/*
 * Decompiled with CFR 0.152.
 */
package com.lly835.bestpay.rest;

import com.lly835.bestpay.rest.ResponseValue;
import com.lly835.bestpay.rest.param.FormParam;
import com.lly835.bestpay.rest.param.HeaderParam;
import com.lly835.bestpay.rest.param.Path;
import com.lly835.bestpay.rest.param.QueryParam;
import com.lly835.bestpay.rest.type.Delete;
import com.lly835.bestpay.rest.type.Get;
import com.lly835.bestpay.rest.type.Post;
import com.lly835.bestpay.rest.type.Put;
import java.util.Objects;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Client {
    protected WebTarget target;
    protected Logger logger = LoggerFactory.getLogger((String)"best-pay");

    @Post
    public ResponseValue post() {
        return this.postForm(null, null, null, null);
    }

    @Post
    public ResponseValue post(Path path) {
        return this.postForm(path, null, null, null);
    }

    @Post
    public ResponseValue post(QueryParam queryParam) {
        return this.postForm(null, queryParam, null, null);
    }

    @Post
    public ResponseValue post(FormParam formParam) {
        return this.postForm(null, null, formParam, null);
    }

    @Post
    public ResponseValue post(HeaderParam headerParam) {
        return this.postForm(null, null, null, headerParam);
    }

    @Post
    public ResponseValue post(Path path, QueryParam queryParam) {
        return this.postForm(path, queryParam, null, null);
    }

    @Post
    public ResponseValue post(Path path, FormParam formParam) {
        return this.postForm(path, null, formParam, null);
    }

    @Post
    public ResponseValue post(Path path, HeaderParam headerParam) {
        return this.postForm(path, null, null, headerParam);
    }

    @Post
    public ResponseValue post(QueryParam queryParam, FormParam formParam) {
        return this.postForm(null, queryParam, formParam, null);
    }

    @Post
    public ResponseValue post(QueryParam queryParam, HeaderParam headerParam) {
        return this.postForm(null, queryParam, null, headerParam);
    }

    @Post
    public ResponseValue post(FormParam formParam, HeaderParam headerParam) {
        return this.postForm(null, null, formParam, headerParam);
    }

    @Post
    public ResponseValue post(QueryParam queryParam, FormParam formParam, HeaderParam headerParam) {
        return this.postForm(null, queryParam, formParam, headerParam);
    }

    @Post
    public ResponseValue post(Path path, FormParam formParam, HeaderParam headerParam) {
        return this.postForm(path, null, formParam, headerParam);
    }

    @Post
    public ResponseValue post(Path path, QueryParam queryParam, HeaderParam headerParam) {
        return this.postForm(path, queryParam, null, headerParam);
    }

    @Post
    public ResponseValue post(Path path, QueryParam queryParam, FormParam formParam) {
        return this.postForm(path, queryParam, formParam, null);
    }

    @Post
    public ResponseValue post(Path path, QueryParam queryParam, FormParam formParam, HeaderParam headerParam) {
        return this.postForm(path, queryParam, formParam, headerParam);
    }

    @Post
    private ResponseValue postForm(Path path, QueryParam queryParam, FormParam formParam, HeaderParam headerParam) {
        WebTarget target = this.target;
        if (path != null) {
            target = path.appendToTarget(this.target);
        }
        if (queryParam != null) {
            target = queryParam.appendToTarget(target);
        }
        Invocation.Builder request = target.request();
        if (headerParam != null) {
            request = headerParam.appendToRequest(request);
        }
        Form form = formParam == null ? new Form() : formParam.toForm();
        try {
            this.logger.debug("Prepare to post to {} with query {}, form {} and header {}.", new Object[]{path, queryParam, formParam, headerParam});
            Response r = (Response)request.post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE), Response.class);
            return this.toResponseValue(r);
        }
        catch (ProcessingException | WebApplicationException e) {
            this.logger.error("Fail to post.", e);
            return ResponseValue.internalServerError();
        }
    }

    @Post
    public ResponseValue postJson(String jsonParam) {
        return this.postJson(null, null, jsonParam, null);
    }

    @Post
    public ResponseValue postJson(Path path, String jsonParam) {
        return this.postJson(path, null, jsonParam, null);
    }

    @Post
    public ResponseValue postJson(QueryParam queryParam, String jsonParam) {
        return this.postJson(null, queryParam, jsonParam, null);
    }

    @Post
    public ResponseValue postJson(String jsonParam, HeaderParam headerParam) {
        return this.postJson(null, null, jsonParam, headerParam);
    }

    @Post
    public ResponseValue postJson(Path path, QueryParam queryParam, String jsonParam) {
        return this.postJson(path, queryParam, jsonParam, null);
    }

    @Post
    public ResponseValue postJson(Path path, String jsonParam, HeaderParam headerParam) {
        return this.postJson(path, null, jsonParam, headerParam);
    }

    @Post
    public ResponseValue postJson(QueryParam queryParam, String jsonParam, HeaderParam headerParam) {
        return this.postJson(null, queryParam, jsonParam, headerParam);
    }

    @Post
    public ResponseValue postJson(Path path, QueryParam queryParam, String jsonParam, HeaderParam headerParam) {
        Objects.requireNonNull(jsonParam, "Json is null.");
        WebTarget target = this.target;
        if (path != null) {
            target = path.appendToTarget(this.target);
        }
        if (queryParam != null) {
            target = queryParam.appendToTarget(target);
        }
        Invocation.Builder request = target.request();
        if (headerParam != null) {
            request = headerParam.appendToRequest(request);
        }
        try {
            this.logger.debug("Prepare to post to {} with query {}, body {} and header {}.", new Object[]{path, queryParam, jsonParam, headerParam});
            Response r = (Response)request.post(Entity.json((Object)jsonParam), Response.class);
            return this.toResponseValue(r);
        }
        catch (ProcessingException | WebApplicationException e) {
            this.logger.error("Fail to post.", e);
            return ResponseValue.internalServerError();
        }
    }

    @Post
    public ResponseValue postXml(String xmlParam) {
        return this.postXml(null, null, xmlParam, null);
    }

    @Post
    public ResponseValue postXml(Path path, String xmlParam) {
        return this.postXml(path, null, xmlParam, null);
    }

    @Post
    public ResponseValue postXml(QueryParam queryParam, String xmlParam) {
        return this.postXml(null, queryParam, xmlParam, null);
    }

    @Post
    public ResponseValue postXml(String xmlParam, HeaderParam headerParam) {
        return this.postXml(null, null, xmlParam, headerParam);
    }

    @Post
    public ResponseValue postXml(Path path, QueryParam queryParam, String xmlParam) {
        return this.postXml(path, queryParam, xmlParam, null);
    }

    @Post
    public ResponseValue postXml(Path path, String xmlParam, HeaderParam headerParam) {
        return this.postXml(path, null, xmlParam, headerParam);
    }

    @Post
    public ResponseValue postXml(QueryParam queryParam, String xmlParam, HeaderParam headerParam) {
        return this.postXml(null, queryParam, xmlParam, headerParam);
    }

    @Post
    public ResponseValue postXml(Path path, QueryParam queryParam, String xmlParam, HeaderParam headerParam) {
        Objects.requireNonNull(xmlParam, "Xml is null.");
        WebTarget target = this.target;
        if (path != null) {
            target = path.appendToTarget(this.target);
        }
        if (queryParam != null) {
            target = queryParam.appendToTarget(target);
        }
        Invocation.Builder request = target.request();
        if (headerParam != null) {
            request = headerParam.appendToRequest(request);
        }
        try {
            this.logger.debug("Prepare to post to {} with query {}, body {} and header {}.", new Object[]{path, queryParam, xmlParam, headerParam});
            Response r = (Response)request.post(Entity.xml((Object)xmlParam), Response.class);
            return this.toResponseValue(r);
        }
        catch (ProcessingException | WebApplicationException e) {
            this.logger.error("Fail to post.", e);
            return ResponseValue.internalServerError();
        }
    }

    @Get
    public ResponseValue get() {
        return this.get(null, null, null);
    }

    @Get
    public ResponseValue get(Path path) {
        return this.get(path, null, null);
    }

    @Get
    public ResponseValue get(QueryParam queryParam) {
        return this.get(null, queryParam, null);
    }

    @Get
    public ResponseValue get(HeaderParam headerParam) {
        return this.get(null, null, headerParam);
    }

    @Get
    public ResponseValue get(Path path, QueryParam queryParam) {
        return this.get(path, queryParam, null);
    }

    @Get
    public ResponseValue get(Path path, HeaderParam headerParam) {
        return this.get(path, null, headerParam);
    }

    @Get
    public ResponseValue get(QueryParam queryParam, HeaderParam headerParam) {
        return this.get(null, queryParam, headerParam);
    }

    @Get
    public ResponseValue get(Path path, QueryParam queryParam, HeaderParam headerParam) {
        WebTarget target = this.target;
        if (path != null) {
            target = path.appendToTarget(this.target);
        }
        if (queryParam != null) {
            target = queryParam.appendToTarget(target);
        }
        Invocation.Builder request = target.request();
        if (headerParam != null) {
            request = headerParam.appendToRequest(request);
        }
        try {
            this.logger.debug("Prepare to get from {} with query {} and header {}.", new Object[]{path, queryParam, headerParam});
            Response r = (Response)request.get(Response.class);
            return this.toResponseValue(r);
        }
        catch (ProcessingException | WebApplicationException e) {
            this.logger.error("Fail to get.", e);
            return ResponseValue.internalServerError();
        }
    }

    @Put
    public ResponseValue put() {
        return this.putForm(null, null, null, null);
    }

    @Put
    public ResponseValue put(Path path) {
        return this.putForm(path, null, null, null);
    }

    @Put
    public ResponseValue put(QueryParam queryParam) {
        return this.putForm(null, queryParam, null, null);
    }

    @Put
    public ResponseValue put(FormParam formParam) {
        return this.putForm(null, null, formParam, null);
    }

    @Put
    public ResponseValue put(HeaderParam headerParam) {
        return this.putForm(null, null, null, headerParam);
    }

    @Put
    public ResponseValue put(Path path, QueryParam queryParam) {
        return this.putForm(path, queryParam, null, null);
    }

    @Put
    public ResponseValue put(Path path, FormParam formParam) {
        return this.putForm(path, null, formParam, null);
    }

    @Put
    public ResponseValue put(Path path, HeaderParam headerParam) {
        return this.putForm(path, null, null, headerParam);
    }

    @Put
    public ResponseValue put(QueryParam queryParam, FormParam formParam) {
        return this.putForm(null, queryParam, formParam, null);
    }

    @Put
    public ResponseValue put(QueryParam queryParam, HeaderParam headerParam) {
        return this.putForm(null, queryParam, null, headerParam);
    }

    @Put
    public ResponseValue put(FormParam formParam, HeaderParam headerParam) {
        return this.putForm(null, null, formParam, headerParam);
    }

    @Put
    public ResponseValue put(QueryParam queryParam, FormParam formParam, HeaderParam headerParam) {
        return this.putForm(null, queryParam, formParam, headerParam);
    }

    @Put
    public ResponseValue put(Path path, FormParam formParam, HeaderParam headerParam) {
        return this.putForm(path, null, formParam, headerParam);
    }

    @Put
    public ResponseValue put(Path path, QueryParam queryParam, HeaderParam headerParam) {
        return this.putForm(path, queryParam, null, headerParam);
    }

    @Put
    public ResponseValue put(Path path, QueryParam queryParam, FormParam formParam) {
        return this.putForm(path, queryParam, formParam, null);
    }

    @Put
    public ResponseValue put(Path path, QueryParam queryParam, FormParam formParam, HeaderParam headerParam) {
        return this.putForm(path, queryParam, formParam, headerParam);
    }

    @Put
    private ResponseValue putForm(Path path, QueryParam queryParam, FormParam formParam, HeaderParam headerParam) {
        WebTarget target = this.target;
        if (path != null) {
            target = path.appendToTarget(this.target);
        }
        if (queryParam != null) {
            target = queryParam.appendToTarget(target);
        }
        Invocation.Builder request = target.request();
        if (headerParam != null) {
            request = headerParam.appendToRequest(request);
        }
        Form form = formParam == null ? new Form() : formParam.toForm();
        try {
            this.logger.debug("Prepare to put to {} with query {}, form {} and header {}.", new Object[]{path, queryParam, formParam, headerParam});
            Response r = (Response)request.put(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE), Response.class);
            return this.toResponseValue(r);
        }
        catch (ProcessingException | WebApplicationException e) {
            this.logger.error("Fail to put.", e);
            return ResponseValue.internalServerError();
        }
    }

    @Put
    public ResponseValue putJson(String jsonParam) {
        return this.putJson(null, null, jsonParam, null);
    }

    @Put
    public ResponseValue putJson(Path path, String jsonParam) {
        return this.putJson(path, null, jsonParam, null);
    }

    @Put
    public ResponseValue putJson(QueryParam queryParam, String jsonParam) {
        return this.putJson(null, queryParam, jsonParam, null);
    }

    @Put
    public ResponseValue putJson(String jsonParam, HeaderParam headerParam) {
        return this.putJson(null, null, jsonParam, headerParam);
    }

    @Put
    public ResponseValue putJson(Path path, QueryParam queryParam, String jsonParam) {
        return this.putJson(path, queryParam, jsonParam, null);
    }

    @Put
    public ResponseValue putJson(Path path, String jsonParam, HeaderParam headerParam) {
        return this.putJson(path, null, jsonParam, headerParam);
    }

    @Put
    public ResponseValue putJson(QueryParam queryParam, String jsonParam, HeaderParam headerParam) {
        return this.putJson(null, queryParam, jsonParam, headerParam);
    }

    @Put
    public ResponseValue putJson(Path path, QueryParam queryParam, String jsonParam, HeaderParam headerParam) {
        Objects.requireNonNull(jsonParam, "Json is null.");
        WebTarget target = this.target;
        if (path != null) {
            target = path.appendToTarget(this.target);
        }
        if (queryParam != null) {
            target = queryParam.appendToTarget(target);
        }
        Invocation.Builder request = target.request();
        if (headerParam != null) {
            request = headerParam.appendToRequest(request);
        }
        try {
            this.logger.debug("Prepare to put to {} with query {}, body {} and header {}.", new Object[]{path, queryParam, jsonParam, headerParam});
            Response r = (Response)request.put(Entity.json((Object)jsonParam), Response.class);
            return this.toResponseValue(r);
        }
        catch (ProcessingException | WebApplicationException e) {
            this.logger.error("Fail to put.", e);
            return ResponseValue.internalServerError();
        }
    }

    @Put
    public ResponseValue putXml(String xmlParam) {
        return this.putXml(null, null, xmlParam, null);
    }

    @Put
    public ResponseValue putXml(Path path, String xmlParam) {
        return this.putXml(path, null, xmlParam, null);
    }

    @Put
    public ResponseValue putXml(QueryParam queryParam, String xmlParam) {
        return this.putXml(null, queryParam, xmlParam, null);
    }

    @Put
    public ResponseValue putXml(String xmlParam, HeaderParam headerParam) {
        return this.putXml(null, null, xmlParam, headerParam);
    }

    @Put
    public ResponseValue putXml(Path path, QueryParam queryParam, String xmlParam) {
        return this.putXml(path, queryParam, xmlParam, null);
    }

    @Put
    public ResponseValue putXml(Path path, String xmlParam, HeaderParam headerParam) {
        return this.putXml(path, null, xmlParam, headerParam);
    }

    @Put
    public ResponseValue putXml(QueryParam queryParam, String xmlParam, HeaderParam headerParam) {
        return this.putXml(null, queryParam, xmlParam, headerParam);
    }

    @Put
    public ResponseValue putXml(Path path, QueryParam queryParam, String xmlParam, HeaderParam headerParam) {
        Objects.requireNonNull(xmlParam, "Xml is null.");
        WebTarget target = this.target;
        if (path != null) {
            target = path.appendToTarget(this.target);
        }
        if (queryParam != null) {
            target = queryParam.appendToTarget(target);
        }
        Invocation.Builder request = target.request();
        if (headerParam != null) {
            request = headerParam.appendToRequest(request);
        }
        try {
            this.logger.debug("Prepare to put to {} with query {}, body {} and header {}.", new Object[]{path, queryParam, xmlParam, headerParam});
            Response r = (Response)request.put(Entity.xml((Object)xmlParam), Response.class);
            return this.toResponseValue(r);
        }
        catch (ProcessingException | WebApplicationException e) {
            this.logger.error("Fail to put.", e);
            return ResponseValue.internalServerError();
        }
    }

    @Delete
    public ResponseValue delete() {
        return this.delete(null, null, null);
    }

    @Delete
    public ResponseValue delete(Path path) {
        return this.delete(path, null, null);
    }

    @Delete
    public ResponseValue delete(QueryParam queryParam) {
        return this.delete(null, queryParam, null);
    }

    @Delete
    public ResponseValue delete(HeaderParam headerParam) {
        return this.delete(null, null, headerParam);
    }

    @Delete
    public ResponseValue delete(Path path, QueryParam queryParam) {
        return this.delete(path, queryParam, null);
    }

    @Delete
    public ResponseValue delete(Path path, HeaderParam headerParam) {
        return this.delete(path, null, headerParam);
    }

    @Delete
    public ResponseValue delete(QueryParam queryParam, HeaderParam headerParam) {
        return this.delete(null, queryParam, headerParam);
    }

    @Delete
    public ResponseValue delete(Path path, QueryParam queryParam, HeaderParam headerParam) {
        WebTarget target = this.target;
        if (path != null) {
            target = path.appendToTarget(this.target);
        }
        if (queryParam != null) {
            target = queryParam.appendToTarget(target);
        }
        Invocation.Builder request = target.request();
        if (headerParam != null) {
            request = headerParam.appendToRequest(request);
        }
        try {
            this.logger.debug("Prepare to delete {} with query {} and header {}.", new Object[]{path, queryParam, headerParam});
            Response r = (Response)request.delete(Response.class);
            return this.toResponseValue(r);
        }
        catch (ProcessingException | WebApplicationException e) {
            this.logger.error("Fail to delete.", e);
            return ResponseValue.internalServerError();
        }
    }

    private ResponseValue toResponseValue(Response response) {
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        this.logger.debug("Response status is {}.", (Object)status.getStatusCode());
        Response.Status.Family family = response.getStatusInfo().getFamily();
        String data = (String)response.readEntity(String.class);
        switch (family) {
            case SUCCESSFUL: {
                if (status == Response.Status.OK) {
                    this.logger.debug("Response data is {}.", (Object)data);
                    return ResponseValue.ok(data);
                }
                if (status == Response.Status.ACCEPTED) {
                    return ResponseValue.accepted();
                }
                if (status == Response.Status.NO_CONTENT) {
                    return ResponseValue.noContent();
                }
                return ResponseValue.internalServerError();
            }
            case CLIENT_ERROR: {
                if (status == Response.Status.BAD_REQUEST) {
                    return ResponseValue.badRequest();
                }
                if (status == Response.Status.FORBIDDEN) {
                    this.logger.debug("Response data is {}.", (Object)data);
                    return ResponseValue.forbidden(data);
                }
                if (status == Response.Status.NOT_FOUND) {
                    return ResponseValue.notFound();
                }
                return ResponseValue.internalServerError();
            }
        }
        return ResponseValue.internalServerError();
    }
}

