/*
 * Decompiled with CFR 0.152.
 */
package com.lly835.bestpay.config;

import com.lly835.bestpay.config.PayConfig;
import com.lly835.bestpay.config.SignType;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;

public class AlipayConfig
extends PayConfig {
    private String appId;
    private String appRSAPrivateKey;
    private String alipayRSAPublicKey;
    private PrivateKey appRSAPrivateKeyObject;
    private PublicKey alipayRSAPublicKeyOBject;
    private SignType signType;

    @Override
    public void check() {
        super.check();
        Objects.requireNonNull(this.appId, "config param 'appId' is null.");
        if (this.appId.length() > 32) {
            throw new IllegalArgumentException("config param 'appId' is incorrect: size exceeds 32.");
        }
        Objects.requireNonNull(this.signType, "config param 'signType' is null.");
        switch (this.signType) {
            case MD5: {
                throw new IllegalArgumentException("config param 'signType' [" + (Object)((Object)this.signType) + "] is not match.");
            }
            case RSA: 
            case RSA2: {
                KeyFactory keyFactory;
                Objects.requireNonNull(this.appRSAPrivateKey, "config param 'appRSAPrivateKey' is null.");
                try {
                    keyFactory = KeyFactory.getInstance("RSA");
                    this.appRSAPrivateKeyObject = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(Base64.decodeBase64((String)this.appRSAPrivateKey)));
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new IllegalArgumentException("config param 'appRSAPrivateKey' is incorrect.", e);
                }
                Objects.requireNonNull(this.alipayRSAPublicKey, "config param 'alipayRSAPublicKey' is null.");
                try {
                    keyFactory = KeyFactory.getInstance("RSA");
                    this.alipayRSAPublicKeyOBject = keyFactory.generatePublic(new X509EncodedKeySpec(Base64.decodeBase64((String)this.alipayRSAPublicKey)));
                    break;
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new IllegalArgumentException("config param 'alipayRSAPublicKey' is incorrect.", e);
                }
            }
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public PrivateKey getAppRSAPrivateKeyObject() {
        return this.appRSAPrivateKeyObject;
    }

    public PublicKey getAlipayRSAPublicKeyOBject() {
        return this.alipayRSAPublicKeyOBject;
    }

    public SignType getSignType() {
        return this.signType;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppRSAPrivateKey(String appRSAPrivateKey) {
        this.appRSAPrivateKey = appRSAPrivateKey;
    }

    public void setAlipayRSAPublicKey(String alipayRSAPublicKey) {
        this.alipayRSAPublicKey = alipayRSAPublicKey;
    }

    public void setSignType(SignType signType) {
        this.signType = signType;
    }

    public String getInputCharset() {
        return "utf-8";
    }
}

