/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.message.service;

import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.message.dto.AlarmControlDTO;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class AlarmControlHandler {
    private final Map<String, ReentrantLock> threadPoolLock = new HashMap<String, ReentrantLock>();
    private final Map<String, Cache<String, String>> threadPoolAlarmCache = new ConcurrentHashMap<String, Cache<String, String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSendAlarm(AlarmControlDTO alarmControl) {
        String threadPoolKey = alarmControl.buildPk();
        Cache<String, String> cache = this.threadPoolAlarmCache.get(threadPoolKey);
        if (cache == null) {
            return false;
        }
        String pkId = (String)cache.getIfPresent((Object)alarmControl.getTypeEnum().name());
        if (StringUtil.isBlank((CharSequence)pkId)) {
            ReentrantLock lock = this.threadPoolLock.get(threadPoolKey);
            lock.lock();
            try {
                pkId = (String)cache.getIfPresent((Object)alarmControl.getTypeEnum().name());
                if (StringUtil.isBlank((CharSequence)pkId)) {
                    cache.put((Object)alarmControl.getTypeEnum().name(), (Object)"-");
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }

    public void initCacheAndLock(String threadPoolId, String platform, Integer interval) {
        String threadPoolKey = threadPoolId + "+" + platform;
        Cache cache = Caffeine.newBuilder().expireAfterWrite((long)interval.intValue(), TimeUnit.MINUTES).build();
        this.threadPoolAlarmCache.put(threadPoolKey, (Cache<String, String>)cache);
        ReentrantLock reentrantLock = new ReentrantLock();
        this.threadPoolLock.put(threadPoolKey, reentrantLock);
    }
}

