/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.service;

import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseService;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Permission;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Scope;
import cn.herodotus.engine.oauth2.management.repository.OAuth2ScopeRepository;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class OAuth2ScopeService
extends BaseService<OAuth2Scope, String> {
    private final OAuth2ScopeRepository oauthScopesRepository;

    public OAuth2ScopeService(OAuth2ScopeRepository oauthScopesRepository) {
        this.oauthScopesRepository = oauthScopesRepository;
    }

    public BaseRepository<OAuth2Scope, String> getRepository() {
        return this.oauthScopesRepository;
    }

    public OAuth2Scope assigned(String scopeId, Set<OAuth2Permission> permissions) {
        OAuth2Scope oldScope = (OAuth2Scope)this.findById((Serializable)((Object)scopeId));
        oldScope.setPermissions(permissions);
        return (OAuth2Scope)this.saveAndFlush((Entity)oldScope);
    }

    public OAuth2Scope findByScopeCode(String scopeCode) {
        return this.oauthScopesRepository.findByScopeCode(scopeCode);
    }

    public List<OAuth2Scope> findByScopeCodeIn(List<String> scopeCodes) {
        return this.oauthScopesRepository.findByScopeCodeIn(scopeCodes);
    }
}

