/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.response;

import cn.herodotus.engine.oauth2.management.service.OAuth2DeviceService;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.oidc.OidcClientRegistration;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcClientRegistrationAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.oidc.http.converter.OidcClientRegistrationHttpMessageConverter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

public class OidcClientRegistrationResponseHandler
implements AuthenticationSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(OidcClientRegistrationResponseHandler.class);
    private final OAuth2DeviceService deviceService;
    private final HttpMessageConverter<OidcClientRegistration> clientRegistrationHttpMessageConverter = new OidcClientRegistrationHttpMessageConverter();

    public OidcClientRegistrationResponseHandler(OAuth2DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        OidcClientRegistrationAuthenticationToken clientRegistrationAuthenticationToken = (OidcClientRegistrationAuthenticationToken)authentication;
        OidcClientRegistration clientRegistration = clientRegistrationAuthenticationToken.getClientRegistration();
        boolean success = this.deviceService.sync(clientRegistration);
        if (success) {
            log.info("[Herodotus] |- Sync oidcClientRegistration to device succeed.");
        } else {
            log.warn("[Herodotus] |- Sync oidcClientRegistration to device failed!");
        }
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        if (HttpMethod.POST.name().equals(request.getMethod())) {
            httpResponse.setStatusCode((HttpStatusCode)HttpStatus.CREATED);
        } else {
            httpResponse.setStatusCode((HttpStatusCode)HttpStatus.OK);
        }
        this.clientRegistrationHttpMessageConverter.write((Object)clientRegistration, null, (HttpOutputMessage)httpResponse);
    }
}

