/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.definition;

import cn.herodotus.engine.oauth2.data.jpa.definition.converter.RegisteredClientConverter;
import cn.herodotus.engine.oauth2.management.definition.AbstractOAuth2RegisteredClient;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Scope;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.OAuth2TokenFormat;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.util.StringUtils;

public abstract class AbstractOAuth2RegisteredClientConverter<T extends AbstractOAuth2RegisteredClient>
implements RegisteredClientConverter<T> {
    public Set<String> getScopes(T details) {
        Set<OAuth2Scope> clientScopes = ((AbstractOAuth2RegisteredClient)((Object)details)).getScopes();
        return clientScopes.stream().map(OAuth2Scope::getScopeCode).collect(Collectors.toSet());
    }

    public ClientSettings getClientSettings(T details) {
        SignatureAlgorithm jwsAlgorithm;
        ClientSettings.Builder clientSettingsBuilder = ClientSettings.builder();
        clientSettingsBuilder.requireAuthorizationConsent(((AbstractOAuth2RegisteredClient)((Object)details)).getRequireAuthorizationConsent().booleanValue());
        clientSettingsBuilder.requireProofKey(((AbstractOAuth2RegisteredClient)((Object)details)).getRequireProofKey().booleanValue());
        if (StringUtils.hasText((String)((AbstractOAuth2RegisteredClient)((Object)details)).getJwkSetUrl())) {
            clientSettingsBuilder.jwkSetUrl(((AbstractOAuth2RegisteredClient)((Object)details)).getJwkSetUrl());
        }
        if (ObjectUtils.isNotEmpty((Object)((AbstractOAuth2RegisteredClient)((Object)details)).getAuthenticationSigningAlgorithm()) && ObjectUtils.isNotEmpty((Object)(jwsAlgorithm = SignatureAlgorithm.from((String)((AbstractOAuth2RegisteredClient)((Object)details)).getAuthenticationSigningAlgorithm().name())))) {
            clientSettingsBuilder.tokenEndpointAuthenticationSigningAlgorithm((JwsAlgorithm)jwsAlgorithm);
        }
        return clientSettingsBuilder.build();
    }

    public TokenSettings getTokenSettings(T details) {
        SignatureAlgorithm signatureAlgorithm;
        TokenSettings.Builder tokenSettingsBuilder = TokenSettings.builder();
        tokenSettingsBuilder.authorizationCodeTimeToLive(((AbstractOAuth2RegisteredClient)((Object)details)).getAuthorizationCodeValidity());
        tokenSettingsBuilder.deviceCodeTimeToLive(((AbstractOAuth2RegisteredClient)((Object)details)).getDeviceCodeValidity());
        tokenSettingsBuilder.accessTokenTimeToLive(((AbstractOAuth2RegisteredClient)((Object)details)).getAccessTokenValidity());
        tokenSettingsBuilder.refreshTokenTimeToLive(((AbstractOAuth2RegisteredClient)((Object)details)).getRefreshTokenValidity());
        tokenSettingsBuilder.reuseRefreshTokens(((AbstractOAuth2RegisteredClient)((Object)details)).getReuseRefreshTokens().booleanValue());
        tokenSettingsBuilder.accessTokenFormat(new OAuth2TokenFormat(((AbstractOAuth2RegisteredClient)((Object)details)).getAccessTokenFormat().getFormat()));
        if (ObjectUtils.isNotEmpty((Object)((AbstractOAuth2RegisteredClient)((Object)details)).getIdTokenSignatureAlgorithm()) && ObjectUtils.isNotEmpty((Object)(signatureAlgorithm = SignatureAlgorithm.from((String)((AbstractOAuth2RegisteredClient)((Object)details)).getIdTokenSignatureAlgorithm().name())))) {
            tokenSettingsBuilder.idTokenSignatureAlgorithm(signatureAlgorithm);
        }
        return tokenSettingsBuilder.build();
    }
}

