/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.stp;

import cn.dev33.satoken.SaTokenManager;
import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.util.SaCookieUtil;
import cn.dev33.satoken.util.SpringMvcUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class StpLogic {
    public String loginKey = "";

    public StpLogic(String loginKey) {
        this.loginKey = loginKey;
    }

    public String randomTokenValue() {
        return UUID.randomUUID().toString();
    }

    public String getTokenValue() {
        String tokenValue;
        Cookie cookie;
        String tokenValue2;
        HttpServletRequest request = SpringMvcUtil.getRequest();
        SaTokenConfig config = SaTokenManager.getConfig();
        String keyTokenName = this.getKeyTokenName();
        if (request.getAttribute("JUST_CREATED_SAVE_KEY_") != null) {
            return String.valueOf(request.getAttribute("JUST_CREATED_SAVE_KEY_"));
        }
        if (config.getIsReadBody().booleanValue() && (tokenValue2 = request.getParameter(keyTokenName)) != null) {
            return tokenValue2;
        }
        if (config.getIsReadHead().booleanValue() && (tokenValue2 = request.getHeader(keyTokenName)) != null) {
            return tokenValue2;
        }
        if (config.getIsReadCookie().booleanValue() && (cookie = SaCookieUtil.getCookie(request, keyTokenName)) != null && (tokenValue = cookie.getValue()) != null) {
            return tokenValue;
        }
        return null;
    }

    public String getTokenValueByLoginId(Object loginId) {
        return SaTokenManager.getDao().getValue(this.getKeyLoginId(loginId));
    }

    public Map<String, String> getTokenInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tokenName", this.getKeyTokenName());
        map.put("tokenValue", this.getTokenValue());
        return map;
    }

    public void setLoginId(Object loginId) {
        HttpServletRequest request = SpringMvcUtil.getRequest();
        SaTokenConfig config = SaTokenManager.getConfig();
        SaTokenDao dao = SaTokenManager.getDao();
        String tokenValue = this.getTokenValueByLoginId(loginId);
        if (tokenValue == null) {
            tokenValue = this.randomTokenValue();
        } else if (!config.getIsShare().booleanValue()) {
            dao.delKey(this.getKeyTokenValue(tokenValue));
            tokenValue = this.randomTokenValue();
        }
        dao.setValue(this.getKeyTokenValue(tokenValue), String.valueOf(loginId), config.getTimeout());
        dao.setValue(this.getKeyLoginId(loginId), tokenValue, config.getTimeout());
        request.setAttribute("JUST_CREATED_SAVE_KEY_", (Object)tokenValue);
        if (config.getIsReadCookie().booleanValue()) {
            SaCookieUtil.addCookie(SpringMvcUtil.getResponse(), this.getKeyTokenName(), tokenValue, "/", (int)config.getTimeout());
        }
    }

    public void logout() {
        Object loginId = this.getLoginIdDefaultNull();
        if (loginId != null) {
            this.logoutByLoginId(loginId);
            if (SaTokenManager.getConfig().getIsReadCookie().booleanValue()) {
                SaCookieUtil.delCookie(SpringMvcUtil.getRequest(), SpringMvcUtil.getResponse(), this.getKeyTokenName());
            }
        }
    }

    public void logoutByLoginId(Object loginId) {
        String tokenValue = this.getTokenValueByLoginId(loginId);
        if (tokenValue == null) {
            return;
        }
        SaTokenManager.getDao().delKey(this.getKeyTokenValue(tokenValue));
        SaTokenManager.getDao().delKey(this.getKeyLoginId(loginId));
        SaTokenManager.getDao().delKey(this.getKeySession(loginId));
    }

    public boolean isLogin() {
        return this.getLoginIdDefaultNull() != null;
    }

    public void checkLogin() {
        this.getLoginId();
    }

    public Object getLoginId() {
        Object loginId = this.getLoginIdDefaultNull();
        if (loginId == null) {
            throw new NotLoginException(this.loginKey);
        }
        return loginId;
    }

    public <T> T getLoginId(T defaultValue) {
        Object loginId = this.getLoginIdDefaultNull();
        if (loginId == null) {
            return defaultValue;
        }
        if (defaultValue instanceof Integer) {
            return (T)Integer.valueOf(loginId.toString());
        }
        if (defaultValue instanceof Long) {
            return (T)Long.valueOf(loginId.toString());
        }
        if (defaultValue instanceof String) {
            return (T)loginId.toString();
        }
        return (T)loginId;
    }

    public Object getLoginIdDefaultNull() {
        String loginId;
        String tokenValue = this.getTokenValue();
        if (tokenValue != null && (loginId = SaTokenManager.getDao().getValue(this.getKeyTokenValue(tokenValue))) != null) {
            return loginId;
        }
        return null;
    }

    public String getLoginIdAsString() {
        return String.valueOf(this.getLoginId());
    }

    public int getLoginIdAsInt() {
        return Integer.valueOf(String.valueOf(this.getLoginId()));
    }

    public long getLoginIdAsLong() {
        return Long.valueOf(String.valueOf(this.getLoginId()));
    }

    public Object getLoginIdByToken(String tokenValue) {
        String loginId;
        if (tokenValue != null && (loginId = SaTokenManager.getDao().getValue(this.getKeyTokenValue(tokenValue))) != null) {
            return loginId;
        }
        return null;
    }

    protected SaSession getSessionBySessionId(String sessionId, boolean isCreate) {
        SaSession session = SaTokenManager.getDao().getSaSession(sessionId);
        if (session == null && isCreate) {
            session = new SaSession(sessionId);
            SaTokenManager.getDao().saveSaSession(session, SaTokenManager.getConfig().getTimeout());
        }
        return session;
    }

    public SaSession getSessionByLoginId(Object loginId, boolean isCreate) {
        return this.getSessionBySessionId(this.getKeySession(loginId), isCreate);
    }

    public SaSession getSessionByLoginId(Object loginId) {
        return this.getSessionByLoginId(this.getKeySession(loginId), false);
    }

    public SaSession getSession() {
        return this.getSessionBySessionId(this.getKeySession(this.getLoginId()), true);
    }

    public boolean hasPermission(Object loginId, Object pcode) {
        List<Object> pcodeList = SaTokenManager.getStp().getPermissionCodeList(loginId, this.loginKey);
        return pcodeList != null && pcodeList.contains(pcode);
    }

    public boolean hasPermission(Object pcode) {
        return this.hasPermission(this.getLoginId(), pcode);
    }

    public void checkPermission(Object pcode) {
        if (!this.hasPermission(pcode)) {
            throw new NotPermissionException(pcode, this.loginKey);
        }
    }

    public void checkPermissionAnd(Object ... pcodeArray) {
        Object loginId = this.getLoginId();
        List<Object> pcodeList = SaTokenManager.getStp().getPermissionCodeList(loginId, this.loginKey);
        for (Object pcode : pcodeArray) {
            if (pcodeList.contains(pcode)) continue;
            throw new NotPermissionException(pcode, this.loginKey);
        }
    }

    public void checkPermissionOr(Object ... pcodeArray) {
        Object loginId = this.getLoginId();
        List<Object> pcodeList = SaTokenManager.getStp().getPermissionCodeList(loginId, this.loginKey);
        for (Object pcode : pcodeArray) {
            if (!pcodeList.contains(pcode)) continue;
            return;
        }
        if (pcodeArray.length > 0) {
            throw new NotPermissionException(pcodeArray[0], this.loginKey);
        }
    }

    public String getKeyTokenName() {
        return SaTokenManager.getConfig().getTokenName();
    }

    public String getKeyTokenValue(String tokenValue) {
        return SaTokenManager.getConfig().getTokenName() + ":" + this.loginKey + ":token:" + tokenValue;
    }

    public String getKeyLoginId(Object loginId) {
        return SaTokenManager.getConfig().getTokenName() + ":" + this.loginKey + ":id:" + loginId;
    }

    public String getKeySession(Object loginId) {
        return SaTokenManager.getConfig().getTokenName() + ":" + this.loginKey + ":session:" + loginId;
    }
}

