/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.annotation;

import cn.dev33.satoken.annotation.SaCheckLogin;
import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.StpUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class SaCheckInterceptor
implements HandlerInterceptor {
    public StpLogic stpLogic = null;

    public SaCheckInterceptor() {
        this(StpUtil.stpLogic);
    }

    public SaCheckInterceptor(StpLogic stpLogic) {
        this.stpLogic = stpLogic;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        SaCheckPermission scp;
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod method = (HandlerMethod)handler;
        if (method.hasMethodAnnotation(SaCheckLogin.class) || method.getBeanType().isAnnotationPresent(SaCheckLogin.class)) {
            this.stpLogic.checkLogin();
        }
        if ((scp = (SaCheckPermission)method.getMethodAnnotation(SaCheckPermission.class)) == null) {
            scp = method.getBeanType().getAnnotation(SaCheckPermission.class);
        }
        if (scp == null) {
            return true;
        }
        Object[] codeArray = this.concatAbc(scp.value(), scp.valueInt(), scp.valueLong());
        if (scp.isAnd()) {
            this.stpLogic.checkPermissionAnd(codeArray);
        } else {
            this.stpLogic.checkPermissionOr(codeArray);
        }
        return true;
    }

    private Object[] concatAbc(String[] a, int[] b, long[] c) {
        int i;
        Object[] d = new Object[a.length + b.length + c.length];
        for (i = 0; i < a.length; ++i) {
            d[i] = a[i];
        }
        for (i = 0; i < b.length; ++i) {
            d[a.length + i] = b[i];
        }
        for (i = 0; i < c.length; ++i) {
            d[a.length + b.length + i] = c[i];
        }
        return d;
    }
}

