/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso.template;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.sign.SaSignManager;
import cn.dev33.satoken.sign.config.SaSignConfig;
import cn.dev33.satoken.sign.template.SaSignTemplate;
import cn.dev33.satoken.sso.SaSsoManager;
import cn.dev33.satoken.sso.config.SaSsoClientModel;
import cn.dev33.satoken.sso.config.SaSsoServerConfig;
import cn.dev33.satoken.sso.exception.SaSsoException;
import cn.dev33.satoken.sso.message.SaSsoMessage;
import cn.dev33.satoken.sso.message.handle.server.SaSsoMessageCheckTicketHandle;
import cn.dev33.satoken.sso.message.handle.server.SaSsoMessageSignoutHandle;
import cn.dev33.satoken.sso.model.SaSsoClientInfo;
import cn.dev33.satoken.sso.model.TicketModel;
import cn.dev33.satoken.sso.strategy.SaSsoServerStrategy;
import cn.dev33.satoken.sso.template.SaSsoTemplate;
import cn.dev33.satoken.stp.parameter.SaLogoutParameter;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SaSsoServerTemplate
extends SaSsoTemplate {
    public SaSsoServerStrategy strategy = new SaSsoServerStrategy();

    public SaSsoServerTemplate() {
        this.messageHolder.addHandle(new SaSsoMessageCheckTicketHandle());
        this.messageHolder.addHandle(new SaSsoMessageSignoutHandle());
    }

    public void saveTicket(TicketModel ticketModel) {
        long ticketTimeout = this.getServerConfig().getTicketTimeout();
        SaManager.getSaTokenDao().setObject(this.splicingTicketModelSaveKey(ticketModel.getTicket()), (Object)ticketModel, ticketTimeout);
    }

    public void deleteTicket(String ticket) {
        if (ticket == null) {
            return;
        }
        SaManager.getSaTokenDao().deleteObject(this.splicingTicketModelSaveKey(ticket));
    }

    public TicketModel createTicket(String client, Object loginId, String tokenValue) {
        TicketModel ticketModel = new TicketModel();
        ticketModel.setTicket(this.randomTicket(loginId));
        ticketModel.setClient(client);
        ticketModel.setLoginId(loginId);
        ticketModel.setTokenValue(tokenValue);
        return ticketModel;
    }

    public String createTicketAndSave(String client, Object loginId, String tokenValue) {
        TicketModel ticketModel = this.createTicket(client, loginId, tokenValue);
        this.saveTicket(ticketModel);
        this.saveTicketIndex(client, loginId, ticketModel.getTicket());
        return ticketModel.getTicket();
    }

    public String randomTicket(Object loginId) {
        return SaFoxUtil.getRandomString((int)64);
    }

    public TicketModel getTicket(String ticket) {
        if (SaFoxUtil.isEmpty((Object)ticket)) {
            return null;
        }
        return (TicketModel)SaManager.getSaTokenDao().getObject(this.splicingTicketModelSaveKey(ticket), TicketModel.class);
    }

    public Object getLoginId(String ticket) {
        TicketModel ticketModel = this.getTicket(ticket);
        if (ticketModel == null) {
            return null;
        }
        return ticketModel.getLoginId();
    }

    public <T> T getLoginId(String ticket, Class<T> cs) {
        return (T)SaFoxUtil.getValueByType((Object)this.getLoginId(ticket), cs);
    }

    public TicketModel checkTicket(String ticket) {
        TicketModel ticketModel = this.getTicket(ticket);
        if (ticketModel == null) {
            throw new SaSsoException("\u65e0\u6548 ticket : " + ticket).setCode(30004);
        }
        return ticketModel;
    }

    public TicketModel checkTicketParamAndDelete(String ticket) {
        return this.checkTicketParamAndDelete(ticket, "*");
    }

    public TicketModel checkTicketParamAndDelete(String ticket, String client) {
        TicketModel ticketModel = this.checkTicket(ticket);
        String ticketClient = ticketModel.getClient();
        if (!("*".equals(client) || SaFoxUtil.isEmpty((Object)client) && SaFoxUtil.isEmpty((Object)ticketClient) || !SaFoxUtil.notEquals((Object)client, (Object)ticketClient))) {
            throw new SaSsoException("\u8be5 ticket \u4e0d\u5c5e\u4e8e client=" + client + ", ticket \u503c: " + ticket).setCode(30011);
        }
        this.deleteTicket(ticket);
        this.deleteTicketIndex(client, ticketModel.getLoginId());
        return ticketModel;
    }

    public void saveTicketIndex(String client, Object loginId, String ticket) {
        long ticketTimeout = this.getServerConfig().getTicketTimeout();
        SaManager.getSaTokenDao().set(this.splicingTicketIndexKey(client, loginId), String.valueOf(ticket), ticketTimeout);
    }

    public void deleteTicketIndex(String client, Object loginId) {
        if (loginId == null) {
            return;
        }
        SaManager.getSaTokenDao().delete(this.splicingTicketIndexKey(client, loginId));
    }

    public String getTicketValue(String client, Object loginId) {
        if (loginId == null) {
            return null;
        }
        return SaManager.getSaTokenDao().get(this.splicingTicketIndexKey(client, loginId));
    }

    public List<SaSsoClientModel> getClients() {
        return new ArrayList<SaSsoClientModel>(this.getServerConfig().getClients().values());
    }

    public SaSsoClientModel getClient(String client) {
        return this.getServerConfig().getClients().get(client);
    }

    public SaSsoClientModel getClientNotNull(String client) {
        if (SaFoxUtil.isEmpty((Object)client)) {
            if (this.getConfigOfAllowAnonClient()) {
                return this.getAnonClient();
            }
            throw new SaSsoException("client \u6807\u8bc6\u4e0d\u53ef\u4e3a\u7a7a");
        }
        SaSsoClientModel scm = this.getClient(client);
        if (scm == null) {
            throw new SaSsoException("\u672a\u80fd\u83b7\u53d6\u5e94\u7528\u4fe1\u606f\uff0cclient=" + client).setCode(30013);
        }
        return scm;
    }

    public boolean getConfigOfAllowAnonClient() {
        return this.getServerConfig().getAllowAnonClient();
    }

    public SaSsoClientModel getAnonClient() {
        SaSsoServerConfig serverConfig = this.getServerConfig();
        SaSsoClientModel scm = new SaSsoClientModel();
        scm.setAllowUrl(serverConfig.getAllowUrl());
        scm.setIsSlo(serverConfig.getIsSlo());
        scm.setSecretKey(serverConfig.getSecretKey());
        if (SaFoxUtil.isEmpty((Object)scm.getSecretKey())) {
            scm.setSecretKey(SaSignManager.getSaSignTemplate().getSignConfigOrGlobal().getSecretKey());
        }
        return scm;
    }

    public List<SaSsoClientModel> getNeedPushClients() {
        ArrayList<SaSsoClientModel> list = new ArrayList<SaSsoClientModel>();
        List<SaSsoClientModel> clients = this.getClients();
        for (SaSsoClientModel scm : clients) {
            if (!scm.getIsPush().booleanValue()) continue;
            list.add(scm);
        }
        return list;
    }

    public String buildRedirectUrl(String client, String redirect, Object loginId, String tokenValue) {
        this.checkRedirectUrl(client, redirect);
        this.deleteTicket(this.getTicketValue(client, loginId));
        String ticket = this.createTicketAndSave(client, loginId, tokenValue);
        return SaFoxUtil.joinParam((String)this.encodeBackParam(redirect), (String)this.paramName.ticket, (Object)ticket);
    }

    public String encodeBackParam(String url) {
        int index = url.indexOf("?" + this.paramName.back + "=");
        if (index == -1 && (index = url.indexOf("&" + this.paramName.back + "=")) == -1) {
            return url;
        }
        int length = this.paramName.back.length() + 2;
        String back = url.substring(index + length);
        back = SaFoxUtil.encodeUrl((String)back);
        url = url.substring(0, index + length) + back;
        return url;
    }

    public void checkRedirectUrl(String client, String url) {
        if (!SaFoxUtil.isUrl((String)url)) {
            throw new SaSsoException("\u65e0\u6548redirect\uff1a" + url).setCode(30001);
        }
        int qIndex = url.indexOf("?");
        if (qIndex != -1) {
            url = url.substring(0, qIndex);
        }
        if (url.contains("@")) {
            throw new SaSsoException("\u65e0\u6548redirect\uff08\u4e0d\u5141\u8bb8\u51fa\u73b0@\u5b57\u7b26\uff09\uff1a" + url).setCode(30001);
        }
        String allowUrlString = this.getClientNotNull(client).getAllowUrl();
        List<String> allowUrlList = Arrays.asList(allowUrlString.replaceAll(" ", "").split(","));
        this.checkAllowUrlList(allowUrlList);
        if (!((Boolean)SaStrategy.instance.hasElement.apply(allowUrlList, (Object)url)).booleanValue()) {
            throw new SaSsoException("\u975e\u6cd5redirect\uff1a" + url).setCode(30002);
        }
    }

    public void checkAllowUrlList(List<String> allowUrlList) {
        SaSsoServerTemplate.checkAllowUrlListStaticMethod(allowUrlList);
    }

    public static void checkAllowUrlListStaticMethod(List<String> allowUrlList) {
        for (String url : allowUrlList) {
            int index = url.indexOf("*");
            if (index == -1 || index == url.length() - 1) continue;
            throw new SaSsoException("\u65e0\u6548\u7684 allow-url \u914d\u7f6e\uff08*\u901a\u914d\u7b26\u53ea\u5141\u8bb8\u51fa\u73b0\u5728\u6700\u540e\u4e00\u4f4d\uff09\uff1a" + url).setCode(30015);
        }
    }

    public void registerSloCallbackUrl(Object loginId, String client, String sloCallbackUrl) {
        if (SaFoxUtil.isEmpty((Object)loginId)) {
            return;
        }
        SaSession session = this.getStpLogicOrGlobal().getSessionByLoginId(loginId);
        List scmList = (List)session.get("SSO_CLIENT_MODEL_LIST_KEY_", ArrayList::new);
        SaSsoClientInfo scm = new SaSsoClientInfo(client, sloCallbackUrl, this.calcNextIndex(scmList));
        scmList.add(scm);
        int maxRegClient = this.getServerConfig().maxRegClient;
        if (maxRegClient != -1) {
            while (scmList.size() > maxRegClient) {
                SaSsoClientInfo removeScm = (SaSsoClientInfo)scmList.remove(0);
                this.strategy.asyncRun.run(() -> this.notifyClientLogout(loginId, null, removeScm, true, true));
            }
        }
        session.set("SSO_CLIENT_MODEL_LIST_KEY_", (Object)scmList);
    }

    public int calcNextIndex(List<SaSsoClientInfo> scmList) {
        if (scmList == null || scmList.isEmpty()) {
            return 0;
        }
        int maxIndex = scmList.get((int)(scmList.size() - 1)).index;
        if (maxIndex == Integer.MAX_VALUE) {
            return 0;
        }
        return ++maxIndex;
    }

    public void ssoLogout(Object loginId) {
        this.ssoLogout(loginId, this.getStpLogicOrGlobal().createSaLogoutParameter(), null);
    }

    public void ssoLogout(Object loginId, SaLogoutParameter logoutParameter, String ignoreClient) {
        this.pushToAllClientByLogoutCall(loginId, logoutParameter, ignoreClient);
        SaSession session = this.getStpLogicOrGlobal().getSessionByLoginId(loginId, false);
        if (session == null) {
            return;
        }
        List scmList = (List)session.get("SSO_CLIENT_MODEL_LIST_KEY_", ArrayList::new);
        scmList.forEach(scm -> this.strategy.asyncRun.run(() -> this.notifyClientLogout(loginId, logoutParameter.getDeviceId(), (SaSsoClientInfo)scm, false, false)));
        this.getStpLogicOrGlobal().logout(loginId, logoutParameter);
    }

    public String notifyClientLogout(Object loginId, String deviceId, SaSsoClientInfo scm, boolean autoLogout, boolean isPushWork) {
        if (scm == null || scm.mode != 3) {
            return null;
        }
        String sloCallUrl = scm.getSloCallbackUrl();
        if (SaFoxUtil.isEmpty((Object)sloCallUrl)) {
            if (isPushWork && SaFoxUtil.isNotEmpty((Object)scm.getClient())) {
                SaSsoClientModel client = this.getClient(scm.getClient());
                return this.pushToClientByLogoutCall(client, loginId, true, this.getStpLogicOrGlobal().createSaLogoutParameter());
            }
            return null;
        }
        TreeMap<String, Object> paramsMap = new TreeMap<String, Object>();
        paramsMap.put(this.paramName.client, scm.getClient());
        paramsMap.put(this.paramName.loginId, loginId);
        paramsMap.put(this.paramName.deviceId, deviceId);
        paramsMap.put(this.paramName.autoLogout, autoLogout);
        String signParamsStr = this.getSignTemplate(scm.getClient()).addSignParamsAndJoin(paramsMap);
        String finalUrl = SaFoxUtil.joinParam((String)sloCallUrl, (String)signParamsStr);
        return (String)this.strategy.sendRequest.apply(finalUrl);
    }

    public String pushMessage(SaSsoClientModel clientModel, SaSsoMessage message) {
        message.checkType();
        String noticeUrl = clientModel.splicingPushUrl();
        String paramsStr = this.getSignTemplate(clientModel.getClient()).addSignParamsAndJoin((Map)message);
        String finalUrl = SaFoxUtil.joinParam((String)noticeUrl, (String)paramsStr);
        return (String)this.strategy.sendRequest.apply(finalUrl);
    }

    public SaResult pushMessageAsSaResult(SaSsoClientModel clientModel, SaSsoMessage message) {
        String res = this.pushMessage(clientModel, message);
        Map map = SaManager.getSaJsonTemplate().jsonToMap(res);
        return new SaResult(map);
    }

    public String pushMessage(String client, SaSsoMessage message) {
        return this.pushMessage(this.getClientNotNull(client), message);
    }

    public SaResult pushMessageAsSaResult(String client, SaSsoMessage message) {
        String res = this.pushMessage(client, message);
        Map map = SaManager.getSaJsonTemplate().jsonToMap(res);
        return new SaResult(map);
    }

    public void pushToAllClient(SaSsoMessage message) {
        this.pushToAllClient(message, null);
    }

    public void pushToAllClient(SaSsoMessage message, String ignoreClient) {
        List<SaSsoClientModel> needPushClients = this.getNeedPushClients();
        for (SaSsoClientModel client : needPushClients) {
            if (SaFoxUtil.isNotEmpty((Object)ignoreClient) && ignoreClient.equals(client.getClient())) continue;
            this.strategy.asyncRun.run(() -> this.pushMessage(client, message));
        }
    }

    public void pushToAllClientByLogoutCall(Object loginId, SaLogoutParameter logoutParameter, String ignoreClient) {
        List<SaSsoClientModel> npClients = this.getNeedPushClients();
        for (SaSsoClientModel client : npClients) {
            if (SaFoxUtil.isNotEmpty((Object)ignoreClient) && ignoreClient.equals(client.getClient()) || !client.getIsSlo().booleanValue()) continue;
            this.strategy.asyncRun.run(() -> this.pushToClientByLogoutCall(client, loginId, false, logoutParameter));
        }
    }

    public String pushToClientByLogoutCall(SaSsoClientModel client, Object loginId, boolean autoLogout, SaLogoutParameter logoutParameter) {
        SaSsoMessage message = new SaSsoMessage();
        message.setType("logoutCall");
        message.set(this.paramName.loginId, loginId);
        message.set(this.paramName.autoLogout, autoLogout);
        message.set(this.paramName.deviceId, logoutParameter.getDeviceId());
        return this.pushMessage(client, message);
    }

    public SaSsoServerConfig getServerConfig() {
        return SaSsoManager.getServerConfig();
    }

    public SaSignTemplate getSignTemplate(String client) {
        SaSignConfig signConfig = SaSignManager.getSaSignTemplate().getSignConfigOrGlobal().copy();
        SaSsoClientModel clientModel = this.getClientNotNull(client);
        String secretKey = clientModel.getSecretKey();
        if (SaFoxUtil.isEmpty((Object)secretKey) && SaFoxUtil.isNotEmpty((Object)client)) {
            secretKey = this.getServerConfig().getSecretKey();
        }
        if (SaFoxUtil.isEmpty((Object)secretKey)) {
            secretKey = signConfig.getSecretKey();
        }
        signConfig.setSecretKey(secretKey);
        return new SaSignTemplate(signConfig);
    }

    public String splicingTicketModelSaveKey(String ticket) {
        return this.getStpLogicOrGlobal().getConfigOrGlobal().getTokenName() + ":ticket:" + ticket;
    }

    public String splicingTicketIndexKey(String client, Object id) {
        if (SaFoxUtil.isEmpty((Object)client) || "*".equals(client)) {
            client = "anon";
        }
        return this.getStpLogicOrGlobal().getConfigOrGlobal().getTokenName() + ":ticket-index:" + client + ":" + id;
    }
}

