/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.NoAutoStart;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.Loader;

public class ClassUtil {
    static final String[] AUTHORIZED_PREFIXES = new String[]{"ch.qos.logback", "chapters.appenders", "chapters.layouts", "chapters.filters"};

    public static boolean classImplements(Class<?> aClass, Class<?> otherClass) {
        return otherClass.isAssignableFrom(aClass);
    }

    public static boolean shouldBeStarted(Class<?> aClass) {
        if (ClassUtil.classImplements(aClass, LifeCycle.class)) {
            return ClassUtil.notMarkedWithNoAutoStart(aClass);
        }
        return false;
    }

    public static boolean notMarkedWithNoAutoStart(Class<?> aClass) {
        NoAutoStart a = aClass.getAnnotation(NoAutoStart.class);
        return a == null;
    }

    public static boolean isAuthorized(String classStr) {
        for (String s : AUTHORIZED_PREFIXES) {
            if (!classStr.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> restrictecLoadClass(String classStr, Context context) throws ClassNotFoundException {
        if (!ClassUtil.isAuthorized(classStr)) {
            throw new IllegalArgumentException("Class name " + classStr + " not supported");
        }
        ClassLoader cl = Loader.getClassLoaderOfObject((Object)context);
        return cl.loadClass(classStr);
    }

    public static String extractPackageName(String fqcn) {
        int lastDotIndex = fqcn.lastIndexOf(46);
        if (lastDotIndex != -1) {
            String packageName = fqcn.substring(0, lastDotIndex);
            return packageName;
        }
        return null;
    }

    public static String extractSimpleClassName(String fqcn) {
        int lastDotIndex = fqcn.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return fqcn;
        }
        if (lastDotIndex + 1 < fqcn.length()) {
            String className = fqcn.substring(lastDotIndex + 1);
            return className;
        }
        return null;
    }
}

