/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.IncludeModelHandler;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import javax.lang.model.element.Modifier;

public class TylerIncludeModelHandler
extends ModelHandlerBase {
    static final String INCLUDE_METHOD_NAME = "include";

    public TylerIncludeModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        return new TylerIncludeModelHandler(context);
    }

    protected Class<IncludeModel> getSupportedModelClass() {
        return IncludeModel.class;
    }

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        IncludeModel includeModel = (IncludeModel)model;
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
        this.addJavaStatement(tmic, includeModel);
    }

    protected void addJavaStatement(TylerModelInterpretationContext tmic, IncludeModel originalModel) {
        this.addIncludeMethod(tmic);
        tmic.configureMethodSpecBuilder.addStatement("$N($S, $S, $S, $S)", new Object[]{INCLUDE_METHOD_NAME, originalModel.getFile(), originalModel.getUrl(), originalModel.getResource(), originalModel.getOptional()});
    }

    void addIncludeMethod(TylerModelInterpretationContext tmic) {
        if (tmic.mapOfMethodSpecBuilders.containsKey(INCLUDE_METHOD_NAME)) {
            return;
        }
        String includeModelVarName = "includeModel";
        String imhVarName = "includeModelHandler";
        String mfifVarName = "modelFromIncludedFile";
        String fileStrVarName = "fileStr";
        String urlStrVarName = "urlStr";
        String resourceStrVarName = "resourceStr";
        String optionalStrVarName = "optionalStr";
        ParameterSpec fileStr_ParameterSpec = ParameterSpec.builder(String.class, (String)"fileStr", (Modifier[])new Modifier[0]).build();
        ParameterSpec urStr_ParameterSpec = ParameterSpec.builder(String.class, (String)"urlStr", (Modifier[])new Modifier[0]).build();
        ParameterSpec resourceStr_ParameterSpec = ParameterSpec.builder(String.class, (String)"resourceStr", (Modifier[])new Modifier[0]).build();
        ParameterSpec optionalStr_ParameterSpec = ParameterSpec.builder(String.class, (String)"optionalStr", (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder msBuilder = MethodSpec.methodBuilder((String)INCLUDE_METHOD_NAME).addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(fileStr_ParameterSpec).addParameter(urStr_ParameterSpec).addParameter(resourceStr_ParameterSpec).addParameter(optionalStr_ParameterSpec).returns(Void.TYPE);
        msBuilder.addStatement("$1T $2N = new $1T()", new Object[]{IncludeModel.class, includeModelVarName});
        msBuilder.addStatement("$N.setFile(subst($N))", new Object[]{includeModelVarName, "fileStr"});
        msBuilder.addStatement("$N.setUrl(subst($N))", new Object[]{includeModelVarName, "urlStr"});
        msBuilder.addStatement("$N.setResource(subst($N))", new Object[]{includeModelVarName, "resourceStr"});
        msBuilder.addStatement("$N.setOptional(subst($N))", new Object[]{includeModelVarName, "optionalStr"});
        msBuilder.addStatement("$1T $2N = new $1T($3N)", new Object[]{IncludeModelHandler.class, imhVarName, tmic.getContextFieldSpec()});
        msBuilder.beginControlFlow("try", new Object[0]);
        msBuilder.addStatement("$T $N = $N.buildModelFromIncludedFile(this, $N)", new Object[]{Model.class, mfifVarName, imhVarName, includeModelVarName});
        msBuilder.addStatement("processModelFromIncludedFile($N)", new Object[]{mfifVarName});
        msBuilder.nextControlFlow("catch($T e)", new Object[]{ModelHandlerException.class});
        msBuilder.addStatement("addError(\"Failed to process IncludeModelHandler\", e)", new Object[0]);
        msBuilder.endControlFlow();
        tmic.mapOfMethodSpecBuilders.put(INCLUDE_METHOD_NAME, msBuilder);
        msBuilder.addJavadoc("<p>Warning: please note that at translation time logback-tyler usually does not have\naccess to the included file.<p>\n\n<p>It follows that the code in this method (produced by logback-tyler) falls back to invoking\nlogback-classic's default configurator, i.e. JoranConfigurator which will invoke an XML\nparser.</p>\n\n<p>If you wish to avoid calling <code>JoranConfigurator</code>, then you can insert\nthe contents of the included XML file into the encompassing file manually before performing\nthe translation.</p>\n\n<p>Also note that PropertiesConfigurator introduced in version 1.5.8, allows for setting\nlogger levels via a properties file. The location of properties files can be specified\nas a file path as well a URL via HTTP or HTTPS protocols. Watching files and\nreconfiguration upon change are also supported. Logback-tyler supports\n<code>PropertiesConfigurator</code>.</p>\n\n", new Object[0]);
    }
}

