/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.util.AggregationAssessor;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.model.ImplicitModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StringUtil;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import ch.qos.logback.tyler.base.handler.ImplicitModelHandlerData;
import ch.qos.logback.tyler.base.util.ClassUtil;
import ch.qos.logback.tyler.base.util.StringToVariableStament;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import java.lang.reflect.Method;

public class ImplicitModelHandler
extends ModelHandlerBase {
    boolean inError = false;
    private final BeanDescriptionCache beanDescriptionCache;
    ImplicitModelHandlerData implicitModelHandlerData;
    AggregationAssessor aggregationAssessor;
    AggregationType aggregationType;
    public static final String IGNORING_UNKNOWN_PROP = "Ignoring unknown property";

    public ImplicitModelHandler(Context context, BeanDescriptionCache beanDescriptionCache) {
        super(context);
        this.beanDescriptionCache = beanDescriptionCache;
    }

    public static ImplicitModelHandler makeInstance(Context context, ModelInterpretationContext mic) {
        BeanDescriptionCache beanDescriptionCache = mic.getBeanDescriptionCache();
        return new ImplicitModelHandler(context, beanDescriptionCache);
    }

    protected Class<? extends ImplicitModel> getSupportedModelClass() {
        return ImplicitModel.class;
    }

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        ImplicitModel implicitModel = (ImplicitModel)model;
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
        if (mic.isObjectStackEmpty()) {
            this.inError = true;
            return;
        }
        String nestedElementTagName = implicitModel.getTag();
        Object o = mic.peekObject();
        if (o == null) {
            this.addError("Null object at the top of the stack");
            this.inError = true;
            return;
        }
        if (!(o instanceof ImplicitModelHandlerData)) {
            this.addError("Was expecting class of type " + ImplicitModelHandlerData.class.getName() + " but found " + o.getClass().getName());
            this.inError = true;
            return;
        }
        ImplicitModelHandlerData tylerImplicitData = (ImplicitModelHandlerData)o;
        this.aggregationAssessor = new AggregationAssessor(this.beanDescriptionCache, tylerImplicitData.getParentObjectClass());
        this.aggregationAssessor.setContext(this.context);
        this.aggregationType = this.aggregationAssessor.computeAggregationType(nestedElementTagName);
        switch (this.aggregationType) {
            case NOT_FOUND: {
                this.addWarn("Ignoring unknown property [" + nestedElementTagName + "] in [" + o.getClass().getName() + "]");
                this.inError = true;
                implicitModel.markAsSkipped();
                return;
            }
            case AS_BASIC_PROPERTY: 
            case AS_BASIC_PROPERTY_COLLECTION: {
                this.doBasicProperty(mic, implicitModel, this.aggregationAssessor, tylerImplicitData, this.aggregationType);
                return;
            }
            case AS_COMPLEX_PROPERTY_COLLECTION: 
            case AS_COMPLEX_PROPERTY: {
                this.doComplex(tmic, implicitModel, this.aggregationAssessor, tylerImplicitData, this.aggregationType);
                return;
            }
        }
        this.addError("PropertySetter.computeAggregationType returned " + String.valueOf(this.aggregationType));
        this.inError = true;
    }

    private void doComplex(TylerModelInterpretationContext tmic, ImplicitModel implicitModel, AggregationAssessor aggregationAssessor, ImplicitModelHandlerData classAndMethodSpecTuple, AggregationType aggregationType) {
        String className = implicitModel.getClassName();
        String fqcn = tmic.getImport(className);
        String nestedElementTagName = implicitModel.getTag();
        Class componentClass = null;
        try {
            componentClass = !OptionHelper.isNullOrEmptyOrAllSpaces((String)fqcn) ? ClassUtil.restrictecLoadClass(fqcn, this.context) : aggregationAssessor.getClassNameViaImplicitRules(nestedElementTagName, aggregationType, tmic.getDefaultNestedComponentRegistry());
            if (componentClass == null) {
                this.inError = true;
                String errMsg = "Could not find an appropriate class for property [" + nestedElementTagName + "]";
                this.addError(errMsg);
                return;
            }
            if (OptionHelper.isNullOrEmptyOrAllSpaces((String)fqcn)) {
                this.addInfo("Assuming default type [" + componentClass.getName() + "] for [" + nestedElementTagName + "] property");
            }
            this.implicitModelHandlerData = this.addJavaStatementForComplexProperty(tmic, implicitModel, classAndMethodSpecTuple, componentClass);
            tmic.pushObject(this.implicitModelHandlerData);
        }
        catch (Exception oops) {
            this.inError = true;
            String msg = "Could not create component [" + implicitModel.getTag() + "] of type [" + fqcn + "]";
            this.addError(msg, oops);
        }
    }

    private ImplicitModelHandlerData addJavaStatementForComplexProperty(TylerModelInterpretationContext tmic, ImplicitModel implicitModel, ImplicitModelHandlerData implicitModelHandlerData, Class<?> componentClass) {
        MethodSpec.Builder methodSpecBuilder = implicitModelHandlerData.methodSpecBuilder;
        String parentVariableName = implicitModelHandlerData.getVariableName();
        String variableName = StringUtil.lowercaseFirstLetter((String)componentClass.getSimpleName());
        ClassName componentCN = ClassName.get((String)componentClass.getPackageName(), (String)componentClass.getSimpleName(), (String[])new String[0]);
        methodSpecBuilder.addCode("\n", new Object[0]);
        methodSpecBuilder.addComment("Configure component of type $T", new Object[]{componentCN});
        methodSpecBuilder.addStatement("$1T $2N = new $1T()", new Object[]{componentCN, variableName});
        boolean isContextAware = ClassUtil.classImplements(componentClass, ContextAware.class);
        if (isContextAware) {
            methodSpecBuilder.addStatement("$N.setContext($N)", new Object[]{variableName, tmic.getContextFieldSpec()});
        } else {
            methodSpecBuilder.addComment("$T not ContextAware", new Object[]{componentClass});
        }
        ImplicitModelHandlerData cvnmsbt = new ImplicitModelHandlerData(parentVariableName, componentClass, variableName, methodSpecBuilder);
        return cvnmsbt;
    }

    private void doBasicProperty(ModelInterpretationContext mic, ImplicitModel implicitModel, AggregationAssessor aggregationAssessor, ImplicitModelHandlerData classAndMethodSpecTuple, AggregationType aggregationType) {
        String bodyText = implicitModel.getBodyText();
        String nestedElementTagName = implicitModel.getTag();
        switch (aggregationType) {
            case AS_BASIC_PROPERTY: {
                Method setterMethod = aggregationAssessor.findSetterMethod(nestedElementTagName);
                Class<?>[] paramTypes = setterMethod.getParameterTypes();
                this.setPropertyJavaStatement(classAndMethodSpecTuple, setterMethod, bodyText, paramTypes[0]);
                break;
            }
            case AS_BASIC_PROPERTY_COLLECTION: {
                Method adderMethod = aggregationAssessor.findAdderMethod(nestedElementTagName);
                Class<?>[] addedParamTypes = adderMethod.getParameterTypes();
                this.setPropertyJavaStatement(classAndMethodSpecTuple, adderMethod, bodyText, addedParamTypes[0]);
                break;
            }
            default: {
                this.addError("Unexpected aggregationType " + String.valueOf(aggregationType));
            }
        }
    }

    private void setPropertyJavaStatement(ImplicitModelHandlerData classAndMethodSpecTuple, Method setterMethod, String value, Class<?> type) {
        MethodSpec.Builder methodSpecBuilder = classAndMethodSpecTuple.methodSpecBuilder;
        String variableName = classAndMethodSpecTuple.getVariableName();
        String valuePart = StringToVariableStament.convertArg(type, value);
        if (Boolean.TYPE.isAssignableFrom(type)) {
            value = value.toLowerCase();
        }
        methodSpecBuilder.addStatement("$N.$N(" + valuePart + ")", new Object[]{variableName, setterMethod.getName(), value});
        Integer.parseInt("1");
    }

    public void postHandle(ModelInterpretationContext mic, Model model) {
        if (this.inError) {
            return;
        }
        if (this.implicitModelHandlerData != null) {
            this.postHandleComplex(mic, model);
        }
    }

    private void postHandleComplex(ModelInterpretationContext mic, Model model) {
        Object o = mic.peekObject();
        if (o != this.implicitModelHandlerData) {
            this.addError("The object on the top the of the stack is not the " + String.valueOf(ImplicitModelHandlerData.class) + " instance pushed earlier.");
        } else {
            mic.popObject();
            ImplicitModel implicitModel = (ImplicitModel)model;
            MethodSpec.Builder methodSpecBuilder = this.implicitModelHandlerData.methodSpecBuilder;
            String parentVariableName = this.implicitModelHandlerData.getParentVariableName();
            String variableName = this.implicitModelHandlerData.getVariableName();
            Class objClass = this.implicitModelHandlerData.getParentObjectClass();
            Method method = switch (this.aggregationType) {
                case AggregationType.AS_COMPLEX_PROPERTY -> this.aggregationAssessor.findSetterMethod(implicitModel.getTag());
                case AggregationType.AS_COMPLEX_PROPERTY_COLLECTION -> this.aggregationAssessor.findAdderMethod(implicitModel.getTag());
                default -> throw new IllegalArgumentException("unexpected aggregationType " + String.valueOf(this.aggregationType));
            };
            AggregationAssessor nestedAggregationAssessor = new AggregationAssessor(this.beanDescriptionCache, objClass);
            nestedAggregationAssessor.setContext(this.context);
            Method parentSetterMethod = nestedAggregationAssessor.findSetterMethod("parent");
            if (parentSetterMethod != null) {
                methodSpecBuilder.addStatement("$N.$N($N)", new Object[]{variableName, parentSetterMethod.getName(), parentVariableName});
            } else {
                methodSpecBuilder.addComment("===========no parent setter", new Object[0]);
            }
            boolean shouldBeStarted = ClassUtil.shouldBeStarted(objClass);
            if (shouldBeStarted) {
                methodSpecBuilder.addStatement("$N.start()", new Object[]{variableName});
            } else {
                methodSpecBuilder.addComment("$N of class $T does not implement $T interface,", new Object[]{variableName, objClass, LifeCycle.class});
                methodSpecBuilder.addComment("or alternatively class $T is annotated with @NoAutoStart", new Object[]{objClass});
            }
            methodSpecBuilder.addComment("Inject component of type $T into parent", new Object[]{objClass});
            methodSpecBuilder.addStatement("$N.$N($N)", new Object[]{parentVariableName, method.getName(), variableName});
        }
    }
}

