/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Marker;

public final class Logger
implements org.slf4j.Logger,
AppenderAttachable {
    public static final String FQCN = Logger.class.getName();
    static int instanceCount = 0;
    private String name;
    private Level level;
    private int effectiveLevelInt;
    private Logger parent;
    private List<Logger> childrenList;
    private AppenderAttachableImpl aai;
    private boolean additive = true;
    final LoggerContext loggerContext;
    private static final int DEFAULT_CHILD_ARRAY_SIZE = 5;

    Logger(String name, Logger parent, LoggerContext loggerContext) {
        this.name = name;
        this.parent = parent;
        this.loggerContext = loggerContext;
        ++instanceCount;
    }

    final Level getEffectiveLevel() {
        return Level.toLevel(this.effectiveLevelInt);
    }

    int getEffectiveLevelInt() {
        return this.effectiveLevelInt;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    private final boolean isRootLogger() {
        return this.parent == null;
    }

    Logger getChildBySuffix(String suffix) {
        if (this.childrenList == null) {
            return null;
        }
        int len = this.childrenList.size();
        int childNameOffset = this.isRootLogger() ? 0 : this.name.length() + 1;
        for (int i = 0; i < len; ++i) {
            Logger childLogger = this.childrenList.get(i);
            String childName = childLogger.getName();
            if (!suffix.equals(childName.substring(childNameOffset))) continue;
            return childLogger;
        }
        return null;
    }

    Logger getChildByName(String childName) {
        if (this.childrenList == null) {
            return null;
        }
        int len = this.childrenList.size();
        for (int i = 0; i < len; ++i) {
            Logger childLogger_i = this.childrenList.get(i);
            String childName_i = childLogger_i.getName();
            if (!childName.equals(childName_i)) continue;
            return childLogger_i;
        }
        return null;
    }

    public synchronized void setLevel(Level newLevel) {
        if (this.level == newLevel) {
            return;
        }
        this.level = newLevel;
        this.effectiveLevelInt = newLevel.levelInt;
        if (this.childrenList != null) {
            int len = this.childrenList.size();
            for (int i = 0; i < len; ++i) {
                Logger child = this.childrenList.get(i);
                child.handleParentLevelChange(newLevel);
            }
        }
    }

    private synchronized void handleParentLevelChange(Level newParentLevel) {
        if (this.level == null) {
            this.effectiveLevelInt = newParentLevel.levelInt;
            if (this.childrenList != null) {
                int len = this.childrenList.size();
                for (int i = 0; i < len; ++i) {
                    Logger child = this.childrenList.get(i);
                    child.handleParentLevelChange(newParentLevel);
                }
            }
        }
    }

    public synchronized void detachAndStopAllAppenders() {
        if (this.aai != null) {
            this.aai.detachAndStopAllAppenders();
        }
    }

    public synchronized Appender detachAppender(String name) {
        if (this.aai == null) {
            return null;
        }
        return this.aai.detachAppender(name);
    }

    public synchronized void addAppender(Appender newAppender) {
        if (this.aai == null) {
            this.aai = new AppenderAttachableImpl();
        }
        this.aai.addAppender(newAppender);
    }

    public boolean isAttached(Appender appender) {
        if (this.aai == null) {
            return false;
        }
        return this.aai.isAttached(appender);
    }

    public synchronized Iterator iteratorForAppenders() {
        if (this.aai != null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.aai.iteratorForAppenders();
    }

    public Appender getAppender(String name) {
        if (this.aai == null) {
            this.aai = new AppenderAttachableImpl();
        }
        return this.aai.getAppender(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callAppenders(LoggingEvent event) {
        int writes = 0;
        Logger l = this;
        while (l != null) {
            Logger logger = l;
            synchronized (logger) {
                writes += l.appendLoopOnAppenders(event);
                if (!l.additive) {
                    break;
                }
            }
            l = l.parent;
        }
        if (writes == 0) {
            this.loggerContext.noAppenderDefinedWarning(this);
        }
    }

    private int appendLoopOnAppenders(LoggingEvent event) {
        int size = 0;
        if (this.aai != null) {
            size = this.aai.appendLoopOnAppenders((Object)event);
        }
        return size;
    }

    public synchronized boolean detachAppender(Appender appender) {
        if (this.aai == null) {
            return false;
        }
        return this.aai.detachAppender(appender);
    }

    Logger createChildByLastNamePart(String lastPart) {
        int i_index = lastPart.indexOf(46);
        if (i_index != -1) {
            throw new IllegalArgumentException("Child name [" + lastPart + " passed as parameter, may not include [" + '.' + "]");
        }
        if (this.childrenList == null) {
            this.childrenList = new ArrayList<Logger>();
        }
        Logger childLogger = this.isRootLogger() ? new Logger(lastPart, this, this.loggerContext) : new Logger(this.name + '.' + lastPart, this, this.loggerContext);
        this.childrenList.add(childLogger);
        childLogger.effectiveLevelInt = this.effectiveLevelInt;
        return childLogger;
    }

    Logger createChildByName(String childName) {
        int i_index = childName.indexOf(46, this.name.length() + 1);
        if (i_index != -1) {
            throw new IllegalArgumentException("For logger [" + this.name + "] child name [" + childName + " passed as parameter, may not include '.' after index" + (this.name.length() + 1));
        }
        if (this.childrenList == null) {
            this.childrenList = new ArrayList<Logger>(5);
        }
        Logger childLogger = new Logger(childName, this, this.loggerContext);
        this.childrenList.add(childLogger);
        childLogger.effectiveLevelInt = this.effectiveLevelInt;
        return childLogger;
    }

    private void filterAndLog(String caller, Level level, String format, Throwable t) {
        LoggingEvent le = new LoggingEvent(caller, this, level, format, t);
        this.loggerContext.getFilterChainDecision(le);
        if (this.loggerContext.getFilterChainDecision(le) != -1) {
            this.callAppenders(le);
        }
    }

    private void filterAndLog(String caller, Level level, String format, Object[] argArray, Throwable t) {
        LoggingEvent le = new LoggingEvent(caller, this, level, format, t);
        le.setArgumentArray(argArray);
        if (this.loggerContext.getFilterChainDecision(le) != -1) {
            this.callAppenders(le);
        }
    }

    private void filterAndLog(String caller, Level level, Marker marker, String format, Object[] argArray, Throwable t) {
        LoggingEvent le = new LoggingEvent(caller, this, level, format, t);
        le.setMarker(marker);
        le.setArgumentArray(argArray);
        if (this.loggerContext.getFilterChainDecision(le) != -1) {
            this.callAppenders(le);
        }
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.filterAndLog(FQCN, Level.DEBUG, msg, null);
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.filterAndLog(FQCN, Level.DEBUG, format, new Object[]{arg}, null);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.filterAndLog(FQCN, Level.DEBUG, format, new Object[]{arg1, arg2}, null);
        }
    }

    public void debug(String format, Object[] argArray) {
        if (this.isDebugEnabled()) {
            this.filterAndLog(FQCN, Level.DEBUG, format, new Object[]{argArray}, null);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.filterAndLog(FQCN, Level.DEBUG, msg, t);
        }
    }

    public final void debug(Marker marker, String msg) {
        if (this.isDebugEnabled()) {
            this.filterAndLog(FQCN, Level.DEBUG, marker, msg, null, null);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.filterAndLog(FQCN, Level.DEBUG, marker, format, new Object[]{arg}, null);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.filterAndLog(FQCN, Level.DEBUG, marker, format, new Object[]{arg1, arg2}, null);
        }
    }

    public void debug(Marker marker, String format, Object[] argArray) {
        if (this.isDebugEnabled()) {
            this.filterAndLog(FQCN, Level.DEBUG, marker, format, new Object[]{argArray}, null);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.filterAndLog(FQCN, Level.DEBUG, marker, msg, null, t);
        }
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.filterAndLog(FQCN, Level.ERROR, msg, null);
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.filterAndLog(FQCN, Level.ERROR, format, new Object[]{arg}, null);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.filterAndLog(FQCN, Level.ERROR, format, new Object[]{arg1, arg2}, null);
        }
    }

    public void error(String format, Object[] argArray) {
        if (this.isErrorEnabled()) {
            this.filterAndLog(FQCN, Level.ERROR, format, new Object[]{argArray}, null);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.filterAndLog(FQCN, Level.ERROR, msg, t);
        }
    }

    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled()) {
            this.filterAndLog(FQCN, Level.ERROR, marker, msg, null, null);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.filterAndLog(FQCN, Level.ERROR, marker, format, new Object[]{arg}, null);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.filterAndLog(FQCN, Level.ERROR, marker, format, new Object[]{arg1, arg2}, null);
        }
    }

    public void error(Marker marker, String format, Object[] argArray) {
        if (this.isErrorEnabled()) {
            this.filterAndLog(FQCN, Level.ERROR, marker, format, new Object[]{argArray}, null);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.filterAndLog(FQCN, Level.ERROR, marker, msg, null, t);
        }
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.filterAndLog(FQCN, Level.INFO, msg, null);
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.filterAndLog(FQCN, Level.INFO, format, new Object[]{arg}, null);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.filterAndLog(FQCN, Level.INFO, format, new Object[]{arg1, arg2}, null);
        }
    }

    public void info(String format, Object[] argArray) {
        if (this.isInfoEnabled()) {
            this.filterAndLog(FQCN, Level.INFO, format, new Object[]{argArray}, null);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.filterAndLog(FQCN, Level.INFO, msg, t);
        }
    }

    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled()) {
            this.filterAndLog(FQCN, Level.INFO, marker, msg, null, null);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.filterAndLog(FQCN, Level.INFO, marker, format, new Object[]{arg}, null);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.filterAndLog(FQCN, Level.INFO, marker, format, new Object[]{arg1, arg2}, null);
        }
    }

    public void info(Marker marker, String format, Object[] argArray) {
        if (this.isInfoEnabled()) {
            this.filterAndLog(FQCN, Level.INFO, marker, format, new Object[]{argArray}, null);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.filterAndLog(FQCN, Level.INFO, marker, msg, null, t);
        }
    }

    public final boolean isDebugEnabled() {
        return this.effectiveLevelInt <= 10000;
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public final boolean isErrorEnabled() {
        return this.effectiveLevelInt <= 40000;
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public boolean isInfoEnabled() {
        return this.effectiveLevelInt <= 20000;
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.effectiveLevelInt <= 30000;
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.filterAndLog(FQCN, Level.WARN, msg, null);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.filterAndLog(FQCN, Level.WARN, msg, t);
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.filterAndLog(FQCN, Level.WARN, format, new Object[]{arg}, null);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.filterAndLog(FQCN, Level.WARN, format, new Object[]{arg1, arg2}, null);
        }
    }

    public void warn(String format, Object[] argArray) {
        if (this.effectiveLevelInt <= 30000) {
            this.filterAndLog(FQCN, Level.WARN, format, new Object[]{argArray}, null);
        }
    }

    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled()) {
            this.filterAndLog(FQCN, Level.WARN, marker, msg, null, null);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.filterAndLog(FQCN, Level.WARN, marker, format, new Object[]{arg}, null);
        }
    }

    public void warn(Marker marker, String format, Object[] argArray) {
        if (this.isWarnEnabled()) {
            this.filterAndLog(FQCN, Level.WARN, marker, format, new Object[]{argArray}, null);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.filterAndLog(FQCN, Level.WARN, marker, format, new Object[]{arg1, arg2}, null);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.filterAndLog(FQCN, Level.WARN, marker, msg, null, t);
        }
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public void setAdditive(boolean additive) {
        this.additive = additive;
    }

    public String toString() {
        return "Logger[" + this.name + "]";
    }

    public LoggerContext getLoggerContext() {
        return this.loggerContext;
    }
}

