/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.util.namejuggler;

import cc.factorie.app.nlp.lexicon.TriePhraseLexicon;
import cc.factorie.app.nlp.lexicon.TrieUnionLexicon;
import cc.factorie.app.nlp.lexicon.package$;
import cc.factorie.util.namejuggler.NameComponentFormat;
import cc.factorie.util.namejuggler.PersonNameFormat;
import cc.factorie.util.namejuggler.PersonNameFormat$;
import cc.factorie.util.namejuggler.StringUtils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple11;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class PersonNameFormat$
implements Serializable {
    public static final PersonNameFormat$ MODULE$;
    private TrieUnionLexicon nameLexicon;
    private final Set<String> validPrefixes;
    private final Set<String> allValidPrefixes;
    private final Seq<String> validDegrees;
    private final Map<String, String> degreeFixer;
    private final Seq<String> allValidDegrees;
    private final Seq<String> validHereditySuffixes;
    private final Seq<String> validSurnameParticles;
    private final Regex consecutiveUpperCasePattern;
    private volatile boolean bitmap$0;

    static {
        new PersonNameFormat$();
    }

    private TrieUnionLexicon nameLexicon$lzycompute() {
        PersonNameFormat$ personNameFormat$ = this;
        synchronized (personNameFormat$) {
            if (!this.bitmap$0) {
                this.nameLexicon = new TrieUnionLexicon("first names", (Seq<TriePhraseLexicon>)Predef$.MODULE$.wrapRefArray((Object[])new TriePhraseLexicon[]{package$.MODULE$.iesl().PersonFirstHighest(), package$.MODULE$.iesl().PersonFirstHigh()}));
                this.bitmap$0 = true;
            }
            return this.nameLexicon;
        }
    }

    private TrieUnionLexicon nameLexicon() {
        return this.bitmap$0 ? this.nameLexicon : this.nameLexicon$lzycompute();
    }

    private Set<String> validPrefixes() {
        return this.validPrefixes;
    }

    private Set<String> allValidPrefixes() {
        return this.allValidPrefixes;
    }

    private Seq<String> validDegrees() {
        return this.validDegrees;
    }

    private Map<String, String> degreeFixer() {
        return this.degreeFixer;
    }

    public String fixDegree(String s) {
        return (String)this.degreeFixer().getOrElse((Object)StringUtils$.MODULE$.enrichString(s.toLowerCase()).stripPunctuation(), (Function0)new Serializable(s){
            private final String s$1;

            public final String apply() {
                return this.s$1.toUpperCase();
            }
            {
                this.s$1 = s$1;
            }
        });
    }

    private Seq<String> allValidDegrees() {
        return this.allValidDegrees;
    }

    private Seq<String> validHereditySuffixes() {
        return this.validHereditySuffixes;
    }

    private Seq<String> validSurnameParticles() {
        return this.validSurnameParticles;
    }

    public boolean isPrefix(String s) {
        return !s.trim().isEmpty() && this.allValidPrefixes().contains((Object)s.trim().toLowerCase());
    }

    public boolean isHereditySuffix(String s) {
        return !s.trim().isEmpty() && this.validHereditySuffixes().contains((Object)s.trim());
    }

    public boolean isSurnameParticle(String s) {
        return !s.trim().isEmpty() && this.validSurnameParticles().contains((Object)s.trim());
    }

    public boolean isSurnameParticleNoCase(String s) {
        return this.isSurnameParticle(s.toLowerCase());
    }

    public boolean isGivenNames(String s) {
        return this.nameLexicon().containsLemmatizedWord(s.toLowerCase());
    }

    public String fixParticle(String s) {
        String lc = s.toLowerCase();
        return this.isSurnameParticle(lc) ? lc : s;
    }

    public Regex consecutiveUpperCasePattern() {
        return this.consecutiveUpperCasePattern;
    }

    public boolean likelyDegree(String s, boolean containsLowerCase2, boolean hasFirstName) {
        boolean bl;
        if (new StringOps(Predef$.MODULE$.augmentString(StringUtils$.MODULE$.enrichString(s).stripPunctuation())).size() < 2) {
            bl = false;
        } else {
            String c;
            boolean stringMatch = this.allValidDegrees().contains((Object)s);
            String string = s;
            Option option = this.consecutiveUpperCasePattern().unapplySeq((CharSequence)string);
            boolean bl2 = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 ? !(c = (String)((LinearSeqOptimized)option.get()).apply(0)).isEmpty() && containsLowerCase2 : false;
            boolean caseSuggestive = bl2;
            bl = stringMatch || caseSuggestive && hasFirstName;
        }
        return bl;
    }

    public PersonNameFormat apply(boolean withPrefixes, NameComponentFormat givenFormat, NameComponentFormat surFormat, boolean inverted, String invertedSeparator, boolean withSuffixes, String initialTerminator, String initialSeparator, String degreeAbbreviator, String degreeSeparator, boolean allCaps) {
        return new PersonNameFormat(withPrefixes, givenFormat, surFormat, inverted, invertedSeparator, withSuffixes, initialTerminator, initialSeparator, degreeAbbreviator, degreeSeparator, allCaps);
    }

    public Option<Tuple11<Object, NameComponentFormat, NameComponentFormat, Object, String, Object, String, String, String, String, Object>> unapply(PersonNameFormat x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple11((Object)BoxesRunTime.boxToBoolean((boolean)x$0.withPrefixes()), (Object)x$0.givenFormat(), (Object)x$0.surFormat(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.inverted()), (Object)x$0.invertedSeparator(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.withSuffixes()), (Object)x$0.initialTerminator(), (Object)x$0.initialSeparator(), (Object)x$0.degreeAbbreviator(), (Object)x$0.degreeSeparator(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.allCaps())));
    }

    public String $lessinit$greater$default$5() {
        return ",";
    }

    public String $lessinit$greater$default$7() {
        return ".";
    }

    public String $lessinit$greater$default$8() {
        return ".";
    }

    public String $lessinit$greater$default$9() {
        return ".";
    }

    public String $lessinit$greater$default$10() {
        return ", ";
    }

    public boolean $lessinit$greater$default$11() {
        return false;
    }

    public String apply$default$5() {
        return ",";
    }

    public String apply$default$7() {
        return ".";
    }

    public String apply$default$8() {
        return ".";
    }

    public String apply$default$9() {
        return ".";
    }

    public String apply$default$10() {
        return ", ";
    }

    public boolean apply$default$11() {
        return false;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PersonNameFormat$() {
        MODULE$ = this;
        this.validPrefixes = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ms.", "Miss", "Mrs.", "Mr.", "Master", "Rev.", "Fr.", "Dr.", "Atty.", "Prof.", "Hon.", "Pres.", "Gov.", "Coach", "Ofc.", "Msgr.", "Sr.", "Br.", "Supt.", "Rep.", "Sen.", "Amb.", "Treas.", "Sec.", "Pvt.", "Cpl.", "Sgt.", "Adm.", "Maj.", "Capt.", "Cmdr.", "Lt.", "Lt. Col.", "Col.", "Gen."}))).map((Function1)new anonfun.1(), Set$.MODULE$.canBuildFrom());
        this.allValidPrefixes = (Set)this.validPrefixes().$plus$plus((GenTraversableOnce)this.validPrefixes().map((Function1)new anonfun.2(), Set$.MODULE$.canBuildFrom()));
        this.validDegrees = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"M.D.", "Ph.D."}));
        this.degreeFixer = ((TraversableOnce)this.validDegrees().map((Function1)new anonfun.3(), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.allValidDegrees = (Seq)this.validDegrees().$plus$plus((GenTraversableOnce)this.validDegrees().map((Function1)new anonfun.4(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        this.validHereditySuffixes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Jr.", "Sr.", "II", "III", "IV"}));
        this.validSurnameParticles = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"van", "von", "der", "de", "du", "da", "di", "do", "la", "del", "della", "ter", "bin", "ben"}));
        this.consecutiveUpperCasePattern = new StringOps(Predef$.MODULE$.augmentString(".*([A-Z][A-Z]).*")).r();
    }
}

