/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.util;

import cc.factorie.util.DoubleSeq;
import cc.factorie.util.DoubleSeq$;
import cc.factorie.util.MutableDoubleSeq;
import cc.factorie.util.SparseDoubleSeq;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.util.Random;

public abstract class SparseDoubleSeq$class {
    public static boolean forallActiveElements(SparseDoubleSeq $this, Function2 f) {
        BooleanRef result = BooleanRef.create((boolean)true);
        $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, result, f){
            private final BooleanRef result$1;
            private final Function2 f$3;

            public final void apply(int i, double v) {
                this.apply$mcVID$sp(i, v);
            }

            public void apply$mcVID$sp(int i, double v) {
                this.result$1.elem = this.result$1.elem && this.f$3.apply$mcZID$sp(i, v);
            }
            {
                this.result$1 = result$1;
                this.f$3 = f$3;
            }
        });
        return result.elem;
    }

    public static void $eq$plus(SparseDoubleSeq $this, double[] a, int offset, double f) {
        $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, a, offset, f){
            private final double[] a$2;
            private final int offset$1;
            private final double f$4;

            public final void apply(int i, double v) {
                this.apply$mcVID$sp(i, v);
            }

            public void apply$mcVID$sp(int i, double v) {
                int n = i + this.offset$1;
                this.a$2[n] = this.a$2[n] + this.f$4 * v;
            }
            {
                this.a$2 = a$2;
                this.offset$1 = offset$1;
                this.f$4 = f$4;
            }
        });
    }

    public static int indexOf(SparseDoubleSeq $this, double d) {
        IntRef idx = IntRef.create((int)-1);
        $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, idx, d){
            private final IntRef idx$1;
            private final double d$1;

            public final void apply(int i, double v) {
                this.apply$mcVID$sp(i, v);
            }

            public void apply$mcVID$sp(int i, double v) {
                if (v == this.d$1) {
                    this.idx$1.elem = i;
                }
            }
            {
                this.idx$1 = idx$1;
                this.d$1 = d$1;
            }
        });
        return idx.elem;
    }

    public static double infinityNorm(SparseDoubleSeq $this) {
        DoubleRef max2 = DoubleRef.create((double)0.0);
        $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, max2){
            private final DoubleRef max$1;

            public final void apply(int i, double v) {
                this.apply$mcVID$sp(i, v);
            }

            public void apply$mcVID$sp(int i, double v) {
                if (package$.MODULE$.abs(v) > this.max$1.elem) {
                    this.max$1.elem = package$.MODULE$.abs(v);
                }
            }
            {
                this.max$1 = max$1;
            }
        });
        return max2.elem;
    }

    public static Tuple2 maxIndex2(SparseDoubleSeq $this) {
        DoubleRef max2 = DoubleRef.create((double)Double.NEGATIVE_INFINITY);
        IntRef maxi = IntRef.create((int)-1);
        DoubleRef max22 = DoubleRef.create((double)Double.NEGATIVE_INFINITY);
        IntRef maxi2 = IntRef.create((int)-1);
        $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, max2, maxi, max22, maxi2){
            private final DoubleRef max$2;
            private final IntRef maxi$1;
            private final DoubleRef max2$1;
            private final IntRef maxi2$1;

            public final void apply(int i, double v) {
                this.apply$mcVID$sp(i, v);
            }

            public void apply$mcVID$sp(int i, double v) {
                if (v > this.max$2.elem) {
                    this.max2$1.elem = this.max$2.elem;
                    this.maxi2$1.elem = this.maxi$1.elem;
                    this.max$2.elem = v;
                    this.maxi$1.elem = i;
                } else if (v > this.max2$1.elem) {
                    this.max2$1.elem = v;
                    this.maxi2$1.elem = i;
                }
            }
            {
                this.max$2 = max$2;
                this.maxi$1 = maxi$1;
                this.max2$1 = max2$1;
                this.maxi2$1 = maxi2$1;
            }
        });
        return new Tuple2.mcII.sp(maxi.elem, maxi2.elem);
    }

    /*
     * WARNING - void declaration
     */
    public static double[] toArray(SparseDoubleSeq $this) {
        void var1_1;
        double[] a = new double[$this.length()];
        $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, a){
            private final double[] a$1;

            public final void apply(int i, double v) {
                this.apply$mcVID$sp(i, v);
            }

            public void apply$mcVID$sp(int i, double v) {
                this.a$1[i] = v;
            }
            {
                this.a$1 = a$1;
            }
        });
        return var1_1;
    }

    public static double max(SparseDoubleSeq $this) {
        DoubleRef m = DoubleRef.create((double)Double.NaN);
        $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, m){
            private final DoubleRef m$1;

            public final void apply(int i, double v) {
                this.apply$mcVID$sp(i, v);
            }

            public void apply$mcVID$sp(int i, double v) {
                if (!(this.m$1.elem >= v)) {
                    this.m$1.elem = v;
                }
            }
            {
                this.m$1 = m$1;
            }
        });
        return m.elem;
    }

    public static double min(SparseDoubleSeq $this) {
        DoubleRef m = DoubleRef.create((double)Double.NaN);
        $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, m){
            private final DoubleRef m$2;

            public final void apply(int i, double v) {
                this.apply$mcVID$sp(i, v);
            }

            public void apply$mcVID$sp(int i, double v) {
                if (!(this.m$2.elem <= v)) {
                    this.m$2.elem = v;
                }
            }
            {
                this.m$2 = m$2;
            }
        });
        return m.elem;
    }

    public static double sum(SparseDoubleSeq $this) {
        DoubleRef s = DoubleRef.create((double)0.0);
        $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, s){
            private final DoubleRef s$1;

            public final void apply(int i, double v) {
                this.apply$mcVID$sp(i, v);
            }

            public void apply$mcVID$sp(int i, double v) {
                this.s$1.elem += v;
            }
            {
                this.s$1 = s$1;
            }
        });
        return s.elem;
    }

    public static double oneNorm(SparseDoubleSeq $this) {
        DoubleRef s = DoubleRef.create((double)0.0);
        $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, s){
            private final DoubleRef s$2;

            public final void apply(int i, double v) {
                this.apply$mcVID$sp(i, v);
            }

            public void apply$mcVID$sp(int i, double v) {
                this.s$2.elem += package$.MODULE$.abs(v);
            }
            {
                this.s$2 = s$2;
            }
        });
        return s.elem;
    }

    public static double twoNormSquared(SparseDoubleSeq $this) {
        DoubleRef s = DoubleRef.create((double)0.0);
        $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, s){
            private final DoubleRef s$3;

            public final void apply(int i, double v) {
                this.apply$mcVID$sp(i, v);
            }

            public void apply$mcVID$sp(int i, double v) {
                this.s$3.elem += v * v;
            }
            {
                this.s$3 = s$3;
            }
        });
        return s.elem;
    }

    public static boolean contains(SparseDoubleSeq $this, double d) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, object, d){
                    private final Object nonLocalReturnKey1$1;
                    private final double d$2;

                    public final void apply(int i, double v) {
                        this.apply$mcVID$sp(i, v);
                    }

                    public void apply$mcVID$sp(int i, double v) {
                        if (this.d$2 == v) {
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                        }
                    }
                    {
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        this.d$2 = d$2;
                    }
                });
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public static boolean different(SparseDoubleSeq $this, DoubleSeq t, double threshold) {
        DoubleSeq doubleSeq;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    doubleSeq = t;
                    if (!(doubleSeq instanceof SparseDoubleSeq)) break block2;
                    SparseDoubleSeq sparseDoubleSeq = (SparseDoubleSeq)doubleSeq;
                    bl = $this.cc$factorie$util$SparseDoubleSeq$$super$different(sparseDoubleSeq, threshold);
                    break block3;
                }
                if (doubleSeq == null) break block4;
                DoubleSeq doubleSeq2 = doubleSeq;
                bl = $this.cc$factorie$util$SparseDoubleSeq$$super$different(doubleSeq2, threshold);
            }
            return bl;
        }
        throw new MatchError((Object)doubleSeq);
    }

    public static int maxIndex(SparseDoubleSeq $this) {
        IntRef j = IntRef.create((int)0);
        DoubleRef m = DoubleRef.create((double)Double.NaN);
        $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, j, m){
            private final IntRef j$1;
            private final DoubleRef m$3;

            public final void apply(int i, double v) {
                this.apply$mcVID$sp(i, v);
            }

            public void apply$mcVID$sp(int i, double v) {
                if (!(this.m$3.elem >= v)) {
                    this.m$3.elem = v;
                    this.j$1.elem = i;
                }
            }
            {
                this.j$1 = j$1;
                this.m$3 = m$3;
            }
        });
        return j.elem;
    }

    public static boolean containsNaN(SparseDoubleSeq $this) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, object){
                    private final Object nonLocalReturnKey2$1;

                    public final void apply(int i, double v) {
                        this.apply$mcVID$sp(i, v);
                    }

                    public void apply$mcVID$sp(int i, double v) {
                        if (v != v) {
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey2$1, true);
                        }
                    }
                    {
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                });
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public static int sampleIndex(SparseDoubleSeq $this, double normalizer, Random r) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            int n;
            Object object = new Object();
            try {
                Predef$.MODULE$.assert(normalizer > 0.0, (Function0)new Serializable($this, normalizer){
                    private final double normalizer$2;

                    public final String apply() {
                        return new StringBuilder().append((Object)"normalizer = ").append((Object)BoxesRunTime.boxToDouble((double)this.normalizer$2)).toString();
                    }
                    {
                        this.normalizer$2 = normalizer$2;
                    }
                });
                DoubleRef b = DoubleRef.create((double)0.0);
                double s = r.nextDouble() * normalizer;
                $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, b, s, object){
                    private final DoubleRef b$1;
                    private final double s$4;
                    private final Object nonLocalReturnKey3$1;

                    public final void apply(int i, double v) {
                        this.apply$mcVID$sp(i, v);
                    }

                    public void apply$mcVID$sp(int i, double v) {
                        Predef$.MODULE$.assert(v >= 0.0);
                        if (this.b$1.elem > this.s$4) {
                            throw new NonLocalReturnControl.mcI.sp(this.nonLocalReturnKey3$1, i - 1);
                        }
                        this.b$1.elem += v;
                    }
                    {
                        this.b$1 = b$1;
                        this.s$4 = s$4;
                        this.nonLocalReturnKey3$1 = nonLocalReturnKey3$1;
                    }
                });
                n = $this.length() - 1;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                n = nonLocalReturnControl2.value$mcI$sp();
            }
            return n;
        }
        throw nonLocalReturnControl2;
    }

    public static double entropy(SparseDoubleSeq $this) {
        DoubleRef result = DoubleRef.create((double)0.0);
        DoubleRef sum2 = DoubleRef.create((double)0.0);
        $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, result, sum2){
            private final DoubleRef result$2;
            private final DoubleRef sum$2;

            public final void apply(int i, double v) {
                this.apply$mcVID$sp(i, v);
            }

            public void apply$mcVID$sp(int i, double v) {
                this.sum$2.elem += v;
                Predef$.MODULE$.require(v >= 0.0, (Function0)new Serializable(this, v){
                    private final double v$1;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return this.v$1;
                    }
                    {
                        this.v$1 = v$1;
                    }
                });
                Predef$.MODULE$.require(v <= 1.000001);
                if (v > 0.0) {
                    this.result$2.elem -= v * package$.MODULE$.log(v);
                }
            }
            {
                this.result$2 = result$2;
                this.sum$2 = sum$2;
            }
        });
        Predef$.MODULE$.assert(sum2.elem > 0.9999 && sum2.elem < 1.0001);
        return result.elem / cc.factorie.maths.package$.MODULE$.log2();
    }

    public static double klDivergence(SparseDoubleSeq $this, DoubleSeq p) {
        Predef$.MODULE$.assert($this.length() == p.length());
        DoubleRef klDiv = DoubleRef.create((double)0.0);
        DoubleRef sum1 = DoubleRef.create((double)0.0);
        DoubleRef p2 = DoubleRef.create((double)0.0);
        $this.foreachActiveElement((Function2<Object, Object, BoxedUnit>)new Serializable($this, klDiv, sum1, p2, p){
            private final DoubleRef klDiv$1;
            private final DoubleRef sum1$1;
            private final DoubleRef p2$1;
            private final DoubleSeq p$1;

            public final void apply(int i, double p1) {
                this.apply$mcVID$sp(i, p1);
            }

            public void apply$mcVID$sp(int i, double p1) {
                this.p2$1.elem = this.p$1.apply(i);
                this.sum1$1.elem += p1;
                if (p1 != 0.0) {
                    this.klDiv$1.elem += p1 * package$.MODULE$.log(p1 / this.p2$1.elem);
                }
            }
            {
                this.klDiv$1 = klDiv$1;
                this.sum1$1 = sum1$1;
                this.p2$1 = p2$1;
                this.p$1 = p$1;
            }
        });
        Predef$.MODULE$.assert(sum1.elem > 0.9999 && sum1.elem < 1.0001);
        return klDiv.elem / cc.factorie.maths.package$.MODULE$.log2();
    }

    public static double jsDivergence(SparseDoubleSeq $this, DoubleSeq p) {
        Predef$.MODULE$.assert($this.length() == p.length());
        MutableDoubleSeq average = DoubleSeq$.MODULE$.apply($this.length());
        int l = $this.length();
        for (int i = 0; i < l; ++i) {
            int n = i;
            average.update(n, average.apply(n) + ($this.apply(i) + p.apply(i)) / 2.0);
        }
        return ($this.klDivergence(average) + p.klDivergence(average)) / 2.0;
    }

    public static void $init$(SparseDoubleSeq $this) {
    }
}

