/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.tutorial;

import cc.factorie.app.chain.ChainModel;
import cc.factorie.app.chain.Observations$;
import cc.factorie.app.nlp.Document;
import cc.factorie.app.nlp.Sentence;
import cc.factorie.app.nlp.Token;
import cc.factorie.app.nlp.load.LoadOWPL$;
import cc.factorie.app.nlp.pos.LabeledPennPosTag;
import cc.factorie.app.nlp.pos.PennPosDomain$;
import cc.factorie.app.nlp.pos.PennPosTag;
import cc.factorie.model.WeightsSet;
import cc.factorie.optimize.Example;
import cc.factorie.optimize.GradientOptimizer;
import cc.factorie.optimize.Trainer$;
import cc.factorie.package$;
import cc.factorie.tutorial.ForwardBackwardPOS;
import cc.factorie.tutorial.ForwardBackwardPOS$PosFeaturesDomain$;
import cc.factorie.tutorial.ForwardBackwardPOS$PosModel$;
import cc.factorie.tutorial.ForwardBackwardPOS$opts$2$;
import cc.factorie.util.Attr;
import cc.factorie.util.BinarySerializer$;
import cc.factorie.util.Cubbie;
import cc.factorie.variable.LabeledVar;
import cc.factorie.variable.MutableCategoricalVar;
import java.io.File;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.VolatileObjectRef;
import scala.util.Random;

public final class ForwardBackwardPOS$ {
    public static final ForwardBackwardPOS$ MODULE$;
    private boolean modelLoaded;
    private String defaultCategory;
    private volatile boolean bitmap$0;

    static {
        new ForwardBackwardPOS$();
    }

    private String defaultCategory$lzycompute() {
        ForwardBackwardPOS$ forwardBackwardPOS$ = this;
        synchronized (forwardBackwardPOS$) {
            if (!this.bitmap$0) {
                this.defaultCategory = this.liftedTree1$1();
                this.bitmap$0 = true;
            }
            return this.defaultCategory;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ForwardBackwardPOS$opts$2$ opts$1$lzycompute(VolatileObjectRef x$1) {
        ForwardBackwardPOS$ forwardBackwardPOS$ = this;
        synchronized (forwardBackwardPOS$) {
            if (x$1.elem != null) return (ForwardBackwardPOS$opts$2$)x$1.elem;
            x$1.elem = new ForwardBackwardPOS$opts$2$();
            return (ForwardBackwardPOS$opts$2$)x$1.elem;
        }
    }

    public void initPosFeatures(Seq<Document> documents) {
        documents.map((Function1)new Serializable(){

            public final void apply(Document document2) {
                ForwardBackwardPOS$.MODULE$.initPosFeatures(document2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void initPosFeatures(Document document2) {
        document2.tokens().foreach((Function1)new Serializable(){

            public final void apply(Token token) {
                String rawWord = token.string();
                String word = cc.factorie.app.strings.package$.MODULE$.simplifyDigits(rawWord);
                ForwardBackwardPOS.PosFeatures features2 = new ForwardBackwardPOS.PosFeatures(token);
                token.attr().$plus$eq(features2);
                features2.$plus$eq(new StringBuilder().append((Object)"W=").append((Object)word).toString());
                features2.$plus$eq(new StringBuilder().append((Object)"SHAPE3=").append((Object)cc.factorie.app.strings.package$.MODULE$.stringShape(rawWord, 3)).toString());
                int i = 3;
                features2.$plus$eq(new StringBuilder().append((Object)"SUFFIX").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)"=").append(new StringOps(Predef$.MODULE$.augmentString(word)).takeRight(i)).toString());
                features2.$plus$eq(new StringBuilder().append((Object)"PREFIX").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)"=").append(new StringOps(Predef$.MODULE$.augmentString(word)).take(i)).toString());
                if (token.isCapitalized()) {
                    features2.$plus$eq("CAPITALIZED");
                }
                if (token.string().matches("[A-Z]")) {
                    features2.$plus$eq("CONTAINS_CAPITAL");
                }
                if (token.string().matches("-")) {
                    features2.$plus$eq("CONTAINS_DASH");
                }
                if (token.containsDigit()) {
                    features2.$plus$eq("NUMERIC");
                }
                if (token.isPunctuation()) {
                    features2.$plus$eq("PUNCTUATION");
                }
            }
        });
        document2.sentences().foreach((Function1)new Serializable(){

            public final void apply(Sentence sentence2) {
                Observations$.MODULE$.addNeighboringFeatureConjunctions(sentence2.tokens(), new Serializable(this){

                    public final ForwardBackwardPOS.PosFeatures apply(Token t) {
                        return (ForwardBackwardPOS.PosFeatures)t.attr().apply(ClassTag$.MODULE$.apply(ForwardBackwardPOS.PosFeatures.class));
                    }
                }, "W=", (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-2})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-2, -1})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1, 0}))}));
            }
        });
    }

    public <L extends LabeledVar> double percentageSetToTarget(Seq<L> ls) {
        double numCorrect = BoxesRunTime.unboxToDouble((Object)ls.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(){

            public final double apply(double partialSum, L label) {
                return partialSum + (double)(label.valueIsTarget() ? 1 : 0);
            }
        }));
        return numCorrect / (double)ls.size() * (double)100;
    }

    public void predictSentence(Sentence s) {
        this.predictSentence((Seq<LabeledPennPosTag>)((Seq)s.tokens().map((Function1)new Serializable(){

            public final LabeledPennPosTag apply(Token x$1) {
                return (LabeledPennPosTag)x$1.attr().apply(ClassTag$.MODULE$.apply(LabeledPennPosTag.class));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())), this.predictSentence$default$2());
    }

    public void predictSentence(Seq<LabeledPennPosTag> vs, boolean oldBp) {
        ForwardBackwardPOS$PosModel$.MODULE$.maximize(vs, null);
    }

    public boolean predictSentence$default$2() {
        return false;
    }

    public void train(Seq<Document> documents, Seq<Document> devDocuments, Seq<Document> testDocuments, int iterations, String modelFile, String extraId, Random random) {
        Seq sentences = (Seq)documents.flatMap((Function1)new Serializable(){

            public final Iterable<Sentence> apply(Document x$2) {
                return x$2.sentences();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq sentenceTags = (Seq)((TraversableLike)sentences.map((Function1)new Serializable(){

            public final IndexedSeq<PennPosTag> apply(Sentence x$3) {
                return x$3.posTags();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){

            public final boolean apply(IndexedSeq<PennPosTag> x$4) {
                return x$4.size() > 0;
            }
        });
        Seq examples2 = (Seq)sentenceTags.map((Function1)new Serializable(){

            public final ChainModel.ChainLikelihoodExample apply(IndexedSeq<PennPosTag> s) {
                return new ChainModel.ChainLikelihoodExample(ForwardBackwardPOS$PosModel$.MODULE$, s, ForwardBackwardPOS$PosModel$.MODULE$.ChainLikelihoodExample().$lessinit$greater$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        WeightsSet x$9 = ForwardBackwardPOS$PosModel$.MODULE$.parameters();
        Seq x$10 = examples2;
        int x$11 = 10;
        Function0<BoxedUnit> x$12 = Trainer$.MODULE$.onlineTrain$default$3();
        boolean x$13 = Trainer$.MODULE$.onlineTrain$default$4();
        GradientOptimizer x$14 = Trainer$.MODULE$.onlineTrain$default$6();
        int x$15 = Trainer$.MODULE$.onlineTrain$default$7();
        int x$16 = Trainer$.MODULE$.onlineTrain$default$8();
        int x$17 = Trainer$.MODULE$.onlineTrain$default$9();
        Trainer$.MODULE$.onlineTrain(x$9, (Seq<Example>)x$10, x$12, x$13, x$11, x$14, x$15, x$16, x$17, random);
        this.testSavePrint$1("final", documents, devDocuments, testDocuments, modelFile, extraId);
    }

    public Seq<Document> train$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public int train$default$4() {
        return 100;
    }

    public String train$default$5() {
        return "";
    }

    public String train$default$6() {
        return "";
    }

    public void test(Seq<Document> documents, String label) {
        Random random = new Random(0);
        Seq sentences = (Seq)documents.flatMap((Function1)new Serializable(){

            public final Iterable<Sentence> apply(Document x$5) {
                return x$5.sentences();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq labels2 = (Seq)((TraversableLike)sentences.map((Function1)new Serializable(){

            public final scala.collection.immutable.IndexedSeq<Token> apply(Sentence x$6) {
                return x$6.tokens();
            }
        }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(){

            public final scala.collection.immutable.IndexedSeq<LabeledPennPosTag> apply(scala.collection.immutable.IndexedSeq<Token> x$7) {
                return (scala.collection.immutable.IndexedSeq)x$7.map((Function1)new Serializable(this){

                    public final LabeledPennPosTag apply(Token t) {
                        return (LabeledPennPosTag)t.attr().apply(ClassTag$.MODULE$.apply(LabeledPennPosTag.class));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        labels2.map((Function1)new Serializable(random){
            private final Random random$1;

            public final void apply(LabeledPennPosTag x$8) {
                x$8.setRandomly(this.random$1, x$8.setRandomly$default$2());
            }
            {
                this.random$1 = random$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        sentences.map((Function1)new Serializable(){

            public final void apply(Sentence s) {
                ForwardBackwardPOS$.MODULE$.predictSentence(s);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)label).append((Object)" accuracy: ").append((Object)BoxesRunTime.boxToDouble((double)this.percentageSetToTarget(labels2))).append((Object)"%").toString());
    }

    public String test$default$2() {
        return "test";
    }

    public boolean modelLoaded() {
        return this.modelLoaded;
    }

    public void modelLoaded_$eq(boolean x$1) {
        this.modelLoaded = x$1;
    }

    public void load(String modelFile) {
        BinarySerializer$.MODULE$.deserialize((Function0<Cubbie>)new Serializable(){

            public final Cubbie apply() {
                return package$.MODULE$.cdtdm(ForwardBackwardPOS$PosFeaturesDomain$.MODULE$);
            }
        }, (Function0<Cubbie>)new Serializable(){

            public final Cubbie apply() {
                return package$.MODULE$.modm(ForwardBackwardPOS$PosModel$.MODULE$);
            }
        }, new File(modelFile), true);
        this.modelLoaded_$eq(true);
    }

    public void process(Seq<Document> documents) {
        documents.map((Function1)new Serializable(){

            public final void apply(Document document2) {
                ForwardBackwardPOS$.MODULE$.process(document2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void process(Document document2) {
        if (this.modelLoaded()) {
            Option option = ((Attr)document2.tokens().head()).attr().get(ClassTag$.MODULE$.apply(PennPosTag.class));
            None$ none$ = None$.MODULE$;
            if (!(option != null ? !option.equals(none$) : none$ != null)) {
                document2.tokens().foreach((Function1)new Serializable(){

                    public final LabeledPennPosTag apply(Token t) {
                        return (LabeledPennPosTag)t.attr().$plus$eq(ForwardBackwardPOS$.MODULE$.labelMaker(t, ForwardBackwardPOS$.MODULE$.labelMaker$default$2()).apply(0));
                    }
                });
                this.initPosFeatures(document2);
            }
            document2.sentences().foreach((Function1)new Serializable(){

                public final void apply(Sentence s) {
                    ForwardBackwardPOS$.MODULE$.predictSentence(s);
                }
            });
            return;
        }
        throw new Error("The model should be loaded before documents are processed.");
    }

    public String defaultCategory() {
        return this.bitmap$0 ? this.defaultCategory : this.defaultCategory$lzycompute();
    }

    public Seq<LabeledPennPosTag> labelMaker(Token t, Seq<String> l) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPennPosTag[]{new LabeledPennPosTag(t, (String)l.apply(0))}));
    }

    public Seq<String> labelMaker$default$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.defaultCategory()}));
    }

    public void main(String[] args) {
        VolatileObjectRef opts$module = VolatileObjectRef.zero();
        this.opts$1(opts$module).parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        Random random = new Random(0);
        if (this.opts$1(opts$module).trainFile().wasInvoked() && this.opts$1(opts$module).devFile().wasInvoked() && this.opts$1(opts$module).testFile().wasInvoked()) {
            Seq trainDocs = this.load$1(this.opts$1(opts$module).trainFile().value(), opts$module);
            Seq devDocs = this.load$1(this.opts$1(opts$module).devFile().value(), opts$module);
            Seq testDocs = this.load$1(this.opts$1(opts$module).testFile().value(), opts$module);
            this.initPosFeatures((Seq<Document>)((Seq)((TraversableLike)trainDocs.$plus$plus((GenTraversableOnce)devDocs, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)testDocs, Seq$.MODULE$.canBuildFrom())));
            this.train((Seq<Document>)trainDocs, (Seq<Document>)devDocs, (Seq<Document>)testDocs, new StringOps(Predef$.MODULE$.augmentString(this.opts$1(opts$module).iterations().value())).toInt(), this.opts$1(opts$module).modelDir().value(), this.opts$1(opts$module).extraId().value(), random);
        }
    }

    private final void testSavePrint$1(String label, Seq documents$1, Seq devDocuments$1, Seq testDocuments$1, String modelFile$1, String extraId$1) {
        this.test((Seq<Document>)documents$1, "train");
        if (testDocuments$1.nonEmpty()) {
            this.test((Seq<Document>)testDocuments$1, "test");
        }
        if (devDocuments$1.nonEmpty()) {
            this.test((Seq<Document>)devDocuments$1, "dev");
        }
        String string = modelFile$1;
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            BinarySerializer$.MODULE$.serialize((Function0<Cubbie>)new Serializable(){

                public final Cubbie apply() {
                    return package$.MODULE$.cdtdm(ForwardBackwardPOS$PosFeaturesDomain$.MODULE$);
                }
            }, (Function0<Cubbie>)new Serializable(){

                public final Cubbie apply() {
                    return package$.MODULE$.modm(ForwardBackwardPOS$PosModel$.MODULE$);
                }
            }, new File(new StringBuilder().append((Object)modelFile$1).append((Object)label).append((Object)extraId$1).toString()), true);
        }
    }

    private final String liftedTree1$1() {
        try {
            return (String)PennPosDomain$.MODULE$.categories().head();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new Error("The domain must be loaded before it is accessed.");
        }
    }

    private final ForwardBackwardPOS$opts$2$ opts$1(VolatileObjectRef opts$module$1) {
        return opts$module$1.elem == null ? this.opts$1$lzycompute(opts$module$1) : (ForwardBackwardPOS$opts$2$)opts$module$1.elem;
    }

    private final Seq load$1(String f, VolatileObjectRef opts$module$1) {
        String x$18 = f;
        Serializable x$19 = new Serializable(){

            public final Seq<LabeledPennPosTag> apply(Token t, Seq<String> l) {
                return ForwardBackwardPOS$.MODULE$.labelMaker(t, l);
            }
        };
        int x$20 = new StringOps(Predef$.MODULE$.augmentString(this.opts$1(opts$module$1).takeOnly().value())).toInt();
        String x$21 = LoadOWPL$.MODULE$.fromFilename$default$3();
        return LoadOWPL$.MODULE$.fromFilename(x$18, (Function2<Token, Seq<String>, Seq<MutableCategoricalVar<String>>>)x$19, x$21, x$20);
    }

    private ForwardBackwardPOS$() {
        MODULE$ = this;
        this.modelLoaded = false;
    }
}

