/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.tutorial;

import cc.factorie.app.nlp.Document;
import cc.factorie.app.nlp.Token;
import cc.factorie.app.nlp.load.LoadConll2003$;
import cc.factorie.app.nlp.ner.LabeledIobConllNerTag;
import cc.factorie.app.strings.package$;
import cc.factorie.infer.BP$;
import cc.factorie.infer.InferByBPChain$;
import cc.factorie.model.Model;
import cc.factorie.model.Parameters;
import cc.factorie.model.TemplateModel;
import cc.factorie.optimize.Example;
import cc.factorie.optimize.LikelihoodExample;
import cc.factorie.optimize.Trainer$;
import cc.factorie.tutorial.ChainNERExample;
import cc.factorie.tutorial.ChainNERExample$;
import cc.factorie.variable.DiffList;
import cc.factorie.variable.DiscreteVar;
import cc.factorie.variable.HammingObjective$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

public final class ChainNERExample$ {
    public static final ChainNERExample$ MODULE$;
    private final TemplateModel model;

    static {
        new ChainNERExample$();
    }

    public TemplateModel model() {
        return this.model;
    }

    public void main(String[] args) {
        Random random = new Random(0);
        if (args.length != 2) {
            throw new Error("Usage: ChainNER1 trainfile testfile");
        }
        Seq<Document> trainDocuments = LoadConll2003$.MODULE$.fromFilename(args[0]);
        Seq<Document> testDocuments = LoadConll2003$.MODULE$.fromFilename(args[1]);
        ((IterableLike)trainDocuments.$plus$plus(testDocuments, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(){

            public final void apply(Document document2) {
                document2.tokens().foreach((Function1)new Serializable(this){

                    public final ChainNERExample.TokenFeatures apply(Token token) {
                        ChainNERExample.TokenFeatures features2 = new ChainNERExample.TokenFeatures(token);
                        features2.$plus$eq(new StringBuilder().append((Object)"W=").append((Object)token.string()).toString());
                        features2.$plus$eq(new StringBuilder().append((Object)"SHAPE=").append((Object)package$.MODULE$.stringShape(token.string(), 2)).toString());
                        return token.attr().$plus$eq(features2);
                    }
                });
            }
        });
        Seq trainLabelsSentences = (Seq)trainDocuments.map((Function1)new Serializable(){

            public final Seq<LabeledIobConllNerTag> apply(Document x$1) {
                return (Seq)x$1.tokens().toSeq().map((Function1)new Serializable(this){

                    public final LabeledIobConllNerTag apply(Token x$2) {
                        return (LabeledIobConllNerTag)x$2.attr().apply(ClassTag$.MODULE$.apply(LabeledIobConllNerTag.class));
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq testLabelsSentences = (Seq)testDocuments.map((Function1)new Serializable(){

            public final Seq<LabeledIobConllNerTag> apply(Document x$3) {
                return (Seq)x$3.tokens().toSeq().map((Function1)new Serializable(this){

                    public final LabeledIobConllNerTag apply(Token x$4) {
                        return (LabeledIobConllNerTag)x$4.attr().apply(ClassTag$.MODULE$.apply(LabeledIobConllNerTag.class));
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(!testLabelsSentences.contains(null));
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("*** Starting training (#sentences=%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)trainDocuments.map((Function1)new Serializable(){

            public final int apply(Document x$5) {
                return x$5.sentences().size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)})));
        long start = System.currentTimeMillis();
        Seq examples2 = (Seq)trainLabelsSentences.map((Function1)new Serializable(){

            public final LikelihoodExample<Seq<LabeledIobConllNerTag>, TemplateModel> apply(Seq<LabeledIobConllNerTag> s) {
                return new LikelihoodExample<Iterable<DiscreteVar>, Model>((Iterable<DiscreteVar>)s, ChainNERExample$.MODULE$.model(), InferByBPChain$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Trainer$.MODULE$.batchTrain(((Parameters)((Object)this.model())).parameters(), (Seq<Example>)examples2, Trainer$.MODULE$.batchTrain$default$3(), Trainer$.MODULE$.batchTrain$default$4(), Trainer$.MODULE$.batchTrain$default$5(), Trainer$.MODULE$.batchTrain$default$6(), Trainer$.MODULE$.batchTrain$default$7(), random);
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("*** Starting inference (#sentences=%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)testDocuments.map((Function1)new Serializable(){

            public final int apply(Document x$6) {
                return x$6.sentences().size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)})));
        testLabelsSentences.foreach((Function1)new Serializable(){

            public final void apply(Seq<LabeledIobConllNerTag> variables2) {
                Seq<LabeledIobConllNerTag> x$7 = variables2;
                TemplateModel x$8 = ChainNERExample$.MODULE$.model();
                DiffList x$9 = BP$.MODULE$.inferChainMax$default$3(x$7, x$8);
                BP$.MODULE$.inferChainMax(x$7, x$8, x$9).setToMaximize(null);
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"test token accuracy=").append((Object)BoxesRunTime.boxToDouble((double)HammingObjective$.MODULE$.accuracy((Iterable)testLabelsSentences.flatten((Function1)Predef$.MODULE$.$conforms())))).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Total training took ").append((Object)BoxesRunTime.boxToDouble((double)((double)(System.currentTimeMillis() - start) / 1000.0))).append((Object)" seconds").toString());
    }

    private ChainNERExample$() {
        MODULE$ = this;
        this.model = new anon.4();
    }
}

