/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.tutorial;

import cc.factorie.infer.BPSummary;
import cc.factorie.infer.GibbsSampler;
import cc.factorie.infer.IteratedConditionalModes;
import cc.factorie.model.TemplateModel;
import cc.factorie.optimize.AdaGrad;
import cc.factorie.optimize.AdaGrad$;
import cc.factorie.optimize.SampleRankTrainer;
import cc.factorie.tutorial.ChainNERDemo;
import cc.factorie.tutorial.ChainNERDemo$;
import cc.factorie.tutorial.ChainNERDemo$LabelDomain$;
import cc.factorie.tutorial.ChainNERDemo$TokenDomain$;
import cc.factorie.variable.CategoricalTargetVariable;
import cc.factorie.variable.CategoricalValue;
import cc.factorie.variable.CategoricalVariable;
import cc.factorie.variable.CategoricalVectorVar;
import cc.factorie.variable.HammingTemplate;
import cc.factorie.variable.TargetVar;
import cc.factorie.variable.Var;
import java.io.File;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Random;
import scala.util.matching.Regex;

public final class ChainNERDemo$ {
    public static final ChainNERDemo$ MODULE$;
    private final TemplateModel model;
    private final HammingTemplate<ChainNERDemo.Label> objective;
    private final Regex Capitalized;
    private final Regex Numeric;
    private final Regex Punctuation;

    static {
        new ChainNERDemo$();
    }

    public TemplateModel model() {
        return this.model;
    }

    public HammingTemplate<ChainNERDemo.Label> objective() {
        return this.objective;
    }

    public void main(String[] args) {
        Random random = new Random(0);
        if (args.length != 2) {
            throw new Error("Usage: ChainNERDemo trainfile testfile");
        }
        Seq<ChainNERDemo.Sentence> trainSentences = this.load(args[0]);
        Seq<ChainNERDemo.Sentence> testSentences = this.load(args[1]);
        Seq trainLabels = (Seq)((IterableLike)trainSentences.flatMap((Function1)new Serializable(){

            public final IndexedSeq<ChainNERDemo.Label> apply(ChainNERDemo.Sentence x$1) {
                return (IndexedSeq)x$1.links().map((Function1)new Serializable(this){

                    public final ChainNERDemo.Label apply(ChainNERDemo.Token x$2) {
                        return x$2.label();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom())).take(50000);
        Seq testLabels = (Seq)testSentences.flatMap((Function1)new Serializable(){

            public final IndexedSeq<ChainNERDemo.Label> apply(ChainNERDemo.Sentence x$3) {
                return (IndexedSeq)x$3.links().map((Function1)new Serializable(this){

                    public final ChainNERDemo.Label apply(ChainNERDemo.Token x$4) {
                        return x$4.label();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq allTokens = (Seq)((TraversableLike)trainLabels.$plus$plus((GenTraversableOnce)testLabels, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){

            public final ChainNERDemo.Token apply(ChainNERDemo.Label x$5) {
                return x$5.token();
            }
        }, Seq$.MODULE$.canBuildFrom());
        allTokens.foreach((Function1)new Serializable(){

            public final void apply(ChainNERDemo.Token t) {
                if (t.hasPrev()) {
                    t.$plus$plus$eq((Iterable)((TraversableLike)((CategoricalVectorVar)((Object)t.prev())).activeCategories().filter((Function1)new Serializable(this){

                        public final boolean apply(String x$6) {
                            return !new StringOps(Predef$.MODULE$.augmentString(x$6)).contains((Object)BoxesRunTime.boxToCharacter((char)'@'));
                        }
                    })).map((Function1)new Serializable(this){

                        public final String apply(String x$7) {
                            return new StringBuilder().append((Object)x$7).append((Object)"@-1").toString();
                        }
                    }, Seq$.MODULE$.canBuildFrom()));
                }
                if (t.hasNext()) {
                    t.$plus$plus$eq((Iterable)((TraversableLike)((CategoricalVectorVar)((Object)t.next())).activeCategories().filter((Function1)new Serializable(this){

                        public final boolean apply(String x$8) {
                            return !new StringOps(Predef$.MODULE$.augmentString(x$8)).contains((Object)BoxesRunTime.boxToCharacter((char)'@'));
                        }
                    })).map((Function1)new Serializable(this){

                        public final String apply(String x$9) {
                            return new StringBuilder().append((Object)x$9).append((Object)"@+1").toString();
                        }
                    }, Seq$.MODULE$.canBuildFrom()));
                }
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Using ").append((Object)BoxesRunTime.boxToInteger((int)ChainNERDemo$TokenDomain$.MODULE$.dimensionSize())).append((Object)" observable features.").toString());
        long startTime = System.currentTimeMillis();
        ((IterableLike)trainLabels.$plus$plus((GenTraversableOnce)testLabels, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(random){
            private final Random random$1;

            public final void apply(ChainNERDemo.Label x$10) {
                x$10.setRandomly(this.random$1, x$10.setRandomly$default$2());
            }
            {
                this.random$1 = random$1;
            }
        });
        SampleRankTrainer<Var> learner = new SampleRankTrainer<Var>(new GibbsSampler(random){
            {
                this.temperature_$eq(0.1);
            }
        }, new AdaGrad(AdaGrad$.MODULE$.$lessinit$greater$default$1(), AdaGrad$.MODULE$.$lessinit$greater$default$2()));
        IteratedConditionalModes predictor = new IteratedConditionalModes(this.model(), null);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).foreach$mVc$sp((Function1)new Serializable(trainLabels, testLabels, learner, predictor){
            private final Seq trainLabels$1;
            private final Seq testLabels$1;
            private final SampleRankTrainer learner$1;
            private final IteratedConditionalModes predictor$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.learner$1.processContexts(this.trainLabels$1);
                this.predictor$1.processAll(this.testLabels$1, this.predictor$1.processAll$default$2());
                this.predictor$1.processAll(this.trainLabels$1, this.predictor$1.processAll$default$2());
                ((IterableLike)this.trainLabels$1.take(20)).foreach((Function1)new Serializable(this){

                    public final void apply(ChainNERDemo.Label label) {
                        ChainNERDemo$.MODULE$.printLabel(label);
                    }
                });
                Predef$.MODULE$.println();
                Predef$.MODULE$.println();
                ChainNERDemo$.MODULE$.printDiagnostic((Seq<ChainNERDemo.Label>)((Seq)this.trainLabels$1.take(400)));
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Test  accuracy = ").append((Object)BoxesRunTime.boxToDouble((double)ChainNERDemo$.MODULE$.objective().accuracy((Iterable<ChainNERDemo.Label>)this.testLabels$1))).toString());
            }
            {
                this.trainLabels$1 = trainLabels$1;
                this.testLabels$1 = testLabels$1;
                this.learner$1 = learner$1;
                this.predictor$1 = predictor$1;
            }
        });
        predictor.processAll(testLabels, 2);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Final Test  accuracy = ").append((Object)BoxesRunTime.boxToDouble((double)this.objective().accuracy((Iterable<ChainNERDemo.Label>)testLabels))).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Finished in ").append((Object)BoxesRunTime.boxToDouble((double)((double)(System.currentTimeMillis() - startTime) / 1000.0))).append((Object)" seconds").toString());
    }

    public void printTokenMarginals(Seq<ChainNERDemo.Token> tokens, BPSummary summary) {
        tokens.foreach((Function1)new Serializable(summary){
            private final BPSummary summary$1;

            public final void apply(ChainNERDemo.Token token) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)token.word()).append((Object)" ").append((Object)((TraversableOnce)((SeqLike)((SeqLike)ChainNERDemo$LabelDomain$.MODULE$.categories().zip(this.summary$1.marginal(token.label()).proportions().asSeq(), Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(this){

                    public final double apply(Tuple2<String, Object> x$13) {
                        return x$13._2$mcD$sp();
                    }
                }, (Ordering)Ordering.Double$.MODULE$)).reverse()).mkString(" ")).toString());
            }
            {
                this.summary$1 = summary$1;
            }
        });
        Predef$.MODULE$.println();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> wordToFeatures(String word, Seq<String> initialFeatures) {
        void var3_3;
        ArrayBuffer f = new ArrayBuffer();
        f.$plus$eq((Object)new StringBuilder().append((Object)"W=").append((Object)word).toString());
        f.$plus$plus$eq(initialFeatures);
        Object object = word.length() > 3 ? f.$plus$eq((Object)new StringBuilder().append((Object)"PRE=").append((Object)word.substring(0, 3)).toString()) : BoxedUnit.UNIT;
        Option option = this.Capitalized().findFirstMatchIn((CharSequence)word);
        None$ none$ = None$.MODULE$;
        Object object2 = !(option != null ? !option.equals(none$) : none$ != null) ? BoxedUnit.UNIT : f.$plus$eq((Object)"CAPITALIZED");
        Option option2 = this.Numeric().findFirstMatchIn((CharSequence)word);
        None$ none$2 = None$.MODULE$;
        Object object3 = !(option2 != null ? !option2.equals(none$2) : none$2 != null) ? BoxedUnit.UNIT : f.$plus$eq((Object)"NUMERIC");
        Option option3 = this.Punctuation().findFirstMatchIn((CharSequence)word);
        None$ none$3 = None$.MODULE$;
        Object object4 = !(option3 != null ? !option3.equals(none$3) : none$3 != null) ? BoxedUnit.UNIT : f.$plus$eq((Object)"PUNCTUATION");
        return var3_3;
    }

    public Regex Capitalized() {
        return this.Capitalized;
    }

    public Regex Numeric() {
        return this.Numeric;
    }

    public Regex Punctuation() {
        return this.Punctuation;
    }

    public void printLabel(ChainNERDemo.Label label) {
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%-16s TRUE=%-8s PRED=%-8s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{label.token().word(), ((CategoricalVariable)((Object)label.target())).categoryValue(), label.value().category(), label.token().toString()})));
    }

    public void printDiagnostic(Seq<ChainNERDemo.Label> labels2) {
        labels2.withFilter((Function1)new Serializable(){

            public final boolean apply(ChainNERDemo.Label label) {
                return label.intValue() != label.domain().index("O");
            }
        }).foreach((Function1)new Serializable(){

            public final void apply(ChainNERDemo.Label label) {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                if (!label.hasPrev()) break block4;
                                CategoricalValue categoricalValue = label.value();
                                CategoricalValue categoricalValue2 = label.prev().value();
                                if (!(categoricalValue == null ? categoricalValue2 != null : !categoricalValue.equals(categoricalValue2))) break block5;
                            }
                            Object[] objectArray = new Object[2];
                            CategoricalValue categoricalValue = label.value();
                            CategoricalValue categoricalValue3 = ((CategoricalVariable)((Object)label.target())).value();
                            objectArray[0] = !(categoricalValue != null ? !categoricalValue.equals(categoricalValue3) : categoricalValue3 != null) ? " " : new StringOps(Predef$.MODULE$.augmentString((String)((CategoricalVariable)((Object)label.target())).value().category())).drop(2);
                            objectArray[1] = new StringOps(Predef$.MODULE$.augmentString((String)label.value().category())).drop(2);
                            Predef$.MODULE$.print((Object)new StringOps(Predef$.MODULE$.augmentString("%-7s %-7s ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
                        }
                        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)label.token().word()).append((Object)" ").toString());
                        if (!label.hasNext()) break block6;
                        CategoricalValue categoricalValue = label.value();
                        CategoricalValue categoricalValue4 = label.next().value();
                        if (!(categoricalValue == null ? categoricalValue4 != null : !categoricalValue.equals(categoricalValue4))) break block7;
                    }
                    Predef$.MODULE$.println();
                }
            }
        });
        Predef$.MODULE$.println();
    }

    public Seq<ChainNERDemo.Sentence> load(String filename) {
        IntRef wordCount = IntRef.create((int)0);
        ObjectRef sentences = ObjectRef.create((Object)new ArrayBuffer());
        BufferedSource source = Source$.MODULE$.fromFile(new File(filename), Codec$.MODULE$.fallbackSystemCodec());
        ObjectRef sentence2 = ObjectRef.create((Object)new ChainNERDemo.Sentence());
        source.getLines().foreach((Function1)new Serializable(wordCount, sentences, sentence2){
            private final IntRef wordCount$1;
            private final ObjectRef sentences$1;
            private final ObjectRef sentence$1;

            public final void apply(String line) {
                if (line.length() < 2) {
                    ((ArrayBuffer)this.sentences$1.elem).$plus$eq((Object)((ChainNERDemo.Sentence)this.sentence$1.elem));
                    this.sentence$1.elem = new ChainNERDemo.Sentence();
                } else if (!line.startsWith("-DOCSTART-")) {
                    String[] fields = new StringOps(Predef$.MODULE$.augmentString(line)).split(' ');
                    Predef$.MODULE$.assert(fields.length == 4);
                    String word = fields[0];
                    String pos = fields[1];
                    String label = new StringOps(Predef$.MODULE$.augmentString(fields[3])).stripLineEnd();
                    ((ChainNERDemo.Sentence)this.sentence$1.elem).$plus$eq(new ChainNERDemo.Token(word, ChainNERDemo$.MODULE$.wordToFeatures(word, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"POS=").append((Object)pos).toString()})), label));
                    ++this.wordCount$1.elem;
                }
            }
            {
                this.wordCount$1 = wordCount$1;
                this.sentences$1 = sentences$1;
                this.sentence$1 = sentence$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Loaded ").append((Object)BoxesRunTime.boxToInteger((int)((ArrayBuffer)sentences.elem).length())).append((Object)" sentences with ").append((Object)BoxesRunTime.boxToInteger((int)wordCount.elem)).append((Object)" words total from file ").append((Object)filename).toString());
        return (ArrayBuffer)sentences.elem;
    }

    private ChainNERDemo$() {
        MODULE$ = this;
        this.model = new anon.1();
        this.objective = new HammingTemplate(ManifestFactory$.MODULE$.classType(ChainNERDemo.Label.class), (Manifest<TargetVar>)ManifestFactory$.MODULE$.classType(CategoricalTargetVariable.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        this.Capitalized = new StringOps(Predef$.MODULE$.augmentString("^[A-Z].*")).r();
        this.Numeric = new StringOps(Predef$.MODULE$.augmentString("^[0-9]+$")).r();
        this.Punctuation = new StringOps(Predef$.MODULE$.augmentString("[-,\\.;:?!()]+")).r();
    }
}

