/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.maths;

import cc.factorie.maths.package$Digamma$;
import cc.factorie.maths.package$FactorialCache$;
import cc.factorie.maths.package$LogGamma$;
import cc.factorie.maths.package$Probit$;
import cc.factorie.util.DoubleSeq;
import java.util.BitSet;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.util.Random;

public final class package$ {
    public static final package$ MODULE$;
    private final double log2;
    private double nextGaussianValue;
    private boolean haveNextGaussianValue;

    static {
        new package$();
    }

    public double logBinom(int x, int n, double p) {
        double cfr_ignored_0 = this.logFactorial(n) - this.logFactorial(x) - this.logFactorial(n - x);
        return (double)x * scala.math.package$.MODULE$.log(p) + (double)(n - x) * scala.math.package$.MODULE$.log(1.0 - p);
    }

    public double pbinom(int x, int n, double p) {
        DoubleRef sum2 = DoubleRef.create((double)Double.NEGATIVE_INFINITY);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), x).foreach$mVc$sp((Function1)new Serializable(n, p, sum2){
            private final int n$1;
            private final double p$1;
            private final DoubleRef sum$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.sum$2.elem = package$.MODULE$.sumLogProb(this.sum$2.elem, package$.MODULE$.logBinom(i, this.n$1, this.p$1));
            }
            {
                this.n$1 = n$1;
                this.p$1 = p$1;
                this.sum$2 = sum$2;
            }
        });
        return scala.math.package$.MODULE$.exp(sum2.elem);
    }

    public boolean almostEquals(double d1, double d2, double epsilon) {
        return scala.math.package$.MODULE$.abs(d1 - d2) < epsilon;
    }

    public double almostEquals$default$3() {
        return 1.0E-6;
    }

    public double numCombinations(int n, int r) {
        return scala.math.package$.MODULE$.exp(this.logFactorial(n) - this.logFactorial(r) - this.logFactorial(n - r));
    }

    public double numPermutations(int n, int r) {
        return scala.math.package$.MODULE$.exp(this.logFactorial(n) - this.logFactorial(r));
    }

    public double factorial(int n) {
        return n < package$FactorialCache$.MODULE$.size() ? (double)package$FactorialCache$.MODULE$.factorial(n) : scala.math.package$.MODULE$.exp(this.logGamma((double)n + 1.0));
    }

    public double logFactorial(int n) {
        return this.logGamma((double)n + 1.0);
    }

    public double digamma(double x) {
        return package$Digamma$.MODULE$.digamma(x);
    }

    public double logGamma(double xa) {
        return package$LogGamma$.MODULE$.logGamma(xa);
    }

    public double logBeta(double a, double b) {
        return this.logGamma(a) + this.logGamma(b) - this.logGamma(a + b);
    }

    public double beta(double a, double b) {
        return scala.math.package$.MODULE$.exp(this.logBeta(a, b));
    }

    public double gamma(double x) {
        return scala.math.package$.MODULE$.exp(this.logGamma(x));
    }

    public double log2() {
        return this.log2;
    }

    public double entropy(double[] p) {
        double result = 0.0;
        DoubleRef pv = DoubleRef.create((double)0.0);
        for (int i = p.length - 1; i >= 0; --i) {
            pv.elem = p[i];
            Predef$.MODULE$.require(pv.elem >= 0.0, (Function0)new Serializable(pv){
                private final DoubleRef pv$1;

                public final double apply() {
                    return this.apply$mcD$sp();
                }

                public double apply$mcD$sp() {
                    return this.pv$1.elem;
                }
                {
                    this.pv$1 = pv$1;
                }
            });
            Predef$.MODULE$.require(pv.elem <= 1.000001, (Function0)new Serializable(pv){
                private final DoubleRef pv$1;

                public final double apply() {
                    return this.apply$mcD$sp();
                }

                public double apply$mcD$sp() {
                    return this.pv$1.elem;
                }
                {
                    this.pv$1 = pv$1;
                }
            });
            if (!(pv.elem > 0.0)) continue;
            result -= pv.elem * scala.math.package$.MODULE$.log(pv.elem);
        }
        return result / this.log2();
    }

    public double klDivergence(double[] p1, double[] p2) {
        Predef$.MODULE$.assert(p1.length == p2.length);
        DoubleRef klDiv = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), p1.length).foreach$mVc$sp((Function1)new Serializable(p1, p2, klDiv){
            private final double[] p1$1;
            private final double[] p2$1;
            private final DoubleRef klDiv$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                if (this.p1$1[i] != 0.0) {
                    this.klDiv$1.elem += this.p1$1[i] * scala.math.package$.MODULE$.log(this.p1$1[i] / this.p2$1[i]);
                }
            }
            {
                this.p1$1 = p1$1;
                this.p2$1 = p2$1;
                this.klDiv$1 = klDiv$1;
            }
        });
        return klDiv.elem / this.log2();
    }

    public double jensenShannonDivergence(double[] p1, double[] p2) {
        Predef$.MODULE$.assert(p1.length == p2.length);
        double[] average = new double[p1.length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), p1.length).foreach$mVc$sp((Function1)new Serializable(p1, p2, average){
            private final double[] p1$2;
            private final double[] p2$2;
            private final double[] average$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.average$1[i] = this.average$1[i] + (this.p1$2[i] + this.p2$2[i]) / 2.0;
            }
            {
                this.p1$2 = p1$2;
                this.p2$2 = p2$2;
                this.average$1 = average$1;
            }
        });
        return (this.klDivergence(p1, average) + this.klDivergence(p2, average)) / 2.0;
    }

    public double sumLogProb(double a, double b) {
        return RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(a)) ? b : (RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(b)) ? a : (b < a ? a + scala.math.package$.MODULE$.log1p(scala.math.package$.MODULE$.exp(b - a)) : b + scala.math.package$.MODULE$.log1p(scala.math.package$.MODULE$.exp(a - b))));
    }

    public double sumLogProbs(double[] vals) {
        int i;
        double LOGTOLERANCE = 30.0;
        int len = vals.length;
        double max2 = vals[0];
        int maxIdx = 0;
        for (i = 1; i < len; ++i) {
            double v = vals[i];
            if (!(v > max2)) continue;
            max2 = v;
            maxIdx = i;
        }
        if (max2 == Double.NEGATIVE_INFINITY) {
            return max2;
        }
        boolean anyAdded = false;
        double intermediate = 0.0;
        double cutoff = max2 - LOGTOLERANCE;
        for (i = 0; i < len; ++i) {
            if (!(vals[i] >= cutoff) || i == maxIdx || Predef$.MODULE$.double2Double(vals[i]).isInfinite()) continue;
            anyAdded = true;
            intermediate += scala.math.package$.MODULE$.exp(vals[i] - max2);
        }
        return anyAdded ? max2 + scala.math.package$.MODULE$.log1p(intermediate) : max2;
    }

    public double sumLogProbs(DoubleSeq vals) {
        int i;
        double LOGTOLERANCE = 30.0;
        int len = vals.length();
        double max2 = vals.apply(0);
        int maxIdx = 0;
        for (i = 1; i < len; ++i) {
            double v = vals.apply(i);
            if (!(v > max2)) continue;
            max2 = v;
            maxIdx = i;
        }
        if (max2 == Double.NEGATIVE_INFINITY) {
            return max2;
        }
        boolean anyAdded = false;
        double intermediate = 0.0;
        double cutoff = max2 - LOGTOLERANCE;
        for (i = 0; i < len; ++i) {
            if (!(vals.apply(i) >= cutoff) || i == maxIdx || Predef$.MODULE$.double2Double(vals.apply(i)).isInfinite()) continue;
            anyAdded = true;
            intermediate += scala.math.package$.MODULE$.exp(vals.apply(i) - max2);
        }
        return anyAdded ? max2 + scala.math.package$.MODULE$.log1p(intermediate) : max2;
    }

    public double subtractLogProb(double a, double b) {
        return RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(b)) ? a : a + scala.math.package$.MODULE$.log(1.0 - scala.math.package$.MODULE$.exp(b - a));
    }

    public double poly(double[] coeff, double x) {
        double result = 0.0;
        for (int i = coeff.length - 1; i >= 0; --i) {
            result = result * x + coeff[i];
        }
        return result;
    }

    public double probit(double p) {
        if (p <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double q = p - 0.5;
        double r = 0.0;
        double g = 0.0;
        if (scala.math.package$.MODULE$.abs(q) <= package$Probit$.MODULE$.split1()) {
            r = package$Probit$.MODULE$.const1() - q * q;
            g = q * this.poly(package$Probit$.MODULE$.a(), r) / this.poly(package$Probit$.MODULE$.b(), r);
        } else {
            r = q < 0.0 ? p : 1.0 - p;
            if (r <= 0.0) {
                g = -1.0;
            } else {
                g = (r = scala.math.package$.MODULE$.sqrt(-scala.math.package$.MODULE$.log(r))) <= package$Probit$.MODULE$.split2() ? this.poly(package$Probit$.MODULE$.c(), r -= package$Probit$.MODULE$.const2()) / this.poly(package$Probit$.MODULE$.d(), r) : this.poly(package$Probit$.MODULE$.e(), r -= package$Probit$.MODULE$.split2()) / this.poly(package$Probit$.MODULE$.f(), r);
                if (q < 0.0) {
                    g = -g;
                }
            }
        }
        return g;
    }

    public double sigmoid(double beta) {
        return 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-beta));
    }

    public double sigmoid_rev(double sig) {
        return this.logit(sig);
    }

    public double logit(double p) {
        return scala.math.package$.MODULE$.log(p / (1.0 - p));
    }

    public double nextPoisson(double lambda, Random r) {
        int v = -1;
        double l = scala.math.package$.MODULE$.exp(-lambda);
        double p = 1.0;
        while (p >= l) {
            p *= this.nextUniform(r);
            ++v;
        }
        return v;
    }

    public double nextPoisson(Random r) {
        return this.nextPoisson(1.0, r);
    }

    public boolean nextBoolean(Random r) {
        return r.nextBoolean();
    }

    public boolean nextBoolean(double p, Random r) {
        return this.nextUniform(r) < p;
    }

    public BitSet nextBitSet(int size2, double p, Random r) {
        BitSet bs = new BitSet(size2);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size2).foreach$mVc$sp((Function1)new Serializable(p, r, bs){
            private final double p$2;
            private final Random r$1;
            private final BitSet bs$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                if (package$.MODULE$.nextBoolean(this.p$2, this.r$1)) {
                    this.bs$1.set(i);
                }
            }
            {
                this.p$2 = p$2;
                this.r$1 = r$1;
                this.bs$1 = bs$1;
            }
        });
        return bs;
    }

    public final double nextUniform(Random r) {
        return r.nextDouble();
    }

    public int nextDiscrete(double[] a, Random r) {
        int i;
        double b = 0.0;
        double s = this.nextUniform(r);
        for (i = 0; b <= s && i < a.length; b += a[i], ++i) {
            Predef$.MODULE$.assert(a[i] >= 0.0);
        }
        Predef$.MODULE$.assert(i > 0);
        return i - 1;
    }

    public int nextDiscrete(double[] a, double sum2, Random r) {
        int i;
        Predef$.MODULE$.assert(sum2 > 0.0, (Function0)new Serializable(sum2){
            private final double sum$1;

            public final String apply() {
                return new StringBuilder().append((Object)"sum = ").append((Object)BoxesRunTime.boxToDouble((double)this.sum$1)).toString();
            }
            {
                this.sum$1 = sum$1;
            }
        });
        double b = 0.0;
        double s = this.nextUniform(r) * sum2;
        for (i = 0; b <= s && i < a.length; b += a[i], ++i) {
            Predef$.MODULE$.assert(a[i] >= 0.0);
        }
        Predef$.MODULE$.assert(i > 0);
        return i - 1;
    }

    private double nextGaussianValue() {
        return this.nextGaussianValue;
    }

    private void nextGaussianValue_$eq(double x$1) {
        this.nextGaussianValue = x$1;
    }

    private boolean haveNextGaussianValue() {
        return this.haveNextGaussianValue;
    }

    private void haveNextGaussianValue_$eq(boolean x$1) {
        this.haveNextGaussianValue = x$1;
    }

    public double nextGaussian(Random r) {
        while (this.haveNextGaussianValue()) {
            this.haveNextGaussianValue_$eq(false);
        }
        double v1 = this.nextUniform(r);
        double v2 = this.nextUniform(r);
        double x1 = scala.math.package$.MODULE$.sqrt((double)-2 * scala.math.package$.MODULE$.log(v1)) * scala.math.package$.MODULE$.cos(Math.PI * 2 * v2);
        double x2 = scala.math.package$.MODULE$.sqrt((double)-2 * scala.math.package$.MODULE$.log(v1)) * scala.math.package$.MODULE$.sin(Math.PI * 2 * v2);
        this.nextGaussianValue_$eq(x2);
        this.haveNextGaussianValue_$eq(true);
        return x1;
    }

    public double nextGaussian(double mean, double s2, Random r) {
        return this.nextGaussian(r) * scala.math.package$.MODULE$.sqrt(s2) + mean;
    }

    public double nextGamma(Random r) {
        return this.nextGamma(1.0, 1.0, 0.0, r);
    }

    public double nextGamma(double alpha, Random r) {
        return this.nextGamma(alpha, 1.0, 0.0, r);
    }

    public double nextGamma(double alpha, double beta, Random r) {
        return this.nextGamma(alpha, beta, 0.0, r);
    }

    public double nextGamma(double alpha, double beta, double lambda, Random r) {
        double gamma = 0.0;
        if (alpha <= 0.0 || beta <= 0.0) {
            throw new IllegalArgumentException("alpha and beta must be strictly positive.");
        }
        if (alpha < 1.0) {
            double p = 0.0;
            boolean flag = false;
            double b = 1.0 + alpha * scala.math.package$.MODULE$.exp(-1.0);
            while (!flag) {
                p = b * this.nextUniform(r);
                if (p > 1.0) {
                    gamma = -scala.math.package$.MODULE$.log((b - p) / alpha);
                    if (!(this.nextUniform(r) <= scala.math.package$.MODULE$.pow(gamma, alpha - 1.0))) continue;
                    flag = true;
                    continue;
                }
                gamma = scala.math.package$.MODULE$.pow(p, 1.0 / alpha);
                if (!(this.nextUniform(r) <= scala.math.package$.MODULE$.exp(-gamma))) continue;
                flag = true;
            }
        } else if (alpha == 1.0) {
            gamma = -scala.math.package$.MODULE$.log(this.nextUniform(r));
        } else {
            double y = -scala.math.package$.MODULE$.log(this.nextUniform(r));
            while (this.nextUniform(r) > scala.math.package$.MODULE$.pow(y * scala.math.package$.MODULE$.exp(1.0 - y), alpha - 1.0)) {
                y = -scala.math.package$.MODULE$.log(this.nextUniform(r));
            }
            gamma = alpha * y;
        }
        return beta * gamma + lambda;
    }

    public double nextExp(Random r) {
        return this.nextGamma(1.0, 1.0, 0.0, r);
    }

    public double nextExp(double beta, Random r) {
        return this.nextGamma(1.0, beta, 0.0, r);
    }

    public double nextExp(double beta, double lambda, Random r) {
        return this.nextGamma(1.0, beta, lambda, r);
    }

    public double nextChiSq(Random r) {
        return this.nextGamma(0.5, 2.0, 0.0, r);
    }

    public double nextChiSq(int df, Random r) {
        return this.nextGamma(0.5 * (double)df, 2.0, 0.0, r);
    }

    public double nextChiSq(int df, double lambda, Random r) {
        return this.nextGamma(0.5 * (double)df, 2.0, lambda, r);
    }

    public double nextBeta(double alpha, double beta, Random r) {
        double d;
        if (alpha <= 0.0 || beta <= 0.0) {
            throw new IllegalArgumentException("alpha and beta must be strictly positive.");
        }
        if (alpha == 1.0 && beta == 1.0) {
            d = this.nextUniform(r);
        } else if (alpha >= 1.0 && beta >= 1.0) {
            double A2 = alpha - 1.0;
            double B = beta - 1.0;
            double C = A2 + B;
            double L = C * scala.math.package$.MODULE$.log(C);
            double mu = A2 / C;
            double sigma = 0.5 / scala.math.package$.MODULE$.sqrt(C);
            double y = this.nextGaussian(r);
            double x = sigma * y + mu;
            while (x < 0.0 || x > 1.0) {
                y = this.nextGaussian(r);
                x = sigma * y + mu;
            }
            double u = this.nextUniform(r);
            while (scala.math.package$.MODULE$.log(u) >= A2 * scala.math.package$.MODULE$.log(x / A2) + B * scala.math.package$.MODULE$.log((1.0 - x) / B) + L + 0.5 * y * y) {
                y = this.nextGaussian(r);
                x = sigma * y + mu;
                while (x < 0.0 || x > 1.0) {
                    y = this.nextGaussian(r);
                    x = sigma * y + mu;
                }
                u = this.nextUniform(r);
            }
            d = x;
        } else {
            double v1 = scala.math.package$.MODULE$.pow(this.nextUniform(r), 1.0 / alpha);
            double v2 = scala.math.package$.MODULE$.pow(this.nextUniform(r), 1.0 / beta);
            while (v1 + v2 > 1.0) {
                v1 = scala.math.package$.MODULE$.pow(this.nextUniform(r), 1.0 / alpha);
                v2 = scala.math.package$.MODULE$.pow(this.nextUniform(r), 1.0 / beta);
            }
            d = v1 / (v1 + v2);
        }
        return d;
    }

    public double sampleMean(DoubleSeq ds) {
        return ds.sum() / (double)ds.length();
    }

    public double sampleVariance(DoubleSeq ds) {
        return this.sampleVariance(ds, this.sampleMean(ds));
    }

    public double sampleVariance(DoubleSeq ds, double mean) {
        int len = ds.length();
        double v = 0.0;
        for (int i = 0; i < len; ++i) {
            double diff = mean - ds.apply(i);
            v += diff * diff;
        }
        return v / (double)(len - 1);
    }

    public double cosh(double a) {
        return a < 0.0 ? 0.5 * (scala.math.package$.MODULE$.exp(-a) + scala.math.package$.MODULE$.exp(a)) : 0.5 * (scala.math.package$.MODULE$.exp(a) + scala.math.package$.MODULE$.exp(-a));
    }

    public double tanh(double a) {
        return (scala.math.package$.MODULE$.exp(a) - scala.math.package$.MODULE$.exp(-a)) / (scala.math.package$.MODULE$.exp(a) + scala.math.package$.MODULE$.exp(-a));
    }

    private package$() {
        MODULE$ = this;
        this.log2 = scala.math.package$.MODULE$.log(2.0);
        this.nextGaussianValue = 0.0;
        this.haveNextGaussianValue = false;
    }
}

