/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.pos;

import cc.factorie.app.chain.Observations$;
import cc.factorie.app.nlp.Sentence;
import cc.factorie.app.nlp.Token;
import cc.factorie.app.nlp.pos.ChainPosTagger;
import cc.factorie.app.nlp.pos.PennPosTag;
import cc.factorie.app.strings.package$;
import java.net.URL;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m2A!\u0001\u0002\u0001\u001b\t\trk\u0015&DQ\u0006Lg\u000eU8t)\u0006<w-\u001a:\u000b\u0005\r!\u0011a\u00019pg*\u0011QAB\u0001\u0004]2\u0004(BA\u0004\t\u0003\r\t\u0007\u000f\u001d\u0006\u0003\u0013)\t\u0001BZ1di>\u0014\u0018.\u001a\u0006\u0002\u0017\u0005\u00111mY\u0002\u0001'\t\u0001a\u0002E\u0002\u0010!Ii\u0011AA\u0005\u0003#\t\u0011ab\u00115bS:\u0004vn\u001d+bO\u001e,'\u000f\u0005\u0002\u0010'%\u0011AC\u0001\u0002\u000b!\u0016tg\u000eU8t)\u0006<\u0007\"\u0002\f\u0001\t\u00039\u0012A\u0002\u001fj]&$h\bF\u0001\u0019!\ty\u0001\u0001C\u0003\u0017\u0001\u0011\u0005!\u0004\u0006\u0002\u00197!)A$\u0007a\u0001;\u0005\u0019QO\u001d7\u0011\u0005y\u0019S\"A\u0010\u000b\u0005\u0001\n\u0013a\u00018fi*\t!%\u0001\u0003kCZ\f\u0017B\u0001\u0013 \u0005\r)&\u000b\u0014\u0005\u0006M\u0001!\taJ\u0001\u0010S:LG\u000fU(T\r\u0016\fG/\u001e:fgR\u0011\u0001F\f\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0005+:LG\u000fC\u00030K\u0001\u0007\u0001'\u0001\u0005tK:$XM\\2f!\t\t$'D\u0001\u0005\u0013\t\u0019DA\u0001\u0005TK:$XM\\2f\u000f\u0015)$\u0001#\u00017\u0003E96KS\"iC&t\u0007k\\:UC\u001e<WM\u001d\t\u0003\u001f]2Q!\u0001\u0002\t\u0002a\u001a\"a\u000e\r\t\u000bY9D\u0011\u0001\u001e\u0015\u0003Y\u0002")
public class WSJChainPosTagger
extends ChainPosTagger<PennPosTag> {
    @Override
    public void initPOSFeatures(Sentence sentence2) {
        sentence2.tokens().foreach((Function1)new Serializable(this){
            private final /* synthetic */ WSJChainPosTagger $outer;

            public final void apply(Token token) {
                if (token.attr().apply(ClassTag$.MODULE$.apply(ChainPosTagger.PosFeatures.class)) != null) {
                    token.attr().remove(ClassTag$.MODULE$.apply(ChainPosTagger.PosFeatures.class));
                }
                ChainPosTagger.PosFeatures features2 = token.attr().$plus$eq(new ChainPosTagger.PosFeatures(this.$outer, token));
                String rawWord = token.string();
                String word = package$.MODULE$.simplifyDigits(rawWord).toLowerCase();
                features2.$plus$eq(new StringBuilder().append((Object)"W=").append((Object)word).toString());
                features2.$plus$eq(new StringBuilder().append((Object)"STEM=").append((Object)package$.MODULE$.porterStem(word)).toString());
                features2.$plus$eq(new StringBuilder().append((Object)"SHAPE2=").append((Object)package$.MODULE$.stringShape(rawWord, 2)).toString());
                features2.$plus$eq(new StringBuilder().append((Object)"SHAPE3=").append((Object)package$.MODULE$.stringShape(rawWord, 3)).toString());
                int i = 3;
                features2.$plus$eq(new StringBuilder().append((Object)"SUFFIX").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)"=").append(new StringOps(Predef$.MODULE$.augmentString(word)).takeRight(i)).toString());
                features2.$plus$eq(new StringBuilder().append((Object)"PREFIX").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)"=").append(new StringOps(Predef$.MODULE$.augmentString(word)).take(i)).toString());
                if (token.isCapitalized()) {
                    features2.$plus$eq("CAPITALIZED");
                }
                if (token.string().matches("[A-Z]")) {
                    features2.$plus$eq("CONTAINS_CAPITAL");
                }
                if (token.string().matches("-")) {
                    features2.$plus$eq("CONTAINS_DASH");
                }
                if (token.containsDigit()) {
                    features2.$plus$eq("NUMERIC");
                }
                if (token.isPunctuation()) {
                    features2.$plus$eq("PUNCTUATION");
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Observations$.MODULE$.addNeighboringFeatureConjunctions(sentence2.tokens(), new Serializable(this){

            public final ChainPosTagger.PosFeatures apply(Token t) {
                return (ChainPosTagger.PosFeatures)t.attr().apply(ClassTag$.MODULE$.apply(ChainPosTagger.PosFeatures.class));
            }
        }, "W=[^@]*$", (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-2})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-2, -1})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1, 0}))}));
    }

    public WSJChainPosTagger() {
        super(new Serializable(){

            public final PennPosTag apply(Token t) {
                return new PennPosTag(t, 0);
            }
        }, ClassTag$.MODULE$.apply(PennPosTag.class));
    }

    public WSJChainPosTagger(URL url) {
        this();
        this.deserialize(url.openConnection().getInputStream());
    }
}

