/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.phrase;

import cc.factorie.app.nlp.Sentence;
import cc.factorie.app.nlp.Token;
import cc.factorie.app.nlp.lexicon.Preposition$;
import cc.factorie.app.nlp.parse.ParseTree;
import cc.factorie.app.nlp.phrase.Phrase;
import scala.Serializable;
import scala.collection.IndexedSeq;
import scala.math.package$;

public final class HeadTokenOffset$ {
    public static final HeadTokenOffset$ MODULE$;

    static {
        new HeadTokenOffset$();
    }

    public int apply(Phrase phrase) {
        if (phrase.length() == 1) {
            return 0;
        }
        IndexedSeq span = phrase.value();
        Sentence sentence2 = phrase.sentence();
        ParseTree parse2 = sentence2.parse();
        if (parse2 != null) {
            int headSentenceIndex = package$.MODULE$.min(span.end(), sentence2.end()) - 1 - sentence2.start();
            int parentSentenceIndex = parse2.parentIndex(headSentenceIndex);
            while (span.contains(parentSentenceIndex + sentence2.start())) {
                headSentenceIndex = parentSentenceIndex;
                parentSentenceIndex = parse2.parentIndex(parentSentenceIndex);
            }
            if (parentSentenceIndex >= 0) {
                parentSentenceIndex = parse2.parentIndex(parentSentenceIndex);
                while (span.contains(parentSentenceIndex + sentence2.start())) {
                    headSentenceIndex = parentSentenceIndex;
                    parentSentenceIndex = parse2.parentIndex(parentSentenceIndex);
                }
            }
            return headSentenceIndex + sentence2.start() - span.start();
        }
        int prepositionIndex = span.indexWhere(new Serializable(){

            public final boolean apply(Token x$1) {
                return Preposition$.MODULE$.contains(x$1);
            }
        });
        if (prepositionIndex >= 1) {
            return prepositionIndex - 1;
        }
        int lastNounIndex = span.lastIndexWhere(new Serializable(){

            public final boolean apply(Token x$2) {
                return x$2.posTag().isNoun();
            }
        });
        if (lastNounIndex > 0) {
            return lastNounIndex;
        }
        return span.length() - 1;
    }

    private HeadTokenOffset$() {
        MODULE$ = this;
    }
}

