/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.parse;

import cc.factorie.app.nlp.Document;
import cc.factorie.app.nlp.Sentence;
import cc.factorie.app.nlp.load.LoadConll2008$;
import cc.factorie.app.nlp.load.LoadOntonotes5$;
import cc.factorie.app.nlp.parse.ProjectiveGraphBasedParser;
import cc.factorie.app.nlp.parse.ProjectiveGraphBasedParserOpts$;
import cc.factorie.package$;
import cc.factorie.util.BoxedDouble;
import cc.factorie.util.CmdOptions;
import cc.factorie.util.FileUtils$;
import cc.factorie.util.HyperparameterMain;
import cc.factorie.util.HyperparameterMain$class;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

public final class ProjectiveGraphBasedParserTrainer$
implements HyperparameterMain {
    public static final ProjectiveGraphBasedParserTrainer$ MODULE$;

    static {
        new ProjectiveGraphBasedParserTrainer$();
    }

    @Override
    public final void main(String[] args) {
        HyperparameterMain$class.main(this, args);
    }

    @Override
    public final BoxedDouble actualMain(String[] args) {
        return HyperparameterMain$class.actualMain(this, args);
    }

    @Override
    public double evaluateParameters(String[] args) {
        ProjectiveGraphBasedParserOpts$ opts = ProjectiveGraphBasedParserOpts$.MODULE$;
        opts.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        ProjectiveGraphBasedParser parser = new ProjectiveGraphBasedParser();
        Predef$.MODULE$.assert(opts.trainFile().wasInvoked() || opts.trainDir().wasInvoked());
        Seq trainSentencesFull = this.loadSentences$1(opts.trainFile(), opts.trainDir(), opts);
        Seq testSentencesFull = this.loadSentences$1(opts.testFile(), opts.testDir(), opts);
        double trainPortionToTake = opts.trainPortion().wasInvoked() ? BoxesRunTime.unboxToDouble((Object)opts.trainPortion().value()) : 1.0;
        double testPortionToTake = opts.testPortion().wasInvoked() ? BoxesRunTime.unboxToDouble((Object)opts.testPortion().value()) : 1.0;
        Seq trainSentences = (Seq)trainSentencesFull.take((int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(trainPortionToTake * (double)trainSentencesFull.length())));
        Seq testSentences = (Seq)testSentencesFull.take((int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(testPortionToTake * (double)testSentencesFull.length())));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Total train sentences: ").append((Object)BoxesRunTime.boxToInteger((int)trainSentences.size())).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Total test sentences: ").append((Object)BoxesRunTime.boxToInteger((int)testSentences.size())).toString());
        parser.train((Seq<Sentence>)trainSentences, (Seq<Sentence>)testSentences, opts.model().value(), scala.math.package$.MODULE$.min(BoxesRunTime.unboxToInt((Object)opts.nThreads().value()), Runtime.getRuntime().availableProcessors()), parser.train$default$5());
        Predef$.MODULE$.println((Object)"Predicting train set...");
        Tuple4<Object, Object, Object, Object> tuple4 = parser.test((Iterable<Sentence>)trainSentences);
        if (tuple4 != null) {
            Tuple4 tuple42;
            double trainLAS = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double trainUAS = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            double trainTokSpeed = BoxesRunTime.unboxToDouble((Object)tuple4._3());
            double trainSentSpeed = BoxesRunTime.unboxToDouble((Object)tuple4._4());
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)trainLAS), (Object)BoxesRunTime.boxToDouble((double)trainUAS), (Object)BoxesRunTime.boxToDouble((double)trainTokSpeed), (Object)BoxesRunTime.boxToDouble((double)trainSentSpeed));
            double trainLAS2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
            double trainUAS2 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
            double trainTokSpeed2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
            double trainSentSpeed2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training UAS=", ", LAS=", ", ", " tokens/sec, ", " sentences/sec"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)trainUAS2), BoxesRunTime.boxToDouble((double)trainLAS2), BoxesRunTime.boxToDouble((double)trainTokSpeed2), BoxesRunTime.boxToDouble((double)trainSentSpeed2)})));
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Predicting test set...");
            Tuple4<Object, Object, Object, Object> tuple44 = parser.test((Iterable<Sentence>)testSentences);
            if (tuple44 != null) {
                Tuple4 tuple45;
                double testLAS = BoxesRunTime.unboxToDouble((Object)tuple44._1());
                double testUAS = BoxesRunTime.unboxToDouble((Object)tuple44._2());
                double testTokSpeed = BoxesRunTime.unboxToDouble((Object)tuple44._3());
                double testSentSpeed = BoxesRunTime.unboxToDouble((Object)tuple44._4());
                Tuple4 tuple46 = tuple45 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)testLAS), (Object)BoxesRunTime.boxToDouble((double)testUAS), (Object)BoxesRunTime.boxToDouble((double)testTokSpeed), (Object)BoxesRunTime.boxToDouble((double)testSentSpeed));
                double testLAS2 = BoxesRunTime.unboxToDouble((Object)tuple46._1());
                double testUAS2 = BoxesRunTime.unboxToDouble((Object)tuple46._2());
                double testTokSpeed2 = BoxesRunTime.unboxToDouble((Object)tuple46._3());
                double testSentSpeed2 = BoxesRunTime.unboxToDouble((Object)tuple46._4());
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training UAS=", ", LAS=", ", ", " tokens/sec, ", " sentences/sec"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)testUAS2), BoxesRunTime.boxToDouble((double)testLAS2), BoxesRunTime.boxToDouble((double)testTokSpeed2), BoxesRunTime.boxToDouble((double)testSentSpeed2)})));
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Done.");
                if (opts.targetAccuracy().wasInvoked()) {
                    package$.MODULE$.assertMinimalAccuracy(testUAS2, new StringOps(Predef$.MODULE$.augmentString(opts.targetAccuracy().value())).toDouble());
                }
                return testUAS2;
            }
            throw new MatchError(tuple44);
        }
        throw new MatchError(tuple4);
    }

    private final Seq loadSentences$1(CmdOptions.CmdOption fileOpt, CmdOptions.CmdOption dirOpt, ProjectiveGraphBasedParserOpts$ opts$1) {
        String fileExt = BoxesRunTime.unboxToBoolean((Object)opts$1.ontonotes().value()) ? ".dep.pmd" : "";
        Seq fileList = (Seq)Seq$.MODULE$.empty();
        if (fileOpt.wasInvoked()) {
            fileList = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)fileOpt.value()}));
        }
        if (dirOpt.wasInvoked()) {
            fileList = (Seq)fileList.$plus$plus(FileUtils$.MODULE$.getFileListFromDir((String)dirOpt.value(), fileExt), Seq$.MODULE$.canBuildFrom());
        }
        return (Seq)fileList.flatMap((Function1)new Serializable(opts$1){
            private final ProjectiveGraphBasedParserOpts$ opts$1;

            public final Seq<Sentence> apply(String fname) {
                return ((Document)(BoxesRunTime.unboxToBoolean((Object)this.opts$1.ontonotes().value()) ? LoadOntonotes5$.MODULE$.fromFilename(fname, LoadOntonotes5$.MODULE$.fromFilename$default$2(), LoadOntonotes5$.MODULE$.fromFilename$default$3(), LoadOntonotes5$.MODULE$.fromFilename$default$4(), LoadOntonotes5$.MODULE$.fromFilename$default$5(), LoadOntonotes5$.MODULE$.fromFilename$default$6()) : LoadConll2008$.MODULE$.fromFilename(fname)).head()).sentences().toSeq();
            }
            {
                this.opts$1 = opts$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private ProjectiveGraphBasedParserTrainer$() {
        MODULE$ = this;
        HyperparameterMain$class.$init$(this);
    }
}

