/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.ner;

import cc.factorie.app.nlp.Document;
import cc.factorie.app.nlp.load.LoadConll2003;
import cc.factorie.app.nlp.ner.ConllStackedChainNer;
import cc.factorie.app.nlp.ner.ConllStackedChainNer$;
import cc.factorie.app.nlp.ner.StackedChainNerOpts;
import cc.factorie.package$;
import cc.factorie.util.BoxedDouble;
import cc.factorie.util.HyperparameterMain;
import cc.factorie.util.HyperparameterMain$class;
import java.io.FileOutputStream;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

public final class ConllStackedChainNerTrainer$
implements HyperparameterMain {
    public static final ConllStackedChainNerTrainer$ MODULE$;

    static {
        new ConllStackedChainNerTrainer$();
    }

    @Override
    public final void main(String[] args) {
        HyperparameterMain$class.main(this, args);
    }

    @Override
    public final BoxedDouble actualMain(String[] args) {
        return HyperparameterMain$class.actualMain(this, args);
    }

    @Override
    public double evaluateParameters(String[] args) {
        StackedChainNerOpts opts = new StackedChainNerOpts();
        opts.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        ConllStackedChainNer ner = new ConllStackedChainNer(null, BoxesRunTime.unboxToInt((Object)opts.embeddingDim().value()), BoxesRunTime.unboxToDouble((Object)opts.embeddingScale().value()), BoxesRunTime.unboxToBoolean((Object)opts.useOffsetEmbedding().value()), ConllStackedChainNer$.MODULE$.$lessinit$greater$default$5());
        ner.aggregate_$eq(opts.aggregateTokens().wasInvoked());
        if (opts.brownClusFile().wasInvoked()) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Reading brown cluster file ").append((Object)opts.brownClusFile().value()).toString());
            Source$.MODULE$.fromFile(opts.brownClusFile().value(), Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable(ner){
                private final ConllStackedChainNer ner$1;

                public final void apply(String line) {
                    String[] splitLine = line.split("\t");
                    this.ner$1.clusters().update((Object)splitLine[1], (Object)splitLine[0]);
                }
                {
                    this.ner$1 = ner$1;
                }
            });
        }
        double trainPortionToTake = opts.trainPortion().wasInvoked() ? BoxesRunTime.unboxToDouble((Object)opts.trainPortion().value()) : 1.0;
        double testPortionToTake = opts.testPortion().wasInvoked() ? BoxesRunTime.unboxToDouble((Object)opts.testPortion().value()) : 1.0;
        Seq<Document> trainDocsFull = new LoadConll2003(true).fromFilename(opts.trainFile().value());
        Seq<Document> testDocsFull = new LoadConll2003(true).fromFilename(opts.testFile().value());
        Seq trainDocs = (Seq)trainDocsFull.take((int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((double)trainDocsFull.length() * trainPortionToTake)));
        Seq testDocs = (Seq)testDocsFull.take((int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((double)testDocsFull.length() * testPortionToTake)));
        double result = ner.train((Seq<Document>)trainDocs, (Seq<Document>)testDocs, BoxesRunTime.unboxToDouble((Object)opts.rate().value()), BoxesRunTime.unboxToDouble((Object)opts.delta().value()));
        if (BoxesRunTime.unboxToBoolean((Object)opts.saveModel().value())) {
            ner.serialize(new FileOutputStream(opts.modelDir().value()));
        }
        if (opts.targetAccuracy().wasInvoked()) {
            package$.MODULE$.assertMinimalAccuracy(result, new StringOps(Predef$.MODULE$.augmentString(opts.targetAccuracy().value())).toDouble());
        }
        return result;
    }

    private ConllStackedChainNerTrainer$() {
        MODULE$ = this;
        HyperparameterMain$class.$init$(this);
    }
}

