/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.load;

import cc.factorie.app.nlp.Document;
import cc.factorie.app.nlp.coref.Mention;
import cc.factorie.app.nlp.coref.WithinDocCoref;
import cc.factorie.app.nlp.coref.WithinDocEntity;
import cc.factorie.app.nlp.load.Conll2011Iterator;
import cc.factorie.app.nlp.phrase.OntonotesPhraseEntityType;
import cc.factorie.variable.CategoricalLabeling;
import cc.factorie.variable.CategoricalVar;
import java.io.File;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;

public final class LoadConllCoreference$ {
    public static final LoadConllCoreference$ MODULE$;

    static {
        new LoadConllCoreference$();
    }

    public Seq<Document> load(String goldFilename, int limitNumDocuments, boolean loadFromParse, Option<String> autoDirOpt) {
        Conll2011Iterator conllLoader = new Conll2011Iterator(goldFilename, loadFromParse, (Option<File>)autoDirOpt.map((Function1)new Serializable(){

            public final File apply(String x$1) {
                return new File(x$1);
            }
        }));
        ArrayBuffer docs = new ArrayBuffer();
        while (conllLoader.hasNext() && (limitNumDocuments == -1 || docs.size() < limitNumDocuments)) {
            docs.$plus$eq((Object)conllLoader.next());
        }
        this.disperseEntityTypes((Seq<WithinDocCoref>)((Seq)docs.map((Function1)new Serializable(){

            public final WithinDocCoref apply(Document x$2) {
                return x$2.getTargetCoref();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())));
        if (autoDirOpt.isDefined()) {
            this.disperseEntityTypes((Seq<WithinDocCoref>)((Seq)docs.map((Function1)new Serializable(){

                public final WithinDocCoref apply(Document x$3) {
                    return x$3.getCoref();
                }
            }, ArrayBuffer$.MODULE$.canBuildFrom())));
        }
        return docs;
    }

    public Option<String> load$default$4() {
        return None$.MODULE$;
    }

    public void disperseEntityTypes(Seq<WithinDocCoref> corefDocs) {
        corefDocs.foreach((Function1)new Serializable(){

            public final void apply(WithinDocCoref corefDoc) {
                Map entities = (Map)corefDoc.mentions().toSeq().groupBy((Function1)new Serializable(this){

                    public final WithinDocEntity apply(Mention m) {
                        return m.entity();
                    }
                }).filter((Function1)new Serializable(this){

                    public final boolean apply(Tuple2<WithinDocEntity, Seq<Mention>> x) {
                        return ((SeqLike)x._2()).length() > 1;
                    }
                });
                entities.foreach((Function1)new Serializable(this){

                    public final void apply(Tuple2<WithinDocEntity, Seq<Mention>> ent) {
                        Seq entityTypes = (Seq)((SeqLike)((TraversableLike)((TraversableLike)ent._2()).map((Function1)new Serializable(this){

                            public final String apply(Mention m) {
                                return (String)((CategoricalVar)m.phrase().attr().apply(ClassTag$.MODULE$.apply(OntonotesPhraseEntityType.class))).categoryValue();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){

                            public final boolean apply(String t) {
                                String string = t;
                                String string2 = "O";
                                return string != null ? !string.equals(string2) : string2 != null;
                            }
                        })).distinct();
                        if (entityTypes.length() > 0) {
                            String newType = (String)entityTypes.apply(0);
                            ((IterableLike)ent._2()).foreach((Function1)new Serializable(this, newType){
                                private final String newType$1;

                                public final void apply(Mention m) {
                                    ((CategoricalLabeling)m.phrase().attr().apply(ClassTag$.MODULE$.apply(OntonotesPhraseEntityType.class))).target().setCategory(this.newType$1, null);
                                }
                                {
                                    this.newType$1 = newType$1;
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    private LoadConllCoreference$() {
        MODULE$ = this;
    }
}

