/*
 * Decompiled with CFR 0.152.
 */
package cc.factorie.app.nlp.coref;

import cc.factorie.app.nlp.Document;
import cc.factorie.app.nlp.DocumentAnnotator;
import cc.factorie.app.nlp.DocumentAnnotatorPipeline$;
import cc.factorie.app.nlp.MutableDocumentAnnotatorMap;
import cc.factorie.app.nlp.coref.CorefConllOutput;
import cc.factorie.app.nlp.coref.CorefOptions;
import cc.factorie.app.nlp.coref.CorefTrainer$;
import cc.factorie.app.nlp.coref.CorefTrainerOpts;
import cc.factorie.app.nlp.coref.Mention;
import cc.factorie.app.nlp.coref.MentionAlignment$;
import cc.factorie.app.nlp.load.LoadConll2011$;
import cc.factorie.app.nlp.ner.ConllChainNer$;
import cc.factorie.app.nlp.ner.NerTag;
import cc.factorie.app.nlp.phrase.DeterministicNounPhraseTypeLabeler$;
import cc.factorie.app.nlp.phrase.NounPhraseEntityTypeLabeler$;
import cc.factorie.app.nlp.phrase.NounPhraseGenderLabeler$;
import cc.factorie.app.nlp.phrase.NounPhraseNumberLabeler$;
import cc.factorie.app.nlp.phrase.OntonotesPhraseEntityType;
import cc.factorie.util.BoxedDouble;
import cc.factorie.util.HyperparameterMain;
import cc.factorie.util.HyperparameterMain$class;
import cc.factorie.util.Trackable;
import cc.factorie.util.Trackable$class;
import java.io.File;
import java.io.PrintStream;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q4Q!\u0001\u0002\u0002\u00025\u0011AbQ8sK\u001a$&/Y5oKJT!a\u0001\u0003\u0002\u000b\r|'/\u001a4\u000b\u0005\u00151\u0011a\u00018ma*\u0011q\u0001C\u0001\u0004CB\u0004(BA\u0005\u000b\u0003!1\u0017m\u0019;pe&,'\"A\u0006\u0002\u0005\r\u001c7\u0001A\n\u0005\u00019!\"\u0004\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tA!\u001e;jY&\u0011\u0011D\u0006\u0002\u0013\u0011f\u0004XM\u001d9be\u0006lW\r^3s\u001b\u0006Lg\u000e\u0005\u0002\u00167%\u0011AD\u0006\u0002\n)J\f7m[1cY\u0016DQA\b\u0001\u0005\u0002}\ta\u0001P5oSRtD#\u0001\u0011\u0011\u0005\u0005\u0002Q\"\u0001\u0002\t\u000b\r\u0002a\u0011\u0001\u0013\u0002%\u00154\u0018\r\\;bi\u0016\u0004\u0016M]1nKR,'o\u001d\u000b\u0003K!\u0002\"a\u0004\u0014\n\u0005\u001d\u0002\"A\u0002#pk\ndW\rC\u0003*E\u0001\u0007!&\u0001\u0003be\u001e\u001c\bcA\b,[%\u0011A\u0006\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003]Er!aD\u0018\n\u0005A\u0002\u0012A\u0002)sK\u0012,g-\u0003\u00023g\t11\u000b\u001e:j]\u001eT!\u0001\r\t\t\u000bU\u0002a\u0011\u0001\u001c\u0002\t=\u0004Ho]\u000b\u0002oA\u0011\u0011\u0005O\u0005\u0003s\t\u0011\u0001cQ8sK\u001a$&/Y5oKJ|\u0005\u000f^:\t\u000bm\u0002A\u0011\u0001\u001f\u0002/\u0005$GmR3oI\u0016\u0014h*^7cKJd\u0015MY3mS:<GcA\u001fA%B\u0011qBP\u0005\u0003\u007fA\u0011A!\u00168ji\")\u0011I\u000fa\u0001\u0005\u0006IAO]1j]\u0012{7m\u001d\t\u0004\u0007.seB\u0001#J\u001d\t)\u0005*D\u0001G\u0015\t9E\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0011!\nE\u0001\ba\u0006\u001c7.Y4f\u0013\taUJA\u0002TKFT!A\u0013\t\u0011\u0005=\u0003V\"\u0001\u0003\n\u0005E#!\u0001\u0003#pGVlWM\u001c;\t\u000bMS\u0004\u0019\u0001\"\u0002\u0011Q,7\u000f\u001e#pGNDQ!\u0016\u0001\u0005\u0002Y\u000bq$\\1lKR\u0013\u0018-\u001b8UKN$H)\u0019;b\u000f>dGMQ8v]\u0012\f'/[3t)\u00119&\f\u00180\u0011\t=A&IQ\u0005\u00033B\u0011a\u0001V;qY\u0016\u0014\u0004\"B.U\u0001\u0004i\u0013!\u0003;sC&tg)\u001b7f\u0011\u0015iF\u000b1\u0001.\u0003!!Xm\u001d;GS2,\u0007\"B0U\u0001\u0004\u0001\u0017!\u00037pC\u0012$&/Y5o!\ty\u0011-\u0003\u0002c!\t9!i\\8mK\u0006t\u0007\"\u00023\u0001\t\u0003)\u0017!E7bW\u0016$&/Y5o)\u0016\u001cH\u000fR1uCR1qKZ4i[:DQaW2A\u00025BQ!X2A\u00025BQ![2A\u0002)\fqa\u001c9uS>t7\u000f\u0005\u0002\"W&\u0011AN\u0001\u0002\r\u0007>\u0014XMZ(qi&|gn\u001d\u0005\u0006?\u000e\u0004\r\u0001\u0019\u0005\u0006_\u000e\u0004\r\u0001Y\u0001\u000fkN,g*\u001a:NK:$\u0018n\u001c8t\u0011\u0015\t\b\u0001\"\u0001s\u0003A9(/\u001b;f\u0007>tG\u000e\\(viB,H\u000f\u0006\u0002>g\")1\u000b\u001da\u0001\u0005\u0002")
public abstract class CorefTrainer
implements HyperparameterMain,
Trackable {
    @Override
    public void mark(String text, boolean start) {
        Trackable$class.mark(this, text, start);
    }

    @Override
    public void $bar$times$times(String text) {
        Trackable$class.$bar$times$times(this, text);
    }

    @Override
    public void $times$times$bar(String text) {
        Trackable$class.$times$times$bar(this, text);
    }

    @Override
    public void $times$times$bar() {
        Trackable$class.$times$times$bar(this);
    }

    @Override
    public final void main(String[] args) {
        HyperparameterMain$class.main(this, args);
    }

    @Override
    public final BoxedDouble actualMain(String[] args) {
        return HyperparameterMain$class.actualMain(this, args);
    }

    @Override
    public abstract double evaluateParameters(String[] var1);

    public abstract CorefTrainerOpts opts();

    public void addGenderNumberLabeling(Seq<Document> trainDocs, Seq<Document> testDocs) {
        this.$bar$times$times("Adding Training Gender Labels");
        if (trainDocs != null) {
            trainDocs.foreach((Function1)new Serializable(this){

                public final void apply(Document doc) {
                    doc.targetCoref().mentions().foreach((Function1)new Serializable(this){

                        public final void apply(Mention mention) {
                            NounPhraseGenderLabeler$.MODULE$.process(mention.phrase());
                            NounPhraseNumberLabeler$.MODULE$.process(mention.phrase());
                            DeterministicNounPhraseTypeLabeler$.MODULE$.process(mention.phrase());
                        }
                    });
                }
            });
            trainDocs.foreach((Function1)new Serializable(this){

                public final void apply(Document doc) {
                    doc.coref().mentions().foreach((Function1)new Serializable(this){

                        public final void apply(Mention mention) {
                            NounPhraseGenderLabeler$.MODULE$.process(mention.phrase());
                            NounPhraseNumberLabeler$.MODULE$.process(mention.phrase());
                            DeterministicNounPhraseTypeLabeler$.MODULE$.process(mention.phrase());
                        }
                    });
                }
            });
        }
        testDocs.foreach((Function1)new Serializable(this){

            public final void apply(Document doc) {
                doc.coref().mentions().foreach((Function1)new Serializable(this){

                    public final void apply(Mention mention) {
                        NounPhraseGenderLabeler$.MODULE$.process(mention.phrase());
                        NounPhraseNumberLabeler$.MODULE$.process(mention.phrase());
                        DeterministicNounPhraseTypeLabeler$.MODULE$.process(mention.phrase());
                    }
                });
            }
        });
        this.$times$times$bar();
    }

    public Tuple2<Seq<Document>, Seq<Document>> makeTrainTestDataGoldBoundaries(String trainFile, String testFile, boolean loadTrain) {
        Seq trainDocs = null;
        if (loadTrain) {
            Seq<Document> allTrainDocs = LoadConll2011$.MODULE$.loadWithParse(trainFile, LoadConll2011$.MODULE$.loadWithParse$default$2(), LoadConll2011$.MODULE$.loadWithParse$default$3(), LoadConll2011$.MODULE$.loadWithParse$default$4());
            trainDocs = (Seq)allTrainDocs.take((int)((double)allTrainDocs.length() * BoxesRunTime.unboxToDouble((Object)this.opts().portion().value())));
            trainDocs.foreach((Function1)new Serializable(this){

                public final void apply(Document doc) {
                    doc.getTargetCoref().mentions().foreach((Function1)new Serializable(this, doc){
                        private final Document doc$1;

                        public final OntonotesPhraseEntityType apply(Mention mention) {
                            Predef$.MODULE$.assert(mention.phrase().attr().apply(ClassTag$.MODULE$.apply(OntonotesPhraseEntityType.class)) != null, (Function0)new Serializable(this){

                                public final String apply() {
                                    return "missing entity type";
                                }
                            });
                            return (OntonotesPhraseEntityType)this.doc$1.coref().addMention(mention.phrase()).phrase().attr().$plus$eq(mention.phrase().attr().apply(ClassTag$.MODULE$.apply(OntonotesPhraseEntityType.class)));
                        }
                        {
                            this.doc$1 = doc$1;
                        }
                    });
                }
            });
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Train: ").append((Object)BoxesRunTime.boxToInteger((int)trainDocs.length())).append((Object)" documents, ").append((Object)BoxesRunTime.boxToFloat((float)((float)BoxesRunTime.unboxToInt((Object)((TraversableOnce)trainDocs.map((Function1)new Serializable(this){

                public final int apply(Document d) {
                    return d.coref().mentions().size();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / (float)trainDocs.length()))).append((Object)" mentions/doc").toString());
        }
        Seq<Document> allTestDocs = LoadConll2011$.MODULE$.loadWithParse(testFile, LoadConll2011$.MODULE$.loadWithParse$default$2(), LoadConll2011$.MODULE$.loadWithParse$default$3(), LoadConll2011$.MODULE$.loadWithParse$default$4());
        Seq testDocs = (Seq)allTestDocs.take((int)((double)allTestDocs.length() * BoxesRunTime.unboxToDouble((Object)this.opts().portion().value())));
        testDocs.foreach((Function1)new Serializable(this){

            public final void apply(Document doc) {
                doc.getTargetCoref().mentions().foreach((Function1)new Serializable(this, doc){
                    private final Document doc$2;

                    public final OntonotesPhraseEntityType apply(Mention mention) {
                        Predef$.MODULE$.assert(mention.phrase().attr().apply(ClassTag$.MODULE$.apply(OntonotesPhraseEntityType.class)) != null, (Function0)new Serializable(this){

                            public final String apply() {
                                return "missing entity type";
                            }
                        });
                        return (OntonotesPhraseEntityType)this.doc$2.coref().addMention(mention.phrase()).phrase().attr().$plus$eq(mention.phrase().attr().apply(ClassTag$.MODULE$.apply(OntonotesPhraseEntityType.class)));
                    }
                    {
                        this.doc$2 = doc$2;
                    }
                });
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Test : ").append((Object)BoxesRunTime.boxToInteger((int)testDocs.length())).append((Object)" documents, ").append((Object)BoxesRunTime.boxToFloat((float)((float)BoxesRunTime.unboxToInt((Object)((TraversableOnce)testDocs.map((Function1)new Serializable(this){

            public final int apply(Document d) {
                return d.coref().mentions().size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / (float)testDocs.length()))).append((Object)" mention/doc").toString());
        return new Tuple2((Object)trainDocs, (Object)testDocs);
    }

    public Tuple2<Seq<Document>, Seq<Document>> makeTrainTestData(String trainFile, String testFile, CorefOptions options, boolean loadTrain, boolean useNerMentions) {
        MutableDocumentAnnotatorMap map2 = (MutableDocumentAnnotatorMap)new MutableDocumentAnnotatorMap().$plus$plus$eq((TraversableOnce)DocumentAnnotatorPipeline$.MODULE$.defaultDocumentAnnotationMap());
        if (useNerMentions) {
            map2.update(NerTag.class, new Serializable(this){

                public final ConllChainNer$ apply() {
                    return ConllChainNer$.MODULE$;
                }
            });
        }
        Seq<Document> trainDocs = null;
        if (loadTrain) {
            Seq<Document> allTrainDocs = LoadConll2011$.MODULE$.loadWithParse(trainFile, false, LoadConll2011$.MODULE$.loadWithParse$default$3(), LoadConll2011$.MODULE$.loadWithParse$default$4());
            Seq unalignedTrainDocs = (Seq)allTrainDocs.take((int)((double)allTrainDocs.length() * BoxesRunTime.unboxToDouble((Object)this.opts().portion().value())));
            trainDocs = MentionAlignment$.MODULE$.makeLabeledData((Seq<Document>)unalignedTrainDocs, null, options.useEntityType(), options, (Map<Class<?>, Function0<DocumentAnnotator>>)map2.toMap(Predef$.MODULE$.$conforms()));
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Train: ").append((Object)BoxesRunTime.boxToInteger((int)trainDocs.length())).append((Object)" documents, ").append((Object)BoxesRunTime.boxToFloat((float)((float)BoxesRunTime.unboxToInt((Object)((TraversableOnce)trainDocs.map((Function1)new Serializable(this){

                public final int apply(Document d) {
                    return d.targetCoref().mentions().size();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / (float)trainDocs.length()))).append((Object)" mentions/doc").toString());
        }
        Seq<Document> allTestDocs = LoadConll2011$.MODULE$.loadWithParse(testFile, false, LoadConll2011$.MODULE$.loadWithParse$default$3(), LoadConll2011$.MODULE$.loadWithParse$default$4());
        Seq unalignedTestDocs = (Seq)allTestDocs.take((int)((double)allTestDocs.length() * BoxesRunTime.unboxToDouble((Object)this.opts().portion().value())));
        Seq<Document> testDocs = MentionAlignment$.MODULE$.makeLabeledData((Seq<Document>)unalignedTestDocs, null, options.useEntityType(), options, (Map<Class<?>, Function0<DocumentAnnotator>>)map2.toMap(Predef$.MODULE$.$conforms()));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Test : ").append((Object)BoxesRunTime.boxToInteger((int)testDocs.length())).append((Object)" documents, ").append((Object)BoxesRunTime.boxToFloat((float)((float)BoxesRunTime.unboxToInt((Object)((TraversableOnce)testDocs.map((Function1)new Serializable(this){

            public final int apply(Document d) {
                return d.targetCoref().mentions().size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / (float)testDocs.length()))).append((Object)" mention/doc").toString());
        if (!useNerMentions) {
            NounPhraseEntityTypeLabeler$ labeler = NounPhraseEntityTypeLabeler$.MODULE$;
            if (loadTrain) {
                trainDocs.foreach((Function1)new Serializable(this, labeler){
                    public final NounPhraseEntityTypeLabeler$ labeler$1;

                    public final void apply(Document doc) {
                        doc.coref().mentions().foreach((Function1)new Serializable(this){
                            private final /* synthetic */ $anonfun$makeTrainTestData$4 $outer;

                            public final void apply(Mention mention) {
                                this.$outer.labeler$1.process(mention.phrase());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.labeler$1 = labeler$1;
                    }
                });
            }
            testDocs.foreach((Function1)new Serializable(this, labeler){
                public final NounPhraseEntityTypeLabeler$ labeler$1;

                public final void apply(Document doc) {
                    doc.coref().mentions().foreach((Function1)new Serializable(this){
                        private final /* synthetic */ $anonfun$makeTrainTestData$5 $outer;

                        public final void apply(Mention mention) {
                            this.$outer.labeler$1.process(mention.phrase());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.labeler$1 = labeler$1;
                }
            });
        }
        return new Tuple2(trainDocs, testDocs);
    }

    public void writeConllOutput(Seq<Document> testDocs) {
        CorefConllOutput conllFormatPrinter = new CorefConllOutput();
        PrintStream conllFormatFilt = new PrintStream(new File("eval-test.filtpred"));
        testDocs.foreach((Function1)new Serializable(this, conllFormatPrinter, conllFormatFilt){
            private final CorefConllOutput conllFormatPrinter$1;
            private final PrintStream conllFormatFilt$1;

            public final void apply(Document d) {
                this.conllFormatPrinter$1.printConll2011Format(d.getCoref(), this.conllFormatFilt$1, false);
            }
            {
                this.conllFormatPrinter$1 = conllFormatPrinter$1;
                this.conllFormatFilt$1 = conllFormatFilt$1;
            }
        });
        conllFormatFilt.flush();
        conllFormatFilt.close();
        PrintStream conllFormatNonFilt = new PrintStream(new File("eval-test-key.filtgold"));
        testDocs.foreach((Function1)new Serializable(this, conllFormatPrinter, conllFormatNonFilt){
            private final CorefConllOutput conllFormatPrinter$1;
            private final PrintStream conllFormatNonFilt$1;

            public final void apply(Document d) {
                d.targetCoref().removeSingletons();
                this.conllFormatPrinter$1.printConll2011Format(d.getTargetCoref(), this.conllFormatNonFilt$1, false);
            }
            {
                this.conllFormatPrinter$1 = conllFormatPrinter$1;
                this.conllFormatNonFilt$1 = conllFormatNonFilt$1;
            }
        });
        conllFormatNonFilt.flush();
        conllFormatNonFilt.close();
    }

    public CorefTrainer() {
        HyperparameterMain$class.$init$(this);
        Trackable$class.$init$(this);
    }
}

