/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.util.CodeMapper;
import ca.uhn.hl7v2.util.Home;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCodeMapper
extends CodeMapper {
    private static final Logger log = LoggerFactory.getLogger(FileCodeMapper.class);
    private boolean throwIfNoMatch = false;
    final File baseDir = new File(Home.getHomeDirectory().getAbsolutePath() + "/codemap");
    private Map<String, Map<String, Map<String, String>>> interfaceToLocal;
    private Map<String, Map<String, Map<String, String>>> localToInterface;

    public FileCodeMapper() throws HL7Exception {
        this.refreshCache();
    }

    @Override
    public void refreshCache() throws HL7Exception {
        this.localToInterface = new HashMap<String, Map<String, Map<String, String>>>(10);
        this.interfaceToLocal = new HashMap<String, Map<String, Map<String, String>>>(10);
        log.info("Refreshing cache");
        try {
            File[] interfaceDirs;
            for (File interfaceDir : interfaceDirs = this.baseDir.listFiles(pathname -> {
                boolean acc = false;
                if (pathname.isDirectory()) {
                    acc = true;
                }
                return acc;
            })) {
                log.info("Checking directory {} for interface code maps.", (Object)interfaceDir.getName());
                File[] mapFiles = interfaceDir.listFiles((dir, name) -> {
                    boolean acc = false;
                    if (name.toUpperCase().startsWith("HL7") && (name.substring(name.lastIndexOf(46)).equals(".li") || name.substring(name.lastIndexOf(46)).equals(".il"))) {
                        acc = true;
                    }
                    return acc;
                });
                HashMap li = new HashMap(50);
                HashMap il = new HashMap(50);
                for (File mapFile : mapFiles) {
                    log.info("Reading map entries from file {}", (Object)mapFile);
                    String fName = mapFile.getName();
                    String tableName = fName.substring(0, fName.lastIndexOf(46));
                    String mapDirection = fName.substring(fName.lastIndexOf(46) + 1);
                    HashMap<String, String> codeMap = new HashMap<String, String>(25);
                    try (BufferedReader in = new BufferedReader(new FileReader(mapFile));){
                        while (in.ready()) {
                            String line = in.readLine();
                            if (line.startsWith("//")) continue;
                            StringTokenizer tok = new StringTokenizer(line, "\t", false);
                            String from = null;
                            String to = null;
                            if (tok.hasMoreTokens()) {
                                from = tok.nextToken();
                            }
                            if (tok.hasMoreTokens()) {
                                to = tok.nextToken();
                            }
                            if (from == null || to == null) continue;
                            codeMap.put(from, to);
                        }
                    }
                    if (mapDirection.equals("il")) {
                        il.put(tableName.toUpperCase(), codeMap);
                        log.debug("Adding {} codes to interface -> local map for {} in {} interface", new Object[]{codeMap.size(), tableName, interfaceDir.getName()});
                        continue;
                    }
                    li.put(tableName.toUpperCase(), codeMap);
                    log.debug("Adding {} codes to local -> interface map for {} in {} interface", new Object[]{codeMap.size(), tableName, interfaceDir.getName()});
                }
                this.interfaceToLocal.put(interfaceDir.getName(), il);
                this.localToInterface.put(interfaceDir.getName(), li);
            }
        }
        catch (IOException e) {
            throw new HL7Exception("Can't read interface code maps from disk", e);
        }
    }

    @Override
    public String getLocalCode(String interfaceName, int hl7Table, String interfaceCode) throws HL7Exception {
        String localCode;
        block2: {
            localCode = null;
            try {
                Map<String, Map<String, String>> interfaceMap = this.interfaceToLocal.get(interfaceName);
                localCode = this.getCode(interfaceMap, hl7Table, interfaceCode);
            }
            catch (NullPointerException npe) {
                if (!this.throwIfNoMatch) break block2;
                throw new HL7Exception("No local mapping for the interface code " + interfaceCode + " for HL7 table " + hl7Table + " for the interface '" + interfaceName + "'", ErrorCode.TABLE_VALUE_NOT_FOUND);
            }
        }
        return localCode;
    }

    private String getCode(Map<String, Map<String, String>> interfaceMap, int hl7Table, String code) {
        StringBuilder tableName = new StringBuilder();
        tableName.append("HL7");
        if (hl7Table < 1000) {
            tableName.append("0");
        }
        if (hl7Table < 100) {
            tableName.append("0");
        }
        if (hl7Table < 10) {
            tableName.append("0");
        }
        tableName.append(hl7Table);
        Map<String, String> tableMap = interfaceMap.get(tableName.toString());
        String ret = tableMap.get(code);
        return ret;
    }

    @Override
    public String getInterfaceCode(String interfaceName, int hl7Table, String localCode) throws HL7Exception {
        String interfaceCode;
        block2: {
            interfaceCode = null;
            try {
                Map<String, Map<String, String>> interfaceMap = this.localToInterface.get(interfaceName);
                interfaceCode = this.getCode(interfaceMap, hl7Table, localCode);
            }
            catch (NullPointerException npe) {
                if (!this.throwIfNoMatch) break block2;
                throw new HL7Exception("No interface mapping for the local code " + localCode + " for HL7 table " + hl7Table + " for the interface '" + interfaceName + "'", ErrorCode.TABLE_VALUE_NOT_FOUND);
            }
        }
        return interfaceCode;
    }

    @Override
    public void throwExceptionIfNoMatch(boolean throwException) {
        this.throwIfNoMatch = throwException;
    }

    public static void main(String[] args) {
        try {
            CodeMapper.getInstance().throwExceptionIfNoMatch(true);
            System.out.println("Local code for M is " + CodeMapper.getLocal("test", 1, "M"));
            System.out.println("Interface code for female is " + CodeMapper.getInt("test", 1, "female"));
        }
        catch (HL7Exception e) {
            e.printStackTrace();
        }
    }
}

