/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance;

import org.hl7.fhir.r5.elementmodel.Element;

public class PercentageTracker {
    private int total;
    private int last;
    private int current;
    private boolean log;
    private String url;
    private static int instance;

    public PercentageTracker(int total, String fhirType, String url, boolean log) {
        this.total = total;
        ++instance;
        this.last = 0;
        this.log = log;
        this.url = url;
        if (log) {
            System.out.print("Validate " + fhirType + " against " + url);
        }
    }

    public void done() {
        if (this.log) {
            System.out.println("|");
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void seeElement(Element e) {
        if (e.getInstanceId() != instance) {
            int pct;
            e.setInstanceId(instance);
            ++this.current;
            int n = pct = this.total == 0 ? 0 : this.current * 100 / this.total;
            if (pct > this.last + 2) {
                while (this.last + 2 < pct) {
                    if (this.log) {
                        System.out.print(".");
                    }
                    this.last += 2;
                    if (this.last % 20 != 0 || !this.log) continue;
                    System.out.print("" + this.last);
                }
            }
        }
    }
}

