/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.time.Instant;
import java.util.Comparator;
import org.hl7.fhir.utilities.Utilities;

public class PackageInfo {
    private final String id;
    private final String version;
    private final String fhirVersion;
    private final String description;
    private final String url;
    private final String canonical;
    private Instant date;

    public PackageInfo(String id, String version, String fhirVersion, String description, String url, String canonical, Instant date) {
        this(id, version, fhirVersion, description, url, canonical, null, date);
    }

    public PackageInfo(String id, String version, String fhirVersion, String description, String url, String canonical, String address, Instant date) {
        this.id = id;
        this.version = version;
        this.fhirVersion = fhirVersion;
        this.description = description;
        this.url = url == null && id != null && version != null ? Utilities.pathURL(address, id, version) : url;
        this.canonical = canonical;
        this.date = date;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFhirVersion() {
        return this.fhirVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCanonical() {
        return this.canonical;
    }

    public Instant getDate() {
        return this.date;
    }

    public String toString() {
        return this.id + "#" + (this.version == null ? "?pc-pi?" : this.version) + (String)(this.fhirVersion == null ? "" : " (" + this.canonical + ") for FHIR " + this.fhirVersion) + (String)(this.url == null ? "" : " @" + this.url) + (String)(this.description == null ? "" : " '" + this.description + "'");
    }

    public static class PackageInfoSorter
    implements Comparator<PackageInfo> {
        private boolean byDate;

        public PackageInfoSorter(boolean byDate) {
            this.byDate = byDate;
        }

        @Override
        public int compare(PackageInfo o1, PackageInfo o2) {
            if (this.byDate) {
                return o1.date.compareTo(o2.date);
            }
            return o1.id.compareTo(o2.id);
        }
    }
}

