/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.LanguageFileProducer;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XLIFFProducer
extends LanguageFileProducer {
    private int filecount;

    public XLIFFProducer(String folder) {
        super(folder);
    }

    public XLIFFProducer() {
    }

    @Override
    public LanguageFileProducer.LanguageProducerSession startSession(String id, String baseLang) throws IOException {
        return new XLiffLanguageProducerSession(id, baseLang);
    }

    @Override
    public void finish() {
    }

    @Override
    public List<LanguageFileProducer.TranslationUnit> loadSource(InputStream source) throws IOException, ParserConfigurationException, SAXException {
        ArrayList<LanguageFileProducer.TranslationUnit> list = new ArrayList<LanguageFileProducer.TranslationUnit>();
        Document dom = XMLUtil.parseToDom(TextFile.streamToBytes(source));
        Element xliff = dom.getDocumentElement();
        if (!xliff.getNodeName().equals("xliff")) {
            throw new IOException("Not an XLIFF document");
        }
        for (Element file : XMLUtil.getNamedChildren(xliff, "file")) {
            Element body = XMLUtil.getNamedChild(file, "body");
            for (Element transUnit : XMLUtil.getNamedChildren(body, "trans-unit")) {
                Element notes = XMLUtil.getNamedChild(transUnit, "notes");
                LanguageFileProducer.TranslationUnit tu = new LanguageFileProducer.TranslationUnit(file.getAttribute("target-language"), transUnit.getAttribute("resname"), notes == null ? null : XMLUtil.getNamedChildText(notes, "note"), XMLUtil.getNamedChildText(transUnit, "source"), XMLUtil.getNamedChildText(transUnit, "target"));
                if (Utilities.noString(tu.getSrcText()) || Utilities.noString(tu.getTgtText())) continue;
                list.add(tu);
            }
        }
        return list;
    }

    private void check(String string, boolean equals) {
    }

    @Override
    public int fileCount() {
        return this.filecount;
    }

    protected void ln(StringBuilder xml, String line) {
        xml.append(line + "\r\n");
    }

    @Override
    public void produce(String id, String baseLang, String targetLang, List<LanguageFileProducer.TranslationUnit> translations, String filename) throws IOException {
        StringBuilder xml = new StringBuilder();
        this.ln(xml, "<?xml version=\"1.0\" ?>\r\n");
        this.ln(xml, "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\">");
        this.ln(xml, "  <file source-language=\"" + baseLang + "\" target-language=\"" + targetLang + "\" id=\"" + id + "\" original=\"Resource " + id + "\" datatype=\"KEYVALUEJSON\">");
        this.ln(xml, "    <body>");
        for (LanguageFileProducer.TranslationUnit tu : translations) {
            int i = 0;
            this.ln(xml, "      <trans-unit id=\"" + id + "\" resname=\"" + tu.getId() + "\">");
            if (tu.getContext1() != null) {
                this.ln(xml, "             <notes>");
                this.ln(xml, "               <note id=\"n" + ++i + "\">" + Utilities.escapeXml(tu.getContext1()) + "</note>");
                this.ln(xml, "             </notes>");
            }
            this.ln(xml, "        <source>" + Utilities.escapeXml(tu.getSrcText()) + "</source>");
            this.ln(xml, "        <target>" + Utilities.escapeXml(tu.getTgtText()) + "</target>");
            this.ln(xml, "      </trans-unit>");
        }
        this.ln(xml, "    </body>");
        this.ln(xml, "  </file>");
        this.ln(xml, "</xliff>");
        TextFile.stringToFile(xml.toString(), Utilities.path(this.getFolder(), filename));
    }

    public class XLiffLanguageProducerSession
    extends LanguageFileProducer.LanguageProducerSession {
        public XLiffLanguageProducerSession(String id, String baseLang) {
            super(id, baseLang);
        }

        @Override
        public LanguageFileProducer.LanguageProducerLanguageSession forLang(String targetLang) {
            return new XLiffLanguageProducerLanguageSession(this.id, this.baseLang, targetLang);
        }

        @Override
        public void finish() throws IOException {
        }
    }

    public class XLiffLanguageProducerLanguageSession
    extends LanguageFileProducer.LanguageProducerLanguageSession {
        private StringBuilder xml;
        int i;

        public XLiffLanguageProducerLanguageSession(String id, String baseLang, String targetLang) {
            super(id, baseLang, targetLang);
            this.i = 0;
            this.xml = new StringBuilder();
            this.ln("<?xml version=\"1.0\" ?>\r\n");
            this.ln("<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\">");
            this.ln("  <file source-language=\"" + baseLang + "\" target-language=\"" + targetLang + "\" id=\"" + id + "\" original=\"Resource " + id + "\" datatype=\"KEYVALUEJSON\">");
            this.ln("    <body>");
        }

        protected void ln(String line) {
            this.xml.append(line + "\r\n");
        }

        @Override
        public void finish() throws IOException {
            this.ln("    </body>");
            this.ln("  </file>");
            this.ln("</xliff>");
            TextFile.stringToFile(this.xml.toString(), Utilities.path(XLIFFProducer.this.getFolder(), this.id + ".xliff"));
            ++XLIFFProducer.this.filecount;
        }

        @Override
        public void entry(LanguageFileProducer.TextUnit unit) {
            ++this.i;
            this.ln("      <trans-unit id=\"" + this.id + "\" resname=\"" + unit.getId() + "\">");
            if (unit.getContext1() != null) {
                this.ln("        <notes>");
                this.ln("          <note id=\"n" + this.i + "\">" + Utilities.escapeXml(unit.getContext1()) + "</note>");
                this.ln("        </notes>");
            }
            this.ln("        <source>" + Utilities.escapeXml(unit.getSrcText()) + "</source>");
            this.ln("        <target>" + Utilities.escapeXml(unit.getTgtText()) + "</target>");
            this.ln("      </trans-unit>");
        }
    }
}

