/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

public class CSVReader
extends InputStreamReader {
    private String[] cols;
    private String[] cells;
    private char delimiter = (char)44;
    private boolean multiline;
    private boolean doingQuotes = true;
    private int state = 0;
    private char pc;

    public CSVReader(InputStream in) throws FHIRException, IOException {
        super(in, "UTF-8");
        this.checkBOM();
    }

    private void checkBOM() throws FHIRException, IOException {
        if (this.peek() == '\ufeff') {
            this.next();
        }
    }

    public void readHeaders() throws IOException, FHIRException {
        this.cols = this.parseLine();
    }

    public boolean line() throws IOException, FHIRException {
        if (this.ready()) {
            this.cells = this.parseLine();
            return true;
        }
        return false;
    }

    public boolean has(String name) {
        for (int i = 0; i < this.cols.length; ++i) {
            if (!name.equals(this.cols[i].trim())) continue;
            return this.cell(name) != null;
        }
        return false;
    }

    public String cell(String name) {
        String s;
        int index = -1;
        for (int i = 0; i < this.cols.length; ++i) {
            if (!name.equals(this.cols[i].trim())) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new FHIRException("no cell " + name + " in " + this.cols);
        }
        String string = s = this.cells.length > index ? this.cells[index] : null;
        if (Utilities.noString(s)) {
            return null;
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 2);
        }
        return s;
    }

    protected boolean parseBoolean(String column) {
        if (column == null) {
            return false;
        }
        return column.equalsIgnoreCase("y") || column.equalsIgnoreCase("yes") || column.equalsIgnoreCase("true") || column.equalsIgnoreCase("1");
    }

    protected static String getColumn(String[] titles, String[] values, String column) {
        int c = -1;
        for (int i = 0; i < titles.length; ++i) {
            if (!titles[i].equalsIgnoreCase(column)) continue;
            c = i;
        }
        if (c == -1) {
            return "";
        }
        if (values.length <= c) {
            return "";
        }
        return values[c];
    }

    public String[] parseLine() throws IOException, FHIRException {
        ArrayList<String> res = new ArrayList<String>();
        StringBuilder b = new StringBuilder();
        boolean inQuote = false;
        while (this.more() && !this.finished(inQuote, res.size())) {
            char c = this.peek();
            this.next();
            if (c == '\"' && this.doingQuotes) {
                if (this.ready() && this.peek() == '\"') {
                    b.append(c);
                    this.next();
                    continue;
                }
                inQuote = !inQuote;
                continue;
            }
            if (!inQuote && c == this.delimiter) {
                res.add(b.toString().trim());
                b = new StringBuilder();
                continue;
            }
            b.append(c);
        }
        res.add(b.toString().trim());
        while (this.ready() && (this.peek() == '\r' || this.peek() == '\n')) {
            this.next();
        }
        String[] r = new String[]{};
        r = res.toArray(r);
        return r;
    }

    private boolean more() throws IOException {
        return this.state == 1 || this.ready();
    }

    private boolean finished(boolean inQuote, int size) throws FHIRException, IOException {
        if (this.multiline && this.cols != null) {
            return size == this.cols.length || size == this.cols.length - 1 && !inQuote && (this.peek() == '\r' || this.peek() == '\n');
        }
        return !inQuote && (this.peek() == '\r' || this.peek() == '\n');
    }

    private char peek() throws FHIRException, IOException {
        if (this.state == 0) {
            this.next();
        }
        if (this.state == 1) {
            return this.pc;
        }
        throw new FHIRException("read past end of source");
    }

    private void next() throws FHIRException, IOException {
        if (this.state == 2) {
            throw new FHIRException("read past end of source");
        }
        this.state = 1;
        int i = this.read();
        if (i == -1) {
            this.state = 2;
        } else {
            this.pc = (char)i;
        }
    }

    public void checkColumn(int i, String name, String desc) throws FHIRException {
        if (this.cols.length < i) {
            throw new FHIRException("Error parsing " + desc + ": expected column " + name + " at col " + i + " but only found " + this.cols.length + " cols");
        }
        if (!this.cols[i - 1].equals(name)) {
            throw new FHIRException("Error parsing " + desc + ": expected column " + name + " at col " + i + " but found '" + this.cols[i - 1] + "'");
        }
    }

    public String value(int i) {
        if (i > this.cells.length) {
            return null;
        }
        if (Utilities.noString(this.cells[i - 1])) {
            return null;
        }
        return this.cells[i - 1];
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isDoingQuotes() {
        return this.doingQuotes;
    }

    public void setDoingQuotes(boolean doingQuotes) {
        this.doingQuotes = doingQuotes;
    }
}

