/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.json.model;

import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonElementType;
import org.hl7.fhir.utilities.json.model.JsonPrimitive;

public class JsonBoolean
extends JsonPrimitive {
    private boolean value;

    public JsonBoolean(boolean value) {
        this.value = value;
    }

    private JsonBoolean() {
    }

    @Override
    public JsonElementType type() {
        return JsonElementType.BOOLEAN;
    }

    public boolean isValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value ? "true" : "false";
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    protected JsonElement copy(JsonElement other) {
        this.value = ((JsonBoolean)other).value;
        return this;
    }

    @Override
    protected JsonElement make() {
        return new JsonBoolean();
    }
}

