/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.SimpleHTTPClient;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonProperty;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.npm.PackageInfo;
import org.hl7.fhir.utilities.npm.PackageServer;

public class PackageClient {
    private PackageServer server;
    private String address;

    public PackageClient(PackageServer server) {
        this.server = server;
        this.address = this.server.getUrl();
    }

    public boolean exists(String id, String ver) throws IOException {
        List<PackageInfo> vl = this.getVersions(id);
        for (PackageInfo pi : vl) {
            if (ver != null && !ver.equals(pi.getVersion())) continue;
            return true;
        }
        return false;
    }

    public InputStream fetch(String id, String ver) throws IOException {
        return this.fetchCached(Utilities.pathURL(this.address, id, ver));
    }

    public InputStream fetch(PackageInfo info) throws IOException {
        return this.fetchCached(Utilities.pathURL(this.address, info.getId(), info.getVersion()));
    }

    public InputStream fetchNpm(String id, String ver) throws IOException {
        return this.fetchCached(Utilities.pathURL(this.address, id, "-", id + "-" + ver + ".tgz"));
    }

    public InputStream fetchCached(String url) throws IOException, FileNotFoundException {
        return this.fetchUrl(url, null);
    }

    protected String fn(String url) {
        String[] p = url.split("\\/");
        return p[2] + "-" + p[p.length - 2] + "-" + p[p.length - 1] + ".tgz";
    }

    public List<PackageInfo> getVersions(String id) throws IOException {
        String url = Utilities.pathURL(this.address, id);
        ArrayList<PackageInfo> res = new ArrayList<PackageInfo>();
        try {
            JsonObject json = this.fetchJson(url);
            JsonObject versions = json.getJsonObject("versions");
            boolean hasDates = true;
            if (versions != null) {
                for (JsonProperty v : versions.getProperties()) {
                    Instant d;
                    JsonObject obj = versions.getJsonObject(v.getName());
                    Instant instant = d = obj.hasString("date") ? obj.asDate("date") : null;
                    if (d == null) {
                        hasDates = false;
                    }
                    res.add(new PackageInfo(obj.asString("Name", "name"), obj.asString("Version", "version"), obj.asString("FhirVersion", "fhirVersion"), obj.asString("Description", "description"), obj.asString("url"), obj.asString("canonical"), this.address, d));
                }
            }
            if (hasDates) {
                Collections.sort(res, new PackageInfo.PackageInfoSorter(true));
            } else {
                Collections.sort(res, new PackageInfo.PackageInfoSorter(false));
            }
        }
        catch (Exception e) {
            System.out.println("Error fetching " + url + ": " + e.getMessage());
        }
        return res;
    }

    public List<PackageInfo> search(String name, String canonical, String fhirVersion, boolean preRelease) throws IOException {
        CommaSeparatedStringBuilder params = new CommaSeparatedStringBuilder("&");
        if (!Utilities.noString(name)) {
            params.append("name=" + name);
        }
        if (!Utilities.noString(canonical)) {
            params.append("pkgcanonical=" + canonical);
        }
        if (!Utilities.noString(fhirVersion)) {
            params.append("fhirversion=" + fhirVersion);
        }
        if (preRelease) {
            params.append("prerelease=" + preRelease);
        }
        ArrayList<PackageInfo> res = new ArrayList<PackageInfo>();
        try {
            JsonArray json = this.fetchJsonArray(Utilities.pathURL(this.address, "catalog?") + params.toString());
            boolean hasDates = true;
            for (JsonObject obj : json.asJsonObjects()) {
                Instant d;
                Instant instant = d = obj.has("date") ? obj.asDate("date") : null;
                if (d == null) {
                    hasDates = false;
                }
                res.add(new PackageInfo(obj.asString("Name", "name"), obj.asString("Version", "version"), obj.asString("FhirVersion", "fhirVersion"), obj.asString("Description", "description"), obj.asString("url"), obj.asString("canonical"), this.address, d));
            }
            if (hasDates) {
                Collections.sort(res, new PackageInfo.PackageInfoSorter(true));
            } else {
                Collections.sort(res, new PackageInfo.PackageInfoSorter(false));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    public Date getNewPackages(Date lastCalled, List<PackageInfo> updates) {
        return null;
    }

    private InputStream fetchUrl(String source, String accept) throws IOException {
        SimpleHTTPClient http = new SimpleHTTPClient();
        SimpleHTTPClient.HTTPResult res = http.get(source, accept);
        res.checkThrowException();
        return new ByteArrayInputStream(res.getContent());
    }

    private JsonObject fetchJson(String source) throws IOException {
        String src = TextFile.streamToString(this.fetchUrl(source, "application/json"));
        return JsonParser.parseObject(src);
    }

    private JsonArray fetchJsonArray(String source) throws IOException {
        String src = TextFile.streamToString(this.fetchUrl(source, "application/json"));
        return (JsonArray)JsonParser.parse(src);
    }

    public String url(String id, String v) {
        return Utilities.pathURL(this.address, id, v);
    }

    public String getLatestVersion(String id) throws IOException {
        List<PackageInfo> list = this.getVersions(id);
        if (list.isEmpty()) {
            throw new IOException("Package not found: " + id);
        }
        String v = list.get(0).getVersion();
        for (PackageInfo p : list) {
            if (!VersionUtilities.isThisOrLater(v, p.getVersion())) continue;
            v = p.getVersion();
        }
        return v;
    }

    public String getLatestVersion(String id, String specVersion) throws IOException {
        List<PackageInfo> list = this.getVersions(id);
        if (list.isEmpty()) {
            throw new IOException("Package not found: " + id);
        }
        String v = null;
        for (PackageInfo p : list) {
            if (!VersionUtilities.isMajMinOrLaterPatch(specVersion, p.getVersion())) continue;
            v = p.getVersion();
        }
        return v;
    }

    protected PackageInfo getPackageInfoFromJSON(JsonObject o, String name, String canonical, String fhirVersion) {
        String id = o.asString("npm-name");
        String pname = o.asString("name");
        String pcanonical = o.asString("canonical");
        String description = o.asString("description");
        Instant d = o.has("date") ? o.asDate("date") : null;
        boolean ok = true;
        if (ok && !Utilities.noString(name)) {
            boolean bl = ok = pname != null && pname.contains(name) || description != null && description.contains(name) || id != null && id.contains(name);
        }
        if (ok && !Utilities.noString(canonical)) {
            ok = pcanonical.contains(canonical);
        }
        String version = null;
        String fVersion = null;
        String url = null;
        if (ok) {
            for (JsonObject e : o.getJsonObjects("editions")) {
                if (fhirVersion != null && !fhirVersion.equals(e.asString("fhir-version"))) continue;
                String v = e.asString("ig-version");
                if (version != null && !VersionUtilities.isThisOrLater(version, v)) continue;
                version = v;
                fVersion = e.getJsonArray("fhir-version").get(0).asString();
                url = e.asString("url");
                String npmPackage = e.asString("package");
                if (npmPackage == null || id != null) continue;
                id = npmPackage.substring(0, npmPackage.indexOf("#"));
            }
        }
        return new PackageInfo(id, version, fVersion, description, url, pcanonical, this.address, d);
    }

    public List<PackageInfo> listFromRegistry(String name, String canonical, String fhirVersion) throws IOException {
        ArrayList<PackageInfo> result = new ArrayList<PackageInfo>();
        JsonObject packages = JsonParser.parseObjectFromUrl("https://raw.githubusercontent.com/FHIR/ig-registry/master/fhir-ig-list.json?nocache=" + System.currentTimeMillis());
        for (JsonObject o : packages.getJsonObjects("guides")) {
            PackageInfo packageInfo;
            if (!o.has("canonical") || (packageInfo = this.getPackageInfoFromJSON(o, name, canonical, fhirVersion)).getVersion() == null) continue;
            result.add(packageInfo);
        }
        return result;
    }

    public void findDependents(Set<String> list, String id) {
        CommaSeparatedStringBuilder params = new CommaSeparatedStringBuilder("&");
        params.append("dependency=" + id.replace("#", "|"));
        try {
            JsonArray json = this.fetchJsonArray(Utilities.pathURL(this.address, "catalog?") + params.toString());
            for (JsonObject obj : json.asJsonObjects()) {
                list.add(obj.asString("Name", "name"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

