/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.xml.XMLWriter;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlGenerator {
    private XMLWriter xml;

    public void generate(Element element, File file, String defaultNamespace, String elementName) throws FHIRException, IOException {
        FileOutputStream stream = new FileOutputStream(file);
        this.xml = new XMLWriter((OutputStream)stream, "UTF-8");
        this.xml.start();
        this.xml.setDefaultNamespace(defaultNamespace);
        this.xml.enter(defaultNamespace, elementName);
        this.processContents(element);
        this.xml.exit();
        this.xml.end();
        this.xml.flush();
        ((OutputStream)stream).close();
    }

    public String generate(Element element) throws IOException, FHIRException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.generate(element, stream);
        return new String(stream.toByteArray());
    }

    public void generate(Element element, File file) throws IOException, FHIRException {
        FileOutputStream stream = new FileOutputStream(file);
        this.generate(element, stream);
    }

    public void generate(Element element, OutputStream stream) throws IOException, FHIRException {
        this.xml = new XMLWriter(stream, "UTF-8");
        this.xml.start();
        this.xml.setDefaultNamespace(element.getNamespaceURI());
        this.processElement(element);
        this.xml.end();
    }

    private void processContents(Element element) throws FHIRException, IOException {
        block5: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 1: {
                    this.processElement((Element)node);
                    continue block5;
                }
                case 3: {
                    this.processText(node);
                    continue block5;
                }
                case 8: {
                    this.processComment((Comment)node);
                    continue block5;
                }
                default: {
                    throw new FHIRException("unhandled node type " + Integer.toString(node.getNodeType()));
                }
            }
        }
    }

    private void processComment(Comment node) throws DOMException, IOException {
        this.xml.comment(node.getNodeValue(), true);
    }

    private void processElement(Element element) throws IOException, FHIRException {
        if (this.xml.getDefaultNamespace() == null || !this.xml.getDefaultNamespace().equals(element.getNamespaceURI())) {
            this.xml.setDefaultNamespace(element.getNamespaceURI());
        }
        this.processAttributes(element);
        this.xml.enter(element.getNamespaceURI(), element.getLocalName());
        this.processContents(element);
        this.xml.exit();
    }

    private void processText(Node node) throws DOMException, IOException {
        this.xml.text(node.getNodeValue());
    }

    private void processAttributes(Element element) throws DOMException, IOException {
        NamedNodeMap nodes = element.getAttributes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node attr = nodes.item(i);
            if (attr.getNamespaceURI() != null) continue;
            if (attr.getLocalName() != null) {
                this.xml.attribute(attr.getLocalName(), attr.getNodeValue());
                continue;
            }
            if (attr.getNodeName() == null || "xmlns".equals(attr.getNodeName())) continue;
            this.xml.attribute(attr.getNodeName(), attr.getNodeValue());
        }
    }
}

