/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Resource;

public class DataTypeVisitor {
    private boolean anyFalse;
    private boolean anyTrue;
    private int nodeCount;
    private int selectedCount;

    public <T extends DataType> void visit(Resource resource, IDatatypeVisitor<T> visitor) {
        this.visitNode(resource.fhirType(), resource, visitor);
    }

    private <T extends DataType> void visitNode(String path, Base node, IDatatypeVisitor<T> visitor) {
        ++this.nodeCount;
        if (node instanceof DataType && visitor.classT().isInstance(node)) {
            ++this.selectedCount;
            boolean ok = visitor.visit(path, (DataType)node);
            if (ok) {
                this.anyTrue = true;
            } else {
                this.anyFalse = true;
            }
        }
        for (Property p : node.children()) {
            if (p.isList()) {
                int i = 0;
                for (Base b : p.getValues()) {
                    this.visitNode(path + "." + p.getName() + "[" + i + "]", b, visitor);
                    ++i;
                }
                continue;
            }
            for (Base b : p.getValues()) {
                this.visitNode(path + "." + p.getName(), b, visitor);
            }
        }
    }

    public boolean isAnyFalse() {
        return this.anyFalse;
    }

    public boolean isAnyTrue() {
        return this.anyTrue;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getSelectedCount() {
        return this.selectedCount;
    }

    public static interface IDatatypeVisitor<T extends DataType> {
        public Class<T> classT();

        public boolean visit(String var1, T var2);
    }
}

