/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class SubscriptionTopicRenderer
extends ResourceRenderer {
    public SubscriptionTopicRenderer(RenderingContext context) {
        super(context);
    }

    public SubscriptionTopicRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws FHIRFormatError, DefinitionException, IOException {
        return this.render(x, (SubscriptionTopic)dr);
    }

    public boolean render(XhtmlNode x, SubscriptionTopic st) throws FHIRFormatError, DefinitionException, IOException {
        ResourceRenderer.TableRowData tr;
        ResourceRenderer.TableData td;
        if (this.context.isHeader()) {
            XhtmlNode h = x.h2();
            h.addText(st.hasTitle() ? st.getTitle() : st.getName());
            this.addMarkdown(x, st.getDescription());
            if (st.hasCopyright()) {
                this.generateCopyright(x, st);
            }
        }
        if (st.hasResourceTrigger()) {
            td = new ResourceRenderer.TableData("Resource Triggers");
            for (SubscriptionTopic.SubscriptionTopicResourceTriggerComponent subscriptionTopicResourceTriggerComponent : st.getResourceTrigger()) {
                tr = td.addRow();
                if (subscriptionTopicResourceTriggerComponent.hasResource()) {
                    tr.value("Resource", subscriptionTopicResourceTriggerComponent.getResourceElement());
                }
                for (Enumeration<SubscriptionTopic.InteractionTrigger> enumeration : subscriptionTopicResourceTriggerComponent.getSupportedInteraction()) {
                    tr.value("Interactions", enumeration);
                }
                if (subscriptionTopicResourceTriggerComponent.hasQueryCriteria()) {
                    StringBuilder md = new StringBuilder();
                    if (subscriptionTopicResourceTriggerComponent.getQueryCriteria().hasPrevious()) {
                        md.append("* previous = " + subscriptionTopicResourceTriggerComponent.getQueryCriteria().getPrevious() + "\r\n");
                    }
                    if (subscriptionTopicResourceTriggerComponent.getQueryCriteria().hasResultForCreate()) {
                        md.append("* create result = " + subscriptionTopicResourceTriggerComponent.getQueryCriteria().getResultForCreate() + "\r\n");
                    }
                    if (subscriptionTopicResourceTriggerComponent.getQueryCriteria().hasCurrent()) {
                        md.append("* create result = " + subscriptionTopicResourceTriggerComponent.getQueryCriteria().getCurrent() + "\r\n");
                    }
                    if (subscriptionTopicResourceTriggerComponent.getQueryCriteria().hasPrevious()) {
                        md.append("* delete result = " + subscriptionTopicResourceTriggerComponent.getQueryCriteria().getResultForDelete() + "\r\n");
                    }
                    if (subscriptionTopicResourceTriggerComponent.getQueryCriteria().hasRequireBoth()) {
                        md.append("* require both = " + subscriptionTopicResourceTriggerComponent.getQueryCriteria().getRequireBoth() + "\r\n");
                    }
                    tr.value("Criteria", new MarkdownType(md.toString()));
                }
                if (subscriptionTopicResourceTriggerComponent.hasFhirPathCriteriaElement()) {
                    tr.value("FHIR Path", subscriptionTopicResourceTriggerComponent.getFhirPathCriteriaElement());
                }
                if (!subscriptionTopicResourceTriggerComponent.hasDescription()) continue;
                tr.value("Description", subscriptionTopicResourceTriggerComponent.getDescriptionElement());
            }
            this.renderTable(td, x);
        }
        if (st.hasResourceTrigger()) {
            td = new ResourceRenderer.TableData("Event Triggers");
            for (SubscriptionTopic.SubscriptionTopicEventTriggerComponent subscriptionTopicEventTriggerComponent : st.getEventTrigger()) {
                tr = td.addRow();
                if (subscriptionTopicEventTriggerComponent.hasResource()) {
                    tr.value("Resource", subscriptionTopicEventTriggerComponent.getResourceElement());
                }
                if (subscriptionTopicEventTriggerComponent.hasEvent()) {
                    tr.value("Event", subscriptionTopicEventTriggerComponent.getEvent());
                }
                if (!subscriptionTopicEventTriggerComponent.hasDescription()) continue;
                tr.value("Description", subscriptionTopicEventTriggerComponent.getDescriptionElement());
            }
            this.renderTable(td, x);
        }
        if (st.hasCanFilterBy()) {
            td = new ResourceRenderer.TableData("Can Filter By");
            for (SubscriptionTopic.SubscriptionTopicCanFilterByComponent subscriptionTopicCanFilterByComponent : st.getCanFilterBy()) {
                tr = td.addRow();
                if (subscriptionTopicCanFilterByComponent.hasResource()) {
                    tr.value("Resource", subscriptionTopicCanFilterByComponent.getResourceElement());
                }
                if (subscriptionTopicCanFilterByComponent.hasFilterParameter()) {
                    tr.value("Filter Parameter", subscriptionTopicCanFilterByComponent.getFilterParameterElement());
                }
                if (subscriptionTopicCanFilterByComponent.hasFilterDefinition()) {
                    tr.value("Filter Definition", subscriptionTopicCanFilterByComponent.getFilterDefinitionElement());
                }
                for (Enumeration enumeration : subscriptionTopicCanFilterByComponent.getComparator()) {
                    tr.value("Comparators", enumeration);
                }
                for (Enumeration enumeration : subscriptionTopicCanFilterByComponent.getModifier()) {
                    tr.value("Modifiers", enumeration);
                }
            }
            this.renderTable(td, x);
        }
        if (st.hasNotificationShape()) {
            td = new ResourceRenderer.TableData("Notification Shapes");
            for (SubscriptionTopic.SubscriptionTopicNotificationShapeComponent subscriptionTopicNotificationShapeComponent : st.getNotificationShape()) {
                tr = td.addRow();
                if (subscriptionTopicNotificationShapeComponent.hasResource()) {
                    tr.value("Resource", subscriptionTopicNotificationShapeComponent.getResourceElement());
                }
                for (StringType stringType : subscriptionTopicNotificationShapeComponent.getInclude()) {
                    tr.value("Includes", stringType);
                }
                for (StringType stringType : subscriptionTopicNotificationShapeComponent.getRevInclude()) {
                    tr.value("Reverse Includes", stringType);
                }
            }
            this.renderTable(td, x);
        }
        return false;
    }

    public void describe(XhtmlNode x, Library lib) {
        x.tx(this.display(lib));
    }

    public String display(Library lib) {
        return lib.present();
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return ((Library)r).present();
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        if (r.has("title")) {
            return r.children("title").get(0).getBase().primitiveValue();
        }
        return "??";
    }
}

