/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class SearchParameterRenderer
extends TerminologyRenderer {
    public SearchParameterRenderer(RenderingContext context) {
        super(context);
    }

    public SearchParameterRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws IOException, FHIRException, EOperationOutcome {
        return this.render(x, (SearchParameter)dr);
    }

    public boolean render(XhtmlNode x, SearchParameter spd) throws IOException, FHIRException, EOperationOutcome {
        StructureDefinition sd;
        XhtmlNode h2 = x.h2();
        h2.addText(spd.getName());
        StandardsStatus ss = ToolingExtensions.getStandardsStatus(spd);
        if (ss != this.context.getDefaultStandardsStatus()) {
            this.genStandardsStatus(h2, ss);
        }
        XhtmlNode p = x.para();
        p.tx("Parameter ");
        p.code().tx(spd.getCode());
        p.tx(":");
        p.code().tx(spd.getType().toCode());
        this.addMarkdown(x, spd.getDescription());
        XhtmlNode tbl = x.table("grid");
        XhtmlNode tr = tbl.tr();
        tr.td().tx(Utilities.pluralize((String)"Resource", (int)spd.getBase().size()));
        XhtmlNode td = tr.td();
        for (Enumeration<Enumerations.VersionIndependentResourceTypesAll> enumeration : spd.getBase()) {
            sd = this.context.getWorker().fetchTypeDefinition(enumeration.getCode());
            if (sd != null && sd.hasWebPath()) {
                td.sep(", ");
                td.ah(sd.getWebPath()).tx(enumeration.getCode());
                continue;
            }
            td.sep(", ");
            td.tx(enumeration.getCode());
        }
        tr = tbl.tr();
        tr.td().tx("Expression");
        if (spd.hasExpression()) {
            tr.td().code().tx(spd.getExpression());
        } else {
            tr.td().tx("(none)");
        }
        if (spd.hasProcessingMode()) {
            tr = tbl.tr();
            tr.td().tx("Processing Mode");
            tr.td().tx(spd.getProcessingMode().getDisplay());
        }
        if (spd.hasTarget()) {
            tr = tbl.tr();
            tr.td().tx(Utilities.pluralize((String)"Target Resources", (int)spd.getTarget().size()));
            td = tr.td();
            if (this.isAllConcreteResources(spd.getTarget())) {
                td.ah(Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC), "resourcelist.html"})).tx("All Resources");
            } else {
                for (Enumeration<Enumerations.VersionIndependentResourceTypesAll> enumeration : spd.getTarget()) {
                    sd = this.context.getWorker().fetchTypeDefinition(enumeration.getCode());
                    if (sd != null && sd.hasWebPath()) {
                        td.sep(", ");
                        td.ah(sd.getWebPath()).tx(enumeration.getCode());
                        continue;
                    }
                    td.sep(", ");
                    td.tx(enumeration.getCode());
                }
            }
        }
        tr = tbl.tr();
        tr.td().tx("Multiples");
        if (spd.getMultipleAnd() && spd.getMultipleOr()) {
            tr.td().tx("The parameter can repeat (and) and can have repeating values (or)");
        } else if (spd.getMultipleOr()) {
            tr.td().tx("The parameter can repeat (and) but each repeat can only have one value");
        } else if (spd.getMultipleAnd()) {
            tr.td().tx("The parameter cannot repeat (and) but the single parameter can have multiple values (or)");
        } else {
            tr.td().tx("The parameter cannot repeat or have multiple values");
        }
        if (spd.hasComparator()) {
            tr = tbl.tr();
            tr.td().tx("Comparators");
            td = tr.td();
            td.tx("Allowed: ");
            for (Enumeration<Enum> enumeration : spd.getComparator()) {
                td.sep(", ");
                td.tx(enumeration.asStringValue());
            }
        }
        if (spd.hasModifier()) {
            tr = tbl.tr();
            tr.td().tx("Modifiers");
            td = tr.td();
            td.tx("Allowed: ");
            for (Enumeration enumeration : spd.getModifier()) {
                td.sep(", ");
                td.tx(enumeration.asStringValue());
            }
        }
        if (spd.hasChain()) {
            tr = tbl.tr();
            tr.td().tx("Chains");
            td = tr.td();
            td.tx("Allowed: ");
            for (StringType stringType : spd.getChain()) {
                td.sep(", ");
                td.tx(stringType.asStringValue());
            }
        }
        if (spd.hasComponent()) {
            x.para().b().tx("Components");
            tbl = x.table("grid");
            for (SearchParameter.SearchParameterComponentComponent searchParameterComponentComponent : spd.getComponent()) {
                tr = tbl.tr();
                SearchParameter tsp = this.context.getWorker().fetchResource(SearchParameter.class, searchParameterComponentComponent.getDefinition(), spd);
                if (tsp != null && tsp.hasWebPath()) {
                    tr.td().ah(tsp.getWebPath()).tx(tsp.present());
                } else {
                    tr.td().tx(searchParameterComponentComponent.getDefinition());
                }
                tr.td().code().tx(searchParameterComponentComponent.getExpression());
            }
        }
        return false;
    }

    private boolean isAllConcreteResources(List<Enumeration<Enumerations.VersionIndependentResourceTypesAll>> list) {
        for (String s : this.context.getWorker().getResourceNames()) {
            StructureDefinition sd = this.context.getWorker().fetchTypeDefinition(s);
            if (sd.getAbstract() || Utilities.existsInList((String)sd.getType(), (String[])new String[]{"Parameters"})) continue;
            boolean found = false;
            for (Enumeration<Enumerations.VersionIndependentResourceTypesAll> c : list) {
                found = found || sd.getName().equals(c.getCode());
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void describe(XhtmlNode x, OperationDefinition opd) {
        x.tx(this.display(opd));
    }

    public String display(OperationDefinition opd) {
        return opd.present();
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return ((SearchParameter)r).present();
    }
}

