/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SubstanceSourceMaterial", profile="http://hl7.org/fhir/StructureDefinition/SubstanceSourceMaterial")
public class SubstanceSourceMaterial
extends DomainResource {
    @Child(name="sourceMaterialClass", type={CodeableConcept.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="General high level classification of the source material specific to the origin of the material", formalDefinition="General high level classification of the source material specific to the origin of the material.")
    protected CodeableConcept sourceMaterialClass;
    @Child(name="sourceMaterialType", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The type of the source material shall be specified based on a controlled vocabulary. For vaccines, this subclause refers to the class of infectious agent", formalDefinition="The type of the source material shall be specified based on a controlled vocabulary. For vaccines, this subclause refers to the class of infectious agent.")
    protected CodeableConcept sourceMaterialType;
    @Child(name="sourceMaterialState", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The state of the source material when extracted", formalDefinition="The state of the source material when extracted.")
    protected CodeableConcept sourceMaterialState;
    @Child(name="organismId", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The unique identifier associated with the source material parent organism shall be specified", formalDefinition="The unique identifier associated with the source material parent organism shall be specified.")
    protected Identifier organismId;
    @Child(name="organismName", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The organism accepted Scientific name shall be provided based on the organism taxonomy", formalDefinition="The organism accepted Scientific name shall be provided based on the organism taxonomy.")
    protected StringType organismName;
    @Child(name="parentSubstanceId", type={Identifier.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The parent of the herbal drug Ginkgo biloba, Leaf is the substance ID of the substance (fresh) of Ginkgo biloba L. or Ginkgo biloba L. (Whole plant)", formalDefinition="The parent of the herbal drug Ginkgo biloba, Leaf is the substance ID of the substance (fresh) of Ginkgo biloba L. or Ginkgo biloba L. (Whole plant).")
    protected List<Identifier> parentSubstanceId;
    @Child(name="parentSubstanceName", type={StringType.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The parent substance of the Herbal Drug, or Herbal preparation", formalDefinition="The parent substance of the Herbal Drug, or Herbal preparation.")
    protected List<StringType> parentSubstanceName;
    @Child(name="countryOfOrigin", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The country where the plant material is harvested or the countries where the plasma is sourced from as laid down in accordance with the Plasma Master File. For \u201cPlasma-derived substances\u201d the attribute country of origin provides information about the countries used for the manufacturing of the Cryopoor plama or Crioprecipitate", formalDefinition="The country where the plant material is harvested or the countries where the plasma is sourced from as laid down in accordance with the Plasma Master File. For \u201cPlasma-derived substances\u201d the attribute country of origin provides information about the countries used for the manufacturing of the Cryopoor plama or Crioprecipitate.")
    protected List<CodeableConcept> countryOfOrigin;
    @Child(name="geographicalLocation", type={StringType.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The place/region where the plant is harvested or the places/regions where the animal source material has its habitat", formalDefinition="The place/region where the plant is harvested or the places/regions where the animal source material has its habitat.")
    protected List<StringType> geographicalLocation;
    @Child(name="developmentStage", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Stage of life for animals, plants, insects and microorganisms. This information shall be provided only when the substance is significantly different in these stages (e.g. foetal bovine serum)", formalDefinition="Stage of life for animals, plants, insects and microorganisms. This information shall be provided only when the substance is significantly different in these stages (e.g. foetal bovine serum).")
    protected CodeableConcept developmentStage;
    @Child(name="fractionDescription", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Many complex materials are fractions of parts of plants, animals, or minerals. Fraction elements are often necessary to define both Substances and Specified Group 1 Substances. For substances derived from Plants, fraction information will be captured at the Substance information level ( . Oils, Juices and Exudates). Additional information for Extracts, such as extraction solvent composition, will be captured at the Specified Substance Group 1 information level. For plasma-derived products fraction information will be captured at the Substance and the Specified Substance Group 1 levels", formalDefinition="Many complex materials are fractions of parts of plants, animals, or minerals. Fraction elements are often necessary to define both Substances and Specified Group 1 Substances. For substances derived from Plants, fraction information will be captured at the Substance information level ( . Oils, Juices and Exudates). Additional information for Extracts, such as extraction solvent composition, will be captured at the Specified Substance Group 1 information level. For plasma-derived products fraction information will be captured at the Substance and the Specified Substance Group 1 levels.")
    protected List<SubstanceSourceMaterialFractionDescriptionComponent> fractionDescription;
    @Child(name="organism", type={}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="This subclause describes the organism which the substance is derived from. For vaccines, the parent organism shall be specified based on these subclause elements. As an example, full taxonomy will be described for the Substance Name: ., Leaf", formalDefinition="This subclause describes the organism which the substance is derived from. For vaccines, the parent organism shall be specified based on these subclause elements. As an example, full taxonomy will be described for the Substance Name: ., Leaf.")
    protected SubstanceSourceMaterialOrganismComponent organism;
    @Child(name="partDescription", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="To do", formalDefinition="To do.")
    protected List<SubstanceSourceMaterialPartDescriptionComponent> partDescription;
    private static final long serialVersionUID = 442657667L;

    public CodeableConcept getSourceMaterialClass() {
        if (this.sourceMaterialClass == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSourceMaterial.sourceMaterialClass");
            }
            if (Configuration.doAutoCreate()) {
                this.sourceMaterialClass = new CodeableConcept();
            }
        }
        return this.sourceMaterialClass;
    }

    public boolean hasSourceMaterialClass() {
        return this.sourceMaterialClass != null && !this.sourceMaterialClass.isEmpty();
    }

    public SubstanceSourceMaterial setSourceMaterialClass(CodeableConcept value) {
        this.sourceMaterialClass = value;
        return this;
    }

    public CodeableConcept getSourceMaterialType() {
        if (this.sourceMaterialType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSourceMaterial.sourceMaterialType");
            }
            if (Configuration.doAutoCreate()) {
                this.sourceMaterialType = new CodeableConcept();
            }
        }
        return this.sourceMaterialType;
    }

    public boolean hasSourceMaterialType() {
        return this.sourceMaterialType != null && !this.sourceMaterialType.isEmpty();
    }

    public SubstanceSourceMaterial setSourceMaterialType(CodeableConcept value) {
        this.sourceMaterialType = value;
        return this;
    }

    public CodeableConcept getSourceMaterialState() {
        if (this.sourceMaterialState == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSourceMaterial.sourceMaterialState");
            }
            if (Configuration.doAutoCreate()) {
                this.sourceMaterialState = new CodeableConcept();
            }
        }
        return this.sourceMaterialState;
    }

    public boolean hasSourceMaterialState() {
        return this.sourceMaterialState != null && !this.sourceMaterialState.isEmpty();
    }

    public SubstanceSourceMaterial setSourceMaterialState(CodeableConcept value) {
        this.sourceMaterialState = value;
        return this;
    }

    public Identifier getOrganismId() {
        if (this.organismId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSourceMaterial.organismId");
            }
            if (Configuration.doAutoCreate()) {
                this.organismId = new Identifier();
            }
        }
        return this.organismId;
    }

    public boolean hasOrganismId() {
        return this.organismId != null && !this.organismId.isEmpty();
    }

    public SubstanceSourceMaterial setOrganismId(Identifier value) {
        this.organismId = value;
        return this;
    }

    public StringType getOrganismNameElement() {
        if (this.organismName == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSourceMaterial.organismName");
            }
            if (Configuration.doAutoCreate()) {
                this.organismName = new StringType();
            }
        }
        return this.organismName;
    }

    public boolean hasOrganismNameElement() {
        return this.organismName != null && !this.organismName.isEmpty();
    }

    public boolean hasOrganismName() {
        return this.organismName != null && !this.organismName.isEmpty();
    }

    public SubstanceSourceMaterial setOrganismNameElement(StringType value) {
        this.organismName = value;
        return this;
    }

    public String getOrganismName() {
        return this.organismName == null ? null : (String)this.organismName.getValue();
    }

    public SubstanceSourceMaterial setOrganismName(String value) {
        if (Utilities.noString((String)value)) {
            this.organismName = null;
        } else {
            if (this.organismName == null) {
                this.organismName = new StringType();
            }
            this.organismName.setValue(value);
        }
        return this;
    }

    public List<Identifier> getParentSubstanceId() {
        if (this.parentSubstanceId == null) {
            this.parentSubstanceId = new ArrayList<Identifier>();
        }
        return this.parentSubstanceId;
    }

    public SubstanceSourceMaterial setParentSubstanceId(List<Identifier> theParentSubstanceId) {
        this.parentSubstanceId = theParentSubstanceId;
        return this;
    }

    public boolean hasParentSubstanceId() {
        if (this.parentSubstanceId == null) {
            return false;
        }
        for (Identifier item : this.parentSubstanceId) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addParentSubstanceId() {
        Identifier t = new Identifier();
        if (this.parentSubstanceId == null) {
            this.parentSubstanceId = new ArrayList<Identifier>();
        }
        this.parentSubstanceId.add(t);
        return t;
    }

    public SubstanceSourceMaterial addParentSubstanceId(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.parentSubstanceId == null) {
            this.parentSubstanceId = new ArrayList<Identifier>();
        }
        this.parentSubstanceId.add(t);
        return this;
    }

    public Identifier getParentSubstanceIdFirstRep() {
        if (this.getParentSubstanceId().isEmpty()) {
            this.addParentSubstanceId();
        }
        return this.getParentSubstanceId().get(0);
    }

    public List<StringType> getParentSubstanceName() {
        if (this.parentSubstanceName == null) {
            this.parentSubstanceName = new ArrayList<StringType>();
        }
        return this.parentSubstanceName;
    }

    public SubstanceSourceMaterial setParentSubstanceName(List<StringType> theParentSubstanceName) {
        this.parentSubstanceName = theParentSubstanceName;
        return this;
    }

    public boolean hasParentSubstanceName() {
        if (this.parentSubstanceName == null) {
            return false;
        }
        for (StringType item : this.parentSubstanceName) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addParentSubstanceNameElement() {
        StringType t = new StringType();
        if (this.parentSubstanceName == null) {
            this.parentSubstanceName = new ArrayList<StringType>();
        }
        this.parentSubstanceName.add(t);
        return t;
    }

    public SubstanceSourceMaterial addParentSubstanceName(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.parentSubstanceName == null) {
            this.parentSubstanceName = new ArrayList<StringType>();
        }
        this.parentSubstanceName.add(t);
        return this;
    }

    public boolean hasParentSubstanceName(String value) {
        if (this.parentSubstanceName == null) {
            return false;
        }
        for (StringType v : this.parentSubstanceName) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CodeableConcept> getCountryOfOrigin() {
        if (this.countryOfOrigin == null) {
            this.countryOfOrigin = new ArrayList<CodeableConcept>();
        }
        return this.countryOfOrigin;
    }

    public SubstanceSourceMaterial setCountryOfOrigin(List<CodeableConcept> theCountryOfOrigin) {
        this.countryOfOrigin = theCountryOfOrigin;
        return this;
    }

    public boolean hasCountryOfOrigin() {
        if (this.countryOfOrigin == null) {
            return false;
        }
        for (CodeableConcept item : this.countryOfOrigin) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCountryOfOrigin() {
        CodeableConcept t = new CodeableConcept();
        if (this.countryOfOrigin == null) {
            this.countryOfOrigin = new ArrayList<CodeableConcept>();
        }
        this.countryOfOrigin.add(t);
        return t;
    }

    public SubstanceSourceMaterial addCountryOfOrigin(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.countryOfOrigin == null) {
            this.countryOfOrigin = new ArrayList<CodeableConcept>();
        }
        this.countryOfOrigin.add(t);
        return this;
    }

    public CodeableConcept getCountryOfOriginFirstRep() {
        if (this.getCountryOfOrigin().isEmpty()) {
            this.addCountryOfOrigin();
        }
        return this.getCountryOfOrigin().get(0);
    }

    public List<StringType> getGeographicalLocation() {
        if (this.geographicalLocation == null) {
            this.geographicalLocation = new ArrayList<StringType>();
        }
        return this.geographicalLocation;
    }

    public SubstanceSourceMaterial setGeographicalLocation(List<StringType> theGeographicalLocation) {
        this.geographicalLocation = theGeographicalLocation;
        return this;
    }

    public boolean hasGeographicalLocation() {
        if (this.geographicalLocation == null) {
            return false;
        }
        for (StringType item : this.geographicalLocation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addGeographicalLocationElement() {
        StringType t = new StringType();
        if (this.geographicalLocation == null) {
            this.geographicalLocation = new ArrayList<StringType>();
        }
        this.geographicalLocation.add(t);
        return t;
    }

    public SubstanceSourceMaterial addGeographicalLocation(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.geographicalLocation == null) {
            this.geographicalLocation = new ArrayList<StringType>();
        }
        this.geographicalLocation.add(t);
        return this;
    }

    public boolean hasGeographicalLocation(String value) {
        if (this.geographicalLocation == null) {
            return false;
        }
        for (StringType v : this.geographicalLocation) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept getDevelopmentStage() {
        if (this.developmentStage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSourceMaterial.developmentStage");
            }
            if (Configuration.doAutoCreate()) {
                this.developmentStage = new CodeableConcept();
            }
        }
        return this.developmentStage;
    }

    public boolean hasDevelopmentStage() {
        return this.developmentStage != null && !this.developmentStage.isEmpty();
    }

    public SubstanceSourceMaterial setDevelopmentStage(CodeableConcept value) {
        this.developmentStage = value;
        return this;
    }

    public List<SubstanceSourceMaterialFractionDescriptionComponent> getFractionDescription() {
        if (this.fractionDescription == null) {
            this.fractionDescription = new ArrayList<SubstanceSourceMaterialFractionDescriptionComponent>();
        }
        return this.fractionDescription;
    }

    public SubstanceSourceMaterial setFractionDescription(List<SubstanceSourceMaterialFractionDescriptionComponent> theFractionDescription) {
        this.fractionDescription = theFractionDescription;
        return this;
    }

    public boolean hasFractionDescription() {
        if (this.fractionDescription == null) {
            return false;
        }
        for (SubstanceSourceMaterialFractionDescriptionComponent item : this.fractionDescription) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceSourceMaterialFractionDescriptionComponent addFractionDescription() {
        SubstanceSourceMaterialFractionDescriptionComponent t = new SubstanceSourceMaterialFractionDescriptionComponent();
        if (this.fractionDescription == null) {
            this.fractionDescription = new ArrayList<SubstanceSourceMaterialFractionDescriptionComponent>();
        }
        this.fractionDescription.add(t);
        return t;
    }

    public SubstanceSourceMaterial addFractionDescription(SubstanceSourceMaterialFractionDescriptionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.fractionDescription == null) {
            this.fractionDescription = new ArrayList<SubstanceSourceMaterialFractionDescriptionComponent>();
        }
        this.fractionDescription.add(t);
        return this;
    }

    public SubstanceSourceMaterialFractionDescriptionComponent getFractionDescriptionFirstRep() {
        if (this.getFractionDescription().isEmpty()) {
            this.addFractionDescription();
        }
        return this.getFractionDescription().get(0);
    }

    public SubstanceSourceMaterialOrganismComponent getOrganism() {
        if (this.organism == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSourceMaterial.organism");
            }
            if (Configuration.doAutoCreate()) {
                this.organism = new SubstanceSourceMaterialOrganismComponent();
            }
        }
        return this.organism;
    }

    public boolean hasOrganism() {
        return this.organism != null && !this.organism.isEmpty();
    }

    public SubstanceSourceMaterial setOrganism(SubstanceSourceMaterialOrganismComponent value) {
        this.organism = value;
        return this;
    }

    public List<SubstanceSourceMaterialPartDescriptionComponent> getPartDescription() {
        if (this.partDescription == null) {
            this.partDescription = new ArrayList<SubstanceSourceMaterialPartDescriptionComponent>();
        }
        return this.partDescription;
    }

    public SubstanceSourceMaterial setPartDescription(List<SubstanceSourceMaterialPartDescriptionComponent> thePartDescription) {
        this.partDescription = thePartDescription;
        return this;
    }

    public boolean hasPartDescription() {
        if (this.partDescription == null) {
            return false;
        }
        for (SubstanceSourceMaterialPartDescriptionComponent item : this.partDescription) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceSourceMaterialPartDescriptionComponent addPartDescription() {
        SubstanceSourceMaterialPartDescriptionComponent t = new SubstanceSourceMaterialPartDescriptionComponent();
        if (this.partDescription == null) {
            this.partDescription = new ArrayList<SubstanceSourceMaterialPartDescriptionComponent>();
        }
        this.partDescription.add(t);
        return t;
    }

    public SubstanceSourceMaterial addPartDescription(SubstanceSourceMaterialPartDescriptionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.partDescription == null) {
            this.partDescription = new ArrayList<SubstanceSourceMaterialPartDescriptionComponent>();
        }
        this.partDescription.add(t);
        return this;
    }

    public SubstanceSourceMaterialPartDescriptionComponent getPartDescriptionFirstRep() {
        if (this.getPartDescription().isEmpty()) {
            this.addPartDescription();
        }
        return this.getPartDescription().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("sourceMaterialClass", "CodeableConcept", "General high level classification of the source material specific to the origin of the material.", 0, 1, this.sourceMaterialClass));
        children.add(new Property("sourceMaterialType", "CodeableConcept", "The type of the source material shall be specified based on a controlled vocabulary. For vaccines, this subclause refers to the class of infectious agent.", 0, 1, this.sourceMaterialType));
        children.add(new Property("sourceMaterialState", "CodeableConcept", "The state of the source material when extracted.", 0, 1, this.sourceMaterialState));
        children.add(new Property("organismId", "Identifier", "The unique identifier associated with the source material parent organism shall be specified.", 0, 1, this.organismId));
        children.add(new Property("organismName", "string", "The organism accepted Scientific name shall be provided based on the organism taxonomy.", 0, 1, this.organismName));
        children.add(new Property("parentSubstanceId", "Identifier", "The parent of the herbal drug Ginkgo biloba, Leaf is the substance ID of the substance (fresh) of Ginkgo biloba L. or Ginkgo biloba L. (Whole plant).", 0, Integer.MAX_VALUE, this.parentSubstanceId));
        children.add(new Property("parentSubstanceName", "string", "The parent substance of the Herbal Drug, or Herbal preparation.", 0, Integer.MAX_VALUE, this.parentSubstanceName));
        children.add(new Property("countryOfOrigin", "CodeableConcept", "The country where the plant material is harvested or the countries where the plasma is sourced from as laid down in accordance with the Plasma Master File. For \u201cPlasma-derived substances\u201d the attribute country of origin provides information about the countries used for the manufacturing of the Cryopoor plama or Crioprecipitate.", 0, Integer.MAX_VALUE, this.countryOfOrigin));
        children.add(new Property("geographicalLocation", "string", "The place/region where the plant is harvested or the places/regions where the animal source material has its habitat.", 0, Integer.MAX_VALUE, this.geographicalLocation));
        children.add(new Property("developmentStage", "CodeableConcept", "Stage of life for animals, plants, insects and microorganisms. This information shall be provided only when the substance is significantly different in these stages (e.g. foetal bovine serum).", 0, 1, this.developmentStage));
        children.add(new Property("fractionDescription", "", "Many complex materials are fractions of parts of plants, animals, or minerals. Fraction elements are often necessary to define both Substances and Specified Group 1 Substances. For substances derived from Plants, fraction information will be captured at the Substance information level ( . Oils, Juices and Exudates). Additional information for Extracts, such as extraction solvent composition, will be captured at the Specified Substance Group 1 information level. For plasma-derived products fraction information will be captured at the Substance and the Specified Substance Group 1 levels.", 0, Integer.MAX_VALUE, this.fractionDescription));
        children.add(new Property("organism", "", "This subclause describes the organism which the substance is derived from. For vaccines, the parent organism shall be specified based on these subclause elements. As an example, full taxonomy will be described for the Substance Name: ., Leaf.", 0, 1, this.organism));
        children.add(new Property("partDescription", "", "To do.", 0, Integer.MAX_VALUE, this.partDescription));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1253081034: {
                return new Property("sourceMaterialClass", "CodeableConcept", "General high level classification of the source material specific to the origin of the material.", 0, 1, this.sourceMaterialClass);
            }
            case 1622665404: {
                return new Property("sourceMaterialType", "CodeableConcept", "The type of the source material shall be specified based on a controlled vocabulary. For vaccines, this subclause refers to the class of infectious agent.", 0, 1, this.sourceMaterialType);
            }
            case -1238066353: {
                return new Property("sourceMaterialState", "CodeableConcept", "The state of the source material when extracted.", 0, 1, this.sourceMaterialState);
            }
            case -1965449843: {
                return new Property("organismId", "Identifier", "The unique identifier associated with the source material parent organism shall be specified.", 0, 1, this.organismId);
            }
            case 988460669: {
                return new Property("organismName", "string", "The organism accepted Scientific name shall be provided based on the organism taxonomy.", 0, 1, this.organismName);
            }
            case -675437663: {
                return new Property("parentSubstanceId", "Identifier", "The parent of the herbal drug Ginkgo biloba, Leaf is the substance ID of the substance (fresh) of Ginkgo biloba L. or Ginkgo biloba L. (Whole plant).", 0, Integer.MAX_VALUE, this.parentSubstanceId);
            }
            case -555382895: {
                return new Property("parentSubstanceName", "string", "The parent substance of the Herbal Drug, or Herbal preparation.", 0, Integer.MAX_VALUE, this.parentSubstanceName);
            }
            case 57176467: {
                return new Property("countryOfOrigin", "CodeableConcept", "The country where the plant material is harvested or the countries where the plasma is sourced from as laid down in accordance with the Plasma Master File. For \u201cPlasma-derived substances\u201d the attribute country of origin provides information about the countries used for the manufacturing of the Cryopoor plama or Crioprecipitate.", 0, Integer.MAX_VALUE, this.countryOfOrigin);
            }
            case -1988836681: {
                return new Property("geographicalLocation", "string", "The place/region where the plant is harvested or the places/regions where the animal source material has its habitat.", 0, Integer.MAX_VALUE, this.geographicalLocation);
            }
            case 391529091: {
                return new Property("developmentStage", "CodeableConcept", "Stage of life for animals, plants, insects and microorganisms. This information shall be provided only when the substance is significantly different in these stages (e.g. foetal bovine serum).", 0, 1, this.developmentStage);
            }
            case 1472689306: {
                return new Property("fractionDescription", "", "Many complex materials are fractions of parts of plants, animals, or minerals. Fraction elements are often necessary to define both Substances and Specified Group 1 Substances. For substances derived from Plants, fraction information will be captured at the Substance information level ( . Oils, Juices and Exudates). Additional information for Extracts, such as extraction solvent composition, will be captured at the Specified Substance Group 1 information level. For plasma-derived products fraction information will be captured at the Substance and the Specified Substance Group 1 levels.", 0, Integer.MAX_VALUE, this.fractionDescription);
            }
            case 1316389074: {
                return new Property("organism", "", "This subclause describes the organism which the substance is derived from. For vaccines, the parent organism shall be specified based on these subclause elements. As an example, full taxonomy will be described for the Substance Name: ., Leaf.", 0, 1, this.organism);
            }
            case -1803623927: {
                return new Property("partDescription", "", "To do.", 0, Integer.MAX_VALUE, this.partDescription);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1253081034: {
                Base[] baseArray;
                if (this.sourceMaterialClass == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.sourceMaterialClass;
                }
                return baseArray;
            }
            case 1622665404: {
                Base[] baseArray;
                if (this.sourceMaterialType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.sourceMaterialType;
                }
                return baseArray;
            }
            case -1238066353: {
                Base[] baseArray;
                if (this.sourceMaterialState == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.sourceMaterialState;
                }
                return baseArray;
            }
            case -1965449843: {
                Base[] baseArray;
                if (this.organismId == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.organismId;
                }
                return baseArray;
            }
            case 988460669: {
                Base[] baseArray;
                if (this.organismName == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.organismName;
                }
                return baseArray;
            }
            case -675437663: {
                return this.parentSubstanceId == null ? new Base[]{} : this.parentSubstanceId.toArray(new Base[this.parentSubstanceId.size()]);
            }
            case -555382895: {
                return this.parentSubstanceName == null ? new Base[]{} : this.parentSubstanceName.toArray(new Base[this.parentSubstanceName.size()]);
            }
            case 57176467: {
                return this.countryOfOrigin == null ? new Base[]{} : this.countryOfOrigin.toArray(new Base[this.countryOfOrigin.size()]);
            }
            case -1988836681: {
                return this.geographicalLocation == null ? new Base[]{} : this.geographicalLocation.toArray(new Base[this.geographicalLocation.size()]);
            }
            case 391529091: {
                Base[] baseArray;
                if (this.developmentStage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.developmentStage;
                }
                return baseArray;
            }
            case 1472689306: {
                return this.fractionDescription == null ? new Base[]{} : this.fractionDescription.toArray(new Base[this.fractionDescription.size()]);
            }
            case 1316389074: {
                Base[] baseArray;
                if (this.organism == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.organism;
                }
                return baseArray;
            }
            case -1803623927: {
                return this.partDescription == null ? new Base[]{} : this.partDescription.toArray(new Base[this.partDescription.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1253081034: {
                this.sourceMaterialClass = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1622665404: {
                this.sourceMaterialType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1238066353: {
                this.sourceMaterialState = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1965449843: {
                this.organismId = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case 988460669: {
                this.organismName = TypeConvertor.castToString(value);
                return value;
            }
            case -675437663: {
                this.getParentSubstanceId().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -555382895: {
                this.getParentSubstanceName().add(TypeConvertor.castToString(value));
                return value;
            }
            case 57176467: {
                this.getCountryOfOrigin().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1988836681: {
                this.getGeographicalLocation().add(TypeConvertor.castToString(value));
                return value;
            }
            case 391529091: {
                this.developmentStage = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1472689306: {
                this.getFractionDescription().add((SubstanceSourceMaterialFractionDescriptionComponent)value);
                return value;
            }
            case 1316389074: {
                this.organism = (SubstanceSourceMaterialOrganismComponent)value;
                return value;
            }
            case -1803623927: {
                this.getPartDescription().add((SubstanceSourceMaterialPartDescriptionComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("sourceMaterialClass")) {
            this.sourceMaterialClass = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("sourceMaterialType")) {
            this.sourceMaterialType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("sourceMaterialState")) {
            this.sourceMaterialState = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("organismId")) {
            this.organismId = TypeConvertor.castToIdentifier(value);
        } else if (name.equals("organismName")) {
            this.organismName = TypeConvertor.castToString(value);
        } else if (name.equals("parentSubstanceId")) {
            this.getParentSubstanceId().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("parentSubstanceName")) {
            this.getParentSubstanceName().add(TypeConvertor.castToString(value));
        } else if (name.equals("countryOfOrigin")) {
            this.getCountryOfOrigin().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("geographicalLocation")) {
            this.getGeographicalLocation().add(TypeConvertor.castToString(value));
        } else if (name.equals("developmentStage")) {
            this.developmentStage = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("fractionDescription")) {
            this.getFractionDescription().add((SubstanceSourceMaterialFractionDescriptionComponent)value);
        } else if (name.equals("organism")) {
            this.organism = (SubstanceSourceMaterialOrganismComponent)value;
        } else if (name.equals("partDescription")) {
            this.getPartDescription().add((SubstanceSourceMaterialPartDescriptionComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1253081034: {
                return this.getSourceMaterialClass();
            }
            case 1622665404: {
                return this.getSourceMaterialType();
            }
            case -1238066353: {
                return this.getSourceMaterialState();
            }
            case -1965449843: {
                return this.getOrganismId();
            }
            case 988460669: {
                return this.getOrganismNameElement();
            }
            case -675437663: {
                return this.addParentSubstanceId();
            }
            case -555382895: {
                return this.addParentSubstanceNameElement();
            }
            case 57176467: {
                return this.addCountryOfOrigin();
            }
            case -1988836681: {
                return this.addGeographicalLocationElement();
            }
            case 391529091: {
                return this.getDevelopmentStage();
            }
            case 1472689306: {
                return this.addFractionDescription();
            }
            case 1316389074: {
                return this.getOrganism();
            }
            case -1803623927: {
                return this.addPartDescription();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1253081034: {
                return new String[]{"CodeableConcept"};
            }
            case 1622665404: {
                return new String[]{"CodeableConcept"};
            }
            case -1238066353: {
                return new String[]{"CodeableConcept"};
            }
            case -1965449843: {
                return new String[]{"Identifier"};
            }
            case 988460669: {
                return new String[]{"string"};
            }
            case -675437663: {
                return new String[]{"Identifier"};
            }
            case -555382895: {
                return new String[]{"string"};
            }
            case 57176467: {
                return new String[]{"CodeableConcept"};
            }
            case -1988836681: {
                return new String[]{"string"};
            }
            case 391529091: {
                return new String[]{"CodeableConcept"};
            }
            case 1472689306: {
                return new String[0];
            }
            case 1316389074: {
                return new String[0];
            }
            case -1803623927: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("sourceMaterialClass")) {
            this.sourceMaterialClass = new CodeableConcept();
            return this.sourceMaterialClass;
        }
        if (name.equals("sourceMaterialType")) {
            this.sourceMaterialType = new CodeableConcept();
            return this.sourceMaterialType;
        }
        if (name.equals("sourceMaterialState")) {
            this.sourceMaterialState = new CodeableConcept();
            return this.sourceMaterialState;
        }
        if (name.equals("organismId")) {
            this.organismId = new Identifier();
            return this.organismId;
        }
        if (name.equals("organismName")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubstanceSourceMaterial.organismName");
        }
        if (name.equals("parentSubstanceId")) {
            return this.addParentSubstanceId();
        }
        if (name.equals("parentSubstanceName")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubstanceSourceMaterial.parentSubstanceName");
        }
        if (name.equals("countryOfOrigin")) {
            return this.addCountryOfOrigin();
        }
        if (name.equals("geographicalLocation")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubstanceSourceMaterial.geographicalLocation");
        }
        if (name.equals("developmentStage")) {
            this.developmentStage = new CodeableConcept();
            return this.developmentStage;
        }
        if (name.equals("fractionDescription")) {
            return this.addFractionDescription();
        }
        if (name.equals("organism")) {
            this.organism = new SubstanceSourceMaterialOrganismComponent();
            return this.organism;
        }
        if (name.equals("partDescription")) {
            return this.addPartDescription();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SubstanceSourceMaterial";
    }

    @Override
    public SubstanceSourceMaterial copy() {
        SubstanceSourceMaterial dst = new SubstanceSourceMaterial();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SubstanceSourceMaterial dst) {
        super.copyValues(dst);
        dst.sourceMaterialClass = this.sourceMaterialClass == null ? null : this.sourceMaterialClass.copy();
        dst.sourceMaterialType = this.sourceMaterialType == null ? null : this.sourceMaterialType.copy();
        dst.sourceMaterialState = this.sourceMaterialState == null ? null : this.sourceMaterialState.copy();
        dst.organismId = this.organismId == null ? null : this.organismId.copy();
        StringType stringType = dst.organismName = this.organismName == null ? null : this.organismName.copy();
        if (this.parentSubstanceId != null) {
            dst.parentSubstanceId = new ArrayList<Identifier>();
            for (Identifier identifier : this.parentSubstanceId) {
                dst.parentSubstanceId.add(identifier.copy());
            }
        }
        if (this.parentSubstanceName != null) {
            dst.parentSubstanceName = new ArrayList<StringType>();
            for (StringType stringType2 : this.parentSubstanceName) {
                dst.parentSubstanceName.add(stringType2.copy());
            }
        }
        if (this.countryOfOrigin != null) {
            dst.countryOfOrigin = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.countryOfOrigin) {
                dst.countryOfOrigin.add(codeableConcept.copy());
            }
        }
        if (this.geographicalLocation != null) {
            dst.geographicalLocation = new ArrayList<StringType>();
            for (StringType stringType3 : this.geographicalLocation) {
                dst.geographicalLocation.add(stringType3.copy());
            }
        }
        CodeableConcept codeableConcept = dst.developmentStage = this.developmentStage == null ? null : this.developmentStage.copy();
        if (this.fractionDescription != null) {
            dst.fractionDescription = new ArrayList<SubstanceSourceMaterialFractionDescriptionComponent>();
            for (SubstanceSourceMaterialFractionDescriptionComponent substanceSourceMaterialFractionDescriptionComponent : this.fractionDescription) {
                dst.fractionDescription.add(substanceSourceMaterialFractionDescriptionComponent.copy());
            }
        }
        SubstanceSourceMaterialOrganismComponent substanceSourceMaterialOrganismComponent = dst.organism = this.organism == null ? null : this.organism.copy();
        if (this.partDescription != null) {
            dst.partDescription = new ArrayList<SubstanceSourceMaterialPartDescriptionComponent>();
            for (SubstanceSourceMaterialPartDescriptionComponent substanceSourceMaterialPartDescriptionComponent : this.partDescription) {
                dst.partDescription.add(substanceSourceMaterialPartDescriptionComponent.copy());
            }
        }
    }

    protected SubstanceSourceMaterial typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceSourceMaterial)) {
            return false;
        }
        SubstanceSourceMaterial o = (SubstanceSourceMaterial)other_;
        return SubstanceSourceMaterial.compareDeep(this.sourceMaterialClass, o.sourceMaterialClass, true) && SubstanceSourceMaterial.compareDeep(this.sourceMaterialType, o.sourceMaterialType, true) && SubstanceSourceMaterial.compareDeep(this.sourceMaterialState, o.sourceMaterialState, true) && SubstanceSourceMaterial.compareDeep(this.organismId, o.organismId, true) && SubstanceSourceMaterial.compareDeep(this.organismName, o.organismName, true) && SubstanceSourceMaterial.compareDeep(this.parentSubstanceId, o.parentSubstanceId, true) && SubstanceSourceMaterial.compareDeep(this.parentSubstanceName, o.parentSubstanceName, true) && SubstanceSourceMaterial.compareDeep(this.countryOfOrigin, o.countryOfOrigin, true) && SubstanceSourceMaterial.compareDeep(this.geographicalLocation, o.geographicalLocation, true) && SubstanceSourceMaterial.compareDeep(this.developmentStage, o.developmentStage, true) && SubstanceSourceMaterial.compareDeep(this.fractionDescription, o.fractionDescription, true) && SubstanceSourceMaterial.compareDeep(this.organism, o.organism, true) && SubstanceSourceMaterial.compareDeep(this.partDescription, o.partDescription, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceSourceMaterial)) {
            return false;
        }
        SubstanceSourceMaterial o = (SubstanceSourceMaterial)other_;
        return SubstanceSourceMaterial.compareValues(this.organismName, o.organismName, true) && SubstanceSourceMaterial.compareValues(this.parentSubstanceName, o.parentSubstanceName, true) && SubstanceSourceMaterial.compareValues(this.geographicalLocation, o.geographicalLocation, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sourceMaterialClass, this.sourceMaterialType, this.sourceMaterialState, this.organismId, this.organismName, this.parentSubstanceId, this.parentSubstanceName, this.countryOfOrigin, this.geographicalLocation, this.developmentStage, this.fractionDescription, this.organism, this.partDescription});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SubstanceSourceMaterial;
    }

    @Block
    public static class SubstanceSourceMaterialPartDescriptionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="part", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Entity of anatomical origin of source material within an organism", formalDefinition="Entity of anatomical origin of source material within an organism.")
        protected CodeableConcept part;
        @Child(name="partLocation", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The detailed anatomic location when the part can be extracted from different anatomical locations of the organism. Multiple alternative locations may apply", formalDefinition="The detailed anatomic location when the part can be extracted from different anatomical locations of the organism. Multiple alternative locations may apply.")
        protected CodeableConcept partLocation;
        private static final long serialVersionUID = 308875915L;

        public CodeableConcept getPart() {
            if (this.part == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialPartDescriptionComponent.part");
                }
                if (Configuration.doAutoCreate()) {
                    this.part = new CodeableConcept();
                }
            }
            return this.part;
        }

        public boolean hasPart() {
            return this.part != null && !this.part.isEmpty();
        }

        public SubstanceSourceMaterialPartDescriptionComponent setPart(CodeableConcept value) {
            this.part = value;
            return this;
        }

        public CodeableConcept getPartLocation() {
            if (this.partLocation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialPartDescriptionComponent.partLocation");
                }
                if (Configuration.doAutoCreate()) {
                    this.partLocation = new CodeableConcept();
                }
            }
            return this.partLocation;
        }

        public boolean hasPartLocation() {
            return this.partLocation != null && !this.partLocation.isEmpty();
        }

        public SubstanceSourceMaterialPartDescriptionComponent setPartLocation(CodeableConcept value) {
            this.partLocation = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("part", "CodeableConcept", "Entity of anatomical origin of source material within an organism.", 0, 1, this.part));
            children.add(new Property("partLocation", "CodeableConcept", "The detailed anatomic location when the part can be extracted from different anatomical locations of the organism. Multiple alternative locations may apply.", 0, 1, this.partLocation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3433459: {
                    return new Property("part", "CodeableConcept", "Entity of anatomical origin of source material within an organism.", 0, 1, this.part);
                }
                case 893437128: {
                    return new Property("partLocation", "CodeableConcept", "The detailed anatomic location when the part can be extracted from different anatomical locations of the organism. Multiple alternative locations may apply.", 0, 1, this.partLocation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433459: {
                    Base[] baseArray;
                    if (this.part == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.part;
                    }
                    return baseArray;
                }
                case 893437128: {
                    Base[] baseArray;
                    if (this.partLocation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.partLocation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433459: {
                    this.part = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 893437128: {
                    this.partLocation = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("part")) {
                this.part = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("partLocation")) {
                this.partLocation = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433459: {
                    return this.getPart();
                }
                case 893437128: {
                    return this.getPartLocation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433459: {
                    return new String[]{"CodeableConcept"};
                }
                case 893437128: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("part")) {
                this.part = new CodeableConcept();
                return this.part;
            }
            if (name.equals("partLocation")) {
                this.partLocation = new CodeableConcept();
                return this.partLocation;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSourceMaterialPartDescriptionComponent copy() {
            SubstanceSourceMaterialPartDescriptionComponent dst = new SubstanceSourceMaterialPartDescriptionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceSourceMaterialPartDescriptionComponent dst) {
            super.copyValues(dst);
            dst.part = this.part == null ? null : this.part.copy();
            dst.partLocation = this.partLocation == null ? null : this.partLocation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSourceMaterialPartDescriptionComponent)) {
                return false;
            }
            SubstanceSourceMaterialPartDescriptionComponent o = (SubstanceSourceMaterialPartDescriptionComponent)other_;
            return SubstanceSourceMaterialPartDescriptionComponent.compareDeep(this.part, o.part, true) && SubstanceSourceMaterialPartDescriptionComponent.compareDeep(this.partLocation, o.partLocation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSourceMaterialPartDescriptionComponent)) {
                return false;
            }
            SubstanceSourceMaterialPartDescriptionComponent o = (SubstanceSourceMaterialPartDescriptionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.part, this.partLocation});
        }

        @Override
        public String fhirType() {
            return "SubstanceSourceMaterial.partDescription";
        }
    }

    @Block
    public static class SubstanceSourceMaterialOrganismOrganismGeneralComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="kingdom", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The kingdom of an organism shall be specified", formalDefinition="The kingdom of an organism shall be specified.")
        protected CodeableConcept kingdom;
        @Child(name="phylum", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The phylum of an organism shall be specified", formalDefinition="The phylum of an organism shall be specified.")
        protected CodeableConcept phylum;
        @Child(name="class", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The class of an organism shall be specified", formalDefinition="The class of an organism shall be specified.")
        protected CodeableConcept class_;
        @Child(name="order", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The order of an organism shall be specified,", formalDefinition="The order of an organism shall be specified,.")
        protected CodeableConcept order;
        private static final long serialVersionUID = 659838613L;

        public CodeableConcept getKingdom() {
            if (this.kingdom == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismOrganismGeneralComponent.kingdom");
                }
                if (Configuration.doAutoCreate()) {
                    this.kingdom = new CodeableConcept();
                }
            }
            return this.kingdom;
        }

        public boolean hasKingdom() {
            return this.kingdom != null && !this.kingdom.isEmpty();
        }

        public SubstanceSourceMaterialOrganismOrganismGeneralComponent setKingdom(CodeableConcept value) {
            this.kingdom = value;
            return this;
        }

        public CodeableConcept getPhylum() {
            if (this.phylum == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismOrganismGeneralComponent.phylum");
                }
                if (Configuration.doAutoCreate()) {
                    this.phylum = new CodeableConcept();
                }
            }
            return this.phylum;
        }

        public boolean hasPhylum() {
            return this.phylum != null && !this.phylum.isEmpty();
        }

        public SubstanceSourceMaterialOrganismOrganismGeneralComponent setPhylum(CodeableConcept value) {
            this.phylum = value;
            return this;
        }

        public CodeableConcept getClass_() {
            if (this.class_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismOrganismGeneralComponent.class_");
                }
                if (Configuration.doAutoCreate()) {
                    this.class_ = new CodeableConcept();
                }
            }
            return this.class_;
        }

        public boolean hasClass_() {
            return this.class_ != null && !this.class_.isEmpty();
        }

        public SubstanceSourceMaterialOrganismOrganismGeneralComponent setClass_(CodeableConcept value) {
            this.class_ = value;
            return this;
        }

        public CodeableConcept getOrder() {
            if (this.order == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismOrganismGeneralComponent.order");
                }
                if (Configuration.doAutoCreate()) {
                    this.order = new CodeableConcept();
                }
            }
            return this.order;
        }

        public boolean hasOrder() {
            return this.order != null && !this.order.isEmpty();
        }

        public SubstanceSourceMaterialOrganismOrganismGeneralComponent setOrder(CodeableConcept value) {
            this.order = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("kingdom", "CodeableConcept", "The kingdom of an organism shall be specified.", 0, 1, this.kingdom));
            children.add(new Property("phylum", "CodeableConcept", "The phylum of an organism shall be specified.", 0, 1, this.phylum));
            children.add(new Property("class", "CodeableConcept", "The class of an organism shall be specified.", 0, 1, this.class_));
            children.add(new Property("order", "CodeableConcept", "The order of an organism shall be specified,.", 0, 1, this.order));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -710537653: {
                    return new Property("kingdom", "CodeableConcept", "The kingdom of an organism shall be specified.", 0, 1, this.kingdom);
                }
                case -988743965: {
                    return new Property("phylum", "CodeableConcept", "The phylum of an organism shall be specified.", 0, 1, this.phylum);
                }
                case 94742904: {
                    return new Property("class", "CodeableConcept", "The class of an organism shall be specified.", 0, 1, this.class_);
                }
                case 106006350: {
                    return new Property("order", "CodeableConcept", "The order of an organism shall be specified,.", 0, 1, this.order);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -710537653: {
                    Base[] baseArray;
                    if (this.kingdom == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.kingdom;
                    }
                    return baseArray;
                }
                case -988743965: {
                    Base[] baseArray;
                    if (this.phylum == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.phylum;
                    }
                    return baseArray;
                }
                case 94742904: {
                    Base[] baseArray;
                    if (this.class_ == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.class_;
                    }
                    return baseArray;
                }
                case 106006350: {
                    Base[] baseArray;
                    if (this.order == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.order;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -710537653: {
                    this.kingdom = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -988743965: {
                    this.phylum = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 94742904: {
                    this.class_ = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 106006350: {
                    this.order = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("kingdom")) {
                this.kingdom = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("phylum")) {
                this.phylum = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("class")) {
                this.class_ = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("order")) {
                this.order = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -710537653: {
                    return this.getKingdom();
                }
                case -988743965: {
                    return this.getPhylum();
                }
                case 94742904: {
                    return this.getClass_();
                }
                case 106006350: {
                    return this.getOrder();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -710537653: {
                    return new String[]{"CodeableConcept"};
                }
                case -988743965: {
                    return new String[]{"CodeableConcept"};
                }
                case 94742904: {
                    return new String[]{"CodeableConcept"};
                }
                case 106006350: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("kingdom")) {
                this.kingdom = new CodeableConcept();
                return this.kingdom;
            }
            if (name.equals("phylum")) {
                this.phylum = new CodeableConcept();
                return this.phylum;
            }
            if (name.equals("class")) {
                this.class_ = new CodeableConcept();
                return this.class_;
            }
            if (name.equals("order")) {
                this.order = new CodeableConcept();
                return this.order;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSourceMaterialOrganismOrganismGeneralComponent copy() {
            SubstanceSourceMaterialOrganismOrganismGeneralComponent dst = new SubstanceSourceMaterialOrganismOrganismGeneralComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceSourceMaterialOrganismOrganismGeneralComponent dst) {
            super.copyValues(dst);
            dst.kingdom = this.kingdom == null ? null : this.kingdom.copy();
            dst.phylum = this.phylum == null ? null : this.phylum.copy();
            dst.class_ = this.class_ == null ? null : this.class_.copy();
            dst.order = this.order == null ? null : this.order.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSourceMaterialOrganismOrganismGeneralComponent)) {
                return false;
            }
            SubstanceSourceMaterialOrganismOrganismGeneralComponent o = (SubstanceSourceMaterialOrganismOrganismGeneralComponent)other_;
            return SubstanceSourceMaterialOrganismOrganismGeneralComponent.compareDeep(this.kingdom, o.kingdom, true) && SubstanceSourceMaterialOrganismOrganismGeneralComponent.compareDeep(this.phylum, o.phylum, true) && SubstanceSourceMaterialOrganismOrganismGeneralComponent.compareDeep(this.class_, o.class_, true) && SubstanceSourceMaterialOrganismOrganismGeneralComponent.compareDeep(this.order, o.order, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSourceMaterialOrganismOrganismGeneralComponent)) {
                return false;
            }
            SubstanceSourceMaterialOrganismOrganismGeneralComponent o = (SubstanceSourceMaterialOrganismOrganismGeneralComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.kingdom, this.phylum, this.class_, this.order});
        }

        @Override
        public String fhirType() {
            return "SubstanceSourceMaterial.organism.organismGeneral";
        }
    }

    @Block
    public static class SubstanceSourceMaterialOrganismHybridComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="maternalOrganismId", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The identifier of the maternal species constituting the hybrid organism shall be specified based on a controlled vocabulary. For plants, the parents aren\u2019t always known, and it is unlikely that it will be known which is maternal and which is paternal", formalDefinition="The identifier of the maternal species constituting the hybrid organism shall be specified based on a controlled vocabulary. For plants, the parents aren\u2019t always known, and it is unlikely that it will be known which is maternal and which is paternal.")
        protected StringType maternalOrganismId;
        @Child(name="maternalOrganismName", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The name of the maternal species constituting the hybrid organism shall be specified. For plants, the parents aren\u2019t always known, and it is unlikely that it will be known which is maternal and which is paternal", formalDefinition="The name of the maternal species constituting the hybrid organism shall be specified. For plants, the parents aren\u2019t always known, and it is unlikely that it will be known which is maternal and which is paternal.")
        protected StringType maternalOrganismName;
        @Child(name="paternalOrganismId", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The identifier of the paternal species constituting the hybrid organism shall be specified based on a controlled vocabulary", formalDefinition="The identifier of the paternal species constituting the hybrid organism shall be specified based on a controlled vocabulary.")
        protected StringType paternalOrganismId;
        @Child(name="paternalOrganismName", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The name of the paternal species constituting the hybrid organism shall be specified", formalDefinition="The name of the paternal species constituting the hybrid organism shall be specified.")
        protected StringType paternalOrganismName;
        @Child(name="hybridType", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The hybrid type of an organism shall be specified", formalDefinition="The hybrid type of an organism shall be specified.")
        protected CodeableConcept hybridType;
        private static final long serialVersionUID = 1981189787L;

        public StringType getMaternalOrganismIdElement() {
            if (this.maternalOrganismId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismHybridComponent.maternalOrganismId");
                }
                if (Configuration.doAutoCreate()) {
                    this.maternalOrganismId = new StringType();
                }
            }
            return this.maternalOrganismId;
        }

        public boolean hasMaternalOrganismIdElement() {
            return this.maternalOrganismId != null && !this.maternalOrganismId.isEmpty();
        }

        public boolean hasMaternalOrganismId() {
            return this.maternalOrganismId != null && !this.maternalOrganismId.isEmpty();
        }

        public SubstanceSourceMaterialOrganismHybridComponent setMaternalOrganismIdElement(StringType value) {
            this.maternalOrganismId = value;
            return this;
        }

        public String getMaternalOrganismId() {
            return this.maternalOrganismId == null ? null : (String)this.maternalOrganismId.getValue();
        }

        public SubstanceSourceMaterialOrganismHybridComponent setMaternalOrganismId(String value) {
            if (Utilities.noString((String)value)) {
                this.maternalOrganismId = null;
            } else {
                if (this.maternalOrganismId == null) {
                    this.maternalOrganismId = new StringType();
                }
                this.maternalOrganismId.setValue(value);
            }
            return this;
        }

        public StringType getMaternalOrganismNameElement() {
            if (this.maternalOrganismName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismHybridComponent.maternalOrganismName");
                }
                if (Configuration.doAutoCreate()) {
                    this.maternalOrganismName = new StringType();
                }
            }
            return this.maternalOrganismName;
        }

        public boolean hasMaternalOrganismNameElement() {
            return this.maternalOrganismName != null && !this.maternalOrganismName.isEmpty();
        }

        public boolean hasMaternalOrganismName() {
            return this.maternalOrganismName != null && !this.maternalOrganismName.isEmpty();
        }

        public SubstanceSourceMaterialOrganismHybridComponent setMaternalOrganismNameElement(StringType value) {
            this.maternalOrganismName = value;
            return this;
        }

        public String getMaternalOrganismName() {
            return this.maternalOrganismName == null ? null : (String)this.maternalOrganismName.getValue();
        }

        public SubstanceSourceMaterialOrganismHybridComponent setMaternalOrganismName(String value) {
            if (Utilities.noString((String)value)) {
                this.maternalOrganismName = null;
            } else {
                if (this.maternalOrganismName == null) {
                    this.maternalOrganismName = new StringType();
                }
                this.maternalOrganismName.setValue(value);
            }
            return this;
        }

        public StringType getPaternalOrganismIdElement() {
            if (this.paternalOrganismId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismHybridComponent.paternalOrganismId");
                }
                if (Configuration.doAutoCreate()) {
                    this.paternalOrganismId = new StringType();
                }
            }
            return this.paternalOrganismId;
        }

        public boolean hasPaternalOrganismIdElement() {
            return this.paternalOrganismId != null && !this.paternalOrganismId.isEmpty();
        }

        public boolean hasPaternalOrganismId() {
            return this.paternalOrganismId != null && !this.paternalOrganismId.isEmpty();
        }

        public SubstanceSourceMaterialOrganismHybridComponent setPaternalOrganismIdElement(StringType value) {
            this.paternalOrganismId = value;
            return this;
        }

        public String getPaternalOrganismId() {
            return this.paternalOrganismId == null ? null : (String)this.paternalOrganismId.getValue();
        }

        public SubstanceSourceMaterialOrganismHybridComponent setPaternalOrganismId(String value) {
            if (Utilities.noString((String)value)) {
                this.paternalOrganismId = null;
            } else {
                if (this.paternalOrganismId == null) {
                    this.paternalOrganismId = new StringType();
                }
                this.paternalOrganismId.setValue(value);
            }
            return this;
        }

        public StringType getPaternalOrganismNameElement() {
            if (this.paternalOrganismName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismHybridComponent.paternalOrganismName");
                }
                if (Configuration.doAutoCreate()) {
                    this.paternalOrganismName = new StringType();
                }
            }
            return this.paternalOrganismName;
        }

        public boolean hasPaternalOrganismNameElement() {
            return this.paternalOrganismName != null && !this.paternalOrganismName.isEmpty();
        }

        public boolean hasPaternalOrganismName() {
            return this.paternalOrganismName != null && !this.paternalOrganismName.isEmpty();
        }

        public SubstanceSourceMaterialOrganismHybridComponent setPaternalOrganismNameElement(StringType value) {
            this.paternalOrganismName = value;
            return this;
        }

        public String getPaternalOrganismName() {
            return this.paternalOrganismName == null ? null : (String)this.paternalOrganismName.getValue();
        }

        public SubstanceSourceMaterialOrganismHybridComponent setPaternalOrganismName(String value) {
            if (Utilities.noString((String)value)) {
                this.paternalOrganismName = null;
            } else {
                if (this.paternalOrganismName == null) {
                    this.paternalOrganismName = new StringType();
                }
                this.paternalOrganismName.setValue(value);
            }
            return this;
        }

        public CodeableConcept getHybridType() {
            if (this.hybridType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismHybridComponent.hybridType");
                }
                if (Configuration.doAutoCreate()) {
                    this.hybridType = new CodeableConcept();
                }
            }
            return this.hybridType;
        }

        public boolean hasHybridType() {
            return this.hybridType != null && !this.hybridType.isEmpty();
        }

        public SubstanceSourceMaterialOrganismHybridComponent setHybridType(CodeableConcept value) {
            this.hybridType = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("maternalOrganismId", "string", "The identifier of the maternal species constituting the hybrid organism shall be specified based on a controlled vocabulary. For plants, the parents aren\u2019t always known, and it is unlikely that it will be known which is maternal and which is paternal.", 0, 1, this.maternalOrganismId));
            children.add(new Property("maternalOrganismName", "string", "The name of the maternal species constituting the hybrid organism shall be specified. For plants, the parents aren\u2019t always known, and it is unlikely that it will be known which is maternal and which is paternal.", 0, 1, this.maternalOrganismName));
            children.add(new Property("paternalOrganismId", "string", "The identifier of the paternal species constituting the hybrid organism shall be specified based on a controlled vocabulary.", 0, 1, this.paternalOrganismId));
            children.add(new Property("paternalOrganismName", "string", "The name of the paternal species constituting the hybrid organism shall be specified.", 0, 1, this.paternalOrganismName));
            children.add(new Property("hybridType", "CodeableConcept", "The hybrid type of an organism shall be specified.", 0, 1, this.hybridType));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1179977063: {
                    return new Property("maternalOrganismId", "string", "The identifier of the maternal species constituting the hybrid organism shall be specified based on a controlled vocabulary. For plants, the parents aren\u2019t always known, and it is unlikely that it will be known which is maternal and which is paternal.", 0, 1, this.maternalOrganismId);
                }
                case -86441847: {
                    return new Property("maternalOrganismName", "string", "The name of the maternal species constituting the hybrid organism shall be specified. For plants, the parents aren\u2019t always known, and it is unlikely that it will be known which is maternal and which is paternal.", 0, 1, this.maternalOrganismName);
                }
                case 123773174: {
                    return new Property("paternalOrganismId", "string", "The identifier of the paternal species constituting the hybrid organism shall be specified based on a controlled vocabulary.", 0, 1, this.paternalOrganismId);
                }
                case -1312914522: {
                    return new Property("paternalOrganismName", "string", "The name of the paternal species constituting the hybrid organism shall be specified.", 0, 1, this.paternalOrganismName);
                }
                case 1572734806: {
                    return new Property("hybridType", "CodeableConcept", "The hybrid type of an organism shall be specified.", 0, 1, this.hybridType);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1179977063: {
                    Base[] baseArray;
                    if (this.maternalOrganismId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.maternalOrganismId;
                    }
                    return baseArray;
                }
                case -86441847: {
                    Base[] baseArray;
                    if (this.maternalOrganismName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.maternalOrganismName;
                    }
                    return baseArray;
                }
                case 123773174: {
                    Base[] baseArray;
                    if (this.paternalOrganismId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.paternalOrganismId;
                    }
                    return baseArray;
                }
                case -1312914522: {
                    Base[] baseArray;
                    if (this.paternalOrganismName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.paternalOrganismName;
                    }
                    return baseArray;
                }
                case 1572734806: {
                    Base[] baseArray;
                    if (this.hybridType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.hybridType;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1179977063: {
                    this.maternalOrganismId = TypeConvertor.castToString(value);
                    return value;
                }
                case -86441847: {
                    this.maternalOrganismName = TypeConvertor.castToString(value);
                    return value;
                }
                case 123773174: {
                    this.paternalOrganismId = TypeConvertor.castToString(value);
                    return value;
                }
                case -1312914522: {
                    this.paternalOrganismName = TypeConvertor.castToString(value);
                    return value;
                }
                case 1572734806: {
                    this.hybridType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("maternalOrganismId")) {
                this.maternalOrganismId = TypeConvertor.castToString(value);
            } else if (name.equals("maternalOrganismName")) {
                this.maternalOrganismName = TypeConvertor.castToString(value);
            } else if (name.equals("paternalOrganismId")) {
                this.paternalOrganismId = TypeConvertor.castToString(value);
            } else if (name.equals("paternalOrganismName")) {
                this.paternalOrganismName = TypeConvertor.castToString(value);
            } else if (name.equals("hybridType")) {
                this.hybridType = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1179977063: {
                    return this.getMaternalOrganismIdElement();
                }
                case -86441847: {
                    return this.getMaternalOrganismNameElement();
                }
                case 123773174: {
                    return this.getPaternalOrganismIdElement();
                }
                case -1312914522: {
                    return this.getPaternalOrganismNameElement();
                }
                case 1572734806: {
                    return this.getHybridType();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1179977063: {
                    return new String[]{"string"};
                }
                case -86441847: {
                    return new String[]{"string"};
                }
                case 123773174: {
                    return new String[]{"string"};
                }
                case -1312914522: {
                    return new String[]{"string"};
                }
                case 1572734806: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("maternalOrganismId")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSourceMaterial.organism.hybrid.maternalOrganismId");
            }
            if (name.equals("maternalOrganismName")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSourceMaterial.organism.hybrid.maternalOrganismName");
            }
            if (name.equals("paternalOrganismId")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSourceMaterial.organism.hybrid.paternalOrganismId");
            }
            if (name.equals("paternalOrganismName")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSourceMaterial.organism.hybrid.paternalOrganismName");
            }
            if (name.equals("hybridType")) {
                this.hybridType = new CodeableConcept();
                return this.hybridType;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSourceMaterialOrganismHybridComponent copy() {
            SubstanceSourceMaterialOrganismHybridComponent dst = new SubstanceSourceMaterialOrganismHybridComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceSourceMaterialOrganismHybridComponent dst) {
            super.copyValues(dst);
            dst.maternalOrganismId = this.maternalOrganismId == null ? null : this.maternalOrganismId.copy();
            dst.maternalOrganismName = this.maternalOrganismName == null ? null : this.maternalOrganismName.copy();
            dst.paternalOrganismId = this.paternalOrganismId == null ? null : this.paternalOrganismId.copy();
            dst.paternalOrganismName = this.paternalOrganismName == null ? null : this.paternalOrganismName.copy();
            dst.hybridType = this.hybridType == null ? null : this.hybridType.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSourceMaterialOrganismHybridComponent)) {
                return false;
            }
            SubstanceSourceMaterialOrganismHybridComponent o = (SubstanceSourceMaterialOrganismHybridComponent)other_;
            return SubstanceSourceMaterialOrganismHybridComponent.compareDeep(this.maternalOrganismId, o.maternalOrganismId, true) && SubstanceSourceMaterialOrganismHybridComponent.compareDeep(this.maternalOrganismName, o.maternalOrganismName, true) && SubstanceSourceMaterialOrganismHybridComponent.compareDeep(this.paternalOrganismId, o.paternalOrganismId, true) && SubstanceSourceMaterialOrganismHybridComponent.compareDeep(this.paternalOrganismName, o.paternalOrganismName, true) && SubstanceSourceMaterialOrganismHybridComponent.compareDeep(this.hybridType, o.hybridType, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSourceMaterialOrganismHybridComponent)) {
                return false;
            }
            SubstanceSourceMaterialOrganismHybridComponent o = (SubstanceSourceMaterialOrganismHybridComponent)other_;
            return SubstanceSourceMaterialOrganismHybridComponent.compareValues(this.maternalOrganismId, o.maternalOrganismId, true) && SubstanceSourceMaterialOrganismHybridComponent.compareValues(this.maternalOrganismName, o.maternalOrganismName, true) && SubstanceSourceMaterialOrganismHybridComponent.compareValues(this.paternalOrganismId, o.paternalOrganismId, true) && SubstanceSourceMaterialOrganismHybridComponent.compareValues(this.paternalOrganismName, o.paternalOrganismName, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.maternalOrganismId, this.maternalOrganismName, this.paternalOrganismId, this.paternalOrganismName, this.hybridType});
        }

        @Override
        public String fhirType() {
            return "SubstanceSourceMaterial.organism.hybrid";
        }
    }

    @Block
    public static class SubstanceSourceMaterialOrganismAuthorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="authorType", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of author of an organism species shall be specified. The parenthetical author of an organism species refers to the first author who published the plant/animal name (of any rank). The primary author of an organism species refers to the first author(s), who validly published the plant/animal name", formalDefinition="The type of author of an organism species shall be specified. The parenthetical author of an organism species refers to the first author who published the plant/animal name (of any rank). The primary author of an organism species refers to the first author(s), who validly published the plant/animal name.")
        protected CodeableConcept authorType;
        @Child(name="authorDescription", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The author of an organism species shall be specified. The author year of an organism shall also be specified when applicable; refers to the year in which the first author(s) published the infraspecific plant/animal name (of any rank)", formalDefinition="The author of an organism species shall be specified. The author year of an organism shall also be specified when applicable; refers to the year in which the first author(s) published the infraspecific plant/animal name (of any rank).")
        protected StringType authorDescription;
        private static final long serialVersionUID = 1429770120L;

        public CodeableConcept getAuthorType() {
            if (this.authorType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismAuthorComponent.authorType");
                }
                if (Configuration.doAutoCreate()) {
                    this.authorType = new CodeableConcept();
                }
            }
            return this.authorType;
        }

        public boolean hasAuthorType() {
            return this.authorType != null && !this.authorType.isEmpty();
        }

        public SubstanceSourceMaterialOrganismAuthorComponent setAuthorType(CodeableConcept value) {
            this.authorType = value;
            return this;
        }

        public StringType getAuthorDescriptionElement() {
            if (this.authorDescription == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismAuthorComponent.authorDescription");
                }
                if (Configuration.doAutoCreate()) {
                    this.authorDescription = new StringType();
                }
            }
            return this.authorDescription;
        }

        public boolean hasAuthorDescriptionElement() {
            return this.authorDescription != null && !this.authorDescription.isEmpty();
        }

        public boolean hasAuthorDescription() {
            return this.authorDescription != null && !this.authorDescription.isEmpty();
        }

        public SubstanceSourceMaterialOrganismAuthorComponent setAuthorDescriptionElement(StringType value) {
            this.authorDescription = value;
            return this;
        }

        public String getAuthorDescription() {
            return this.authorDescription == null ? null : (String)this.authorDescription.getValue();
        }

        public SubstanceSourceMaterialOrganismAuthorComponent setAuthorDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.authorDescription = null;
            } else {
                if (this.authorDescription == null) {
                    this.authorDescription = new StringType();
                }
                this.authorDescription.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("authorType", "CodeableConcept", "The type of author of an organism species shall be specified. The parenthetical author of an organism species refers to the first author who published the plant/animal name (of any rank). The primary author of an organism species refers to the first author(s), who validly published the plant/animal name.", 0, 1, this.authorType));
            children.add(new Property("authorDescription", "string", "The author of an organism species shall be specified. The author year of an organism shall also be specified when applicable; refers to the year in which the first author(s) published the infraspecific plant/animal name (of any rank).", 0, 1, this.authorDescription));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1501337755: {
                    return new Property("authorType", "CodeableConcept", "The type of author of an organism species shall be specified. The parenthetical author of an organism species refers to the first author who published the plant/animal name (of any rank). The primary author of an organism species refers to the first author(s), who validly published the plant/animal name.", 0, 1, this.authorType);
                }
                case -166185615: {
                    return new Property("authorDescription", "string", "The author of an organism species shall be specified. The author year of an organism shall also be specified when applicable; refers to the year in which the first author(s) published the infraspecific plant/animal name (of any rank).", 0, 1, this.authorDescription);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1501337755: {
                    Base[] baseArray;
                    if (this.authorType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.authorType;
                    }
                    return baseArray;
                }
                case -166185615: {
                    Base[] baseArray;
                    if (this.authorDescription == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.authorDescription;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1501337755: {
                    this.authorType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -166185615: {
                    this.authorDescription = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("authorType")) {
                this.authorType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("authorDescription")) {
                this.authorDescription = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1501337755: {
                    return this.getAuthorType();
                }
                case -166185615: {
                    return this.getAuthorDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1501337755: {
                    return new String[]{"CodeableConcept"};
                }
                case -166185615: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("authorType")) {
                this.authorType = new CodeableConcept();
                return this.authorType;
            }
            if (name.equals("authorDescription")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSourceMaterial.organism.author.authorDescription");
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSourceMaterialOrganismAuthorComponent copy() {
            SubstanceSourceMaterialOrganismAuthorComponent dst = new SubstanceSourceMaterialOrganismAuthorComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceSourceMaterialOrganismAuthorComponent dst) {
            super.copyValues(dst);
            dst.authorType = this.authorType == null ? null : this.authorType.copy();
            dst.authorDescription = this.authorDescription == null ? null : this.authorDescription.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSourceMaterialOrganismAuthorComponent)) {
                return false;
            }
            SubstanceSourceMaterialOrganismAuthorComponent o = (SubstanceSourceMaterialOrganismAuthorComponent)other_;
            return SubstanceSourceMaterialOrganismAuthorComponent.compareDeep(this.authorType, o.authorType, true) && SubstanceSourceMaterialOrganismAuthorComponent.compareDeep(this.authorDescription, o.authorDescription, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSourceMaterialOrganismAuthorComponent)) {
                return false;
            }
            SubstanceSourceMaterialOrganismAuthorComponent o = (SubstanceSourceMaterialOrganismAuthorComponent)other_;
            return SubstanceSourceMaterialOrganismAuthorComponent.compareValues(this.authorDescription, o.authorDescription, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.authorType, this.authorDescription});
        }

        @Override
        public String fhirType() {
            return "SubstanceSourceMaterial.organism.author";
        }
    }

    @Block
    public static class SubstanceSourceMaterialOrganismComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="family", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The family of an organism shall be specified", formalDefinition="The family of an organism shall be specified.")
        protected CodeableConcept family;
        @Child(name="genus", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The genus of an organism shall be specified; refers to the Latin epithet of the genus element of the plant/animal scientific name; it is present in names for genera, species and infraspecies", formalDefinition="The genus of an organism shall be specified; refers to the Latin epithet of the genus element of the plant/animal scientific name; it is present in names for genera, species and infraspecies.")
        protected CodeableConcept genus;
        @Child(name="species", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The species of an organism shall be specified; refers to the Latin epithet of the species of the plant/animal; it is present in names for species and infraspecies", formalDefinition="The species of an organism shall be specified; refers to the Latin epithet of the species of the plant/animal; it is present in names for species and infraspecies.")
        protected CodeableConcept species;
        @Child(name="intraspecificType", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The Intraspecific type of an organism shall be specified", formalDefinition="The Intraspecific type of an organism shall be specified.")
        protected CodeableConcept intraspecificType;
        @Child(name="intraspecificDescription", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The intraspecific description of an organism shall be specified based on a controlled vocabulary. For Influenza Vaccine, the intraspecific description shall contain the syntax of the antigen in line with the WHO convention", formalDefinition="The intraspecific description of an organism shall be specified based on a controlled vocabulary. For Influenza Vaccine, the intraspecific description shall contain the syntax of the antigen in line with the WHO convention.")
        protected StringType intraspecificDescription;
        @Child(name="author", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="4.9.13.6.1 Author type (Conditional)", formalDefinition="4.9.13.6.1 Author type (Conditional).")
        protected List<SubstanceSourceMaterialOrganismAuthorComponent> author;
        @Child(name="hybrid", type={}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="4.9.13.8.1 Hybrid species maternal organism ID (Optional)", formalDefinition="4.9.13.8.1 Hybrid species maternal organism ID (Optional).")
        protected SubstanceSourceMaterialOrganismHybridComponent hybrid;
        @Child(name="organismGeneral", type={}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="4.9.13.7.1 Kingdom (Conditional)", formalDefinition="4.9.13.7.1 Kingdom (Conditional).")
        protected SubstanceSourceMaterialOrganismOrganismGeneralComponent organismGeneral;
        private static final long serialVersionUID = 941648312L;

        public CodeableConcept getFamily() {
            if (this.family == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismComponent.family");
                }
                if (Configuration.doAutoCreate()) {
                    this.family = new CodeableConcept();
                }
            }
            return this.family;
        }

        public boolean hasFamily() {
            return this.family != null && !this.family.isEmpty();
        }

        public SubstanceSourceMaterialOrganismComponent setFamily(CodeableConcept value) {
            this.family = value;
            return this;
        }

        public CodeableConcept getGenus() {
            if (this.genus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismComponent.genus");
                }
                if (Configuration.doAutoCreate()) {
                    this.genus = new CodeableConcept();
                }
            }
            return this.genus;
        }

        public boolean hasGenus() {
            return this.genus != null && !this.genus.isEmpty();
        }

        public SubstanceSourceMaterialOrganismComponent setGenus(CodeableConcept value) {
            this.genus = value;
            return this;
        }

        public CodeableConcept getSpecies() {
            if (this.species == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismComponent.species");
                }
                if (Configuration.doAutoCreate()) {
                    this.species = new CodeableConcept();
                }
            }
            return this.species;
        }

        public boolean hasSpecies() {
            return this.species != null && !this.species.isEmpty();
        }

        public SubstanceSourceMaterialOrganismComponent setSpecies(CodeableConcept value) {
            this.species = value;
            return this;
        }

        public CodeableConcept getIntraspecificType() {
            if (this.intraspecificType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismComponent.intraspecificType");
                }
                if (Configuration.doAutoCreate()) {
                    this.intraspecificType = new CodeableConcept();
                }
            }
            return this.intraspecificType;
        }

        public boolean hasIntraspecificType() {
            return this.intraspecificType != null && !this.intraspecificType.isEmpty();
        }

        public SubstanceSourceMaterialOrganismComponent setIntraspecificType(CodeableConcept value) {
            this.intraspecificType = value;
            return this;
        }

        public StringType getIntraspecificDescriptionElement() {
            if (this.intraspecificDescription == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismComponent.intraspecificDescription");
                }
                if (Configuration.doAutoCreate()) {
                    this.intraspecificDescription = new StringType();
                }
            }
            return this.intraspecificDescription;
        }

        public boolean hasIntraspecificDescriptionElement() {
            return this.intraspecificDescription != null && !this.intraspecificDescription.isEmpty();
        }

        public boolean hasIntraspecificDescription() {
            return this.intraspecificDescription != null && !this.intraspecificDescription.isEmpty();
        }

        public SubstanceSourceMaterialOrganismComponent setIntraspecificDescriptionElement(StringType value) {
            this.intraspecificDescription = value;
            return this;
        }

        public String getIntraspecificDescription() {
            return this.intraspecificDescription == null ? null : (String)this.intraspecificDescription.getValue();
        }

        public SubstanceSourceMaterialOrganismComponent setIntraspecificDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.intraspecificDescription = null;
            } else {
                if (this.intraspecificDescription == null) {
                    this.intraspecificDescription = new StringType();
                }
                this.intraspecificDescription.setValue(value);
            }
            return this;
        }

        public List<SubstanceSourceMaterialOrganismAuthorComponent> getAuthor() {
            if (this.author == null) {
                this.author = new ArrayList<SubstanceSourceMaterialOrganismAuthorComponent>();
            }
            return this.author;
        }

        public SubstanceSourceMaterialOrganismComponent setAuthor(List<SubstanceSourceMaterialOrganismAuthorComponent> theAuthor) {
            this.author = theAuthor;
            return this;
        }

        public boolean hasAuthor() {
            if (this.author == null) {
                return false;
            }
            for (SubstanceSourceMaterialOrganismAuthorComponent item : this.author) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstanceSourceMaterialOrganismAuthorComponent addAuthor() {
            SubstanceSourceMaterialOrganismAuthorComponent t = new SubstanceSourceMaterialOrganismAuthorComponent();
            if (this.author == null) {
                this.author = new ArrayList<SubstanceSourceMaterialOrganismAuthorComponent>();
            }
            this.author.add(t);
            return t;
        }

        public SubstanceSourceMaterialOrganismComponent addAuthor(SubstanceSourceMaterialOrganismAuthorComponent t) {
            if (t == null) {
                return this;
            }
            if (this.author == null) {
                this.author = new ArrayList<SubstanceSourceMaterialOrganismAuthorComponent>();
            }
            this.author.add(t);
            return this;
        }

        public SubstanceSourceMaterialOrganismAuthorComponent getAuthorFirstRep() {
            if (this.getAuthor().isEmpty()) {
                this.addAuthor();
            }
            return this.getAuthor().get(0);
        }

        public SubstanceSourceMaterialOrganismHybridComponent getHybrid() {
            if (this.hybrid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismComponent.hybrid");
                }
                if (Configuration.doAutoCreate()) {
                    this.hybrid = new SubstanceSourceMaterialOrganismHybridComponent();
                }
            }
            return this.hybrid;
        }

        public boolean hasHybrid() {
            return this.hybrid != null && !this.hybrid.isEmpty();
        }

        public SubstanceSourceMaterialOrganismComponent setHybrid(SubstanceSourceMaterialOrganismHybridComponent value) {
            this.hybrid = value;
            return this;
        }

        public SubstanceSourceMaterialOrganismOrganismGeneralComponent getOrganismGeneral() {
            if (this.organismGeneral == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialOrganismComponent.organismGeneral");
                }
                if (Configuration.doAutoCreate()) {
                    this.organismGeneral = new SubstanceSourceMaterialOrganismOrganismGeneralComponent();
                }
            }
            return this.organismGeneral;
        }

        public boolean hasOrganismGeneral() {
            return this.organismGeneral != null && !this.organismGeneral.isEmpty();
        }

        public SubstanceSourceMaterialOrganismComponent setOrganismGeneral(SubstanceSourceMaterialOrganismOrganismGeneralComponent value) {
            this.organismGeneral = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("family", "CodeableConcept", "The family of an organism shall be specified.", 0, 1, this.family));
            children.add(new Property("genus", "CodeableConcept", "The genus of an organism shall be specified; refers to the Latin epithet of the genus element of the plant/animal scientific name; it is present in names for genera, species and infraspecies.", 0, 1, this.genus));
            children.add(new Property("species", "CodeableConcept", "The species of an organism shall be specified; refers to the Latin epithet of the species of the plant/animal; it is present in names for species and infraspecies.", 0, 1, this.species));
            children.add(new Property("intraspecificType", "CodeableConcept", "The Intraspecific type of an organism shall be specified.", 0, 1, this.intraspecificType));
            children.add(new Property("intraspecificDescription", "string", "The intraspecific description of an organism shall be specified based on a controlled vocabulary. For Influenza Vaccine, the intraspecific description shall contain the syntax of the antigen in line with the WHO convention.", 0, 1, this.intraspecificDescription));
            children.add(new Property("author", "", "4.9.13.6.1 Author type (Conditional).", 0, Integer.MAX_VALUE, this.author));
            children.add(new Property("hybrid", "", "4.9.13.8.1 Hybrid species maternal organism ID (Optional).", 0, 1, this.hybrid));
            children.add(new Property("organismGeneral", "", "4.9.13.7.1 Kingdom (Conditional).", 0, 1, this.organismGeneral));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1281860764: {
                    return new Property("family", "CodeableConcept", "The family of an organism shall be specified.", 0, 1, this.family);
                }
                case 98241006: {
                    return new Property("genus", "CodeableConcept", "The genus of an organism shall be specified; refers to the Latin epithet of the genus element of the plant/animal scientific name; it is present in names for genera, species and infraspecies.", 0, 1, this.genus);
                }
                case -2008465092: {
                    return new Property("species", "CodeableConcept", "The species of an organism shall be specified; refers to the Latin epithet of the species of the plant/animal; it is present in names for species and infraspecies.", 0, 1, this.species);
                }
                case 1717161194: {
                    return new Property("intraspecificType", "CodeableConcept", "The Intraspecific type of an organism shall be specified.", 0, 1, this.intraspecificType);
                }
                case -1473085364: {
                    return new Property("intraspecificDescription", "string", "The intraspecific description of an organism shall be specified based on a controlled vocabulary. For Influenza Vaccine, the intraspecific description shall contain the syntax of the antigen in line with the WHO convention.", 0, 1, this.intraspecificDescription);
                }
                case -1406328437: {
                    return new Property("author", "", "4.9.13.6.1 Author type (Conditional).", 0, Integer.MAX_VALUE, this.author);
                }
                case -1202757124: {
                    return new Property("hybrid", "", "4.9.13.8.1 Hybrid species maternal organism ID (Optional).", 0, 1, this.hybrid);
                }
                case -865996874: {
                    return new Property("organismGeneral", "", "4.9.13.7.1 Kingdom (Conditional).", 0, 1, this.organismGeneral);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1281860764: {
                    Base[] baseArray;
                    if (this.family == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.family;
                    }
                    return baseArray;
                }
                case 98241006: {
                    Base[] baseArray;
                    if (this.genus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.genus;
                    }
                    return baseArray;
                }
                case -2008465092: {
                    Base[] baseArray;
                    if (this.species == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.species;
                    }
                    return baseArray;
                }
                case 1717161194: {
                    Base[] baseArray;
                    if (this.intraspecificType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.intraspecificType;
                    }
                    return baseArray;
                }
                case -1473085364: {
                    Base[] baseArray;
                    if (this.intraspecificDescription == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.intraspecificDescription;
                    }
                    return baseArray;
                }
                case -1406328437: {
                    return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
                }
                case -1202757124: {
                    Base[] baseArray;
                    if (this.hybrid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.hybrid;
                    }
                    return baseArray;
                }
                case -865996874: {
                    Base[] baseArray;
                    if (this.organismGeneral == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.organismGeneral;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1281860764: {
                    this.family = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 98241006: {
                    this.genus = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -2008465092: {
                    this.species = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1717161194: {
                    this.intraspecificType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1473085364: {
                    this.intraspecificDescription = TypeConvertor.castToString(value);
                    return value;
                }
                case -1406328437: {
                    this.getAuthor().add((SubstanceSourceMaterialOrganismAuthorComponent)value);
                    return value;
                }
                case -1202757124: {
                    this.hybrid = (SubstanceSourceMaterialOrganismHybridComponent)value;
                    return value;
                }
                case -865996874: {
                    this.organismGeneral = (SubstanceSourceMaterialOrganismOrganismGeneralComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("family")) {
                this.family = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("genus")) {
                this.genus = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("species")) {
                this.species = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("intraspecificType")) {
                this.intraspecificType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("intraspecificDescription")) {
                this.intraspecificDescription = TypeConvertor.castToString(value);
            } else if (name.equals("author")) {
                this.getAuthor().add((SubstanceSourceMaterialOrganismAuthorComponent)value);
            } else if (name.equals("hybrid")) {
                this.hybrid = (SubstanceSourceMaterialOrganismHybridComponent)value;
            } else if (name.equals("organismGeneral")) {
                this.organismGeneral = (SubstanceSourceMaterialOrganismOrganismGeneralComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1281860764: {
                    return this.getFamily();
                }
                case 98241006: {
                    return this.getGenus();
                }
                case -2008465092: {
                    return this.getSpecies();
                }
                case 1717161194: {
                    return this.getIntraspecificType();
                }
                case -1473085364: {
                    return this.getIntraspecificDescriptionElement();
                }
                case -1406328437: {
                    return this.addAuthor();
                }
                case -1202757124: {
                    return this.getHybrid();
                }
                case -865996874: {
                    return this.getOrganismGeneral();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1281860764: {
                    return new String[]{"CodeableConcept"};
                }
                case 98241006: {
                    return new String[]{"CodeableConcept"};
                }
                case -2008465092: {
                    return new String[]{"CodeableConcept"};
                }
                case 1717161194: {
                    return new String[]{"CodeableConcept"};
                }
                case -1473085364: {
                    return new String[]{"string"};
                }
                case -1406328437: {
                    return new String[0];
                }
                case -1202757124: {
                    return new String[0];
                }
                case -865996874: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("family")) {
                this.family = new CodeableConcept();
                return this.family;
            }
            if (name.equals("genus")) {
                this.genus = new CodeableConcept();
                return this.genus;
            }
            if (name.equals("species")) {
                this.species = new CodeableConcept();
                return this.species;
            }
            if (name.equals("intraspecificType")) {
                this.intraspecificType = new CodeableConcept();
                return this.intraspecificType;
            }
            if (name.equals("intraspecificDescription")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSourceMaterial.organism.intraspecificDescription");
            }
            if (name.equals("author")) {
                return this.addAuthor();
            }
            if (name.equals("hybrid")) {
                this.hybrid = new SubstanceSourceMaterialOrganismHybridComponent();
                return this.hybrid;
            }
            if (name.equals("organismGeneral")) {
                this.organismGeneral = new SubstanceSourceMaterialOrganismOrganismGeneralComponent();
                return this.organismGeneral;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSourceMaterialOrganismComponent copy() {
            SubstanceSourceMaterialOrganismComponent dst = new SubstanceSourceMaterialOrganismComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceSourceMaterialOrganismComponent dst) {
            super.copyValues(dst);
            dst.family = this.family == null ? null : this.family.copy();
            dst.genus = this.genus == null ? null : this.genus.copy();
            dst.species = this.species == null ? null : this.species.copy();
            dst.intraspecificType = this.intraspecificType == null ? null : this.intraspecificType.copy();
            StringType stringType = dst.intraspecificDescription = this.intraspecificDescription == null ? null : this.intraspecificDescription.copy();
            if (this.author != null) {
                dst.author = new ArrayList<SubstanceSourceMaterialOrganismAuthorComponent>();
                for (SubstanceSourceMaterialOrganismAuthorComponent i : this.author) {
                    dst.author.add(i.copy());
                }
            }
            dst.hybrid = this.hybrid == null ? null : this.hybrid.copy();
            dst.organismGeneral = this.organismGeneral == null ? null : this.organismGeneral.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSourceMaterialOrganismComponent)) {
                return false;
            }
            SubstanceSourceMaterialOrganismComponent o = (SubstanceSourceMaterialOrganismComponent)other_;
            return SubstanceSourceMaterialOrganismComponent.compareDeep(this.family, o.family, true) && SubstanceSourceMaterialOrganismComponent.compareDeep(this.genus, o.genus, true) && SubstanceSourceMaterialOrganismComponent.compareDeep(this.species, o.species, true) && SubstanceSourceMaterialOrganismComponent.compareDeep(this.intraspecificType, o.intraspecificType, true) && SubstanceSourceMaterialOrganismComponent.compareDeep(this.intraspecificDescription, o.intraspecificDescription, true) && SubstanceSourceMaterialOrganismComponent.compareDeep(this.author, o.author, true) && SubstanceSourceMaterialOrganismComponent.compareDeep(this.hybrid, o.hybrid, true) && SubstanceSourceMaterialOrganismComponent.compareDeep(this.organismGeneral, o.organismGeneral, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSourceMaterialOrganismComponent)) {
                return false;
            }
            SubstanceSourceMaterialOrganismComponent o = (SubstanceSourceMaterialOrganismComponent)other_;
            return SubstanceSourceMaterialOrganismComponent.compareValues(this.intraspecificDescription, o.intraspecificDescription, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.family, this.genus, this.species, this.intraspecificType, this.intraspecificDescription, this.author, this.hybrid, this.organismGeneral});
        }

        @Override
        public String fhirType() {
            return "SubstanceSourceMaterial.organism";
        }
    }

    @Block
    public static class SubstanceSourceMaterialFractionDescriptionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="fraction", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="This element is capturing information about the fraction of a plant part, or human plasma for fractionation", formalDefinition="This element is capturing information about the fraction of a plant part, or human plasma for fractionation.")
        protected StringType fraction;
        @Child(name="materialType", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The specific type of the material constituting the component. For Herbal preparations the particulars of the extracts (liquid/dry) is described in Specified Substance Group 1", formalDefinition="The specific type of the material constituting the component. For Herbal preparations the particulars of the extracts (liquid/dry) is described in Specified Substance Group 1.")
        protected CodeableConcept materialType;
        private static final long serialVersionUID = -1118226733L;

        public StringType getFractionElement() {
            if (this.fraction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialFractionDescriptionComponent.fraction");
                }
                if (Configuration.doAutoCreate()) {
                    this.fraction = new StringType();
                }
            }
            return this.fraction;
        }

        public boolean hasFractionElement() {
            return this.fraction != null && !this.fraction.isEmpty();
        }

        public boolean hasFraction() {
            return this.fraction != null && !this.fraction.isEmpty();
        }

        public SubstanceSourceMaterialFractionDescriptionComponent setFractionElement(StringType value) {
            this.fraction = value;
            return this;
        }

        public String getFraction() {
            return this.fraction == null ? null : (String)this.fraction.getValue();
        }

        public SubstanceSourceMaterialFractionDescriptionComponent setFraction(String value) {
            if (Utilities.noString((String)value)) {
                this.fraction = null;
            } else {
                if (this.fraction == null) {
                    this.fraction = new StringType();
                }
                this.fraction.setValue(value);
            }
            return this;
        }

        public CodeableConcept getMaterialType() {
            if (this.materialType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSourceMaterialFractionDescriptionComponent.materialType");
                }
                if (Configuration.doAutoCreate()) {
                    this.materialType = new CodeableConcept();
                }
            }
            return this.materialType;
        }

        public boolean hasMaterialType() {
            return this.materialType != null && !this.materialType.isEmpty();
        }

        public SubstanceSourceMaterialFractionDescriptionComponent setMaterialType(CodeableConcept value) {
            this.materialType = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("fraction", "string", "This element is capturing information about the fraction of a plant part, or human plasma for fractionation.", 0, 1, this.fraction));
            children.add(new Property("materialType", "CodeableConcept", "The specific type of the material constituting the component. For Herbal preparations the particulars of the extracts (liquid/dry) is described in Specified Substance Group 1.", 0, 1, this.materialType));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1653751294: {
                    return new Property("fraction", "string", "This element is capturing information about the fraction of a plant part, or human plasma for fractionation.", 0, 1, this.fraction);
                }
                case -2115601151: {
                    return new Property("materialType", "CodeableConcept", "The specific type of the material constituting the component. For Herbal preparations the particulars of the extracts (liquid/dry) is described in Specified Substance Group 1.", 0, 1, this.materialType);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1653751294: {
                    Base[] baseArray;
                    if (this.fraction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.fraction;
                    }
                    return baseArray;
                }
                case -2115601151: {
                    Base[] baseArray;
                    if (this.materialType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.materialType;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1653751294: {
                    this.fraction = TypeConvertor.castToString(value);
                    return value;
                }
                case -2115601151: {
                    this.materialType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("fraction")) {
                this.fraction = TypeConvertor.castToString(value);
            } else if (name.equals("materialType")) {
                this.materialType = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1653751294: {
                    return this.getFractionElement();
                }
                case -2115601151: {
                    return this.getMaterialType();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1653751294: {
                    return new String[]{"string"};
                }
                case -2115601151: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("fraction")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSourceMaterial.fractionDescription.fraction");
            }
            if (name.equals("materialType")) {
                this.materialType = new CodeableConcept();
                return this.materialType;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSourceMaterialFractionDescriptionComponent copy() {
            SubstanceSourceMaterialFractionDescriptionComponent dst = new SubstanceSourceMaterialFractionDescriptionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceSourceMaterialFractionDescriptionComponent dst) {
            super.copyValues(dst);
            dst.fraction = this.fraction == null ? null : this.fraction.copy();
            dst.materialType = this.materialType == null ? null : this.materialType.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSourceMaterialFractionDescriptionComponent)) {
                return false;
            }
            SubstanceSourceMaterialFractionDescriptionComponent o = (SubstanceSourceMaterialFractionDescriptionComponent)other_;
            return SubstanceSourceMaterialFractionDescriptionComponent.compareDeep(this.fraction, o.fraction, true) && SubstanceSourceMaterialFractionDescriptionComponent.compareDeep(this.materialType, o.materialType, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSourceMaterialFractionDescriptionComponent)) {
                return false;
            }
            SubstanceSourceMaterialFractionDescriptionComponent o = (SubstanceSourceMaterialFractionDescriptionComponent)other_;
            return SubstanceSourceMaterialFractionDescriptionComponent.compareValues(this.fraction, o.fraction, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.fraction, this.materialType});
        }

        @Override
        public String fhirType() {
            return "SubstanceSourceMaterial.fractionDescription";
        }
    }
}

