/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.TypeConvertor;

@DatatypeDef(name="ExtendedContactDetail")
public class ExtendedContactDetail
extends DataType
implements ICompositeType {
    @Child(name="purpose", type={CodeableConcept.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The type of contact", formalDefinition="The purpose/type of contact.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/contactentity-type")
    protected CodeableConcept purpose;
    @Child(name="name", type={HumanName.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Name of an individual to contact", formalDefinition="The name of an individual to contact, some types of contact detail are usually blank.")
    protected List<HumanName> name;
    @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details (e.g.phone/fax/url)", formalDefinition="The contact details application for the purpose defined.")
    protected List<ContactPoint> telecom;
    @Child(name="address", type={Address.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Address for the contact", formalDefinition="Address for the contact.")
    protected Address address;
    @Child(name="organization", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="This contact detail is handled/monitored by a specific organization", formalDefinition="This contact detail is handled/monitored by a specific organization. If the name is provided in the contact, then it is referring to the named individual within this organization.")
    protected Reference organization;
    @Child(name="period", type={Period.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Period that this contact was valid for usage", formalDefinition="Period that this contact was valid for usage.")
    protected Period period;
    private static final long serialVersionUID = 154672475L;

    public CodeableConcept getPurpose() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExtendedContactDetail.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new CodeableConcept();
            }
        }
        return this.purpose;
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public ExtendedContactDetail setPurpose(CodeableConcept value) {
        this.purpose = value;
        return this;
    }

    public List<HumanName> getName() {
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        return this.name;
    }

    public ExtendedContactDetail setName(List<HumanName> theName) {
        this.name = theName;
        return this;
    }

    public boolean hasName() {
        if (this.name == null) {
            return false;
        }
        for (HumanName item : this.name) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public HumanName addName() {
        HumanName t = new HumanName();
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        this.name.add(t);
        return t;
    }

    public ExtendedContactDetail addName(HumanName t) {
        if (t == null) {
            return this;
        }
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        this.name.add(t);
        return this;
    }

    public HumanName getNameFirstRep() {
        if (this.getName().isEmpty()) {
            this.addName();
        }
        return this.getName().get(0);
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public ExtendedContactDetail setTelecom(List<ContactPoint> theTelecom) {
        this.telecom = theTelecom;
        return this;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public ExtendedContactDetail addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public ContactPoint getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public Address getAddress() {
        if (this.address == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExtendedContactDetail.address");
            }
            if (Configuration.doAutoCreate()) {
                this.address = new Address();
            }
        }
        return this.address;
    }

    public boolean hasAddress() {
        return this.address != null && !this.address.isEmpty();
    }

    public ExtendedContactDetail setAddress(Address value) {
        this.address = value;
        return this;
    }

    public Reference getOrganization() {
        if (this.organization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExtendedContactDetail.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organization = new Reference();
            }
        }
        return this.organization;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public ExtendedContactDetail setOrganization(Reference value) {
        this.organization = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExtendedContactDetail.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public ExtendedContactDetail setPeriod(Period value) {
        this.period = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("purpose", "CodeableConcept", "The purpose/type of contact.", 0, 1, this.purpose));
        children.add(new Property("name", "HumanName", "The name of an individual to contact, some types of contact detail are usually blank.", 0, Integer.MAX_VALUE, this.name));
        children.add(new Property("telecom", "ContactPoint", "The contact details application for the purpose defined.", 0, Integer.MAX_VALUE, this.telecom));
        children.add(new Property("address", "Address", "Address for the contact.", 0, 1, this.address));
        children.add(new Property("organization", "Reference(Organization)", "This contact detail is handled/monitored by a specific organization. If the name is provided in the contact, then it is referring to the named individual within this organization.", 0, 1, this.organization));
        children.add(new Property("period", "Period", "Period that this contact was valid for usage.", 0, 1, this.period));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -220463842: {
                return new Property("purpose", "CodeableConcept", "The purpose/type of contact.", 0, 1, this.purpose);
            }
            case 3373707: {
                return new Property("name", "HumanName", "The name of an individual to contact, some types of contact detail are usually blank.", 0, Integer.MAX_VALUE, this.name);
            }
            case -1429363305: {
                return new Property("telecom", "ContactPoint", "The contact details application for the purpose defined.", 0, Integer.MAX_VALUE, this.telecom);
            }
            case -1147692044: {
                return new Property("address", "Address", "Address for the contact.", 0, 1, this.address);
            }
            case 1178922291: {
                return new Property("organization", "Reference(Organization)", "This contact detail is handled/monitored by a specific organization. If the name is provided in the contact, then it is referring to the named individual within this organization.", 0, 1, this.organization);
            }
            case -991726143: {
                return new Property("period", "Period", "Period that this contact was valid for usage.", 0, 1, this.period);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.purpose;
                }
                return baseArray;
            }
            case 3373707: {
                return this.name == null ? new Base[]{} : this.name.toArray(new Base[this.name.size()]);
            }
            case -1429363305: {
                return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
            }
            case -1147692044: {
                Base[] baseArray;
                if (this.address == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.address;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.organization;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.period;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -220463842: {
                this.purpose = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3373707: {
                this.getName().add(TypeConvertor.castToHumanName(value));
                return value;
            }
            case -1429363305: {
                this.getTelecom().add(TypeConvertor.castToContactPoint(value));
                return value;
            }
            case -1147692044: {
                this.address = TypeConvertor.castToAddress(value);
                return value;
            }
            case 1178922291: {
                this.organization = TypeConvertor.castToReference(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("name")) {
            this.getName().add(TypeConvertor.castToHumanName(value));
        } else if (name.equals("telecom")) {
            this.getTelecom().add(TypeConvertor.castToContactPoint(value));
        } else if (name.equals("address")) {
            this.address = TypeConvertor.castToAddress(value);
        } else if (name.equals("organization")) {
            this.organization = TypeConvertor.castToReference(value);
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -220463842: {
                return this.getPurpose();
            }
            case 3373707: {
                return this.addName();
            }
            case -1429363305: {
                return this.addTelecom();
            }
            case -1147692044: {
                return this.getAddress();
            }
            case 1178922291: {
                return this.getOrganization();
            }
            case -991726143: {
                return this.getPeriod();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -220463842: {
                return new String[]{"CodeableConcept"};
            }
            case 3373707: {
                return new String[]{"HumanName"};
            }
            case -1429363305: {
                return new String[]{"ContactPoint"};
            }
            case -1147692044: {
                return new String[]{"Address"};
            }
            case 1178922291: {
                return new String[]{"Reference"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("purpose")) {
            this.purpose = new CodeableConcept();
            return this.purpose;
        }
        if (name.equals("name")) {
            return this.addName();
        }
        if (name.equals("telecom")) {
            return this.addTelecom();
        }
        if (name.equals("address")) {
            this.address = new Address();
            return this.address;
        }
        if (name.equals("organization")) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ExtendedContactDetail";
    }

    @Override
    public ExtendedContactDetail copy() {
        ExtendedContactDetail dst = new ExtendedContactDetail();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ExtendedContactDetail dst) {
        super.copyValues(dst);
        CodeableConcept codeableConcept = dst.purpose = this.purpose == null ? null : this.purpose.copy();
        if (this.name != null) {
            dst.name = new ArrayList<HumanName>();
            for (HumanName humanName : this.name) {
                dst.name.add(humanName.copy());
            }
        }
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        dst.address = this.address == null ? null : this.address.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.period = this.period == null ? null : this.period.copy();
    }

    protected ExtendedContactDetail typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ExtendedContactDetail)) {
            return false;
        }
        ExtendedContactDetail o = (ExtendedContactDetail)other_;
        return ExtendedContactDetail.compareDeep(this.purpose, o.purpose, true) && ExtendedContactDetail.compareDeep(this.name, o.name, true) && ExtendedContactDetail.compareDeep(this.telecom, o.telecom, true) && ExtendedContactDetail.compareDeep(this.address, o.address, true) && ExtendedContactDetail.compareDeep(this.organization, o.organization, true) && ExtendedContactDetail.compareDeep(this.period, o.period, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ExtendedContactDetail)) {
            return false;
        }
        ExtendedContactDetail o = (ExtendedContactDetail)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.purpose, this.name, this.telecom, this.address, this.organization, this.period});
    }
}

