/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.patterns;

import java.util.List;
import org.hl7.fhir.r4b.model.Annotation;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.Element;
import org.hl7.fhir.r4b.model.Extension;
import org.hl7.fhir.r4b.model.Resource;
import org.hl7.fhir.r4b.patterns.PatternBase;

public class PatternBaseImpl
implements PatternBase {
    private Base wrapped;

    public PatternBaseImpl(Base wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public String getId() {
        if (this.wrapped instanceof Element) {
            return ((Element)this.wrapped).getId();
        }
        if (this.wrapped instanceof Resource) {
            return ((Resource)this.wrapped).getId();
        }
        return null;
    }

    @Override
    public PatternBase setId(String value) {
        if (this.wrapped instanceof Element) {
            ((Element)this.wrapped).setId(value);
        } else if (this.wrapped instanceof Resource) {
            ((Resource)this.wrapped).setId(value);
        } else {
            throw new Error("this should not happen? wrapped = " + this.wrapped.getClass().getName());
        }
        return this;
    }

    @Override
    public List<Extension> getExtension() {
        if (this.wrapped instanceof Element) {
            return ((Element)this.wrapped).getExtension();
        }
        if (this.wrapped instanceof DomainResource) {
            return ((DomainResource)this.wrapped).getExtension();
        }
        return null;
    }

    protected Annotation convertStringToAnnotation(String value) {
        if (value == null) {
            return null;
        }
        return new Annotation().setText(value);
    }

    protected String convertAnnotationToString(Annotation value) {
        if (value == null) {
            return null;
        }
        return value.getText();
    }
}

