/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4b.model.BackboneType;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.Element;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Quantity;
import org.hl7.fhir.r4b.model.Range;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="SubstanceAmount")
public class SubstanceAmount
extends BackboneType
implements ICompositeType {
    @Child(name="amount", type={Quantity.class, Range.class, StringType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field", formalDefinition="Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.")
    protected DataType amount;
    @Child(name="amountType", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Most elements that require a quantitative value will also have a field called amount type. Amount type should always be specified because the actual value of the amount is often dependent on it. EXAMPLE: In capturing the actual relative amounts of substances or molecular fragments it is essential to indicate whether the amount refers to a mole ratio or weight ratio. For any given element an effort should be made to use same the amount type for all related definitional elements", formalDefinition="Most elements that require a quantitative value will also have a field called amount type. Amount type should always be specified because the actual value of the amount is often dependent on it. EXAMPLE: In capturing the actual relative amounts of substances or molecular fragments it is essential to indicate whether the amount refers to a mole ratio or weight ratio. For any given element an effort should be made to use same the amount type for all related definitional elements.")
    protected CodeableConcept amountType;
    @Child(name="amountText", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A textual comment on a numeric value", formalDefinition="A textual comment on a numeric value.")
    protected StringType amountText;
    @Child(name="referenceRange", type={}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reference range of possible or expected values", formalDefinition="Reference range of possible or expected values.")
    protected SubstanceAmountReferenceRangeComponent referenceRange;
    private static final long serialVersionUID = 585120586L;

    public DataType getAmount() {
        return this.amount;
    }

    public Quantity getAmountQuantity() throws FHIRException {
        if (this.amount == null) {
            this.amount = new Quantity();
        }
        if (!(this.amount instanceof Quantity)) {
            throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.amount.getClass().getName() + " was encountered");
        }
        return (Quantity)this.amount;
    }

    public boolean hasAmountQuantity() {
        return this != null && this.amount instanceof Quantity;
    }

    public Range getAmountRange() throws FHIRException {
        if (this.amount == null) {
            this.amount = new Range();
        }
        if (!(this.amount instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.amount.getClass().getName() + " was encountered");
        }
        return (Range)this.amount;
    }

    public boolean hasAmountRange() {
        return this != null && this.amount instanceof Range;
    }

    public StringType getAmountStringType() throws FHIRException {
        if (this.amount == null) {
            this.amount = new StringType();
        }
        if (!(this.amount instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.amount.getClass().getName() + " was encountered");
        }
        return (StringType)this.amount;
    }

    public boolean hasAmountStringType() {
        return this != null && this.amount instanceof StringType;
    }

    public boolean hasAmount() {
        return this.amount != null && !this.amount.isEmpty();
    }

    public SubstanceAmount setAmount(DataType value) {
        if (!(value == null || value instanceof Quantity || value instanceof Range || value instanceof StringType)) {
            throw new Error("Not the right type for SubstanceAmount.amount[x]: " + value.fhirType());
        }
        this.amount = value;
        return this;
    }

    public CodeableConcept getAmountType() {
        if (this.amountType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceAmount.amountType");
            }
            if (Configuration.doAutoCreate()) {
                this.amountType = new CodeableConcept();
            }
        }
        return this.amountType;
    }

    public boolean hasAmountType() {
        return this.amountType != null && !this.amountType.isEmpty();
    }

    public SubstanceAmount setAmountType(CodeableConcept value) {
        this.amountType = value;
        return this;
    }

    public StringType getAmountTextElement() {
        if (this.amountText == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceAmount.amountText");
            }
            if (Configuration.doAutoCreate()) {
                this.amountText = new StringType();
            }
        }
        return this.amountText;
    }

    public boolean hasAmountTextElement() {
        return this.amountText != null && !this.amountText.isEmpty();
    }

    public boolean hasAmountText() {
        return this.amountText != null && !this.amountText.isEmpty();
    }

    public SubstanceAmount setAmountTextElement(StringType value) {
        this.amountText = value;
        return this;
    }

    public String getAmountText() {
        return this.amountText == null ? null : (String)this.amountText.getValue();
    }

    public SubstanceAmount setAmountText(String value) {
        if (Utilities.noString((String)value)) {
            this.amountText = null;
        } else {
            if (this.amountText == null) {
                this.amountText = new StringType();
            }
            this.amountText.setValue(value);
        }
        return this;
    }

    public SubstanceAmountReferenceRangeComponent getReferenceRange() {
        if (this.referenceRange == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceAmount.referenceRange");
            }
            if (Configuration.doAutoCreate()) {
                this.referenceRange = new SubstanceAmountReferenceRangeComponent();
            }
        }
        return this.referenceRange;
    }

    public boolean hasReferenceRange() {
        return this.referenceRange != null && !this.referenceRange.isEmpty();
    }

    public SubstanceAmount setReferenceRange(SubstanceAmountReferenceRangeComponent value) {
        this.referenceRange = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("amount[x]", "Quantity|Range|string", "Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.", 0, 1, this.amount));
        children.add(new Property("amountType", "CodeableConcept", "Most elements that require a quantitative value will also have a field called amount type. Amount type should always be specified because the actual value of the amount is often dependent on it. EXAMPLE: In capturing the actual relative amounts of substances or molecular fragments it is essential to indicate whether the amount refers to a mole ratio or weight ratio. For any given element an effort should be made to use same the amount type for all related definitional elements.", 0, 1, this.amountType));
        children.add(new Property("amountText", "string", "A textual comment on a numeric value.", 0, 1, this.amountText));
        children.add(new Property("referenceRange", "", "Reference range of possible or expected values.", 0, 1, this.referenceRange));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 646780200: {
                return new Property("amount[x]", "Quantity|Range|string", "Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.", 0, 1, this.amount);
            }
            case -1413853096: {
                return new Property("amount[x]", "Quantity|Range|string", "Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.", 0, 1, this.amount);
            }
            case 1664303363: {
                return new Property("amount[x]", "Quantity", "Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.", 0, 1, this.amount);
            }
            case -1223462971: {
                return new Property("amount[x]", "Range", "Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.", 0, 1, this.amount);
            }
            case 773651081: {
                return new Property("amount[x]", "string", "Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.", 0, 1, this.amount);
            }
            case -1424857166: {
                return new Property("amountType", "CodeableConcept", "Most elements that require a quantitative value will also have a field called amount type. Amount type should always be specified because the actual value of the amount is often dependent on it. EXAMPLE: In capturing the actual relative amounts of substances or molecular fragments it is essential to indicate whether the amount refers to a mole ratio or weight ratio. For any given element an effort should be made to use same the amount type for all related definitional elements.", 0, 1, this.amountType);
            }
            case -1424876123: {
                return new Property("amountText", "string", "A textual comment on a numeric value.", 0, 1, this.amountText);
            }
            case -1912545102: {
                return new Property("referenceRange", "", "Reference range of possible or expected values.", 0, 1, this.referenceRange);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1413853096: {
                Base[] baseArray;
                if (this.amount == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.amount;
                }
                return baseArray;
            }
            case -1424857166: {
                Base[] baseArray;
                if (this.amountType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.amountType;
                }
                return baseArray;
            }
            case -1424876123: {
                Base[] baseArray;
                if (this.amountText == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.amountText;
                }
                return baseArray;
            }
            case -1912545102: {
                Base[] baseArray;
                if (this.referenceRange == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.referenceRange;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1413853096: {
                this.amount = TypeConvertor.castToType(value);
                return value;
            }
            case -1424857166: {
                this.amountType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1424876123: {
                this.amountText = TypeConvertor.castToString(value);
                return value;
            }
            case -1912545102: {
                this.referenceRange = (SubstanceAmountReferenceRangeComponent)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("amount[x]")) {
            this.amount = TypeConvertor.castToType(value);
        } else if (name.equals("amountType")) {
            this.amountType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("amountText")) {
            this.amountText = TypeConvertor.castToString(value);
        } else if (name.equals("referenceRange")) {
            this.referenceRange = (SubstanceAmountReferenceRangeComponent)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 646780200: {
                return this.getAmount();
            }
            case -1413853096: {
                return this.getAmount();
            }
            case -1424857166: {
                return this.getAmountType();
            }
            case -1424876123: {
                return this.getAmountTextElement();
            }
            case -1912545102: {
                return this.getReferenceRange();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1413853096: {
                return new String[]{"Quantity", "Range", "string"};
            }
            case -1424857166: {
                return new String[]{"CodeableConcept"};
            }
            case -1424876123: {
                return new String[]{"string"};
            }
            case -1912545102: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("amountQuantity")) {
            this.amount = new Quantity();
            return this.amount;
        }
        if (name.equals("amountRange")) {
            this.amount = new Range();
            return this.amount;
        }
        if (name.equals("amountString")) {
            this.amount = new StringType();
            return this.amount;
        }
        if (name.equals("amountType")) {
            this.amountType = new CodeableConcept();
            return this.amountType;
        }
        if (name.equals("amountText")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubstanceAmount.amountText");
        }
        if (name.equals("referenceRange")) {
            this.referenceRange = new SubstanceAmountReferenceRangeComponent();
            return this.referenceRange;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SubstanceAmount";
    }

    @Override
    public SubstanceAmount copy() {
        SubstanceAmount dst = new SubstanceAmount();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SubstanceAmount dst) {
        super.copyValues(dst);
        dst.amount = this.amount == null ? null : this.amount.copy();
        dst.amountType = this.amountType == null ? null : this.amountType.copy();
        dst.amountText = this.amountText == null ? null : this.amountText.copy();
        dst.referenceRange = this.referenceRange == null ? null : this.referenceRange.copy();
    }

    protected SubstanceAmount typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceAmount)) {
            return false;
        }
        SubstanceAmount o = (SubstanceAmount)other_;
        return SubstanceAmount.compareDeep(this.amount, o.amount, true) && SubstanceAmount.compareDeep(this.amountType, o.amountType, true) && SubstanceAmount.compareDeep(this.amountText, o.amountText, true) && SubstanceAmount.compareDeep(this.referenceRange, o.referenceRange, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceAmount)) {
            return false;
        }
        SubstanceAmount o = (SubstanceAmount)other_;
        return SubstanceAmount.compareValues(this.amountText, o.amountText, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.amount, this.amountType, this.amountText, this.referenceRange});
    }

    @Block
    public static class SubstanceAmountReferenceRangeComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="lowLimit", type={Quantity.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Lower limit possible or expected", formalDefinition="Lower limit possible or expected.")
        protected Quantity lowLimit;
        @Child(name="highLimit", type={Quantity.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Upper limit possible or expected", formalDefinition="Upper limit possible or expected.")
        protected Quantity highLimit;
        private static final long serialVersionUID = -193230412L;

        public Quantity getLowLimit() {
            if (this.lowLimit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceAmountReferenceRangeComponent.lowLimit");
                }
                if (Configuration.doAutoCreate()) {
                    this.lowLimit = new Quantity();
                }
            }
            return this.lowLimit;
        }

        public boolean hasLowLimit() {
            return this.lowLimit != null && !this.lowLimit.isEmpty();
        }

        public SubstanceAmountReferenceRangeComponent setLowLimit(Quantity value) {
            this.lowLimit = value;
            return this;
        }

        public Quantity getHighLimit() {
            if (this.highLimit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceAmountReferenceRangeComponent.highLimit");
                }
                if (Configuration.doAutoCreate()) {
                    this.highLimit = new Quantity();
                }
            }
            return this.highLimit;
        }

        public boolean hasHighLimit() {
            return this.highLimit != null && !this.highLimit.isEmpty();
        }

        public SubstanceAmountReferenceRangeComponent setHighLimit(Quantity value) {
            this.highLimit = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("lowLimit", "Quantity", "Lower limit possible or expected.", 0, 1, this.lowLimit));
            children.add(new Property("highLimit", "Quantity", "Upper limit possible or expected.", 0, 1, this.highLimit));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1841058617: {
                    return new Property("lowLimit", "Quantity", "Lower limit possible or expected.", 0, 1, this.lowLimit);
                }
                case -710757575: {
                    return new Property("highLimit", "Quantity", "Upper limit possible or expected.", 0, 1, this.highLimit);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1841058617: {
                    Base[] baseArray;
                    if (this.lowLimit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.lowLimit;
                    }
                    return baseArray;
                }
                case -710757575: {
                    Base[] baseArray;
                    if (this.highLimit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.highLimit;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1841058617: {
                    this.lowLimit = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -710757575: {
                    this.highLimit = TypeConvertor.castToQuantity(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("lowLimit")) {
                this.lowLimit = TypeConvertor.castToQuantity(value);
            } else if (name.equals("highLimit")) {
                this.highLimit = TypeConvertor.castToQuantity(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1841058617: {
                    return this.getLowLimit();
                }
                case -710757575: {
                    return this.getHighLimit();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1841058617: {
                    return new String[]{"Quantity"};
                }
                case -710757575: {
                    return new String[]{"Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("lowLimit")) {
                this.lowLimit = new Quantity();
                return this.lowLimit;
            }
            if (name.equals("highLimit")) {
                this.highLimit = new Quantity();
                return this.highLimit;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceAmountReferenceRangeComponent copy() {
            SubstanceAmountReferenceRangeComponent dst = new SubstanceAmountReferenceRangeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceAmountReferenceRangeComponent dst) {
            super.copyValues(dst);
            dst.lowLimit = this.lowLimit == null ? null : this.lowLimit.copy();
            dst.highLimit = this.highLimit == null ? null : this.highLimit.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceAmountReferenceRangeComponent)) {
                return false;
            }
            SubstanceAmountReferenceRangeComponent o = (SubstanceAmountReferenceRangeComponent)other_;
            return SubstanceAmountReferenceRangeComponent.compareDeep(this.lowLimit, o.lowLimit, true) && SubstanceAmountReferenceRangeComponent.compareDeep(this.highLimit, o.highLimit, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceAmountReferenceRangeComponent)) {
                return false;
            }
            SubstanceAmountReferenceRangeComponent o = (SubstanceAmountReferenceRangeComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.lowLimit, this.highLimit});
        }

        @Override
        public String fhirType() {
            return "SubstanceAmount.referenceRange";
        }
    }
}

