/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.Base64BinaryType;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DetectedIssue;
import org.hl7.fhir.r4b.model.DocumentReference;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.Dosage;
import org.hl7.fhir.r4b.model.Duration;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.MarkdownType;
import org.hl7.fhir.r4b.model.Media;
import org.hl7.fhir.r4b.model.Medication;
import org.hl7.fhir.r4b.model.Money;
import org.hl7.fhir.r4b.model.ObservationDefinition;
import org.hl7.fhir.r4b.model.Organization;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Quantity;
import org.hl7.fhir.r4b.model.Ratio;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.Substance;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicationKnowledge", profile="http://hl7.org/fhir/StructureDefinition/MedicationKnowledge")
public class MedicationKnowledge
extends DomainResource {
    @Child(name="code", type={CodeableConcept.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Code that identifies this medication", formalDefinition="A code that specifies this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected CodeableConcept code;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | inactive | entered-in-error", formalDefinition="A code to indicate if the medication is in active use.  The status refers to the validity about the information of the medication and not to its medicinal properties.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationknowledge-status")
    protected Enumeration<MedicationKnowledgeStatusCodes> status;
    @Child(name="manufacturer", type={Organization.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of the item", formalDefinition="Describes the details of the manufacturer of the medication product.  This is not intended to represent the distributor of a medication product.")
    protected Reference manufacturer;
    @Child(name="doseForm", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="powder | tablets | capsule +", formalDefinition="Describes the form of the item.  Powder; tablets; capsule.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-form-codes")
    protected CodeableConcept doseForm;
    @Child(name="amount", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Amount of drug in package", formalDefinition="Specific amount of the drug in the packaged product.  For example, when specifying a product that has the same strength (For example, Insulin glargine 100 unit per mL solution for injection), this attribute provides additional clarification of the package amount (For example, 3 mL, 10mL, etc.).")
    protected Quantity amount;
    @Child(name="synonym", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional names for a medication", formalDefinition="Additional names for a medication, for example, the name(s) given to a medication in different countries.  For example, acetaminophen and paracetamol or salbutamol and albuterol.")
    protected List<StringType> synonym;
    @Child(name="relatedMedicationKnowledge", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Associated or related medication information", formalDefinition="Associated or related knowledge about a medication.")
    protected List<MedicationKnowledgeRelatedMedicationKnowledgeComponent> relatedMedicationKnowledge;
    @Child(name="associatedMedication", type={Medication.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A medication resource that is associated with this medication", formalDefinition="Associated or related medications.  For example, if the medication is a branded product (e.g. Crestor), this is the Therapeutic Moeity (e.g. Rosuvastatin) or if this is a generic medication (e.g. Rosuvastatin), this would link to a branded product (e.g. Crestor).")
    protected List<Reference> associatedMedication;
    @Child(name="productType", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Category of the medication or product", formalDefinition="Category of the medication or product (e.g. branded product, therapeutic moeity, generic product, innovator product, etc.).")
    protected List<CodeableConcept> productType;
    @Child(name="monograph", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Associated documentation about the medication", formalDefinition="Associated documentation about the medication.")
    protected List<MedicationKnowledgeMonographComponent> monograph;
    @Child(name="ingredient", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Active or inactive ingredient", formalDefinition="Identifies a particular constituent of interest in the product.")
    protected List<MedicationKnowledgeIngredientComponent> ingredient;
    @Child(name="preparationInstruction", type={MarkdownType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The instructions for preparing the medication", formalDefinition="The instructions for preparing the medication.")
    protected MarkdownType preparationInstruction;
    @Child(name="intendedRoute", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The intended or approved route of administration", formalDefinition="The intended or approved route of administration.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/route-codes")
    protected List<CodeableConcept> intendedRoute;
    @Child(name="cost", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The pricing of the medication", formalDefinition="The price of the medication.")
    protected List<MedicationKnowledgeCostComponent> cost;
    @Child(name="monitoringProgram", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Program under which a medication is reviewed", formalDefinition="The program under which the medication is reviewed.")
    protected List<MedicationKnowledgeMonitoringProgramComponent> monitoringProgram;
    @Child(name="administrationGuidelines", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Guidelines for administration of the medication", formalDefinition="Guidelines for the administration of the medication.")
    protected List<MedicationKnowledgeAdministrationGuidelinesComponent> administrationGuidelines;
    @Child(name="medicineClassification", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Categorization of the medication within a formulary or classification system", formalDefinition="Categorization of the medication within a formulary or classification system.")
    protected List<MedicationKnowledgeMedicineClassificationComponent> medicineClassification;
    @Child(name="packaging", type={}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details about packaged medications", formalDefinition="Information that only applies to packages (not products).")
    protected MedicationKnowledgePackagingComponent packaging;
    @Child(name="drugCharacteristic", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specifies descriptive properties of the medicine", formalDefinition="Specifies descriptive properties of the medicine, such as color, shape, imprints, etc.")
    protected List<MedicationKnowledgeDrugCharacteristicComponent> drugCharacteristic;
    @Child(name="contraindication", type={DetectedIssue.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Potential clinical issue with or between medication(s)", formalDefinition="Potential clinical issue with or between medication(s) (for example, drug-drug interaction, drug-disease contraindication, drug-allergy interaction, etc.).")
    protected List<Reference> contraindication;
    @Child(name="regulatory", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Regulatory information about a medication", formalDefinition="Regulatory information about a medication.")
    protected List<MedicationKnowledgeRegulatoryComponent> regulatory;
    @Child(name="kinetics", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The time course of drug absorption, distribution, metabolism and excretion of a medication from the body", formalDefinition="The time course of drug absorption, distribution, metabolism and excretion of a medication from the body.")
    protected List<MedicationKnowledgeKineticsComponent> kinetics;
    private static final long serialVersionUID = -268799938L;
    @SearchParamDefinition(name="classification-type", path="MedicationKnowledge.medicineClassification.type", description="The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification)", type="token")
    public static final String SP_CLASSIFICATION_TYPE = "classification-type";
    public static final TokenClientParam CLASSIFICATION_TYPE = new TokenClientParam("classification-type");
    @SearchParamDefinition(name="classification", path="MedicationKnowledge.medicineClassification.classification", description="Specific category assigned to the medication", type="token")
    public static final String SP_CLASSIFICATION = "classification";
    public static final TokenClientParam CLASSIFICATION = new TokenClientParam("classification");
    @SearchParamDefinition(name="code", path="MedicationKnowledge.code", description="Code that identifies this medication", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="doseform", path="MedicationKnowledge.doseForm", description="powder | tablets | capsule +", type="token")
    public static final String SP_DOSEFORM = "doseform";
    public static final TokenClientParam DOSEFORM = new TokenClientParam("doseform");
    @SearchParamDefinition(name="ingredient-code", path="(MedicationKnowledge.ingredient.item as CodeableConcept)", description="Medication(s) or substance(s) contained in the medication", type="token")
    public static final String SP_INGREDIENT_CODE = "ingredient-code";
    public static final TokenClientParam INGREDIENT_CODE = new TokenClientParam("ingredient-code");
    @SearchParamDefinition(name="ingredient", path="(MedicationKnowledge.ingredient.item as Reference)", description="Medication(s) or substance(s) contained in the medication", type="reference", target={Substance.class})
    public static final String SP_INGREDIENT = "ingredient";
    public static final ReferenceClientParam INGREDIENT = new ReferenceClientParam("ingredient");
    public static final Include INCLUDE_INGREDIENT = new Include("MedicationKnowledge:ingredient").toLocked();
    @SearchParamDefinition(name="manufacturer", path="MedicationKnowledge.manufacturer", description="Manufacturer of the item", type="reference", target={Organization.class})
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final ReferenceClientParam MANUFACTURER = new ReferenceClientParam("manufacturer");
    public static final Include INCLUDE_MANUFACTURER = new Include("MedicationKnowledge:manufacturer").toLocked();
    @SearchParamDefinition(name="monitoring-program-name", path="MedicationKnowledge.monitoringProgram.name", description="Name of the reviewing program", type="token")
    public static final String SP_MONITORING_PROGRAM_NAME = "monitoring-program-name";
    public static final TokenClientParam MONITORING_PROGRAM_NAME = new TokenClientParam("monitoring-program-name");
    @SearchParamDefinition(name="monitoring-program-type", path="MedicationKnowledge.monitoringProgram.type", description="Type of program under which the medication is monitored", type="token")
    public static final String SP_MONITORING_PROGRAM_TYPE = "monitoring-program-type";
    public static final TokenClientParam MONITORING_PROGRAM_TYPE = new TokenClientParam("monitoring-program-type");
    @SearchParamDefinition(name="monograph-type", path="MedicationKnowledge.monograph.type", description="The category of medication document", type="token")
    public static final String SP_MONOGRAPH_TYPE = "monograph-type";
    public static final TokenClientParam MONOGRAPH_TYPE = new TokenClientParam("monograph-type");
    @SearchParamDefinition(name="monograph", path="MedicationKnowledge.monograph.source", description="Associated documentation about the medication", type="reference", target={DocumentReference.class, Media.class})
    public static final String SP_MONOGRAPH = "monograph";
    public static final ReferenceClientParam MONOGRAPH = new ReferenceClientParam("monograph");
    public static final Include INCLUDE_MONOGRAPH = new Include("MedicationKnowledge:monograph").toLocked();
    @SearchParamDefinition(name="source-cost", path="MedicationKnowledge.cost.source", description="The source or owner for the price information", type="token")
    public static final String SP_SOURCE_COST = "source-cost";
    public static final TokenClientParam SOURCE_COST = new TokenClientParam("source-cost");
    @SearchParamDefinition(name="status", path="MedicationKnowledge.status", description="active | inactive | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public MedicationKnowledge setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Enumeration<MedicationKnowledgeStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationKnowledgeStatusCodes>(new MedicationKnowledgeStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicationKnowledge setStatusElement(Enumeration<MedicationKnowledgeStatusCodes> value) {
        this.status = value;
        return this;
    }

    public MedicationKnowledgeStatusCodes getStatus() {
        return this.status == null ? null : (MedicationKnowledgeStatusCodes)((Object)this.status.getValue());
    }

    public MedicationKnowledge setStatus(MedicationKnowledgeStatusCodes value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<MedicationKnowledgeStatusCodes>(new MedicationKnowledgeStatusCodesEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getManufacturer() {
        if (this.manufacturer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturer = new Reference();
            }
        }
        return this.manufacturer;
    }

    public boolean hasManufacturer() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public MedicationKnowledge setManufacturer(Reference value) {
        this.manufacturer = value;
        return this;
    }

    public CodeableConcept getDoseForm() {
        if (this.doseForm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.doseForm");
            }
            if (Configuration.doAutoCreate()) {
                this.doseForm = new CodeableConcept();
            }
        }
        return this.doseForm;
    }

    public boolean hasDoseForm() {
        return this.doseForm != null && !this.doseForm.isEmpty();
    }

    public MedicationKnowledge setDoseForm(CodeableConcept value) {
        this.doseForm = value;
        return this;
    }

    public Quantity getAmount() {
        if (this.amount == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.amount");
            }
            if (Configuration.doAutoCreate()) {
                this.amount = new Quantity();
            }
        }
        return this.amount;
    }

    public boolean hasAmount() {
        return this.amount != null && !this.amount.isEmpty();
    }

    public MedicationKnowledge setAmount(Quantity value) {
        this.amount = value;
        return this;
    }

    public List<StringType> getSynonym() {
        if (this.synonym == null) {
            this.synonym = new ArrayList<StringType>();
        }
        return this.synonym;
    }

    public MedicationKnowledge setSynonym(List<StringType> theSynonym) {
        this.synonym = theSynonym;
        return this;
    }

    public boolean hasSynonym() {
        if (this.synonym == null) {
            return false;
        }
        for (StringType item : this.synonym) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addSynonymElement() {
        StringType t = new StringType();
        if (this.synonym == null) {
            this.synonym = new ArrayList<StringType>();
        }
        this.synonym.add(t);
        return t;
    }

    public MedicationKnowledge addSynonym(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.synonym == null) {
            this.synonym = new ArrayList<StringType>();
        }
        this.synonym.add(t);
        return this;
    }

    public boolean hasSynonym(String value) {
        if (this.synonym == null) {
            return false;
        }
        for (StringType v : this.synonym) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<MedicationKnowledgeRelatedMedicationKnowledgeComponent> getRelatedMedicationKnowledge() {
        if (this.relatedMedicationKnowledge == null) {
            this.relatedMedicationKnowledge = new ArrayList<MedicationKnowledgeRelatedMedicationKnowledgeComponent>();
        }
        return this.relatedMedicationKnowledge;
    }

    public MedicationKnowledge setRelatedMedicationKnowledge(List<MedicationKnowledgeRelatedMedicationKnowledgeComponent> theRelatedMedicationKnowledge) {
        this.relatedMedicationKnowledge = theRelatedMedicationKnowledge;
        return this;
    }

    public boolean hasRelatedMedicationKnowledge() {
        if (this.relatedMedicationKnowledge == null) {
            return false;
        }
        for (MedicationKnowledgeRelatedMedicationKnowledgeComponent item : this.relatedMedicationKnowledge) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeRelatedMedicationKnowledgeComponent addRelatedMedicationKnowledge() {
        MedicationKnowledgeRelatedMedicationKnowledgeComponent t = new MedicationKnowledgeRelatedMedicationKnowledgeComponent();
        if (this.relatedMedicationKnowledge == null) {
            this.relatedMedicationKnowledge = new ArrayList<MedicationKnowledgeRelatedMedicationKnowledgeComponent>();
        }
        this.relatedMedicationKnowledge.add(t);
        return t;
    }

    public MedicationKnowledge addRelatedMedicationKnowledge(MedicationKnowledgeRelatedMedicationKnowledgeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relatedMedicationKnowledge == null) {
            this.relatedMedicationKnowledge = new ArrayList<MedicationKnowledgeRelatedMedicationKnowledgeComponent>();
        }
        this.relatedMedicationKnowledge.add(t);
        return this;
    }

    public MedicationKnowledgeRelatedMedicationKnowledgeComponent getRelatedMedicationKnowledgeFirstRep() {
        if (this.getRelatedMedicationKnowledge().isEmpty()) {
            this.addRelatedMedicationKnowledge();
        }
        return this.getRelatedMedicationKnowledge().get(0);
    }

    public List<Reference> getAssociatedMedication() {
        if (this.associatedMedication == null) {
            this.associatedMedication = new ArrayList<Reference>();
        }
        return this.associatedMedication;
    }

    public MedicationKnowledge setAssociatedMedication(List<Reference> theAssociatedMedication) {
        this.associatedMedication = theAssociatedMedication;
        return this;
    }

    public boolean hasAssociatedMedication() {
        if (this.associatedMedication == null) {
            return false;
        }
        for (Reference item : this.associatedMedication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAssociatedMedication() {
        Reference t = new Reference();
        if (this.associatedMedication == null) {
            this.associatedMedication = new ArrayList<Reference>();
        }
        this.associatedMedication.add(t);
        return t;
    }

    public MedicationKnowledge addAssociatedMedication(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.associatedMedication == null) {
            this.associatedMedication = new ArrayList<Reference>();
        }
        this.associatedMedication.add(t);
        return this;
    }

    public Reference getAssociatedMedicationFirstRep() {
        if (this.getAssociatedMedication().isEmpty()) {
            this.addAssociatedMedication();
        }
        return this.getAssociatedMedication().get(0);
    }

    public List<CodeableConcept> getProductType() {
        if (this.productType == null) {
            this.productType = new ArrayList<CodeableConcept>();
        }
        return this.productType;
    }

    public MedicationKnowledge setProductType(List<CodeableConcept> theProductType) {
        this.productType = theProductType;
        return this;
    }

    public boolean hasProductType() {
        if (this.productType == null) {
            return false;
        }
        for (CodeableConcept item : this.productType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addProductType() {
        CodeableConcept t = new CodeableConcept();
        if (this.productType == null) {
            this.productType = new ArrayList<CodeableConcept>();
        }
        this.productType.add(t);
        return t;
    }

    public MedicationKnowledge addProductType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.productType == null) {
            this.productType = new ArrayList<CodeableConcept>();
        }
        this.productType.add(t);
        return this;
    }

    public CodeableConcept getProductTypeFirstRep() {
        if (this.getProductType().isEmpty()) {
            this.addProductType();
        }
        return this.getProductType().get(0);
    }

    public List<MedicationKnowledgeMonographComponent> getMonograph() {
        if (this.monograph == null) {
            this.monograph = new ArrayList<MedicationKnowledgeMonographComponent>();
        }
        return this.monograph;
    }

    public MedicationKnowledge setMonograph(List<MedicationKnowledgeMonographComponent> theMonograph) {
        this.monograph = theMonograph;
        return this;
    }

    public boolean hasMonograph() {
        if (this.monograph == null) {
            return false;
        }
        for (MedicationKnowledgeMonographComponent item : this.monograph) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeMonographComponent addMonograph() {
        MedicationKnowledgeMonographComponent t = new MedicationKnowledgeMonographComponent();
        if (this.monograph == null) {
            this.monograph = new ArrayList<MedicationKnowledgeMonographComponent>();
        }
        this.monograph.add(t);
        return t;
    }

    public MedicationKnowledge addMonograph(MedicationKnowledgeMonographComponent t) {
        if (t == null) {
            return this;
        }
        if (this.monograph == null) {
            this.monograph = new ArrayList<MedicationKnowledgeMonographComponent>();
        }
        this.monograph.add(t);
        return this;
    }

    public MedicationKnowledgeMonographComponent getMonographFirstRep() {
        if (this.getMonograph().isEmpty()) {
            this.addMonograph();
        }
        return this.getMonograph().get(0);
    }

    public List<MedicationKnowledgeIngredientComponent> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationKnowledgeIngredientComponent>();
        }
        return this.ingredient;
    }

    public MedicationKnowledge setIngredient(List<MedicationKnowledgeIngredientComponent> theIngredient) {
        this.ingredient = theIngredient;
        return this;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (MedicationKnowledgeIngredientComponent item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeIngredientComponent addIngredient() {
        MedicationKnowledgeIngredientComponent t = new MedicationKnowledgeIngredientComponent();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationKnowledgeIngredientComponent>();
        }
        this.ingredient.add(t);
        return t;
    }

    public MedicationKnowledge addIngredient(MedicationKnowledgeIngredientComponent t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationKnowledgeIngredientComponent>();
        }
        this.ingredient.add(t);
        return this;
    }

    public MedicationKnowledgeIngredientComponent getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    public MarkdownType getPreparationInstructionElement() {
        if (this.preparationInstruction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.preparationInstruction");
            }
            if (Configuration.doAutoCreate()) {
                this.preparationInstruction = new MarkdownType();
            }
        }
        return this.preparationInstruction;
    }

    public boolean hasPreparationInstructionElement() {
        return this.preparationInstruction != null && !this.preparationInstruction.isEmpty();
    }

    public boolean hasPreparationInstruction() {
        return this.preparationInstruction != null && !this.preparationInstruction.isEmpty();
    }

    public MedicationKnowledge setPreparationInstructionElement(MarkdownType value) {
        this.preparationInstruction = value;
        return this;
    }

    public String getPreparationInstruction() {
        return this.preparationInstruction == null ? null : (String)this.preparationInstruction.getValue();
    }

    public MedicationKnowledge setPreparationInstruction(String value) {
        if (value == null) {
            this.preparationInstruction = null;
        } else {
            if (this.preparationInstruction == null) {
                this.preparationInstruction = new MarkdownType();
            }
            this.preparationInstruction.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getIntendedRoute() {
        if (this.intendedRoute == null) {
            this.intendedRoute = new ArrayList<CodeableConcept>();
        }
        return this.intendedRoute;
    }

    public MedicationKnowledge setIntendedRoute(List<CodeableConcept> theIntendedRoute) {
        this.intendedRoute = theIntendedRoute;
        return this;
    }

    public boolean hasIntendedRoute() {
        if (this.intendedRoute == null) {
            return false;
        }
        for (CodeableConcept item : this.intendedRoute) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addIntendedRoute() {
        CodeableConcept t = new CodeableConcept();
        if (this.intendedRoute == null) {
            this.intendedRoute = new ArrayList<CodeableConcept>();
        }
        this.intendedRoute.add(t);
        return t;
    }

    public MedicationKnowledge addIntendedRoute(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.intendedRoute == null) {
            this.intendedRoute = new ArrayList<CodeableConcept>();
        }
        this.intendedRoute.add(t);
        return this;
    }

    public CodeableConcept getIntendedRouteFirstRep() {
        if (this.getIntendedRoute().isEmpty()) {
            this.addIntendedRoute();
        }
        return this.getIntendedRoute().get(0);
    }

    public List<MedicationKnowledgeCostComponent> getCost() {
        if (this.cost == null) {
            this.cost = new ArrayList<MedicationKnowledgeCostComponent>();
        }
        return this.cost;
    }

    public MedicationKnowledge setCost(List<MedicationKnowledgeCostComponent> theCost) {
        this.cost = theCost;
        return this;
    }

    public boolean hasCost() {
        if (this.cost == null) {
            return false;
        }
        for (MedicationKnowledgeCostComponent item : this.cost) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeCostComponent addCost() {
        MedicationKnowledgeCostComponent t = new MedicationKnowledgeCostComponent();
        if (this.cost == null) {
            this.cost = new ArrayList<MedicationKnowledgeCostComponent>();
        }
        this.cost.add(t);
        return t;
    }

    public MedicationKnowledge addCost(MedicationKnowledgeCostComponent t) {
        if (t == null) {
            return this;
        }
        if (this.cost == null) {
            this.cost = new ArrayList<MedicationKnowledgeCostComponent>();
        }
        this.cost.add(t);
        return this;
    }

    public MedicationKnowledgeCostComponent getCostFirstRep() {
        if (this.getCost().isEmpty()) {
            this.addCost();
        }
        return this.getCost().get(0);
    }

    public List<MedicationKnowledgeMonitoringProgramComponent> getMonitoringProgram() {
        if (this.monitoringProgram == null) {
            this.monitoringProgram = new ArrayList<MedicationKnowledgeMonitoringProgramComponent>();
        }
        return this.monitoringProgram;
    }

    public MedicationKnowledge setMonitoringProgram(List<MedicationKnowledgeMonitoringProgramComponent> theMonitoringProgram) {
        this.monitoringProgram = theMonitoringProgram;
        return this;
    }

    public boolean hasMonitoringProgram() {
        if (this.monitoringProgram == null) {
            return false;
        }
        for (MedicationKnowledgeMonitoringProgramComponent item : this.monitoringProgram) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeMonitoringProgramComponent addMonitoringProgram() {
        MedicationKnowledgeMonitoringProgramComponent t = new MedicationKnowledgeMonitoringProgramComponent();
        if (this.monitoringProgram == null) {
            this.monitoringProgram = new ArrayList<MedicationKnowledgeMonitoringProgramComponent>();
        }
        this.monitoringProgram.add(t);
        return t;
    }

    public MedicationKnowledge addMonitoringProgram(MedicationKnowledgeMonitoringProgramComponent t) {
        if (t == null) {
            return this;
        }
        if (this.monitoringProgram == null) {
            this.monitoringProgram = new ArrayList<MedicationKnowledgeMonitoringProgramComponent>();
        }
        this.monitoringProgram.add(t);
        return this;
    }

    public MedicationKnowledgeMonitoringProgramComponent getMonitoringProgramFirstRep() {
        if (this.getMonitoringProgram().isEmpty()) {
            this.addMonitoringProgram();
        }
        return this.getMonitoringProgram().get(0);
    }

    public List<MedicationKnowledgeAdministrationGuidelinesComponent> getAdministrationGuidelines() {
        if (this.administrationGuidelines == null) {
            this.administrationGuidelines = new ArrayList<MedicationKnowledgeAdministrationGuidelinesComponent>();
        }
        return this.administrationGuidelines;
    }

    public MedicationKnowledge setAdministrationGuidelines(List<MedicationKnowledgeAdministrationGuidelinesComponent> theAdministrationGuidelines) {
        this.administrationGuidelines = theAdministrationGuidelines;
        return this;
    }

    public boolean hasAdministrationGuidelines() {
        if (this.administrationGuidelines == null) {
            return false;
        }
        for (MedicationKnowledgeAdministrationGuidelinesComponent item : this.administrationGuidelines) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeAdministrationGuidelinesComponent addAdministrationGuidelines() {
        MedicationKnowledgeAdministrationGuidelinesComponent t = new MedicationKnowledgeAdministrationGuidelinesComponent();
        if (this.administrationGuidelines == null) {
            this.administrationGuidelines = new ArrayList<MedicationKnowledgeAdministrationGuidelinesComponent>();
        }
        this.administrationGuidelines.add(t);
        return t;
    }

    public MedicationKnowledge addAdministrationGuidelines(MedicationKnowledgeAdministrationGuidelinesComponent t) {
        if (t == null) {
            return this;
        }
        if (this.administrationGuidelines == null) {
            this.administrationGuidelines = new ArrayList<MedicationKnowledgeAdministrationGuidelinesComponent>();
        }
        this.administrationGuidelines.add(t);
        return this;
    }

    public MedicationKnowledgeAdministrationGuidelinesComponent getAdministrationGuidelinesFirstRep() {
        if (this.getAdministrationGuidelines().isEmpty()) {
            this.addAdministrationGuidelines();
        }
        return this.getAdministrationGuidelines().get(0);
    }

    public List<MedicationKnowledgeMedicineClassificationComponent> getMedicineClassification() {
        if (this.medicineClassification == null) {
            this.medicineClassification = new ArrayList<MedicationKnowledgeMedicineClassificationComponent>();
        }
        return this.medicineClassification;
    }

    public MedicationKnowledge setMedicineClassification(List<MedicationKnowledgeMedicineClassificationComponent> theMedicineClassification) {
        this.medicineClassification = theMedicineClassification;
        return this;
    }

    public boolean hasMedicineClassification() {
        if (this.medicineClassification == null) {
            return false;
        }
        for (MedicationKnowledgeMedicineClassificationComponent item : this.medicineClassification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeMedicineClassificationComponent addMedicineClassification() {
        MedicationKnowledgeMedicineClassificationComponent t = new MedicationKnowledgeMedicineClassificationComponent();
        if (this.medicineClassification == null) {
            this.medicineClassification = new ArrayList<MedicationKnowledgeMedicineClassificationComponent>();
        }
        this.medicineClassification.add(t);
        return t;
    }

    public MedicationKnowledge addMedicineClassification(MedicationKnowledgeMedicineClassificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.medicineClassification == null) {
            this.medicineClassification = new ArrayList<MedicationKnowledgeMedicineClassificationComponent>();
        }
        this.medicineClassification.add(t);
        return this;
    }

    public MedicationKnowledgeMedicineClassificationComponent getMedicineClassificationFirstRep() {
        if (this.getMedicineClassification().isEmpty()) {
            this.addMedicineClassification();
        }
        return this.getMedicineClassification().get(0);
    }

    public MedicationKnowledgePackagingComponent getPackaging() {
        if (this.packaging == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.packaging");
            }
            if (Configuration.doAutoCreate()) {
                this.packaging = new MedicationKnowledgePackagingComponent();
            }
        }
        return this.packaging;
    }

    public boolean hasPackaging() {
        return this.packaging != null && !this.packaging.isEmpty();
    }

    public MedicationKnowledge setPackaging(MedicationKnowledgePackagingComponent value) {
        this.packaging = value;
        return this;
    }

    public List<MedicationKnowledgeDrugCharacteristicComponent> getDrugCharacteristic() {
        if (this.drugCharacteristic == null) {
            this.drugCharacteristic = new ArrayList<MedicationKnowledgeDrugCharacteristicComponent>();
        }
        return this.drugCharacteristic;
    }

    public MedicationKnowledge setDrugCharacteristic(List<MedicationKnowledgeDrugCharacteristicComponent> theDrugCharacteristic) {
        this.drugCharacteristic = theDrugCharacteristic;
        return this;
    }

    public boolean hasDrugCharacteristic() {
        if (this.drugCharacteristic == null) {
            return false;
        }
        for (MedicationKnowledgeDrugCharacteristicComponent item : this.drugCharacteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeDrugCharacteristicComponent addDrugCharacteristic() {
        MedicationKnowledgeDrugCharacteristicComponent t = new MedicationKnowledgeDrugCharacteristicComponent();
        if (this.drugCharacteristic == null) {
            this.drugCharacteristic = new ArrayList<MedicationKnowledgeDrugCharacteristicComponent>();
        }
        this.drugCharacteristic.add(t);
        return t;
    }

    public MedicationKnowledge addDrugCharacteristic(MedicationKnowledgeDrugCharacteristicComponent t) {
        if (t == null) {
            return this;
        }
        if (this.drugCharacteristic == null) {
            this.drugCharacteristic = new ArrayList<MedicationKnowledgeDrugCharacteristicComponent>();
        }
        this.drugCharacteristic.add(t);
        return this;
    }

    public MedicationKnowledgeDrugCharacteristicComponent getDrugCharacteristicFirstRep() {
        if (this.getDrugCharacteristic().isEmpty()) {
            this.addDrugCharacteristic();
        }
        return this.getDrugCharacteristic().get(0);
    }

    public List<Reference> getContraindication() {
        if (this.contraindication == null) {
            this.contraindication = new ArrayList<Reference>();
        }
        return this.contraindication;
    }

    public MedicationKnowledge setContraindication(List<Reference> theContraindication) {
        this.contraindication = theContraindication;
        return this;
    }

    public boolean hasContraindication() {
        if (this.contraindication == null) {
            return false;
        }
        for (Reference item : this.contraindication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addContraindication() {
        Reference t = new Reference();
        if (this.contraindication == null) {
            this.contraindication = new ArrayList<Reference>();
        }
        this.contraindication.add(t);
        return t;
    }

    public MedicationKnowledge addContraindication(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.contraindication == null) {
            this.contraindication = new ArrayList<Reference>();
        }
        this.contraindication.add(t);
        return this;
    }

    public Reference getContraindicationFirstRep() {
        if (this.getContraindication().isEmpty()) {
            this.addContraindication();
        }
        return this.getContraindication().get(0);
    }

    public List<MedicationKnowledgeRegulatoryComponent> getRegulatory() {
        if (this.regulatory == null) {
            this.regulatory = new ArrayList<MedicationKnowledgeRegulatoryComponent>();
        }
        return this.regulatory;
    }

    public MedicationKnowledge setRegulatory(List<MedicationKnowledgeRegulatoryComponent> theRegulatory) {
        this.regulatory = theRegulatory;
        return this;
    }

    public boolean hasRegulatory() {
        if (this.regulatory == null) {
            return false;
        }
        for (MedicationKnowledgeRegulatoryComponent item : this.regulatory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeRegulatoryComponent addRegulatory() {
        MedicationKnowledgeRegulatoryComponent t = new MedicationKnowledgeRegulatoryComponent();
        if (this.regulatory == null) {
            this.regulatory = new ArrayList<MedicationKnowledgeRegulatoryComponent>();
        }
        this.regulatory.add(t);
        return t;
    }

    public MedicationKnowledge addRegulatory(MedicationKnowledgeRegulatoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.regulatory == null) {
            this.regulatory = new ArrayList<MedicationKnowledgeRegulatoryComponent>();
        }
        this.regulatory.add(t);
        return this;
    }

    public MedicationKnowledgeRegulatoryComponent getRegulatoryFirstRep() {
        if (this.getRegulatory().isEmpty()) {
            this.addRegulatory();
        }
        return this.getRegulatory().get(0);
    }

    public List<MedicationKnowledgeKineticsComponent> getKinetics() {
        if (this.kinetics == null) {
            this.kinetics = new ArrayList<MedicationKnowledgeKineticsComponent>();
        }
        return this.kinetics;
    }

    public MedicationKnowledge setKinetics(List<MedicationKnowledgeKineticsComponent> theKinetics) {
        this.kinetics = theKinetics;
        return this;
    }

    public boolean hasKinetics() {
        if (this.kinetics == null) {
            return false;
        }
        for (MedicationKnowledgeKineticsComponent item : this.kinetics) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeKineticsComponent addKinetics() {
        MedicationKnowledgeKineticsComponent t = new MedicationKnowledgeKineticsComponent();
        if (this.kinetics == null) {
            this.kinetics = new ArrayList<MedicationKnowledgeKineticsComponent>();
        }
        this.kinetics.add(t);
        return t;
    }

    public MedicationKnowledge addKinetics(MedicationKnowledgeKineticsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.kinetics == null) {
            this.kinetics = new ArrayList<MedicationKnowledgeKineticsComponent>();
        }
        this.kinetics.add(t);
        return this;
    }

    public MedicationKnowledgeKineticsComponent getKineticsFirstRep() {
        if (this.getKinetics().isEmpty()) {
            this.addKinetics();
        }
        return this.getKinetics().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_CODE, "CodeableConcept", "A code that specifies this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.", 0, 1, this.code));
        children.add(new Property(SP_STATUS, SP_CODE, "A code to indicate if the medication is in active use.  The status refers to the validity about the information of the medication and not to its medicinal properties.", 0, 1, this.status));
        children.add(new Property(SP_MANUFACTURER, "Reference(Organization)", "Describes the details of the manufacturer of the medication product.  This is not intended to represent the distributor of a medication product.", 0, 1, this.manufacturer));
        children.add(new Property("doseForm", "CodeableConcept", "Describes the form of the item.  Powder; tablets; capsule.", 0, 1, this.doseForm));
        children.add(new Property("amount", "Quantity", "Specific amount of the drug in the packaged product.  For example, when specifying a product that has the same strength (For example, Insulin glargine 100 unit per mL solution for injection), this attribute provides additional clarification of the package amount (For example, 3 mL, 10mL, etc.).", 0, 1, this.amount));
        children.add(new Property("synonym", "string", "Additional names for a medication, for example, the name(s) given to a medication in different countries.  For example, acetaminophen and paracetamol or salbutamol and albuterol.", 0, Integer.MAX_VALUE, this.synonym));
        children.add(new Property("relatedMedicationKnowledge", "", "Associated or related knowledge about a medication.", 0, Integer.MAX_VALUE, this.relatedMedicationKnowledge));
        children.add(new Property("associatedMedication", "Reference(Medication)", "Associated or related medications.  For example, if the medication is a branded product (e.g. Crestor), this is the Therapeutic Moeity (e.g. Rosuvastatin) or if this is a generic medication (e.g. Rosuvastatin), this would link to a branded product (e.g. Crestor).", 0, Integer.MAX_VALUE, this.associatedMedication));
        children.add(new Property("productType", "CodeableConcept", "Category of the medication or product (e.g. branded product, therapeutic moeity, generic product, innovator product, etc.).", 0, Integer.MAX_VALUE, this.productType));
        children.add(new Property(SP_MONOGRAPH, "", "Associated documentation about the medication.", 0, Integer.MAX_VALUE, this.monograph));
        children.add(new Property(SP_INGREDIENT, "", "Identifies a particular constituent of interest in the product.", 0, Integer.MAX_VALUE, this.ingredient));
        children.add(new Property("preparationInstruction", "markdown", "The instructions for preparing the medication.", 0, 1, this.preparationInstruction));
        children.add(new Property("intendedRoute", "CodeableConcept", "The intended or approved route of administration.", 0, Integer.MAX_VALUE, this.intendedRoute));
        children.add(new Property("cost", "", "The price of the medication.", 0, Integer.MAX_VALUE, this.cost));
        children.add(new Property("monitoringProgram", "", "The program under which the medication is reviewed.", 0, Integer.MAX_VALUE, this.monitoringProgram));
        children.add(new Property("administrationGuidelines", "", "Guidelines for the administration of the medication.", 0, Integer.MAX_VALUE, this.administrationGuidelines));
        children.add(new Property("medicineClassification", "", "Categorization of the medication within a formulary or classification system.", 0, Integer.MAX_VALUE, this.medicineClassification));
        children.add(new Property("packaging", "", "Information that only applies to packages (not products).", 0, 1, this.packaging));
        children.add(new Property("drugCharacteristic", "", "Specifies descriptive properties of the medicine, such as color, shape, imprints, etc.", 0, Integer.MAX_VALUE, this.drugCharacteristic));
        children.add(new Property("contraindication", "Reference(DetectedIssue)", "Potential clinical issue with or between medication(s) (for example, drug-drug interaction, drug-disease contraindication, drug-allergy interaction, etc.).", 0, Integer.MAX_VALUE, this.contraindication));
        children.add(new Property("regulatory", "", "Regulatory information about a medication.", 0, Integer.MAX_VALUE, this.regulatory));
        children.add(new Property("kinetics", "", "The time course of drug absorption, distribution, metabolism and excretion of a medication from the body.", 0, Integer.MAX_VALUE, this.kinetics));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "A code that specifies this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.", 0, 1, this.code);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code to indicate if the medication is in active use.  The status refers to the validity about the information of the medication and not to its medicinal properties.", 0, 1, this.status);
            }
            case -1969347631: {
                return new Property(SP_MANUFACTURER, "Reference(Organization)", "Describes the details of the manufacturer of the medication product.  This is not intended to represent the distributor of a medication product.", 0, 1, this.manufacturer);
            }
            case 1303858817: {
                return new Property("doseForm", "CodeableConcept", "Describes the form of the item.  Powder; tablets; capsule.", 0, 1, this.doseForm);
            }
            case -1413853096: {
                return new Property("amount", "Quantity", "Specific amount of the drug in the packaged product.  For example, when specifying a product that has the same strength (For example, Insulin glargine 100 unit per mL solution for injection), this attribute provides additional clarification of the package amount (For example, 3 mL, 10mL, etc.).", 0, 1, this.amount);
            }
            case -1742128133: {
                return new Property("synonym", "string", "Additional names for a medication, for example, the name(s) given to a medication in different countries.  For example, acetaminophen and paracetamol or salbutamol and albuterol.", 0, Integer.MAX_VALUE, this.synonym);
            }
            case 723067972: {
                return new Property("relatedMedicationKnowledge", "", "Associated or related knowledge about a medication.", 0, Integer.MAX_VALUE, this.relatedMedicationKnowledge);
            }
            case 1312779381: {
                return new Property("associatedMedication", "Reference(Medication)", "Associated or related medications.  For example, if the medication is a branded product (e.g. Crestor), this is the Therapeutic Moeity (e.g. Rosuvastatin) or if this is a generic medication (e.g. Rosuvastatin), this would link to a branded product (e.g. Crestor).", 0, Integer.MAX_VALUE, this.associatedMedication);
            }
            case -1491615543: {
                return new Property("productType", "CodeableConcept", "Category of the medication or product (e.g. branded product, therapeutic moeity, generic product, innovator product, etc.).", 0, Integer.MAX_VALUE, this.productType);
            }
            case -1442980789: {
                return new Property(SP_MONOGRAPH, "", "Associated documentation about the medication.", 0, Integer.MAX_VALUE, this.monograph);
            }
            case -206409263: {
                return new Property(SP_INGREDIENT, "", "Identifies a particular constituent of interest in the product.", 0, Integer.MAX_VALUE, this.ingredient);
            }
            case 1025456503: {
                return new Property("preparationInstruction", "markdown", "The instructions for preparing the medication.", 0, 1, this.preparationInstruction);
            }
            case -767798050: {
                return new Property("intendedRoute", "CodeableConcept", "The intended or approved route of administration.", 0, Integer.MAX_VALUE, this.intendedRoute);
            }
            case 3059661: {
                return new Property("cost", "", "The price of the medication.", 0, Integer.MAX_VALUE, this.cost);
            }
            case 569848092: {
                return new Property("monitoringProgram", "", "The program under which the medication is reviewed.", 0, Integer.MAX_VALUE, this.monitoringProgram);
            }
            case 496930945: {
                return new Property("administrationGuidelines", "", "Guidelines for the administration of the medication.", 0, Integer.MAX_VALUE, this.administrationGuidelines);
            }
            case 1791551680: {
                return new Property("medicineClassification", "", "Categorization of the medication within a formulary or classification system.", 0, Integer.MAX_VALUE, this.medicineClassification);
            }
            case 1802065795: {
                return new Property("packaging", "", "Information that only applies to packages (not products).", 0, 1, this.packaging);
            }
            case -844126885: {
                return new Property("drugCharacteristic", "", "Specifies descriptive properties of the medicine, such as color, shape, imprints, etc.", 0, Integer.MAX_VALUE, this.drugCharacteristic);
            }
            case 107135229: {
                return new Property("contraindication", "Reference(DetectedIssue)", "Potential clinical issue with or between medication(s) (for example, drug-drug interaction, drug-disease contraindication, drug-allergy interaction, etc.).", 0, Integer.MAX_VALUE, this.contraindication);
            }
            case -27327848: {
                return new Property("regulatory", "", "Regulatory information about a medication.", 0, Integer.MAX_VALUE, this.regulatory);
            }
            case -553207110: {
                return new Property("kinetics", "", "The time course of drug absorption, distribution, metabolism and excretion of a medication from the body.", 0, Integer.MAX_VALUE, this.kinetics);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.code;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -1969347631: {
                Base[] baseArray;
                if (this.manufacturer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.manufacturer;
                }
                return baseArray;
            }
            case 1303858817: {
                Base[] baseArray;
                if (this.doseForm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.doseForm;
                }
                return baseArray;
            }
            case -1413853096: {
                Base[] baseArray;
                if (this.amount == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.amount;
                }
                return baseArray;
            }
            case -1742128133: {
                return this.synonym == null ? new Base[]{} : this.synonym.toArray(new Base[this.synonym.size()]);
            }
            case 723067972: {
                return this.relatedMedicationKnowledge == null ? new Base[]{} : this.relatedMedicationKnowledge.toArray(new Base[this.relatedMedicationKnowledge.size()]);
            }
            case 1312779381: {
                return this.associatedMedication == null ? new Base[]{} : this.associatedMedication.toArray(new Base[this.associatedMedication.size()]);
            }
            case -1491615543: {
                return this.productType == null ? new Base[]{} : this.productType.toArray(new Base[this.productType.size()]);
            }
            case -1442980789: {
                return this.monograph == null ? new Base[]{} : this.monograph.toArray(new Base[this.monograph.size()]);
            }
            case -206409263: {
                return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
            }
            case 1025456503: {
                Base[] baseArray;
                if (this.preparationInstruction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.preparationInstruction;
                }
                return baseArray;
            }
            case -767798050: {
                return this.intendedRoute == null ? new Base[]{} : this.intendedRoute.toArray(new Base[this.intendedRoute.size()]);
            }
            case 3059661: {
                return this.cost == null ? new Base[]{} : this.cost.toArray(new Base[this.cost.size()]);
            }
            case 569848092: {
                return this.monitoringProgram == null ? new Base[]{} : this.monitoringProgram.toArray(new Base[this.monitoringProgram.size()]);
            }
            case 496930945: {
                return this.administrationGuidelines == null ? new Base[]{} : this.administrationGuidelines.toArray(new Base[this.administrationGuidelines.size()]);
            }
            case 1791551680: {
                return this.medicineClassification == null ? new Base[]{} : this.medicineClassification.toArray(new Base[this.medicineClassification.size()]);
            }
            case 1802065795: {
                Base[] baseArray;
                if (this.packaging == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.packaging;
                }
                return baseArray;
            }
            case -844126885: {
                return this.drugCharacteristic == null ? new Base[]{} : this.drugCharacteristic.toArray(new Base[this.drugCharacteristic.size()]);
            }
            case 107135229: {
                return this.contraindication == null ? new Base[]{} : this.contraindication.toArray(new Base[this.contraindication.size()]);
            }
            case -27327848: {
                return this.regulatory == null ? new Base[]{} : this.regulatory.toArray(new Base[this.regulatory.size()]);
            }
            case -553207110: {
                return this.kinetics == null ? new Base[]{} : this.kinetics.toArray(new Base[this.kinetics.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -892481550: {
                value = new MedicationKnowledgeStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1969347631: {
                this.manufacturer = TypeConvertor.castToReference(value);
                return value;
            }
            case 1303858817: {
                this.doseForm = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1413853096: {
                this.amount = TypeConvertor.castToQuantity(value);
                return value;
            }
            case -1742128133: {
                this.getSynonym().add(TypeConvertor.castToString(value));
                return value;
            }
            case 723067972: {
                this.getRelatedMedicationKnowledge().add((MedicationKnowledgeRelatedMedicationKnowledgeComponent)((Object)value));
                return value;
            }
            case 1312779381: {
                this.getAssociatedMedication().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1491615543: {
                this.getProductType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1442980789: {
                this.getMonograph().add((MedicationKnowledgeMonographComponent)((Object)value));
                return value;
            }
            case -206409263: {
                this.getIngredient().add((MedicationKnowledgeIngredientComponent)((Object)value));
                return value;
            }
            case 1025456503: {
                this.preparationInstruction = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -767798050: {
                this.getIntendedRoute().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059661: {
                this.getCost().add((MedicationKnowledgeCostComponent)((Object)value));
                return value;
            }
            case 569848092: {
                this.getMonitoringProgram().add((MedicationKnowledgeMonitoringProgramComponent)((Object)value));
                return value;
            }
            case 496930945: {
                this.getAdministrationGuidelines().add((MedicationKnowledgeAdministrationGuidelinesComponent)((Object)value));
                return value;
            }
            case 1791551680: {
                this.getMedicineClassification().add((MedicationKnowledgeMedicineClassificationComponent)((Object)value));
                return value;
            }
            case 1802065795: {
                this.packaging = (MedicationKnowledgePackagingComponent)((Object)value);
                return value;
            }
            case -844126885: {
                this.getDrugCharacteristic().add((MedicationKnowledgeDrugCharacteristicComponent)((Object)value));
                return value;
            }
            case 107135229: {
                this.getContraindication().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -27327848: {
                this.getRegulatory().add((MedicationKnowledgeRegulatoryComponent)((Object)value));
                return value;
            }
            case -553207110: {
                this.getKinetics().add((MedicationKnowledgeKineticsComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_STATUS)) {
            value = new MedicationKnowledgeStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = TypeConvertor.castToReference(value);
        } else if (name.equals("doseForm")) {
            this.doseForm = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("amount")) {
            this.amount = TypeConvertor.castToQuantity(value);
        } else if (name.equals("synonym")) {
            this.getSynonym().add(TypeConvertor.castToString(value));
        } else if (name.equals("relatedMedicationKnowledge")) {
            this.getRelatedMedicationKnowledge().add((MedicationKnowledgeRelatedMedicationKnowledgeComponent)((Object)value));
        } else if (name.equals("associatedMedication")) {
            this.getAssociatedMedication().add(TypeConvertor.castToReference(value));
        } else if (name.equals("productType")) {
            this.getProductType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_MONOGRAPH)) {
            this.getMonograph().add((MedicationKnowledgeMonographComponent)((Object)value));
        } else if (name.equals(SP_INGREDIENT)) {
            this.getIngredient().add((MedicationKnowledgeIngredientComponent)((Object)value));
        } else if (name.equals("preparationInstruction")) {
            this.preparationInstruction = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("intendedRoute")) {
            this.getIntendedRoute().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("cost")) {
            this.getCost().add((MedicationKnowledgeCostComponent)((Object)value));
        } else if (name.equals("monitoringProgram")) {
            this.getMonitoringProgram().add((MedicationKnowledgeMonitoringProgramComponent)((Object)value));
        } else if (name.equals("administrationGuidelines")) {
            this.getAdministrationGuidelines().add((MedicationKnowledgeAdministrationGuidelinesComponent)((Object)value));
        } else if (name.equals("medicineClassification")) {
            this.getMedicineClassification().add((MedicationKnowledgeMedicineClassificationComponent)((Object)value));
        } else if (name.equals("packaging")) {
            this.packaging = (MedicationKnowledgePackagingComponent)((Object)value);
        } else if (name.equals("drugCharacteristic")) {
            this.getDrugCharacteristic().add((MedicationKnowledgeDrugCharacteristicComponent)((Object)value));
        } else if (name.equals("contraindication")) {
            this.getContraindication().add(TypeConvertor.castToReference(value));
        } else if (name.equals("regulatory")) {
            this.getRegulatory().add((MedicationKnowledgeRegulatoryComponent)((Object)value));
        } else if (name.equals("kinetics")) {
            this.getKinetics().add((MedicationKnowledgeKineticsComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3059181: {
                return this.getCode();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1969347631: {
                return this.getManufacturer();
            }
            case 1303858817: {
                return this.getDoseForm();
            }
            case -1413853096: {
                return this.getAmount();
            }
            case -1742128133: {
                return this.addSynonymElement();
            }
            case 723067972: {
                return this.addRelatedMedicationKnowledge();
            }
            case 1312779381: {
                return this.addAssociatedMedication();
            }
            case -1491615543: {
                return this.addProductType();
            }
            case -1442980789: {
                return this.addMonograph();
            }
            case -206409263: {
                return this.addIngredient();
            }
            case 1025456503: {
                return this.getPreparationInstructionElement();
            }
            case -767798050: {
                return this.addIntendedRoute();
            }
            case 3059661: {
                return this.addCost();
            }
            case 569848092: {
                return this.addMonitoringProgram();
            }
            case 496930945: {
                return this.addAdministrationGuidelines();
            }
            case 1791551680: {
                return this.addMedicineClassification();
            }
            case 1802065795: {
                return this.getPackaging();
            }
            case -844126885: {
                return this.addDrugCharacteristic();
            }
            case 107135229: {
                return this.addContraindication();
            }
            case -27327848: {
                return this.addRegulatory();
            }
            case -553207110: {
                return this.addKinetics();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case 1303858817: {
                return new String[]{"CodeableConcept"};
            }
            case -1413853096: {
                return new String[]{"Quantity"};
            }
            case -1742128133: {
                return new String[]{"string"};
            }
            case 723067972: {
                return new String[0];
            }
            case 1312779381: {
                return new String[]{"Reference"};
            }
            case -1491615543: {
                return new String[]{"CodeableConcept"};
            }
            case -1442980789: {
                return new String[0];
            }
            case -206409263: {
                return new String[0];
            }
            case 1025456503: {
                return new String[]{"markdown"};
            }
            case -767798050: {
                return new String[]{"CodeableConcept"};
            }
            case 3059661: {
                return new String[0];
            }
            case 569848092: {
                return new String[0];
            }
            case 496930945: {
                return new String[0];
            }
            case 1791551680: {
                return new String[0];
            }
            case 1802065795: {
                return new String[0];
            }
            case -844126885: {
                return new String[0];
            }
            case 107135229: {
                return new String[]{"Reference"};
            }
            case -27327848: {
                return new String[0];
            }
            case -553207110: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.status");
        }
        if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = new Reference();
            return this.manufacturer;
        }
        if (name.equals("doseForm")) {
            this.doseForm = new CodeableConcept();
            return this.doseForm;
        }
        if (name.equals("amount")) {
            this.amount = new Quantity();
            return this.amount;
        }
        if (name.equals("synonym")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.synonym");
        }
        if (name.equals("relatedMedicationKnowledge")) {
            return this.addRelatedMedicationKnowledge();
        }
        if (name.equals("associatedMedication")) {
            return this.addAssociatedMedication();
        }
        if (name.equals("productType")) {
            return this.addProductType();
        }
        if (name.equals(SP_MONOGRAPH)) {
            return this.addMonograph();
        }
        if (name.equals(SP_INGREDIENT)) {
            return this.addIngredient();
        }
        if (name.equals("preparationInstruction")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.preparationInstruction");
        }
        if (name.equals("intendedRoute")) {
            return this.addIntendedRoute();
        }
        if (name.equals("cost")) {
            return this.addCost();
        }
        if (name.equals("monitoringProgram")) {
            return this.addMonitoringProgram();
        }
        if (name.equals("administrationGuidelines")) {
            return this.addAdministrationGuidelines();
        }
        if (name.equals("medicineClassification")) {
            return this.addMedicineClassification();
        }
        if (name.equals("packaging")) {
            this.packaging = new MedicationKnowledgePackagingComponent();
            return this.packaging;
        }
        if (name.equals("drugCharacteristic")) {
            return this.addDrugCharacteristic();
        }
        if (name.equals("contraindication")) {
            return this.addContraindication();
        }
        if (name.equals("regulatory")) {
            return this.addRegulatory();
        }
        if (name.equals("kinetics")) {
            return this.addKinetics();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicationKnowledge";
    }

    @Override
    public MedicationKnowledge copy() {
        MedicationKnowledge dst = new MedicationKnowledge();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MedicationKnowledge dst) {
        super.copyValues(dst);
        dst.code = this.code == null ? null : this.code.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        dst.doseForm = this.doseForm == null ? null : this.doseForm.copy();
        Quantity quantity = dst.amount = this.amount == null ? null : this.amount.copy();
        if (this.synonym != null) {
            dst.synonym = new ArrayList<StringType>();
            for (StringType stringType : this.synonym) {
                dst.synonym.add(stringType.copy());
            }
        }
        if (this.relatedMedicationKnowledge != null) {
            dst.relatedMedicationKnowledge = new ArrayList<MedicationKnowledgeRelatedMedicationKnowledgeComponent>();
            for (MedicationKnowledgeRelatedMedicationKnowledgeComponent medicationKnowledgeRelatedMedicationKnowledgeComponent : this.relatedMedicationKnowledge) {
                dst.relatedMedicationKnowledge.add(medicationKnowledgeRelatedMedicationKnowledgeComponent.copy());
            }
        }
        if (this.associatedMedication != null) {
            dst.associatedMedication = new ArrayList<Reference>();
            for (Reference reference : this.associatedMedication) {
                dst.associatedMedication.add(reference.copy());
            }
        }
        if (this.productType != null) {
            dst.productType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.productType) {
                dst.productType.add(codeableConcept.copy());
            }
        }
        if (this.monograph != null) {
            dst.monograph = new ArrayList<MedicationKnowledgeMonographComponent>();
            for (MedicationKnowledgeMonographComponent medicationKnowledgeMonographComponent : this.monograph) {
                dst.monograph.add(medicationKnowledgeMonographComponent.copy());
            }
        }
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<MedicationKnowledgeIngredientComponent>();
            for (MedicationKnowledgeIngredientComponent medicationKnowledgeIngredientComponent : this.ingredient) {
                dst.ingredient.add(medicationKnowledgeIngredientComponent.copy());
            }
        }
        MarkdownType markdownType = dst.preparationInstruction = this.preparationInstruction == null ? null : this.preparationInstruction.copy();
        if (this.intendedRoute != null) {
            dst.intendedRoute = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.intendedRoute) {
                dst.intendedRoute.add(codeableConcept.copy());
            }
        }
        if (this.cost != null) {
            dst.cost = new ArrayList<MedicationKnowledgeCostComponent>();
            for (MedicationKnowledgeCostComponent medicationKnowledgeCostComponent : this.cost) {
                dst.cost.add(medicationKnowledgeCostComponent.copy());
            }
        }
        if (this.monitoringProgram != null) {
            dst.monitoringProgram = new ArrayList<MedicationKnowledgeMonitoringProgramComponent>();
            for (MedicationKnowledgeMonitoringProgramComponent medicationKnowledgeMonitoringProgramComponent : this.monitoringProgram) {
                dst.monitoringProgram.add(medicationKnowledgeMonitoringProgramComponent.copy());
            }
        }
        if (this.administrationGuidelines != null) {
            dst.administrationGuidelines = new ArrayList<MedicationKnowledgeAdministrationGuidelinesComponent>();
            for (MedicationKnowledgeAdministrationGuidelinesComponent medicationKnowledgeAdministrationGuidelinesComponent : this.administrationGuidelines) {
                dst.administrationGuidelines.add(medicationKnowledgeAdministrationGuidelinesComponent.copy());
            }
        }
        if (this.medicineClassification != null) {
            dst.medicineClassification = new ArrayList<MedicationKnowledgeMedicineClassificationComponent>();
            for (MedicationKnowledgeMedicineClassificationComponent medicationKnowledgeMedicineClassificationComponent : this.medicineClassification) {
                dst.medicineClassification.add(medicationKnowledgeMedicineClassificationComponent.copy());
            }
        }
        MedicationKnowledgePackagingComponent medicationKnowledgePackagingComponent = dst.packaging = this.packaging == null ? null : this.packaging.copy();
        if (this.drugCharacteristic != null) {
            dst.drugCharacteristic = new ArrayList<MedicationKnowledgeDrugCharacteristicComponent>();
            for (MedicationKnowledgeDrugCharacteristicComponent medicationKnowledgeDrugCharacteristicComponent : this.drugCharacteristic) {
                dst.drugCharacteristic.add(medicationKnowledgeDrugCharacteristicComponent.copy());
            }
        }
        if (this.contraindication != null) {
            dst.contraindication = new ArrayList<Reference>();
            for (Reference reference : this.contraindication) {
                dst.contraindication.add(reference.copy());
            }
        }
        if (this.regulatory != null) {
            dst.regulatory = new ArrayList<MedicationKnowledgeRegulatoryComponent>();
            for (MedicationKnowledgeRegulatoryComponent medicationKnowledgeRegulatoryComponent : this.regulatory) {
                dst.regulatory.add(medicationKnowledgeRegulatoryComponent.copy());
            }
        }
        if (this.kinetics != null) {
            dst.kinetics = new ArrayList<MedicationKnowledgeKineticsComponent>();
            for (MedicationKnowledgeKineticsComponent medicationKnowledgeKineticsComponent : this.kinetics) {
                dst.kinetics.add(medicationKnowledgeKineticsComponent.copy());
            }
        }
    }

    protected MedicationKnowledge typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationKnowledge)) {
            return false;
        }
        MedicationKnowledge o = (MedicationKnowledge)other_;
        return MedicationKnowledge.compareDeep(this.code, o.code, true) && MedicationKnowledge.compareDeep(this.status, o.status, true) && MedicationKnowledge.compareDeep(this.manufacturer, o.manufacturer, true) && MedicationKnowledge.compareDeep(this.doseForm, o.doseForm, true) && MedicationKnowledge.compareDeep(this.amount, o.amount, true) && MedicationKnowledge.compareDeep(this.synonym, o.synonym, true) && MedicationKnowledge.compareDeep(this.relatedMedicationKnowledge, o.relatedMedicationKnowledge, true) && MedicationKnowledge.compareDeep(this.associatedMedication, o.associatedMedication, true) && MedicationKnowledge.compareDeep(this.productType, o.productType, true) && MedicationKnowledge.compareDeep(this.monograph, o.monograph, true) && MedicationKnowledge.compareDeep(this.ingredient, o.ingredient, true) && MedicationKnowledge.compareDeep(this.preparationInstruction, o.preparationInstruction, true) && MedicationKnowledge.compareDeep(this.intendedRoute, o.intendedRoute, true) && MedicationKnowledge.compareDeep(this.cost, o.cost, true) && MedicationKnowledge.compareDeep(this.monitoringProgram, o.monitoringProgram, true) && MedicationKnowledge.compareDeep(this.administrationGuidelines, o.administrationGuidelines, true) && MedicationKnowledge.compareDeep(this.medicineClassification, o.medicineClassification, true) && MedicationKnowledge.compareDeep(this.packaging, o.packaging, true) && MedicationKnowledge.compareDeep(this.drugCharacteristic, o.drugCharacteristic, true) && MedicationKnowledge.compareDeep(this.contraindication, o.contraindication, true) && MedicationKnowledge.compareDeep(this.regulatory, o.regulatory, true) && MedicationKnowledge.compareDeep(this.kinetics, o.kinetics, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationKnowledge)) {
            return false;
        }
        MedicationKnowledge o = (MedicationKnowledge)other_;
        return MedicationKnowledge.compareValues(this.status, o.status, true) && MedicationKnowledge.compareValues(this.synonym, o.synonym, true) && MedicationKnowledge.compareValues(this.preparationInstruction, o.preparationInstruction, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.status, this.manufacturer, this.doseForm, this.amount, this.synonym, this.relatedMedicationKnowledge, this.associatedMedication, this.productType, this.monograph, this.ingredient, this.preparationInstruction, this.intendedRoute, this.cost, this.monitoringProgram, this.administrationGuidelines, this.medicineClassification, this.packaging, this.drugCharacteristic, this.contraindication, this.regulatory, this.kinetics});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationKnowledge;
    }

    @Block
    public static class MedicationKnowledgeKineticsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="areaUnderCurve", type={Quantity.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The drug concentration measured at certain discrete points in time", formalDefinition="The drug concentration measured at certain discrete points in time.")
        protected List<Quantity> areaUnderCurve;
        @Child(name="lethalDose50", type={Quantity.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The median lethal dose of a drug", formalDefinition="The median lethal dose of a drug.")
        protected List<Quantity> lethalDose50;
        @Child(name="halfLifePeriod", type={Duration.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time required for concentration in the body to decrease by half", formalDefinition="The time required for any specified property (e.g., the concentration of a substance in the body) to decrease by half.")
        protected Duration halfLifePeriod;
        private static final long serialVersionUID = -206244264L;

        public List<Quantity> getAreaUnderCurve() {
            if (this.areaUnderCurve == null) {
                this.areaUnderCurve = new ArrayList<Quantity>();
            }
            return this.areaUnderCurve;
        }

        public MedicationKnowledgeKineticsComponent setAreaUnderCurve(List<Quantity> theAreaUnderCurve) {
            this.areaUnderCurve = theAreaUnderCurve;
            return this;
        }

        public boolean hasAreaUnderCurve() {
            if (this.areaUnderCurve == null) {
                return false;
            }
            for (Quantity item : this.areaUnderCurve) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Quantity addAreaUnderCurve() {
            Quantity t = new Quantity();
            if (this.areaUnderCurve == null) {
                this.areaUnderCurve = new ArrayList<Quantity>();
            }
            this.areaUnderCurve.add(t);
            return t;
        }

        public MedicationKnowledgeKineticsComponent addAreaUnderCurve(Quantity t) {
            if (t == null) {
                return this;
            }
            if (this.areaUnderCurve == null) {
                this.areaUnderCurve = new ArrayList<Quantity>();
            }
            this.areaUnderCurve.add(t);
            return this;
        }

        public Quantity getAreaUnderCurveFirstRep() {
            if (this.getAreaUnderCurve().isEmpty()) {
                this.addAreaUnderCurve();
            }
            return this.getAreaUnderCurve().get(0);
        }

        public List<Quantity> getLethalDose50() {
            if (this.lethalDose50 == null) {
                this.lethalDose50 = new ArrayList<Quantity>();
            }
            return this.lethalDose50;
        }

        public MedicationKnowledgeKineticsComponent setLethalDose50(List<Quantity> theLethalDose50) {
            this.lethalDose50 = theLethalDose50;
            return this;
        }

        public boolean hasLethalDose50() {
            if (this.lethalDose50 == null) {
                return false;
            }
            for (Quantity item : this.lethalDose50) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Quantity addLethalDose50() {
            Quantity t = new Quantity();
            if (this.lethalDose50 == null) {
                this.lethalDose50 = new ArrayList<Quantity>();
            }
            this.lethalDose50.add(t);
            return t;
        }

        public MedicationKnowledgeKineticsComponent addLethalDose50(Quantity t) {
            if (t == null) {
                return this;
            }
            if (this.lethalDose50 == null) {
                this.lethalDose50 = new ArrayList<Quantity>();
            }
            this.lethalDose50.add(t);
            return this;
        }

        public Quantity getLethalDose50FirstRep() {
            if (this.getLethalDose50().isEmpty()) {
                this.addLethalDose50();
            }
            return this.getLethalDose50().get(0);
        }

        public Duration getHalfLifePeriod() {
            if (this.halfLifePeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeKineticsComponent.halfLifePeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.halfLifePeriod = new Duration();
                }
            }
            return this.halfLifePeriod;
        }

        public boolean hasHalfLifePeriod() {
            return this.halfLifePeriod != null && !this.halfLifePeriod.isEmpty();
        }

        public MedicationKnowledgeKineticsComponent setHalfLifePeriod(Duration value) {
            this.halfLifePeriod = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("areaUnderCurve", "Quantity", "The drug concentration measured at certain discrete points in time.", 0, Integer.MAX_VALUE, this.areaUnderCurve));
            children.add(new Property("lethalDose50", "Quantity", "The median lethal dose of a drug.", 0, Integer.MAX_VALUE, this.lethalDose50));
            children.add(new Property("halfLifePeriod", "Duration", "The time required for any specified property (e.g., the concentration of a substance in the body) to decrease by half.", 0, 1, this.halfLifePeriod));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1243936100: {
                    return new Property("areaUnderCurve", "Quantity", "The drug concentration measured at certain discrete points in time.", 0, Integer.MAX_VALUE, this.areaUnderCurve);
                }
                case 302983216: {
                    return new Property("lethalDose50", "Quantity", "The median lethal dose of a drug.", 0, Integer.MAX_VALUE, this.lethalDose50);
                }
                case -628810640: {
                    return new Property("halfLifePeriod", "Duration", "The time required for any specified property (e.g., the concentration of a substance in the body) to decrease by half.", 0, 1, this.halfLifePeriod);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1243936100: {
                    return this.areaUnderCurve == null ? new Base[]{} : this.areaUnderCurve.toArray(new Base[this.areaUnderCurve.size()]);
                }
                case 302983216: {
                    return this.lethalDose50 == null ? new Base[]{} : this.lethalDose50.toArray(new Base[this.lethalDose50.size()]);
                }
                case -628810640: {
                    Base[] baseArray;
                    if (this.halfLifePeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.halfLifePeriod;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1243936100: {
                    this.getAreaUnderCurve().add(TypeConvertor.castToQuantity(value));
                    return value;
                }
                case 302983216: {
                    this.getLethalDose50().add(TypeConvertor.castToQuantity(value));
                    return value;
                }
                case -628810640: {
                    this.halfLifePeriod = TypeConvertor.castToDuration(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("areaUnderCurve")) {
                this.getAreaUnderCurve().add(TypeConvertor.castToQuantity(value));
            } else if (name.equals("lethalDose50")) {
                this.getLethalDose50().add(TypeConvertor.castToQuantity(value));
            } else if (name.equals("halfLifePeriod")) {
                this.halfLifePeriod = TypeConvertor.castToDuration(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1243936100: {
                    return this.addAreaUnderCurve();
                }
                case 302983216: {
                    return this.addLethalDose50();
                }
                case -628810640: {
                    return this.getHalfLifePeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1243936100: {
                    return new String[]{"Quantity"};
                }
                case 302983216: {
                    return new String[]{"Quantity"};
                }
                case -628810640: {
                    return new String[]{"Duration"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("areaUnderCurve")) {
                return this.addAreaUnderCurve();
            }
            if (name.equals("lethalDose50")) {
                return this.addLethalDose50();
            }
            if (name.equals("halfLifePeriod")) {
                this.halfLifePeriod = new Duration();
                return this.halfLifePeriod;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeKineticsComponent copy() {
            MedicationKnowledgeKineticsComponent dst = new MedicationKnowledgeKineticsComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeKineticsComponent dst) {
            super.copyValues(dst);
            if (this.areaUnderCurve != null) {
                dst.areaUnderCurve = new ArrayList<Quantity>();
                for (Quantity i : this.areaUnderCurve) {
                    dst.areaUnderCurve.add(i.copy());
                }
            }
            if (this.lethalDose50 != null) {
                dst.lethalDose50 = new ArrayList<Quantity>();
                for (Quantity i : this.lethalDose50) {
                    dst.lethalDose50.add(i.copy());
                }
            }
            dst.halfLifePeriod = this.halfLifePeriod == null ? null : this.halfLifePeriod.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeKineticsComponent)) {
                return false;
            }
            MedicationKnowledgeKineticsComponent o = (MedicationKnowledgeKineticsComponent)other_;
            return MedicationKnowledgeKineticsComponent.compareDeep(this.areaUnderCurve, o.areaUnderCurve, true) && MedicationKnowledgeKineticsComponent.compareDeep(this.lethalDose50, o.lethalDose50, true) && MedicationKnowledgeKineticsComponent.compareDeep(this.halfLifePeriod, o.halfLifePeriod, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeKineticsComponent)) {
                return false;
            }
            MedicationKnowledgeKineticsComponent o = (MedicationKnowledgeKineticsComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.areaUnderCurve, this.lethalDose50, this.halfLifePeriod});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.kinetics";
        }
    }

    @Block
    public static class MedicationKnowledgeRegulatoryMaxDispenseComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="quantity", type={Quantity.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The maximum number of units of the medication that can be dispensed", formalDefinition="The maximum number of units of the medication that can be dispensed.")
        protected Quantity quantity;
        @Child(name="period", type={Duration.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The period that applies to the maximum number of units", formalDefinition="The period that applies to the maximum number of units.")
        protected Duration period;
        private static final long serialVersionUID = -441724185L;

        public MedicationKnowledgeRegulatoryMaxDispenseComponent() {
        }

        public MedicationKnowledgeRegulatoryMaxDispenseComponent(Quantity quantity) {
            this.setQuantity(quantity);
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatoryMaxDispenseComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public MedicationKnowledgeRegulatoryMaxDispenseComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Duration getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatoryMaxDispenseComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Duration();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public MedicationKnowledgeRegulatoryMaxDispenseComponent setPeriod(Duration value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("quantity", "Quantity", "The maximum number of units of the medication that can be dispensed.", 0, 1, this.quantity));
            children.add(new Property("period", "Duration", "The period that applies to the maximum number of units.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The maximum number of units of the medication that can be dispensed.", 0, 1, this.quantity);
                }
                case -991726143: {
                    return new Property("period", "Duration", "The period that applies to the maximum number of units.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToDuration(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToDuration(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return this.getQuantity();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case -991726143: {
                    return new String[]{"Duration"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("period")) {
                this.period = new Duration();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeRegulatoryMaxDispenseComponent copy() {
            MedicationKnowledgeRegulatoryMaxDispenseComponent dst = new MedicationKnowledgeRegulatoryMaxDispenseComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeRegulatoryMaxDispenseComponent dst) {
            super.copyValues(dst);
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatoryMaxDispenseComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatoryMaxDispenseComponent o = (MedicationKnowledgeRegulatoryMaxDispenseComponent)other_;
            return MedicationKnowledgeRegulatoryMaxDispenseComponent.compareDeep(this.quantity, o.quantity, true) && MedicationKnowledgeRegulatoryMaxDispenseComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatoryMaxDispenseComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatoryMaxDispenseComponent o = (MedicationKnowledgeRegulatoryMaxDispenseComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.quantity, this.period});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.regulatory.maxDispense";
        }
    }

    @Block
    public static class MedicationKnowledgeRegulatoryScheduleComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="schedule", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies the specific drug schedule", formalDefinition="Specifies the specific drug schedule.")
        protected CodeableConcept schedule;
        private static final long serialVersionUID = 1955520912L;

        public MedicationKnowledgeRegulatoryScheduleComponent() {
        }

        public MedicationKnowledgeRegulatoryScheduleComponent(CodeableConcept schedule) {
            this.setSchedule(schedule);
        }

        public CodeableConcept getSchedule() {
            if (this.schedule == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatoryScheduleComponent.schedule");
                }
                if (Configuration.doAutoCreate()) {
                    this.schedule = new CodeableConcept();
                }
            }
            return this.schedule;
        }

        public boolean hasSchedule() {
            return this.schedule != null && !this.schedule.isEmpty();
        }

        public MedicationKnowledgeRegulatoryScheduleComponent setSchedule(CodeableConcept value) {
            this.schedule = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("schedule", "CodeableConcept", "Specifies the specific drug schedule.", 0, 1, this.schedule));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -697920873: {
                    return new Property("schedule", "CodeableConcept", "Specifies the specific drug schedule.", 0, 1, this.schedule);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -697920873: {
                    Base[] baseArray;
                    if (this.schedule == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.schedule;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -697920873: {
                    this.schedule = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("schedule")) {
                return super.setProperty(name, value);
            }
            this.schedule = TypeConvertor.castToCodeableConcept(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -697920873: {
                    return this.getSchedule();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -697920873: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("schedule")) {
                this.schedule = new CodeableConcept();
                return this.schedule;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeRegulatoryScheduleComponent copy() {
            MedicationKnowledgeRegulatoryScheduleComponent dst = new MedicationKnowledgeRegulatoryScheduleComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeRegulatoryScheduleComponent dst) {
            super.copyValues(dst);
            dst.schedule = this.schedule == null ? null : this.schedule.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatoryScheduleComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatoryScheduleComponent o = (MedicationKnowledgeRegulatoryScheduleComponent)other_;
            return MedicationKnowledgeRegulatoryScheduleComponent.compareDeep(this.schedule, o.schedule, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatoryScheduleComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatoryScheduleComponent o = (MedicationKnowledgeRegulatoryScheduleComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.schedule});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.regulatory.schedule";
        }
    }

    @Block
    public static class MedicationKnowledgeRegulatorySubstitutionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies the type of substitution allowed", formalDefinition="Specifies the type of substitution allowed.")
        protected CodeableConcept type;
        @Child(name="allowed", type={BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies if regulation allows for changes in the medication when dispensing", formalDefinition="Specifies if regulation allows for changes in the medication when dispensing.")
        protected BooleanType allowed;
        private static final long serialVersionUID = 396354861L;

        public MedicationKnowledgeRegulatorySubstitutionComponent() {
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent(CodeableConcept type, boolean allowed) {
            this.setType(type);
            this.setAllowed(allowed);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatorySubstitutionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public BooleanType getAllowedElement() {
            if (this.allowed == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatorySubstitutionComponent.allowed");
                }
                if (Configuration.doAutoCreate()) {
                    this.allowed = new BooleanType();
                }
            }
            return this.allowed;
        }

        public boolean hasAllowedElement() {
            return this.allowed != null && !this.allowed.isEmpty();
        }

        public boolean hasAllowed() {
            return this.allowed != null && !this.allowed.isEmpty();
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent setAllowedElement(BooleanType value) {
            this.allowed = value;
            return this;
        }

        public boolean getAllowed() {
            return this.allowed == null || this.allowed.isEmpty() ? false : (Boolean)this.allowed.getValue();
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent setAllowed(boolean value) {
            if (this.allowed == null) {
                this.allowed = new BooleanType();
            }
            this.allowed.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Specifies the type of substitution allowed.", 0, 1, this.type));
            children.add(new Property("allowed", "boolean", "Specifies if regulation allows for changes in the medication when dispensing.", 0, 1, this.allowed));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Specifies the type of substitution allowed.", 0, 1, this.type);
                }
                case -911343192: {
                    return new Property("allowed", "boolean", "Specifies if regulation allows for changes in the medication when dispensing.", 0, 1, this.allowed);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -911343192: {
                    Base[] baseArray;
                    if (this.allowed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.allowed;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -911343192: {
                    this.allowed = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("allowed")) {
                this.allowed = TypeConvertor.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -911343192: {
                    return this.getAllowedElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -911343192: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("allowed")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.regulatory.substitution.allowed");
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeRegulatorySubstitutionComponent copy() {
            MedicationKnowledgeRegulatorySubstitutionComponent dst = new MedicationKnowledgeRegulatorySubstitutionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeRegulatorySubstitutionComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.allowed = this.allowed == null ? null : this.allowed.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatorySubstitutionComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatorySubstitutionComponent o = (MedicationKnowledgeRegulatorySubstitutionComponent)other_;
            return MedicationKnowledgeRegulatorySubstitutionComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeRegulatorySubstitutionComponent.compareDeep(this.allowed, o.allowed, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatorySubstitutionComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatorySubstitutionComponent o = (MedicationKnowledgeRegulatorySubstitutionComponent)other_;
            return MedicationKnowledgeRegulatorySubstitutionComponent.compareValues(this.allowed, o.allowed, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.allowed});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.regulatory.substitution";
        }
    }

    @Block
    public static class MedicationKnowledgeRegulatoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="regulatoryAuthority", type={Organization.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies the authority of the regulation", formalDefinition="The authority that is specifying the regulations.")
        protected Reference regulatoryAuthority;
        @Child(name="substitution", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies if changes are allowed when dispensing a medication from a regulatory perspective", formalDefinition="Specifies if changes are allowed when dispensing a medication from a regulatory perspective.")
        protected List<MedicationKnowledgeRegulatorySubstitutionComponent> substitution;
        @Child(name="schedule", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies the schedule of a medication in jurisdiction", formalDefinition="Specifies the schedule of a medication in jurisdiction.")
        protected List<MedicationKnowledgeRegulatoryScheduleComponent> schedule;
        @Child(name="maxDispense", type={}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The maximum number of units of the medication that can be dispensed in a period", formalDefinition="The maximum number of units of the medication that can be dispensed in a period.")
        protected MedicationKnowledgeRegulatoryMaxDispenseComponent maxDispense;
        private static final long serialVersionUID = 727798050L;

        public MedicationKnowledgeRegulatoryComponent() {
        }

        public MedicationKnowledgeRegulatoryComponent(Reference regulatoryAuthority) {
            this.setRegulatoryAuthority(regulatoryAuthority);
        }

        public Reference getRegulatoryAuthority() {
            if (this.regulatoryAuthority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatoryComponent.regulatoryAuthority");
                }
                if (Configuration.doAutoCreate()) {
                    this.regulatoryAuthority = new Reference();
                }
            }
            return this.regulatoryAuthority;
        }

        public boolean hasRegulatoryAuthority() {
            return this.regulatoryAuthority != null && !this.regulatoryAuthority.isEmpty();
        }

        public MedicationKnowledgeRegulatoryComponent setRegulatoryAuthority(Reference value) {
            this.regulatoryAuthority = value;
            return this;
        }

        public List<MedicationKnowledgeRegulatorySubstitutionComponent> getSubstitution() {
            if (this.substitution == null) {
                this.substitution = new ArrayList<MedicationKnowledgeRegulatorySubstitutionComponent>();
            }
            return this.substitution;
        }

        public MedicationKnowledgeRegulatoryComponent setSubstitution(List<MedicationKnowledgeRegulatorySubstitutionComponent> theSubstitution) {
            this.substitution = theSubstitution;
            return this;
        }

        public boolean hasSubstitution() {
            if (this.substitution == null) {
                return false;
            }
            for (MedicationKnowledgeRegulatorySubstitutionComponent item : this.substitution) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent addSubstitution() {
            MedicationKnowledgeRegulatorySubstitutionComponent t = new MedicationKnowledgeRegulatorySubstitutionComponent();
            if (this.substitution == null) {
                this.substitution = new ArrayList<MedicationKnowledgeRegulatorySubstitutionComponent>();
            }
            this.substitution.add(t);
            return t;
        }

        public MedicationKnowledgeRegulatoryComponent addSubstitution(MedicationKnowledgeRegulatorySubstitutionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.substitution == null) {
                this.substitution = new ArrayList<MedicationKnowledgeRegulatorySubstitutionComponent>();
            }
            this.substitution.add(t);
            return this;
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent getSubstitutionFirstRep() {
            if (this.getSubstitution().isEmpty()) {
                this.addSubstitution();
            }
            return this.getSubstitution().get(0);
        }

        public List<MedicationKnowledgeRegulatoryScheduleComponent> getSchedule() {
            if (this.schedule == null) {
                this.schedule = new ArrayList<MedicationKnowledgeRegulatoryScheduleComponent>();
            }
            return this.schedule;
        }

        public MedicationKnowledgeRegulatoryComponent setSchedule(List<MedicationKnowledgeRegulatoryScheduleComponent> theSchedule) {
            this.schedule = theSchedule;
            return this;
        }

        public boolean hasSchedule() {
            if (this.schedule == null) {
                return false;
            }
            for (MedicationKnowledgeRegulatoryScheduleComponent item : this.schedule) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationKnowledgeRegulatoryScheduleComponent addSchedule() {
            MedicationKnowledgeRegulatoryScheduleComponent t = new MedicationKnowledgeRegulatoryScheduleComponent();
            if (this.schedule == null) {
                this.schedule = new ArrayList<MedicationKnowledgeRegulatoryScheduleComponent>();
            }
            this.schedule.add(t);
            return t;
        }

        public MedicationKnowledgeRegulatoryComponent addSchedule(MedicationKnowledgeRegulatoryScheduleComponent t) {
            if (t == null) {
                return this;
            }
            if (this.schedule == null) {
                this.schedule = new ArrayList<MedicationKnowledgeRegulatoryScheduleComponent>();
            }
            this.schedule.add(t);
            return this;
        }

        public MedicationKnowledgeRegulatoryScheduleComponent getScheduleFirstRep() {
            if (this.getSchedule().isEmpty()) {
                this.addSchedule();
            }
            return this.getSchedule().get(0);
        }

        public MedicationKnowledgeRegulatoryMaxDispenseComponent getMaxDispense() {
            if (this.maxDispense == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatoryComponent.maxDispense");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxDispense = new MedicationKnowledgeRegulatoryMaxDispenseComponent();
                }
            }
            return this.maxDispense;
        }

        public boolean hasMaxDispense() {
            return this.maxDispense != null && !this.maxDispense.isEmpty();
        }

        public MedicationKnowledgeRegulatoryComponent setMaxDispense(MedicationKnowledgeRegulatoryMaxDispenseComponent value) {
            this.maxDispense = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("regulatoryAuthority", "Reference(Organization)", "The authority that is specifying the regulations.", 0, 1, this.regulatoryAuthority));
            children.add(new Property("substitution", "", "Specifies if changes are allowed when dispensing a medication from a regulatory perspective.", 0, Integer.MAX_VALUE, this.substitution));
            children.add(new Property("schedule", "", "Specifies the schedule of a medication in jurisdiction.", 0, Integer.MAX_VALUE, this.schedule));
            children.add(new Property("maxDispense", "", "The maximum number of units of the medication that can be dispensed in a period.", 0, 1, this.maxDispense));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 711233419: {
                    return new Property("regulatoryAuthority", "Reference(Organization)", "The authority that is specifying the regulations.", 0, 1, this.regulatoryAuthority);
                }
                case 826147581: {
                    return new Property("substitution", "", "Specifies if changes are allowed when dispensing a medication from a regulatory perspective.", 0, Integer.MAX_VALUE, this.substitution);
                }
                case -697920873: {
                    return new Property("schedule", "", "Specifies the schedule of a medication in jurisdiction.", 0, Integer.MAX_VALUE, this.schedule);
                }
                case -1977784607: {
                    return new Property("maxDispense", "", "The maximum number of units of the medication that can be dispensed in a period.", 0, 1, this.maxDispense);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 711233419: {
                    Base[] baseArray;
                    if (this.regulatoryAuthority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.regulatoryAuthority;
                    }
                    return baseArray;
                }
                case 826147581: {
                    return this.substitution == null ? new Base[]{} : this.substitution.toArray(new Base[this.substitution.size()]);
                }
                case -697920873: {
                    return this.schedule == null ? new Base[]{} : this.schedule.toArray(new Base[this.schedule.size()]);
                }
                case -1977784607: {
                    Base[] baseArray;
                    if (this.maxDispense == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.maxDispense;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 711233419: {
                    this.regulatoryAuthority = TypeConvertor.castToReference(value);
                    return value;
                }
                case 826147581: {
                    this.getSubstitution().add((MedicationKnowledgeRegulatorySubstitutionComponent)value);
                    return value;
                }
                case -697920873: {
                    this.getSchedule().add((MedicationKnowledgeRegulatoryScheduleComponent)value);
                    return value;
                }
                case -1977784607: {
                    this.maxDispense = (MedicationKnowledgeRegulatoryMaxDispenseComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("regulatoryAuthority")) {
                this.regulatoryAuthority = TypeConvertor.castToReference(value);
            } else if (name.equals("substitution")) {
                this.getSubstitution().add((MedicationKnowledgeRegulatorySubstitutionComponent)value);
            } else if (name.equals("schedule")) {
                this.getSchedule().add((MedicationKnowledgeRegulatoryScheduleComponent)value);
            } else if (name.equals("maxDispense")) {
                this.maxDispense = (MedicationKnowledgeRegulatoryMaxDispenseComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 711233419: {
                    return this.getRegulatoryAuthority();
                }
                case 826147581: {
                    return this.addSubstitution();
                }
                case -697920873: {
                    return this.addSchedule();
                }
                case -1977784607: {
                    return this.getMaxDispense();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 711233419: {
                    return new String[]{"Reference"};
                }
                case 826147581: {
                    return new String[0];
                }
                case -697920873: {
                    return new String[0];
                }
                case -1977784607: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("regulatoryAuthority")) {
                this.regulatoryAuthority = new Reference();
                return this.regulatoryAuthority;
            }
            if (name.equals("substitution")) {
                return this.addSubstitution();
            }
            if (name.equals("schedule")) {
                return this.addSchedule();
            }
            if (name.equals("maxDispense")) {
                this.maxDispense = new MedicationKnowledgeRegulatoryMaxDispenseComponent();
                return this.maxDispense;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeRegulatoryComponent copy() {
            MedicationKnowledgeRegulatoryComponent dst = new MedicationKnowledgeRegulatoryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeRegulatoryComponent dst) {
            super.copyValues(dst);
            Reference reference = dst.regulatoryAuthority = this.regulatoryAuthority == null ? null : this.regulatoryAuthority.copy();
            if (this.substitution != null) {
                dst.substitution = new ArrayList<MedicationKnowledgeRegulatorySubstitutionComponent>();
                for (MedicationKnowledgeRegulatorySubstitutionComponent medicationKnowledgeRegulatorySubstitutionComponent : this.substitution) {
                    dst.substitution.add(medicationKnowledgeRegulatorySubstitutionComponent.copy());
                }
            }
            if (this.schedule != null) {
                dst.schedule = new ArrayList<MedicationKnowledgeRegulatoryScheduleComponent>();
                for (MedicationKnowledgeRegulatoryScheduleComponent medicationKnowledgeRegulatoryScheduleComponent : this.schedule) {
                    dst.schedule.add(medicationKnowledgeRegulatoryScheduleComponent.copy());
                }
            }
            dst.maxDispense = this.maxDispense == null ? null : this.maxDispense.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatoryComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatoryComponent o = (MedicationKnowledgeRegulatoryComponent)other_;
            return MedicationKnowledgeRegulatoryComponent.compareDeep(this.regulatoryAuthority, o.regulatoryAuthority, true) && MedicationKnowledgeRegulatoryComponent.compareDeep(this.substitution, o.substitution, true) && MedicationKnowledgeRegulatoryComponent.compareDeep(this.schedule, o.schedule, true) && MedicationKnowledgeRegulatoryComponent.compareDeep(this.maxDispense, o.maxDispense, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatoryComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatoryComponent o = (MedicationKnowledgeRegulatoryComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.regulatoryAuthority, this.substitution, this.schedule, this.maxDispense});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.regulatory";
        }
    }

    @Block
    public static class MedicationKnowledgeDrugCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code specifying the type of characteristic of medication", formalDefinition="A code specifying which characteristic of the medicine is being described (for example, colour, shape, imprint).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationknowledge-characteristic")
        protected CodeableConcept type;
        @Child(name="value", type={CodeableConcept.class, StringType.class, Quantity.class, Base64BinaryType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the characteristic", formalDefinition="Description of the characteristic.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeDrugCharacteristicComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeDrugCharacteristicComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Base64BinaryType getValueBase64BinaryType() throws FHIRException {
            if (this.value == null) {
                this.value = new Base64BinaryType();
            }
            if (!(this.value instanceof Base64BinaryType)) {
                throw new FHIRException("Type mismatch: the type Base64BinaryType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Base64BinaryType)this.value;
        }

        public boolean hasValueBase64BinaryType() {
            return this != null && this.value instanceof Base64BinaryType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public MedicationKnowledgeDrugCharacteristicComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof StringType || value instanceof Quantity || value instanceof Base64BinaryType)) {
                throw new Error("Not the right type for MedicationKnowledge.drugCharacteristic.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code specifying which characteristic of the medicine is being described (for example, colour, shape, imprint).", 0, 1, this.type));
            children.add(new Property("value[x]", "CodeableConcept|string|Quantity|base64Binary", "Description of the characteristic.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code specifying which characteristic of the medicine is being described (for example, colour, shape, imprint).", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|string|Quantity|base64Binary", "Description of the characteristic.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|string|Quantity|base64Binary", "Description of the characteristic.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "Description of the characteristic.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "Description of the characteristic.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "Description of the characteristic.", 0, 1, this.value);
                }
                case -1535024575: {
                    return new Property("value[x]", "base64Binary", "Description of the characteristic.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "string", "Quantity", "base64Binary"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeDrugCharacteristicComponent copy() {
            MedicationKnowledgeDrugCharacteristicComponent dst = new MedicationKnowledgeDrugCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeDrugCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeDrugCharacteristicComponent)) {
                return false;
            }
            MedicationKnowledgeDrugCharacteristicComponent o = (MedicationKnowledgeDrugCharacteristicComponent)other_;
            return MedicationKnowledgeDrugCharacteristicComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeDrugCharacteristicComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeDrugCharacteristicComponent)) {
                return false;
            }
            MedicationKnowledgeDrugCharacteristicComponent o = (MedicationKnowledgeDrugCharacteristicComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.drugCharacteristic";
        }
    }

    @Block
    public static class MedicationKnowledgePackagingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A code that defines the specific type of packaging that the medication can be found in", formalDefinition="A code that defines the specific type of packaging that the medication can be found in (e.g. blister sleeve, tube, bottle).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationknowledge-package-type")
        protected CodeableConcept type;
        @Child(name="quantity", type={Quantity.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The number of product units the package would contain if fully loaded", formalDefinition="The number of product units the package would contain if fully loaded.")
        protected Quantity quantity;
        private static final long serialVersionUID = -308052041L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgePackagingComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgePackagingComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgePackagingComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public MedicationKnowledgePackagingComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code that defines the specific type of packaging that the medication can be found in (e.g. blister sleeve, tube, bottle).", 0, 1, this.type));
            children.add(new Property("quantity", "Quantity", "The number of product units the package would contain if fully loaded.", 0, 1, this.quantity));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code that defines the specific type of packaging that the medication can be found in (e.g. blister sleeve, tube, bottle).", 0, 1, this.type);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The number of product units the package would contain if fully loaded.", 0, 1, this.quantity);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.quantity;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgePackagingComponent copy() {
            MedicationKnowledgePackagingComponent dst = new MedicationKnowledgePackagingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgePackagingComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgePackagingComponent)) {
                return false;
            }
            MedicationKnowledgePackagingComponent o = (MedicationKnowledgePackagingComponent)other_;
            return MedicationKnowledgePackagingComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgePackagingComponent.compareDeep(this.quantity, o.quantity, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgePackagingComponent)) {
                return false;
            }
            MedicationKnowledgePackagingComponent o = (MedicationKnowledgePackagingComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.quantity});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.packaging";
        }
    }

    @Block
    public static class MedicationKnowledgeMedicineClassificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification)", formalDefinition="The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification).")
        protected CodeableConcept type;
        @Child(name="classification", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specific category assigned to the medication", formalDefinition="Specific category assigned to the medication (e.g. anti-infective, anti-hypertensive, antibiotic, etc.).")
        protected List<CodeableConcept> classification;
        private static final long serialVersionUID = 1562996046L;

        public MedicationKnowledgeMedicineClassificationComponent() {
        }

        public MedicationKnowledgeMedicineClassificationComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMedicineClassificationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeMedicineClassificationComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getClassification() {
            if (this.classification == null) {
                this.classification = new ArrayList<CodeableConcept>();
            }
            return this.classification;
        }

        public MedicationKnowledgeMedicineClassificationComponent setClassification(List<CodeableConcept> theClassification) {
            this.classification = theClassification;
            return this;
        }

        public boolean hasClassification() {
            if (this.classification == null) {
                return false;
            }
            for (CodeableConcept item : this.classification) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addClassification() {
            CodeableConcept t = new CodeableConcept();
            if (this.classification == null) {
                this.classification = new ArrayList<CodeableConcept>();
            }
            this.classification.add(t);
            return t;
        }

        public MedicationKnowledgeMedicineClassificationComponent addClassification(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.classification == null) {
                this.classification = new ArrayList<CodeableConcept>();
            }
            this.classification.add(t);
            return this;
        }

        public CodeableConcept getClassificationFirstRep() {
            if (this.getClassification().isEmpty()) {
                this.addClassification();
            }
            return this.getClassification().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification).", 0, 1, this.type));
            children.add(new Property(MedicationKnowledge.SP_CLASSIFICATION, "CodeableConcept", "Specific category assigned to the medication (e.g. anti-infective, anti-hypertensive, antibiotic, etc.).", 0, Integer.MAX_VALUE, this.classification));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification).", 0, 1, this.type);
                }
                case 382350310: {
                    return new Property(MedicationKnowledge.SP_CLASSIFICATION, "CodeableConcept", "Specific category assigned to the medication (e.g. anti-infective, anti-hypertensive, antibiotic, etc.).", 0, Integer.MAX_VALUE, this.classification);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 382350310: {
                    return this.classification == null ? new Base[]{} : this.classification.toArray(new Base[this.classification.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 382350310: {
                    this.getClassification().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(MedicationKnowledge.SP_CLASSIFICATION)) {
                this.getClassification().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 382350310: {
                    return this.addClassification();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 382350310: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(MedicationKnowledge.SP_CLASSIFICATION)) {
                return this.addClassification();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeMedicineClassificationComponent copy() {
            MedicationKnowledgeMedicineClassificationComponent dst = new MedicationKnowledgeMedicineClassificationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeMedicineClassificationComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.classification != null) {
                dst.classification = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.classification) {
                    dst.classification.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMedicineClassificationComponent)) {
                return false;
            }
            MedicationKnowledgeMedicineClassificationComponent o = (MedicationKnowledgeMedicineClassificationComponent)other_;
            return MedicationKnowledgeMedicineClassificationComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeMedicineClassificationComponent.compareDeep(this.classification, o.classification, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMedicineClassificationComponent)) {
                return false;
            }
            MedicationKnowledgeMedicineClassificationComponent o = (MedicationKnowledgeMedicineClassificationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.classification});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.medicineClassification";
        }
    }

    @Block
    public static class MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="characteristic", type={CodeableConcept.class, Quantity.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific characteristic that is relevant to the administration guideline", formalDefinition="Specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).")
        protected DataType characteristic;
        @Child(name="value", type={StringType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The specific characteristic", formalDefinition="The specific characteristic (e.g. height, weight, gender, etc.).")
        protected List<StringType> value;
        private static final long serialVersionUID = 1612053261L;

        public MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent() {
        }

        public MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent(DataType characteristic) {
            this.setCharacteristic(characteristic);
        }

        public DataType getCharacteristic() {
            return this.characteristic;
        }

        public CodeableConcept getCharacteristicCodeableConcept() throws FHIRException {
            if (this.characteristic == null) {
                this.characteristic = new CodeableConcept();
            }
            if (!(this.characteristic instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.characteristic.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.characteristic;
        }

        public boolean hasCharacteristicCodeableConcept() {
            return this != null && this.characteristic instanceof CodeableConcept;
        }

        public Quantity getCharacteristicQuantity() throws FHIRException {
            if (this.characteristic == null) {
                this.characteristic = new Quantity();
            }
            if (!(this.characteristic instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.characteristic.getClass().getName() + " was encountered");
            }
            return (Quantity)this.characteristic;
        }

        public boolean hasCharacteristicQuantity() {
            return this != null && this.characteristic instanceof Quantity;
        }

        public boolean hasCharacteristic() {
            return this.characteristic != null && !this.characteristic.isEmpty();
        }

        public MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent setCharacteristic(DataType value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Quantity)) {
                throw new Error("Not the right type for MedicationKnowledge.administrationGuidelines.patientCharacteristics.characteristic[x]: " + value.fhirType());
            }
            this.characteristic = value;
            return this;
        }

        public List<StringType> getValue() {
            if (this.value == null) {
                this.value = new ArrayList<StringType>();
            }
            return this.value;
        }

        public MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent setValue(List<StringType> theValue) {
            this.value = theValue;
            return this;
        }

        public boolean hasValue() {
            if (this.value == null) {
                return false;
            }
            for (StringType item : this.value) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addValueElement() {
            StringType t = new StringType();
            if (this.value == null) {
                this.value = new ArrayList<StringType>();
            }
            this.value.add(t);
            return t;
        }

        public MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent addValue(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.value == null) {
                this.value = new ArrayList<StringType>();
            }
            this.value.add(t);
            return this;
        }

        public boolean hasValue(String value) {
            if (this.value == null) {
                return false;
            }
            for (StringType v : this.value) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("characteristic[x]", "CodeableConcept|Quantity", "Specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).", 0, 1, this.characteristic));
            children.add(new Property("value", "string", "The specific characteristic (e.g. height, weight, gender, etc.).", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -654919419: {
                    return new Property("characteristic[x]", "CodeableConcept|Quantity", "Specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).", 0, 1, this.characteristic);
                }
                case 366313883: {
                    return new Property("characteristic[x]", "CodeableConcept|Quantity", "Specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).", 0, 1, this.characteristic);
                }
                case -1259840378: {
                    return new Property("characteristic[x]", "CodeableConcept", "Specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).", 0, 1, this.characteristic);
                }
                case 1769373510: {
                    return new Property("characteristic[x]", "Quantity", "Specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).", 0, 1, this.characteristic);
                }
                case 111972721: {
                    return new Property("value", "string", "The specific characteristic (e.g. height, weight, gender, etc.).", 0, Integer.MAX_VALUE, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 366313883: {
                    Base[] baseArray;
                    if (this.characteristic == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.characteristic;
                    }
                    return baseArray;
                }
                case 111972721: {
                    return this.value == null ? new Base[]{} : this.value.toArray(new Base[this.value.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 366313883: {
                    this.characteristic = TypeConvertor.castToType(value);
                    return value;
                }
                case 111972721: {
                    this.getValue().add(TypeConvertor.castToString(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("characteristic[x]")) {
                this.characteristic = TypeConvertor.castToType(value);
            } else if (name.equals("value")) {
                this.getValue().add(TypeConvertor.castToString(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -654919419: {
                    return this.getCharacteristic();
                }
                case 366313883: {
                    return this.getCharacteristic();
                }
                case 111972721: {
                    return this.addValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 366313883: {
                    return new String[]{"CodeableConcept", "Quantity"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("characteristicCodeableConcept")) {
                this.characteristic = new CodeableConcept();
                return this.characteristic;
            }
            if (name.equals("characteristicQuantity")) {
                this.characteristic = new Quantity();
                return this.characteristic;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.administrationGuidelines.patientCharacteristics.value");
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent copy() {
            MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent dst = new MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent dst) {
            super.copyValues(dst);
            DataType dataType = dst.characteristic = this.characteristic == null ? null : this.characteristic.copy();
            if (this.value != null) {
                dst.value = new ArrayList<StringType>();
                for (StringType i : this.value) {
                    dst.value.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent)) {
                return false;
            }
            MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent o = (MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent)other_;
            return MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent.compareDeep(this.characteristic, o.characteristic, true) && MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent)) {
                return false;
            }
            MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent o = (MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent)other_;
            return MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.characteristic, this.value});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.administrationGuidelines.patientCharacteristics";
        }
    }

    @Block
    public static class MedicationKnowledgeAdministrationGuidelinesDosageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of dosage", formalDefinition="The type of dosage (for example, prophylaxis, maintenance, therapeutic, etc.).")
        protected CodeableConcept type;
        @Child(name="dosage", type={Dosage.class}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Dosage for the medication for the specific guidelines", formalDefinition="Dosage for the medication for the specific guidelines.")
        protected List<Dosage> dosage;
        private static final long serialVersionUID = 1578257961L;

        public MedicationKnowledgeAdministrationGuidelinesDosageComponent() {
        }

        public MedicationKnowledgeAdministrationGuidelinesDosageComponent(CodeableConcept type, Dosage dosage) {
            this.setType(type);
            this.addDosage(dosage);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeAdministrationGuidelinesDosageComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeAdministrationGuidelinesDosageComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<Dosage> getDosage() {
            if (this.dosage == null) {
                this.dosage = new ArrayList<Dosage>();
            }
            return this.dosage;
        }

        public MedicationKnowledgeAdministrationGuidelinesDosageComponent setDosage(List<Dosage> theDosage) {
            this.dosage = theDosage;
            return this;
        }

        public boolean hasDosage() {
            if (this.dosage == null) {
                return false;
            }
            for (Dosage item : this.dosage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Dosage addDosage() {
            Dosage t = new Dosage();
            if (this.dosage == null) {
                this.dosage = new ArrayList<Dosage>();
            }
            this.dosage.add(t);
            return t;
        }

        public MedicationKnowledgeAdministrationGuidelinesDosageComponent addDosage(Dosage t) {
            if (t == null) {
                return this;
            }
            if (this.dosage == null) {
                this.dosage = new ArrayList<Dosage>();
            }
            this.dosage.add(t);
            return this;
        }

        public Dosage getDosageFirstRep() {
            if (this.getDosage().isEmpty()) {
                this.addDosage();
            }
            return this.getDosage().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The type of dosage (for example, prophylaxis, maintenance, therapeutic, etc.).", 0, 1, this.type));
            children.add(new Property("dosage", "Dosage", "Dosage for the medication for the specific guidelines.", 0, Integer.MAX_VALUE, this.dosage));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type of dosage (for example, prophylaxis, maintenance, therapeutic, etc.).", 0, 1, this.type);
                }
                case -1326018889: {
                    return new Property("dosage", "Dosage", "Dosage for the medication for the specific guidelines.", 0, Integer.MAX_VALUE, this.dosage);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1326018889: {
                    return this.dosage == null ? new Base[]{} : this.dosage.toArray(new Base[this.dosage.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1326018889: {
                    this.getDosage().add(TypeConvertor.castToDosage(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("dosage")) {
                this.getDosage().add(TypeConvertor.castToDosage(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1326018889: {
                    return this.addDosage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1326018889: {
                    return new String[]{"Dosage"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("dosage")) {
                return this.addDosage();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeAdministrationGuidelinesDosageComponent copy() {
            MedicationKnowledgeAdministrationGuidelinesDosageComponent dst = new MedicationKnowledgeAdministrationGuidelinesDosageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeAdministrationGuidelinesDosageComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.dosage != null) {
                dst.dosage = new ArrayList<Dosage>();
                for (Dosage i : this.dosage) {
                    dst.dosage.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeAdministrationGuidelinesDosageComponent)) {
                return false;
            }
            MedicationKnowledgeAdministrationGuidelinesDosageComponent o = (MedicationKnowledgeAdministrationGuidelinesDosageComponent)other_;
            return MedicationKnowledgeAdministrationGuidelinesDosageComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeAdministrationGuidelinesDosageComponent.compareDeep(this.dosage, o.dosage, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeAdministrationGuidelinesDosageComponent)) {
                return false;
            }
            MedicationKnowledgeAdministrationGuidelinesDosageComponent o = (MedicationKnowledgeAdministrationGuidelinesDosageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.dosage});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.administrationGuidelines.dosage";
        }
    }

    @Block
    public static class MedicationKnowledgeAdministrationGuidelinesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="dosage", type={}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Dosage for the medication for the specific guidelines", formalDefinition="Dosage for the medication for the specific guidelines.")
        protected List<MedicationKnowledgeAdministrationGuidelinesDosageComponent> dosage;
        @Child(name="indication", type={CodeableConcept.class, ObservationDefinition.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indication for use that apply to the specific administration guidelines", formalDefinition="Indication for use that apply to the specific administration guidelines.")
        protected DataType indication;
        @Child(name="patientCharacteristics", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Characteristics of the patient that are relevant to the administration guidelines", formalDefinition="Characteristics of the patient that are relevant to the administration guidelines (for example, height, weight, gender, etc.).")
        protected List<MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent> patientCharacteristics;
        private static final long serialVersionUID = -208888532L;

        public List<MedicationKnowledgeAdministrationGuidelinesDosageComponent> getDosage() {
            if (this.dosage == null) {
                this.dosage = new ArrayList<MedicationKnowledgeAdministrationGuidelinesDosageComponent>();
            }
            return this.dosage;
        }

        public MedicationKnowledgeAdministrationGuidelinesComponent setDosage(List<MedicationKnowledgeAdministrationGuidelinesDosageComponent> theDosage) {
            this.dosage = theDosage;
            return this;
        }

        public boolean hasDosage() {
            if (this.dosage == null) {
                return false;
            }
            for (MedicationKnowledgeAdministrationGuidelinesDosageComponent item : this.dosage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationKnowledgeAdministrationGuidelinesDosageComponent addDosage() {
            MedicationKnowledgeAdministrationGuidelinesDosageComponent t = new MedicationKnowledgeAdministrationGuidelinesDosageComponent();
            if (this.dosage == null) {
                this.dosage = new ArrayList<MedicationKnowledgeAdministrationGuidelinesDosageComponent>();
            }
            this.dosage.add(t);
            return t;
        }

        public MedicationKnowledgeAdministrationGuidelinesComponent addDosage(MedicationKnowledgeAdministrationGuidelinesDosageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dosage == null) {
                this.dosage = new ArrayList<MedicationKnowledgeAdministrationGuidelinesDosageComponent>();
            }
            this.dosage.add(t);
            return this;
        }

        public MedicationKnowledgeAdministrationGuidelinesDosageComponent getDosageFirstRep() {
            if (this.getDosage().isEmpty()) {
                this.addDosage();
            }
            return this.getDosage().get(0);
        }

        public DataType getIndication() {
            return this.indication;
        }

        public CodeableConcept getIndicationCodeableConcept() throws FHIRException {
            if (this.indication == null) {
                this.indication = new CodeableConcept();
            }
            if (!(this.indication instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.indication.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.indication;
        }

        public boolean hasIndicationCodeableConcept() {
            return this != null && this.indication instanceof CodeableConcept;
        }

        public Reference getIndicationReference() throws FHIRException {
            if (this.indication == null) {
                this.indication = new Reference();
            }
            if (!(this.indication instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.indication.getClass().getName() + " was encountered");
            }
            return (Reference)this.indication;
        }

        public boolean hasIndicationReference() {
            return this != null && this.indication instanceof Reference;
        }

        public boolean hasIndication() {
            return this.indication != null && !this.indication.isEmpty();
        }

        public MedicationKnowledgeAdministrationGuidelinesComponent setIndication(DataType value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for MedicationKnowledge.administrationGuidelines.indication[x]: " + value.fhirType());
            }
            this.indication = value;
            return this;
        }

        public List<MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent> getPatientCharacteristics() {
            if (this.patientCharacteristics == null) {
                this.patientCharacteristics = new ArrayList<MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent>();
            }
            return this.patientCharacteristics;
        }

        public MedicationKnowledgeAdministrationGuidelinesComponent setPatientCharacteristics(List<MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent> thePatientCharacteristics) {
            this.patientCharacteristics = thePatientCharacteristics;
            return this;
        }

        public boolean hasPatientCharacteristics() {
            if (this.patientCharacteristics == null) {
                return false;
            }
            for (MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent item : this.patientCharacteristics) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent addPatientCharacteristics() {
            MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent t = new MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent();
            if (this.patientCharacteristics == null) {
                this.patientCharacteristics = new ArrayList<MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent>();
            }
            this.patientCharacteristics.add(t);
            return t;
        }

        public MedicationKnowledgeAdministrationGuidelinesComponent addPatientCharacteristics(MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent t) {
            if (t == null) {
                return this;
            }
            if (this.patientCharacteristics == null) {
                this.patientCharacteristics = new ArrayList<MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent>();
            }
            this.patientCharacteristics.add(t);
            return this;
        }

        public MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent getPatientCharacteristicsFirstRep() {
            if (this.getPatientCharacteristics().isEmpty()) {
                this.addPatientCharacteristics();
            }
            return this.getPatientCharacteristics().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("dosage", "", "Dosage for the medication for the specific guidelines.", 0, Integer.MAX_VALUE, this.dosage));
            children.add(new Property("indication[x]", "CodeableConcept|Reference(ObservationDefinition)", "Indication for use that apply to the specific administration guidelines.", 0, 1, this.indication));
            children.add(new Property("patientCharacteristics", "", "Characteristics of the patient that are relevant to the administration guidelines (for example, height, weight, gender, etc.).", 0, Integer.MAX_VALUE, this.patientCharacteristics));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1326018889: {
                    return new Property("dosage", "", "Dosage for the medication for the specific guidelines.", 0, Integer.MAX_VALUE, this.dosage);
                }
                case -501208668: {
                    return new Property("indication[x]", "CodeableConcept|Reference(ObservationDefinition)", "Indication for use that apply to the specific administration guidelines.", 0, 1, this.indication);
                }
                case -597168804: {
                    return new Property("indication[x]", "CodeableConcept|Reference(ObservationDefinition)", "Indication for use that apply to the specific administration guidelines.", 0, 1, this.indication);
                }
                case -1094003035: {
                    return new Property("indication[x]", "CodeableConcept", "Indication for use that apply to the specific administration guidelines.", 0, 1, this.indication);
                }
                case 803518799: {
                    return new Property("indication[x]", "Reference(ObservationDefinition)", "Indication for use that apply to the specific administration guidelines.", 0, 1, this.indication);
                }
                case -960531341: {
                    return new Property("patientCharacteristics", "", "Characteristics of the patient that are relevant to the administration guidelines (for example, height, weight, gender, etc.).", 0, Integer.MAX_VALUE, this.patientCharacteristics);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1326018889: {
                    return this.dosage == null ? new Base[]{} : this.dosage.toArray(new Base[this.dosage.size()]);
                }
                case -597168804: {
                    Base[] baseArray;
                    if (this.indication == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.indication;
                    }
                    return baseArray;
                }
                case -960531341: {
                    return this.patientCharacteristics == null ? new Base[]{} : this.patientCharacteristics.toArray(new Base[this.patientCharacteristics.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1326018889: {
                    this.getDosage().add((MedicationKnowledgeAdministrationGuidelinesDosageComponent)value);
                    return value;
                }
                case -597168804: {
                    this.indication = TypeConvertor.castToType(value);
                    return value;
                }
                case -960531341: {
                    this.getPatientCharacteristics().add((MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("dosage")) {
                this.getDosage().add((MedicationKnowledgeAdministrationGuidelinesDosageComponent)value);
            } else if (name.equals("indication[x]")) {
                this.indication = TypeConvertor.castToType(value);
            } else if (name.equals("patientCharacteristics")) {
                this.getPatientCharacteristics().add((MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1326018889: {
                    return this.addDosage();
                }
                case -501208668: {
                    return this.getIndication();
                }
                case -597168804: {
                    return this.getIndication();
                }
                case -960531341: {
                    return this.addPatientCharacteristics();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1326018889: {
                    return new String[0];
                }
                case -597168804: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case -960531341: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("dosage")) {
                return this.addDosage();
            }
            if (name.equals("indicationCodeableConcept")) {
                this.indication = new CodeableConcept();
                return this.indication;
            }
            if (name.equals("indicationReference")) {
                this.indication = new Reference();
                return this.indication;
            }
            if (name.equals("patientCharacteristics")) {
                return this.addPatientCharacteristics();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeAdministrationGuidelinesComponent copy() {
            MedicationKnowledgeAdministrationGuidelinesComponent dst = new MedicationKnowledgeAdministrationGuidelinesComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeAdministrationGuidelinesComponent dst) {
            super.copyValues(dst);
            if (this.dosage != null) {
                dst.dosage = new ArrayList<MedicationKnowledgeAdministrationGuidelinesDosageComponent>();
                for (MedicationKnowledgeAdministrationGuidelinesDosageComponent medicationKnowledgeAdministrationGuidelinesDosageComponent : this.dosage) {
                    dst.dosage.add(medicationKnowledgeAdministrationGuidelinesDosageComponent.copy());
                }
            }
            DataType dataType = dst.indication = this.indication == null ? null : this.indication.copy();
            if (this.patientCharacteristics != null) {
                dst.patientCharacteristics = new ArrayList<MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent>();
                for (MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent medicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent : this.patientCharacteristics) {
                    dst.patientCharacteristics.add(medicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeAdministrationGuidelinesComponent)) {
                return false;
            }
            MedicationKnowledgeAdministrationGuidelinesComponent o = (MedicationKnowledgeAdministrationGuidelinesComponent)other_;
            return MedicationKnowledgeAdministrationGuidelinesComponent.compareDeep(this.dosage, o.dosage, true) && MedicationKnowledgeAdministrationGuidelinesComponent.compareDeep(this.indication, o.indication, true) && MedicationKnowledgeAdministrationGuidelinesComponent.compareDeep(this.patientCharacteristics, o.patientCharacteristics, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeAdministrationGuidelinesComponent)) {
                return false;
            }
            MedicationKnowledgeAdministrationGuidelinesComponent o = (MedicationKnowledgeAdministrationGuidelinesComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.dosage, this.indication, this.patientCharacteristics});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.administrationGuidelines";
        }
    }

    @Block
    public static class MedicationKnowledgeMonitoringProgramComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of program under which the medication is monitored", formalDefinition="Type of program under which the medication is monitored.")
        protected CodeableConcept type;
        @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of the reviewing program", formalDefinition="Name of the reviewing program.")
        protected StringType name;
        private static final long serialVersionUID = -280346281L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonitoringProgramComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeMonitoringProgramComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonitoringProgramComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public MedicationKnowledgeMonitoringProgramComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public MedicationKnowledgeMonitoringProgramComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Type of program under which the medication is monitored.", 0, 1, this.type));
            children.add(new Property("name", "string", "Name of the reviewing program.", 0, 1, this.name));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of program under which the medication is monitored.", 0, 1, this.type);
                }
                case 3373707: {
                    return new Property("name", "string", "Name of the reviewing program.", 0, 1, this.name);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 3373707: {
                    return this.getNameElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.monitoringProgram.name");
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeMonitoringProgramComponent copy() {
            MedicationKnowledgeMonitoringProgramComponent dst = new MedicationKnowledgeMonitoringProgramComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeMonitoringProgramComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.name = this.name == null ? null : this.name.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMonitoringProgramComponent)) {
                return false;
            }
            MedicationKnowledgeMonitoringProgramComponent o = (MedicationKnowledgeMonitoringProgramComponent)other_;
            return MedicationKnowledgeMonitoringProgramComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeMonitoringProgramComponent.compareDeep(this.name, o.name, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMonitoringProgramComponent)) {
                return false;
            }
            MedicationKnowledgeMonitoringProgramComponent o = (MedicationKnowledgeMonitoringProgramComponent)other_;
            return MedicationKnowledgeMonitoringProgramComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.name});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.monitoringProgram";
        }
    }

    @Block
    public static class MedicationKnowledgeCostComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The category of the cost information", formalDefinition="The category of the cost information.  For example, manufacturers' cost, patient cost, claim reimbursement cost, actual acquisition cost.")
        protected CodeableConcept type;
        @Child(name="source", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The source or owner for the price information", formalDefinition="The source or owner that assigns the price to the medication.")
        protected StringType source;
        @Child(name="cost", type={Money.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The price of the medication", formalDefinition="The price of the medication.")
        protected Money cost;
        private static final long serialVersionUID = 244671378L;

        public MedicationKnowledgeCostComponent() {
        }

        public MedicationKnowledgeCostComponent(CodeableConcept type, Money cost) {
            this.setType(type);
            this.setCost(cost);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeCostComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeCostComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getSourceElement() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeCostComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new StringType();
                }
            }
            return this.source;
        }

        public boolean hasSourceElement() {
            return this.source != null && !this.source.isEmpty();
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public MedicationKnowledgeCostComponent setSourceElement(StringType value) {
            this.source = value;
            return this;
        }

        public String getSource() {
            return this.source == null ? null : (String)this.source.getValue();
        }

        public MedicationKnowledgeCostComponent setSource(String value) {
            if (Utilities.noString((String)value)) {
                this.source = null;
            } else {
                if (this.source == null) {
                    this.source = new StringType();
                }
                this.source.setValue(value);
            }
            return this;
        }

        public Money getCost() {
            if (this.cost == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeCostComponent.cost");
                }
                if (Configuration.doAutoCreate()) {
                    this.cost = new Money();
                }
            }
            return this.cost;
        }

        public boolean hasCost() {
            return this.cost != null && !this.cost.isEmpty();
        }

        public MedicationKnowledgeCostComponent setCost(Money value) {
            this.cost = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The category of the cost information.  For example, manufacturers' cost, patient cost, claim reimbursement cost, actual acquisition cost.", 0, 1, this.type));
            children.add(new Property("source", "string", "The source or owner that assigns the price to the medication.", 0, 1, this.source));
            children.add(new Property("cost", "Money", "The price of the medication.", 0, 1, this.cost));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The category of the cost information.  For example, manufacturers' cost, patient cost, claim reimbursement cost, actual acquisition cost.", 0, 1, this.type);
                }
                case -896505829: {
                    return new Property("source", "string", "The source or owner that assigns the price to the medication.", 0, 1, this.source);
                }
                case 3059661: {
                    return new Property("cost", "Money", "The price of the medication.", 0, 1, this.cost);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.source;
                    }
                    return baseArray;
                }
                case 3059661: {
                    Base[] baseArray;
                    if (this.cost == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.cost;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -896505829: {
                    this.source = TypeConvertor.castToString(value);
                    return value;
                }
                case 3059661: {
                    this.cost = TypeConvertor.castToMoney(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("source")) {
                this.source = TypeConvertor.castToString(value);
            } else if (name.equals("cost")) {
                this.cost = TypeConvertor.castToMoney(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -896505829: {
                    return this.getSourceElement();
                }
                case 3059661: {
                    return this.getCost();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -896505829: {
                    return new String[]{"string"};
                }
                case 3059661: {
                    return new String[]{"Money"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("source")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.cost.source");
            }
            if (name.equals("cost")) {
                this.cost = new Money();
                return this.cost;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeCostComponent copy() {
            MedicationKnowledgeCostComponent dst = new MedicationKnowledgeCostComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeCostComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.source = this.source == null ? null : this.source.copy();
            dst.cost = this.cost == null ? null : this.cost.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeCostComponent)) {
                return false;
            }
            MedicationKnowledgeCostComponent o = (MedicationKnowledgeCostComponent)other_;
            return MedicationKnowledgeCostComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeCostComponent.compareDeep(this.source, o.source, true) && MedicationKnowledgeCostComponent.compareDeep(this.cost, o.cost, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeCostComponent)) {
                return false;
            }
            MedicationKnowledgeCostComponent o = (MedicationKnowledgeCostComponent)other_;
            return MedicationKnowledgeCostComponent.compareValues(this.source, o.source, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.source, this.cost});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.cost";
        }
    }

    @Block
    public static class MedicationKnowledgeIngredientComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={CodeableConcept.class, Substance.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Medication(s) or substance(s) contained in the medication", formalDefinition="The actual ingredient - either a substance (simple ingredient) or another medication.")
        protected DataType item;
        @Child(name="isActive", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Active ingredient indicator", formalDefinition="Indication of whether this ingredient affects the therapeutic action of the drug.")
        protected BooleanType isActive;
        @Child(name="strength", type={Ratio.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Quantity of ingredient present", formalDefinition="Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet.")
        protected Ratio strength;
        private static final long serialVersionUID = -744144813L;

        public MedicationKnowledgeIngredientComponent() {
        }

        public MedicationKnowledgeIngredientComponent(DataType item) {
            this.setItem(item);
        }

        public DataType getItem() {
            return this.item;
        }

        public CodeableConcept getItemCodeableConcept() throws FHIRException {
            if (this.item == null) {
                this.item = new CodeableConcept();
            }
            if (!(this.item instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.item;
        }

        public boolean hasItemCodeableConcept() {
            return this != null && this.item instanceof CodeableConcept;
        }

        public Reference getItemReference() throws FHIRException {
            if (this.item == null) {
                this.item = new Reference();
            }
            if (!(this.item instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (Reference)this.item;
        }

        public boolean hasItemReference() {
            return this != null && this.item instanceof Reference;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public MedicationKnowledgeIngredientComponent setItem(DataType value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for MedicationKnowledge.ingredient.item[x]: " + value.fhirType());
            }
            this.item = value;
            return this;
        }

        public BooleanType getIsActiveElement() {
            if (this.isActive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeIngredientComponent.isActive");
                }
                if (Configuration.doAutoCreate()) {
                    this.isActive = new BooleanType();
                }
            }
            return this.isActive;
        }

        public boolean hasIsActiveElement() {
            return this.isActive != null && !this.isActive.isEmpty();
        }

        public boolean hasIsActive() {
            return this.isActive != null && !this.isActive.isEmpty();
        }

        public MedicationKnowledgeIngredientComponent setIsActiveElement(BooleanType value) {
            this.isActive = value;
            return this;
        }

        public boolean getIsActive() {
            return this.isActive == null || this.isActive.isEmpty() ? false : (Boolean)this.isActive.getValue();
        }

        public MedicationKnowledgeIngredientComponent setIsActive(boolean value) {
            if (this.isActive == null) {
                this.isActive = new BooleanType();
            }
            this.isActive.setValue((Object)value);
            return this;
        }

        public Ratio getStrength() {
            if (this.strength == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeIngredientComponent.strength");
                }
                if (Configuration.doAutoCreate()) {
                    this.strength = new Ratio();
                }
            }
            return this.strength;
        }

        public boolean hasStrength() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public MedicationKnowledgeIngredientComponent setStrength(Ratio value) {
            this.strength = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item[x]", "CodeableConcept|Reference(Substance)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item));
            children.add(new Property("isActive", "boolean", "Indication of whether this ingredient affects the therapeutic action of the drug.", 0, 1, this.isActive));
            children.add(new Property("strength", "Ratio", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet.", 0, 1, this.strength));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2116201613: {
                    return new Property("item[x]", "CodeableConcept|Reference(Substance)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item);
                }
                case 3242771: {
                    return new Property("item[x]", "CodeableConcept|Reference(Substance)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item);
                }
                case 106644494: {
                    return new Property("item[x]", "CodeableConcept", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item);
                }
                case 1376364920: {
                    return new Property("item[x]", "Reference(Substance)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item);
                }
                case -748916528: {
                    return new Property("isActive", "boolean", "Indication of whether this ingredient affects the therapeutic action of the drug.", 0, 1, this.isActive);
                }
                case 1791316033: {
                    return new Property("strength", "Ratio", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet.", 0, 1, this.strength);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
                case -748916528: {
                    Base[] baseArray;
                    if (this.isActive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.isActive;
                    }
                    return baseArray;
                }
                case 1791316033: {
                    Base[] baseArray;
                    if (this.strength == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.strength;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = TypeConvertor.castToType(value);
                    return value;
                }
                case -748916528: {
                    this.isActive = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 1791316033: {
                    this.strength = TypeConvertor.castToRatio(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item[x]")) {
                this.item = TypeConvertor.castToType(value);
            } else if (name.equals("isActive")) {
                this.isActive = TypeConvertor.castToBoolean(value);
            } else if (name.equals("strength")) {
                this.strength = TypeConvertor.castToRatio(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2116201613: {
                    return this.getItem();
                }
                case 3242771: {
                    return this.getItem();
                }
                case -748916528: {
                    return this.getIsActiveElement();
                }
                case 1791316033: {
                    return this.getStrength();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case -748916528: {
                    return new String[]{"boolean"};
                }
                case 1791316033: {
                    return new String[]{"Ratio"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemCodeableConcept")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            if (name.equals("itemReference")) {
                this.item = new Reference();
                return this.item;
            }
            if (name.equals("isActive")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.ingredient.isActive");
            }
            if (name.equals("strength")) {
                this.strength = new Ratio();
                return this.strength;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeIngredientComponent copy() {
            MedicationKnowledgeIngredientComponent dst = new MedicationKnowledgeIngredientComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeIngredientComponent dst) {
            super.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
            dst.isActive = this.isActive == null ? null : this.isActive.copy();
            dst.strength = this.strength == null ? null : this.strength.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeIngredientComponent)) {
                return false;
            }
            MedicationKnowledgeIngredientComponent o = (MedicationKnowledgeIngredientComponent)other_;
            return MedicationKnowledgeIngredientComponent.compareDeep(this.item, o.item, true) && MedicationKnowledgeIngredientComponent.compareDeep(this.isActive, o.isActive, true) && MedicationKnowledgeIngredientComponent.compareDeep(this.strength, o.strength, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeIngredientComponent)) {
                return false;
            }
            MedicationKnowledgeIngredientComponent o = (MedicationKnowledgeIngredientComponent)other_;
            return MedicationKnowledgeIngredientComponent.compareValues(this.isActive, o.isActive, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.item, this.isActive, this.strength});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.ingredient";
        }
    }

    @Block
    public static class MedicationKnowledgeMonographComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The category of medication document", formalDefinition="The category of documentation about the medication. (e.g. professional monograph, patient education monograph).")
        protected CodeableConcept type;
        @Child(name="source", type={DocumentReference.class, Media.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Associated documentation about the medication", formalDefinition="Associated documentation about the medication.")
        protected Reference source;
        private static final long serialVersionUID = -197893751L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonographComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeMonographComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Reference getSource() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonographComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new Reference();
                }
            }
            return this.source;
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public MedicationKnowledgeMonographComponent setSource(Reference value) {
            this.source = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The category of documentation about the medication. (e.g. professional monograph, patient education monograph).", 0, 1, this.type));
            children.add(new Property("source", "Reference(DocumentReference|Media)", "Associated documentation about the medication.", 0, 1, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The category of documentation about the medication. (e.g. professional monograph, patient education monograph).", 0, 1, this.type);
                }
                case -896505829: {
                    return new Property("source", "Reference(DocumentReference|Media)", "Associated documentation about the medication.", 0, 1, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.source;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -896505829: {
                    this.source = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("source")) {
                this.source = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -896505829: {
                    return this.getSource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("source")) {
                this.source = new Reference();
                return this.source;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeMonographComponent copy() {
            MedicationKnowledgeMonographComponent dst = new MedicationKnowledgeMonographComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeMonographComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.source = this.source == null ? null : this.source.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMonographComponent)) {
                return false;
            }
            MedicationKnowledgeMonographComponent o = (MedicationKnowledgeMonographComponent)other_;
            return MedicationKnowledgeMonographComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeMonographComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMonographComponent)) {
                return false;
            }
            MedicationKnowledgeMonographComponent o = (MedicationKnowledgeMonographComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.source});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.monograph";
        }
    }

    @Block
    public static class MedicationKnowledgeRelatedMedicationKnowledgeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Category of medicationKnowledge", formalDefinition="The category of the associated medication knowledge reference.")
        protected CodeableConcept type;
        @Child(name="reference", type={MedicationKnowledge.class}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Associated documentation about the associated medication knowledge", formalDefinition="Associated documentation about the associated medication knowledge.")
        protected List<Reference> reference;
        private static final long serialVersionUID = 1687147899L;

        public MedicationKnowledgeRelatedMedicationKnowledgeComponent() {
        }

        public MedicationKnowledgeRelatedMedicationKnowledgeComponent(CodeableConcept type, Reference reference) {
            this.setType(type);
            this.addReference(reference);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRelatedMedicationKnowledgeComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeRelatedMedicationKnowledgeComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<Reference> getReference() {
            if (this.reference == null) {
                this.reference = new ArrayList<Reference>();
            }
            return this.reference;
        }

        public MedicationKnowledgeRelatedMedicationKnowledgeComponent setReference(List<Reference> theReference) {
            this.reference = theReference;
            return this;
        }

        public boolean hasReference() {
            if (this.reference == null) {
                return false;
            }
            for (Reference item : this.reference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addReference() {
            Reference t = new Reference();
            if (this.reference == null) {
                this.reference = new ArrayList<Reference>();
            }
            this.reference.add(t);
            return t;
        }

        public MedicationKnowledgeRelatedMedicationKnowledgeComponent addReference(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.reference == null) {
                this.reference = new ArrayList<Reference>();
            }
            this.reference.add(t);
            return this;
        }

        public Reference getReferenceFirstRep() {
            if (this.getReference().isEmpty()) {
                this.addReference();
            }
            return this.getReference().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The category of the associated medication knowledge reference.", 0, 1, this.type));
            children.add(new Property("reference", "Reference(MedicationKnowledge)", "Associated documentation about the associated medication knowledge.", 0, Integer.MAX_VALUE, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The category of the associated medication knowledge reference.", 0, 1, this.type);
                }
                case -925155509: {
                    return new Property("reference", "Reference(MedicationKnowledge)", "Associated documentation about the associated medication knowledge.", 0, Integer.MAX_VALUE, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -925155509: {
                    return this.reference == null ? new Base[]{} : this.reference.toArray(new Base[this.reference.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -925155509: {
                    this.getReference().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reference")) {
                this.getReference().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -925155509: {
                    return this.addReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("reference")) {
                return this.addReference();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeRelatedMedicationKnowledgeComponent copy() {
            MedicationKnowledgeRelatedMedicationKnowledgeComponent dst = new MedicationKnowledgeRelatedMedicationKnowledgeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeRelatedMedicationKnowledgeComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.reference != null) {
                dst.reference = new ArrayList<Reference>();
                for (Reference i : this.reference) {
                    dst.reference.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRelatedMedicationKnowledgeComponent)) {
                return false;
            }
            MedicationKnowledgeRelatedMedicationKnowledgeComponent o = (MedicationKnowledgeRelatedMedicationKnowledgeComponent)other_;
            return MedicationKnowledgeRelatedMedicationKnowledgeComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeRelatedMedicationKnowledgeComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRelatedMedicationKnowledgeComponent)) {
                return false;
            }
            MedicationKnowledgeRelatedMedicationKnowledgeComponent o = (MedicationKnowledgeRelatedMedicationKnowledgeComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.reference});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.relatedMedicationKnowledge";
        }
    }

    public static class MedicationKnowledgeStatusCodesEnumFactory
    implements EnumFactory<MedicationKnowledgeStatusCodes> {
        @Override
        public MedicationKnowledgeStatusCodes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return MedicationKnowledgeStatusCodes.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return MedicationKnowledgeStatusCodes.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationKnowledgeStatusCodes.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown MedicationKnowledgeStatusCodes code '" + codeString + "'");
        }

        public Enumeration<MedicationKnowledgeStatusCodes> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationKnowledgeStatusCodes>(this, MedicationKnowledgeStatusCodes.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<MedicationKnowledgeStatusCodes>(this, MedicationKnowledgeStatusCodes.NULL, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<MedicationKnowledgeStatusCodes>(this, MedicationKnowledgeStatusCodes.ACTIVE, code);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<MedicationKnowledgeStatusCodes>(this, MedicationKnowledgeStatusCodes.INACTIVE, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationKnowledgeStatusCodes>(this, MedicationKnowledgeStatusCodes.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown MedicationKnowledgeStatusCodes code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationKnowledgeStatusCodes code) {
            if (code == MedicationKnowledgeStatusCodes.ACTIVE) {
                return "active";
            }
            if (code == MedicationKnowledgeStatusCodes.INACTIVE) {
                return "inactive";
            }
            if (code == MedicationKnowledgeStatusCodes.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationKnowledgeStatusCodes code) {
            return code.getSystem();
        }
    }

    public static enum MedicationKnowledgeStatusCodes {
        ACTIVE,
        INACTIVE,
        ENTEREDINERROR,
        NULL;


        public static MedicationKnowledgeStatusCodes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationKnowledgeStatusCodes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://terminology.hl7.org/CodeSystem/medicationknowledge-status";
                }
                case INACTIVE: {
                    return "http://terminology.hl7.org/CodeSystem/medicationknowledge-status";
                }
                case ENTEREDINERROR: {
                    return "http://terminology.hl7.org/CodeSystem/medicationknowledge-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The medication is available for use.";
                }
                case INACTIVE: {
                    return "The medication is not available for use.";
                }
                case ENTEREDINERROR: {
                    return "The medication was entered in error.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

