/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.Organization;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Ratio;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.Substance;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Medication", profile="http://hl7.org/fhir/StructureDefinition/Medication")
public class Medication
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for this medication", formalDefinition="Business identifier for this medication.")
    protected List<Identifier> identifier;
    @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Codes that identify this medication", formalDefinition="A code (or set of codes) that specify this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected CodeableConcept code;
    @Child(name="status", type={CodeType.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | inactive | entered-in-error", formalDefinition="A code to indicate if the medication is in active use.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-status")
    protected Enumeration<MedicationStatusCodes> status;
    @Child(name="manufacturer", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of the item", formalDefinition="Describes the details of the manufacturer of the medication product.  This is not intended to represent the distributor of a medication product.")
    protected Reference manufacturer;
    @Child(name="form", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="powder | tablets | capsule +", formalDefinition="Describes the form of the item.  Powder; tablets; capsule.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-form-codes")
    protected CodeableConcept form;
    @Child(name="amount", type={Ratio.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Amount of drug in package", formalDefinition="Specific amount of the drug in the packaged product.  For example, when specifying a product that has the same strength (For example, Insulin glargine 100 unit per mL solution for injection), this attribute provides additional clarification of the package amount (For example, 3 mL, 10mL, etc.).")
    protected Ratio amount;
    @Child(name="ingredient", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Active or inactive ingredient", formalDefinition="Identifies a particular constituent of interest in the product.")
    protected List<MedicationIngredientComponent> ingredient;
    @Child(name="batch", type={}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details about packaged medications", formalDefinition="Information that only applies to packages (not products).")
    protected MedicationBatchComponent batch;
    private static final long serialVersionUID = 1114691572L;
    @SearchParamDefinition(name="expiration-date", path="Medication.batch.expirationDate", description="Returns medications in a batch with this expiration date", type="date")
    public static final String SP_EXPIRATION_DATE = "expiration-date";
    public static final DateClientParam EXPIRATION_DATE = new DateClientParam("expiration-date");
    @SearchParamDefinition(name="form", path="Medication.form", description="Returns medications for a specific dose form", type="token")
    public static final String SP_FORM = "form";
    public static final TokenClientParam FORM = new TokenClientParam("form");
    @SearchParamDefinition(name="identifier", path="Medication.identifier", description="Returns medications with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="ingredient-code", path="(Medication.ingredient.item as CodeableConcept)", description="Returns medications for this ingredient code", type="token")
    public static final String SP_INGREDIENT_CODE = "ingredient-code";
    public static final TokenClientParam INGREDIENT_CODE = new TokenClientParam("ingredient-code");
    @SearchParamDefinition(name="ingredient", path="(Medication.ingredient.item as Reference)", description="Returns medications for this ingredient reference", type="reference", target={Medication.class, Substance.class})
    public static final String SP_INGREDIENT = "ingredient";
    public static final ReferenceClientParam INGREDIENT = new ReferenceClientParam("ingredient");
    public static final Include INCLUDE_INGREDIENT = new Include("Medication:ingredient").toLocked();
    @SearchParamDefinition(name="lot-number", path="Medication.batch.lotNumber", description="Returns medications in a batch with this lot number", type="token")
    public static final String SP_LOT_NUMBER = "lot-number";
    public static final TokenClientParam LOT_NUMBER = new TokenClientParam("lot-number");
    @SearchParamDefinition(name="manufacturer", path="Medication.manufacturer", description="Returns medications made or sold for this manufacturer", type="reference", target={Organization.class})
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final ReferenceClientParam MANUFACTURER = new ReferenceClientParam("manufacturer");
    public static final Include INCLUDE_MANUFACTURER = new Include("Medication:manufacturer").toLocked();
    @SearchParamDefinition(name="status", path="Medication.status", description="Returns medications for this status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="code", path="AllergyIntolerance.code | AllergyIntolerance.reaction.substance | Condition.code | (DeviceRequest.code as CodeableConcept) | DiagnosticReport.code | FamilyMemberHistory.condition.code | List.code | Medication.code | (MedicationAdministration.medication as CodeableConcept) | (MedicationDispense.medication as CodeableConcept) | (MedicationRequest.medication as CodeableConcept) | (MedicationStatement.medication as CodeableConcept) | Observation.code | Procedure.code | ServiceRequest.code", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [Condition](condition.html): Code for the condition\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication code\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n* [ServiceRequest](servicerequest.html): What is being requested/ordered\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Medication setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Medication addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Medication setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Enumeration<MedicationStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationStatusCodes>(new MedicationStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Medication setStatusElement(Enumeration<MedicationStatusCodes> value) {
        this.status = value;
        return this;
    }

    public MedicationStatusCodes getStatus() {
        return this.status == null ? null : (MedicationStatusCodes)((Object)this.status.getValue());
    }

    public Medication setStatus(MedicationStatusCodes value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<MedicationStatusCodes>(new MedicationStatusCodesEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getManufacturer() {
        if (this.manufacturer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturer = new Reference();
            }
        }
        return this.manufacturer;
    }

    public boolean hasManufacturer() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public Medication setManufacturer(Reference value) {
        this.manufacturer = value;
        return this;
    }

    public CodeableConcept getForm() {
        if (this.form == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.form");
            }
            if (Configuration.doAutoCreate()) {
                this.form = new CodeableConcept();
            }
        }
        return this.form;
    }

    public boolean hasForm() {
        return this.form != null && !this.form.isEmpty();
    }

    public Medication setForm(CodeableConcept value) {
        this.form = value;
        return this;
    }

    public Ratio getAmount() {
        if (this.amount == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.amount");
            }
            if (Configuration.doAutoCreate()) {
                this.amount = new Ratio();
            }
        }
        return this.amount;
    }

    public boolean hasAmount() {
        return this.amount != null && !this.amount.isEmpty();
    }

    public Medication setAmount(Ratio value) {
        this.amount = value;
        return this;
    }

    public List<MedicationIngredientComponent> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationIngredientComponent>();
        }
        return this.ingredient;
    }

    public Medication setIngredient(List<MedicationIngredientComponent> theIngredient) {
        this.ingredient = theIngredient;
        return this;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (MedicationIngredientComponent item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationIngredientComponent addIngredient() {
        MedicationIngredientComponent t = new MedicationIngredientComponent();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationIngredientComponent>();
        }
        this.ingredient.add(t);
        return t;
    }

    public Medication addIngredient(MedicationIngredientComponent t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationIngredientComponent>();
        }
        this.ingredient.add(t);
        return this;
    }

    public MedicationIngredientComponent getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    public MedicationBatchComponent getBatch() {
        if (this.batch == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.batch");
            }
            if (Configuration.doAutoCreate()) {
                this.batch = new MedicationBatchComponent();
            }
        }
        return this.batch;
    }

    public boolean hasBatch() {
        return this.batch != null && !this.batch.isEmpty();
    }

    public Medication setBatch(MedicationBatchComponent value) {
        this.batch = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier for this medication.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_CODE, "CodeableConcept", "A code (or set of codes) that specify this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.", 0, 1, this.code));
        children.add(new Property(SP_STATUS, SP_CODE, "A code to indicate if the medication is in active use.", 0, 1, this.status));
        children.add(new Property(SP_MANUFACTURER, "Reference(Organization)", "Describes the details of the manufacturer of the medication product.  This is not intended to represent the distributor of a medication product.", 0, 1, this.manufacturer));
        children.add(new Property(SP_FORM, "CodeableConcept", "Describes the form of the item.  Powder; tablets; capsule.", 0, 1, this.form));
        children.add(new Property("amount", "Ratio", "Specific amount of the drug in the packaged product.  For example, when specifying a product that has the same strength (For example, Insulin glargine 100 unit per mL solution for injection), this attribute provides additional clarification of the package amount (For example, 3 mL, 10mL, etc.).", 0, 1, this.amount));
        children.add(new Property(SP_INGREDIENT, "", "Identifies a particular constituent of interest in the product.", 0, Integer.MAX_VALUE, this.ingredient));
        children.add(new Property("batch", "", "Information that only applies to packages (not products).", 0, 1, this.batch));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier for this medication.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "A code (or set of codes) that specify this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.", 0, 1, this.code);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code to indicate if the medication is in active use.", 0, 1, this.status);
            }
            case -1969347631: {
                return new Property(SP_MANUFACTURER, "Reference(Organization)", "Describes the details of the manufacturer of the medication product.  This is not intended to represent the distributor of a medication product.", 0, 1, this.manufacturer);
            }
            case 3148996: {
                return new Property(SP_FORM, "CodeableConcept", "Describes the form of the item.  Powder; tablets; capsule.", 0, 1, this.form);
            }
            case -1413853096: {
                return new Property("amount", "Ratio", "Specific amount of the drug in the packaged product.  For example, when specifying a product that has the same strength (For example, Insulin glargine 100 unit per mL solution for injection), this attribute provides additional clarification of the package amount (For example, 3 mL, 10mL, etc.).", 0, 1, this.amount);
            }
            case -206409263: {
                return new Property(SP_INGREDIENT, "", "Identifies a particular constituent of interest in the product.", 0, Integer.MAX_VALUE, this.ingredient);
            }
            case 93509434: {
                return new Property("batch", "", "Information that only applies to packages (not products).", 0, 1, this.batch);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.code;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -1969347631: {
                Base[] baseArray;
                if (this.manufacturer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.manufacturer;
                }
                return baseArray;
            }
            case 3148996: {
                Base[] baseArray;
                if (this.form == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.form;
                }
                return baseArray;
            }
            case -1413853096: {
                Base[] baseArray;
                if (this.amount == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.amount;
                }
                return baseArray;
            }
            case -206409263: {
                return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
            }
            case 93509434: {
                Base[] baseArray;
                if (this.batch == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.batch;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -892481550: {
                value = new MedicationStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1969347631: {
                this.manufacturer = TypeConvertor.castToReference(value);
                return value;
            }
            case 3148996: {
                this.form = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1413853096: {
                this.amount = TypeConvertor.castToRatio(value);
                return value;
            }
            case -206409263: {
                this.getIngredient().add((MedicationIngredientComponent)((Object)value));
                return value;
            }
            case 93509434: {
                this.batch = (MedicationBatchComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_STATUS)) {
            value = new MedicationStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_FORM)) {
            this.form = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("amount")) {
            this.amount = TypeConvertor.castToRatio(value);
        } else if (name.equals(SP_INGREDIENT)) {
            this.getIngredient().add((MedicationIngredientComponent)((Object)value));
        } else if (name.equals("batch")) {
            this.batch = (MedicationBatchComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3059181: {
                return this.getCode();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1969347631: {
                return this.getManufacturer();
            }
            case 3148996: {
                return this.getForm();
            }
            case -1413853096: {
                return this.getAmount();
            }
            case -206409263: {
                return this.addIngredient();
            }
            case 93509434: {
                return this.getBatch();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case 3148996: {
                return new String[]{"CodeableConcept"};
            }
            case -1413853096: {
                return new String[]{"Ratio"};
            }
            case -206409263: {
                return new String[0];
            }
            case 93509434: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Medication.status");
        }
        if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = new Reference();
            return this.manufacturer;
        }
        if (name.equals(SP_FORM)) {
            this.form = new CodeableConcept();
            return this.form;
        }
        if (name.equals("amount")) {
            this.amount = new Ratio();
            return this.amount;
        }
        if (name.equals(SP_INGREDIENT)) {
            return this.addIngredient();
        }
        if (name.equals("batch")) {
            this.batch = new MedicationBatchComponent();
            return this.batch;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Medication";
    }

    @Override
    public Medication copy() {
        Medication dst = new Medication();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Medication dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        dst.form = this.form == null ? null : this.form.copy();
        Ratio ratio = dst.amount = this.amount == null ? null : this.amount.copy();
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<MedicationIngredientComponent>();
            for (MedicationIngredientComponent medicationIngredientComponent : this.ingredient) {
                dst.ingredient.add(medicationIngredientComponent.copy());
            }
        }
        dst.batch = this.batch == null ? null : this.batch.copy();
    }

    protected Medication typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Medication)) {
            return false;
        }
        Medication o = (Medication)other_;
        return Medication.compareDeep(this.identifier, o.identifier, true) && Medication.compareDeep(this.code, o.code, true) && Medication.compareDeep(this.status, o.status, true) && Medication.compareDeep(this.manufacturer, o.manufacturer, true) && Medication.compareDeep(this.form, o.form, true) && Medication.compareDeep(this.amount, o.amount, true) && Medication.compareDeep(this.ingredient, o.ingredient, true) && Medication.compareDeep(this.batch, o.batch, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Medication)) {
            return false;
        }
        Medication o = (Medication)other_;
        return Medication.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.code, this.status, this.manufacturer, this.form, this.amount, this.ingredient, this.batch});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Medication;
    }

    @Block
    public static class MedicationBatchComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="lotNumber", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifier assigned to batch", formalDefinition="The assigned lot number of a batch of the specified product.")
        protected StringType lotNumber;
        @Child(name="expirationDate", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When batch will expire", formalDefinition="When this specific batch of product will expire.")
        protected DateTimeType expirationDate;
        private static final long serialVersionUID = 1982738755L;

        public StringType getLotNumberElement() {
            if (this.lotNumber == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationBatchComponent.lotNumber");
                }
                if (Configuration.doAutoCreate()) {
                    this.lotNumber = new StringType();
                }
            }
            return this.lotNumber;
        }

        public boolean hasLotNumberElement() {
            return this.lotNumber != null && !this.lotNumber.isEmpty();
        }

        public boolean hasLotNumber() {
            return this.lotNumber != null && !this.lotNumber.isEmpty();
        }

        public MedicationBatchComponent setLotNumberElement(StringType value) {
            this.lotNumber = value;
            return this;
        }

        public String getLotNumber() {
            return this.lotNumber == null ? null : (String)this.lotNumber.getValue();
        }

        public MedicationBatchComponent setLotNumber(String value) {
            if (Utilities.noString((String)value)) {
                this.lotNumber = null;
            } else {
                if (this.lotNumber == null) {
                    this.lotNumber = new StringType();
                }
                this.lotNumber.setValue(value);
            }
            return this;
        }

        public DateTimeType getExpirationDateElement() {
            if (this.expirationDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationBatchComponent.expirationDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.expirationDate = new DateTimeType();
                }
            }
            return this.expirationDate;
        }

        public boolean hasExpirationDateElement() {
            return this.expirationDate != null && !this.expirationDate.isEmpty();
        }

        public boolean hasExpirationDate() {
            return this.expirationDate != null && !this.expirationDate.isEmpty();
        }

        public MedicationBatchComponent setExpirationDateElement(DateTimeType value) {
            this.expirationDate = value;
            return this;
        }

        public Date getExpirationDate() {
            return this.expirationDate == null ? null : (Date)this.expirationDate.getValue();
        }

        public MedicationBatchComponent setExpirationDate(Date value) {
            if (value == null) {
                this.expirationDate = null;
            } else {
                if (this.expirationDate == null) {
                    this.expirationDate = new DateTimeType();
                }
                this.expirationDate.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("lotNumber", "string", "The assigned lot number of a batch of the specified product.", 0, 1, this.lotNumber));
            children.add(new Property("expirationDate", "dateTime", "When this specific batch of product will expire.", 0, 1, this.expirationDate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 462547450: {
                    return new Property("lotNumber", "string", "The assigned lot number of a batch of the specified product.", 0, 1, this.lotNumber);
                }
                case -668811523: {
                    return new Property("expirationDate", "dateTime", "When this specific batch of product will expire.", 0, 1, this.expirationDate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 462547450: {
                    Base[] baseArray;
                    if (this.lotNumber == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.lotNumber;
                    }
                    return baseArray;
                }
                case -668811523: {
                    Base[] baseArray;
                    if (this.expirationDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.expirationDate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 462547450: {
                    this.lotNumber = TypeConvertor.castToString(value);
                    return value;
                }
                case -668811523: {
                    this.expirationDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("lotNumber")) {
                this.lotNumber = TypeConvertor.castToString(value);
            } else if (name.equals("expirationDate")) {
                this.expirationDate = TypeConvertor.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 462547450: {
                    return this.getLotNumberElement();
                }
                case -668811523: {
                    return this.getExpirationDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 462547450: {
                    return new String[]{"string"};
                }
                case -668811523: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("lotNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type Medication.batch.lotNumber");
            }
            if (name.equals("expirationDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Medication.batch.expirationDate");
            }
            return super.addChild(name);
        }

        @Override
        public MedicationBatchComponent copy() {
            MedicationBatchComponent dst = new MedicationBatchComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationBatchComponent dst) {
            super.copyValues(dst);
            dst.lotNumber = this.lotNumber == null ? null : this.lotNumber.copy();
            dst.expirationDate = this.expirationDate == null ? null : this.expirationDate.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationBatchComponent)) {
                return false;
            }
            MedicationBatchComponent o = (MedicationBatchComponent)other_;
            return MedicationBatchComponent.compareDeep(this.lotNumber, o.lotNumber, true) && MedicationBatchComponent.compareDeep(this.expirationDate, o.expirationDate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationBatchComponent)) {
                return false;
            }
            MedicationBatchComponent o = (MedicationBatchComponent)other_;
            return MedicationBatchComponent.compareValues(this.lotNumber, o.lotNumber, true) && MedicationBatchComponent.compareValues(this.expirationDate, o.expirationDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.lotNumber, this.expirationDate});
        }

        @Override
        public String fhirType() {
            return "Medication.batch";
        }
    }

    @Block
    public static class MedicationIngredientComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={CodeableConcept.class, Substance.class, Medication.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The actual ingredient or content", formalDefinition="The actual ingredient - either a substance (simple ingredient) or another medication of a medication.")
        protected DataType item;
        @Child(name="isActive", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Active ingredient indicator", formalDefinition="Indication of whether this ingredient affects the therapeutic action of the drug.")
        protected BooleanType isActive;
        @Child(name="strength", type={Ratio.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Quantity of ingredient present", formalDefinition="Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet.")
        protected Ratio strength;
        private static final long serialVersionUID = -744144813L;

        public MedicationIngredientComponent() {
        }

        public MedicationIngredientComponent(DataType item) {
            this.setItem(item);
        }

        public DataType getItem() {
            return this.item;
        }

        public CodeableConcept getItemCodeableConcept() throws FHIRException {
            if (this.item == null) {
                this.item = new CodeableConcept();
            }
            if (!(this.item instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.item;
        }

        public boolean hasItemCodeableConcept() {
            return this != null && this.item instanceof CodeableConcept;
        }

        public Reference getItemReference() throws FHIRException {
            if (this.item == null) {
                this.item = new Reference();
            }
            if (!(this.item instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (Reference)this.item;
        }

        public boolean hasItemReference() {
            return this != null && this.item instanceof Reference;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public MedicationIngredientComponent setItem(DataType value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for Medication.ingredient.item[x]: " + value.fhirType());
            }
            this.item = value;
            return this;
        }

        public BooleanType getIsActiveElement() {
            if (this.isActive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationIngredientComponent.isActive");
                }
                if (Configuration.doAutoCreate()) {
                    this.isActive = new BooleanType();
                }
            }
            return this.isActive;
        }

        public boolean hasIsActiveElement() {
            return this.isActive != null && !this.isActive.isEmpty();
        }

        public boolean hasIsActive() {
            return this.isActive != null && !this.isActive.isEmpty();
        }

        public MedicationIngredientComponent setIsActiveElement(BooleanType value) {
            this.isActive = value;
            return this;
        }

        public boolean getIsActive() {
            return this.isActive == null || this.isActive.isEmpty() ? false : (Boolean)this.isActive.getValue();
        }

        public MedicationIngredientComponent setIsActive(boolean value) {
            if (this.isActive == null) {
                this.isActive = new BooleanType();
            }
            this.isActive.setValue((Object)value);
            return this;
        }

        public Ratio getStrength() {
            if (this.strength == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationIngredientComponent.strength");
                }
                if (Configuration.doAutoCreate()) {
                    this.strength = new Ratio();
                }
            }
            return this.strength;
        }

        public boolean hasStrength() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public MedicationIngredientComponent setStrength(Ratio value) {
            this.strength = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item[x]", "CodeableConcept|Reference(Substance|Medication)", "The actual ingredient - either a substance (simple ingredient) or another medication of a medication.", 0, 1, this.item));
            children.add(new Property("isActive", "boolean", "Indication of whether this ingredient affects the therapeutic action of the drug.", 0, 1, this.isActive));
            children.add(new Property("strength", "Ratio", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet.", 0, 1, this.strength));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2116201613: {
                    return new Property("item[x]", "CodeableConcept|Reference(Substance|Medication)", "The actual ingredient - either a substance (simple ingredient) or another medication of a medication.", 0, 1, this.item);
                }
                case 3242771: {
                    return new Property("item[x]", "CodeableConcept|Reference(Substance|Medication)", "The actual ingredient - either a substance (simple ingredient) or another medication of a medication.", 0, 1, this.item);
                }
                case 106644494: {
                    return new Property("item[x]", "CodeableConcept", "The actual ingredient - either a substance (simple ingredient) or another medication of a medication.", 0, 1, this.item);
                }
                case 1376364920: {
                    return new Property("item[x]", "Reference(Substance|Medication)", "The actual ingredient - either a substance (simple ingredient) or another medication of a medication.", 0, 1, this.item);
                }
                case -748916528: {
                    return new Property("isActive", "boolean", "Indication of whether this ingredient affects the therapeutic action of the drug.", 0, 1, this.isActive);
                }
                case 1791316033: {
                    return new Property("strength", "Ratio", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet.", 0, 1, this.strength);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
                case -748916528: {
                    Base[] baseArray;
                    if (this.isActive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.isActive;
                    }
                    return baseArray;
                }
                case 1791316033: {
                    Base[] baseArray;
                    if (this.strength == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.strength;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = TypeConvertor.castToType(value);
                    return value;
                }
                case -748916528: {
                    this.isActive = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 1791316033: {
                    this.strength = TypeConvertor.castToRatio(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item[x]")) {
                this.item = TypeConvertor.castToType(value);
            } else if (name.equals("isActive")) {
                this.isActive = TypeConvertor.castToBoolean(value);
            } else if (name.equals("strength")) {
                this.strength = TypeConvertor.castToRatio(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2116201613: {
                    return this.getItem();
                }
                case 3242771: {
                    return this.getItem();
                }
                case -748916528: {
                    return this.getIsActiveElement();
                }
                case 1791316033: {
                    return this.getStrength();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case -748916528: {
                    return new String[]{"boolean"};
                }
                case 1791316033: {
                    return new String[]{"Ratio"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemCodeableConcept")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            if (name.equals("itemReference")) {
                this.item = new Reference();
                return this.item;
            }
            if (name.equals("isActive")) {
                throw new FHIRException("Cannot call addChild on a primitive type Medication.ingredient.isActive");
            }
            if (name.equals("strength")) {
                this.strength = new Ratio();
                return this.strength;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationIngredientComponent copy() {
            MedicationIngredientComponent dst = new MedicationIngredientComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationIngredientComponent dst) {
            super.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
            dst.isActive = this.isActive == null ? null : this.isActive.copy();
            dst.strength = this.strength == null ? null : this.strength.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationIngredientComponent)) {
                return false;
            }
            MedicationIngredientComponent o = (MedicationIngredientComponent)other_;
            return MedicationIngredientComponent.compareDeep(this.item, o.item, true) && MedicationIngredientComponent.compareDeep(this.isActive, o.isActive, true) && MedicationIngredientComponent.compareDeep(this.strength, o.strength, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationIngredientComponent)) {
                return false;
            }
            MedicationIngredientComponent o = (MedicationIngredientComponent)other_;
            return MedicationIngredientComponent.compareValues(this.isActive, o.isActive, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.item, this.isActive, this.strength});
        }

        @Override
        public String fhirType() {
            return "Medication.ingredient";
        }
    }

    public static class MedicationStatusCodesEnumFactory
    implements EnumFactory<MedicationStatusCodes> {
        @Override
        public MedicationStatusCodes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return MedicationStatusCodes.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return MedicationStatusCodes.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationStatusCodes.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown MedicationStatusCodes code '" + codeString + "'");
        }

        public Enumeration<MedicationStatusCodes> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationStatusCodes>(this, MedicationStatusCodes.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<MedicationStatusCodes>(this, MedicationStatusCodes.NULL, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<MedicationStatusCodes>(this, MedicationStatusCodes.ACTIVE, code);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<MedicationStatusCodes>(this, MedicationStatusCodes.INACTIVE, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationStatusCodes>(this, MedicationStatusCodes.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown MedicationStatusCodes code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationStatusCodes code) {
            if (code == MedicationStatusCodes.ACTIVE) {
                return "active";
            }
            if (code == MedicationStatusCodes.INACTIVE) {
                return "inactive";
            }
            if (code == MedicationStatusCodes.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationStatusCodes code) {
            return code.getSystem();
        }
    }

    public static enum MedicationStatusCodes {
        ACTIVE,
        INACTIVE,
        ENTEREDINERROR,
        NULL;


        public static MedicationStatusCodes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationStatusCodes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/CodeSystem/medication-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/CodeSystem/medication-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/CodeSystem/medication-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The medication is available for use.";
                }
                case INACTIVE: {
                    return "The medication is not available for use.";
                }
                case ENTEREDINERROR: {
                    return "The medication was entered in error.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

