/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.formats;

import org.hl7.fhir.r4b.formats.RdfParserBase;
import org.hl7.fhir.r4b.model.Account;
import org.hl7.fhir.r4b.model.ActivityDefinition;
import org.hl7.fhir.r4b.model.Address;
import org.hl7.fhir.r4b.model.AdministrableProductDefinition;
import org.hl7.fhir.r4b.model.AdverseEvent;
import org.hl7.fhir.r4b.model.Age;
import org.hl7.fhir.r4b.model.AllergyIntolerance;
import org.hl7.fhir.r4b.model.Annotation;
import org.hl7.fhir.r4b.model.Appointment;
import org.hl7.fhir.r4b.model.AppointmentResponse;
import org.hl7.fhir.r4b.model.Attachment;
import org.hl7.fhir.r4b.model.AuditEvent;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.BackboneType;
import org.hl7.fhir.r4b.model.Base64BinaryType;
import org.hl7.fhir.r4b.model.Basic;
import org.hl7.fhir.r4b.model.Binary;
import org.hl7.fhir.r4b.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r4b.model.BodyStructure;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.Bundle;
import org.hl7.fhir.r4b.model.CanonicalType;
import org.hl7.fhir.r4b.model.CapabilityStatement;
import org.hl7.fhir.r4b.model.CarePlan;
import org.hl7.fhir.r4b.model.CareTeam;
import org.hl7.fhir.r4b.model.CatalogEntry;
import org.hl7.fhir.r4b.model.ChargeItem;
import org.hl7.fhir.r4b.model.ChargeItemDefinition;
import org.hl7.fhir.r4b.model.Citation;
import org.hl7.fhir.r4b.model.Claim;
import org.hl7.fhir.r4b.model.ClaimResponse;
import org.hl7.fhir.r4b.model.ClinicalImpression;
import org.hl7.fhir.r4b.model.ClinicalUseDefinition;
import org.hl7.fhir.r4b.model.CodeSystem;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.CodeableReference;
import org.hl7.fhir.r4b.model.Coding;
import org.hl7.fhir.r4b.model.Communication;
import org.hl7.fhir.r4b.model.CommunicationRequest;
import org.hl7.fhir.r4b.model.CompartmentDefinition;
import org.hl7.fhir.r4b.model.Composition;
import org.hl7.fhir.r4b.model.ConceptMap;
import org.hl7.fhir.r4b.model.Condition;
import org.hl7.fhir.r4b.model.Consent;
import org.hl7.fhir.r4b.model.ContactDetail;
import org.hl7.fhir.r4b.model.ContactPoint;
import org.hl7.fhir.r4b.model.Contract;
import org.hl7.fhir.r4b.model.Contributor;
import org.hl7.fhir.r4b.model.Count;
import org.hl7.fhir.r4b.model.Coverage;
import org.hl7.fhir.r4b.model.CoverageEligibilityRequest;
import org.hl7.fhir.r4b.model.CoverageEligibilityResponse;
import org.hl7.fhir.r4b.model.DataRequirement;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.DateType;
import org.hl7.fhir.r4b.model.DecimalType;
import org.hl7.fhir.r4b.model.DetectedIssue;
import org.hl7.fhir.r4b.model.Device;
import org.hl7.fhir.r4b.model.DeviceDefinition;
import org.hl7.fhir.r4b.model.DeviceMetric;
import org.hl7.fhir.r4b.model.DeviceRequest;
import org.hl7.fhir.r4b.model.DeviceUseStatement;
import org.hl7.fhir.r4b.model.DiagnosticReport;
import org.hl7.fhir.r4b.model.Distance;
import org.hl7.fhir.r4b.model.DocumentManifest;
import org.hl7.fhir.r4b.model.DocumentReference;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.Dosage;
import org.hl7.fhir.r4b.model.Duration;
import org.hl7.fhir.r4b.model.Element;
import org.hl7.fhir.r4b.model.ElementDefinition;
import org.hl7.fhir.r4b.model.Encounter;
import org.hl7.fhir.r4b.model.Endpoint;
import org.hl7.fhir.r4b.model.EnrollmentRequest;
import org.hl7.fhir.r4b.model.EnrollmentResponse;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.EpisodeOfCare;
import org.hl7.fhir.r4b.model.EventDefinition;
import org.hl7.fhir.r4b.model.Evidence;
import org.hl7.fhir.r4b.model.EvidenceReport;
import org.hl7.fhir.r4b.model.EvidenceVariable;
import org.hl7.fhir.r4b.model.ExampleScenario;
import org.hl7.fhir.r4b.model.ExplanationOfBenefit;
import org.hl7.fhir.r4b.model.Expression;
import org.hl7.fhir.r4b.model.Extension;
import org.hl7.fhir.r4b.model.FamilyMemberHistory;
import org.hl7.fhir.r4b.model.Flag;
import org.hl7.fhir.r4b.model.Goal;
import org.hl7.fhir.r4b.model.GraphDefinition;
import org.hl7.fhir.r4b.model.Group;
import org.hl7.fhir.r4b.model.GuidanceResponse;
import org.hl7.fhir.r4b.model.HealthcareService;
import org.hl7.fhir.r4b.model.HumanName;
import org.hl7.fhir.r4b.model.IdType;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.ImagingStudy;
import org.hl7.fhir.r4b.model.Immunization;
import org.hl7.fhir.r4b.model.ImmunizationEvaluation;
import org.hl7.fhir.r4b.model.ImmunizationRecommendation;
import org.hl7.fhir.r4b.model.ImplementationGuide;
import org.hl7.fhir.r4b.model.Ingredient;
import org.hl7.fhir.r4b.model.InstantType;
import org.hl7.fhir.r4b.model.InsurancePlan;
import org.hl7.fhir.r4b.model.Integer64Type;
import org.hl7.fhir.r4b.model.IntegerType;
import org.hl7.fhir.r4b.model.Invoice;
import org.hl7.fhir.r4b.model.Library;
import org.hl7.fhir.r4b.model.Linkage;
import org.hl7.fhir.r4b.model.ListResource;
import org.hl7.fhir.r4b.model.Location;
import org.hl7.fhir.r4b.model.ManufacturedItemDefinition;
import org.hl7.fhir.r4b.model.MarkdownType;
import org.hl7.fhir.r4b.model.MarketingStatus;
import org.hl7.fhir.r4b.model.Measure;
import org.hl7.fhir.r4b.model.MeasureReport;
import org.hl7.fhir.r4b.model.Media;
import org.hl7.fhir.r4b.model.Medication;
import org.hl7.fhir.r4b.model.MedicationAdministration;
import org.hl7.fhir.r4b.model.MedicationDispense;
import org.hl7.fhir.r4b.model.MedicationKnowledge;
import org.hl7.fhir.r4b.model.MedicationRequest;
import org.hl7.fhir.r4b.model.MedicationStatement;
import org.hl7.fhir.r4b.model.MedicinalProductDefinition;
import org.hl7.fhir.r4b.model.MessageDefinition;
import org.hl7.fhir.r4b.model.MessageHeader;
import org.hl7.fhir.r4b.model.Meta;
import org.hl7.fhir.r4b.model.MolecularSequence;
import org.hl7.fhir.r4b.model.Money;
import org.hl7.fhir.r4b.model.NamingSystem;
import org.hl7.fhir.r4b.model.Narrative;
import org.hl7.fhir.r4b.model.NutritionOrder;
import org.hl7.fhir.r4b.model.NutritionProduct;
import org.hl7.fhir.r4b.model.Observation;
import org.hl7.fhir.r4b.model.ObservationDefinition;
import org.hl7.fhir.r4b.model.OidType;
import org.hl7.fhir.r4b.model.OperationDefinition;
import org.hl7.fhir.r4b.model.OperationOutcome;
import org.hl7.fhir.r4b.model.Organization;
import org.hl7.fhir.r4b.model.OrganizationAffiliation;
import org.hl7.fhir.r4b.model.PackagedProductDefinition;
import org.hl7.fhir.r4b.model.ParameterDefinition;
import org.hl7.fhir.r4b.model.Parameters;
import org.hl7.fhir.r4b.model.Patient;
import org.hl7.fhir.r4b.model.PaymentNotice;
import org.hl7.fhir.r4b.model.PaymentReconciliation;
import org.hl7.fhir.r4b.model.Period;
import org.hl7.fhir.r4b.model.Person;
import org.hl7.fhir.r4b.model.PlanDefinition;
import org.hl7.fhir.r4b.model.Population;
import org.hl7.fhir.r4b.model.PositiveIntType;
import org.hl7.fhir.r4b.model.Practitioner;
import org.hl7.fhir.r4b.model.PractitionerRole;
import org.hl7.fhir.r4b.model.Procedure;
import org.hl7.fhir.r4b.model.ProdCharacteristic;
import org.hl7.fhir.r4b.model.ProductShelfLife;
import org.hl7.fhir.r4b.model.Provenance;
import org.hl7.fhir.r4b.model.Quantity;
import org.hl7.fhir.r4b.model.Questionnaire;
import org.hl7.fhir.r4b.model.QuestionnaireResponse;
import org.hl7.fhir.r4b.model.Range;
import org.hl7.fhir.r4b.model.Ratio;
import org.hl7.fhir.r4b.model.RatioRange;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.RegulatedAuthorization;
import org.hl7.fhir.r4b.model.RelatedArtifact;
import org.hl7.fhir.r4b.model.RelatedPerson;
import org.hl7.fhir.r4b.model.RequestGroup;
import org.hl7.fhir.r4b.model.ResearchDefinition;
import org.hl7.fhir.r4b.model.ResearchElementDefinition;
import org.hl7.fhir.r4b.model.ResearchStudy;
import org.hl7.fhir.r4b.model.ResearchSubject;
import org.hl7.fhir.r4b.model.Resource;
import org.hl7.fhir.r4b.model.RiskAssessment;
import org.hl7.fhir.r4b.model.SampledData;
import org.hl7.fhir.r4b.model.Schedule;
import org.hl7.fhir.r4b.model.SearchParameter;
import org.hl7.fhir.r4b.model.ServiceRequest;
import org.hl7.fhir.r4b.model.Signature;
import org.hl7.fhir.r4b.model.Slot;
import org.hl7.fhir.r4b.model.Specimen;
import org.hl7.fhir.r4b.model.SpecimenDefinition;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.r4b.model.StructureMap;
import org.hl7.fhir.r4b.model.Subscription;
import org.hl7.fhir.r4b.model.SubscriptionStatus;
import org.hl7.fhir.r4b.model.SubscriptionTopic;
import org.hl7.fhir.r4b.model.Substance;
import org.hl7.fhir.r4b.model.SubstanceDefinition;
import org.hl7.fhir.r4b.model.SupplyDelivery;
import org.hl7.fhir.r4b.model.SupplyRequest;
import org.hl7.fhir.r4b.model.Task;
import org.hl7.fhir.r4b.model.TerminologyCapabilities;
import org.hl7.fhir.r4b.model.TestReport;
import org.hl7.fhir.r4b.model.TestScript;
import org.hl7.fhir.r4b.model.TimeType;
import org.hl7.fhir.r4b.model.Timing;
import org.hl7.fhir.r4b.model.TriggerDefinition;
import org.hl7.fhir.r4b.model.UnsignedIntType;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.model.UrlType;
import org.hl7.fhir.r4b.model.UsageContext;
import org.hl7.fhir.r4b.model.UuidType;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r4b.model.VerificationResult;
import org.hl7.fhir.r4b.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.turtle.Turtle;

public class RdfParser
extends RdfParserBase {
    public RdfParser() {
    }

    public RdfParser(boolean allowUnknownContent) {
        this.setAllowUnknownContent(allowUnknownContent);
    }

    private void composeEnum(Turtle.Complex parent, String parentType, String name, Enumeration<? extends Enum> value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
        this.decorateCode(t, value);
    }

    protected void composeDate(Turtle.Complex parent, String parentType, String name, DateType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeDateTime(Turtle.Complex parent, String parentType, String name, DateTimeType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeCode(Turtle.Complex parent, String parentType, String name, CodeType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
        this.decorateCode(t, value);
    }

    protected void composeString(Turtle.Complex parent, String parentType, String name, StringType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeInteger(Turtle.Complex parent, String parentType, String name, IntegerType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeInteger64(Turtle.Complex parent, String parentType, String name, Integer64Type value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeOid(Turtle.Complex parent, String parentType, String name, OidType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeCanonical(Turtle.Complex parent, String parentType, String name, CanonicalType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUri(Turtle.Complex parent, String parentType, String name, UriType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUuid(Turtle.Complex parent, String parentType, String name, UuidType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUrl(Turtle.Complex parent, String parentType, String name, UrlType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeInstant(Turtle.Complex parent, String parentType, String name, InstantType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeBoolean(Turtle.Complex parent, String parentType, String name, BooleanType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeBase64Binary(Turtle.Complex parent, String parentType, String name, Base64BinaryType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUnsignedInt(Turtle.Complex parent, String parentType, String name, UnsignedIntType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeMarkdown(Turtle.Complex parent, String parentType, String name, MarkdownType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeTime(Turtle.Complex parent, String parentType, String name, TimeType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeId(Turtle.Complex parent, String parentType, String name, IdType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composePositiveInt(Turtle.Complex parent, String parentType, String name, PositiveIntType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeDecimal(Turtle.Complex parent, String parentType, String name, DecimalType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeElement(Turtle.Complex t, String parentType, String name, Element element, int index) {
        if (element.hasIdElement()) {
            this.composeString(t, "Element", "id", element.getIdElement(), -1);
        }
        for (int i = 0; i < element.getExtension().size(); ++i) {
            this.composeExtension(t, "Element", "extension", element.getExtension().get(i), i);
        }
    }

    protected void composeBackboneElement(Turtle.Complex t, String parentType, String name, BackboneElement element, int index) {
        this.composeDataType(t, parentType, name, element, index);
        for (int i = 0; i < element.getModifierExtension().size(); ++i) {
            this.composeExtension(t, "BackboneElement", "modifierExtension", element.getModifierExtension().get(i), i);
        }
    }

    protected void composeDataType(Turtle.Complex t, String parentType, String name, DataType element, int index) {
        this.composeElement(t, parentType, name, element, index);
    }

    protected void composeBackboneType(Turtle.Complex t, String parentType, String name, BackboneType element, int index) {
        this.composeDataType(t, parentType, name, element, index);
        for (int i = 0; i < element.getModifierExtension().size(); ++i) {
            this.composeExtension(t, "BackboneElement", "modifierExtension", element.getModifierExtension().get(i), i);
        }
    }

    protected void composeAddress(Turtle.Complex parent, String parentType, String name, Address element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Address", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "Address", "use", element.getUseElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Address", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Address", "text", element.getTextElement(), -1);
        }
        for (int i = 0; i < element.getLine().size(); ++i) {
            this.composeString(t, "Address", "line", element.getLine().get(i), i);
        }
        if (element.hasCityElement()) {
            this.composeString(t, "Address", "city", element.getCityElement(), -1);
        }
        if (element.hasDistrictElement()) {
            this.composeString(t, "Address", "district", element.getDistrictElement(), -1);
        }
        if (element.hasStateElement()) {
            this.composeString(t, "Address", "state", element.getStateElement(), -1);
        }
        if (element.hasPostalCodeElement()) {
            this.composeString(t, "Address", "postalCode", element.getPostalCodeElement(), -1);
        }
        if (element.hasCountryElement()) {
            this.composeString(t, "Address", "country", element.getCountryElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Address", "period", element.getPeriod(), -1);
        }
    }

    protected void composeAge(Turtle.Complex parent, String parentType, String name, Age element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeQuantity(t, "Age", name, element, index);
    }

    protected void composeAnnotation(Turtle.Complex parent, String parentType, String name, Annotation element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Annotation", name, element, index);
        if (element.hasAuthor()) {
            this.composeType(t, "Annotation", "author", element.getAuthor(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeDateTime(t, "Annotation", "time", element.getTimeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeMarkdown(t, "Annotation", "text", element.getTextElement(), -1);
        }
    }

    protected void composeAttachment(Turtle.Complex parent, String parentType, String name, Attachment element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Attachment", name, element, index);
        if (element.hasContentTypeElement()) {
            this.composeCode(t, "Attachment", "contentType", element.getContentTypeElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "Attachment", "language", element.getLanguageElement(), -1);
        }
        if (element.hasDataElement()) {
            this.composeBase64Binary(t, "Attachment", "data", element.getDataElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUrl(t, "Attachment", "url", element.getUrlElement(), -1);
        }
        if (element.hasSizeElement()) {
            this.composeUnsignedInt(t, "Attachment", "size", element.getSizeElement(), -1);
        }
        if (element.hasHashElement()) {
            this.composeBase64Binary(t, "Attachment", "hash", element.getHashElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Attachment", "title", element.getTitleElement(), -1);
        }
        if (element.hasCreationElement()) {
            this.composeDateTime(t, "Attachment", "creation", element.getCreationElement(), -1);
        }
    }

    protected void composeCodeableConcept(Turtle.Complex parent, String parentType, String name, CodeableConcept element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "CodeableConcept", name, element, index);
        this.decorateCodeableConcept(t, element);
        for (int i = 0; i < element.getCoding().size(); ++i) {
            this.composeCoding(t, "CodeableConcept", "coding", element.getCoding().get(i), i);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "CodeableConcept", "text", element.getTextElement(), -1);
        }
    }

    protected void composeCodeableReference(Turtle.Complex parent, String parentType, String name, CodeableReference element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "CodeableReference", name, element, index);
        if (element.hasConcept()) {
            this.composeCodeableConcept(t, "CodeableReference", "concept", element.getConcept(), -1);
        }
        if (element.hasReference()) {
            this.composeReference(t, "CodeableReference", "reference", element.getReference(), -1);
        }
    }

    protected void composeCoding(Turtle.Complex parent, String parentType, String name, Coding element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Coding", name, element, index);
        this.decorateCoding(t, element);
        if (element.hasSystemElement()) {
            this.composeUri(t, "Coding", "system", element.getSystemElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Coding", "version", element.getVersionElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "Coding", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "Coding", "display", element.getDisplayElement(), -1);
        }
        if (element.hasUserSelectedElement()) {
            this.composeBoolean(t, "Coding", "userSelected", element.getUserSelectedElement(), -1);
        }
    }

    protected void composeContactDetail(Turtle.Complex parent, String parentType, String name, ContactDetail element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "ContactDetail", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ContactDetail", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "ContactDetail", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeContactPoint(Turtle.Complex parent, String parentType, String name, ContactPoint element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "ContactPoint", name, element, index);
        if (element.hasSystemElement()) {
            this.composeEnum(t, "ContactPoint", "system", element.getSystemElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ContactPoint", "value", element.getValueElement(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ContactPoint", "use", element.getUseElement(), -1);
        }
        if (element.hasRankElement()) {
            this.composePositiveInt(t, "ContactPoint", "rank", element.getRankElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ContactPoint", "period", element.getPeriod(), -1);
        }
    }

    protected void composeContributor(Turtle.Complex parent, String parentType, String name, Contributor element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Contributor", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Contributor", "type", element.getTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Contributor", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "Contributor", "contact", element.getContact().get(i), i);
        }
    }

    protected void composeCount(Turtle.Complex parent, String parentType, String name, Count element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeQuantity(t, "Count", name, element, index);
    }

    protected void composeDataRequirement(Turtle.Complex parent, String parentType, String name, DataRequirement element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "DataRequirement", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "DataRequirement", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getProfile().size(); ++i) {
            this.composeCanonical(t, "DataRequirement", "profile", element.getProfile().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeType(t, "DataRequirement", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getMustSupport().size(); ++i) {
            this.composeString(t, "DataRequirement", "mustSupport", element.getMustSupport().get(i), i);
        }
        for (i = 0; i < element.getCodeFilter().size(); ++i) {
            this.composeDataRequirementCodeFilterComponent(t, "DataRequirement", "codeFilter", element.getCodeFilter().get(i), i);
        }
        for (i = 0; i < element.getDateFilter().size(); ++i) {
            this.composeDataRequirementDateFilterComponent(t, "DataRequirement", "dateFilter", element.getDateFilter().get(i), i);
        }
        if (element.hasLimitElement()) {
            this.composePositiveInt(t, "DataRequirement", "limit", element.getLimitElement(), -1);
        }
        for (i = 0; i < element.getSort().size(); ++i) {
            this.composeDataRequirementSortComponent(t, "DataRequirement", "sort", element.getSort().get(i), i);
        }
    }

    protected void composeDataRequirementCodeFilterComponent(Turtle.Complex parent, String parentType, String name, DataRequirement.DataRequirementCodeFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "codeFilter", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "DataRequirementCodeFilterComponent", "path", element.getPathElement(), -1);
        }
        if (element.hasSearchParamElement()) {
            this.composeString(t, "DataRequirementCodeFilterComponent", "searchParam", element.getSearchParamElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "DataRequirementCodeFilterComponent", "valueSet", element.getValueSetElement(), -1);
        }
        for (int i = 0; i < element.getCode().size(); ++i) {
            this.composeCoding(t, "DataRequirementCodeFilterComponent", "code", element.getCode().get(i), i);
        }
    }

    protected void composeDataRequirementDateFilterComponent(Turtle.Complex parent, String parentType, String name, DataRequirement.DataRequirementDateFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "dateFilter", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "DataRequirementDateFilterComponent", "path", element.getPathElement(), -1);
        }
        if (element.hasSearchParamElement()) {
            this.composeString(t, "DataRequirementDateFilterComponent", "searchParam", element.getSearchParamElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "DataRequirementDateFilterComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeDataRequirementSortComponent(Turtle.Complex parent, String parentType, String name, DataRequirement.DataRequirementSortComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "sort", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "DataRequirementSortComponent", "path", element.getPathElement(), -1);
        }
        if (element.hasDirectionElement()) {
            this.composeEnum(t, "DataRequirementSortComponent", "direction", element.getDirectionElement(), -1);
        }
    }

    protected void composeDistance(Turtle.Complex parent, String parentType, String name, Distance element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeQuantity(t, "Distance", name, element, index);
    }

    protected void composeDosage(Turtle.Complex parent, String parentType, String name, Dosage element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneType(t, "Dosage", name, element, index);
        if (element.hasSequenceElement()) {
            this.composeInteger(t, "Dosage", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Dosage", "text", element.getTextElement(), -1);
        }
        for (i = 0; i < element.getAdditionalInstruction().size(); ++i) {
            this.composeCodeableConcept(t, "Dosage", "additionalInstruction", element.getAdditionalInstruction().get(i), i);
        }
        if (element.hasPatientInstructionElement()) {
            this.composeString(t, "Dosage", "patientInstruction", element.getPatientInstructionElement(), -1);
        }
        if (element.hasTiming()) {
            this.composeTiming(t, "Dosage", "timing", element.getTiming(), -1);
        }
        if (element.hasAsNeeded()) {
            this.composeType(t, "Dosage", "asNeeded", element.getAsNeeded(), -1);
        }
        if (element.hasSite()) {
            this.composeCodeableConcept(t, "Dosage", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "Dosage", "route", element.getRoute(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "Dosage", "method", element.getMethod(), -1);
        }
        for (i = 0; i < element.getDoseAndRate().size(); ++i) {
            this.composeDosageDoseAndRateComponent(t, "Dosage", "doseAndRate", element.getDoseAndRate().get(i), i);
        }
        if (element.hasMaxDosePerPeriod()) {
            this.composeRatio(t, "Dosage", "maxDosePerPeriod", element.getMaxDosePerPeriod(), -1);
        }
        if (element.hasMaxDosePerAdministration()) {
            this.composeQuantity(t, "Dosage", "maxDosePerAdministration", element.getMaxDosePerAdministration(), -1);
        }
        if (element.hasMaxDosePerLifetime()) {
            this.composeQuantity(t, "Dosage", "maxDosePerLifetime", element.getMaxDosePerLifetime(), -1);
        }
    }

    protected void composeDosageDoseAndRateComponent(Turtle.Complex parent, String parentType, String name, Dosage.DosageDoseAndRateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "doseAndRate", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DosageDoseAndRateComponent", "type", element.getType(), -1);
        }
        if (element.hasDose()) {
            this.composeType(t, "DosageDoseAndRateComponent", "dose", element.getDose(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "DosageDoseAndRateComponent", "rate", element.getRate(), -1);
        }
    }

    protected void composeDuration(Turtle.Complex parent, String parentType, String name, Duration element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeQuantity(t, "Duration", name, element, index);
    }

    protected void composeElementDefinition(Turtle.Complex parent, String parentType, String name, ElementDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneType(t, "ElementDefinition", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "ElementDefinition", "path", element.getPathElement(), -1);
        }
        for (i = 0; i < element.getRepresentation().size(); ++i) {
            this.composeEnum(t, "ElementDefinition", "representation", element.getRepresentation().get(i), i);
        }
        if (element.hasSliceNameElement()) {
            this.composeString(t, "ElementDefinition", "sliceName", element.getSliceNameElement(), -1);
        }
        if (element.hasSliceIsConstrainingElement()) {
            this.composeBoolean(t, "ElementDefinition", "sliceIsConstraining", element.getSliceIsConstrainingElement(), -1);
        }
        if (element.hasLabelElement()) {
            this.composeString(t, "ElementDefinition", "label", element.getLabelElement(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCoding(t, "ElementDefinition", "code", element.getCode().get(i), i);
        }
        if (element.hasSlicing()) {
            this.composeElementDefinitionSlicingComponent(t, "ElementDefinition", "slicing", element.getSlicing(), -1);
        }
        if (element.hasShortElement()) {
            this.composeString(t, "ElementDefinition", "short", element.getShortElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeMarkdown(t, "ElementDefinition", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeMarkdown(t, "ElementDefinition", "comment", element.getCommentElement(), -1);
        }
        if (element.hasRequirementsElement()) {
            this.composeMarkdown(t, "ElementDefinition", "requirements", element.getRequirementsElement(), -1);
        }
        for (i = 0; i < element.getAlias().size(); ++i) {
            this.composeString(t, "ElementDefinition", "alias", element.getAlias().get(i), i);
        }
        if (element.hasMinElement()) {
            this.composeUnsignedInt(t, "ElementDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "ElementDefinition", "max", element.getMaxElement(), -1);
        }
        if (element.hasBase()) {
            this.composeElementDefinitionBaseComponent(t, "ElementDefinition", "base", element.getBase(), -1);
        }
        if (element.hasContentReferenceElement()) {
            this.composeUri(t, "ElementDefinition", "contentReference", element.getContentReferenceElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeElementDefinitionTypeRefComponent(t, "ElementDefinition", "type", element.getType().get(i), i);
        }
        if (element.hasDefaultValue()) {
            this.composeType(t, "ElementDefinition", "defaultValue", element.getDefaultValue(), -1);
        }
        if (element.hasMeaningWhenMissingElement()) {
            this.composeMarkdown(t, "ElementDefinition", "meaningWhenMissing", element.getMeaningWhenMissingElement(), -1);
        }
        if (element.hasOrderMeaningElement()) {
            this.composeString(t, "ElementDefinition", "orderMeaning", element.getOrderMeaningElement(), -1);
        }
        if (element.hasFixed()) {
            this.composeType(t, "ElementDefinition", "fixed", element.getFixed(), -1);
        }
        if (element.hasPattern()) {
            this.composeType(t, "ElementDefinition", "pattern", element.getPattern(), -1);
        }
        for (i = 0; i < element.getExample().size(); ++i) {
            this.composeElementDefinitionExampleComponent(t, "ElementDefinition", "example", element.getExample().get(i), i);
        }
        if (element.hasMinValue()) {
            this.composeType(t, "ElementDefinition", "minValue", element.getMinValue(), -1);
        }
        if (element.hasMaxValue()) {
            this.composeType(t, "ElementDefinition", "maxValue", element.getMaxValue(), -1);
        }
        if (element.hasMaxLengthElement()) {
            this.composeInteger(t, "ElementDefinition", "maxLength", element.getMaxLengthElement(), -1);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeId(t, "ElementDefinition", "condition", element.getCondition().get(i), i);
        }
        for (i = 0; i < element.getConstraint().size(); ++i) {
            this.composeElementDefinitionConstraintComponent(t, "ElementDefinition", "constraint", element.getConstraint().get(i), i);
        }
        if (element.hasMustSupportElement()) {
            this.composeBoolean(t, "ElementDefinition", "mustSupport", element.getMustSupportElement(), -1);
        }
        if (element.hasIsModifierElement()) {
            this.composeBoolean(t, "ElementDefinition", "isModifier", element.getIsModifierElement(), -1);
        }
        if (element.hasIsModifierReasonElement()) {
            this.composeString(t, "ElementDefinition", "isModifierReason", element.getIsModifierReasonElement(), -1);
        }
        if (element.hasIsSummaryElement()) {
            this.composeBoolean(t, "ElementDefinition", "isSummary", element.getIsSummaryElement(), -1);
        }
        if (element.hasBinding()) {
            this.composeElementDefinitionBindingComponent(t, "ElementDefinition", "binding", element.getBinding(), -1);
        }
        for (i = 0; i < element.getMapping().size(); ++i) {
            this.composeElementDefinitionMappingComponent(t, "ElementDefinition", "mapping", element.getMapping().get(i), i);
        }
    }

    protected void composeElementDefinitionSlicingComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionSlicingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "slicing", name, element, index);
        for (int i = 0; i < element.getDiscriminator().size(); ++i) {
            this.composeElementDefinitionSlicingDiscriminatorComponent(t, "ElementDefinitionSlicingComponent", "discriminator", element.getDiscriminator().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ElementDefinitionSlicingComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasOrderedElement()) {
            this.composeBoolean(t, "ElementDefinitionSlicingComponent", "ordered", element.getOrderedElement(), -1);
        }
        if (element.hasRulesElement()) {
            this.composeEnum(t, "ElementDefinitionSlicingComponent", "rules", element.getRulesElement(), -1);
        }
    }

    protected void composeElementDefinitionSlicingDiscriminatorComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "discriminator", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ElementDefinitionSlicingDiscriminatorComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasPathElement()) {
            this.composeString(t, "ElementDefinitionSlicingDiscriminatorComponent", "path", element.getPathElement(), -1);
        }
    }

    protected void composeElementDefinitionBaseComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionBaseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "base", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "ElementDefinitionBaseComponent", "path", element.getPathElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeUnsignedInt(t, "ElementDefinitionBaseComponent", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "ElementDefinitionBaseComponent", "max", element.getMaxElement(), -1);
        }
    }

    protected void composeElementDefinitionTypeRefComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.TypeRefComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "type", name, element, index);
        if (element.hasCodeElement()) {
            this.composeUri(t, "TypeRefComponent", "code", element.getCodeElement(), -1);
        }
        for (i = 0; i < element.getProfile().size(); ++i) {
            this.composeCanonical(t, "TypeRefComponent", "profile", element.getProfile().get(i), i);
        }
        for (i = 0; i < element.getTargetProfile().size(); ++i) {
            this.composeCanonical(t, "TypeRefComponent", "targetProfile", element.getTargetProfile().get(i), i);
        }
        for (i = 0; i < element.getAggregation().size(); ++i) {
            this.composeEnum(t, "TypeRefComponent", "aggregation", element.getAggregation().get(i), i);
        }
        if (element.hasVersioningElement()) {
            this.composeEnum(t, "TypeRefComponent", "versioning", element.getVersioningElement(), -1);
        }
    }

    protected void composeElementDefinitionExampleComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionExampleComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "example", name, element, index);
        if (element.hasLabelElement()) {
            this.composeString(t, "ElementDefinitionExampleComponent", "label", element.getLabelElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ElementDefinitionExampleComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeElementDefinitionConstraintComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionConstraintComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "constraint", name, element, index);
        if (element.hasKeyElement()) {
            this.composeId(t, "ElementDefinitionConstraintComponent", "key", element.getKeyElement(), -1);
        }
        if (element.hasRequirementsElement()) {
            this.composeString(t, "ElementDefinitionConstraintComponent", "requirements", element.getRequirementsElement(), -1);
        }
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "ElementDefinitionConstraintComponent", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasHumanElement()) {
            this.composeString(t, "ElementDefinitionConstraintComponent", "human", element.getHumanElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "ElementDefinitionConstraintComponent", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasXpathElement()) {
            this.composeString(t, "ElementDefinitionConstraintComponent", "xpath", element.getXpathElement(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeCanonical(t, "ElementDefinitionConstraintComponent", "source", element.getSourceElement(), -1);
        }
    }

    protected void composeElementDefinitionBindingComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionBindingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "binding", name, element, index);
        if (element.hasStrengthElement()) {
            this.composeEnum(t, "ElementDefinitionBindingComponent", "strength", element.getStrengthElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ElementDefinitionBindingComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "ElementDefinitionBindingComponent", "valueSet", element.getValueSetElement(), -1);
        }
    }

    protected void composeElementDefinitionMappingComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionMappingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "mapping", name, element, index);
        if (element.hasIdentityElement()) {
            this.composeId(t, "ElementDefinitionMappingComponent", "identity", element.getIdentityElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "ElementDefinitionMappingComponent", "language", element.getLanguageElement(), -1);
        }
        if (element.hasMapElement()) {
            this.composeString(t, "ElementDefinitionMappingComponent", "map", element.getMapElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "ElementDefinitionMappingComponent", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeExpression(Turtle.Complex parent, String parentType, String name, Expression element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Expression", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Expression", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeId(t, "Expression", "name", element.getNameElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "Expression", "language", element.getLanguageElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "Expression", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasReferenceElement()) {
            this.composeUri(t, "Expression", "reference", element.getReferenceElement(), -1);
        }
    }

    protected void composeExtension(Turtle.Complex parent, String parentType, String name, Extension element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Extension", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Extension", "url", element.getUrlElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Extension", "value", element.getValue(), -1);
        }
    }

    protected void composeHumanName(Turtle.Complex parent, String parentType, String name, HumanName element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "HumanName", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "HumanName", "use", element.getUseElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "HumanName", "text", element.getTextElement(), -1);
        }
        if (element.hasFamilyElement()) {
            this.composeString(t, "HumanName", "family", element.getFamilyElement(), -1);
        }
        for (i = 0; i < element.getGiven().size(); ++i) {
            this.composeString(t, "HumanName", "given", element.getGiven().get(i), i);
        }
        for (i = 0; i < element.getPrefix().size(); ++i) {
            this.composeString(t, "HumanName", "prefix", element.getPrefix().get(i), i);
        }
        for (i = 0; i < element.getSuffix().size(); ++i) {
            this.composeString(t, "HumanName", "suffix", element.getSuffix().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "HumanName", "period", element.getPeriod(), -1);
        }
    }

    protected void composeIdentifier(Turtle.Complex parent, String parentType, String name, Identifier element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Identifier", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "Identifier", "use", element.getUseElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Identifier", "type", element.getType(), -1);
        }
        if (element.hasSystemElement()) {
            this.composeUri(t, "Identifier", "system", element.getSystemElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "Identifier", "value", element.getValueElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Identifier", "period", element.getPeriod(), -1);
        }
        if (element.hasAssigner()) {
            this.composeReference(t, "Identifier", "assigner", element.getAssigner(), -1);
        }
    }

    protected void composeMarketingStatus(Turtle.Complex parent, String parentType, String name, MarketingStatus element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneType(t, "MarketingStatus", name, element, index);
        if (element.hasCountry()) {
            this.composeCodeableConcept(t, "MarketingStatus", "country", element.getCountry(), -1);
        }
        if (element.hasJurisdiction()) {
            this.composeCodeableConcept(t, "MarketingStatus", "jurisdiction", element.getJurisdiction(), -1);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "MarketingStatus", "status", element.getStatus(), -1);
        }
        if (element.hasDateRange()) {
            this.composePeriod(t, "MarketingStatus", "dateRange", element.getDateRange(), -1);
        }
        if (element.hasRestoreDateElement()) {
            this.composeDateTime(t, "MarketingStatus", "restoreDate", element.getRestoreDateElement(), -1);
        }
    }

    protected void composeMeta(Turtle.Complex parent, String parentType, String name, Meta element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Meta", name, element, index);
        if (element.hasVersionIdElement()) {
            this.composeId(t, "Meta", "versionId", element.getVersionIdElement(), -1);
        }
        if (element.hasLastUpdatedElement()) {
            this.composeInstant(t, "Meta", "lastUpdated", element.getLastUpdatedElement(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeUri(t, "Meta", "source", element.getSourceElement(), -1);
        }
        for (i = 0; i < element.getProfile().size(); ++i) {
            this.composeCanonical(t, "Meta", "profile", element.getProfile().get(i), i);
        }
        for (i = 0; i < element.getSecurity().size(); ++i) {
            this.composeCoding(t, "Meta", "security", element.getSecurity().get(i), i);
        }
        for (i = 0; i < element.getTag().size(); ++i) {
            this.composeCoding(t, "Meta", "tag", element.getTag().get(i), i);
        }
    }

    protected void composeMoney(Turtle.Complex parent, String parentType, String name, Money element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Money", name, element, index);
        if (element.hasValueElement()) {
            this.composeDecimal(t, "Money", "value", element.getValueElement(), -1);
        }
        if (element.hasCurrencyElement()) {
            this.composeCode(t, "Money", "currency", element.getCurrencyElement(), -1);
        }
    }

    protected void composeNarrative(Turtle.Complex parent, String parentType, String name, Narrative element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Narrative", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Narrative", "status", element.getStatusElement(), -1);
        }
        if (element.hasDiv()) {
            this.composeXhtmlNode(t, "Narrative", "div", element.getDiv(), -1);
        }
    }

    protected void composeParameterDefinition(Turtle.Complex parent, String parentType, String name, ParameterDefinition element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "ParameterDefinition", name, element, index);
        if (element.hasNameElement()) {
            this.composeCode(t, "ParameterDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ParameterDefinition", "use", element.getUseElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "ParameterDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "ParameterDefinition", "max", element.getMaxElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "ParameterDefinition", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ParameterDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "ParameterDefinition", "profile", element.getProfileElement(), -1);
        }
    }

    protected void composePeriod(Turtle.Complex parent, String parentType, String name, Period element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Period", name, element, index);
        if (element.hasStartElement()) {
            this.composeDateTime(t, "Period", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeDateTime(t, "Period", "end", element.getEndElement(), -1);
        }
    }

    protected void composePopulation(Turtle.Complex parent, String parentType, String name, Population element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneType(t, "Population", name, element, index);
        if (element.hasAge()) {
            this.composeType(t, "Population", "age", element.getAge(), -1);
        }
        if (element.hasGender()) {
            this.composeCodeableConcept(t, "Population", "gender", element.getGender(), -1);
        }
        if (element.hasRace()) {
            this.composeCodeableConcept(t, "Population", "race", element.getRace(), -1);
        }
        if (element.hasPhysiologicalCondition()) {
            this.composeCodeableConcept(t, "Population", "physiologicalCondition", element.getPhysiologicalCondition(), -1);
        }
    }

    protected void composeProdCharacteristic(Turtle.Complex parent, String parentType, String name, ProdCharacteristic element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneType(t, "ProdCharacteristic", name, element, index);
        if (element.hasHeight()) {
            this.composeQuantity(t, "ProdCharacteristic", "height", element.getHeight(), -1);
        }
        if (element.hasWidth()) {
            this.composeQuantity(t, "ProdCharacteristic", "width", element.getWidth(), -1);
        }
        if (element.hasDepth()) {
            this.composeQuantity(t, "ProdCharacteristic", "depth", element.getDepth(), -1);
        }
        if (element.hasWeight()) {
            this.composeQuantity(t, "ProdCharacteristic", "weight", element.getWeight(), -1);
        }
        if (element.hasNominalVolume()) {
            this.composeQuantity(t, "ProdCharacteristic", "nominalVolume", element.getNominalVolume(), -1);
        }
        if (element.hasExternalDiameter()) {
            this.composeQuantity(t, "ProdCharacteristic", "externalDiameter", element.getExternalDiameter(), -1);
        }
        if (element.hasShapeElement()) {
            this.composeString(t, "ProdCharacteristic", "shape", element.getShapeElement(), -1);
        }
        for (i = 0; i < element.getColor().size(); ++i) {
            this.composeString(t, "ProdCharacteristic", "color", element.getColor().get(i), i);
        }
        for (i = 0; i < element.getImprint().size(); ++i) {
            this.composeString(t, "ProdCharacteristic", "imprint", element.getImprint().get(i), i);
        }
        for (i = 0; i < element.getImage().size(); ++i) {
            this.composeAttachment(t, "ProdCharacteristic", "image", element.getImage().get(i), i);
        }
        if (element.hasScoring()) {
            this.composeCodeableConcept(t, "ProdCharacteristic", "scoring", element.getScoring(), -1);
        }
    }

    protected void composeProductShelfLife(Turtle.Complex parent, String parentType, String name, ProductShelfLife element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneType(t, "ProductShelfLife", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ProductShelfLife", "type", element.getType(), -1);
        }
        if (element.hasPeriod()) {
            this.composeType(t, "ProductShelfLife", "period", element.getPeriod(), -1);
        }
        for (int i = 0; i < element.getSpecialPrecautionsForStorage().size(); ++i) {
            this.composeCodeableConcept(t, "ProductShelfLife", "specialPrecautionsForStorage", element.getSpecialPrecautionsForStorage().get(i), i);
        }
    }

    protected void composeQuantity(Turtle.Complex parent, String parentType, String name, Quantity element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Quantity", name, element, index);
        if (element.hasValueElement()) {
            this.composeDecimal(t, "Quantity", "value", element.getValueElement(), -1);
        }
        if (element.hasComparatorElement()) {
            this.composeEnum(t, "Quantity", "comparator", element.getComparatorElement(), -1);
        }
        if (element.hasUnitElement()) {
            this.composeString(t, "Quantity", "unit", element.getUnitElement(), -1);
        }
        if (element.hasSystemElement()) {
            this.composeUri(t, "Quantity", "system", element.getSystemElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "Quantity", "code", element.getCodeElement(), -1);
        }
    }

    protected void composeRange(Turtle.Complex parent, String parentType, String name, Range element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Range", name, element, index);
        if (element.hasLow()) {
            this.composeQuantity(t, "Range", "low", element.getLow(), -1);
        }
        if (element.hasHigh()) {
            this.composeQuantity(t, "Range", "high", element.getHigh(), -1);
        }
    }

    protected void composeRatio(Turtle.Complex parent, String parentType, String name, Ratio element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Ratio", name, element, index);
        if (element.hasNumerator()) {
            this.composeQuantity(t, "Ratio", "numerator", element.getNumerator(), -1);
        }
        if (element.hasDenominator()) {
            this.composeQuantity(t, "Ratio", "denominator", element.getDenominator(), -1);
        }
    }

    protected void composeRatioRange(Turtle.Complex parent, String parentType, String name, RatioRange element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "RatioRange", name, element, index);
        if (element.hasLowNumerator()) {
            this.composeQuantity(t, "RatioRange", "lowNumerator", element.getLowNumerator(), -1);
        }
        if (element.hasHighNumerator()) {
            this.composeQuantity(t, "RatioRange", "highNumerator", element.getHighNumerator(), -1);
        }
        if (element.hasDenominator()) {
            this.composeQuantity(t, "RatioRange", "denominator", element.getDenominator(), -1);
        }
    }

    protected void composeReference(Turtle.Complex parent, String parentType, String name, Reference element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Reference", name, element, index);
        if (element.hasReferenceElement()) {
            this.composeString(t, "Reference", "reference", element.getReferenceElement_(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeUri(t, "Reference", "type", element.getTypeElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Reference", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "Reference", "display", element.getDisplayElement(), -1);
        }
    }

    protected void composeRelatedArtifact(Turtle.Complex parent, String parentType, String name, RelatedArtifact element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "RelatedArtifact", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "RelatedArtifact", "type", element.getTypeElement(), -1);
        }
        if (element.hasLabelElement()) {
            this.composeString(t, "RelatedArtifact", "label", element.getLabelElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "RelatedArtifact", "display", element.getDisplayElement(), -1);
        }
        if (element.hasCitationElement()) {
            this.composeMarkdown(t, "RelatedArtifact", "citation", element.getCitationElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUrl(t, "RelatedArtifact", "url", element.getUrlElement(), -1);
        }
        if (element.hasDocument()) {
            this.composeAttachment(t, "RelatedArtifact", "document", element.getDocument(), -1);
        }
        if (element.hasResourceElement()) {
            this.composeCanonical(t, "RelatedArtifact", "resource", element.getResourceElement(), -1);
        }
    }

    protected void composeSampledData(Turtle.Complex parent, String parentType, String name, SampledData element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "SampledData", name, element, index);
        if (element.hasOrigin()) {
            this.composeQuantity(t, "SampledData", "origin", element.getOrigin(), -1);
        }
        if (element.hasPeriodElement()) {
            this.composeDecimal(t, "SampledData", "period", element.getPeriodElement(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "SampledData", "factor", element.getFactorElement(), -1);
        }
        if (element.hasLowerLimitElement()) {
            this.composeDecimal(t, "SampledData", "lowerLimit", element.getLowerLimitElement(), -1);
        }
        if (element.hasUpperLimitElement()) {
            this.composeDecimal(t, "SampledData", "upperLimit", element.getUpperLimitElement(), -1);
        }
        if (element.hasDimensionsElement()) {
            this.composePositiveInt(t, "SampledData", "dimensions", element.getDimensionsElement(), -1);
        }
        if (element.hasDataElement()) {
            this.composeString(t, "SampledData", "data", element.getDataElement(), -1);
        }
    }

    protected void composeSignature(Turtle.Complex parent, String parentType, String name, Signature element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Signature", name, element, index);
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCoding(t, "Signature", "type", element.getType().get(i), i);
        }
        if (element.hasWhenElement()) {
            this.composeInstant(t, "Signature", "when", element.getWhenElement(), -1);
        }
        if (element.hasWho()) {
            this.composeReference(t, "Signature", "who", element.getWho(), -1);
        }
        if (element.hasOnBehalfOf()) {
            this.composeReference(t, "Signature", "onBehalfOf", element.getOnBehalfOf(), -1);
        }
        if (element.hasTargetFormatElement()) {
            this.composeCode(t, "Signature", "targetFormat", element.getTargetFormatElement(), -1);
        }
        if (element.hasSigFormatElement()) {
            this.composeCode(t, "Signature", "sigFormat", element.getSigFormatElement(), -1);
        }
        if (element.hasDataElement()) {
            this.composeBase64Binary(t, "Signature", "data", element.getDataElement(), -1);
        }
    }

    protected void composeTiming(Turtle.Complex parent, String parentType, String name, Timing element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneType(t, "Timing", name, element, index);
        for (int i = 0; i < element.getEvent().size(); ++i) {
            this.composeDateTime(t, "Timing", "event", element.getEvent().get(i), i);
        }
        if (element.hasRepeat()) {
            this.composeTimingRepeatComponent(t, "Timing", "repeat", element.getRepeat(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Timing", "code", element.getCode(), -1);
        }
    }

    protected void composeTimingRepeatComponent(Turtle.Complex parent, String parentType, String name, Timing.TimingRepeatComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "repeat", name, element, index);
        if (element.hasBounds()) {
            this.composeType(t, "TimingRepeatComponent", "bounds", element.getBounds(), -1);
        }
        if (element.hasCountElement()) {
            this.composePositiveInt(t, "TimingRepeatComponent", "count", element.getCountElement(), -1);
        }
        if (element.hasCountMaxElement()) {
            this.composePositiveInt(t, "TimingRepeatComponent", "countMax", element.getCountMaxElement(), -1);
        }
        if (element.hasDurationElement()) {
            this.composeDecimal(t, "TimingRepeatComponent", "duration", element.getDurationElement(), -1);
        }
        if (element.hasDurationMaxElement()) {
            this.composeDecimal(t, "TimingRepeatComponent", "durationMax", element.getDurationMaxElement(), -1);
        }
        if (element.hasDurationUnitElement()) {
            this.composeEnum(t, "TimingRepeatComponent", "durationUnit", element.getDurationUnitElement(), -1);
        }
        if (element.hasFrequencyElement()) {
            this.composePositiveInt(t, "TimingRepeatComponent", "frequency", element.getFrequencyElement(), -1);
        }
        if (element.hasFrequencyMaxElement()) {
            this.composePositiveInt(t, "TimingRepeatComponent", "frequencyMax", element.getFrequencyMaxElement(), -1);
        }
        if (element.hasPeriodElement()) {
            this.composeDecimal(t, "TimingRepeatComponent", "period", element.getPeriodElement(), -1);
        }
        if (element.hasPeriodMaxElement()) {
            this.composeDecimal(t, "TimingRepeatComponent", "periodMax", element.getPeriodMaxElement(), -1);
        }
        if (element.hasPeriodUnitElement()) {
            this.composeEnum(t, "TimingRepeatComponent", "periodUnit", element.getPeriodUnitElement(), -1);
        }
        for (i = 0; i < element.getDayOfWeek().size(); ++i) {
            this.composeEnum(t, "TimingRepeatComponent", "dayOfWeek", element.getDayOfWeek().get(i), i);
        }
        for (i = 0; i < element.getTimeOfDay().size(); ++i) {
            this.composeTime(t, "TimingRepeatComponent", "timeOfDay", element.getTimeOfDay().get(i), i);
        }
        for (i = 0; i < element.getWhen().size(); ++i) {
            this.composeEnum(t, "TimingRepeatComponent", "when", element.getWhen().get(i), i);
        }
        if (element.hasOffsetElement()) {
            this.composeUnsignedInt(t, "TimingRepeatComponent", "offset", element.getOffsetElement(), -1);
        }
    }

    protected void composeTriggerDefinition(Turtle.Complex parent, String parentType, String name, TriggerDefinition element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "TriggerDefinition", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "TriggerDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "TriggerDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "TriggerDefinition", "timing", element.getTiming(), -1);
        }
        for (int i = 0; i < element.getData().size(); ++i) {
            this.composeDataRequirement(t, "TriggerDefinition", "data", element.getData().get(i), i);
        }
        if (element.hasCondition()) {
            this.composeExpression(t, "TriggerDefinition", "condition", element.getCondition(), -1);
        }
    }

    protected void composeUsageContext(Turtle.Complex parent, String parentType, String name, UsageContext element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "UsageContext", name, element, index);
        if (element.hasCode()) {
            this.composeCoding(t, "UsageContext", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "UsageContext", "value", element.getValue(), -1);
        }
    }

    protected void composeResource(Turtle.Complex t, String parentType, String name, Resource element, int index) {
        if (element.hasIdElement()) {
            this.composeId(t, "Resource", "id", element.getIdElement(), -1);
        }
        if (element.hasMeta()) {
            this.composeMeta(t, "Resource", "meta", element.getMeta(), -1);
        }
        if (element.hasImplicitRulesElement()) {
            this.composeUri(t, "Resource", "implicitRules", element.getImplicitRulesElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "Resource", "language", element.getLanguageElement(), -1);
        }
    }

    protected void composeDomainResource(Turtle.Complex t, String parentType, String name, DomainResource element, int index) {
        int i;
        this.composeResource(t, parentType, name, element, index);
        if (element.hasText()) {
            this.composeNarrative(t, "DomainResource", "text", element.getText(), -1);
        }
        for (i = 0; i < element.getContained().size(); ++i) {
            this.composeResource(t, "DomainResource", "contained", element.getContained().get(i), i);
        }
        for (i = 0; i < element.getExtension().size(); ++i) {
            this.composeExtension(t, "DomainResource", "extension", element.getExtension().get(i), i);
        }
        for (i = 0; i < element.getModifierExtension().size(); ++i) {
            this.composeExtension(t, "DomainResource", "modifierExtension", element.getModifierExtension().get(i), i);
        }
    }

    protected void composeAccount(Turtle.Complex parent, String parentType, String name, Account element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Account", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Account", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Account", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Account", "type", element.getType(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Account", "name", element.getNameElement(), -1);
        }
        for (i = 0; i < element.getSubject().size(); ++i) {
            this.composeReference(t, "Account", "subject", element.getSubject().get(i), i);
        }
        if (element.hasServicePeriod()) {
            this.composePeriod(t, "Account", "servicePeriod", element.getServicePeriod(), -1);
        }
        for (i = 0; i < element.getCoverage().size(); ++i) {
            this.composeAccountCoverageComponent(t, "Account", "coverage", element.getCoverage().get(i), i);
        }
        if (element.hasOwner()) {
            this.composeReference(t, "Account", "owner", element.getOwner(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Account", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getGuarantor().size(); ++i) {
            this.composeAccountGuarantorComponent(t, "Account", "guarantor", element.getGuarantor().get(i), i);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Account", "partOf", element.getPartOf(), -1);
        }
    }

    protected void composeAccountCoverageComponent(Turtle.Complex parent, String parentType, String name, Account.CoverageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "coverage", name, element, index);
        if (element.hasCoverage()) {
            this.composeReference(t, "CoverageComponent", "coverage", element.getCoverage(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composePositiveInt(t, "CoverageComponent", "priority", element.getPriorityElement(), -1);
        }
    }

    protected void composeAccountGuarantorComponent(Turtle.Complex parent, String parentType, String name, Account.GuarantorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "guarantor", name, element, index);
        if (element.hasParty()) {
            this.composeReference(t, "GuarantorComponent", "party", element.getParty(), -1);
        }
        if (element.hasOnHoldElement()) {
            this.composeBoolean(t, "GuarantorComponent", "onHold", element.getOnHoldElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "GuarantorComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeActivityDefinition(Turtle.Complex parent, String parentType, String name, ActivityDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ActivityDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ActivityDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ActivityDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ActivityDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ActivityDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ActivityDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "ActivityDefinition", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ActivityDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ActivityDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "ActivityDefinition", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ActivityDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ActivityDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ActivityDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ActivityDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ActivityDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ActivityDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ActivityDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "ActivityDefinition", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ActivityDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "ActivityDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "ActivityDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "ActivityDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "ActivityDefinition", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "ActivityDefinition", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "ActivityDefinition", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "ActivityDefinition", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "ActivityDefinition", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "ActivityDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeCanonical(t, "ActivityDefinition", "library", element.getLibrary().get(i), i);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "ActivityDefinition", "kind", element.getKindElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "ActivityDefinition", "profile", element.getProfileElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ActivityDefinition", "code", element.getCode(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "ActivityDefinition", "intent", element.getIntentElement(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "ActivityDefinition", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "ActivityDefinition", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "ActivityDefinition", "timing", element.getTiming(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "ActivityDefinition", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeActivityDefinitionParticipantComponent(t, "ActivityDefinition", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasProduct()) {
            this.composeType(t, "ActivityDefinition", "product", element.getProduct(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ActivityDefinition", "quantity", element.getQuantity(), -1);
        }
        for (i = 0; i < element.getDosage().size(); ++i) {
            this.composeDosage(t, "ActivityDefinition", "dosage", element.getDosage().get(i), i);
        }
        for (i = 0; i < element.getBodySite().size(); ++i) {
            this.composeCodeableConcept(t, "ActivityDefinition", "bodySite", element.getBodySite().get(i), i);
        }
        for (i = 0; i < element.getSpecimenRequirement().size(); ++i) {
            this.composeReference(t, "ActivityDefinition", "specimenRequirement", element.getSpecimenRequirement().get(i), i);
        }
        for (i = 0; i < element.getObservationRequirement().size(); ++i) {
            this.composeReference(t, "ActivityDefinition", "observationRequirement", element.getObservationRequirement().get(i), i);
        }
        for (i = 0; i < element.getObservationResultRequirement().size(); ++i) {
            this.composeReference(t, "ActivityDefinition", "observationResultRequirement", element.getObservationResultRequirement().get(i), i);
        }
        if (element.hasTransformElement()) {
            this.composeCanonical(t, "ActivityDefinition", "transform", element.getTransformElement(), -1);
        }
        for (i = 0; i < element.getDynamicValue().size(); ++i) {
            this.composeActivityDefinitionDynamicValueComponent(t, "ActivityDefinition", "dynamicValue", element.getDynamicValue().get(i), i);
        }
    }

    protected void composeActivityDefinitionParticipantComponent(Turtle.Complex parent, String parentType, String name, ActivityDefinition.ActivityDefinitionParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ActivityDefinitionParticipantComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "ActivityDefinitionParticipantComponent", "role", element.getRole(), -1);
        }
    }

    protected void composeActivityDefinitionDynamicValueComponent(Turtle.Complex parent, String parentType, String name, ActivityDefinition.ActivityDefinitionDynamicValueComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dynamicValue", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "ActivityDefinitionDynamicValueComponent", "path", element.getPathElement(), -1);
        }
        if (element.hasExpression()) {
            this.composeExpression(t, "ActivityDefinitionDynamicValueComponent", "expression", element.getExpression(), -1);
        }
    }

    protected void composeAdministrableProductDefinition(Turtle.Complex parent, String parentType, String name, AdministrableProductDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AdministrableProductDefinition", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "AdministrableProductDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "AdministrableProductDefinition", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getFormOf().size(); ++i) {
            this.composeReference(t, "AdministrableProductDefinition", "formOf", element.getFormOf().get(i), i);
        }
        if (element.hasAdministrableDoseForm()) {
            this.composeCodeableConcept(t, "AdministrableProductDefinition", "administrableDoseForm", element.getAdministrableDoseForm(), -1);
        }
        if (element.hasUnitOfPresentation()) {
            this.composeCodeableConcept(t, "AdministrableProductDefinition", "unitOfPresentation", element.getUnitOfPresentation(), -1);
        }
        for (i = 0; i < element.getProducedFrom().size(); ++i) {
            this.composeReference(t, "AdministrableProductDefinition", "producedFrom", element.getProducedFrom().get(i), i);
        }
        for (i = 0; i < element.getIngredient().size(); ++i) {
            this.composeCodeableConcept(t, "AdministrableProductDefinition", "ingredient", element.getIngredient().get(i), i);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "AdministrableProductDefinition", "device", element.getDevice(), -1);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeAdministrableProductDefinitionPropertyComponent(t, "AdministrableProductDefinition", "property", element.getProperty().get(i), i);
        }
        for (i = 0; i < element.getRouteOfAdministration().size(); ++i) {
            this.composeAdministrableProductDefinitionRouteOfAdministrationComponent(t, "AdministrableProductDefinition", "routeOfAdministration", element.getRouteOfAdministration().get(i), i);
        }
    }

    protected void composeAdministrableProductDefinitionPropertyComponent(Turtle.Complex parent, String parentType, String name, AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "AdministrableProductDefinitionPropertyComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "AdministrableProductDefinitionPropertyComponent", "value", element.getValue(), -1);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "AdministrableProductDefinitionPropertyComponent", "status", element.getStatus(), -1);
        }
    }

    protected void composeAdministrableProductDefinitionRouteOfAdministrationComponent(Turtle.Complex parent, String parentType, String name, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "routeOfAdministration", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "code", element.getCode(), -1);
        }
        if (element.hasFirstDose()) {
            this.composeQuantity(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "firstDose", element.getFirstDose(), -1);
        }
        if (element.hasMaxSingleDose()) {
            this.composeQuantity(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "maxSingleDose", element.getMaxSingleDose(), -1);
        }
        if (element.hasMaxDosePerDay()) {
            this.composeQuantity(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "maxDosePerDay", element.getMaxDosePerDay(), -1);
        }
        if (element.hasMaxDosePerTreatmentPeriod()) {
            this.composeRatio(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "maxDosePerTreatmentPeriod", element.getMaxDosePerTreatmentPeriod(), -1);
        }
        if (element.hasMaxTreatmentPeriod()) {
            this.composeDuration(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "maxTreatmentPeriod", element.getMaxTreatmentPeriod(), -1);
        }
        for (int i = 0; i < element.getTargetSpecies().size(); ++i) {
            this.composeAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "targetSpecies", element.getTargetSpecies().get(i), i);
        }
    }

    protected void composeAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(Turtle.Complex parent, String parentType, String name, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "targetSpecies", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent", "code", element.getCode(), -1);
        }
        for (int i = 0; i < element.getWithdrawalPeriod().size(); ++i) {
            this.composeAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent", "withdrawalPeriod", element.getWithdrawalPeriod().get(i), i);
        }
    }

    protected void composeAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(Turtle.Complex parent, String parentType, String name, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "withdrawalPeriod", name, element, index);
        if (element.hasTissue()) {
            this.composeCodeableConcept(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent", "tissue", element.getTissue(), -1);
        }
        if (element.hasValue()) {
            this.composeQuantity(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent", "value", element.getValue(), -1);
        }
        if (element.hasSupportingInformationElement()) {
            this.composeString(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent", "supportingInformation", element.getSupportingInformationElement(), -1);
        }
    }

    protected void composeAdverseEvent(Turtle.Complex parent, String parentType, String name, AdverseEvent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AdverseEvent", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "AdverseEvent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasActualityElement()) {
            this.composeEnum(t, "AdverseEvent", "actuality", element.getActualityElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "AdverseEvent", "category", element.getCategory().get(i), i);
        }
        if (element.hasEvent()) {
            this.composeCodeableConcept(t, "AdverseEvent", "event", element.getEvent(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "AdverseEvent", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "AdverseEvent", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "AdverseEvent", "date", element.getDateElement(), -1);
        }
        if (element.hasDetectedElement()) {
            this.composeDateTime(t, "AdverseEvent", "detected", element.getDetectedElement(), -1);
        }
        if (element.hasRecordedDateElement()) {
            this.composeDateTime(t, "AdverseEvent", "recordedDate", element.getRecordedDateElement(), -1);
        }
        for (i = 0; i < element.getResultingCondition().size(); ++i) {
            this.composeReference(t, "AdverseEvent", "resultingCondition", element.getResultingCondition().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "AdverseEvent", "location", element.getLocation(), -1);
        }
        if (element.hasSeriousness()) {
            this.composeCodeableConcept(t, "AdverseEvent", "seriousness", element.getSeriousness(), -1);
        }
        if (element.hasSeverity()) {
            this.composeCodeableConcept(t, "AdverseEvent", "severity", element.getSeverity(), -1);
        }
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "AdverseEvent", "outcome", element.getOutcome(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "AdverseEvent", "recorder", element.getRecorder(), -1);
        }
        for (i = 0; i < element.getContributor().size(); ++i) {
            this.composeReference(t, "AdverseEvent", "contributor", element.getContributor().get(i), i);
        }
        for (i = 0; i < element.getSuspectEntity().size(); ++i) {
            this.composeAdverseEventSuspectEntityComponent(t, "AdverseEvent", "suspectEntity", element.getSuspectEntity().get(i), i);
        }
        for (i = 0; i < element.getSubjectMedicalHistory().size(); ++i) {
            this.composeReference(t, "AdverseEvent", "subjectMedicalHistory", element.getSubjectMedicalHistory().get(i), i);
        }
        for (i = 0; i < element.getReferenceDocument().size(); ++i) {
            this.composeReference(t, "AdverseEvent", "referenceDocument", element.getReferenceDocument().get(i), i);
        }
        for (i = 0; i < element.getStudy().size(); ++i) {
            this.composeReference(t, "AdverseEvent", "study", element.getStudy().get(i), i);
        }
    }

    protected void composeAdverseEventSuspectEntityComponent(Turtle.Complex parent, String parentType, String name, AdverseEvent.AdverseEventSuspectEntityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "suspectEntity", name, element, index);
        if (element.hasInstance()) {
            this.composeReference(t, "AdverseEventSuspectEntityComponent", "instance", element.getInstance(), -1);
        }
        for (int i = 0; i < element.getCausality().size(); ++i) {
            this.composeAdverseEventSuspectEntityCausalityComponent(t, "AdverseEventSuspectEntityComponent", "causality", element.getCausality().get(i), i);
        }
    }

    protected void composeAdverseEventSuspectEntityCausalityComponent(Turtle.Complex parent, String parentType, String name, AdverseEvent.AdverseEventSuspectEntityCausalityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "causality", name, element, index);
        if (element.hasAssessment()) {
            this.composeCodeableConcept(t, "AdverseEventSuspectEntityCausalityComponent", "assessment", element.getAssessment(), -1);
        }
        if (element.hasProductRelatednessElement()) {
            this.composeString(t, "AdverseEventSuspectEntityCausalityComponent", "productRelatedness", element.getProductRelatednessElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "AdverseEventSuspectEntityCausalityComponent", "author", element.getAuthor(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "AdverseEventSuspectEntityCausalityComponent", "method", element.getMethod(), -1);
        }
    }

    protected void composeAllergyIntolerance(Turtle.Complex parent, String parentType, String name, AllergyIntolerance element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AllergyIntolerance", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "AllergyIntolerance", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasClinicalStatus()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "clinicalStatus", element.getClinicalStatus(), -1);
        }
        if (element.hasVerificationStatus()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "verificationStatus", element.getVerificationStatus(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "AllergyIntolerance", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeEnum(t, "AllergyIntolerance", "category", element.getCategory().get(i), i);
        }
        if (element.hasCriticalityElement()) {
            this.composeEnum(t, "AllergyIntolerance", "criticality", element.getCriticalityElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "code", element.getCode(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "AllergyIntolerance", "patient", element.getPatient(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "AllergyIntolerance", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOnset()) {
            this.composeType(t, "AllergyIntolerance", "onset", element.getOnset(), -1);
        }
        if (element.hasRecordedDateElement()) {
            this.composeDateTime(t, "AllergyIntolerance", "recordedDate", element.getRecordedDateElement(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "AllergyIntolerance", "recorder", element.getRecorder(), -1);
        }
        if (element.hasAsserter()) {
            this.composeReference(t, "AllergyIntolerance", "asserter", element.getAsserter(), -1);
        }
        if (element.hasLastOccurrenceElement()) {
            this.composeDateTime(t, "AllergyIntolerance", "lastOccurrence", element.getLastOccurrenceElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "AllergyIntolerance", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getReaction().size(); ++i) {
            this.composeAllergyIntoleranceReactionComponent(t, "AllergyIntolerance", "reaction", element.getReaction().get(i), i);
        }
    }

    protected void composeAllergyIntoleranceReactionComponent(Turtle.Complex parent, String parentType, String name, AllergyIntolerance.AllergyIntoleranceReactionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "reaction", name, element, index);
        if (element.hasSubstance()) {
            this.composeCodeableConcept(t, "AllergyIntoleranceReactionComponent", "substance", element.getSubstance(), -1);
        }
        for (i = 0; i < element.getManifestation().size(); ++i) {
            this.composeCodeableConcept(t, "AllergyIntoleranceReactionComponent", "manifestation", element.getManifestation().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "AllergyIntoleranceReactionComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasOnsetElement()) {
            this.composeDateTime(t, "AllergyIntoleranceReactionComponent", "onset", element.getOnsetElement(), -1);
        }
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "AllergyIntoleranceReactionComponent", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasExposureRoute()) {
            this.composeCodeableConcept(t, "AllergyIntoleranceReactionComponent", "exposureRoute", element.getExposureRoute(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "AllergyIntoleranceReactionComponent", "note", element.getNote().get(i), i);
        }
    }

    protected void composeAppointment(Turtle.Complex parent, String parentType, String name, Appointment element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Appointment", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Appointment", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Appointment", "status", element.getStatusElement(), -1);
        }
        if (element.hasCancelationReason()) {
            this.composeCodeableConcept(t, "Appointment", "cancelationReason", element.getCancelationReason(), -1);
        }
        for (i = 0; i < element.getServiceCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "serviceCategory", element.getServiceCategory().get(i), i);
        }
        for (i = 0; i < element.getServiceType().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "serviceType", element.getServiceType().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "specialty", element.getSpecialty().get(i), i);
        }
        if (element.hasAppointmentType()) {
            this.composeCodeableConcept(t, "Appointment", "appointmentType", element.getAppointmentType(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "Appointment", "reasonReference", element.getReasonReference().get(i), i);
        }
        if (element.hasPriorityElement()) {
            this.composeUnsignedInt(t, "Appointment", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Appointment", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "Appointment", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
        if (element.hasStartElement()) {
            this.composeInstant(t, "Appointment", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "Appointment", "end", element.getEndElement(), -1);
        }
        if (element.hasMinutesDurationElement()) {
            this.composePositiveInt(t, "Appointment", "minutesDuration", element.getMinutesDurationElement(), -1);
        }
        for (i = 0; i < element.getSlot().size(); ++i) {
            this.composeReference(t, "Appointment", "slot", element.getSlot().get(i), i);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "Appointment", "created", element.getCreatedElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "Appointment", "comment", element.getCommentElement(), -1);
        }
        if (element.hasPatientInstructionElement()) {
            this.composeString(t, "Appointment", "patientInstruction", element.getPatientInstructionElement(), -1);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Appointment", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeAppointmentParticipantComponent(t, "Appointment", "participant", element.getParticipant().get(i), i);
        }
        for (i = 0; i < element.getRequestedPeriod().size(); ++i) {
            this.composePeriod(t, "Appointment", "requestedPeriod", element.getRequestedPeriod().get(i), i);
        }
    }

    protected void composeAppointmentParticipantComponent(Turtle.Complex parent, String parentType, String name, Appointment.AppointmentParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "AppointmentParticipantComponent", "type", element.getType().get(i), i);
        }
        if (element.hasActor()) {
            this.composeReference(t, "AppointmentParticipantComponent", "actor", element.getActor(), -1);
        }
        if (element.hasRequiredElement()) {
            this.composeEnum(t, "AppointmentParticipantComponent", "required", element.getRequiredElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "AppointmentParticipantComponent", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "AppointmentParticipantComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeAppointmentResponse(Turtle.Complex parent, String parentType, String name, AppointmentResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AppointmentResponse", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "AppointmentResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasAppointment()) {
            this.composeReference(t, "AppointmentResponse", "appointment", element.getAppointment(), -1);
        }
        if (element.hasStartElement()) {
            this.composeInstant(t, "AppointmentResponse", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "AppointmentResponse", "end", element.getEndElement(), -1);
        }
        for (i = 0; i < element.getParticipantType().size(); ++i) {
            this.composeCodeableConcept(t, "AppointmentResponse", "participantType", element.getParticipantType().get(i), i);
        }
        if (element.hasActor()) {
            this.composeReference(t, "AppointmentResponse", "actor", element.getActor(), -1);
        }
        if (element.hasParticipantStatusElement()) {
            this.composeEnum(t, "AppointmentResponse", "participantStatus", element.getParticipantStatusElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "AppointmentResponse", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeAuditEvent(Turtle.Complex parent, String parentType, String name, AuditEvent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AuditEvent", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "AuditEvent", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSubtype().size(); ++i) {
            this.composeCoding(t, "AuditEvent", "subtype", element.getSubtype().get(i), i);
        }
        if (element.hasActionElement()) {
            this.composeEnum(t, "AuditEvent", "action", element.getActionElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "AuditEvent", "period", element.getPeriod(), -1);
        }
        if (element.hasRecordedElement()) {
            this.composeInstant(t, "AuditEvent", "recorded", element.getRecordedElement(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "AuditEvent", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasOutcomeDescElement()) {
            this.composeString(t, "AuditEvent", "outcomeDesc", element.getOutcomeDescElement(), -1);
        }
        for (i = 0; i < element.getPurposeOfEvent().size(); ++i) {
            this.composeCodeableConcept(t, "AuditEvent", "purposeOfEvent", element.getPurposeOfEvent().get(i), i);
        }
        for (i = 0; i < element.getAgent().size(); ++i) {
            this.composeAuditEventAgentComponent(t, "AuditEvent", "agent", element.getAgent().get(i), i);
        }
        if (element.hasSource()) {
            this.composeAuditEventSourceComponent(t, "AuditEvent", "source", element.getSource(), -1);
        }
        for (i = 0; i < element.getEntity().size(); ++i) {
            this.composeAuditEventEntityComponent(t, "AuditEvent", "entity", element.getEntity().get(i), i);
        }
    }

    protected void composeAuditEventAgentComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventAgentComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "agent", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "AuditEventAgentComponent", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getRole().size(); ++i) {
            this.composeCodeableConcept(t, "AuditEventAgentComponent", "role", element.getRole().get(i), i);
        }
        if (element.hasWho()) {
            this.composeReference(t, "AuditEventAgentComponent", "who", element.getWho(), -1);
        }
        if (element.hasAltIdElement()) {
            this.composeString(t, "AuditEventAgentComponent", "altId", element.getAltIdElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "AuditEventAgentComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasRequestorElement()) {
            this.composeBoolean(t, "AuditEventAgentComponent", "requestor", element.getRequestorElement(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "AuditEventAgentComponent", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getPolicy().size(); ++i) {
            this.composeUri(t, "AuditEventAgentComponent", "policy", element.getPolicy().get(i), i);
        }
        if (element.hasMedia()) {
            this.composeCoding(t, "AuditEventAgentComponent", "media", element.getMedia(), -1);
        }
        if (element.hasNetwork()) {
            this.composeAuditEventAgentNetworkComponent(t, "AuditEventAgentComponent", "network", element.getNetwork(), -1);
        }
        for (i = 0; i < element.getPurposeOfUse().size(); ++i) {
            this.composeCodeableConcept(t, "AuditEventAgentComponent", "purposeOfUse", element.getPurposeOfUse().get(i), i);
        }
    }

    protected void composeAuditEventAgentNetworkComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventAgentNetworkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "network", name, element, index);
        if (element.hasAddressElement()) {
            this.composeString(t, "AuditEventAgentNetworkComponent", "address", element.getAddressElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "AuditEventAgentNetworkComponent", "type", element.getTypeElement(), -1);
        }
    }

    protected void composeAuditEventSourceComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventSourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "source", name, element, index);
        if (element.hasSiteElement()) {
            this.composeString(t, "AuditEventSourceComponent", "site", element.getSiteElement(), -1);
        }
        if (element.hasObserver()) {
            this.composeReference(t, "AuditEventSourceComponent", "observer", element.getObserver(), -1);
        }
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCoding(t, "AuditEventSourceComponent", "type", element.getType().get(i), i);
        }
    }

    protected void composeAuditEventEntityComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventEntityComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entity", name, element, index);
        if (element.hasWhat()) {
            this.composeReference(t, "AuditEventEntityComponent", "what", element.getWhat(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "AuditEventEntityComponent", "type", element.getType(), -1);
        }
        if (element.hasRole()) {
            this.composeCoding(t, "AuditEventEntityComponent", "role", element.getRole(), -1);
        }
        if (element.hasLifecycle()) {
            this.composeCoding(t, "AuditEventEntityComponent", "lifecycle", element.getLifecycle(), -1);
        }
        for (i = 0; i < element.getSecurityLabel().size(); ++i) {
            this.composeCoding(t, "AuditEventEntityComponent", "securityLabel", element.getSecurityLabel().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "AuditEventEntityComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "AuditEventEntityComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasQueryElement()) {
            this.composeBase64Binary(t, "AuditEventEntityComponent", "query", element.getQueryElement(), -1);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeAuditEventEntityDetailComponent(t, "AuditEventEntityComponent", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeAuditEventEntityDetailComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventEntityDetailComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasTypeElement()) {
            this.composeString(t, "AuditEventEntityDetailComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "AuditEventEntityDetailComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeBasic(Turtle.Complex parent, String parentType, String name, Basic element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Basic", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Basic", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Basic", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Basic", "subject", element.getSubject(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDate(t, "Basic", "created", element.getCreatedElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Basic", "author", element.getAuthor(), -1);
        }
    }

    protected void composeBinary(Turtle.Complex parent, String parentType, String name, Binary element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeResource(t, "Binary", name, element, index);
        if (element.hasContentTypeElement()) {
            this.composeCode(t, "Binary", "contentType", element.getContentTypeElement(), -1);
        }
        if (element.hasSecurityContext()) {
            this.composeReference(t, "Binary", "securityContext", element.getSecurityContext(), -1);
        }
        if (element.hasDataElement()) {
            this.composeBase64Binary(t, "Binary", "data", element.getDataElement(), -1);
        }
    }

    protected void composeBiologicallyDerivedProduct(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "BiologicallyDerivedProduct", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "BiologicallyDerivedProduct", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasProductCategoryElement()) {
            this.composeEnum(t, "BiologicallyDerivedProduct", "productCategory", element.getProductCategoryElement(), -1);
        }
        if (element.hasProductCode()) {
            this.composeCodeableConcept(t, "BiologicallyDerivedProduct", "productCode", element.getProductCode(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "BiologicallyDerivedProduct", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getRequest().size(); ++i) {
            this.composeReference(t, "BiologicallyDerivedProduct", "request", element.getRequest().get(i), i);
        }
        if (element.hasQuantityElement()) {
            this.composeInteger(t, "BiologicallyDerivedProduct", "quantity", element.getQuantityElement(), -1);
        }
        for (i = 0; i < element.getParent().size(); ++i) {
            this.composeReference(t, "BiologicallyDerivedProduct", "parent", element.getParent().get(i), i);
        }
        if (element.hasCollection()) {
            this.composeBiologicallyDerivedProductCollectionComponent(t, "BiologicallyDerivedProduct", "collection", element.getCollection(), -1);
        }
        for (i = 0; i < element.getProcessing().size(); ++i) {
            this.composeBiologicallyDerivedProductProcessingComponent(t, "BiologicallyDerivedProduct", "processing", element.getProcessing().get(i), i);
        }
        if (element.hasManipulation()) {
            this.composeBiologicallyDerivedProductManipulationComponent(t, "BiologicallyDerivedProduct", "manipulation", element.getManipulation(), -1);
        }
        for (i = 0; i < element.getStorage().size(); ++i) {
            this.composeBiologicallyDerivedProductStorageComponent(t, "BiologicallyDerivedProduct", "storage", element.getStorage().get(i), i);
        }
    }

    protected void composeBiologicallyDerivedProductCollectionComponent(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "collection", name, element, index);
        if (element.hasCollector()) {
            this.composeReference(t, "BiologicallyDerivedProductCollectionComponent", "collector", element.getCollector(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "BiologicallyDerivedProductCollectionComponent", "source", element.getSource(), -1);
        }
        if (element.hasCollected()) {
            this.composeType(t, "BiologicallyDerivedProductCollectionComponent", "collected", element.getCollected(), -1);
        }
    }

    protected void composeBiologicallyDerivedProductProcessingComponent(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "processing", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "BiologicallyDerivedProductProcessingComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeCodeableConcept(t, "BiologicallyDerivedProductProcessingComponent", "procedure", element.getProcedure(), -1);
        }
        if (element.hasAdditive()) {
            this.composeReference(t, "BiologicallyDerivedProductProcessingComponent", "additive", element.getAdditive(), -1);
        }
        if (element.hasTime()) {
            this.composeType(t, "BiologicallyDerivedProductProcessingComponent", "time", element.getTime(), -1);
        }
    }

    protected void composeBiologicallyDerivedProductManipulationComponent(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "manipulation", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "BiologicallyDerivedProductManipulationComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTime()) {
            this.composeType(t, "BiologicallyDerivedProductManipulationComponent", "time", element.getTime(), -1);
        }
    }

    protected void composeBiologicallyDerivedProductStorageComponent(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "storage", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "BiologicallyDerivedProductStorageComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTemperatureElement()) {
            this.composeDecimal(t, "BiologicallyDerivedProductStorageComponent", "temperature", element.getTemperatureElement(), -1);
        }
        if (element.hasScaleElement()) {
            this.composeEnum(t, "BiologicallyDerivedProductStorageComponent", "scale", element.getScaleElement(), -1);
        }
        if (element.hasDuration()) {
            this.composePeriod(t, "BiologicallyDerivedProductStorageComponent", "duration", element.getDuration(), -1);
        }
    }

    protected void composeBodyStructure(Turtle.Complex parent, String parentType, String name, BodyStructure element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "BodyStructure", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "BodyStructure", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "BodyStructure", "active", element.getActiveElement(), -1);
        }
        if (element.hasMorphology()) {
            this.composeCodeableConcept(t, "BodyStructure", "morphology", element.getMorphology(), -1);
        }
        if (element.hasLocation()) {
            this.composeCodeableConcept(t, "BodyStructure", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getLocationQualifier().size(); ++i) {
            this.composeCodeableConcept(t, "BodyStructure", "locationQualifier", element.getLocationQualifier().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "BodyStructure", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getImage().size(); ++i) {
            this.composeAttachment(t, "BodyStructure", "image", element.getImage().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "BodyStructure", "patient", element.getPatient(), -1);
        }
    }

    protected void composeBundle(Turtle.Complex parent, String parentType, String name, Bundle element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeResource(t, "Bundle", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Bundle", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Bundle", "type", element.getTypeElement(), -1);
        }
        if (element.hasTimestampElement()) {
            this.composeInstant(t, "Bundle", "timestamp", element.getTimestampElement(), -1);
        }
        if (element.hasTotalElement()) {
            this.composeUnsignedInt(t, "Bundle", "total", element.getTotalElement(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composeBundleLinkComponent(t, "Bundle", "link", element.getLink().get(i), i);
        }
        for (i = 0; i < element.getEntry().size(); ++i) {
            this.composeBundleEntryComponent(t, "Bundle", "entry", element.getEntry().get(i), i);
        }
        if (element.hasSignature()) {
            this.composeSignature(t, "Bundle", "signature", element.getSignature(), -1);
        }
    }

    protected void composeBundleLinkComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasRelationElement()) {
            this.composeString(t, "BundleLinkComponent", "relation", element.getRelationElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "BundleLinkComponent", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeBundleEntryComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleEntryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entry", name, element, index);
        for (int i = 0; i < element.getLink().size(); ++i) {
            this.composeBundleLinkComponent(t, "BundleEntryComponent", "link", element.getLink().get(i), i);
        }
        if (element.hasFullUrlElement()) {
            this.composeUri(t, "BundleEntryComponent", "fullUrl", element.getFullUrlElement(), -1);
        }
        if (element.hasResource()) {
            this.composeResource(t, "BundleEntryComponent", "resource", element.getResource(), -1);
        }
        if (element.hasSearch()) {
            this.composeBundleEntrySearchComponent(t, "BundleEntryComponent", "search", element.getSearch(), -1);
        }
        if (element.hasRequest()) {
            this.composeBundleEntryRequestComponent(t, "BundleEntryComponent", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeBundleEntryResponseComponent(t, "BundleEntryComponent", "response", element.getResponse(), -1);
        }
    }

    protected void composeBundleEntrySearchComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleEntrySearchComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "search", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "BundleEntrySearchComponent", "mode", element.getModeElement(), -1);
        }
        if (element.hasScoreElement()) {
            this.composeDecimal(t, "BundleEntrySearchComponent", "score", element.getScoreElement(), -1);
        }
    }

    protected void composeBundleEntryRequestComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleEntryRequestComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "request", name, element, index);
        if (element.hasMethodElement()) {
            this.composeEnum(t, "BundleEntryRequestComponent", "method", element.getMethodElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "BundleEntryRequestComponent", "url", element.getUrlElement(), -1);
        }
        if (element.hasIfNoneMatchElement()) {
            this.composeString(t, "BundleEntryRequestComponent", "ifNoneMatch", element.getIfNoneMatchElement(), -1);
        }
        if (element.hasIfModifiedSinceElement()) {
            this.composeInstant(t, "BundleEntryRequestComponent", "ifModifiedSince", element.getIfModifiedSinceElement(), -1);
        }
        if (element.hasIfMatchElement()) {
            this.composeString(t, "BundleEntryRequestComponent", "ifMatch", element.getIfMatchElement(), -1);
        }
        if (element.hasIfNoneExistElement()) {
            this.composeString(t, "BundleEntryRequestComponent", "ifNoneExist", element.getIfNoneExistElement(), -1);
        }
    }

    protected void composeBundleEntryResponseComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleEntryResponseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "response", name, element, index);
        if (element.hasStatusElement()) {
            this.composeString(t, "BundleEntryResponseComponent", "status", element.getStatusElement(), -1);
        }
        if (element.hasLocationElement()) {
            this.composeUri(t, "BundleEntryResponseComponent", "location", element.getLocationElement(), -1);
        }
        if (element.hasEtagElement()) {
            this.composeString(t, "BundleEntryResponseComponent", "etag", element.getEtagElement(), -1);
        }
        if (element.hasLastModifiedElement()) {
            this.composeInstant(t, "BundleEntryResponseComponent", "lastModified", element.getLastModifiedElement(), -1);
        }
        if (element.hasOutcome()) {
            this.composeResource(t, "BundleEntryResponseComponent", "outcome", element.getOutcome(), -1);
        }
    }

    protected void composeCapabilityStatement(Turtle.Complex parent, String parentType, String name, CapabilityStatement element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CapabilityStatement", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "CapabilityStatement", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CapabilityStatement", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CapabilityStatement", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CapabilityStatement", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CapabilityStatement", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "CapabilityStatement", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "CapabilityStatement", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "CapabilityStatement", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "CapabilityStatement", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "CapabilityStatement", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "CapabilityStatement", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "CapabilityStatement", "kind", element.getKindElement(), -1);
        }
        for (i = 0; i < element.getInstantiates().size(); ++i) {
            this.composeCanonical(t, "CapabilityStatement", "instantiates", element.getInstantiates().get(i), i);
        }
        for (i = 0; i < element.getImports().size(); ++i) {
            this.composeCanonical(t, "CapabilityStatement", "imports", element.getImports().get(i), i);
        }
        if (element.hasSoftware()) {
            this.composeCapabilityStatementSoftwareComponent(t, "CapabilityStatement", "software", element.getSoftware(), -1);
        }
        if (element.hasImplementation()) {
            this.composeCapabilityStatementImplementationComponent(t, "CapabilityStatement", "implementation", element.getImplementation(), -1);
        }
        if (element.hasFhirVersionElement()) {
            this.composeEnum(t, "CapabilityStatement", "fhirVersion", element.getFhirVersionElement(), -1);
        }
        for (i = 0; i < element.getFormat().size(); ++i) {
            this.composeCode(t, "CapabilityStatement", "format", element.getFormat().get(i), i);
        }
        for (i = 0; i < element.getPatchFormat().size(); ++i) {
            this.composeCode(t, "CapabilityStatement", "patchFormat", element.getPatchFormat().get(i), i);
        }
        for (i = 0; i < element.getImplementationGuide().size(); ++i) {
            this.composeCanonical(t, "CapabilityStatement", "implementationGuide", element.getImplementationGuide().get(i), i);
        }
        for (i = 0; i < element.getRest().size(); ++i) {
            this.composeCapabilityStatementRestComponent(t, "CapabilityStatement", "rest", element.getRest().get(i), i);
        }
        for (i = 0; i < element.getMessaging().size(); ++i) {
            this.composeCapabilityStatementMessagingComponent(t, "CapabilityStatement", "messaging", element.getMessaging().get(i), i);
        }
        for (i = 0; i < element.getDocument().size(); ++i) {
            this.composeCapabilityStatementDocumentComponent(t, "CapabilityStatement", "document", element.getDocument().get(i), i);
        }
    }

    protected void composeCapabilityStatementSoftwareComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementSoftwareComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "software", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "CapabilityStatementSoftwareComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CapabilityStatementSoftwareComponent", "version", element.getVersionElement(), -1);
        }
        if (element.hasReleaseDateElement()) {
            this.composeDateTime(t, "CapabilityStatementSoftwareComponent", "releaseDate", element.getReleaseDateElement(), -1);
        }
    }

    protected void composeCapabilityStatementImplementationComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementImplementationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "implementation", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CapabilityStatementImplementationComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUrl(t, "CapabilityStatementImplementationComponent", "url", element.getUrlElement(), -1);
        }
        if (element.hasCustodian()) {
            this.composeReference(t, "CapabilityStatementImplementationComponent", "custodian", element.getCustodian(), -1);
        }
    }

    protected void composeCapabilityStatementRestComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "rest", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "CapabilityStatementRestComponent", "mode", element.getModeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatementRestComponent", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasSecurity()) {
            this.composeCapabilityStatementRestSecurityComponent(t, "CapabilityStatementRestComponent", "security", element.getSecurity(), -1);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeCapabilityStatementRestResourceComponent(t, "CapabilityStatementRestComponent", "resource", element.getResource().get(i), i);
        }
        for (i = 0; i < element.getInteraction().size(); ++i) {
            this.composeCapabilityStatementSystemInteractionComponent(t, "CapabilityStatementRestComponent", "interaction", element.getInteraction().get(i), i);
        }
        for (i = 0; i < element.getSearchParam().size(); ++i) {
            this.composeCapabilityStatementRestResourceSearchParamComponent(t, "CapabilityStatementRestComponent", "searchParam", element.getSearchParam().get(i), i);
        }
        for (i = 0; i < element.getOperation().size(); ++i) {
            this.composeCapabilityStatementRestResourceOperationComponent(t, "CapabilityStatementRestComponent", "operation", element.getOperation().get(i), i);
        }
        for (i = 0; i < element.getCompartment().size(); ++i) {
            this.composeCanonical(t, "CapabilityStatementRestComponent", "compartment", element.getCompartment().get(i), i);
        }
    }

    protected void composeCapabilityStatementRestSecurityComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestSecurityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "security", name, element, index);
        if (element.hasCorsElement()) {
            this.composeBoolean(t, "CapabilityStatementRestSecurityComponent", "cors", element.getCorsElement(), -1);
        }
        for (int i = 0; i < element.getService().size(); ++i) {
            this.composeCodeableConcept(t, "CapabilityStatementRestSecurityComponent", "service", element.getService().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "CapabilityStatementRestSecurityComponent", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeCapabilityStatementRestResourceComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "CapabilityStatementRestResourceComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "CapabilityStatementRestResourceComponent", "profile", element.getProfileElement(), -1);
        }
        for (i = 0; i < element.getSupportedProfile().size(); ++i) {
            this.composeCanonical(t, "CapabilityStatementRestResourceComponent", "supportedProfile", element.getSupportedProfile().get(i), i);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatementRestResourceComponent", "documentation", element.getDocumentationElement(), -1);
        }
        for (i = 0; i < element.getInteraction().size(); ++i) {
            this.composeCapabilityStatementResourceInteractionComponent(t, "CapabilityStatementRestResourceComponent", "interaction", element.getInteraction().get(i), i);
        }
        if (element.hasVersioningElement()) {
            this.composeEnum(t, "CapabilityStatementRestResourceComponent", "versioning", element.getVersioningElement(), -1);
        }
        if (element.hasReadHistoryElement()) {
            this.composeBoolean(t, "CapabilityStatementRestResourceComponent", "readHistory", element.getReadHistoryElement(), -1);
        }
        if (element.hasUpdateCreateElement()) {
            this.composeBoolean(t, "CapabilityStatementRestResourceComponent", "updateCreate", element.getUpdateCreateElement(), -1);
        }
        if (element.hasConditionalCreateElement()) {
            this.composeBoolean(t, "CapabilityStatementRestResourceComponent", "conditionalCreate", element.getConditionalCreateElement(), -1);
        }
        if (element.hasConditionalReadElement()) {
            this.composeEnum(t, "CapabilityStatementRestResourceComponent", "conditionalRead", element.getConditionalReadElement(), -1);
        }
        if (element.hasConditionalUpdateElement()) {
            this.composeBoolean(t, "CapabilityStatementRestResourceComponent", "conditionalUpdate", element.getConditionalUpdateElement(), -1);
        }
        if (element.hasConditionalDeleteElement()) {
            this.composeEnum(t, "CapabilityStatementRestResourceComponent", "conditionalDelete", element.getConditionalDeleteElement(), -1);
        }
        for (i = 0; i < element.getReferencePolicy().size(); ++i) {
            this.composeEnum(t, "CapabilityStatementRestResourceComponent", "referencePolicy", element.getReferencePolicy().get(i), i);
        }
        for (i = 0; i < element.getSearchInclude().size(); ++i) {
            this.composeString(t, "CapabilityStatementRestResourceComponent", "searchInclude", element.getSearchInclude().get(i), i);
        }
        for (i = 0; i < element.getSearchRevInclude().size(); ++i) {
            this.composeString(t, "CapabilityStatementRestResourceComponent", "searchRevInclude", element.getSearchRevInclude().get(i), i);
        }
        for (i = 0; i < element.getSearchParam().size(); ++i) {
            this.composeCapabilityStatementRestResourceSearchParamComponent(t, "CapabilityStatementRestResourceComponent", "searchParam", element.getSearchParam().get(i), i);
        }
        for (i = 0; i < element.getOperation().size(); ++i) {
            this.composeCapabilityStatementRestResourceOperationComponent(t, "CapabilityStatementRestResourceComponent", "operation", element.getOperation().get(i), i);
        }
    }

    protected void composeCapabilityStatementResourceInteractionComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.ResourceInteractionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "interaction", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "ResourceInteractionComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "ResourceInteractionComponent", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeCapabilityStatementRestResourceSearchParamComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "searchParam", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "CapabilityStatementRestResourceSearchParamComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "CapabilityStatementRestResourceSearchParamComponent", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "CapabilityStatementRestResourceSearchParamComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatementRestResourceSearchParamComponent", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeCapabilityStatementRestResourceOperationComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "operation", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "CapabilityStatementRestResourceOperationComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "CapabilityStatementRestResourceOperationComponent", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatementRestResourceOperationComponent", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeCapabilityStatementSystemInteractionComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.SystemInteractionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "interaction", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "SystemInteractionComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "SystemInteractionComponent", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeCapabilityStatementMessagingComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "messaging", name, element, index);
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeCapabilityStatementMessagingEndpointComponent(t, "CapabilityStatementMessagingComponent", "endpoint", element.getEndpoint().get(i), i);
        }
        if (element.hasReliableCacheElement()) {
            this.composeUnsignedInt(t, "CapabilityStatementMessagingComponent", "reliableCache", element.getReliableCacheElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatementMessagingComponent", "documentation", element.getDocumentationElement(), -1);
        }
        for (i = 0; i < element.getSupportedMessage().size(); ++i) {
            this.composeCapabilityStatementMessagingSupportedMessageComponent(t, "CapabilityStatementMessagingComponent", "supportedMessage", element.getSupportedMessage().get(i), i);
        }
    }

    protected void composeCapabilityStatementMessagingEndpointComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingEndpointComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "endpoint", name, element, index);
        if (element.hasProtocol()) {
            this.composeCoding(t, "CapabilityStatementMessagingEndpointComponent", "protocol", element.getProtocol(), -1);
        }
        if (element.hasAddressElement()) {
            this.composeUrl(t, "CapabilityStatementMessagingEndpointComponent", "address", element.getAddressElement(), -1);
        }
    }

    protected void composeCapabilityStatementMessagingSupportedMessageComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supportedMessage", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "CapabilityStatementMessagingSupportedMessageComponent", "mode", element.getModeElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "CapabilityStatementMessagingSupportedMessageComponent", "definition", element.getDefinitionElement(), -1);
        }
    }

    protected void composeCapabilityStatementDocumentComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementDocumentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "document", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "CapabilityStatementDocumentComponent", "mode", element.getModeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatementDocumentComponent", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "CapabilityStatementDocumentComponent", "profile", element.getProfileElement(), -1);
        }
    }

    protected void composeCarePlan(Turtle.Complex parent, String parentType, String name, CarePlan element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CarePlan", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CarePlan", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "CarePlan", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "CarePlan", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "CarePlan", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeReference(t, "CarePlan", "replaces", element.getReplaces().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "CarePlan", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CarePlan", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "CarePlan", "intent", element.getIntentElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "CarePlan", "category", element.getCategory().get(i), i);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CarePlan", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CarePlan", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "CarePlan", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "CarePlan", "encounter", element.getEncounter(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CarePlan", "period", element.getPeriod(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "CarePlan", "created", element.getCreatedElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "CarePlan", "author", element.getAuthor(), -1);
        }
        for (i = 0; i < element.getContributor().size(); ++i) {
            this.composeReference(t, "CarePlan", "contributor", element.getContributor().get(i), i);
        }
        for (i = 0; i < element.getCareTeam().size(); ++i) {
            this.composeReference(t, "CarePlan", "careTeam", element.getCareTeam().get(i), i);
        }
        for (i = 0; i < element.getAddresses().size(); ++i) {
            this.composeReference(t, "CarePlan", "addresses", element.getAddresses().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeReference(t, "CarePlan", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getGoal().size(); ++i) {
            this.composeReference(t, "CarePlan", "goal", element.getGoal().get(i), i);
        }
        for (i = 0; i < element.getActivity().size(); ++i) {
            this.composeCarePlanActivityComponent(t, "CarePlan", "activity", element.getActivity().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "CarePlan", "note", element.getNote().get(i), i);
        }
    }

    protected void composeCarePlanActivityComponent(Turtle.Complex parent, String parentType, String name, CarePlan.CarePlanActivityComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "activity", name, element, index);
        for (i = 0; i < element.getOutcomeCodeableConcept().size(); ++i) {
            this.composeCodeableConcept(t, "CarePlanActivityComponent", "outcomeCodeableConcept", element.getOutcomeCodeableConcept().get(i), i);
        }
        for (i = 0; i < element.getOutcomeReference().size(); ++i) {
            this.composeReference(t, "CarePlanActivityComponent", "outcomeReference", element.getOutcomeReference().get(i), i);
        }
        for (i = 0; i < element.getProgress().size(); ++i) {
            this.composeAnnotation(t, "CarePlanActivityComponent", "progress", element.getProgress().get(i), i);
        }
        if (element.hasReference()) {
            this.composeReference(t, "CarePlanActivityComponent", "reference", element.getReference(), -1);
        }
        if (element.hasDetail()) {
            this.composeCarePlanActivityDetailComponent(t, "CarePlanActivityComponent", "detail", element.getDetail(), -1);
        }
    }

    protected void composeCarePlanActivityDetailComponent(Turtle.Complex parent, String parentType, String name, CarePlan.CarePlanActivityDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasKindElement()) {
            this.composeEnum(t, "CarePlanActivityDetailComponent", "kind", element.getKindElement(), -1);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "CarePlanActivityDetailComponent", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "CarePlanActivityDetailComponent", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "CarePlanActivityDetailComponent", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "CarePlanActivityDetailComponent", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "CarePlanActivityDetailComponent", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getGoal().size(); ++i) {
            this.composeReference(t, "CarePlanActivityDetailComponent", "goal", element.getGoal().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CarePlanActivityDetailComponent", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "CarePlanActivityDetailComponent", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "CarePlanActivityDetailComponent", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasScheduled()) {
            this.composeType(t, "CarePlanActivityDetailComponent", "scheduled", element.getScheduled(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "CarePlanActivityDetailComponent", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "CarePlanActivityDetailComponent", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasProduct()) {
            this.composeType(t, "CarePlanActivityDetailComponent", "product", element.getProduct(), -1);
        }
        if (element.hasDailyAmount()) {
            this.composeQuantity(t, "CarePlanActivityDetailComponent", "dailyAmount", element.getDailyAmount(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "CarePlanActivityDetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CarePlanActivityDetailComponent", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeCareTeam(Turtle.Complex parent, String parentType, String name, CareTeam element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CareTeam", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CareTeam", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CareTeam", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "CareTeam", "category", element.getCategory().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CareTeam", "name", element.getNameElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "CareTeam", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "CareTeam", "encounter", element.getEncounter(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CareTeam", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeCareTeamParticipantComponent(t, "CareTeam", "participant", element.getParticipant().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "CareTeam", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "CareTeam", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getManagingOrganization().size(); ++i) {
            this.composeReference(t, "CareTeam", "managingOrganization", element.getManagingOrganization().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "CareTeam", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "CareTeam", "note", element.getNote().get(i), i);
        }
    }

    protected void composeCareTeamParticipantComponent(Turtle.Complex parent, String parentType, String name, CareTeam.CareTeamParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        for (int i = 0; i < element.getRole().size(); ++i) {
            this.composeCodeableConcept(t, "CareTeamParticipantComponent", "role", element.getRole().get(i), i);
        }
        if (element.hasMember()) {
            this.composeReference(t, "CareTeamParticipantComponent", "member", element.getMember(), -1);
        }
        if (element.hasOnBehalfOf()) {
            this.composeReference(t, "CareTeamParticipantComponent", "onBehalfOf", element.getOnBehalfOf(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CareTeamParticipantComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeCatalogEntry(Turtle.Complex parent, String parentType, String name, CatalogEntry element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CatalogEntry", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CatalogEntry", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CatalogEntry", "type", element.getType(), -1);
        }
        if (element.hasOrderableElement()) {
            this.composeBoolean(t, "CatalogEntry", "orderable", element.getOrderableElement(), -1);
        }
        if (element.hasReferencedItem()) {
            this.composeReference(t, "CatalogEntry", "referencedItem", element.getReferencedItem(), -1);
        }
        for (i = 0; i < element.getAdditionalIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CatalogEntry", "additionalIdentifier", element.getAdditionalIdentifier().get(i), i);
        }
        for (i = 0; i < element.getClassification().size(); ++i) {
            this.composeCodeableConcept(t, "CatalogEntry", "classification", element.getClassification().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CatalogEntry", "status", element.getStatusElement(), -1);
        }
        if (element.hasValidityPeriod()) {
            this.composePeriod(t, "CatalogEntry", "validityPeriod", element.getValidityPeriod(), -1);
        }
        if (element.hasValidToElement()) {
            this.composeDateTime(t, "CatalogEntry", "validTo", element.getValidToElement(), -1);
        }
        if (element.hasLastUpdatedElement()) {
            this.composeDateTime(t, "CatalogEntry", "lastUpdated", element.getLastUpdatedElement(), -1);
        }
        for (i = 0; i < element.getAdditionalCharacteristic().size(); ++i) {
            this.composeCodeableConcept(t, "CatalogEntry", "additionalCharacteristic", element.getAdditionalCharacteristic().get(i), i);
        }
        for (i = 0; i < element.getAdditionalClassification().size(); ++i) {
            this.composeCodeableConcept(t, "CatalogEntry", "additionalClassification", element.getAdditionalClassification().get(i), i);
        }
        for (i = 0; i < element.getRelatedEntry().size(); ++i) {
            this.composeCatalogEntryRelatedEntryComponent(t, "CatalogEntry", "relatedEntry", element.getRelatedEntry().get(i), i);
        }
    }

    protected void composeCatalogEntryRelatedEntryComponent(Turtle.Complex parent, String parentType, String name, CatalogEntry.CatalogEntryRelatedEntryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatedEntry", name, element, index);
        if (element.hasRelationtypeElement()) {
            this.composeEnum(t, "CatalogEntryRelatedEntryComponent", "relationtype", element.getRelationtypeElement(), -1);
        }
        if (element.hasItem()) {
            this.composeReference(t, "CatalogEntryRelatedEntryComponent", "item", element.getItem(), -1);
        }
    }

    protected void composeChargeItem(Turtle.Complex parent, String parentType, String name, ChargeItem element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ChargeItem", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ChargeItem", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getDefinitionUri().size(); ++i) {
            this.composeUri(t, "ChargeItem", "definitionUri", element.getDefinitionUri().get(i), i);
        }
        for (i = 0; i < element.getDefinitionCanonical().size(); ++i) {
            this.composeCanonical(t, "ChargeItem", "definitionCanonical", element.getDefinitionCanonical().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ChargeItem", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "ChargeItem", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ChargeItem", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ChargeItem", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "ChargeItem", "context", element.getContext(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "ChargeItem", "occurrence", element.getOccurrence(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeChargeItemPerformerComponent(t, "ChargeItem", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasPerformingOrganization()) {
            this.composeReference(t, "ChargeItem", "performingOrganization", element.getPerformingOrganization(), -1);
        }
        if (element.hasRequestingOrganization()) {
            this.composeReference(t, "ChargeItem", "requestingOrganization", element.getRequestingOrganization(), -1);
        }
        if (element.hasCostCenter()) {
            this.composeReference(t, "ChargeItem", "costCenter", element.getCostCenter(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ChargeItem", "quantity", element.getQuantity(), -1);
        }
        for (i = 0; i < element.getBodysite().size(); ++i) {
            this.composeCodeableConcept(t, "ChargeItem", "bodysite", element.getBodysite().get(i), i);
        }
        if (element.hasFactorOverrideElement()) {
            this.composeDecimal(t, "ChargeItem", "factorOverride", element.getFactorOverrideElement(), -1);
        }
        if (element.hasPriceOverride()) {
            this.composeMoney(t, "ChargeItem", "priceOverride", element.getPriceOverride(), -1);
        }
        if (element.hasOverrideReasonElement()) {
            this.composeString(t, "ChargeItem", "overrideReason", element.getOverrideReasonElement(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "ChargeItem", "enterer", element.getEnterer(), -1);
        }
        if (element.hasEnteredDateElement()) {
            this.composeDateTime(t, "ChargeItem", "enteredDate", element.getEnteredDateElement(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "ChargeItem", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getService().size(); ++i) {
            this.composeReference(t, "ChargeItem", "service", element.getService().get(i), i);
        }
        if (element.hasProduct()) {
            this.composeType(t, "ChargeItem", "product", element.getProduct(), -1);
        }
        for (i = 0; i < element.getAccount().size(); ++i) {
            this.composeReference(t, "ChargeItem", "account", element.getAccount().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ChargeItem", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "ChargeItem", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
    }

    protected void composeChargeItemPerformerComponent(Turtle.Complex parent, String parentType, String name, ChargeItem.ChargeItemPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "ChargeItemPerformerComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "ChargeItemPerformerComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeChargeItemDefinition(Turtle.Complex parent, String parentType, String name, ChargeItemDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ChargeItemDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ChargeItemDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ChargeItemDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ChargeItemDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ChargeItemDefinition", "title", element.getTitleElement(), -1);
        }
        for (i = 0; i < element.getDerivedFromUri().size(); ++i) {
            this.composeUri(t, "ChargeItemDefinition", "derivedFromUri", element.getDerivedFromUri().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeCanonical(t, "ChargeItemDefinition", "partOf", element.getPartOf().get(i), i);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeCanonical(t, "ChargeItemDefinition", "replaces", element.getReplaces().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ChargeItemDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ChargeItemDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ChargeItemDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ChargeItemDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ChargeItemDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ChargeItemDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ChargeItemDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ChargeItemDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ChargeItemDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "ChargeItemDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "ChargeItemDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "ChargeItemDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ChargeItemDefinition", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getInstance().size(); ++i) {
            this.composeReference(t, "ChargeItemDefinition", "instance", element.getInstance().get(i), i);
        }
        for (i = 0; i < element.getApplicability().size(); ++i) {
            this.composeChargeItemDefinitionApplicabilityComponent(t, "ChargeItemDefinition", "applicability", element.getApplicability().get(i), i);
        }
        for (i = 0; i < element.getPropertyGroup().size(); ++i) {
            this.composeChargeItemDefinitionPropertyGroupComponent(t, "ChargeItemDefinition", "propertyGroup", element.getPropertyGroup().get(i), i);
        }
    }

    protected void composeChargeItemDefinitionApplicabilityComponent(Turtle.Complex parent, String parentType, String name, ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "applicability", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ChargeItemDefinitionApplicabilityComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeString(t, "ChargeItemDefinitionApplicabilityComponent", "language", element.getLanguageElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "ChargeItemDefinitionApplicabilityComponent", "expression", element.getExpressionElement(), -1);
        }
    }

    protected void composeChargeItemDefinitionPropertyGroupComponent(Turtle.Complex parent, String parentType, String name, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "propertyGroup", name, element, index);
        for (i = 0; i < element.getApplicability().size(); ++i) {
            this.composeChargeItemDefinitionApplicabilityComponent(t, "ChargeItemDefinitionPropertyGroupComponent", "applicability", element.getApplicability().get(i), i);
        }
        for (i = 0; i < element.getPriceComponent().size(); ++i) {
            this.composeChargeItemDefinitionPropertyGroupPriceComponentComponent(t, "ChargeItemDefinitionPropertyGroupComponent", "priceComponent", element.getPriceComponent().get(i), i);
        }
    }

    protected void composeChargeItemDefinitionPropertyGroupPriceComponentComponent(Turtle.Complex parent, String parentType, String name, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "priceComponent", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ChargeItemDefinitionPropertyGroupPriceComponentComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ChargeItemDefinitionPropertyGroupPriceComponentComponent", "code", element.getCode(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ChargeItemDefinitionPropertyGroupPriceComponentComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "ChargeItemDefinitionPropertyGroupPriceComponentComponent", "amount", element.getAmount(), -1);
        }
    }

    protected void composeCitation(Turtle.Complex parent, String parentType, String name, Citation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Citation", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Citation", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Citation", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Citation", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Citation", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Citation", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Citation", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "Citation", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Citation", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Citation", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "Citation", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Citation", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "Citation", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "Citation", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "Citation", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "Citation", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "Citation", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "Citation", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "Citation", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "Citation", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "Citation", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "Citation", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "Citation", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getSummary().size(); ++i) {
            this.composeContactDetail(t, "Citation", "summary", element.getSummary().get(i), i);
        }
        for (i = 0; i < element.getClassification().size(); ++i) {
            this.composeCitationClassificationComponent(t, "Citation", "classification", element.getClassification().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Citation", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getCurrentState().size(); ++i) {
            this.composeCodeableConcept(t, "Citation", "currentState", element.getCurrentState().get(i), i);
        }
        for (i = 0; i < element.getStatusDate().size(); ++i) {
            this.composeCitationStatusDateComponent(t, "Citation", "statusDate", element.getStatusDate().get(i), i);
        }
        for (i = 0; i < element.getRelatesTo().size(); ++i) {
            this.composeCitationRelatesToComponent(t, "Citation", "relatesTo", element.getRelatesTo().get(i), i);
        }
        if (element.hasCitedArtifact()) {
            this.composeCitationCitedArtifactComponent(t, "Citation", "citedArtifact", element.getCitedArtifact(), -1);
        }
    }

    protected void composeCitationClassificationComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationClassificationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "classification", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CitationClassificationComponent", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getClassifier().size(); ++i) {
            this.composeCodeableConcept(t, "CitationClassificationComponent", "classifier", element.getClassifier().get(i), i);
        }
    }

    protected void composeCitationStatusDateComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationStatusDateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "statusDate", name, element, index);
        if (element.hasActivity()) {
            this.composeCodeableConcept(t, "CitationStatusDateComponent", "activity", element.getActivity(), -1);
        }
        if (element.hasActualElement()) {
            this.composeBoolean(t, "CitationStatusDateComponent", "actual", element.getActualElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CitationStatusDateComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeCitationRelatesToComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationRelatesToComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatesTo", name, element, index);
        if (element.hasRelationshipType()) {
            this.composeCodeableConcept(t, "CitationRelatesToComponent", "relationshipType", element.getRelationshipType(), -1);
        }
        for (int i = 0; i < element.getTargetClassifier().size(); ++i) {
            this.composeCodeableConcept(t, "CitationRelatesToComponent", "targetClassifier", element.getTargetClassifier().get(i), i);
        }
        if (element.hasTarget()) {
            this.composeType(t, "CitationRelatesToComponent", "target", element.getTarget(), -1);
        }
    }

    protected void composeCitationCitedArtifactComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "citedArtifact", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CitationCitedArtifactComponent", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getRelatedIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CitationCitedArtifactComponent", "relatedIdentifier", element.getRelatedIdentifier().get(i), i);
        }
        if (element.hasDateAccessedElement()) {
            this.composeDateTime(t, "CitationCitedArtifactComponent", "dateAccessed", element.getDateAccessedElement(), -1);
        }
        if (element.hasVersion()) {
            this.composeCitationCitedArtifactVersionComponent(t, "CitationCitedArtifactComponent", "version", element.getVersion(), -1);
        }
        for (i = 0; i < element.getCurrentState().size(); ++i) {
            this.composeCodeableConcept(t, "CitationCitedArtifactComponent", "currentState", element.getCurrentState().get(i), i);
        }
        for (i = 0; i < element.getStatusDate().size(); ++i) {
            this.composeCitationCitedArtifactStatusDateComponent(t, "CitationCitedArtifactComponent", "statusDate", element.getStatusDate().get(i), i);
        }
        for (i = 0; i < element.getTitle().size(); ++i) {
            this.composeCitationCitedArtifactTitleComponent(t, "CitationCitedArtifactComponent", "title", element.getTitle().get(i), i);
        }
        for (i = 0; i < element.getAbstract().size(); ++i) {
            this.composeCitationCitedArtifactAbstractComponent(t, "CitationCitedArtifactComponent", "abstract", element.getAbstract().get(i), i);
        }
        if (element.hasPart()) {
            this.composeCitationCitedArtifactPartComponent(t, "CitationCitedArtifactComponent", "part", element.getPart(), -1);
        }
        for (i = 0; i < element.getRelatesTo().size(); ++i) {
            this.composeCitationCitedArtifactRelatesToComponent(t, "CitationCitedArtifactComponent", "relatesTo", element.getRelatesTo().get(i), i);
        }
        for (i = 0; i < element.getPublicationForm().size(); ++i) {
            this.composeCitationCitedArtifactPublicationFormComponent(t, "CitationCitedArtifactComponent", "publicationForm", element.getPublicationForm().get(i), i);
        }
        for (i = 0; i < element.getWebLocation().size(); ++i) {
            this.composeCitationCitedArtifactWebLocationComponent(t, "CitationCitedArtifactComponent", "webLocation", element.getWebLocation().get(i), i);
        }
        for (i = 0; i < element.getClassification().size(); ++i) {
            this.composeCitationCitedArtifactClassificationComponent(t, "CitationCitedArtifactComponent", "classification", element.getClassification().get(i), i);
        }
        if (element.hasContributorship()) {
            this.composeCitationCitedArtifactContributorshipComponent(t, "CitationCitedArtifactComponent", "contributorship", element.getContributorship(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "CitationCitedArtifactComponent", "note", element.getNote().get(i), i);
        }
    }

    protected void composeCitationCitedArtifactVersionComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactVersionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "version", name, element, index);
        if (element.hasValueElement()) {
            this.composeString(t, "CitationCitedArtifactVersionComponent", "value", element.getValueElement(), -1);
        }
        if (element.hasBaseCitation()) {
            this.composeReference(t, "CitationCitedArtifactVersionComponent", "baseCitation", element.getBaseCitation(), -1);
        }
    }

    protected void composeCitationCitedArtifactStatusDateComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactStatusDateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "statusDate", name, element, index);
        if (element.hasActivity()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactStatusDateComponent", "activity", element.getActivity(), -1);
        }
        if (element.hasActualElement()) {
            this.composeBoolean(t, "CitationCitedArtifactStatusDateComponent", "actual", element.getActualElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CitationCitedArtifactStatusDateComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeCitationCitedArtifactTitleComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactTitleComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "title", name, element, index);
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "CitationCitedArtifactTitleComponent", "type", element.getType().get(i), i);
        }
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactTitleComponent", "language", element.getLanguage(), -1);
        }
        if (element.hasTextElement()) {
            this.composeMarkdown(t, "CitationCitedArtifactTitleComponent", "text", element.getTextElement(), -1);
        }
    }

    protected void composeCitationCitedArtifactAbstractComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactAbstractComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "abstract", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactAbstractComponent", "type", element.getType(), -1);
        }
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactAbstractComponent", "language", element.getLanguage(), -1);
        }
        if (element.hasTextElement()) {
            this.composeMarkdown(t, "CitationCitedArtifactAbstractComponent", "text", element.getTextElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "CitationCitedArtifactAbstractComponent", "copyright", element.getCopyrightElement(), -1);
        }
    }

    protected void composeCitationCitedArtifactPartComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactPartComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "part", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactPartComponent", "type", element.getType(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "CitationCitedArtifactPartComponent", "value", element.getValueElement(), -1);
        }
        if (element.hasBaseCitation()) {
            this.composeReference(t, "CitationCitedArtifactPartComponent", "baseCitation", element.getBaseCitation(), -1);
        }
    }

    protected void composeCitationCitedArtifactRelatesToComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactRelatesToComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatesTo", name, element, index);
        if (element.hasRelationshipType()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactRelatesToComponent", "relationshipType", element.getRelationshipType(), -1);
        }
        for (int i = 0; i < element.getTargetClassifier().size(); ++i) {
            this.composeCodeableConcept(t, "CitationCitedArtifactRelatesToComponent", "targetClassifier", element.getTargetClassifier().get(i), i);
        }
        if (element.hasTarget()) {
            this.composeType(t, "CitationCitedArtifactRelatesToComponent", "target", element.getTarget(), -1);
        }
    }

    protected void composeCitationCitedArtifactPublicationFormComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactPublicationFormComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "publicationForm", name, element, index);
        if (element.hasPublishedIn()) {
            this.composeCitationCitedArtifactPublicationFormPublishedInComponent(t, "CitationCitedArtifactPublicationFormComponent", "publishedIn", element.getPublishedIn(), -1);
        }
        if (element.hasPeriodicRelease()) {
            this.composeCitationCitedArtifactPublicationFormPeriodicReleaseComponent(t, "CitationCitedArtifactPublicationFormComponent", "periodicRelease", element.getPeriodicRelease(), -1);
        }
        if (element.hasArticleDateElement()) {
            this.composeDateTime(t, "CitationCitedArtifactPublicationFormComponent", "articleDate", element.getArticleDateElement(), -1);
        }
        if (element.hasLastRevisionDateElement()) {
            this.composeDateTime(t, "CitationCitedArtifactPublicationFormComponent", "lastRevisionDate", element.getLastRevisionDateElement(), -1);
        }
        for (int i = 0; i < element.getLanguage().size(); ++i) {
            this.composeCodeableConcept(t, "CitationCitedArtifactPublicationFormComponent", "language", element.getLanguage().get(i), i);
        }
        if (element.hasAccessionNumberElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "accessionNumber", element.getAccessionNumberElement(), -1);
        }
        if (element.hasPageStringElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "pageString", element.getPageStringElement(), -1);
        }
        if (element.hasFirstPageElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "firstPage", element.getFirstPageElement(), -1);
        }
        if (element.hasLastPageElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "lastPage", element.getLastPageElement(), -1);
        }
        if (element.hasPageCountElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "pageCount", element.getPageCountElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "CitationCitedArtifactPublicationFormComponent", "copyright", element.getCopyrightElement(), -1);
        }
    }

    protected void composeCitationCitedArtifactPublicationFormPublishedInComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactPublicationFormPublishedInComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "publishedIn", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasPublisher()) {
            this.composeReference(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "publisher", element.getPublisher(), -1);
        }
        if (element.hasPublisherLocationElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "publisherLocation", element.getPublisherLocationElement(), -1);
        }
    }

    protected void composeCitationCitedArtifactPublicationFormPeriodicReleaseComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactPublicationFormPeriodicReleaseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "periodicRelease", name, element, index);
        if (element.hasCitedMedium()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactPublicationFormPeriodicReleaseComponent", "citedMedium", element.getCitedMedium(), -1);
        }
        if (element.hasVolumeElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormPeriodicReleaseComponent", "volume", element.getVolumeElement(), -1);
        }
        if (element.hasIssueElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormPeriodicReleaseComponent", "issue", element.getIssueElement(), -1);
        }
        if (element.hasDateOfPublication()) {
            this.composeCitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent(t, "CitationCitedArtifactPublicationFormPeriodicReleaseComponent", "dateOfPublication", element.getDateOfPublication(), -1);
        }
    }

    protected void composeCitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dateOfPublication", name, element, index);
        if (element.hasDateElement()) {
            this.composeDate(t, "CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasYearElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent", "year", element.getYearElement(), -1);
        }
        if (element.hasMonthElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent", "month", element.getMonthElement(), -1);
        }
        if (element.hasDayElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent", "day", element.getDayElement(), -1);
        }
        if (element.hasSeasonElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent", "season", element.getSeasonElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent", "text", element.getTextElement(), -1);
        }
    }

    protected void composeCitationCitedArtifactWebLocationComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactWebLocationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "webLocation", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactWebLocationComponent", "type", element.getType(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "CitationCitedArtifactWebLocationComponent", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeCitationCitedArtifactClassificationComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactClassificationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "classification", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactClassificationComponent", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getClassifier().size(); ++i) {
            this.composeCodeableConcept(t, "CitationCitedArtifactClassificationComponent", "classifier", element.getClassifier().get(i), i);
        }
        if (element.hasWhoClassified()) {
            this.composeCitationCitedArtifactClassificationWhoClassifiedComponent(t, "CitationCitedArtifactClassificationComponent", "whoClassified", element.getWhoClassified(), -1);
        }
    }

    protected void composeCitationCitedArtifactClassificationWhoClassifiedComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactClassificationWhoClassifiedComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "whoClassified", name, element, index);
        if (element.hasPerson()) {
            this.composeReference(t, "CitationCitedArtifactClassificationWhoClassifiedComponent", "person", element.getPerson(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "CitationCitedArtifactClassificationWhoClassifiedComponent", "organization", element.getOrganization(), -1);
        }
        if (element.hasPublisher()) {
            this.composeReference(t, "CitationCitedArtifactClassificationWhoClassifiedComponent", "publisher", element.getPublisher(), -1);
        }
        if (element.hasClassifierCopyrightElement()) {
            this.composeString(t, "CitationCitedArtifactClassificationWhoClassifiedComponent", "classifierCopyright", element.getClassifierCopyrightElement(), -1);
        }
        if (element.hasFreeToShareElement()) {
            this.composeBoolean(t, "CitationCitedArtifactClassificationWhoClassifiedComponent", "freeToShare", element.getFreeToShareElement(), -1);
        }
    }

    protected void composeCitationCitedArtifactContributorshipComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactContributorshipComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contributorship", name, element, index);
        if (element.hasCompleteElement()) {
            this.composeBoolean(t, "CitationCitedArtifactContributorshipComponent", "complete", element.getCompleteElement(), -1);
        }
        for (i = 0; i < element.getEntry().size(); ++i) {
            this.composeCitationCitedArtifactContributorshipEntryComponent(t, "CitationCitedArtifactContributorshipComponent", "entry", element.getEntry().get(i), i);
        }
        for (i = 0; i < element.getSummary().size(); ++i) {
            this.composeCitationCitedArtifactContributorshipSummaryComponent(t, "CitationCitedArtifactContributorshipComponent", "summary", element.getSummary().get(i), i);
        }
    }

    protected void composeCitationCitedArtifactContributorshipEntryComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactContributorshipEntryComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entry", name, element, index);
        if (element.hasName()) {
            this.composeHumanName(t, "CitationCitedArtifactContributorshipEntryComponent", "name", element.getName(), -1);
        }
        if (element.hasInitialsElement()) {
            this.composeString(t, "CitationCitedArtifactContributorshipEntryComponent", "initials", element.getInitialsElement(), -1);
        }
        if (element.hasCollectiveNameElement()) {
            this.composeString(t, "CitationCitedArtifactContributorshipEntryComponent", "collectiveName", element.getCollectiveNameElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CitationCitedArtifactContributorshipEntryComponent", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getAffiliationInfo().size(); ++i) {
            this.composeCitationCitedArtifactContributorshipEntryAffiliationInfoComponent(t, "CitationCitedArtifactContributorshipEntryComponent", "affiliationInfo", element.getAffiliationInfo().get(i), i);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "CitationCitedArtifactContributorshipEntryComponent", "address", element.getAddress().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "CitationCitedArtifactContributorshipEntryComponent", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getContributionType().size(); ++i) {
            this.composeCodeableConcept(t, "CitationCitedArtifactContributorshipEntryComponent", "contributionType", element.getContributionType().get(i), i);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactContributorshipEntryComponent", "role", element.getRole(), -1);
        }
        for (i = 0; i < element.getContributionInstance().size(); ++i) {
            this.composeCitationCitedArtifactContributorshipEntryContributionInstanceComponent(t, "CitationCitedArtifactContributorshipEntryComponent", "contributionInstance", element.getContributionInstance().get(i), i);
        }
        if (element.hasCorrespondingContactElement()) {
            this.composeBoolean(t, "CitationCitedArtifactContributorshipEntryComponent", "correspondingContact", element.getCorrespondingContactElement(), -1);
        }
        if (element.hasListOrderElement()) {
            this.composePositiveInt(t, "CitationCitedArtifactContributorshipEntryComponent", "listOrder", element.getListOrderElement(), -1);
        }
    }

    protected void composeCitationCitedArtifactContributorshipEntryAffiliationInfoComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactContributorshipEntryAffiliationInfoComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "affiliationInfo", name, element, index);
        if (element.hasAffiliationElement()) {
            this.composeString(t, "CitationCitedArtifactContributorshipEntryAffiliationInfoComponent", "affiliation", element.getAffiliationElement(), -1);
        }
        if (element.hasRoleElement()) {
            this.composeString(t, "CitationCitedArtifactContributorshipEntryAffiliationInfoComponent", "role", element.getRoleElement(), -1);
        }
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CitationCitedArtifactContributorshipEntryAffiliationInfoComponent", "identifier", element.getIdentifier().get(i), i);
        }
    }

    protected void composeCitationCitedArtifactContributorshipEntryContributionInstanceComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contributionInstance", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactContributorshipEntryContributionInstanceComponent", "type", element.getType(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeDateTime(t, "CitationCitedArtifactContributorshipEntryContributionInstanceComponent", "time", element.getTimeElement(), -1);
        }
    }

    protected void composeCitationCitedArtifactContributorshipSummaryComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactContributorshipSummaryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "summary", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactContributorshipSummaryComponent", "type", element.getType(), -1);
        }
        if (element.hasStyle()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactContributorshipSummaryComponent", "style", element.getStyle(), -1);
        }
        if (element.hasSource()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactContributorshipSummaryComponent", "source", element.getSource(), -1);
        }
        if (element.hasValueElement()) {
            this.composeMarkdown(t, "CitationCitedArtifactContributorshipSummaryComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeClaim(Turtle.Complex parent, String parentType, String name, Claim element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Claim", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Claim", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Claim", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Claim", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "Claim", "subType", element.getSubType(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "Claim", "use", element.getUseElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Claim", "patient", element.getPatient(), -1);
        }
        if (element.hasBillablePeriod()) {
            this.composePeriod(t, "Claim", "billablePeriod", element.getBillablePeriod(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "Claim", "created", element.getCreatedElement(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "Claim", "enterer", element.getEnterer(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "Claim", "insurer", element.getInsurer(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "Claim", "provider", element.getProvider(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "Claim", "priority", element.getPriority(), -1);
        }
        if (element.hasFundsReserve()) {
            this.composeCodeableConcept(t, "Claim", "fundsReserve", element.getFundsReserve(), -1);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeClaimRelatedClaimComponent(t, "Claim", "related", element.getRelated().get(i), i);
        }
        if (element.hasPrescription()) {
            this.composeReference(t, "Claim", "prescription", element.getPrescription(), -1);
        }
        if (element.hasOriginalPrescription()) {
            this.composeReference(t, "Claim", "originalPrescription", element.getOriginalPrescription(), -1);
        }
        if (element.hasPayee()) {
            this.composeClaimPayeeComponent(t, "Claim", "payee", element.getPayee(), -1);
        }
        if (element.hasReferral()) {
            this.composeReference(t, "Claim", "referral", element.getReferral(), -1);
        }
        if (element.hasFacility()) {
            this.composeReference(t, "Claim", "facility", element.getFacility(), -1);
        }
        for (i = 0; i < element.getCareTeam().size(); ++i) {
            this.composeClaimCareTeamComponent(t, "Claim", "careTeam", element.getCareTeam().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeClaimSupportingInformationComponent(t, "Claim", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeClaimDiagnosisComponent(t, "Claim", "diagnosis", element.getDiagnosis().get(i), i);
        }
        for (i = 0; i < element.getProcedure().size(); ++i) {
            this.composeClaimProcedureComponent(t, "Claim", "procedure", element.getProcedure().get(i), i);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeClaimInsuranceComponent(t, "Claim", "insurance", element.getInsurance().get(i), i);
        }
        if (element.hasAccident()) {
            this.composeClaimAccidentComponent(t, "Claim", "accident", element.getAccident(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeClaimItemComponent(t, "Claim", "item", element.getItem().get(i), i);
        }
        if (element.hasTotal()) {
            this.composeMoney(t, "Claim", "total", element.getTotal(), -1);
        }
    }

    protected void composeClaimRelatedClaimComponent(Turtle.Complex parent, String parentType, String name, Claim.RelatedClaimComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasClaim()) {
            this.composeReference(t, "RelatedClaimComponent", "claim", element.getClaim(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "RelatedClaimComponent", "relationship", element.getRelationship(), -1);
        }
        if (element.hasReference()) {
            this.composeIdentifier(t, "RelatedClaimComponent", "reference", element.getReference(), -1);
        }
    }

    protected void composeClaimPayeeComponent(Turtle.Complex parent, String parentType, String name, Claim.PayeeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payee", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PayeeComponent", "type", element.getType(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "PayeeComponent", "party", element.getParty(), -1);
        }
    }

    protected void composeClaimCareTeamComponent(Turtle.Complex parent, String parentType, String name, Claim.CareTeamComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "careTeam", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "CareTeamComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "CareTeamComponent", "provider", element.getProvider(), -1);
        }
        if (element.hasResponsibleElement()) {
            this.composeBoolean(t, "CareTeamComponent", "responsible", element.getResponsibleElement(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "CareTeamComponent", "role", element.getRole(), -1);
        }
        if (element.hasQualification()) {
            this.composeCodeableConcept(t, "CareTeamComponent", "qualification", element.getQualification(), -1);
        }
    }

    protected void composeClaimSupportingInformationComponent(Turtle.Complex parent, String parentType, String name, Claim.SupportingInformationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supportingInfo", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "SupportingInformationComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "SupportingInformationComponent", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "SupportingInformationComponent", "code", element.getCode(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "SupportingInformationComponent", "timing", element.getTiming(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "SupportingInformationComponent", "value", element.getValue(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "SupportingInformationComponent", "reason", element.getReason(), -1);
        }
    }

    protected void composeClaimDiagnosisComponent(Turtle.Complex parent, String parentType, String name, Claim.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "DiagnosisComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasDiagnosis()) {
            this.composeType(t, "DiagnosisComponent", "diagnosis", element.getDiagnosis(), -1);
        }
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "DiagnosisComponent", "type", element.getType().get(i), i);
        }
        if (element.hasOnAdmission()) {
            this.composeCodeableConcept(t, "DiagnosisComponent", "onAdmission", element.getOnAdmission(), -1);
        }
        if (element.hasPackageCode()) {
            this.composeCodeableConcept(t, "DiagnosisComponent", "packageCode", element.getPackageCode(), -1);
        }
    }

    protected void composeClaimProcedureComponent(Turtle.Complex parent, String parentType, String name, Claim.ProcedureComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "procedure", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ProcedureComponent", "sequence", element.getSequenceElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "ProcedureComponent", "type", element.getType().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ProcedureComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeType(t, "ProcedureComponent", "procedure", element.getProcedure(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "ProcedureComponent", "udi", element.getUdi().get(i), i);
        }
    }

    protected void composeClaimInsuranceComponent(Turtle.Complex parent, String parentType, String name, Claim.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "InsuranceComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasFocalElement()) {
            this.composeBoolean(t, "InsuranceComponent", "focal", element.getFocalElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "InsuranceComponent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeString(t, "InsuranceComponent", "businessArrangement", element.getBusinessArrangementElement(), -1);
        }
        for (int i = 0; i < element.getPreAuthRef().size(); ++i) {
            this.composeString(t, "InsuranceComponent", "preAuthRef", element.getPreAuthRef().get(i), i);
        }
        if (element.hasClaimResponse()) {
            this.composeReference(t, "InsuranceComponent", "claimResponse", element.getClaimResponse(), -1);
        }
    }

    protected void composeClaimAccidentComponent(Turtle.Complex parent, String parentType, String name, Claim.AccidentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "accident", name, element, index);
        if (element.hasDateElement()) {
            this.composeDate(t, "AccidentComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "AccidentComponent", "type", element.getType(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "AccidentComponent", "location", element.getLocation(), -1);
        }
    }

    protected void composeClaimItemComponent(Turtle.Complex parent, String parentType, String name, Claim.ItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ItemComponent", "sequence", element.getSequenceElement(), -1);
        }
        for (i = 0; i < element.getCareTeamSequence().size(); ++i) {
            this.composePositiveInt(t, "ItemComponent", "careTeamSequence", element.getCareTeamSequence().get(i), i);
        }
        for (i = 0; i < element.getDiagnosisSequence().size(); ++i) {
            this.composePositiveInt(t, "ItemComponent", "diagnosisSequence", element.getDiagnosisSequence().get(i), i);
        }
        for (i = 0; i < element.getProcedureSequence().size(); ++i) {
            this.composePositiveInt(t, "ItemComponent", "procedureSequence", element.getProcedureSequence().get(i), i);
        }
        for (i = 0; i < element.getInformationSequence().size(); ++i) {
            this.composePositiveInt(t, "ItemComponent", "informationSequence", element.getInformationSequence().get(i), i);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "ItemComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ItemComponent", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "ItemComponent", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ItemComponent", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "ItemComponent", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasServiced()) {
            this.composeType(t, "ItemComponent", "serviced", element.getServiced(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "ItemComponent", "location", element.getLocation(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ItemComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ItemComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ItemComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ItemComponent", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "ItemComponent", "udi", element.getUdi().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "ItemComponent", "bodySite", element.getBodySite(), -1);
        }
        for (i = 0; i < element.getSubSite().size(); ++i) {
            this.composeCodeableConcept(t, "ItemComponent", "subSite", element.getSubSite().get(i), i);
        }
        for (i = 0; i < element.getEncounter().size(); ++i) {
            this.composeReference(t, "ItemComponent", "encounter", element.getEncounter().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeClaimDetailComponent(t, "ItemComponent", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeClaimDetailComponent(Turtle.Complex parent, String parentType, String name, Claim.DetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "DetailComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "DetailComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "DetailComponent", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "DetailComponent", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "DetailComponent", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "DetailComponent", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "DetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "DetailComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "DetailComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "DetailComponent", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "DetailComponent", "udi", element.getUdi().get(i), i);
        }
        for (i = 0; i < element.getSubDetail().size(); ++i) {
            this.composeClaimSubDetailComponent(t, "DetailComponent", "subDetail", element.getSubDetail().get(i), i);
        }
    }

    protected void composeClaimSubDetailComponent(Turtle.Complex parent, String parentType, String name, Claim.SubDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "SubDetailComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "SubDetailComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "SubDetailComponent", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "SubDetailComponent", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "SubDetailComponent", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "SubDetailComponent", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "SubDetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "SubDetailComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "SubDetailComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "SubDetailComponent", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "SubDetailComponent", "udi", element.getUdi().get(i), i);
        }
    }

    protected void composeClaimResponse(Turtle.Complex parent, String parentType, String name, ClaimResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ClaimResponse", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ClaimResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ClaimResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ClaimResponse", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "ClaimResponse", "subType", element.getSubType(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ClaimResponse", "use", element.getUseElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ClaimResponse", "patient", element.getPatient(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "ClaimResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "ClaimResponse", "insurer", element.getInsurer(), -1);
        }
        if (element.hasRequestor()) {
            this.composeReference(t, "ClaimResponse", "requestor", element.getRequestor(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "ClaimResponse", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "ClaimResponse", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "ClaimResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasPreAuthRefElement()) {
            this.composeString(t, "ClaimResponse", "preAuthRef", element.getPreAuthRefElement(), -1);
        }
        if (element.hasPreAuthPeriod()) {
            this.composePeriod(t, "ClaimResponse", "preAuthPeriod", element.getPreAuthPeriod(), -1);
        }
        if (element.hasPayeeType()) {
            this.composeCodeableConcept(t, "ClaimResponse", "payeeType", element.getPayeeType(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeClaimResponseItemComponent(t, "ClaimResponse", "item", element.getItem().get(i), i);
        }
        for (i = 0; i < element.getAddItem().size(); ++i) {
            this.composeClaimResponseAddedItemComponent(t, "ClaimResponse", "addItem", element.getAddItem().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getTotal().size(); ++i) {
            this.composeClaimResponseTotalComponent(t, "ClaimResponse", "total", element.getTotal().get(i), i);
        }
        if (element.hasPayment()) {
            this.composeClaimResponsePaymentComponent(t, "ClaimResponse", "payment", element.getPayment(), -1);
        }
        if (element.hasFundsReserve()) {
            this.composeCodeableConcept(t, "ClaimResponse", "fundsReserve", element.getFundsReserve(), -1);
        }
        if (element.hasFormCode()) {
            this.composeCodeableConcept(t, "ClaimResponse", "formCode", element.getFormCode(), -1);
        }
        if (element.hasForm()) {
            this.composeAttachment(t, "ClaimResponse", "form", element.getForm(), -1);
        }
        for (i = 0; i < element.getProcessNote().size(); ++i) {
            this.composeClaimResponseNoteComponent(t, "ClaimResponse", "processNote", element.getProcessNote().get(i), i);
        }
        for (i = 0; i < element.getCommunicationRequest().size(); ++i) {
            this.composeReference(t, "ClaimResponse", "communicationRequest", element.getCommunicationRequest().get(i), i);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeClaimResponseInsuranceComponent(t, "ClaimResponse", "insurance", element.getInsurance().get(i), i);
        }
        for (i = 0; i < element.getError().size(); ++i) {
            this.composeClaimResponseErrorComponent(t, "ClaimResponse", "error", element.getError().get(i), i);
        }
    }

    protected void composeClaimResponseItemComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.ItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasItemSequenceElement()) {
            this.composePositiveInt(t, "ItemComponent", "itemSequence", element.getItemSequenceElement(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ItemComponent", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "ItemComponent", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeClaimResponseItemDetailComponent(t, "ItemComponent", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeClaimResponseAdjudicationComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.AdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "AdjudicationComponent", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "AdjudicationComponent", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "AdjudicationComponent", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "AdjudicationComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeClaimResponseItemDetailComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.ItemDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasDetailSequenceElement()) {
            this.composePositiveInt(t, "ItemDetailComponent", "detailSequence", element.getDetailSequenceElement(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ItemDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "ItemDetailComponent", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getSubDetail().size(); ++i) {
            this.composeClaimResponseSubDetailComponent(t, "ItemDetailComponent", "subDetail", element.getSubDetail().get(i), i);
        }
    }

    protected void composeClaimResponseSubDetailComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.SubDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasSubDetailSequenceElement()) {
            this.composePositiveInt(t, "SubDetailComponent", "subDetailSequence", element.getSubDetailSequenceElement(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "SubDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "SubDetailComponent", "adjudication", element.getAdjudication().get(i), i);
        }
    }

    protected void composeClaimResponseAddedItemComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.AddedItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "addItem", name, element, index);
        for (i = 0; i < element.getItemSequence().size(); ++i) {
            this.composePositiveInt(t, "AddedItemComponent", "itemSequence", element.getItemSequence().get(i), i);
        }
        for (i = 0; i < element.getDetailSequence().size(); ++i) {
            this.composePositiveInt(t, "AddedItemComponent", "detailSequence", element.getDetailSequence().get(i), i);
        }
        for (i = 0; i < element.getSubdetailSequence().size(); ++i) {
            this.composePositiveInt(t, "AddedItemComponent", "subdetailSequence", element.getSubdetailSequence().get(i), i);
        }
        for (i = 0; i < element.getProvider().size(); ++i) {
            this.composeReference(t, "AddedItemComponent", "provider", element.getProvider().get(i), i);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "AddedItemComponent", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "AddedItemComponent", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "AddedItemComponent", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasServiced()) {
            this.composeType(t, "AddedItemComponent", "serviced", element.getServiced(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "AddedItemComponent", "location", element.getLocation(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "AddedItemComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "AddedItemComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "AddedItemComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "AddedItemComponent", "net", element.getNet(), -1);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "AddedItemComponent", "bodySite", element.getBodySite(), -1);
        }
        for (i = 0; i < element.getSubSite().size(); ++i) {
            this.composeCodeableConcept(t, "AddedItemComponent", "subSite", element.getSubSite().get(i), i);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "AddedItemComponent", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "AddedItemComponent", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeClaimResponseAddedItemDetailComponent(t, "AddedItemComponent", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeClaimResponseAddedItemDetailComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.AddedItemDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "AddedItemDetailComponent", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "AddedItemDetailComponent", "modifier", element.getModifier().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "AddedItemDetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "AddedItemDetailComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "AddedItemDetailComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "AddedItemDetailComponent", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "AddedItemDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "AddedItemDetailComponent", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getSubDetail().size(); ++i) {
            this.composeClaimResponseAddedItemSubDetailComponent(t, "AddedItemDetailComponent", "subDetail", element.getSubDetail().get(i), i);
        }
    }

    protected void composeClaimResponseAddedItemSubDetailComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.AddedItemSubDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "AddedItemSubDetailComponent", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "AddedItemSubDetailComponent", "modifier", element.getModifier().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "AddedItemSubDetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "AddedItemSubDetailComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "AddedItemSubDetailComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "AddedItemSubDetailComponent", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "AddedItemSubDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAdjudicationComponent(t, "AddedItemSubDetailComponent", "adjudication", element.getAdjudication().get(i), i);
        }
    }

    protected void composeClaimResponseTotalComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.TotalComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "total", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "TotalComponent", "category", element.getCategory(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "TotalComponent", "amount", element.getAmount(), -1);
        }
    }

    protected void composeClaimResponsePaymentComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.PaymentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payment", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PaymentComponent", "type", element.getType(), -1);
        }
        if (element.hasAdjustment()) {
            this.composeMoney(t, "PaymentComponent", "adjustment", element.getAdjustment(), -1);
        }
        if (element.hasAdjustmentReason()) {
            this.composeCodeableConcept(t, "PaymentComponent", "adjustmentReason", element.getAdjustmentReason(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDate(t, "PaymentComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "PaymentComponent", "amount", element.getAmount(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "PaymentComponent", "identifier", element.getIdentifier(), -1);
        }
    }

    protected void composeClaimResponseNoteComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.NoteComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "processNote", name, element, index);
        if (element.hasNumberElement()) {
            this.composePositiveInt(t, "NoteComponent", "number", element.getNumberElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "NoteComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "NoteComponent", "text", element.getTextElement(), -1);
        }
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "NoteComponent", "language", element.getLanguage(), -1);
        }
    }

    protected void composeClaimResponseInsuranceComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "InsuranceComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasFocalElement()) {
            this.composeBoolean(t, "InsuranceComponent", "focal", element.getFocalElement(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeString(t, "InsuranceComponent", "businessArrangement", element.getBusinessArrangementElement(), -1);
        }
        if (element.hasClaimResponse()) {
            this.composeReference(t, "InsuranceComponent", "claimResponse", element.getClaimResponse(), -1);
        }
    }

    protected void composeClaimResponseErrorComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.ErrorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "error", name, element, index);
        if (element.hasItemSequenceElement()) {
            this.composePositiveInt(t, "ErrorComponent", "itemSequence", element.getItemSequenceElement(), -1);
        }
        if (element.hasDetailSequenceElement()) {
            this.composePositiveInt(t, "ErrorComponent", "detailSequence", element.getDetailSequenceElement(), -1);
        }
        if (element.hasSubDetailSequenceElement()) {
            this.composePositiveInt(t, "ErrorComponent", "subDetailSequence", element.getSubDetailSequenceElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ErrorComponent", "code", element.getCode(), -1);
        }
    }

    protected void composeClinicalImpression(Turtle.Complex parent, String parentType, String name, ClinicalImpression element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ClinicalImpression", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ClinicalImpression", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ClinicalImpression", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "ClinicalImpression", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ClinicalImpression", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ClinicalImpression", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ClinicalImpression", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "ClinicalImpression", "encounter", element.getEncounter(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "ClinicalImpression", "effective", element.getEffective(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ClinicalImpression", "date", element.getDateElement(), -1);
        }
        if (element.hasAssessor()) {
            this.composeReference(t, "ClinicalImpression", "assessor", element.getAssessor(), -1);
        }
        if (element.hasPrevious()) {
            this.composeReference(t, "ClinicalImpression", "previous", element.getPrevious(), -1);
        }
        for (i = 0; i < element.getProblem().size(); ++i) {
            this.composeReference(t, "ClinicalImpression", "problem", element.getProblem().get(i), i);
        }
        for (i = 0; i < element.getInvestigation().size(); ++i) {
            this.composeClinicalImpressionInvestigationComponent(t, "ClinicalImpression", "investigation", element.getInvestigation().get(i), i);
        }
        for (i = 0; i < element.getProtocol().size(); ++i) {
            this.composeUri(t, "ClinicalImpression", "protocol", element.getProtocol().get(i), i);
        }
        if (element.hasSummaryElement()) {
            this.composeString(t, "ClinicalImpression", "summary", element.getSummaryElement(), -1);
        }
        for (i = 0; i < element.getFinding().size(); ++i) {
            this.composeClinicalImpressionFindingComponent(t, "ClinicalImpression", "finding", element.getFinding().get(i), i);
        }
        for (i = 0; i < element.getPrognosisCodeableConcept().size(); ++i) {
            this.composeCodeableConcept(t, "ClinicalImpression", "prognosisCodeableConcept", element.getPrognosisCodeableConcept().get(i), i);
        }
        for (i = 0; i < element.getPrognosisReference().size(); ++i) {
            this.composeReference(t, "ClinicalImpression", "prognosisReference", element.getPrognosisReference().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeReference(t, "ClinicalImpression", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ClinicalImpression", "note", element.getNote().get(i), i);
        }
    }

    protected void composeClinicalImpressionInvestigationComponent(Turtle.Complex parent, String parentType, String name, ClinicalImpression.ClinicalImpressionInvestigationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "investigation", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ClinicalImpressionInvestigationComponent", "code", element.getCode(), -1);
        }
        for (int i = 0; i < element.getItem().size(); ++i) {
            this.composeReference(t, "ClinicalImpressionInvestigationComponent", "item", element.getItem().get(i), i);
        }
    }

    protected void composeClinicalImpressionFindingComponent(Turtle.Complex parent, String parentType, String name, ClinicalImpression.ClinicalImpressionFindingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "finding", name, element, index);
        if (element.hasItemCodeableConcept()) {
            this.composeCodeableConcept(t, "ClinicalImpressionFindingComponent", "itemCodeableConcept", element.getItemCodeableConcept(), -1);
        }
        if (element.hasItemReference()) {
            this.composeReference(t, "ClinicalImpressionFindingComponent", "itemReference", element.getItemReference(), -1);
        }
        if (element.hasBasisElement()) {
            this.composeString(t, "ClinicalImpressionFindingComponent", "basis", element.getBasisElement(), -1);
        }
    }

    protected void composeClinicalUseDefinition(Turtle.Complex parent, String parentType, String name, ClinicalUseDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ClinicalUseDefinition", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ClinicalUseDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ClinicalUseDefinition", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "ClinicalUseDefinition", "category", element.getCategory().get(i), i);
        }
        for (i = 0; i < element.getSubject().size(); ++i) {
            this.composeReference(t, "ClinicalUseDefinition", "subject", element.getSubject().get(i), i);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "ClinicalUseDefinition", "status", element.getStatus(), -1);
        }
        if (element.hasContraindication()) {
            this.composeClinicalUseDefinitionContraindicationComponent(t, "ClinicalUseDefinition", "contraindication", element.getContraindication(), -1);
        }
        if (element.hasIndication()) {
            this.composeClinicalUseDefinitionIndicationComponent(t, "ClinicalUseDefinition", "indication", element.getIndication(), -1);
        }
        if (element.hasInteraction()) {
            this.composeClinicalUseDefinitionInteractionComponent(t, "ClinicalUseDefinition", "interaction", element.getInteraction(), -1);
        }
        for (i = 0; i < element.getPopulation().size(); ++i) {
            this.composeReference(t, "ClinicalUseDefinition", "population", element.getPopulation().get(i), i);
        }
        if (element.hasUndesirableEffect()) {
            this.composeClinicalUseDefinitionUndesirableEffectComponent(t, "ClinicalUseDefinition", "undesirableEffect", element.getUndesirableEffect(), -1);
        }
        if (element.hasWarning()) {
            this.composeClinicalUseDefinitionWarningComponent(t, "ClinicalUseDefinition", "warning", element.getWarning(), -1);
        }
    }

    protected void composeClinicalUseDefinitionContraindicationComponent(Turtle.Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contraindication", name, element, index);
        if (element.hasDiseaseSymptomProcedure()) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionContraindicationComponent", "diseaseSymptomProcedure", element.getDiseaseSymptomProcedure(), -1);
        }
        if (element.hasDiseaseStatus()) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionContraindicationComponent", "diseaseStatus", element.getDiseaseStatus(), -1);
        }
        for (i = 0; i < element.getComorbidity().size(); ++i) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionContraindicationComponent", "comorbidity", element.getComorbidity().get(i), i);
        }
        for (i = 0; i < element.getIndication().size(); ++i) {
            this.composeReference(t, "ClinicalUseDefinitionContraindicationComponent", "indication", element.getIndication().get(i), i);
        }
        for (i = 0; i < element.getOtherTherapy().size(); ++i) {
            this.composeClinicalUseDefinitionContraindicationOtherTherapyComponent(t, "ClinicalUseDefinitionContraindicationComponent", "otherTherapy", element.getOtherTherapy().get(i), i);
        }
    }

    protected void composeClinicalUseDefinitionContraindicationOtherTherapyComponent(Turtle.Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "otherTherapy", name, element, index);
        if (element.hasRelationshipType()) {
            this.composeCodeableConcept(t, "ClinicalUseDefinitionContraindicationOtherTherapyComponent", "relationshipType", element.getRelationshipType(), -1);
        }
        if (element.hasTherapy()) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionContraindicationOtherTherapyComponent", "therapy", element.getTherapy(), -1);
        }
    }

    protected void composeClinicalUseDefinitionIndicationComponent(Turtle.Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "indication", name, element, index);
        if (element.hasDiseaseSymptomProcedure()) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionIndicationComponent", "diseaseSymptomProcedure", element.getDiseaseSymptomProcedure(), -1);
        }
        if (element.hasDiseaseStatus()) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionIndicationComponent", "diseaseStatus", element.getDiseaseStatus(), -1);
        }
        for (i = 0; i < element.getComorbidity().size(); ++i) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionIndicationComponent", "comorbidity", element.getComorbidity().get(i), i);
        }
        if (element.hasIntendedEffect()) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionIndicationComponent", "intendedEffect", element.getIntendedEffect(), -1);
        }
        if (element.hasDuration()) {
            this.composeQuantity(t, "ClinicalUseDefinitionIndicationComponent", "duration", element.getDuration(), -1);
        }
        for (i = 0; i < element.getUndesirableEffect().size(); ++i) {
            this.composeReference(t, "ClinicalUseDefinitionIndicationComponent", "undesirableEffect", element.getUndesirableEffect().get(i), i);
        }
        for (i = 0; i < element.getOtherTherapy().size(); ++i) {
            this.composeClinicalUseDefinitionContraindicationOtherTherapyComponent(t, "ClinicalUseDefinitionIndicationComponent", "otherTherapy", element.getOtherTherapy().get(i), i);
        }
    }

    protected void composeClinicalUseDefinitionInteractionComponent(Turtle.Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "interaction", name, element, index);
        for (i = 0; i < element.getInteractant().size(); ++i) {
            this.composeClinicalUseDefinitionInteractionInteractantComponent(t, "ClinicalUseDefinitionInteractionComponent", "interactant", element.getInteractant().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ClinicalUseDefinitionInteractionComponent", "type", element.getType(), -1);
        }
        if (element.hasEffect()) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionInteractionComponent", "effect", element.getEffect(), -1);
        }
        if (element.hasIncidence()) {
            this.composeCodeableConcept(t, "ClinicalUseDefinitionInteractionComponent", "incidence", element.getIncidence(), -1);
        }
        for (i = 0; i < element.getManagement().size(); ++i) {
            this.composeCodeableConcept(t, "ClinicalUseDefinitionInteractionComponent", "management", element.getManagement().get(i), i);
        }
    }

    protected void composeClinicalUseDefinitionInteractionInteractantComponent(Turtle.Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "interactant", name, element, index);
        if (element.hasItem()) {
            this.composeType(t, "ClinicalUseDefinitionInteractionInteractantComponent", "item", element.getItem(), -1);
        }
    }

    protected void composeClinicalUseDefinitionUndesirableEffectComponent(Turtle.Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "undesirableEffect", name, element, index);
        if (element.hasSymptomConditionEffect()) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionUndesirableEffectComponent", "symptomConditionEffect", element.getSymptomConditionEffect(), -1);
        }
        if (element.hasClassification()) {
            this.composeCodeableConcept(t, "ClinicalUseDefinitionUndesirableEffectComponent", "classification", element.getClassification(), -1);
        }
        if (element.hasFrequencyOfOccurrence()) {
            this.composeCodeableConcept(t, "ClinicalUseDefinitionUndesirableEffectComponent", "frequencyOfOccurrence", element.getFrequencyOfOccurrence(), -1);
        }
    }

    protected void composeClinicalUseDefinitionWarningComponent(Turtle.Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "warning", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ClinicalUseDefinitionWarningComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ClinicalUseDefinitionWarningComponent", "code", element.getCode(), -1);
        }
    }

    protected void composeCodeSystem(Turtle.Complex parent, String parentType, String name, CodeSystem element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CodeSystem", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "CodeSystem", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CodeSystem", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CodeSystem", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CodeSystem", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CodeSystem", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CodeSystem", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "CodeSystem", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "CodeSystem", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "CodeSystem", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "CodeSystem", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "CodeSystem", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "CodeSystem", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "CodeSystem", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "CodeSystem", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "CodeSystem", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasCaseSensitiveElement()) {
            this.composeBoolean(t, "CodeSystem", "caseSensitive", element.getCaseSensitiveElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "CodeSystem", "valueSet", element.getValueSetElement(), -1);
        }
        if (element.hasHierarchyMeaningElement()) {
            this.composeEnum(t, "CodeSystem", "hierarchyMeaning", element.getHierarchyMeaningElement(), -1);
        }
        if (element.hasCompositionalElement()) {
            this.composeBoolean(t, "CodeSystem", "compositional", element.getCompositionalElement(), -1);
        }
        if (element.hasVersionNeededElement()) {
            this.composeBoolean(t, "CodeSystem", "versionNeeded", element.getVersionNeededElement(), -1);
        }
        if (element.hasContentElement()) {
            this.composeEnum(t, "CodeSystem", "content", element.getContentElement(), -1);
        }
        if (element.hasSupplementsElement()) {
            this.composeCanonical(t, "CodeSystem", "supplements", element.getSupplementsElement(), -1);
        }
        if (element.hasCountElement()) {
            this.composeUnsignedInt(t, "CodeSystem", "count", element.getCountElement(), -1);
        }
        for (i = 0; i < element.getFilter().size(); ++i) {
            this.composeCodeSystemFilterComponent(t, "CodeSystem", "filter", element.getFilter().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeCodeSystemPropertyComponent(t, "CodeSystem", "property", element.getProperty().get(i), i);
        }
        for (i = 0; i < element.getConcept().size(); ++i) {
            this.composeCodeSystemConceptDefinitionComponent(t, "CodeSystem", "concept", element.getConcept().get(i), i);
        }
    }

    protected void composeCodeSystemFilterComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.CodeSystemFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "filter", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CodeSystemFilterComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CodeSystemFilterComponent", "description", element.getDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getOperator().size(); ++i) {
            this.composeEnum(t, "CodeSystemFilterComponent", "operator", element.getOperator().get(i), i);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "CodeSystemFilterComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeCodeSystemPropertyComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.PropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "PropertyComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasUriElement()) {
            this.composeUri(t, "PropertyComponent", "uri", element.getUriElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "PropertyComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "PropertyComponent", "type", element.getTypeElement(), -1);
        }
    }

    protected void composeCodeSystemConceptDefinitionComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.ConceptDefinitionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "concept", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "ConceptDefinitionComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "ConceptDefinitionComponent", "display", element.getDisplayElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeString(t, "ConceptDefinitionComponent", "definition", element.getDefinitionElement(), -1);
        }
        for (i = 0; i < element.getDesignation().size(); ++i) {
            this.composeCodeSystemConceptDefinitionDesignationComponent(t, "ConceptDefinitionComponent", "designation", element.getDesignation().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeCodeSystemConceptPropertyComponent(t, "ConceptDefinitionComponent", "property", element.getProperty().get(i), i);
        }
        for (i = 0; i < element.getConcept().size(); ++i) {
            this.composeCodeSystemConceptDefinitionComponent(t, "ConceptDefinitionComponent", "concept", element.getConcept().get(i), i);
        }
    }

    protected void composeCodeSystemConceptDefinitionDesignationComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.ConceptDefinitionDesignationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "designation", name, element, index);
        if (element.hasLanguageElement()) {
            this.composeCode(t, "ConceptDefinitionDesignationComponent", "language", element.getLanguageElement(), -1);
        }
        if (element.hasUse()) {
            this.composeCoding(t, "ConceptDefinitionDesignationComponent", "use", element.getUse(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ConceptDefinitionDesignationComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeCodeSystemConceptPropertyComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.ConceptPropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "ConceptPropertyComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ConceptPropertyComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeCommunication(Turtle.Complex parent, String parentType, String name, Communication element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Communication", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Communication", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "Communication", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "Communication", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Communication", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "Communication", "partOf", element.getPartOf().get(i), i);
        }
        for (i = 0; i < element.getInResponseTo().size(); ++i) {
            this.composeReference(t, "Communication", "inResponseTo", element.getInResponseTo().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Communication", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "Communication", "statusReason", element.getStatusReason(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Communication", "category", element.getCategory().get(i), i);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "Communication", "priority", element.getPriorityElement(), -1);
        }
        for (i = 0; i < element.getMedium().size(); ++i) {
            this.composeCodeableConcept(t, "Communication", "medium", element.getMedium().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Communication", "subject", element.getSubject(), -1);
        }
        if (element.hasTopic()) {
            this.composeCodeableConcept(t, "Communication", "topic", element.getTopic(), -1);
        }
        for (i = 0; i < element.getAbout().size(); ++i) {
            this.composeReference(t, "Communication", "about", element.getAbout().get(i), i);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Communication", "encounter", element.getEncounter(), -1);
        }
        if (element.hasSentElement()) {
            this.composeDateTime(t, "Communication", "sent", element.getSentElement(), -1);
        }
        if (element.hasReceivedElement()) {
            this.composeDateTime(t, "Communication", "received", element.getReceivedElement(), -1);
        }
        for (i = 0; i < element.getRecipient().size(); ++i) {
            this.composeReference(t, "Communication", "recipient", element.getRecipient().get(i), i);
        }
        if (element.hasSender()) {
            this.composeReference(t, "Communication", "sender", element.getSender(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Communication", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "Communication", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getPayload().size(); ++i) {
            this.composeCommunicationPayloadComponent(t, "Communication", "payload", element.getPayload().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Communication", "note", element.getNote().get(i), i);
        }
    }

    protected void composeCommunicationPayloadComponent(Turtle.Complex parent, String parentType, String name, Communication.CommunicationPayloadComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payload", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "CommunicationPayloadComponent", "content", element.getContent(), -1);
        }
    }

    protected void composeCommunicationRequest(Turtle.Complex parent, String parentType, String name, CommunicationRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CommunicationRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CommunicationRequest", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "CommunicationRequest", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeReference(t, "CommunicationRequest", "replaces", element.getReplaces().get(i), i);
        }
        if (element.hasGroupIdentifier()) {
            this.composeIdentifier(t, "CommunicationRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CommunicationRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "CommunicationRequest", "statusReason", element.getStatusReason(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "CommunicationRequest", "category", element.getCategory().get(i), i);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "CommunicationRequest", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "CommunicationRequest", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        for (i = 0; i < element.getMedium().size(); ++i) {
            this.composeCodeableConcept(t, "CommunicationRequest", "medium", element.getMedium().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "CommunicationRequest", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getAbout().size(); ++i) {
            this.composeReference(t, "CommunicationRequest", "about", element.getAbout().get(i), i);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "CommunicationRequest", "encounter", element.getEncounter(), -1);
        }
        for (i = 0; i < element.getPayload().size(); ++i) {
            this.composeCommunicationRequestPayloadComponent(t, "CommunicationRequest", "payload", element.getPayload().get(i), i);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "CommunicationRequest", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "CommunicationRequest", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "CommunicationRequest", "requester", element.getRequester(), -1);
        }
        for (i = 0; i < element.getRecipient().size(); ++i) {
            this.composeReference(t, "CommunicationRequest", "recipient", element.getRecipient().get(i), i);
        }
        if (element.hasSender()) {
            this.composeReference(t, "CommunicationRequest", "sender", element.getSender(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "CommunicationRequest", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "CommunicationRequest", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "CommunicationRequest", "note", element.getNote().get(i), i);
        }
    }

    protected void composeCommunicationRequestPayloadComponent(Turtle.Complex parent, String parentType, String name, CommunicationRequest.CommunicationRequestPayloadComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payload", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "CommunicationRequestPayloadComponent", "content", element.getContent(), -1);
        }
    }

    protected void composeCompartmentDefinition(Turtle.Complex parent, String parentType, String name, CompartmentDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CompartmentDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "CompartmentDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CompartmentDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CompartmentDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CompartmentDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "CompartmentDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "CompartmentDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "CompartmentDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "CompartmentDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "CompartmentDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "CompartmentDefinition", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "CompartmentDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "CompartmentDefinition", "code", element.getCodeElement(), -1);
        }
        if (element.hasSearchElement()) {
            this.composeBoolean(t, "CompartmentDefinition", "search", element.getSearchElement(), -1);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeCompartmentDefinitionResourceComponent(t, "CompartmentDefinition", "resource", element.getResource().get(i), i);
        }
    }

    protected void composeCompartmentDefinitionResourceComponent(Turtle.Complex parent, String parentType, String name, CompartmentDefinition.CompartmentDefinitionResourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CompartmentDefinitionResourceComponent", "code", element.getCodeElement(), -1);
        }
        for (int i = 0; i < element.getParam().size(); ++i) {
            this.composeString(t, "CompartmentDefinitionResourceComponent", "param", element.getParam().get(i), i);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "CompartmentDefinitionResourceComponent", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeComposition(Turtle.Complex parent, String parentType, String name, Composition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Composition", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Composition", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Composition", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Composition", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Composition", "category", element.getCategory().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Composition", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Composition", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Composition", "date", element.getDateElement(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeReference(t, "Composition", "author", element.getAuthor().get(i), i);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Composition", "title", element.getTitleElement(), -1);
        }
        if (element.hasConfidentialityElement()) {
            this.composeCode(t, "Composition", "confidentiality", element.getConfidentialityElement(), -1);
        }
        for (i = 0; i < element.getAttester().size(); ++i) {
            this.composeCompositionAttesterComponent(t, "Composition", "attester", element.getAttester().get(i), i);
        }
        if (element.hasCustodian()) {
            this.composeReference(t, "Composition", "custodian", element.getCustodian(), -1);
        }
        for (i = 0; i < element.getRelatesTo().size(); ++i) {
            this.composeCompositionRelatesToComponent(t, "Composition", "relatesTo", element.getRelatesTo().get(i), i);
        }
        for (i = 0; i < element.getEvent().size(); ++i) {
            this.composeCompositionEventComponent(t, "Composition", "event", element.getEvent().get(i), i);
        }
        for (i = 0; i < element.getSection().size(); ++i) {
            this.composeCompositionSectionComponent(t, "Composition", "section", element.getSection().get(i), i);
        }
    }

    protected void composeCompositionAttesterComponent(Turtle.Complex parent, String parentType, String name, Composition.CompositionAttesterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "attester", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "CompositionAttesterComponent", "mode", element.getModeElement(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeDateTime(t, "CompositionAttesterComponent", "time", element.getTimeElement(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "CompositionAttesterComponent", "party", element.getParty(), -1);
        }
    }

    protected void composeCompositionRelatesToComponent(Turtle.Complex parent, String parentType, String name, Composition.CompositionRelatesToComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatesTo", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "CompositionRelatesToComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeType(t, "CompositionRelatesToComponent", "target", element.getTarget(), -1);
        }
    }

    protected void composeCompositionEventComponent(Turtle.Complex parent, String parentType, String name, Composition.CompositionEventComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "event", name, element, index);
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "CompositionEventComponent", "code", element.getCode().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CompositionEventComponent", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeReference(t, "CompositionEventComponent", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeCompositionSectionComponent(Turtle.Complex parent, String parentType, String name, Composition.SectionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "section", name, element, index);
        if (element.hasTitleElement()) {
            this.composeString(t, "SectionComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "SectionComponent", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeReference(t, "SectionComponent", "author", element.getAuthor().get(i), i);
        }
        if (element.hasFocus()) {
            this.composeReference(t, "SectionComponent", "focus", element.getFocus(), -1);
        }
        if (element.hasText()) {
            this.composeNarrative(t, "SectionComponent", "text", element.getText(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "SectionComponent", "mode", element.getModeElement(), -1);
        }
        if (element.hasOrderedBy()) {
            this.composeCodeableConcept(t, "SectionComponent", "orderedBy", element.getOrderedBy(), -1);
        }
        for (i = 0; i < element.getEntry().size(); ++i) {
            this.composeReference(t, "SectionComponent", "entry", element.getEntry().get(i), i);
        }
        if (element.hasEmptyReason()) {
            this.composeCodeableConcept(t, "SectionComponent", "emptyReason", element.getEmptyReason(), -1);
        }
        for (i = 0; i < element.getSection().size(); ++i) {
            this.composeCompositionSectionComponent(t, "SectionComponent", "section", element.getSection().get(i), i);
        }
    }

    protected void composeConceptMap(Turtle.Complex parent, String parentType, String name, ConceptMap element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ConceptMap", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ConceptMap", "url", element.getUrlElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ConceptMap", "identifier", element.getIdentifierFirstRep(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ConceptMap", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ConceptMap", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ConceptMap", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ConceptMap", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ConceptMap", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ConceptMap", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ConceptMap", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ConceptMap", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ConceptMap", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ConceptMap", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ConceptMap", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ConceptMap", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ConceptMap", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasSource()) {
            this.composeType(t, "ConceptMap", "source", element.getSource(), -1);
        }
        if (element.hasTarget()) {
            this.composeType(t, "ConceptMap", "target", element.getTarget(), -1);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeConceptMapGroupComponent(t, "ConceptMap", "group", element.getGroup().get(i), i);
        }
    }

    protected void composeConceptMapGroupComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.ConceptMapGroupComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasSourceElement()) {
            this.composeUri(t, "ConceptMapGroupComponent", "source", element.getSourceElement(), -1);
        }
        if (element.hasSourceVersionElement()) {
            this.composeString(t, "ConceptMapGroupComponent", "sourceVersion", element.getSourceVersionElement(), -1);
        }
        if (element.hasTargetElement()) {
            this.composeUri(t, "ConceptMapGroupComponent", "target", element.getTargetElement(), -1);
        }
        if (element.hasTargetVersionElement()) {
            this.composeString(t, "ConceptMapGroupComponent", "targetVersion", element.getTargetVersionElement(), -1);
        }
        for (int i = 0; i < element.getElement().size(); ++i) {
            this.composeConceptMapSourceElementComponent(t, "ConceptMapGroupComponent", "element", element.getElement().get(i), i);
        }
        if (element.hasUnmapped()) {
            this.composeConceptMapGroupUnmappedComponent(t, "ConceptMapGroupComponent", "unmapped", element.getUnmapped(), -1);
        }
    }

    protected void composeConceptMapSourceElementComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.SourceElementComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "element", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "SourceElementComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "SourceElementComponent", "display", element.getDisplayElement(), -1);
        }
        for (int i = 0; i < element.getTarget().size(); ++i) {
            this.composeConceptMapTargetElementComponent(t, "SourceElementComponent", "target", element.getTarget().get(i), i);
        }
    }

    protected void composeConceptMapTargetElementComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.TargetElementComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "TargetElementComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "TargetElementComponent", "display", element.getDisplayElement(), -1);
        }
        if (element.hasEquivalenceElement()) {
            this.composeEnum(t, "TargetElementComponent", "equivalence", element.getEquivalenceElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "TargetElementComponent", "comment", element.getCommentElement(), -1);
        }
        for (i = 0; i < element.getDependsOn().size(); ++i) {
            this.composeConceptMapOtherElementComponent(t, "TargetElementComponent", "dependsOn", element.getDependsOn().get(i), i);
        }
        for (i = 0; i < element.getProduct().size(); ++i) {
            this.composeConceptMapOtherElementComponent(t, "TargetElementComponent", "product", element.getProduct().get(i), i);
        }
    }

    protected void composeConceptMapOtherElementComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.OtherElementComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dependsOn", name, element, index);
        if (element.hasPropertyElement()) {
            this.composeUri(t, "OtherElementComponent", "property", element.getPropertyElement(), -1);
        }
        if (element.hasSystemElement()) {
            this.composeCanonical(t, "OtherElementComponent", "system", element.getSystemElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "OtherElementComponent", "value", element.getValueElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "OtherElementComponent", "display", element.getDisplayElement(), -1);
        }
    }

    protected void composeConceptMapGroupUnmappedComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.ConceptMapGroupUnmappedComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "unmapped", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "ConceptMapGroupUnmappedComponent", "mode", element.getModeElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "ConceptMapGroupUnmappedComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "ConceptMapGroupUnmappedComponent", "display", element.getDisplayElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeCanonical(t, "ConceptMapGroupUnmappedComponent", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeCondition(Turtle.Complex parent, String parentType, String name, Condition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Condition", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Condition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasClinicalStatus()) {
            this.composeCodeableConcept(t, "Condition", "clinicalStatus", element.getClinicalStatus(), -1);
        }
        if (element.hasVerificationStatus()) {
            this.composeCodeableConcept(t, "Condition", "verificationStatus", element.getVerificationStatus(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Condition", "category", element.getCategory().get(i), i);
        }
        if (element.hasSeverity()) {
            this.composeCodeableConcept(t, "Condition", "severity", element.getSeverity(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Condition", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getBodySite().size(); ++i) {
            this.composeCodeableConcept(t, "Condition", "bodySite", element.getBodySite().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Condition", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Condition", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOnset()) {
            this.composeType(t, "Condition", "onset", element.getOnset(), -1);
        }
        if (element.hasAbatement()) {
            this.composeType(t, "Condition", "abatement", element.getAbatement(), -1);
        }
        if (element.hasRecordedDateElement()) {
            this.composeDateTime(t, "Condition", "recordedDate", element.getRecordedDateElement(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "Condition", "recorder", element.getRecorder(), -1);
        }
        if (element.hasAsserter()) {
            this.composeReference(t, "Condition", "asserter", element.getAsserter(), -1);
        }
        for (i = 0; i < element.getStage().size(); ++i) {
            this.composeConditionStageComponent(t, "Condition", "stage", element.getStage().get(i), i);
        }
        for (i = 0; i < element.getEvidence().size(); ++i) {
            this.composeConditionEvidenceComponent(t, "Condition", "evidence", element.getEvidence().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Condition", "note", element.getNote().get(i), i);
        }
    }

    protected void composeConditionStageComponent(Turtle.Complex parent, String parentType, String name, Condition.ConditionStageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "stage", name, element, index);
        if (element.hasSummary()) {
            this.composeCodeableConcept(t, "ConditionStageComponent", "summary", element.getSummary(), -1);
        }
        for (int i = 0; i < element.getAssessment().size(); ++i) {
            this.composeReference(t, "ConditionStageComponent", "assessment", element.getAssessment().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ConditionStageComponent", "type", element.getType(), -1);
        }
    }

    protected void composeConditionEvidenceComponent(Turtle.Complex parent, String parentType, String name, Condition.ConditionEvidenceComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "evidence", name, element, index);
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "ConditionEvidenceComponent", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeReference(t, "ConditionEvidenceComponent", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeConsent(Turtle.Complex parent, String parentType, String name, Consent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Consent", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Consent", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Consent", "status", element.getStatusElement(), -1);
        }
        if (element.hasScope()) {
            this.composeCodeableConcept(t, "Consent", "scope", element.getScope(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Consent", "category", element.getCategory().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Consent", "patient", element.getPatient(), -1);
        }
        if (element.hasDateTimeElement()) {
            this.composeDateTime(t, "Consent", "dateTime", element.getDateTimeElement(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "Consent", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getOrganization().size(); ++i) {
            this.composeReference(t, "Consent", "organization", element.getOrganization().get(i), i);
        }
        if (element.hasSource()) {
            this.composeType(t, "Consent", "source", element.getSource(), -1);
        }
        for (i = 0; i < element.getPolicy().size(); ++i) {
            this.composeConsentPolicyComponent(t, "Consent", "policy", element.getPolicy().get(i), i);
        }
        if (element.hasPolicyRule()) {
            this.composeCodeableConcept(t, "Consent", "policyRule", element.getPolicyRule(), -1);
        }
        for (i = 0; i < element.getVerification().size(); ++i) {
            this.composeConsentVerificationComponent(t, "Consent", "verification", element.getVerification().get(i), i);
        }
        if (element.hasProvision()) {
            this.composeConsentProvisionComponent(t, "Consent", "provision", element.getProvision(), -1);
        }
    }

    protected void composeConsentPolicyComponent(Turtle.Complex parent, String parentType, String name, Consent.ConsentPolicyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "policy", name, element, index);
        if (element.hasAuthorityElement()) {
            this.composeUri(t, "ConsentPolicyComponent", "authority", element.getAuthorityElement(), -1);
        }
        if (element.hasUriElement()) {
            this.composeUri(t, "ConsentPolicyComponent", "uri", element.getUriElement(), -1);
        }
    }

    protected void composeConsentVerificationComponent(Turtle.Complex parent, String parentType, String name, Consent.ConsentVerificationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "verification", name, element, index);
        if (element.hasVerifiedElement()) {
            this.composeBoolean(t, "ConsentVerificationComponent", "verified", element.getVerifiedElement(), -1);
        }
        if (element.hasVerifiedWith()) {
            this.composeReference(t, "ConsentVerificationComponent", "verifiedWith", element.getVerifiedWith(), -1);
        }
        if (element.hasVerificationDateElement()) {
            this.composeDateTime(t, "ConsentVerificationComponent", "verificationDate", element.getVerificationDateElement(), -1);
        }
    }

    protected void composeConsentProvisionComponent(Turtle.Complex parent, String parentType, String name, Consent.ProvisionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "provision", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ProvisionComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ProvisionComponent", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getActor().size(); ++i) {
            this.composeConsentProvisionActorComponent(t, "ProvisionComponent", "actor", element.getActor().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeCodeableConcept(t, "ProvisionComponent", "action", element.getAction().get(i), i);
        }
        for (i = 0; i < element.getSecurityLabel().size(); ++i) {
            this.composeCoding(t, "ProvisionComponent", "securityLabel", element.getSecurityLabel().get(i), i);
        }
        for (i = 0; i < element.getPurpose().size(); ++i) {
            this.composeCoding(t, "ProvisionComponent", "purpose", element.getPurpose().get(i), i);
        }
        for (i = 0; i < element.getClass_().size(); ++i) {
            this.composeCoding(t, "ProvisionComponent", "class", element.getClass_().get(i), i);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "ProvisionComponent", "code", element.getCode().get(i), i);
        }
        if (element.hasDataPeriod()) {
            this.composePeriod(t, "ProvisionComponent", "dataPeriod", element.getDataPeriod(), -1);
        }
        for (i = 0; i < element.getData().size(); ++i) {
            this.composeConsentProvisionDataComponent(t, "ProvisionComponent", "data", element.getData().get(i), i);
        }
        for (i = 0; i < element.getProvision().size(); ++i) {
            this.composeConsentProvisionComponent(t, "ProvisionComponent", "provision", element.getProvision().get(i), i);
        }
    }

    protected void composeConsentProvisionActorComponent(Turtle.Complex parent, String parentType, String name, Consent.ProvisionActorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "actor", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "ProvisionActorComponent", "role", element.getRole(), -1);
        }
        if (element.hasReference()) {
            this.composeReference(t, "ProvisionActorComponent", "reference", element.getReference(), -1);
        }
    }

    protected void composeConsentProvisionDataComponent(Turtle.Complex parent, String parentType, String name, Consent.ProvisionDataComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "data", name, element, index);
        if (element.hasMeaningElement()) {
            this.composeEnum(t, "ProvisionDataComponent", "meaning", element.getMeaningElement(), -1);
        }
        if (element.hasReference()) {
            this.composeReference(t, "ProvisionDataComponent", "reference", element.getReference(), -1);
        }
    }

    protected void composeContract(Turtle.Complex parent, String parentType, String name, Contract element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Contract", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Contract", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Contract", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Contract", "version", element.getVersionElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Contract", "status", element.getStatusElement(), -1);
        }
        if (element.hasLegalState()) {
            this.composeCodeableConcept(t, "Contract", "legalState", element.getLegalState(), -1);
        }
        if (element.hasInstantiatesCanonical()) {
            this.composeReference(t, "Contract", "instantiatesCanonical", element.getInstantiatesCanonical(), -1);
        }
        if (element.hasInstantiatesUriElement()) {
            this.composeUri(t, "Contract", "instantiatesUri", element.getInstantiatesUriElement(), -1);
        }
        if (element.hasContentDerivative()) {
            this.composeCodeableConcept(t, "Contract", "contentDerivative", element.getContentDerivative(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeDateTime(t, "Contract", "issued", element.getIssuedElement(), -1);
        }
        if (element.hasApplies()) {
            this.composePeriod(t, "Contract", "applies", element.getApplies(), -1);
        }
        if (element.hasExpirationType()) {
            this.composeCodeableConcept(t, "Contract", "expirationType", element.getExpirationType(), -1);
        }
        for (i = 0; i < element.getSubject().size(); ++i) {
            this.composeReference(t, "Contract", "subject", element.getSubject().get(i), i);
        }
        for (i = 0; i < element.getAuthority().size(); ++i) {
            this.composeReference(t, "Contract", "authority", element.getAuthority().get(i), i);
        }
        for (i = 0; i < element.getDomain().size(); ++i) {
            this.composeReference(t, "Contract", "domain", element.getDomain().get(i), i);
        }
        for (i = 0; i < element.getSite().size(); ++i) {
            this.composeReference(t, "Contract", "site", element.getSite().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Contract", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Contract", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "Contract", "subtitle", element.getSubtitleElement(), -1);
        }
        for (i = 0; i < element.getAlias().size(); ++i) {
            this.composeString(t, "Contract", "alias", element.getAlias().get(i), i);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Contract", "author", element.getAuthor(), -1);
        }
        if (element.hasScope()) {
            this.composeCodeableConcept(t, "Contract", "scope", element.getScope(), -1);
        }
        if (element.hasTopic()) {
            this.composeType(t, "Contract", "topic", element.getTopic(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Contract", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSubType().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "subType", element.getSubType().get(i), i);
        }
        if (element.hasContentDefinition()) {
            this.composeContractContentDefinitionComponent(t, "Contract", "contentDefinition", element.getContentDefinition(), -1);
        }
        for (i = 0; i < element.getTerm().size(); ++i) {
            this.composeContractTermComponent(t, "Contract", "term", element.getTerm().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeReference(t, "Contract", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getRelevantHistory().size(); ++i) {
            this.composeReference(t, "Contract", "relevantHistory", element.getRelevantHistory().get(i), i);
        }
        for (i = 0; i < element.getSigner().size(); ++i) {
            this.composeContractSignatoryComponent(t, "Contract", "signer", element.getSigner().get(i), i);
        }
        for (i = 0; i < element.getFriendly().size(); ++i) {
            this.composeContractFriendlyLanguageComponent(t, "Contract", "friendly", element.getFriendly().get(i), i);
        }
        for (i = 0; i < element.getLegal().size(); ++i) {
            this.composeContractLegalLanguageComponent(t, "Contract", "legal", element.getLegal().get(i), i);
        }
        for (i = 0; i < element.getRule().size(); ++i) {
            this.composeContractComputableLanguageComponent(t, "Contract", "rule", element.getRule().get(i), i);
        }
        if (element.hasLegallyBinding()) {
            this.composeType(t, "Contract", "legallyBinding", element.getLegallyBinding(), -1);
        }
    }

    protected void composeContractContentDefinitionComponent(Turtle.Complex parent, String parentType, String name, Contract.ContentDefinitionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contentDefinition", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ContentDefinitionComponent", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "ContentDefinitionComponent", "subType", element.getSubType(), -1);
        }
        if (element.hasPublisher()) {
            this.composeReference(t, "ContentDefinitionComponent", "publisher", element.getPublisher(), -1);
        }
        if (element.hasPublicationDateElement()) {
            this.composeDateTime(t, "ContentDefinitionComponent", "publicationDate", element.getPublicationDateElement(), -1);
        }
        if (element.hasPublicationStatusElement()) {
            this.composeEnum(t, "ContentDefinitionComponent", "publicationStatus", element.getPublicationStatusElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ContentDefinitionComponent", "copyright", element.getCopyrightElement(), -1);
        }
    }

    protected void composeContractTermComponent(Turtle.Complex parent, String parentType, String name, Contract.TermComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "term", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "TermComponent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeDateTime(t, "TermComponent", "issued", element.getIssuedElement(), -1);
        }
        if (element.hasApplies()) {
            this.composePeriod(t, "TermComponent", "applies", element.getApplies(), -1);
        }
        if (element.hasTopic()) {
            this.composeType(t, "TermComponent", "topic", element.getTopic(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "TermComponent", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "TermComponent", "subType", element.getSubType(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "TermComponent", "text", element.getTextElement(), -1);
        }
        for (i = 0; i < element.getSecurityLabel().size(); ++i) {
            this.composeContractSecurityLabelComponent(t, "TermComponent", "securityLabel", element.getSecurityLabel().get(i), i);
        }
        if (element.hasOffer()) {
            this.composeContractOfferComponent(t, "TermComponent", "offer", element.getOffer(), -1);
        }
        for (i = 0; i < element.getAsset().size(); ++i) {
            this.composeContractAssetComponent(t, "TermComponent", "asset", element.getAsset().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeContractActionComponent(t, "TermComponent", "action", element.getAction().get(i), i);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeContractTermComponent(t, "TermComponent", "group", element.getGroup().get(i), i);
        }
    }

    protected void composeContractSecurityLabelComponent(Turtle.Complex parent, String parentType, String name, Contract.SecurityLabelComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "securityLabel", name, element, index);
        for (i = 0; i < element.getNumber().size(); ++i) {
            this.composeUnsignedInt(t, "SecurityLabelComponent", "number", element.getNumber().get(i), i);
        }
        if (element.hasClassification()) {
            this.composeCoding(t, "SecurityLabelComponent", "classification", element.getClassification(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCoding(t, "SecurityLabelComponent", "category", element.getCategory().get(i), i);
        }
        for (i = 0; i < element.getControl().size(); ++i) {
            this.composeCoding(t, "SecurityLabelComponent", "control", element.getControl().get(i), i);
        }
    }

    protected void composeContractOfferComponent(Turtle.Complex parent, String parentType, String name, Contract.ContractOfferComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "offer", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ContractOfferComponent", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getParty().size(); ++i) {
            this.composeContractPartyComponent(t, "ContractOfferComponent", "party", element.getParty().get(i), i);
        }
        if (element.hasTopic()) {
            this.composeReference(t, "ContractOfferComponent", "topic", element.getTopic(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ContractOfferComponent", "type", element.getType(), -1);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "ContractOfferComponent", "decision", element.getDecision(), -1);
        }
        for (i = 0; i < element.getDecisionMode().size(); ++i) {
            this.composeCodeableConcept(t, "ContractOfferComponent", "decisionMode", element.getDecisionMode().get(i), i);
        }
        for (i = 0; i < element.getAnswer().size(); ++i) {
            this.composeContractAnswerComponent(t, "ContractOfferComponent", "answer", element.getAnswer().get(i), i);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "ContractOfferComponent", "text", element.getTextElement(), -1);
        }
        for (i = 0; i < element.getLinkId().size(); ++i) {
            this.composeString(t, "ContractOfferComponent", "linkId", element.getLinkId().get(i), i);
        }
        for (i = 0; i < element.getSecurityLabelNumber().size(); ++i) {
            this.composeUnsignedInt(t, "ContractOfferComponent", "securityLabelNumber", element.getSecurityLabelNumber().get(i), i);
        }
    }

    protected void composeContractPartyComponent(Turtle.Complex parent, String parentType, String name, Contract.ContractPartyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "party", name, element, index);
        for (int i = 0; i < element.getReference().size(); ++i) {
            this.composeReference(t, "ContractPartyComponent", "reference", element.getReference().get(i), i);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "ContractPartyComponent", "role", element.getRole(), -1);
        }
    }

    protected void composeContractAnswerComponent(Turtle.Complex parent, String parentType, String name, Contract.AnswerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "answer", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "AnswerComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeContractAssetComponent(Turtle.Complex parent, String parentType, String name, Contract.ContractAssetComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "asset", name, element, index);
        if (element.hasScope()) {
            this.composeCodeableConcept(t, "ContractAssetComponent", "scope", element.getScope(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "ContractAssetComponent", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getTypeReference().size(); ++i) {
            this.composeReference(t, "ContractAssetComponent", "typeReference", element.getTypeReference().get(i), i);
        }
        for (i = 0; i < element.getSubtype().size(); ++i) {
            this.composeCodeableConcept(t, "ContractAssetComponent", "subtype", element.getSubtype().get(i), i);
        }
        if (element.hasRelationship()) {
            this.composeCoding(t, "ContractAssetComponent", "relationship", element.getRelationship(), -1);
        }
        for (i = 0; i < element.getContext().size(); ++i) {
            this.composeContractAssetContextComponent(t, "ContractAssetComponent", "context", element.getContext().get(i), i);
        }
        if (element.hasConditionElement()) {
            this.composeString(t, "ContractAssetComponent", "condition", element.getConditionElement(), -1);
        }
        for (i = 0; i < element.getPeriodType().size(); ++i) {
            this.composeCodeableConcept(t, "ContractAssetComponent", "periodType", element.getPeriodType().get(i), i);
        }
        for (i = 0; i < element.getPeriod().size(); ++i) {
            this.composePeriod(t, "ContractAssetComponent", "period", element.getPeriod().get(i), i);
        }
        for (i = 0; i < element.getUsePeriod().size(); ++i) {
            this.composePeriod(t, "ContractAssetComponent", "usePeriod", element.getUsePeriod().get(i), i);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "ContractAssetComponent", "text", element.getTextElement(), -1);
        }
        for (i = 0; i < element.getLinkId().size(); ++i) {
            this.composeString(t, "ContractAssetComponent", "linkId", element.getLinkId().get(i), i);
        }
        for (i = 0; i < element.getAnswer().size(); ++i) {
            this.composeContractAnswerComponent(t, "ContractAssetComponent", "answer", element.getAnswer().get(i), i);
        }
        for (i = 0; i < element.getSecurityLabelNumber().size(); ++i) {
            this.composeUnsignedInt(t, "ContractAssetComponent", "securityLabelNumber", element.getSecurityLabelNumber().get(i), i);
        }
        for (i = 0; i < element.getValuedItem().size(); ++i) {
            this.composeContractValuedItemComponent(t, "ContractAssetComponent", "valuedItem", element.getValuedItem().get(i), i);
        }
    }

    protected void composeContractAssetContextComponent(Turtle.Complex parent, String parentType, String name, Contract.AssetContextComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "context", name, element, index);
        if (element.hasReference()) {
            this.composeReference(t, "AssetContextComponent", "reference", element.getReference(), -1);
        }
        for (int i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "AssetContextComponent", "code", element.getCode().get(i), i);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "AssetContextComponent", "text", element.getTextElement(), -1);
        }
    }

    protected void composeContractValuedItemComponent(Turtle.Complex parent, String parentType, String name, Contract.ValuedItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "valuedItem", name, element, index);
        if (element.hasEntity()) {
            this.composeType(t, "ValuedItemComponent", "entity", element.getEntity(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ValuedItemComponent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasEffectiveTimeElement()) {
            this.composeDateTime(t, "ValuedItemComponent", "effectiveTime", element.getEffectiveTimeElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ValuedItemComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ValuedItemComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ValuedItemComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasPointsElement()) {
            this.composeDecimal(t, "ValuedItemComponent", "points", element.getPointsElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ValuedItemComponent", "net", element.getNet(), -1);
        }
        if (element.hasPaymentElement()) {
            this.composeString(t, "ValuedItemComponent", "payment", element.getPaymentElement(), -1);
        }
        if (element.hasPaymentDateElement()) {
            this.composeDateTime(t, "ValuedItemComponent", "paymentDate", element.getPaymentDateElement(), -1);
        }
        if (element.hasResponsible()) {
            this.composeReference(t, "ValuedItemComponent", "responsible", element.getResponsible(), -1);
        }
        if (element.hasRecipient()) {
            this.composeReference(t, "ValuedItemComponent", "recipient", element.getRecipient(), -1);
        }
        for (i = 0; i < element.getLinkId().size(); ++i) {
            this.composeString(t, "ValuedItemComponent", "linkId", element.getLinkId().get(i), i);
        }
        for (i = 0; i < element.getSecurityLabelNumber().size(); ++i) {
            this.composeUnsignedInt(t, "ValuedItemComponent", "securityLabelNumber", element.getSecurityLabelNumber().get(i), i);
        }
    }

    protected void composeContractActionComponent(Turtle.Complex parent, String parentType, String name, Contract.ActionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "ActionComponent", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ActionComponent", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSubject().size(); ++i) {
            this.composeContractActionSubjectComponent(t, "ActionComponent", "subject", element.getSubject().get(i), i);
        }
        if (element.hasIntent()) {
            this.composeCodeableConcept(t, "ActionComponent", "intent", element.getIntent(), -1);
        }
        for (i = 0; i < element.getLinkId().size(); ++i) {
            this.composeString(t, "ActionComponent", "linkId", element.getLinkId().get(i), i);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "ActionComponent", "status", element.getStatus(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "ActionComponent", "context", element.getContext(), -1);
        }
        for (i = 0; i < element.getContextLinkId().size(); ++i) {
            this.composeString(t, "ActionComponent", "contextLinkId", element.getContextLinkId().get(i), i);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "ActionComponent", "occurrence", element.getOccurrence(), -1);
        }
        for (i = 0; i < element.getRequester().size(); ++i) {
            this.composeReference(t, "ActionComponent", "requester", element.getRequester().get(i), i);
        }
        for (i = 0; i < element.getRequesterLinkId().size(); ++i) {
            this.composeString(t, "ActionComponent", "requesterLinkId", element.getRequesterLinkId().get(i), i);
        }
        for (i = 0; i < element.getPerformerType().size(); ++i) {
            this.composeCodeableConcept(t, "ActionComponent", "performerType", element.getPerformerType().get(i), i);
        }
        if (element.hasPerformerRole()) {
            this.composeCodeableConcept(t, "ActionComponent", "performerRole", element.getPerformerRole(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "ActionComponent", "performer", element.getPerformer(), -1);
        }
        for (i = 0; i < element.getPerformerLinkId().size(); ++i) {
            this.composeString(t, "ActionComponent", "performerLinkId", element.getPerformerLinkId().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "ActionComponent", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "ActionComponent", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeString(t, "ActionComponent", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getReasonLinkId().size(); ++i) {
            this.composeString(t, "ActionComponent", "reasonLinkId", element.getReasonLinkId().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ActionComponent", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getSecurityLabelNumber().size(); ++i) {
            this.composeUnsignedInt(t, "ActionComponent", "securityLabelNumber", element.getSecurityLabelNumber().get(i), i);
        }
    }

    protected void composeContractActionSubjectComponent(Turtle.Complex parent, String parentType, String name, Contract.ActionSubjectComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subject", name, element, index);
        for (int i = 0; i < element.getReference().size(); ++i) {
            this.composeReference(t, "ActionSubjectComponent", "reference", element.getReference().get(i), i);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "ActionSubjectComponent", "role", element.getRole(), -1);
        }
    }

    protected void composeContractSignatoryComponent(Turtle.Complex parent, String parentType, String name, Contract.SignatoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "signer", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "SignatoryComponent", "type", element.getType(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "SignatoryComponent", "party", element.getParty(), -1);
        }
        for (int i = 0; i < element.getSignature().size(); ++i) {
            this.composeSignature(t, "SignatoryComponent", "signature", element.getSignature().get(i), i);
        }
    }

    protected void composeContractFriendlyLanguageComponent(Turtle.Complex parent, String parentType, String name, Contract.FriendlyLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "friendly", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "FriendlyLanguageComponent", "content", element.getContent(), -1);
        }
    }

    protected void composeContractLegalLanguageComponent(Turtle.Complex parent, String parentType, String name, Contract.LegalLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "legal", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "LegalLanguageComponent", "content", element.getContent(), -1);
        }
    }

    protected void composeContractComputableLanguageComponent(Turtle.Complex parent, String parentType, String name, Contract.ComputableLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "rule", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "ComputableLanguageComponent", "content", element.getContent(), -1);
        }
    }

    protected void composeCoverage(Turtle.Complex parent, String parentType, String name, Coverage element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Coverage", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Coverage", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Coverage", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Coverage", "type", element.getType(), -1);
        }
        if (element.hasPolicyHolder()) {
            this.composeReference(t, "Coverage", "policyHolder", element.getPolicyHolder(), -1);
        }
        if (element.hasSubscriber()) {
            this.composeReference(t, "Coverage", "subscriber", element.getSubscriber(), -1);
        }
        if (element.hasSubscriberIdElement()) {
            this.composeString(t, "Coverage", "subscriberId", element.getSubscriberIdElement(), -1);
        }
        if (element.hasBeneficiary()) {
            this.composeReference(t, "Coverage", "beneficiary", element.getBeneficiary(), -1);
        }
        if (element.hasDependentElement()) {
            this.composeString(t, "Coverage", "dependent", element.getDependentElement(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "Coverage", "relationship", element.getRelationship(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Coverage", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getPayor().size(); ++i) {
            this.composeReference(t, "Coverage", "payor", element.getPayor().get(i), i);
        }
        for (i = 0; i < element.getClass_().size(); ++i) {
            this.composeCoverageClassComponent(t, "Coverage", "class", element.getClass_().get(i), i);
        }
        if (element.hasOrderElement()) {
            this.composePositiveInt(t, "Coverage", "order", element.getOrderElement(), -1);
        }
        if (element.hasNetworkElement()) {
            this.composeString(t, "Coverage", "network", element.getNetworkElement(), -1);
        }
        for (i = 0; i < element.getCostToBeneficiary().size(); ++i) {
            this.composeCoverageCostToBeneficiaryComponent(t, "Coverage", "costToBeneficiary", element.getCostToBeneficiary().get(i), i);
        }
        if (element.hasSubrogationElement()) {
            this.composeBoolean(t, "Coverage", "subrogation", element.getSubrogationElement(), -1);
        }
        for (i = 0; i < element.getContract().size(); ++i) {
            this.composeReference(t, "Coverage", "contract", element.getContract().get(i), i);
        }
    }

    protected void composeCoverageClassComponent(Turtle.Complex parent, String parentType, String name, Coverage.ClassComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "class", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ClassComponent", "type", element.getType(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ClassComponent", "value", element.getValueElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ClassComponent", "name", element.getNameElement(), -1);
        }
    }

    protected void composeCoverageCostToBeneficiaryComponent(Turtle.Complex parent, String parentType, String name, Coverage.CostToBeneficiaryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "costToBeneficiary", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CostToBeneficiaryComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "CostToBeneficiaryComponent", "value", element.getValue(), -1);
        }
        for (int i = 0; i < element.getException().size(); ++i) {
            this.composeCoverageExemptionComponent(t, "CostToBeneficiaryComponent", "exception", element.getException().get(i), i);
        }
    }

    protected void composeCoverageExemptionComponent(Turtle.Complex parent, String parentType, String name, Coverage.ExemptionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "exception", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ExemptionComponent", "type", element.getType(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ExemptionComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeCoverageEligibilityRequest(Turtle.Complex parent, String parentType, String name, CoverageEligibilityRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CoverageEligibilityRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CoverageEligibilityRequest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CoverageEligibilityRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "CoverageEligibilityRequest", "priority", element.getPriority(), -1);
        }
        for (i = 0; i < element.getPurpose().size(); ++i) {
            this.composeEnum(t, "CoverageEligibilityRequest", "purpose", element.getPurpose().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "CoverageEligibilityRequest", "patient", element.getPatient(), -1);
        }
        if (element.hasServiced()) {
            this.composeType(t, "CoverageEligibilityRequest", "serviced", element.getServiced(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "CoverageEligibilityRequest", "created", element.getCreatedElement(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "CoverageEligibilityRequest", "enterer", element.getEnterer(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "CoverageEligibilityRequest", "provider", element.getProvider(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "CoverageEligibilityRequest", "insurer", element.getInsurer(), -1);
        }
        if (element.hasFacility()) {
            this.composeReference(t, "CoverageEligibilityRequest", "facility", element.getFacility(), -1);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeCoverageEligibilityRequestSupportingInformationComponent(t, "CoverageEligibilityRequest", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeCoverageEligibilityRequestInsuranceComponent(t, "CoverageEligibilityRequest", "insurance", element.getInsurance().get(i), i);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeCoverageEligibilityRequestDetailsComponent(t, "CoverageEligibilityRequest", "item", element.getItem().get(i), i);
        }
    }

    protected void composeCoverageEligibilityRequestSupportingInformationComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityRequest.SupportingInformationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supportingInfo", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "SupportingInformationComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasInformation()) {
            this.composeReference(t, "SupportingInformationComponent", "information", element.getInformation(), -1);
        }
        if (element.hasAppliesToAllElement()) {
            this.composeBoolean(t, "SupportingInformationComponent", "appliesToAll", element.getAppliesToAllElement(), -1);
        }
    }

    protected void composeCoverageEligibilityRequestInsuranceComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityRequest.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasFocalElement()) {
            this.composeBoolean(t, "InsuranceComponent", "focal", element.getFocalElement(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeString(t, "InsuranceComponent", "businessArrangement", element.getBusinessArrangementElement(), -1);
        }
    }

    protected void composeCoverageEligibilityRequestDetailsComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityRequest.DetailsComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        for (i = 0; i < element.getSupportingInfoSequence().size(); ++i) {
            this.composePositiveInt(t, "DetailsComponent", "supportingInfoSequence", element.getSupportingInfoSequence().get(i), i);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "DetailsComponent", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "DetailsComponent", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "DetailsComponent", "modifier", element.getModifier().get(i), i);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "DetailsComponent", "provider", element.getProvider(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "DetailsComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "DetailsComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFacility()) {
            this.composeReference(t, "DetailsComponent", "facility", element.getFacility(), -1);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeCoverageEligibilityRequestDiagnosisComponent(t, "DetailsComponent", "diagnosis", element.getDiagnosis().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeReference(t, "DetailsComponent", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeCoverageEligibilityRequestDiagnosisComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityRequest.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasDiagnosis()) {
            this.composeType(t, "DiagnosisComponent", "diagnosis", element.getDiagnosis(), -1);
        }
    }

    protected void composeCoverageEligibilityResponse(Turtle.Complex parent, String parentType, String name, CoverageEligibilityResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CoverageEligibilityResponse", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CoverageEligibilityResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CoverageEligibilityResponse", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getPurpose().size(); ++i) {
            this.composeEnum(t, "CoverageEligibilityResponse", "purpose", element.getPurpose().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "CoverageEligibilityResponse", "patient", element.getPatient(), -1);
        }
        if (element.hasServiced()) {
            this.composeType(t, "CoverageEligibilityResponse", "serviced", element.getServiced(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "CoverageEligibilityResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasRequestor()) {
            this.composeReference(t, "CoverageEligibilityResponse", "requestor", element.getRequestor(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "CoverageEligibilityResponse", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "CoverageEligibilityResponse", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "CoverageEligibilityResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "CoverageEligibilityResponse", "insurer", element.getInsurer(), -1);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeCoverageEligibilityResponseInsuranceComponent(t, "CoverageEligibilityResponse", "insurance", element.getInsurance().get(i), i);
        }
        if (element.hasPreAuthRefElement()) {
            this.composeString(t, "CoverageEligibilityResponse", "preAuthRef", element.getPreAuthRefElement(), -1);
        }
        if (element.hasForm()) {
            this.composeCodeableConcept(t, "CoverageEligibilityResponse", "form", element.getForm(), -1);
        }
        for (i = 0; i < element.getError().size(); ++i) {
            this.composeCoverageEligibilityResponseErrorsComponent(t, "CoverageEligibilityResponse", "error", element.getError().get(i), i);
        }
    }

    protected void composeCoverageEligibilityResponseInsuranceComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityResponse.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasCoverage()) {
            this.composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
        }
        if (element.hasInforceElement()) {
            this.composeBoolean(t, "InsuranceComponent", "inforce", element.getInforceElement(), -1);
        }
        if (element.hasBenefitPeriod()) {
            this.composePeriod(t, "InsuranceComponent", "benefitPeriod", element.getBenefitPeriod(), -1);
        }
        for (int i = 0; i < element.getItem().size(); ++i) {
            this.composeCoverageEligibilityResponseItemsComponent(t, "InsuranceComponent", "item", element.getItem().get(i), i);
        }
    }

    protected void composeCoverageEligibilityResponseItemsComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityResponse.ItemsComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ItemsComponent", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "ItemsComponent", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ItemsComponent", "modifier", element.getModifier().get(i), i);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "ItemsComponent", "provider", element.getProvider(), -1);
        }
        if (element.hasExcludedElement()) {
            this.composeBoolean(t, "ItemsComponent", "excluded", element.getExcludedElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ItemsComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ItemsComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNetwork()) {
            this.composeCodeableConcept(t, "ItemsComponent", "network", element.getNetwork(), -1);
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "ItemsComponent", "unit", element.getUnit(), -1);
        }
        if (element.hasTerm()) {
            this.composeCodeableConcept(t, "ItemsComponent", "term", element.getTerm(), -1);
        }
        for (i = 0; i < element.getBenefit().size(); ++i) {
            this.composeCoverageEligibilityResponseBenefitComponent(t, "ItemsComponent", "benefit", element.getBenefit().get(i), i);
        }
        if (element.hasAuthorizationRequiredElement()) {
            this.composeBoolean(t, "ItemsComponent", "authorizationRequired", element.getAuthorizationRequiredElement(), -1);
        }
        for (i = 0; i < element.getAuthorizationSupporting().size(); ++i) {
            this.composeCodeableConcept(t, "ItemsComponent", "authorizationSupporting", element.getAuthorizationSupporting().get(i), i);
        }
        if (element.hasAuthorizationUrlElement()) {
            this.composeUri(t, "ItemsComponent", "authorizationUrl", element.getAuthorizationUrlElement(), -1);
        }
    }

    protected void composeCoverageEligibilityResponseBenefitComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityResponse.BenefitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "benefit", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "BenefitComponent", "type", element.getType(), -1);
        }
        if (element.hasAllowed()) {
            this.composeType(t, "BenefitComponent", "allowed", element.getAllowed(), -1);
        }
        if (element.hasUsed()) {
            this.composeType(t, "BenefitComponent", "used", element.getUsed(), -1);
        }
    }

    protected void composeCoverageEligibilityResponseErrorsComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityResponse.ErrorsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "error", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ErrorsComponent", "code", element.getCode(), -1);
        }
    }

    protected void composeDetectedIssue(Turtle.Complex parent, String parentType, String name, DetectedIssue element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DetectedIssue", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DetectedIssue", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DetectedIssue", "status", element.getStatusElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "DetectedIssue", "code", element.getCode(), -1);
        }
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "DetectedIssue", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "DetectedIssue", "patient", element.getPatient(), -1);
        }
        if (element.hasIdentified()) {
            this.composeType(t, "DetectedIssue", "identified", element.getIdentified(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "DetectedIssue", "author", element.getAuthor(), -1);
        }
        for (i = 0; i < element.getImplicated().size(); ++i) {
            this.composeReference(t, "DetectedIssue", "implicated", element.getImplicated().get(i), i);
        }
        for (i = 0; i < element.getEvidence().size(); ++i) {
            this.composeDetectedIssueEvidenceComponent(t, "DetectedIssue", "evidence", element.getEvidence().get(i), i);
        }
        if (element.hasDetailElement()) {
            this.composeString(t, "DetectedIssue", "detail", element.getDetailElement(), -1);
        }
        if (element.hasReferenceElement()) {
            this.composeUri(t, "DetectedIssue", "reference", element.getReferenceElement(), -1);
        }
        for (i = 0; i < element.getMitigation().size(); ++i) {
            this.composeDetectedIssueMitigationComponent(t, "DetectedIssue", "mitigation", element.getMitigation().get(i), i);
        }
    }

    protected void composeDetectedIssueEvidenceComponent(Turtle.Complex parent, String parentType, String name, DetectedIssue.DetectedIssueEvidenceComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "evidence", name, element, index);
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "DetectedIssueEvidenceComponent", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeReference(t, "DetectedIssueEvidenceComponent", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeDetectedIssueMitigationComponent(Turtle.Complex parent, String parentType, String name, DetectedIssue.DetectedIssueMitigationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "mitigation", name, element, index);
        if (element.hasAction()) {
            this.composeCodeableConcept(t, "DetectedIssueMitigationComponent", "action", element.getAction(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "DetectedIssueMitigationComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "DetectedIssueMitigationComponent", "author", element.getAuthor(), -1);
        }
    }

    protected void composeDevice(Turtle.Complex parent, String parentType, String name, Device element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Device", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Device", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasDefinition()) {
            this.composeReference(t, "Device", "definition", element.getDefinition(), -1);
        }
        for (i = 0; i < element.getUdiCarrier().size(); ++i) {
            this.composeDeviceUdiCarrierComponent(t, "Device", "udiCarrier", element.getUdiCarrier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Device", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getStatusReason().size(); ++i) {
            this.composeCodeableConcept(t, "Device", "statusReason", element.getStatusReason().get(i), i);
        }
        if (element.hasDistinctIdentifierElement()) {
            this.composeString(t, "Device", "distinctIdentifier", element.getDistinctIdentifierElement(), -1);
        }
        if (element.hasManufacturerElement()) {
            this.composeString(t, "Device", "manufacturer", element.getManufacturerElement(), -1);
        }
        if (element.hasManufactureDateElement()) {
            this.composeDateTime(t, "Device", "manufactureDate", element.getManufactureDateElement(), -1);
        }
        if (element.hasExpirationDateElement()) {
            this.composeDateTime(t, "Device", "expirationDate", element.getExpirationDateElement(), -1);
        }
        if (element.hasLotNumberElement()) {
            this.composeString(t, "Device", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasSerialNumberElement()) {
            this.composeString(t, "Device", "serialNumber", element.getSerialNumberElement(), -1);
        }
        for (i = 0; i < element.getDeviceName().size(); ++i) {
            this.composeDeviceDeviceNameComponent(t, "Device", "deviceName", element.getDeviceName().get(i), i);
        }
        if (element.hasModelNumberElement()) {
            this.composeString(t, "Device", "modelNumber", element.getModelNumberElement(), -1);
        }
        if (element.hasPartNumberElement()) {
            this.composeString(t, "Device", "partNumber", element.getPartNumberElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Device", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSpecialization().size(); ++i) {
            this.composeDeviceSpecializationComponent(t, "Device", "specialization", element.getSpecialization().get(i), i);
        }
        for (i = 0; i < element.getVersion().size(); ++i) {
            this.composeDeviceVersionComponent(t, "Device", "version", element.getVersion().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeDevicePropertyComponent(t, "Device", "property", element.getProperty().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Device", "patient", element.getPatient(), -1);
        }
        if (element.hasOwner()) {
            this.composeReference(t, "Device", "owner", element.getOwner(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactPoint(t, "Device", "contact", element.getContact().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Device", "location", element.getLocation(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Device", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Device", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getSafety().size(); ++i) {
            this.composeCodeableConcept(t, "Device", "safety", element.getSafety().get(i), i);
        }
        if (element.hasParent()) {
            this.composeReference(t, "Device", "parent", element.getParent(), -1);
        }
    }

    protected void composeDeviceUdiCarrierComponent(Turtle.Complex parent, String parentType, String name, Device.DeviceUdiCarrierComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "udiCarrier", name, element, index);
        if (element.hasDeviceIdentifierElement()) {
            this.composeString(t, "DeviceUdiCarrierComponent", "deviceIdentifier", element.getDeviceIdentifierElement(), -1);
        }
        if (element.hasIssuerElement()) {
            this.composeUri(t, "DeviceUdiCarrierComponent", "issuer", element.getIssuerElement(), -1);
        }
        if (element.hasJurisdictionElement()) {
            this.composeUri(t, "DeviceUdiCarrierComponent", "jurisdiction", element.getJurisdictionElement(), -1);
        }
        if (element.hasCarrierAIDCElement()) {
            this.composeBase64Binary(t, "DeviceUdiCarrierComponent", "carrierAIDC", element.getCarrierAIDCElement(), -1);
        }
        if (element.hasCarrierHRFElement()) {
            this.composeString(t, "DeviceUdiCarrierComponent", "carrierHRF", element.getCarrierHRFElement(), -1);
        }
        if (element.hasEntryTypeElement()) {
            this.composeEnum(t, "DeviceUdiCarrierComponent", "entryType", element.getEntryTypeElement(), -1);
        }
    }

    protected void composeDeviceDeviceNameComponent(Turtle.Complex parent, String parentType, String name, Device.DeviceDeviceNameComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "deviceName", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "DeviceDeviceNameComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "DeviceDeviceNameComponent", "type", element.getTypeElement(), -1);
        }
    }

    protected void composeDeviceSpecializationComponent(Turtle.Complex parent, String parentType, String name, Device.DeviceSpecializationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "specialization", name, element, index);
        if (element.hasSystemType()) {
            this.composeCodeableConcept(t, "DeviceSpecializationComponent", "systemType", element.getSystemType(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "DeviceSpecializationComponent", "version", element.getVersionElement(), -1);
        }
    }

    protected void composeDeviceVersionComponent(Turtle.Complex parent, String parentType, String name, Device.DeviceVersionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "version", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceVersionComponent", "type", element.getType(), -1);
        }
        if (element.hasComponent()) {
            this.composeIdentifier(t, "DeviceVersionComponent", "component", element.getComponent(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "DeviceVersionComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeDevicePropertyComponent(Turtle.Complex parent, String parentType, String name, Device.DevicePropertyComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DevicePropertyComponent", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getValueQuantity().size(); ++i) {
            this.composeQuantity(t, "DevicePropertyComponent", "valueQuantity", element.getValueQuantity().get(i), i);
        }
        for (i = 0; i < element.getValueCode().size(); ++i) {
            this.composeCodeableConcept(t, "DevicePropertyComponent", "valueCode", element.getValueCode().get(i), i);
        }
    }

    protected void composeDeviceDefinition(Turtle.Complex parent, String parentType, String name, DeviceDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceDefinition", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DeviceDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getUdiDeviceIdentifier().size(); ++i) {
            this.composeDeviceDefinitionUdiDeviceIdentifierComponent(t, "DeviceDefinition", "udiDeviceIdentifier", element.getUdiDeviceIdentifier().get(i), i);
        }
        if (element.hasManufacturer()) {
            this.composeType(t, "DeviceDefinition", "manufacturer", element.getManufacturer(), -1);
        }
        for (i = 0; i < element.getDeviceName().size(); ++i) {
            this.composeDeviceDefinitionDeviceNameComponent(t, "DeviceDefinition", "deviceName", element.getDeviceName().get(i), i);
        }
        if (element.hasModelNumberElement()) {
            this.composeString(t, "DeviceDefinition", "modelNumber", element.getModelNumberElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceDefinition", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSpecialization().size(); ++i) {
            this.composeDeviceDefinitionSpecializationComponent(t, "DeviceDefinition", "specialization", element.getSpecialization().get(i), i);
        }
        for (i = 0; i < element.getVersion().size(); ++i) {
            this.composeString(t, "DeviceDefinition", "version", element.getVersion().get(i), i);
        }
        for (i = 0; i < element.getSafety().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceDefinition", "safety", element.getSafety().get(i), i);
        }
        for (i = 0; i < element.getShelfLifeStorage().size(); ++i) {
            this.composeProductShelfLife(t, "DeviceDefinition", "shelfLifeStorage", element.getShelfLifeStorage().get(i), i);
        }
        if (element.hasPhysicalCharacteristics()) {
            this.composeProdCharacteristic(t, "DeviceDefinition", "physicalCharacteristics", element.getPhysicalCharacteristics(), -1);
        }
        for (i = 0; i < element.getLanguageCode().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceDefinition", "languageCode", element.getLanguageCode().get(i), i);
        }
        for (i = 0; i < element.getCapability().size(); ++i) {
            this.composeDeviceDefinitionCapabilityComponent(t, "DeviceDefinition", "capability", element.getCapability().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeDeviceDefinitionPropertyComponent(t, "DeviceDefinition", "property", element.getProperty().get(i), i);
        }
        if (element.hasOwner()) {
            this.composeReference(t, "DeviceDefinition", "owner", element.getOwner(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactPoint(t, "DeviceDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "DeviceDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasOnlineInformationElement()) {
            this.composeUri(t, "DeviceDefinition", "onlineInformation", element.getOnlineInformationElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "DeviceDefinition", "note", element.getNote().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "DeviceDefinition", "quantity", element.getQuantity(), -1);
        }
        if (element.hasParentDevice()) {
            this.composeReference(t, "DeviceDefinition", "parentDevice", element.getParentDevice(), -1);
        }
        for (i = 0; i < element.getMaterial().size(); ++i) {
            this.composeDeviceDefinitionMaterialComponent(t, "DeviceDefinition", "material", element.getMaterial().get(i), i);
        }
    }

    protected void composeDeviceDefinitionUdiDeviceIdentifierComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "udiDeviceIdentifier", name, element, index);
        if (element.hasDeviceIdentifierElement()) {
            this.composeString(t, "DeviceDefinitionUdiDeviceIdentifierComponent", "deviceIdentifier", element.getDeviceIdentifierElement(), -1);
        }
        if (element.hasIssuerElement()) {
            this.composeUri(t, "DeviceDefinitionUdiDeviceIdentifierComponent", "issuer", element.getIssuerElement(), -1);
        }
        if (element.hasJurisdictionElement()) {
            this.composeUri(t, "DeviceDefinitionUdiDeviceIdentifierComponent", "jurisdiction", element.getJurisdictionElement(), -1);
        }
    }

    protected void composeDeviceDefinitionDeviceNameComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionDeviceNameComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "deviceName", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "DeviceDefinitionDeviceNameComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "DeviceDefinitionDeviceNameComponent", "type", element.getTypeElement(), -1);
        }
    }

    protected void composeDeviceDefinitionSpecializationComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionSpecializationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "specialization", name, element, index);
        if (element.hasSystemTypeElement()) {
            this.composeString(t, "DeviceDefinitionSpecializationComponent", "systemType", element.getSystemTypeElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "DeviceDefinitionSpecializationComponent", "version", element.getVersionElement(), -1);
        }
    }

    protected void composeDeviceDefinitionCapabilityComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionCapabilityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "capability", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceDefinitionCapabilityComponent", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getDescription().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceDefinitionCapabilityComponent", "description", element.getDescription().get(i), i);
        }
    }

    protected void composeDeviceDefinitionPropertyComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionPropertyComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceDefinitionPropertyComponent", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getValueQuantity().size(); ++i) {
            this.composeQuantity(t, "DeviceDefinitionPropertyComponent", "valueQuantity", element.getValueQuantity().get(i), i);
        }
        for (i = 0; i < element.getValueCode().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceDefinitionPropertyComponent", "valueCode", element.getValueCode().get(i), i);
        }
    }

    protected void composeDeviceDefinitionMaterialComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionMaterialComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "material", name, element, index);
        if (element.hasSubstance()) {
            this.composeCodeableConcept(t, "DeviceDefinitionMaterialComponent", "substance", element.getSubstance(), -1);
        }
        if (element.hasAlternateElement()) {
            this.composeBoolean(t, "DeviceDefinitionMaterialComponent", "alternate", element.getAlternateElement(), -1);
        }
        if (element.hasAllergenicIndicatorElement()) {
            this.composeBoolean(t, "DeviceDefinitionMaterialComponent", "allergenicIndicator", element.getAllergenicIndicatorElement(), -1);
        }
    }

    protected void composeDeviceMetric(Turtle.Complex parent, String parentType, String name, DeviceMetric element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceMetric", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DeviceMetric", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceMetric", "type", element.getType(), -1);
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "DeviceMetric", "unit", element.getUnit(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "DeviceMetric", "source", element.getSource(), -1);
        }
        if (element.hasParent()) {
            this.composeReference(t, "DeviceMetric", "parent", element.getParent(), -1);
        }
        if (element.hasOperationalStatusElement()) {
            this.composeEnum(t, "DeviceMetric", "operationalStatus", element.getOperationalStatusElement(), -1);
        }
        if (element.hasColorElement()) {
            this.composeEnum(t, "DeviceMetric", "color", element.getColorElement(), -1);
        }
        if (element.hasCategoryElement()) {
            this.composeEnum(t, "DeviceMetric", "category", element.getCategoryElement(), -1);
        }
        if (element.hasMeasurementPeriod()) {
            this.composeTiming(t, "DeviceMetric", "measurementPeriod", element.getMeasurementPeriod(), -1);
        }
        for (i = 0; i < element.getCalibration().size(); ++i) {
            this.composeDeviceMetricCalibrationComponent(t, "DeviceMetric", "calibration", element.getCalibration().get(i), i);
        }
    }

    protected void composeDeviceMetricCalibrationComponent(Turtle.Complex parent, String parentType, String name, DeviceMetric.DeviceMetricCalibrationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "calibration", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "DeviceMetricCalibrationComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasStateElement()) {
            this.composeEnum(t, "DeviceMetricCalibrationComponent", "state", element.getStateElement(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeInstant(t, "DeviceMetricCalibrationComponent", "time", element.getTimeElement(), -1);
        }
    }

    protected void composeDeviceRequest(Turtle.Complex parent, String parentType, String name, DeviceRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DeviceRequest", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "DeviceRequest", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "DeviceRequest", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPriorRequest().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "priorRequest", element.getPriorRequest().get(i), i);
        }
        if (element.hasGroupIdentifier()) {
            this.composeIdentifier(t, "DeviceRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DeviceRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "DeviceRequest", "intent", element.getIntentElement(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "DeviceRequest", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasCode()) {
            this.composeType(t, "DeviceRequest", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeDeviceRequestParameterComponent(t, "DeviceRequest", "parameter", element.getParameter().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DeviceRequest", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "DeviceRequest", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "DeviceRequest", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "DeviceRequest", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "DeviceRequest", "requester", element.getRequester(), -1);
        }
        if (element.hasPerformerType()) {
            this.composeCodeableConcept(t, "DeviceRequest", "performerType", element.getPerformerType(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "DeviceRequest", "performer", element.getPerformer(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceRequest", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "insurance", element.getInsurance().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "DeviceRequest", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getRelevantHistory().size(); ++i) {
            this.composeReference(t, "DeviceRequest", "relevantHistory", element.getRelevantHistory().get(i), i);
        }
    }

    protected void composeDeviceRequestParameterComponent(Turtle.Complex parent, String parentType, String name, DeviceRequest.DeviceRequestParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "DeviceRequestParameterComponent", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "DeviceRequestParameterComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeDeviceUseStatement(Turtle.Complex parent, String parentType, String name, DeviceUseStatement element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceUseStatement", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DeviceUseStatement", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "DeviceUseStatement", "basedOn", element.getBasedOn().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DeviceUseStatement", "status", element.getStatusElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DeviceUseStatement", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getDerivedFrom().size(); ++i) {
            this.composeReference(t, "DeviceUseStatement", "derivedFrom", element.getDerivedFrom().get(i), i);
        }
        if (element.hasTiming()) {
            this.composeType(t, "DeviceUseStatement", "timing", element.getTiming(), -1);
        }
        if (element.hasRecordedOnElement()) {
            this.composeDateTime(t, "DeviceUseStatement", "recordedOn", element.getRecordedOnElement(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "DeviceUseStatement", "source", element.getSource(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "DeviceUseStatement", "device", element.getDevice(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceUseStatement", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "DeviceUseStatement", "reasonReference", element.getReasonReference().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "DeviceUseStatement", "bodySite", element.getBodySite(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "DeviceUseStatement", "note", element.getNote().get(i), i);
        }
    }

    protected void composeDiagnosticReport(Turtle.Complex parent, String parentType, String name, DiagnosticReport element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DiagnosticReport", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DiagnosticReport", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "basedOn", element.getBasedOn().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DiagnosticReport", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "DiagnosticReport", "category", element.getCategory().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "DiagnosticReport", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DiagnosticReport", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "DiagnosticReport", "encounter", element.getEncounter(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "DiagnosticReport", "effective", element.getEffective(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeInstant(t, "DiagnosticReport", "issued", element.getIssuedElement(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getResultsInterpreter().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "resultsInterpreter", element.getResultsInterpreter().get(i), i);
        }
        for (i = 0; i < element.getSpecimen().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "specimen", element.getSpecimen().get(i), i);
        }
        for (i = 0; i < element.getResult().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "result", element.getResult().get(i), i);
        }
        for (i = 0; i < element.getImagingStudy().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "imagingStudy", element.getImagingStudy().get(i), i);
        }
        for (i = 0; i < element.getMedia().size(); ++i) {
            this.composeDiagnosticReportMediaComponent(t, "DiagnosticReport", "media", element.getMedia().get(i), i);
        }
        if (element.hasConclusionElement()) {
            this.composeString(t, "DiagnosticReport", "conclusion", element.getConclusionElement(), -1);
        }
        for (i = 0; i < element.getConclusionCode().size(); ++i) {
            this.composeCodeableConcept(t, "DiagnosticReport", "conclusionCode", element.getConclusionCode().get(i), i);
        }
        for (i = 0; i < element.getPresentedForm().size(); ++i) {
            this.composeAttachment(t, "DiagnosticReport", "presentedForm", element.getPresentedForm().get(i), i);
        }
    }

    protected void composeDiagnosticReportMediaComponent(Turtle.Complex parent, String parentType, String name, DiagnosticReport.DiagnosticReportMediaComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "media", name, element, index);
        if (element.hasCommentElement()) {
            this.composeString(t, "DiagnosticReportMediaComponent", "comment", element.getCommentElement(), -1);
        }
        if (element.hasLink()) {
            this.composeReference(t, "DiagnosticReportMediaComponent", "link", element.getLink(), -1);
        }
    }

    protected void composeDocumentManifest(Turtle.Complex parent, String parentType, String name, DocumentManifest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DocumentManifest", name, element, index);
        if (element.hasMasterIdentifier()) {
            this.composeIdentifier(t, "DocumentManifest", "masterIdentifier", element.getMasterIdentifier(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DocumentManifest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DocumentManifest", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DocumentManifest", "type", element.getType(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DocumentManifest", "subject", element.getSubject(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "DocumentManifest", "created", element.getCreatedElement(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeReference(t, "DocumentManifest", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getRecipient().size(); ++i) {
            this.composeReference(t, "DocumentManifest", "recipient", element.getRecipient().get(i), i);
        }
        if (element.hasSourceElement()) {
            this.composeUri(t, "DocumentManifest", "source", element.getSourceElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "DocumentManifest", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getContent().size(); ++i) {
            this.composeReference(t, "DocumentManifest", "content", element.getContent().get(i), i);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeDocumentManifestRelatedComponent(t, "DocumentManifest", "related", element.getRelated().get(i), i);
        }
    }

    protected void composeDocumentManifestRelatedComponent(Turtle.Complex parent, String parentType, String name, DocumentManifest.DocumentManifestRelatedComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "DocumentManifestRelatedComponent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasRef()) {
            this.composeReference(t, "DocumentManifestRelatedComponent", "ref", element.getRef(), -1);
        }
    }

    protected void composeDocumentReference(Turtle.Complex parent, String parentType, String name, DocumentReference element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DocumentReference", name, element, index);
        if (element.hasMasterIdentifier()) {
            this.composeIdentifier(t, "DocumentReference", "masterIdentifier", element.getMasterIdentifier(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DocumentReference", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DocumentReference", "status", element.getStatusElement(), -1);
        }
        if (element.hasDocStatusElement()) {
            this.composeEnum(t, "DocumentReference", "docStatus", element.getDocStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DocumentReference", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "DocumentReference", "category", element.getCategory().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DocumentReference", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeInstant(t, "DocumentReference", "date", element.getDateElement(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeReference(t, "DocumentReference", "author", element.getAuthor().get(i), i);
        }
        if (element.hasAuthenticator()) {
            this.composeReference(t, "DocumentReference", "authenticator", element.getAuthenticator(), -1);
        }
        if (element.hasCustodian()) {
            this.composeReference(t, "DocumentReference", "custodian", element.getCustodian(), -1);
        }
        for (i = 0; i < element.getRelatesTo().size(); ++i) {
            this.composeDocumentReferenceRelatesToComponent(t, "DocumentReference", "relatesTo", element.getRelatesTo().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "DocumentReference", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getSecurityLabel().size(); ++i) {
            this.composeCodeableConcept(t, "DocumentReference", "securityLabel", element.getSecurityLabel().get(i), i);
        }
        for (i = 0; i < element.getContent().size(); ++i) {
            this.composeDocumentReferenceContentComponent(t, "DocumentReference", "content", element.getContent().get(i), i);
        }
        if (element.hasContext()) {
            this.composeDocumentReferenceContextComponent(t, "DocumentReference", "context", element.getContext(), -1);
        }
    }

    protected void composeDocumentReferenceRelatesToComponent(Turtle.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceRelatesToComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatesTo", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "DocumentReferenceRelatesToComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeReference(t, "DocumentReferenceRelatesToComponent", "target", element.getTarget(), -1);
        }
    }

    protected void composeDocumentReferenceContentComponent(Turtle.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceContentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "content", name, element, index);
        if (element.hasAttachment()) {
            this.composeAttachment(t, "DocumentReferenceContentComponent", "attachment", element.getAttachment(), -1);
        }
        if (element.hasFormat()) {
            this.composeCoding(t, "DocumentReferenceContentComponent", "format", element.getFormat(), -1);
        }
    }

    protected void composeDocumentReferenceContextComponent(Turtle.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceContextComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "context", name, element, index);
        for (i = 0; i < element.getEncounter().size(); ++i) {
            this.composeReference(t, "DocumentReferenceContextComponent", "encounter", element.getEncounter().get(i), i);
        }
        for (i = 0; i < element.getEvent().size(); ++i) {
            this.composeCodeableConcept(t, "DocumentReferenceContextComponent", "event", element.getEvent().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "DocumentReferenceContextComponent", "period", element.getPeriod(), -1);
        }
        if (element.hasFacilityType()) {
            this.composeCodeableConcept(t, "DocumentReferenceContextComponent", "facilityType", element.getFacilityType(), -1);
        }
        if (element.hasPracticeSetting()) {
            this.composeCodeableConcept(t, "DocumentReferenceContextComponent", "practiceSetting", element.getPracticeSetting(), -1);
        }
        if (element.hasSourcePatientInfo()) {
            this.composeReference(t, "DocumentReferenceContextComponent", "sourcePatientInfo", element.getSourcePatientInfo(), -1);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeReference(t, "DocumentReferenceContextComponent", "related", element.getRelated().get(i), i);
        }
    }

    protected void composeEncounter(Turtle.Complex parent, String parentType, String name, Encounter element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Encounter", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Encounter", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Encounter", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getStatusHistory().size(); ++i) {
            this.composeEncounterStatusHistoryComponent(t, "Encounter", "statusHistory", element.getStatusHistory().get(i), i);
        }
        if (element.hasClass_()) {
            this.composeCoding(t, "Encounter", "class", element.getClass_(), -1);
        }
        for (i = 0; i < element.getClassHistory().size(); ++i) {
            this.composeEncounterClassHistoryComponent(t, "Encounter", "classHistory", element.getClassHistory().get(i), i);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "type", element.getType().get(i), i);
        }
        if (element.hasServiceType()) {
            this.composeCodeableConcept(t, "Encounter", "serviceType", element.getServiceType(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "Encounter", "priority", element.getPriority(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Encounter", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getEpisodeOfCare().size(); ++i) {
            this.composeReference(t, "Encounter", "episodeOfCare", element.getEpisodeOfCare().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Encounter", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeEncounterParticipantComponent(t, "Encounter", "participant", element.getParticipant().get(i), i);
        }
        for (i = 0; i < element.getAppointment().size(); ++i) {
            this.composeReference(t, "Encounter", "appointment", element.getAppointment().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Encounter", "period", element.getPeriod(), -1);
        }
        if (element.hasLength()) {
            this.composeDuration(t, "Encounter", "length", element.getLength(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "Encounter", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeEncounterDiagnosisComponent(t, "Encounter", "diagnosis", element.getDiagnosis().get(i), i);
        }
        for (i = 0; i < element.getAccount().size(); ++i) {
            this.composeReference(t, "Encounter", "account", element.getAccount().get(i), i);
        }
        if (element.hasHospitalization()) {
            this.composeEncounterHospitalizationComponent(t, "Encounter", "hospitalization", element.getHospitalization(), -1);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeEncounterLocationComponent(t, "Encounter", "location", element.getLocation().get(i), i);
        }
        if (element.hasServiceProvider()) {
            this.composeReference(t, "Encounter", "serviceProvider", element.getServiceProvider(), -1);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Encounter", "partOf", element.getPartOf(), -1);
        }
    }

    protected void composeEncounterStatusHistoryComponent(Turtle.Complex parent, String parentType, String name, Encounter.StatusHistoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "statusHistory", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "StatusHistoryComponent", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "StatusHistoryComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEncounterClassHistoryComponent(Turtle.Complex parent, String parentType, String name, Encounter.ClassHistoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "classHistory", name, element, index);
        if (element.hasClass_()) {
            this.composeCoding(t, "ClassHistoryComponent", "class", element.getClass_(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ClassHistoryComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEncounterParticipantComponent(Turtle.Complex parent, String parentType, String name, Encounter.EncounterParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "EncounterParticipantComponent", "type", element.getType().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "EncounterParticipantComponent", "period", element.getPeriod(), -1);
        }
        if (element.hasIndividual()) {
            this.composeReference(t, "EncounterParticipantComponent", "individual", element.getIndividual(), -1);
        }
    }

    protected void composeEncounterDiagnosisComponent(Turtle.Complex parent, String parentType, String name, Encounter.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasCondition()) {
            this.composeReference(t, "DiagnosisComponent", "condition", element.getCondition(), -1);
        }
        if (element.hasUse()) {
            this.composeCodeableConcept(t, "DiagnosisComponent", "use", element.getUse(), -1);
        }
        if (element.hasRankElement()) {
            this.composePositiveInt(t, "DiagnosisComponent", "rank", element.getRankElement(), -1);
        }
    }

    protected void composeEncounterHospitalizationComponent(Turtle.Complex parent, String parentType, String name, Encounter.EncounterHospitalizationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "hospitalization", name, element, index);
        if (element.hasPreAdmissionIdentifier()) {
            this.composeIdentifier(t, "EncounterHospitalizationComponent", "preAdmissionIdentifier", element.getPreAdmissionIdentifier(), -1);
        }
        if (element.hasOrigin()) {
            this.composeReference(t, "EncounterHospitalizationComponent", "origin", element.getOrigin(), -1);
        }
        if (element.hasAdmitSource()) {
            this.composeCodeableConcept(t, "EncounterHospitalizationComponent", "admitSource", element.getAdmitSource(), -1);
        }
        if (element.hasReAdmission()) {
            this.composeCodeableConcept(t, "EncounterHospitalizationComponent", "reAdmission", element.getReAdmission(), -1);
        }
        for (i = 0; i < element.getDietPreference().size(); ++i) {
            this.composeCodeableConcept(t, "EncounterHospitalizationComponent", "dietPreference", element.getDietPreference().get(i), i);
        }
        for (i = 0; i < element.getSpecialCourtesy().size(); ++i) {
            this.composeCodeableConcept(t, "EncounterHospitalizationComponent", "specialCourtesy", element.getSpecialCourtesy().get(i), i);
        }
        for (i = 0; i < element.getSpecialArrangement().size(); ++i) {
            this.composeCodeableConcept(t, "EncounterHospitalizationComponent", "specialArrangement", element.getSpecialArrangement().get(i), i);
        }
        if (element.hasDestination()) {
            this.composeReference(t, "EncounterHospitalizationComponent", "destination", element.getDestination(), -1);
        }
        if (element.hasDischargeDisposition()) {
            this.composeCodeableConcept(t, "EncounterHospitalizationComponent", "dischargeDisposition", element.getDischargeDisposition(), -1);
        }
    }

    protected void composeEncounterLocationComponent(Turtle.Complex parent, String parentType, String name, Encounter.EncounterLocationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "location", name, element, index);
        if (element.hasLocation()) {
            this.composeReference(t, "EncounterLocationComponent", "location", element.getLocation(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EncounterLocationComponent", "status", element.getStatusElement(), -1);
        }
        if (element.hasPhysicalType()) {
            this.composeCodeableConcept(t, "EncounterLocationComponent", "physicalType", element.getPhysicalType(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "EncounterLocationComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEndpoint(Turtle.Complex parent, String parentType, String name, Endpoint element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Endpoint", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Endpoint", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Endpoint", "status", element.getStatusElement(), -1);
        }
        if (element.hasConnectionType()) {
            this.composeCoding(t, "Endpoint", "connectionType", element.getConnectionType(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Endpoint", "name", element.getNameElement(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Endpoint", "managingOrganization", element.getManagingOrganization(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactPoint(t, "Endpoint", "contact", element.getContact().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Endpoint", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getPayloadType().size(); ++i) {
            this.composeCodeableConcept(t, "Endpoint", "payloadType", element.getPayloadType().get(i), i);
        }
        for (i = 0; i < element.getPayloadMimeType().size(); ++i) {
            this.composeCode(t, "Endpoint", "payloadMimeType", element.getPayloadMimeType().get(i), i);
        }
        if (element.hasAddressElement()) {
            this.composeUrl(t, "Endpoint", "address", element.getAddressElement(), -1);
        }
        for (i = 0; i < element.getHeader().size(); ++i) {
            this.composeString(t, "Endpoint", "header", element.getHeader().get(i), i);
        }
    }

    protected void composeEnrollmentRequest(Turtle.Complex parent, String parentType, String name, EnrollmentRequest element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EnrollmentRequest", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EnrollmentRequest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EnrollmentRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "EnrollmentRequest", "created", element.getCreatedElement(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "EnrollmentRequest", "insurer", element.getInsurer(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "EnrollmentRequest", "provider", element.getProvider(), -1);
        }
        if (element.hasCandidate()) {
            this.composeReference(t, "EnrollmentRequest", "candidate", element.getCandidate(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "EnrollmentRequest", "coverage", element.getCoverage(), -1);
        }
    }

    protected void composeEnrollmentResponse(Turtle.Complex parent, String parentType, String name, EnrollmentResponse element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EnrollmentResponse", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EnrollmentResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EnrollmentResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "EnrollmentResponse", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "EnrollmentResponse", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "EnrollmentResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "EnrollmentResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "EnrollmentResponse", "organization", element.getOrganization(), -1);
        }
        if (element.hasRequestProvider()) {
            this.composeReference(t, "EnrollmentResponse", "requestProvider", element.getRequestProvider(), -1);
        }
    }

    protected void composeEpisodeOfCare(Turtle.Complex parent, String parentType, String name, EpisodeOfCare element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EpisodeOfCare", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EpisodeOfCare", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EpisodeOfCare", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getStatusHistory().size(); ++i) {
            this.composeEpisodeOfCareStatusHistoryComponent(t, "EpisodeOfCare", "statusHistory", element.getStatusHistory().get(i), i);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "EpisodeOfCare", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeEpisodeOfCareDiagnosisComponent(t, "EpisodeOfCare", "diagnosis", element.getDiagnosis().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "EpisodeOfCare", "patient", element.getPatient(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "EpisodeOfCare", "managingOrganization", element.getManagingOrganization(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "EpisodeOfCare", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getReferralRequest().size(); ++i) {
            this.composeReference(t, "EpisodeOfCare", "referralRequest", element.getReferralRequest().get(i), i);
        }
        if (element.hasCareManager()) {
            this.composeReference(t, "EpisodeOfCare", "careManager", element.getCareManager(), -1);
        }
        for (i = 0; i < element.getTeam().size(); ++i) {
            this.composeReference(t, "EpisodeOfCare", "team", element.getTeam().get(i), i);
        }
        for (i = 0; i < element.getAccount().size(); ++i) {
            this.composeReference(t, "EpisodeOfCare", "account", element.getAccount().get(i), i);
        }
    }

    protected void composeEpisodeOfCareStatusHistoryComponent(Turtle.Complex parent, String parentType, String name, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "statusHistory", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EpisodeOfCareStatusHistoryComponent", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "EpisodeOfCareStatusHistoryComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEpisodeOfCareDiagnosisComponent(Turtle.Complex parent, String parentType, String name, EpisodeOfCare.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasCondition()) {
            this.composeReference(t, "DiagnosisComponent", "condition", element.getCondition(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "DiagnosisComponent", "role", element.getRole(), -1);
        }
        if (element.hasRankElement()) {
            this.composePositiveInt(t, "DiagnosisComponent", "rank", element.getRankElement(), -1);
        }
    }

    protected void composeEventDefinition(Turtle.Complex parent, String parentType, String name, EventDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EventDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "EventDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EventDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "EventDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "EventDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "EventDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "EventDefinition", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EventDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "EventDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "EventDefinition", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "EventDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "EventDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "EventDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "EventDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "EventDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "EventDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "EventDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "EventDefinition", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "EventDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "EventDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "EventDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "EventDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "EventDefinition", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "EventDefinition", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "EventDefinition", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "EventDefinition", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "EventDefinition", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "EventDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getTrigger().size(); ++i) {
            this.composeTriggerDefinition(t, "EventDefinition", "trigger", element.getTrigger().get(i), i);
        }
    }

    protected void composeEvidence(Turtle.Complex parent, String parentType, String name, Evidence element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Evidence", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Evidence", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Evidence", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Evidence", "version", element.getVersionElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Evidence", "title", element.getTitleElement(), -1);
        }
        if (element.hasCiteAs()) {
            this.composeType(t, "Evidence", "citeAs", element.getCiteAs(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Evidence", "status", element.getStatusElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Evidence", "date", element.getDateElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "Evidence", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "Evidence", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "Evidence", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Evidence", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "Evidence", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "Evidence", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "Evidence", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "Evidence", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "Evidence", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "Evidence", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Evidence", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasAssertionElement()) {
            this.composeMarkdown(t, "Evidence", "assertion", element.getAssertionElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Evidence", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getVariableDefinition().size(); ++i) {
            this.composeEvidenceVariableDefinitionComponent(t, "Evidence", "variableDefinition", element.getVariableDefinition().get(i), i);
        }
        if (element.hasSynthesisType()) {
            this.composeCodeableConcept(t, "Evidence", "synthesisType", element.getSynthesisType(), -1);
        }
        if (element.hasStudyType()) {
            this.composeCodeableConcept(t, "Evidence", "studyType", element.getStudyType(), -1);
        }
        for (i = 0; i < element.getStatistic().size(); ++i) {
            this.composeEvidenceStatisticComponent(t, "Evidence", "statistic", element.getStatistic().get(i), i);
        }
        for (i = 0; i < element.getCertainty().size(); ++i) {
            this.composeEvidenceCertaintyComponent(t, "Evidence", "certainty", element.getCertainty().get(i), i);
        }
    }

    protected void composeEvidenceVariableDefinitionComponent(Turtle.Complex parent, String parentType, String name, Evidence.EvidenceVariableDefinitionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "variableDefinition", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "EvidenceVariableDefinitionComponent", "description", element.getDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "EvidenceVariableDefinitionComponent", "note", element.getNote().get(i), i);
        }
        if (element.hasVariableRole()) {
            this.composeCodeableConcept(t, "EvidenceVariableDefinitionComponent", "variableRole", element.getVariableRole(), -1);
        }
        if (element.hasObserved()) {
            this.composeReference(t, "EvidenceVariableDefinitionComponent", "observed", element.getObserved(), -1);
        }
        if (element.hasIntended()) {
            this.composeReference(t, "EvidenceVariableDefinitionComponent", "intended", element.getIntended(), -1);
        }
        if (element.hasDirectnessMatch()) {
            this.composeCodeableConcept(t, "EvidenceVariableDefinitionComponent", "directnessMatch", element.getDirectnessMatch(), -1);
        }
    }

    protected void composeEvidenceStatisticComponent(Turtle.Complex parent, String parentType, String name, Evidence.EvidenceStatisticComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "statistic", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EvidenceStatisticComponent", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "EvidenceStatisticComponent", "note", element.getNote().get(i), i);
        }
        if (element.hasStatisticType()) {
            this.composeCodeableConcept(t, "EvidenceStatisticComponent", "statisticType", element.getStatisticType(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "EvidenceStatisticComponent", "category", element.getCategory(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "EvidenceStatisticComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasNumberOfEventsElement()) {
            this.composeUnsignedInt(t, "EvidenceStatisticComponent", "numberOfEvents", element.getNumberOfEventsElement(), -1);
        }
        if (element.hasNumberAffectedElement()) {
            this.composeUnsignedInt(t, "EvidenceStatisticComponent", "numberAffected", element.getNumberAffectedElement(), -1);
        }
        if (element.hasSampleSize()) {
            this.composeEvidenceStatisticSampleSizeComponent(t, "EvidenceStatisticComponent", "sampleSize", element.getSampleSize(), -1);
        }
        for (i = 0; i < element.getAttributeEstimate().size(); ++i) {
            this.composeEvidenceStatisticAttributeEstimateComponent(t, "EvidenceStatisticComponent", "attributeEstimate", element.getAttributeEstimate().get(i), i);
        }
        for (i = 0; i < element.getModelCharacteristic().size(); ++i) {
            this.composeEvidenceStatisticModelCharacteristicComponent(t, "EvidenceStatisticComponent", "modelCharacteristic", element.getModelCharacteristic().get(i), i);
        }
    }

    protected void composeEvidenceStatisticSampleSizeComponent(Turtle.Complex parent, String parentType, String name, Evidence.EvidenceStatisticSampleSizeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "sampleSize", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EvidenceStatisticSampleSizeComponent", "description", element.getDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "EvidenceStatisticSampleSizeComponent", "note", element.getNote().get(i), i);
        }
        if (element.hasNumberOfStudiesElement()) {
            this.composeUnsignedInt(t, "EvidenceStatisticSampleSizeComponent", "numberOfStudies", element.getNumberOfStudiesElement(), -1);
        }
        if (element.hasNumberOfParticipantsElement()) {
            this.composeUnsignedInt(t, "EvidenceStatisticSampleSizeComponent", "numberOfParticipants", element.getNumberOfParticipantsElement(), -1);
        }
        if (element.hasKnownDataCountElement()) {
            this.composeUnsignedInt(t, "EvidenceStatisticSampleSizeComponent", "knownDataCount", element.getKnownDataCountElement(), -1);
        }
    }

    protected void composeEvidenceStatisticAttributeEstimateComponent(Turtle.Complex parent, String parentType, String name, Evidence.EvidenceStatisticAttributeEstimateComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "attributeEstimate", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EvidenceStatisticAttributeEstimateComponent", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "EvidenceStatisticAttributeEstimateComponent", "note", element.getNote().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "EvidenceStatisticAttributeEstimateComponent", "type", element.getType(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "EvidenceStatisticAttributeEstimateComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasLevelElement()) {
            this.composeDecimal(t, "EvidenceStatisticAttributeEstimateComponent", "level", element.getLevelElement(), -1);
        }
        if (element.hasRange()) {
            this.composeRange(t, "EvidenceStatisticAttributeEstimateComponent", "range", element.getRange(), -1);
        }
        for (i = 0; i < element.getAttributeEstimate().size(); ++i) {
            this.composeEvidenceStatisticAttributeEstimateComponent(t, "EvidenceStatisticAttributeEstimateComponent", "attributeEstimate", element.getAttributeEstimate().get(i), i);
        }
    }

    protected void composeEvidenceStatisticModelCharacteristicComponent(Turtle.Complex parent, String parentType, String name, Evidence.EvidenceStatisticModelCharacteristicComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "modelCharacteristic", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "EvidenceStatisticModelCharacteristicComponent", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeQuantity(t, "EvidenceStatisticModelCharacteristicComponent", "value", element.getValue(), -1);
        }
        for (i = 0; i < element.getVariable().size(); ++i) {
            this.composeEvidenceStatisticModelCharacteristicVariableComponent(t, "EvidenceStatisticModelCharacteristicComponent", "variable", element.getVariable().get(i), i);
        }
        for (i = 0; i < element.getAttributeEstimate().size(); ++i) {
            this.composeEvidenceStatisticAttributeEstimateComponent(t, "EvidenceStatisticModelCharacteristicComponent", "attributeEstimate", element.getAttributeEstimate().get(i), i);
        }
    }

    protected void composeEvidenceStatisticModelCharacteristicVariableComponent(Turtle.Complex parent, String parentType, String name, Evidence.EvidenceStatisticModelCharacteristicVariableComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "variable", name, element, index);
        if (element.hasVariableDefinition()) {
            this.composeReference(t, "EvidenceStatisticModelCharacteristicVariableComponent", "variableDefinition", element.getVariableDefinition(), -1);
        }
        if (element.hasHandlingElement()) {
            this.composeEnum(t, "EvidenceStatisticModelCharacteristicVariableComponent", "handling", element.getHandlingElement(), -1);
        }
        for (i = 0; i < element.getValueCategory().size(); ++i) {
            this.composeCodeableConcept(t, "EvidenceStatisticModelCharacteristicVariableComponent", "valueCategory", element.getValueCategory().get(i), i);
        }
        for (i = 0; i < element.getValueQuantity().size(); ++i) {
            this.composeQuantity(t, "EvidenceStatisticModelCharacteristicVariableComponent", "valueQuantity", element.getValueQuantity().get(i), i);
        }
        for (i = 0; i < element.getValueRange().size(); ++i) {
            this.composeRange(t, "EvidenceStatisticModelCharacteristicVariableComponent", "valueRange", element.getValueRange().get(i), i);
        }
    }

    protected void composeEvidenceCertaintyComponent(Turtle.Complex parent, String parentType, String name, Evidence.EvidenceCertaintyComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "certainty", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EvidenceCertaintyComponent", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "EvidenceCertaintyComponent", "note", element.getNote().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "EvidenceCertaintyComponent", "type", element.getType(), -1);
        }
        if (element.hasRating()) {
            this.composeCodeableConcept(t, "EvidenceCertaintyComponent", "rating", element.getRating(), -1);
        }
        if (element.hasRaterElement()) {
            this.composeString(t, "EvidenceCertaintyComponent", "rater", element.getRaterElement(), -1);
        }
        for (i = 0; i < element.getSubcomponent().size(); ++i) {
            this.composeEvidenceCertaintyComponent(t, "EvidenceCertaintyComponent", "subcomponent", element.getSubcomponent().get(i), i);
        }
    }

    protected void composeEvidenceReport(Turtle.Complex parent, String parentType, String name, EvidenceReport element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EvidenceReport", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "EvidenceReport", "url", element.getUrlElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EvidenceReport", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "EvidenceReport", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EvidenceReport", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getRelatedIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EvidenceReport", "relatedIdentifier", element.getRelatedIdentifier().get(i), i);
        }
        if (element.hasCiteAs()) {
            this.composeType(t, "EvidenceReport", "citeAs", element.getCiteAs(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "EvidenceReport", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "EvidenceReport", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "EvidenceReport", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeEvidenceReportSubjectComponent(t, "EvidenceReport", "subject", element.getSubject(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "EvidenceReport", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "EvidenceReport", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "EvidenceReport", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "EvidenceReport", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "EvidenceReport", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "EvidenceReport", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatesTo().size(); ++i) {
            this.composeEvidenceReportRelatesToComponent(t, "EvidenceReport", "relatesTo", element.getRelatesTo().get(i), i);
        }
        for (i = 0; i < element.getSection().size(); ++i) {
            this.composeEvidenceReportSectionComponent(t, "EvidenceReport", "section", element.getSection().get(i), i);
        }
    }

    protected void composeEvidenceReportSubjectComponent(Turtle.Complex parent, String parentType, String name, EvidenceReport.EvidenceReportSubjectComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subject", name, element, index);
        for (i = 0; i < element.getCharacteristic().size(); ++i) {
            this.composeEvidenceReportSubjectCharacteristicComponent(t, "EvidenceReportSubjectComponent", "characteristic", element.getCharacteristic().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "EvidenceReportSubjectComponent", "note", element.getNote().get(i), i);
        }
    }

    protected void composeEvidenceReportSubjectCharacteristicComponent(Turtle.Complex parent, String parentType, String name, EvidenceReport.EvidenceReportSubjectCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "characteristic", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "EvidenceReportSubjectCharacteristicComponent", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "EvidenceReportSubjectCharacteristicComponent", "value", element.getValue(), -1);
        }
        if (element.hasExcludeElement()) {
            this.composeBoolean(t, "EvidenceReportSubjectCharacteristicComponent", "exclude", element.getExcludeElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "EvidenceReportSubjectCharacteristicComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEvidenceReportRelatesToComponent(Turtle.Complex parent, String parentType, String name, EvidenceReport.EvidenceReportRelatesToComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatesTo", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "EvidenceReportRelatesToComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeType(t, "EvidenceReportRelatesToComponent", "target", element.getTarget(), -1);
        }
    }

    protected void composeEvidenceReportSectionComponent(Turtle.Complex parent, String parentType, String name, EvidenceReport.SectionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "section", name, element, index);
        if (element.hasTitleElement()) {
            this.composeString(t, "SectionComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasFocus()) {
            this.composeCodeableConcept(t, "SectionComponent", "focus", element.getFocus(), -1);
        }
        if (element.hasFocusReference()) {
            this.composeReference(t, "SectionComponent", "focusReference", element.getFocusReference(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeReference(t, "SectionComponent", "author", element.getAuthor().get(i), i);
        }
        if (element.hasText()) {
            this.composeNarrative(t, "SectionComponent", "text", element.getText(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "SectionComponent", "mode", element.getModeElement(), -1);
        }
        if (element.hasOrderedBy()) {
            this.composeCodeableConcept(t, "SectionComponent", "orderedBy", element.getOrderedBy(), -1);
        }
        for (i = 0; i < element.getEntryClassifier().size(); ++i) {
            this.composeCodeableConcept(t, "SectionComponent", "entryClassifier", element.getEntryClassifier().get(i), i);
        }
        for (i = 0; i < element.getEntryReference().size(); ++i) {
            this.composeReference(t, "SectionComponent", "entryReference", element.getEntryReference().get(i), i);
        }
        for (i = 0; i < element.getEntryQuantity().size(); ++i) {
            this.composeQuantity(t, "SectionComponent", "entryQuantity", element.getEntryQuantity().get(i), i);
        }
        if (element.hasEmptyReason()) {
            this.composeCodeableConcept(t, "SectionComponent", "emptyReason", element.getEmptyReason(), -1);
        }
        for (i = 0; i < element.getSection().size(); ++i) {
            this.composeEvidenceReportSectionComponent(t, "SectionComponent", "section", element.getSection().get(i), i);
        }
    }

    protected void composeEvidenceVariable(Turtle.Complex parent, String parentType, String name, EvidenceVariable element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EvidenceVariable", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "EvidenceVariable", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EvidenceVariable", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "EvidenceVariable", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "EvidenceVariable", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "EvidenceVariable", "title", element.getTitleElement(), -1);
        }
        if (element.hasShortTitleElement()) {
            this.composeString(t, "EvidenceVariable", "shortTitle", element.getShortTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "EvidenceVariable", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EvidenceVariable", "status", element.getStatusElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "EvidenceVariable", "date", element.getDateElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "EvidenceVariable", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "EvidenceVariable", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "EvidenceVariable", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "EvidenceVariable", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "EvidenceVariable", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "EvidenceVariable", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "EvidenceVariable", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "EvidenceVariable", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "EvidenceVariable", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "EvidenceVariable", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        if (element.hasActualElement()) {
            this.composeBoolean(t, "EvidenceVariable", "actual", element.getActualElement(), -1);
        }
        if (element.hasCharacteristicCombinationElement()) {
            this.composeEnum(t, "EvidenceVariable", "characteristicCombination", element.getCharacteristicCombinationElement(), -1);
        }
        for (i = 0; i < element.getCharacteristic().size(); ++i) {
            this.composeEvidenceVariableCharacteristicComponent(t, "EvidenceVariable", "characteristic", element.getCharacteristic().get(i), i);
        }
        if (element.hasHandlingElement()) {
            this.composeEnum(t, "EvidenceVariable", "handling", element.getHandlingElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeEvidenceVariableCategoryComponent(t, "EvidenceVariable", "category", element.getCategory().get(i), i);
        }
    }

    protected void composeEvidenceVariableCharacteristicComponent(Turtle.Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "characteristic", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EvidenceVariableCharacteristicComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasDefinition()) {
            this.composeType(t, "EvidenceVariableCharacteristicComponent", "definition", element.getDefinition(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "EvidenceVariableCharacteristicComponent", "method", element.getMethod(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "EvidenceVariableCharacteristicComponent", "device", element.getDevice(), -1);
        }
        if (element.hasExcludeElement()) {
            this.composeBoolean(t, "EvidenceVariableCharacteristicComponent", "exclude", element.getExcludeElement(), -1);
        }
        if (element.hasTimeFromStart()) {
            this.composeEvidenceVariableCharacteristicTimeFromStartComponent(t, "EvidenceVariableCharacteristicComponent", "timeFromStart", element.getTimeFromStart(), -1);
        }
        if (element.hasGroupMeasureElement()) {
            this.composeEnum(t, "EvidenceVariableCharacteristicComponent", "groupMeasure", element.getGroupMeasureElement(), -1);
        }
    }

    protected void composeEvidenceVariableCharacteristicTimeFromStartComponent(Turtle.Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCharacteristicTimeFromStartComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "timeFromStart", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EvidenceVariableCharacteristicTimeFromStartComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "EvidenceVariableCharacteristicTimeFromStartComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasRange()) {
            this.composeRange(t, "EvidenceVariableCharacteristicTimeFromStartComponent", "range", element.getRange(), -1);
        }
        for (int i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "EvidenceVariableCharacteristicTimeFromStartComponent", "note", element.getNote().get(i), i);
        }
    }

    protected void composeEvidenceVariableCategoryComponent(Turtle.Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCategoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "category", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "EvidenceVariableCategoryComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "EvidenceVariableCategoryComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeExampleScenario(Turtle.Complex parent, String parentType, String name, ExampleScenario element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ExampleScenario", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ExampleScenario", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ExampleScenario", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ExampleScenario", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExampleScenario", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ExampleScenario", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ExampleScenario", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ExampleScenario", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ExampleScenario", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ExampleScenario", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ExampleScenario", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ExampleScenario", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ExampleScenario", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ExampleScenario", "purpose", element.getPurposeElement(), -1);
        }
        for (i = 0; i < element.getActor().size(); ++i) {
            this.composeExampleScenarioActorComponent(t, "ExampleScenario", "actor", element.getActor().get(i), i);
        }
        for (i = 0; i < element.getInstance().size(); ++i) {
            this.composeExampleScenarioInstanceComponent(t, "ExampleScenario", "instance", element.getInstance().get(i), i);
        }
        for (i = 0; i < element.getProcess().size(); ++i) {
            this.composeExampleScenarioProcessComponent(t, "ExampleScenario", "process", element.getProcess().get(i), i);
        }
        for (i = 0; i < element.getWorkflow().size(); ++i) {
            this.composeCanonical(t, "ExampleScenario", "workflow", element.getWorkflow().get(i), i);
        }
    }

    protected void composeExampleScenarioActorComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioActorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "actor", name, element, index);
        if (element.hasActorIdElement()) {
            this.composeString(t, "ExampleScenarioActorComponent", "actorId", element.getActorIdElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ExampleScenarioActorComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExampleScenarioActorComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenarioActorComponent", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeExampleScenarioInstanceComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasResourceIdElement()) {
            this.composeString(t, "ExampleScenarioInstanceComponent", "resourceId", element.getResourceIdElement(), -1);
        }
        if (element.hasResourceTypeElement()) {
            this.composeCode(t, "ExampleScenarioInstanceComponent", "resourceType", element.getResourceTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExampleScenarioInstanceComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenarioInstanceComponent", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getVersion().size(); ++i) {
            this.composeExampleScenarioInstanceVersionComponent(t, "ExampleScenarioInstanceComponent", "version", element.getVersion().get(i), i);
        }
        for (i = 0; i < element.getContainedInstance().size(); ++i) {
            this.composeExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenarioInstanceComponent", "containedInstance", element.getContainedInstance().get(i), i);
        }
    }

    protected void composeExampleScenarioInstanceVersionComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceVersionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "version", name, element, index);
        if (element.hasVersionIdElement()) {
            this.composeString(t, "ExampleScenarioInstanceVersionComponent", "versionId", element.getVersionIdElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenarioInstanceVersionComponent", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeExampleScenarioInstanceContainedInstanceComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "containedInstance", name, element, index);
        if (element.hasResourceIdElement()) {
            this.composeString(t, "ExampleScenarioInstanceContainedInstanceComponent", "resourceId", element.getResourceIdElement(), -1);
        }
        if (element.hasVersionIdElement()) {
            this.composeString(t, "ExampleScenarioInstanceContainedInstanceComponent", "versionId", element.getVersionIdElement(), -1);
        }
    }

    protected void composeExampleScenarioProcessComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "process", name, element, index);
        if (element.hasTitleElement()) {
            this.composeString(t, "ExampleScenarioProcessComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenarioProcessComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasPreConditionsElement()) {
            this.composeMarkdown(t, "ExampleScenarioProcessComponent", "preConditions", element.getPreConditionsElement(), -1);
        }
        if (element.hasPostConditionsElement()) {
            this.composeMarkdown(t, "ExampleScenarioProcessComponent", "postConditions", element.getPostConditionsElement(), -1);
        }
        for (int i = 0; i < element.getStep().size(); ++i) {
            this.composeExampleScenarioProcessStepComponent(t, "ExampleScenarioProcessComponent", "step", element.getStep().get(i), i);
        }
    }

    protected void composeExampleScenarioProcessStepComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "step", name, element, index);
        for (i = 0; i < element.getProcess().size(); ++i) {
            this.composeExampleScenarioProcessComponent(t, "ExampleScenarioProcessStepComponent", "process", element.getProcess().get(i), i);
        }
        if (element.hasPauseElement()) {
            this.composeBoolean(t, "ExampleScenarioProcessStepComponent", "pause", element.getPauseElement(), -1);
        }
        if (element.hasOperation()) {
            this.composeExampleScenarioProcessStepOperationComponent(t, "ExampleScenarioProcessStepComponent", "operation", element.getOperation(), -1);
        }
        for (i = 0; i < element.getAlternative().size(); ++i) {
            this.composeExampleScenarioProcessStepAlternativeComponent(t, "ExampleScenarioProcessStepComponent", "alternative", element.getAlternative().get(i), i);
        }
    }

    protected void composeExampleScenarioProcessStepOperationComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "operation", name, element, index);
        if (element.hasNumberElement()) {
            this.composeString(t, "ExampleScenarioProcessStepOperationComponent", "number", element.getNumberElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeString(t, "ExampleScenarioProcessStepOperationComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExampleScenarioProcessStepOperationComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasInitiatorElement()) {
            this.composeString(t, "ExampleScenarioProcessStepOperationComponent", "initiator", element.getInitiatorElement(), -1);
        }
        if (element.hasReceiverElement()) {
            this.composeString(t, "ExampleScenarioProcessStepOperationComponent", "receiver", element.getReceiverElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenarioProcessStepOperationComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasInitiatorActiveElement()) {
            this.composeBoolean(t, "ExampleScenarioProcessStepOperationComponent", "initiatorActive", element.getInitiatorActiveElement(), -1);
        }
        if (element.hasReceiverActiveElement()) {
            this.composeBoolean(t, "ExampleScenarioProcessStepOperationComponent", "receiverActive", element.getReceiverActiveElement(), -1);
        }
        if (element.hasRequest()) {
            this.composeExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenarioProcessStepOperationComponent", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenarioProcessStepOperationComponent", "response", element.getResponse(), -1);
        }
    }

    protected void composeExampleScenarioProcessStepAlternativeComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "alternative", name, element, index);
        if (element.hasTitleElement()) {
            this.composeString(t, "ExampleScenarioProcessStepAlternativeComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenarioProcessStepAlternativeComponent", "description", element.getDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getStep().size(); ++i) {
            this.composeExampleScenarioProcessStepComponent(t, "ExampleScenarioProcessStepAlternativeComponent", "step", element.getStep().get(i), i);
        }
    }

    protected void composeExplanationOfBenefit(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ExplanationOfBenefit", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ExplanationOfBenefit", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ExplanationOfBenefit", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "subType", element.getSubType(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ExplanationOfBenefit", "use", element.getUseElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ExplanationOfBenefit", "patient", element.getPatient(), -1);
        }
        if (element.hasBillablePeriod()) {
            this.composePeriod(t, "ExplanationOfBenefit", "billablePeriod", element.getBillablePeriod(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "ExplanationOfBenefit", "created", element.getCreatedElement(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "ExplanationOfBenefit", "enterer", element.getEnterer(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "ExplanationOfBenefit", "insurer", element.getInsurer(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "ExplanationOfBenefit", "provider", element.getProvider(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "priority", element.getPriority(), -1);
        }
        if (element.hasFundsReserveRequested()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "fundsReserveRequested", element.getFundsReserveRequested(), -1);
        }
        if (element.hasFundsReserve()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "fundsReserve", element.getFundsReserve(), -1);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeExplanationOfBenefitRelatedClaimComponent(t, "ExplanationOfBenefit", "related", element.getRelated().get(i), i);
        }
        if (element.hasPrescription()) {
            this.composeReference(t, "ExplanationOfBenefit", "prescription", element.getPrescription(), -1);
        }
        if (element.hasOriginalPrescription()) {
            this.composeReference(t, "ExplanationOfBenefit", "originalPrescription", element.getOriginalPrescription(), -1);
        }
        if (element.hasPayee()) {
            this.composeExplanationOfBenefitPayeeComponent(t, "ExplanationOfBenefit", "payee", element.getPayee(), -1);
        }
        if (element.hasReferral()) {
            this.composeReference(t, "ExplanationOfBenefit", "referral", element.getReferral(), -1);
        }
        if (element.hasFacility()) {
            this.composeReference(t, "ExplanationOfBenefit", "facility", element.getFacility(), -1);
        }
        if (element.hasClaim()) {
            this.composeReference(t, "ExplanationOfBenefit", "claim", element.getClaim(), -1);
        }
        if (element.hasClaimResponse()) {
            this.composeReference(t, "ExplanationOfBenefit", "claimResponse", element.getClaimResponse(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "ExplanationOfBenefit", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "ExplanationOfBenefit", "disposition", element.getDispositionElement(), -1);
        }
        for (i = 0; i < element.getPreAuthRef().size(); ++i) {
            this.composeString(t, "ExplanationOfBenefit", "preAuthRef", element.getPreAuthRef().get(i), i);
        }
        for (i = 0; i < element.getPreAuthRefPeriod().size(); ++i) {
            this.composePeriod(t, "ExplanationOfBenefit", "preAuthRefPeriod", element.getPreAuthRefPeriod().get(i), i);
        }
        for (i = 0; i < element.getCareTeam().size(); ++i) {
            this.composeExplanationOfBenefitCareTeamComponent(t, "ExplanationOfBenefit", "careTeam", element.getCareTeam().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeExplanationOfBenefitSupportingInformationComponent(t, "ExplanationOfBenefit", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeExplanationOfBenefitDiagnosisComponent(t, "ExplanationOfBenefit", "diagnosis", element.getDiagnosis().get(i), i);
        }
        for (i = 0; i < element.getProcedure().size(); ++i) {
            this.composeExplanationOfBenefitProcedureComponent(t, "ExplanationOfBenefit", "procedure", element.getProcedure().get(i), i);
        }
        if (element.hasPrecedenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "precedence", element.getPrecedenceElement(), -1);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeExplanationOfBenefitInsuranceComponent(t, "ExplanationOfBenefit", "insurance", element.getInsurance().get(i), i);
        }
        if (element.hasAccident()) {
            this.composeExplanationOfBenefitAccidentComponent(t, "ExplanationOfBenefit", "accident", element.getAccident(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeExplanationOfBenefitItemComponent(t, "ExplanationOfBenefit", "item", element.getItem().get(i), i);
        }
        for (i = 0; i < element.getAddItem().size(); ++i) {
            this.composeExplanationOfBenefitAddedItemComponent(t, "ExplanationOfBenefit", "addItem", element.getAddItem().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getTotal().size(); ++i) {
            this.composeExplanationOfBenefitTotalComponent(t, "ExplanationOfBenefit", "total", element.getTotal().get(i), i);
        }
        if (element.hasPayment()) {
            this.composeExplanationOfBenefitPaymentComponent(t, "ExplanationOfBenefit", "payment", element.getPayment(), -1);
        }
        if (element.hasFormCode()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "formCode", element.getFormCode(), -1);
        }
        if (element.hasForm()) {
            this.composeAttachment(t, "ExplanationOfBenefit", "form", element.getForm(), -1);
        }
        for (i = 0; i < element.getProcessNote().size(); ++i) {
            this.composeExplanationOfBenefitNoteComponent(t, "ExplanationOfBenefit", "processNote", element.getProcessNote().get(i), i);
        }
        if (element.hasBenefitPeriod()) {
            this.composePeriod(t, "ExplanationOfBenefit", "benefitPeriod", element.getBenefitPeriod(), -1);
        }
        for (i = 0; i < element.getBenefitBalance().size(); ++i) {
            this.composeExplanationOfBenefitBenefitBalanceComponent(t, "ExplanationOfBenefit", "benefitBalance", element.getBenefitBalance().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitRelatedClaimComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.RelatedClaimComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasClaim()) {
            this.composeReference(t, "RelatedClaimComponent", "claim", element.getClaim(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "RelatedClaimComponent", "relationship", element.getRelationship(), -1);
        }
        if (element.hasReference()) {
            this.composeIdentifier(t, "RelatedClaimComponent", "reference", element.getReference(), -1);
        }
    }

    protected void composeExplanationOfBenefitPayeeComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.PayeeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payee", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PayeeComponent", "type", element.getType(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "PayeeComponent", "party", element.getParty(), -1);
        }
    }

    protected void composeExplanationOfBenefitCareTeamComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.CareTeamComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "careTeam", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "CareTeamComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "CareTeamComponent", "provider", element.getProvider(), -1);
        }
        if (element.hasResponsibleElement()) {
            this.composeBoolean(t, "CareTeamComponent", "responsible", element.getResponsibleElement(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "CareTeamComponent", "role", element.getRole(), -1);
        }
        if (element.hasQualification()) {
            this.composeCodeableConcept(t, "CareTeamComponent", "qualification", element.getQualification(), -1);
        }
    }

    protected void composeExplanationOfBenefitSupportingInformationComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.SupportingInformationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supportingInfo", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "SupportingInformationComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "SupportingInformationComponent", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "SupportingInformationComponent", "code", element.getCode(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "SupportingInformationComponent", "timing", element.getTiming(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "SupportingInformationComponent", "value", element.getValue(), -1);
        }
        if (element.hasReason()) {
            this.composeCoding(t, "SupportingInformationComponent", "reason", element.getReason(), -1);
        }
    }

    protected void composeExplanationOfBenefitDiagnosisComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "DiagnosisComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasDiagnosis()) {
            this.composeType(t, "DiagnosisComponent", "diagnosis", element.getDiagnosis(), -1);
        }
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "DiagnosisComponent", "type", element.getType().get(i), i);
        }
        if (element.hasOnAdmission()) {
            this.composeCodeableConcept(t, "DiagnosisComponent", "onAdmission", element.getOnAdmission(), -1);
        }
        if (element.hasPackageCode()) {
            this.composeCodeableConcept(t, "DiagnosisComponent", "packageCode", element.getPackageCode(), -1);
        }
    }

    protected void composeExplanationOfBenefitProcedureComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.ProcedureComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "procedure", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ProcedureComponent", "sequence", element.getSequenceElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "ProcedureComponent", "type", element.getType().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ProcedureComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeType(t, "ProcedureComponent", "procedure", element.getProcedure(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "ProcedureComponent", "udi", element.getUdi().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitInsuranceComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasFocalElement()) {
            this.composeBoolean(t, "InsuranceComponent", "focal", element.getFocalElement(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
        }
        for (int i = 0; i < element.getPreAuthRef().size(); ++i) {
            this.composeString(t, "InsuranceComponent", "preAuthRef", element.getPreAuthRef().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitAccidentComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AccidentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "accident", name, element, index);
        if (element.hasDateElement()) {
            this.composeDate(t, "AccidentComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "AccidentComponent", "type", element.getType(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "AccidentComponent", "location", element.getLocation(), -1);
        }
    }

    protected void composeExplanationOfBenefitItemComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.ItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ItemComponent", "sequence", element.getSequenceElement(), -1);
        }
        for (i = 0; i < element.getCareTeamSequence().size(); ++i) {
            this.composePositiveInt(t, "ItemComponent", "careTeamSequence", element.getCareTeamSequence().get(i), i);
        }
        for (i = 0; i < element.getDiagnosisSequence().size(); ++i) {
            this.composePositiveInt(t, "ItemComponent", "diagnosisSequence", element.getDiagnosisSequence().get(i), i);
        }
        for (i = 0; i < element.getProcedureSequence().size(); ++i) {
            this.composePositiveInt(t, "ItemComponent", "procedureSequence", element.getProcedureSequence().get(i), i);
        }
        for (i = 0; i < element.getInformationSequence().size(); ++i) {
            this.composePositiveInt(t, "ItemComponent", "informationSequence", element.getInformationSequence().get(i), i);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "ItemComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ItemComponent", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "ItemComponent", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "ItemComponent", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "ItemComponent", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasServiced()) {
            this.composeType(t, "ItemComponent", "serviced", element.getServiced(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "ItemComponent", "location", element.getLocation(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ItemComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ItemComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ItemComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ItemComponent", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "ItemComponent", "udi", element.getUdi().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "ItemComponent", "bodySite", element.getBodySite(), -1);
        }
        for (i = 0; i < element.getSubSite().size(); ++i) {
            this.composeCodeableConcept(t, "ItemComponent", "subSite", element.getSubSite().get(i), i);
        }
        for (i = 0; i < element.getEncounter().size(); ++i) {
            this.composeReference(t, "ItemComponent", "encounter", element.getEncounter().get(i), i);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ItemComponent", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "ItemComponent", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeExplanationOfBenefitDetailComponent(t, "ItemComponent", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitAdjudicationComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "AdjudicationComponent", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "AdjudicationComponent", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "AdjudicationComponent", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "AdjudicationComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeExplanationOfBenefitDetailComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.DetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "DetailComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "DetailComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "DetailComponent", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "DetailComponent", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "DetailComponent", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "DetailComponent", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "DetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "DetailComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "DetailComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "DetailComponent", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "DetailComponent", "udi", element.getUdi().get(i), i);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "DetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "DetailComponent", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getSubDetail().size(); ++i) {
            this.composeExplanationOfBenefitSubDetailComponent(t, "DetailComponent", "subDetail", element.getSubDetail().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitSubDetailComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.SubDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "SubDetailComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "SubDetailComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "SubDetailComponent", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "SubDetailComponent", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "SubDetailComponent", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "SubDetailComponent", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "SubDetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "SubDetailComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "SubDetailComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "SubDetailComponent", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "SubDetailComponent", "udi", element.getUdi().get(i), i);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "SubDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "SubDetailComponent", "adjudication", element.getAdjudication().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitAddedItemComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "addItem", name, element, index);
        for (i = 0; i < element.getItemSequence().size(); ++i) {
            this.composePositiveInt(t, "AddedItemComponent", "itemSequence", element.getItemSequence().get(i), i);
        }
        for (i = 0; i < element.getDetailSequence().size(); ++i) {
            this.composePositiveInt(t, "AddedItemComponent", "detailSequence", element.getDetailSequence().get(i), i);
        }
        for (i = 0; i < element.getSubDetailSequence().size(); ++i) {
            this.composePositiveInt(t, "AddedItemComponent", "subDetailSequence", element.getSubDetailSequence().get(i), i);
        }
        for (i = 0; i < element.getProvider().size(); ++i) {
            this.composeReference(t, "AddedItemComponent", "provider", element.getProvider().get(i), i);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "AddedItemComponent", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "AddedItemComponent", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCodeableConcept(t, "AddedItemComponent", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasServiced()) {
            this.composeType(t, "AddedItemComponent", "serviced", element.getServiced(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "AddedItemComponent", "location", element.getLocation(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "AddedItemComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "AddedItemComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "AddedItemComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "AddedItemComponent", "net", element.getNet(), -1);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "AddedItemComponent", "bodySite", element.getBodySite(), -1);
        }
        for (i = 0; i < element.getSubSite().size(); ++i) {
            this.composeCodeableConcept(t, "AddedItemComponent", "subSite", element.getSubSite().get(i), i);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "AddedItemComponent", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "AddedItemComponent", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeExplanationOfBenefitAddedItemDetailComponent(t, "AddedItemComponent", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitAddedItemDetailComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "AddedItemDetailComponent", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "AddedItemDetailComponent", "modifier", element.getModifier().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "AddedItemDetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "AddedItemDetailComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "AddedItemDetailComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "AddedItemDetailComponent", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "AddedItemDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "AddedItemDetailComponent", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getSubDetail().size(); ++i) {
            this.composeExplanationOfBenefitAddedItemDetailSubDetailComponent(t, "AddedItemDetailComponent", "subDetail", element.getSubDetail().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitAddedItemDetailSubDetailComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemDetailSubDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "AddedItemDetailSubDetailComponent", "productOrService", element.getProductOrService(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "AddedItemDetailSubDetailComponent", "modifier", element.getModifier().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "AddedItemDetailSubDetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "AddedItemDetailSubDetailComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "AddedItemDetailSubDetailComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "AddedItemDetailSubDetailComponent", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "AddedItemDetailSubDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "AddedItemDetailSubDetailComponent", "adjudication", element.getAdjudication().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitTotalComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.TotalComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "total", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "TotalComponent", "category", element.getCategory(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "TotalComponent", "amount", element.getAmount(), -1);
        }
    }

    protected void composeExplanationOfBenefitPaymentComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.PaymentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payment", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PaymentComponent", "type", element.getType(), -1);
        }
        if (element.hasAdjustment()) {
            this.composeMoney(t, "PaymentComponent", "adjustment", element.getAdjustment(), -1);
        }
        if (element.hasAdjustmentReason()) {
            this.composeCodeableConcept(t, "PaymentComponent", "adjustmentReason", element.getAdjustmentReason(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDate(t, "PaymentComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "PaymentComponent", "amount", element.getAmount(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "PaymentComponent", "identifier", element.getIdentifier(), -1);
        }
    }

    protected void composeExplanationOfBenefitNoteComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.NoteComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "processNote", name, element, index);
        if (element.hasNumberElement()) {
            this.composePositiveInt(t, "NoteComponent", "number", element.getNumberElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "NoteComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "NoteComponent", "text", element.getTextElement(), -1);
        }
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "NoteComponent", "language", element.getLanguage(), -1);
        }
    }

    protected void composeExplanationOfBenefitBenefitBalanceComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.BenefitBalanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "benefitBalance", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "BenefitBalanceComponent", "category", element.getCategory(), -1);
        }
        if (element.hasExcludedElement()) {
            this.composeBoolean(t, "BenefitBalanceComponent", "excluded", element.getExcludedElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "BenefitBalanceComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "BenefitBalanceComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNetwork()) {
            this.composeCodeableConcept(t, "BenefitBalanceComponent", "network", element.getNetwork(), -1);
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "BenefitBalanceComponent", "unit", element.getUnit(), -1);
        }
        if (element.hasTerm()) {
            this.composeCodeableConcept(t, "BenefitBalanceComponent", "term", element.getTerm(), -1);
        }
        for (int i = 0; i < element.getFinancial().size(); ++i) {
            this.composeExplanationOfBenefitBenefitComponent(t, "BenefitBalanceComponent", "financial", element.getFinancial().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitBenefitComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.BenefitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "financial", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "BenefitComponent", "type", element.getType(), -1);
        }
        if (element.hasAllowed()) {
            this.composeType(t, "BenefitComponent", "allowed", element.getAllowed(), -1);
        }
        if (element.hasUsed()) {
            this.composeType(t, "BenefitComponent", "used", element.getUsed(), -1);
        }
    }

    protected void composeFamilyMemberHistory(Turtle.Complex parent, String parentType, String name, FamilyMemberHistory element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "FamilyMemberHistory", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "FamilyMemberHistory", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "FamilyMemberHistory", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "FamilyMemberHistory", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "FamilyMemberHistory", "status", element.getStatusElement(), -1);
        }
        if (element.hasDataAbsentReason()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "dataAbsentReason", element.getDataAbsentReason(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "FamilyMemberHistory", "patient", element.getPatient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "FamilyMemberHistory", "date", element.getDateElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "FamilyMemberHistory", "name", element.getNameElement(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "relationship", element.getRelationship(), -1);
        }
        if (element.hasSex()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "sex", element.getSex(), -1);
        }
        if (element.hasBorn()) {
            this.composeType(t, "FamilyMemberHistory", "born", element.getBorn(), -1);
        }
        if (element.hasAge()) {
            this.composeType(t, "FamilyMemberHistory", "age", element.getAge(), -1);
        }
        if (element.hasEstimatedAgeElement()) {
            this.composeBoolean(t, "FamilyMemberHistory", "estimatedAge", element.getEstimatedAgeElement(), -1);
        }
        if (element.hasDeceased()) {
            this.composeType(t, "FamilyMemberHistory", "deceased", element.getDeceased(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "FamilyMemberHistory", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "FamilyMemberHistory", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeFamilyMemberHistoryConditionComponent(t, "FamilyMemberHistory", "condition", element.getCondition().get(i), i);
        }
    }

    protected void composeFamilyMemberHistoryConditionComponent(Turtle.Complex parent, String parentType, String name, FamilyMemberHistory.FamilyMemberHistoryConditionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "condition", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "FamilyMemberHistoryConditionComponent", "code", element.getCode(), -1);
        }
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "FamilyMemberHistoryConditionComponent", "outcome", element.getOutcome(), -1);
        }
        if (element.hasContributedToDeathElement()) {
            this.composeBoolean(t, "FamilyMemberHistoryConditionComponent", "contributedToDeath", element.getContributedToDeathElement(), -1);
        }
        if (element.hasOnset()) {
            this.composeType(t, "FamilyMemberHistoryConditionComponent", "onset", element.getOnset(), -1);
        }
        for (int i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "FamilyMemberHistoryConditionComponent", "note", element.getNote().get(i), i);
        }
    }

    protected void composeFlag(Turtle.Complex parent, String parentType, String name, Flag element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Flag", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Flag", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Flag", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Flag", "category", element.getCategory().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Flag", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Flag", "subject", element.getSubject(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Flag", "period", element.getPeriod(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Flag", "encounter", element.getEncounter(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Flag", "author", element.getAuthor(), -1);
        }
    }

    protected void composeGoal(Turtle.Complex parent, String parentType, String name, Goal element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Goal", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Goal", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasLifecycleStatusElement()) {
            this.composeEnum(t, "Goal", "lifecycleStatus", element.getLifecycleStatusElement(), -1);
        }
        if (element.hasAchievementStatus()) {
            this.composeCodeableConcept(t, "Goal", "achievementStatus", element.getAchievementStatus(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Goal", "category", element.getCategory().get(i), i);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "Goal", "priority", element.getPriority(), -1);
        }
        if (element.hasDescription()) {
            this.composeCodeableConcept(t, "Goal", "description", element.getDescription(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Goal", "subject", element.getSubject(), -1);
        }
        if (element.hasStart()) {
            this.composeType(t, "Goal", "start", element.getStart(), -1);
        }
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeGoalTargetComponent(t, "Goal", "target", element.getTarget().get(i), i);
        }
        if (element.hasStatusDateElement()) {
            this.composeDate(t, "Goal", "statusDate", element.getStatusDateElement(), -1);
        }
        if (element.hasStatusReasonElement()) {
            this.composeString(t, "Goal", "statusReason", element.getStatusReasonElement(), -1);
        }
        if (element.hasExpressedBy()) {
            this.composeReference(t, "Goal", "expressedBy", element.getExpressedBy(), -1);
        }
        for (i = 0; i < element.getAddresses().size(); ++i) {
            this.composeReference(t, "Goal", "addresses", element.getAddresses().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Goal", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getOutcomeCode().size(); ++i) {
            this.composeCodeableConcept(t, "Goal", "outcomeCode", element.getOutcomeCode().get(i), i);
        }
        for (i = 0; i < element.getOutcomeReference().size(); ++i) {
            this.composeReference(t, "Goal", "outcomeReference", element.getOutcomeReference().get(i), i);
        }
    }

    protected void composeGoalTargetComponent(Turtle.Complex parent, String parentType, String name, Goal.GoalTargetComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasMeasure()) {
            this.composeCodeableConcept(t, "GoalTargetComponent", "measure", element.getMeasure(), -1);
        }
        if (element.hasDetail()) {
            this.composeType(t, "GoalTargetComponent", "detail", element.getDetail(), -1);
        }
        if (element.hasDue()) {
            this.composeType(t, "GoalTargetComponent", "due", element.getDue(), -1);
        }
    }

    protected void composeGraphDefinition(Turtle.Complex parent, String parentType, String name, GraphDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "GraphDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "GraphDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "GraphDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "GraphDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "GraphDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "GraphDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "GraphDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "GraphDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "GraphDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "GraphDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "GraphDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "GraphDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "GraphDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasStartElement()) {
            this.composeCode(t, "GraphDefinition", "start", element.getStartElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "GraphDefinition", "profile", element.getProfileElement(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composeGraphDefinitionLinkComponent(t, "GraphDefinition", "link", element.getLink().get(i), i);
        }
    }

    protected void composeGraphDefinitionLinkComponent(Turtle.Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "GraphDefinitionLinkComponent", "path", element.getPathElement(), -1);
        }
        if (element.hasSliceNameElement()) {
            this.composeString(t, "GraphDefinitionLinkComponent", "sliceName", element.getSliceNameElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "GraphDefinitionLinkComponent", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "GraphDefinitionLinkComponent", "max", element.getMaxElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "GraphDefinitionLinkComponent", "description", element.getDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getTarget().size(); ++i) {
            this.composeGraphDefinitionLinkTargetComponent(t, "GraphDefinitionLinkComponent", "target", element.getTarget().get(i), i);
        }
    }

    protected void composeGraphDefinitionLinkTargetComponent(Turtle.Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionLinkTargetComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "GraphDefinitionLinkTargetComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasParamsElement()) {
            this.composeString(t, "GraphDefinitionLinkTargetComponent", "params", element.getParamsElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "GraphDefinitionLinkTargetComponent", "profile", element.getProfileElement(), -1);
        }
        for (i = 0; i < element.getCompartment().size(); ++i) {
            this.composeGraphDefinitionLinkTargetCompartmentComponent(t, "GraphDefinitionLinkTargetComponent", "compartment", element.getCompartment().get(i), i);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composeGraphDefinitionLinkComponent(t, "GraphDefinitionLinkTargetComponent", "link", element.getLink().get(i), i);
        }
    }

    protected void composeGraphDefinitionLinkTargetCompartmentComponent(Turtle.Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "compartment", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "GraphDefinitionLinkTargetCompartmentComponent", "use", element.getUseElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "GraphDefinitionLinkTargetCompartmentComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasRuleElement()) {
            this.composeEnum(t, "GraphDefinitionLinkTargetCompartmentComponent", "rule", element.getRuleElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "GraphDefinitionLinkTargetCompartmentComponent", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "GraphDefinitionLinkTargetCompartmentComponent", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeGroup(Turtle.Complex parent, String parentType, String name, Group element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Group", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Group", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Group", "active", element.getActiveElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Group", "type", element.getTypeElement(), -1);
        }
        if (element.hasActualElement()) {
            this.composeBoolean(t, "Group", "actual", element.getActualElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Group", "code", element.getCode(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Group", "name", element.getNameElement(), -1);
        }
        if (element.hasQuantityElement()) {
            this.composeUnsignedInt(t, "Group", "quantity", element.getQuantityElement(), -1);
        }
        if (element.hasManagingEntity()) {
            this.composeReference(t, "Group", "managingEntity", element.getManagingEntity(), -1);
        }
        for (i = 0; i < element.getCharacteristic().size(); ++i) {
            this.composeGroupCharacteristicComponent(t, "Group", "characteristic", element.getCharacteristic().get(i), i);
        }
        for (i = 0; i < element.getMember().size(); ++i) {
            this.composeGroupMemberComponent(t, "Group", "member", element.getMember().get(i), i);
        }
    }

    protected void composeGroupCharacteristicComponent(Turtle.Complex parent, String parentType, String name, Group.GroupCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "characteristic", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "GroupCharacteristicComponent", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "GroupCharacteristicComponent", "value", element.getValue(), -1);
        }
        if (element.hasExcludeElement()) {
            this.composeBoolean(t, "GroupCharacteristicComponent", "exclude", element.getExcludeElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "GroupCharacteristicComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeGroupMemberComponent(Turtle.Complex parent, String parentType, String name, Group.GroupMemberComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "member", name, element, index);
        if (element.hasEntity()) {
            this.composeReference(t, "GroupMemberComponent", "entity", element.getEntity(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "GroupMemberComponent", "period", element.getPeriod(), -1);
        }
        if (element.hasInactiveElement()) {
            this.composeBoolean(t, "GroupMemberComponent", "inactive", element.getInactiveElement(), -1);
        }
    }

    protected void composeGuidanceResponse(Turtle.Complex parent, String parentType, String name, GuidanceResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "GuidanceResponse", name, element, index);
        if (element.hasRequestIdentifier()) {
            this.composeIdentifier(t, "GuidanceResponse", "requestIdentifier", element.getRequestIdentifier(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "GuidanceResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasModule()) {
            this.composeType(t, "GuidanceResponse", "module", element.getModule(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "GuidanceResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "GuidanceResponse", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "GuidanceResponse", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOccurrenceDateTimeElement()) {
            this.composeDateTime(t, "GuidanceResponse", "occurrenceDateTime", element.getOccurrenceDateTimeElement(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "GuidanceResponse", "performer", element.getPerformer(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "GuidanceResponse", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "GuidanceResponse", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "GuidanceResponse", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getEvaluationMessage().size(); ++i) {
            this.composeReference(t, "GuidanceResponse", "evaluationMessage", element.getEvaluationMessage().get(i), i);
        }
        if (element.hasOutputParameters()) {
            this.composeReference(t, "GuidanceResponse", "outputParameters", element.getOutputParameters(), -1);
        }
        if (element.hasResult()) {
            this.composeReference(t, "GuidanceResponse", "result", element.getResult(), -1);
        }
        for (i = 0; i < element.getDataRequirement().size(); ++i) {
            this.composeDataRequirement(t, "GuidanceResponse", "dataRequirement", element.getDataRequirement().get(i), i);
        }
    }

    protected void composeHealthcareService(Turtle.Complex parent, String parentType, String name, HealthcareService element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "HealthcareService", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "HealthcareService", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "HealthcareService", "active", element.getActiveElement(), -1);
        }
        if (element.hasProvidedBy()) {
            this.composeReference(t, "HealthcareService", "providedBy", element.getProvidedBy(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "category", element.getCategory().get(i), i);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "specialty", element.getSpecialty().get(i), i);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeReference(t, "HealthcareService", "location", element.getLocation().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "HealthcareService", "name", element.getNameElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "HealthcareService", "comment", element.getCommentElement(), -1);
        }
        if (element.hasExtraDetailsElement()) {
            this.composeMarkdown(t, "HealthcareService", "extraDetails", element.getExtraDetailsElement(), -1);
        }
        if (element.hasPhoto()) {
            this.composeAttachment(t, "HealthcareService", "photo", element.getPhoto(), -1);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "HealthcareService", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getCoverageArea().size(); ++i) {
            this.composeReference(t, "HealthcareService", "coverageArea", element.getCoverageArea().get(i), i);
        }
        for (i = 0; i < element.getServiceProvisionCode().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "serviceProvisionCode", element.getServiceProvisionCode().get(i), i);
        }
        for (i = 0; i < element.getEligibility().size(); ++i) {
            this.composeHealthcareServiceEligibilityComponent(t, "HealthcareService", "eligibility", element.getEligibility().get(i), i);
        }
        for (i = 0; i < element.getProgram().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "program", element.getProgram().get(i), i);
        }
        for (i = 0; i < element.getCharacteristic().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "characteristic", element.getCharacteristic().get(i), i);
        }
        for (i = 0; i < element.getCommunication().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "communication", element.getCommunication().get(i), i);
        }
        for (i = 0; i < element.getReferralMethod().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "referralMethod", element.getReferralMethod().get(i), i);
        }
        if (element.hasAppointmentRequiredElement()) {
            this.composeBoolean(t, "HealthcareService", "appointmentRequired", element.getAppointmentRequiredElement(), -1);
        }
        for (i = 0; i < element.getAvailableTime().size(); ++i) {
            this.composeHealthcareServiceAvailableTimeComponent(t, "HealthcareService", "availableTime", element.getAvailableTime().get(i), i);
        }
        for (i = 0; i < element.getNotAvailable().size(); ++i) {
            this.composeHealthcareServiceNotAvailableComponent(t, "HealthcareService", "notAvailable", element.getNotAvailable().get(i), i);
        }
        if (element.hasAvailabilityExceptionsElement()) {
            this.composeString(t, "HealthcareService", "availabilityExceptions", element.getAvailabilityExceptionsElement(), -1);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "HealthcareService", "endpoint", element.getEndpoint().get(i), i);
        }
    }

    protected void composeHealthcareServiceEligibilityComponent(Turtle.Complex parent, String parentType, String name, HealthcareService.HealthcareServiceEligibilityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "eligibility", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "HealthcareServiceEligibilityComponent", "code", element.getCode(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeMarkdown(t, "HealthcareServiceEligibilityComponent", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeHealthcareServiceAvailableTimeComponent(Turtle.Complex parent, String parentType, String name, HealthcareService.HealthcareServiceAvailableTimeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "availableTime", name, element, index);
        for (int i = 0; i < element.getDaysOfWeek().size(); ++i) {
            this.composeEnum(t, "HealthcareServiceAvailableTimeComponent", "daysOfWeek", element.getDaysOfWeek().get(i), i);
        }
        if (element.hasAllDayElement()) {
            this.composeBoolean(t, "HealthcareServiceAvailableTimeComponent", "allDay", element.getAllDayElement(), -1);
        }
        if (element.hasAvailableStartTimeElement()) {
            this.composeTime(t, "HealthcareServiceAvailableTimeComponent", "availableStartTime", element.getAvailableStartTimeElement(), -1);
        }
        if (element.hasAvailableEndTimeElement()) {
            this.composeTime(t, "HealthcareServiceAvailableTimeComponent", "availableEndTime", element.getAvailableEndTimeElement(), -1);
        }
    }

    protected void composeHealthcareServiceNotAvailableComponent(Turtle.Complex parent, String parentType, String name, HealthcareService.HealthcareServiceNotAvailableComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "notAvailable", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "HealthcareServiceNotAvailableComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasDuring()) {
            this.composePeriod(t, "HealthcareServiceNotAvailableComponent", "during", element.getDuring(), -1);
        }
    }

    protected void composeImagingStudy(Turtle.Complex parent, String parentType, String name, ImagingStudy element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImagingStudy", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ImagingStudy", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ImagingStudy", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getModality().size(); ++i) {
            this.composeCoding(t, "ImagingStudy", "modality", element.getModality().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ImagingStudy", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "ImagingStudy", "encounter", element.getEncounter(), -1);
        }
        if (element.hasStartedElement()) {
            this.composeDateTime(t, "ImagingStudy", "started", element.getStartedElement(), -1);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "basedOn", element.getBasedOn().get(i), i);
        }
        if (element.hasReferrer()) {
            this.composeReference(t, "ImagingStudy", "referrer", element.getReferrer(), -1);
        }
        for (i = 0; i < element.getInterpreter().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "interpreter", element.getInterpreter().get(i), i);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "endpoint", element.getEndpoint().get(i), i);
        }
        if (element.hasNumberOfSeriesElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "numberOfSeries", element.getNumberOfSeriesElement(), -1);
        }
        if (element.hasNumberOfInstancesElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "numberOfInstances", element.getNumberOfInstancesElement(), -1);
        }
        if (element.hasProcedureReference()) {
            this.composeReference(t, "ImagingStudy", "procedureReference", element.getProcedureReference(), -1);
        }
        for (i = 0; i < element.getProcedureCode().size(); ++i) {
            this.composeCodeableConcept(t, "ImagingStudy", "procedureCode", element.getProcedureCode().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "ImagingStudy", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "ImagingStudy", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ImagingStudy", "note", element.getNote().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImagingStudy", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getSeries().size(); ++i) {
            this.composeImagingStudySeriesComponent(t, "ImagingStudy", "series", element.getSeries().get(i), i);
        }
    }

    protected void composeImagingStudySeriesComponent(Turtle.Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "series", name, element, index);
        if (element.hasUidElement()) {
            this.composeId(t, "ImagingStudySeriesComponent", "uid", element.getUidElement(), -1);
        }
        if (element.hasNumberElement()) {
            this.composeUnsignedInt(t, "ImagingStudySeriesComponent", "number", element.getNumberElement(), -1);
        }
        if (element.hasModality()) {
            this.composeCoding(t, "ImagingStudySeriesComponent", "modality", element.getModality(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImagingStudySeriesComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNumberOfInstancesElement()) {
            this.composeUnsignedInt(t, "ImagingStudySeriesComponent", "numberOfInstances", element.getNumberOfInstancesElement(), -1);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "ImagingStudySeriesComponent", "endpoint", element.getEndpoint().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCoding(t, "ImagingStudySeriesComponent", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasLaterality()) {
            this.composeCoding(t, "ImagingStudySeriesComponent", "laterality", element.getLaterality(), -1);
        }
        for (i = 0; i < element.getSpecimen().size(); ++i) {
            this.composeReference(t, "ImagingStudySeriesComponent", "specimen", element.getSpecimen().get(i), i);
        }
        if (element.hasStartedElement()) {
            this.composeDateTime(t, "ImagingStudySeriesComponent", "started", element.getStartedElement(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeImagingStudySeriesPerformerComponent(t, "ImagingStudySeriesComponent", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getInstance().size(); ++i) {
            this.composeImagingStudySeriesInstanceComponent(t, "ImagingStudySeriesComponent", "instance", element.getInstance().get(i), i);
        }
    }

    protected void composeImagingStudySeriesPerformerComponent(Turtle.Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "ImagingStudySeriesPerformerComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "ImagingStudySeriesPerformerComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeImagingStudySeriesInstanceComponent(Turtle.Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesInstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasUidElement()) {
            this.composeId(t, "ImagingStudySeriesInstanceComponent", "uid", element.getUidElement(), -1);
        }
        if (element.hasSopClass()) {
            this.composeCoding(t, "ImagingStudySeriesInstanceComponent", "sopClass", element.getSopClass(), -1);
        }
        if (element.hasNumberElement()) {
            this.composeUnsignedInt(t, "ImagingStudySeriesInstanceComponent", "number", element.getNumberElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ImagingStudySeriesInstanceComponent", "title", element.getTitleElement(), -1);
        }
    }

    protected void composeImmunization(Turtle.Complex parent, String parentType, String name, Immunization element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Immunization", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Immunization", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Immunization", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "Immunization", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasVaccineCode()) {
            this.composeCodeableConcept(t, "Immunization", "vaccineCode", element.getVaccineCode(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Immunization", "patient", element.getPatient(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Immunization", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "Immunization", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasRecordedElement()) {
            this.composeDateTime(t, "Immunization", "recorded", element.getRecordedElement(), -1);
        }
        if (element.hasPrimarySourceElement()) {
            this.composeBoolean(t, "Immunization", "primarySource", element.getPrimarySourceElement(), -1);
        }
        if (element.hasReportOrigin()) {
            this.composeCodeableConcept(t, "Immunization", "reportOrigin", element.getReportOrigin(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Immunization", "location", element.getLocation(), -1);
        }
        if (element.hasManufacturer()) {
            this.composeReference(t, "Immunization", "manufacturer", element.getManufacturer(), -1);
        }
        if (element.hasLotNumberElement()) {
            this.composeString(t, "Immunization", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasExpirationDateElement()) {
            this.composeDate(t, "Immunization", "expirationDate", element.getExpirationDateElement(), -1);
        }
        if (element.hasSite()) {
            this.composeCodeableConcept(t, "Immunization", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "Immunization", "route", element.getRoute(), -1);
        }
        if (element.hasDoseQuantity()) {
            this.composeQuantity(t, "Immunization", "doseQuantity", element.getDoseQuantity(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeImmunizationPerformerComponent(t, "Immunization", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Immunization", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Immunization", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "Immunization", "reasonReference", element.getReasonReference().get(i), i);
        }
        if (element.hasIsSubpotentElement()) {
            this.composeBoolean(t, "Immunization", "isSubpotent", element.getIsSubpotentElement(), -1);
        }
        for (i = 0; i < element.getSubpotentReason().size(); ++i) {
            this.composeCodeableConcept(t, "Immunization", "subpotentReason", element.getSubpotentReason().get(i), i);
        }
        for (i = 0; i < element.getEducation().size(); ++i) {
            this.composeImmunizationEducationComponent(t, "Immunization", "education", element.getEducation().get(i), i);
        }
        for (i = 0; i < element.getProgramEligibility().size(); ++i) {
            this.composeCodeableConcept(t, "Immunization", "programEligibility", element.getProgramEligibility().get(i), i);
        }
        if (element.hasFundingSource()) {
            this.composeCodeableConcept(t, "Immunization", "fundingSource", element.getFundingSource(), -1);
        }
        for (i = 0; i < element.getReaction().size(); ++i) {
            this.composeImmunizationReactionComponent(t, "Immunization", "reaction", element.getReaction().get(i), i);
        }
        for (i = 0; i < element.getProtocolApplied().size(); ++i) {
            this.composeImmunizationProtocolAppliedComponent(t, "Immunization", "protocolApplied", element.getProtocolApplied().get(i), i);
        }
    }

    protected void composeImmunizationPerformerComponent(Turtle.Complex parent, String parentType, String name, Immunization.ImmunizationPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "ImmunizationPerformerComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "ImmunizationPerformerComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeImmunizationEducationComponent(Turtle.Complex parent, String parentType, String name, Immunization.ImmunizationEducationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "education", name, element, index);
        if (element.hasDocumentTypeElement()) {
            this.composeString(t, "ImmunizationEducationComponent", "documentType", element.getDocumentTypeElement(), -1);
        }
        if (element.hasReferenceElement()) {
            this.composeUri(t, "ImmunizationEducationComponent", "reference", element.getReferenceElement(), -1);
        }
        if (element.hasPublicationDateElement()) {
            this.composeDateTime(t, "ImmunizationEducationComponent", "publicationDate", element.getPublicationDateElement(), -1);
        }
        if (element.hasPresentationDateElement()) {
            this.composeDateTime(t, "ImmunizationEducationComponent", "presentationDate", element.getPresentationDateElement(), -1);
        }
    }

    protected void composeImmunizationReactionComponent(Turtle.Complex parent, String parentType, String name, Immunization.ImmunizationReactionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "reaction", name, element, index);
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ImmunizationReactionComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasDetail()) {
            this.composeReference(t, "ImmunizationReactionComponent", "detail", element.getDetail(), -1);
        }
        if (element.hasReportedElement()) {
            this.composeBoolean(t, "ImmunizationReactionComponent", "reported", element.getReportedElement(), -1);
        }
    }

    protected void composeImmunizationProtocolAppliedComponent(Turtle.Complex parent, String parentType, String name, Immunization.ImmunizationProtocolAppliedComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "protocolApplied", name, element, index);
        if (element.hasSeriesElement()) {
            this.composeString(t, "ImmunizationProtocolAppliedComponent", "series", element.getSeriesElement(), -1);
        }
        if (element.hasAuthority()) {
            this.composeReference(t, "ImmunizationProtocolAppliedComponent", "authority", element.getAuthority(), -1);
        }
        for (int i = 0; i < element.getTargetDisease().size(); ++i) {
            this.composeCodeableConcept(t, "ImmunizationProtocolAppliedComponent", "targetDisease", element.getTargetDisease().get(i), i);
        }
        if (element.hasDoseNumber()) {
            this.composeType(t, "ImmunizationProtocolAppliedComponent", "doseNumber", element.getDoseNumber(), -1);
        }
        if (element.hasSeriesDoses()) {
            this.composeType(t, "ImmunizationProtocolAppliedComponent", "seriesDoses", element.getSeriesDoses(), -1);
        }
    }

    protected void composeImmunizationEvaluation(Turtle.Complex parent, String parentType, String name, ImmunizationEvaluation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImmunizationEvaluation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ImmunizationEvaluation", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ImmunizationEvaluation", "status", element.getStatusElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ImmunizationEvaluation", "patient", element.getPatient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ImmunizationEvaluation", "date", element.getDateElement(), -1);
        }
        if (element.hasAuthority()) {
            this.composeReference(t, "ImmunizationEvaluation", "authority", element.getAuthority(), -1);
        }
        if (element.hasTargetDisease()) {
            this.composeCodeableConcept(t, "ImmunizationEvaluation", "targetDisease", element.getTargetDisease(), -1);
        }
        if (element.hasImmunizationEvent()) {
            this.composeReference(t, "ImmunizationEvaluation", "immunizationEvent", element.getImmunizationEvent(), -1);
        }
        if (element.hasDoseStatus()) {
            this.composeCodeableConcept(t, "ImmunizationEvaluation", "doseStatus", element.getDoseStatus(), -1);
        }
        for (i = 0; i < element.getDoseStatusReason().size(); ++i) {
            this.composeCodeableConcept(t, "ImmunizationEvaluation", "doseStatusReason", element.getDoseStatusReason().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImmunizationEvaluation", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasSeriesElement()) {
            this.composeString(t, "ImmunizationEvaluation", "series", element.getSeriesElement(), -1);
        }
        if (element.hasDoseNumber()) {
            this.composeType(t, "ImmunizationEvaluation", "doseNumber", element.getDoseNumber(), -1);
        }
        if (element.hasSeriesDoses()) {
            this.composeType(t, "ImmunizationEvaluation", "seriesDoses", element.getSeriesDoses(), -1);
        }
    }

    protected void composeImmunizationRecommendation(Turtle.Complex parent, String parentType, String name, ImmunizationRecommendation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImmunizationRecommendation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ImmunizationRecommendation", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ImmunizationRecommendation", "patient", element.getPatient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ImmunizationRecommendation", "date", element.getDateElement(), -1);
        }
        if (element.hasAuthority()) {
            this.composeReference(t, "ImmunizationRecommendation", "authority", element.getAuthority(), -1);
        }
        for (i = 0; i < element.getRecommendation().size(); ++i) {
            this.composeImmunizationRecommendationRecommendationComponent(t, "ImmunizationRecommendation", "recommendation", element.getRecommendation().get(i), i);
        }
    }

    protected void composeImmunizationRecommendationRecommendationComponent(Turtle.Complex parent, String parentType, String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "recommendation", name, element, index);
        for (i = 0; i < element.getVaccineCode().size(); ++i) {
            this.composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "vaccineCode", element.getVaccineCode().get(i), i);
        }
        if (element.hasTargetDisease()) {
            this.composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "targetDisease", element.getTargetDisease(), -1);
        }
        for (i = 0; i < element.getContraindicatedVaccineCode().size(); ++i) {
            this.composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "contraindicatedVaccineCode", element.getContraindicatedVaccineCode().get(i), i);
        }
        if (element.hasForecastStatus()) {
            this.composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "forecastStatus", element.getForecastStatus(), -1);
        }
        for (i = 0; i < element.getForecastReason().size(); ++i) {
            this.composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "forecastReason", element.getForecastReason().get(i), i);
        }
        for (i = 0; i < element.getDateCriterion().size(); ++i) {
            this.composeImmunizationRecommendationRecommendationDateCriterionComponent(t, "ImmunizationRecommendationRecommendationComponent", "dateCriterion", element.getDateCriterion().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImmunizationRecommendationRecommendationComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasSeriesElement()) {
            this.composeString(t, "ImmunizationRecommendationRecommendationComponent", "series", element.getSeriesElement(), -1);
        }
        if (element.hasDoseNumber()) {
            this.composeType(t, "ImmunizationRecommendationRecommendationComponent", "doseNumber", element.getDoseNumber(), -1);
        }
        if (element.hasSeriesDoses()) {
            this.composeType(t, "ImmunizationRecommendationRecommendationComponent", "seriesDoses", element.getSeriesDoses(), -1);
        }
        for (i = 0; i < element.getSupportingImmunization().size(); ++i) {
            this.composeReference(t, "ImmunizationRecommendationRecommendationComponent", "supportingImmunization", element.getSupportingImmunization().get(i), i);
        }
        for (i = 0; i < element.getSupportingPatientInformation().size(); ++i) {
            this.composeReference(t, "ImmunizationRecommendationRecommendationComponent", "supportingPatientInformation", element.getSupportingPatientInformation().get(i), i);
        }
    }

    protected void composeImmunizationRecommendationRecommendationDateCriterionComponent(Turtle.Complex parent, String parentType, String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dateCriterion", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ImmunizationRecommendationRecommendationDateCriterionComponent", "code", element.getCode(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDateTime(t, "ImmunizationRecommendationRecommendationDateCriterionComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeImplementationGuide(Turtle.Complex parent, String parentType, String name, ImplementationGuide element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImplementationGuide", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ImplementationGuide", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ImplementationGuide", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ImplementationGuide", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ImplementationGuide", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ImplementationGuide", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ImplementationGuide", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ImplementationGuide", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ImplementationGuide", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ImplementationGuide", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ImplementationGuide", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ImplementationGuide", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ImplementationGuide", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasPackageIdElement()) {
            this.composeId(t, "ImplementationGuide", "packageId", element.getPackageIdElement(), -1);
        }
        if (element.hasLicenseElement()) {
            this.composeEnum(t, "ImplementationGuide", "license", element.getLicenseElement(), -1);
        }
        for (i = 0; i < element.getFhirVersion().size(); ++i) {
            this.composeEnum(t, "ImplementationGuide", "fhirVersion", element.getFhirVersion().get(i), i);
        }
        for (i = 0; i < element.getDependsOn().size(); ++i) {
            this.composeImplementationGuideDependsOnComponent(t, "ImplementationGuide", "dependsOn", element.getDependsOn().get(i), i);
        }
        for (i = 0; i < element.getGlobal().size(); ++i) {
            this.composeImplementationGuideGlobalComponent(t, "ImplementationGuide", "global", element.getGlobal().get(i), i);
        }
        if (element.hasDefinition()) {
            this.composeImplementationGuideDefinitionComponent(t, "ImplementationGuide", "definition", element.getDefinition(), -1);
        }
        if (element.hasManifest()) {
            this.composeImplementationGuideManifestComponent(t, "ImplementationGuide", "manifest", element.getManifest(), -1);
        }
    }

    protected void composeImplementationGuideDependsOnComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDependsOnComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dependsOn", name, element, index);
        if (element.hasUriElement()) {
            this.composeCanonical(t, "ImplementationGuideDependsOnComponent", "uri", element.getUriElement(), -1);
        }
        if (element.hasPackageIdElement()) {
            this.composeId(t, "ImplementationGuideDependsOnComponent", "packageId", element.getPackageIdElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ImplementationGuideDependsOnComponent", "version", element.getVersionElement(), -1);
        }
    }

    protected void composeImplementationGuideGlobalComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideGlobalComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "global", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "ImplementationGuideGlobalComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "ImplementationGuideGlobalComponent", "profile", element.getProfileElement(), -1);
        }
    }

    protected void composeImplementationGuideDefinitionComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "definition", name, element, index);
        for (i = 0; i < element.getGrouping().size(); ++i) {
            this.composeImplementationGuideDefinitionGroupingComponent(t, "ImplementationGuideDefinitionComponent", "grouping", element.getGrouping().get(i), i);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeImplementationGuideDefinitionResourceComponent(t, "ImplementationGuideDefinitionComponent", "resource", element.getResource().get(i), i);
        }
        if (element.hasPage()) {
            this.composeImplementationGuideDefinitionPageComponent(t, "ImplementationGuideDefinitionComponent", "page", element.getPage(), -1);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeImplementationGuideDefinitionParameterComponent(t, "ImplementationGuideDefinitionComponent", "parameter", element.getParameter().get(i), i);
        }
        for (i = 0; i < element.getTemplate().size(); ++i) {
            this.composeImplementationGuideDefinitionTemplateComponent(t, "ImplementationGuideDefinitionComponent", "template", element.getTemplate().get(i), i);
        }
    }

    protected void composeImplementationGuideDefinitionGroupingComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionGroupingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "grouping", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuideDefinitionGroupingComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImplementationGuideDefinitionGroupingComponent", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeImplementationGuideDefinitionResourceComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionResourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasReference()) {
            this.composeReference(t, "ImplementationGuideDefinitionResourceComponent", "reference", element.getReference(), -1);
        }
        for (int i = 0; i < element.getFhirVersion().size(); ++i) {
            this.composeEnum(t, "ImplementationGuideDefinitionResourceComponent", "fhirVersion", element.getFhirVersion().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuideDefinitionResourceComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImplementationGuideDefinitionResourceComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasExample()) {
            this.composeType(t, "ImplementationGuideDefinitionResourceComponent", "example", element.getExample(), -1);
        }
        if (element.hasGroupingIdElement()) {
            this.composeId(t, "ImplementationGuideDefinitionResourceComponent", "groupingId", element.getGroupingIdElement(), -1);
        }
    }

    protected void composeImplementationGuideDefinitionPageComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionPageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "page", name, element, index);
        if (element.hasName()) {
            this.composeType(t, "ImplementationGuideDefinitionPageComponent", "name", element.getName(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ImplementationGuideDefinitionPageComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasGenerationElement()) {
            this.composeEnum(t, "ImplementationGuideDefinitionPageComponent", "generation", element.getGenerationElement(), -1);
        }
        for (int i = 0; i < element.getPage().size(); ++i) {
            this.composeImplementationGuideDefinitionPageComponent(t, "ImplementationGuideDefinitionPageComponent", "page", element.getPage().get(i), i);
        }
    }

    protected void composeImplementationGuideDefinitionParameterComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasCodeElement()) {
            this.composeString(t, "ImplementationGuideDefinitionParameterComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ImplementationGuideDefinitionParameterComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeImplementationGuideDefinitionTemplateComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionTemplateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "template", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "ImplementationGuideDefinitionTemplateComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeString(t, "ImplementationGuideDefinitionTemplateComponent", "source", element.getSourceElement(), -1);
        }
        if (element.hasScopeElement()) {
            this.composeString(t, "ImplementationGuideDefinitionTemplateComponent", "scope", element.getScopeElement(), -1);
        }
    }

    protected void composeImplementationGuideManifestComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideManifestComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "manifest", name, element, index);
        if (element.hasRenderingElement()) {
            this.composeUrl(t, "ImplementationGuideManifestComponent", "rendering", element.getRenderingElement(), -1);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeImplementationGuideManifestResourceComponent(t, "ImplementationGuideManifestComponent", "resource", element.getResource().get(i), i);
        }
        for (i = 0; i < element.getPage().size(); ++i) {
            this.composeImplementationGuideManifestPageComponent(t, "ImplementationGuideManifestComponent", "page", element.getPage().get(i), i);
        }
        for (i = 0; i < element.getImage().size(); ++i) {
            this.composeString(t, "ImplementationGuideManifestComponent", "image", element.getImage().get(i), i);
        }
        for (i = 0; i < element.getOther().size(); ++i) {
            this.composeString(t, "ImplementationGuideManifestComponent", "other", element.getOther().get(i), i);
        }
    }

    protected void composeImplementationGuideManifestResourceComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ManifestResourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasReference()) {
            this.composeReference(t, "ManifestResourceComponent", "reference", element.getReference(), -1);
        }
        if (element.hasExample()) {
            this.composeType(t, "ManifestResourceComponent", "example", element.getExample(), -1);
        }
        if (element.hasRelativePathElement()) {
            this.composeUrl(t, "ManifestResourceComponent", "relativePath", element.getRelativePathElement(), -1);
        }
    }

    protected void composeImplementationGuideManifestPageComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ManifestPageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "page", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ManifestPageComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ManifestPageComponent", "title", element.getTitleElement(), -1);
        }
        for (int i = 0; i < element.getAnchor().size(); ++i) {
            this.composeString(t, "ManifestPageComponent", "anchor", element.getAnchor().get(i), i);
        }
    }

    protected void composeIngredient(Turtle.Complex parent, String parentType, String name, Ingredient element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Ingredient", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Ingredient", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Ingredient", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getFor().size(); ++i) {
            this.composeReference(t, "Ingredient", "for", element.getFor().get(i), i);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "Ingredient", "role", element.getRole(), -1);
        }
        for (i = 0; i < element.getFunction().size(); ++i) {
            this.composeCodeableConcept(t, "Ingredient", "function", element.getFunction().get(i), i);
        }
        if (element.hasAllergenicIndicatorElement()) {
            this.composeBoolean(t, "Ingredient", "allergenicIndicator", element.getAllergenicIndicatorElement(), -1);
        }
        for (i = 0; i < element.getManufacturer().size(); ++i) {
            this.composeIngredientManufacturerComponent(t, "Ingredient", "manufacturer", element.getManufacturer().get(i), i);
        }
        if (element.hasSubstance()) {
            this.composeIngredientSubstanceComponent(t, "Ingredient", "substance", element.getSubstance(), -1);
        }
    }

    protected void composeIngredientManufacturerComponent(Turtle.Complex parent, String parentType, String name, Ingredient.IngredientManufacturerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "manufacturer", name, element, index);
        if (element.hasRole()) {
            this.composeCoding(t, "IngredientManufacturerComponent", "role", element.getRole(), -1);
        }
        if (element.hasManufacturer()) {
            this.composeReference(t, "IngredientManufacturerComponent", "manufacturer", element.getManufacturer(), -1);
        }
    }

    protected void composeIngredientSubstanceComponent(Turtle.Complex parent, String parentType, String name, Ingredient.IngredientSubstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "substance", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableReference(t, "IngredientSubstanceComponent", "code", element.getCode(), -1);
        }
        for (int i = 0; i < element.getStrength().size(); ++i) {
            this.composeIngredientSubstanceStrengthComponent(t, "IngredientSubstanceComponent", "strength", element.getStrength().get(i), i);
        }
    }

    protected void composeIngredientSubstanceStrengthComponent(Turtle.Complex parent, String parentType, String name, Ingredient.IngredientSubstanceStrengthComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "strength", name, element, index);
        if (element.hasPresentation()) {
            this.composeType(t, "IngredientSubstanceStrengthComponent", "presentation", element.getPresentation(), -1);
        }
        if (element.hasPresentationTextElement()) {
            this.composeString(t, "IngredientSubstanceStrengthComponent", "presentationText", element.getPresentationTextElement(), -1);
        }
        if (element.hasConcentration()) {
            this.composeType(t, "IngredientSubstanceStrengthComponent", "concentration", element.getConcentration(), -1);
        }
        if (element.hasConcentrationTextElement()) {
            this.composeString(t, "IngredientSubstanceStrengthComponent", "concentrationText", element.getConcentrationTextElement(), -1);
        }
        if (element.hasMeasurementPointElement()) {
            this.composeString(t, "IngredientSubstanceStrengthComponent", "measurementPoint", element.getMeasurementPointElement(), -1);
        }
        for (i = 0; i < element.getCountry().size(); ++i) {
            this.composeCodeableConcept(t, "IngredientSubstanceStrengthComponent", "country", element.getCountry().get(i), i);
        }
        for (i = 0; i < element.getReferenceStrength().size(); ++i) {
            this.composeIngredientSubstanceStrengthReferenceStrengthComponent(t, "IngredientSubstanceStrengthComponent", "referenceStrength", element.getReferenceStrength().get(i), i);
        }
    }

    protected void composeIngredientSubstanceStrengthReferenceStrengthComponent(Turtle.Complex parent, String parentType, String name, Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "referenceStrength", name, element, index);
        if (element.hasSubstance()) {
            this.composeCodeableReference(t, "IngredientSubstanceStrengthReferenceStrengthComponent", "substance", element.getSubstance(), -1);
        }
        if (element.hasStrength()) {
            this.composeType(t, "IngredientSubstanceStrengthReferenceStrengthComponent", "strength", element.getStrength(), -1);
        }
        if (element.hasMeasurementPointElement()) {
            this.composeString(t, "IngredientSubstanceStrengthReferenceStrengthComponent", "measurementPoint", element.getMeasurementPointElement(), -1);
        }
        for (int i = 0; i < element.getCountry().size(); ++i) {
            this.composeCodeableConcept(t, "IngredientSubstanceStrengthReferenceStrengthComponent", "country", element.getCountry().get(i), i);
        }
    }

    protected void composeInsurancePlan(Turtle.Complex parent, String parentType, String name, InsurancePlan element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "InsurancePlan", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "InsurancePlan", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "InsurancePlan", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "InsurancePlan", "type", element.getType().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "InsurancePlan", "name", element.getNameElement(), -1);
        }
        for (i = 0; i < element.getAlias().size(); ++i) {
            this.composeString(t, "InsurancePlan", "alias", element.getAlias().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "InsurancePlan", "period", element.getPeriod(), -1);
        }
        if (element.hasOwnedBy()) {
            this.composeReference(t, "InsurancePlan", "ownedBy", element.getOwnedBy(), -1);
        }
        if (element.hasAdministeredBy()) {
            this.composeReference(t, "InsurancePlan", "administeredBy", element.getAdministeredBy(), -1);
        }
        for (i = 0; i < element.getCoverageArea().size(); ++i) {
            this.composeReference(t, "InsurancePlan", "coverageArea", element.getCoverageArea().get(i), i);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeInsurancePlanContactComponent(t, "InsurancePlan", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "InsurancePlan", "endpoint", element.getEndpoint().get(i), i);
        }
        for (i = 0; i < element.getNetwork().size(); ++i) {
            this.composeReference(t, "InsurancePlan", "network", element.getNetwork().get(i), i);
        }
        for (i = 0; i < element.getCoverage().size(); ++i) {
            this.composeInsurancePlanCoverageComponent(t, "InsurancePlan", "coverage", element.getCoverage().get(i), i);
        }
        for (i = 0; i < element.getPlan().size(); ++i) {
            this.composeInsurancePlanPlanComponent(t, "InsurancePlan", "plan", element.getPlan().get(i), i);
        }
    }

    protected void composeInsurancePlanContactComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.InsurancePlanContactComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasPurpose()) {
            this.composeCodeableConcept(t, "InsurancePlanContactComponent", "purpose", element.getPurpose(), -1);
        }
        if (element.hasName()) {
            this.composeHumanName(t, "InsurancePlanContactComponent", "name", element.getName(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "InsurancePlanContactComponent", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "InsurancePlanContactComponent", "address", element.getAddress(), -1);
        }
    }

    protected void composeInsurancePlanCoverageComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.InsurancePlanCoverageComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "coverage", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "InsurancePlanCoverageComponent", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getNetwork().size(); ++i) {
            this.composeReference(t, "InsurancePlanCoverageComponent", "network", element.getNetwork().get(i), i);
        }
        for (i = 0; i < element.getBenefit().size(); ++i) {
            this.composeInsurancePlanCoverageBenefitComponent(t, "InsurancePlanCoverageComponent", "benefit", element.getBenefit().get(i), i);
        }
    }

    protected void composeInsurancePlanCoverageBenefitComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.CoverageBenefitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "benefit", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CoverageBenefitComponent", "type", element.getType(), -1);
        }
        if (element.hasRequirementElement()) {
            this.composeString(t, "CoverageBenefitComponent", "requirement", element.getRequirementElement(), -1);
        }
        for (int i = 0; i < element.getLimit().size(); ++i) {
            this.composeInsurancePlanCoverageBenefitLimitComponent(t, "CoverageBenefitComponent", "limit", element.getLimit().get(i), i);
        }
    }

    protected void composeInsurancePlanCoverageBenefitLimitComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.CoverageBenefitLimitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "limit", name, element, index);
        if (element.hasValue()) {
            this.composeQuantity(t, "CoverageBenefitLimitComponent", "value", element.getValue(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "CoverageBenefitLimitComponent", "code", element.getCode(), -1);
        }
    }

    protected void composeInsurancePlanPlanComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.InsurancePlanPlanComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "plan", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "InsurancePlanPlanComponent", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "InsurancePlanPlanComponent", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getCoverageArea().size(); ++i) {
            this.composeReference(t, "InsurancePlanPlanComponent", "coverageArea", element.getCoverageArea().get(i), i);
        }
        for (i = 0; i < element.getNetwork().size(); ++i) {
            this.composeReference(t, "InsurancePlanPlanComponent", "network", element.getNetwork().get(i), i);
        }
        for (i = 0; i < element.getGeneralCost().size(); ++i) {
            this.composeInsurancePlanPlanGeneralCostComponent(t, "InsurancePlanPlanComponent", "generalCost", element.getGeneralCost().get(i), i);
        }
        for (i = 0; i < element.getSpecificCost().size(); ++i) {
            this.composeInsurancePlanPlanSpecificCostComponent(t, "InsurancePlanPlanComponent", "specificCost", element.getSpecificCost().get(i), i);
        }
    }

    protected void composeInsurancePlanPlanGeneralCostComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.InsurancePlanPlanGeneralCostComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "generalCost", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "InsurancePlanPlanGeneralCostComponent", "type", element.getType(), -1);
        }
        if (element.hasGroupSizeElement()) {
            this.composePositiveInt(t, "InsurancePlanPlanGeneralCostComponent", "groupSize", element.getGroupSizeElement(), -1);
        }
        if (element.hasCost()) {
            this.composeMoney(t, "InsurancePlanPlanGeneralCostComponent", "cost", element.getCost(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "InsurancePlanPlanGeneralCostComponent", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeInsurancePlanPlanSpecificCostComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.InsurancePlanPlanSpecificCostComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "specificCost", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "InsurancePlanPlanSpecificCostComponent", "category", element.getCategory(), -1);
        }
        for (int i = 0; i < element.getBenefit().size(); ++i) {
            this.composeInsurancePlanPlanBenefitComponent(t, "InsurancePlanPlanSpecificCostComponent", "benefit", element.getBenefit().get(i), i);
        }
    }

    protected void composeInsurancePlanPlanBenefitComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.PlanBenefitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "benefit", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PlanBenefitComponent", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getCost().size(); ++i) {
            this.composeInsurancePlanPlanBenefitCostComponent(t, "PlanBenefitComponent", "cost", element.getCost().get(i), i);
        }
    }

    protected void composeInsurancePlanPlanBenefitCostComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.PlanBenefitCostComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "cost", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PlanBenefitCostComponent", "type", element.getType(), -1);
        }
        if (element.hasApplicability()) {
            this.composeCodeableConcept(t, "PlanBenefitCostComponent", "applicability", element.getApplicability(), -1);
        }
        for (int i = 0; i < element.getQualifiers().size(); ++i) {
            this.composeCodeableConcept(t, "PlanBenefitCostComponent", "qualifiers", element.getQualifiers().get(i), i);
        }
        if (element.hasValue()) {
            this.composeQuantity(t, "PlanBenefitCostComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeInvoice(Turtle.Complex parent, String parentType, String name, Invoice element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Invoice", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Invoice", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Invoice", "status", element.getStatusElement(), -1);
        }
        if (element.hasCancelledReasonElement()) {
            this.composeString(t, "Invoice", "cancelledReason", element.getCancelledReasonElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Invoice", "type", element.getType(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Invoice", "subject", element.getSubject(), -1);
        }
        if (element.hasRecipient()) {
            this.composeReference(t, "Invoice", "recipient", element.getRecipient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Invoice", "date", element.getDateElement(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeInvoiceParticipantComponent(t, "Invoice", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasIssuer()) {
            this.composeReference(t, "Invoice", "issuer", element.getIssuer(), -1);
        }
        if (element.hasAccount()) {
            this.composeReference(t, "Invoice", "account", element.getAccount(), -1);
        }
        for (i = 0; i < element.getLineItem().size(); ++i) {
            this.composeInvoiceLineItemComponent(t, "Invoice", "lineItem", element.getLineItem().get(i), i);
        }
        for (i = 0; i < element.getTotalPriceComponent().size(); ++i) {
            this.composeInvoiceLineItemPriceComponentComponent(t, "Invoice", "totalPriceComponent", element.getTotalPriceComponent().get(i), i);
        }
        if (element.hasTotalNet()) {
            this.composeMoney(t, "Invoice", "totalNet", element.getTotalNet(), -1);
        }
        if (element.hasTotalGross()) {
            this.composeMoney(t, "Invoice", "totalGross", element.getTotalGross(), -1);
        }
        if (element.hasPaymentTermsElement()) {
            this.composeMarkdown(t, "Invoice", "paymentTerms", element.getPaymentTermsElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Invoice", "note", element.getNote().get(i), i);
        }
    }

    protected void composeInvoiceParticipantComponent(Turtle.Complex parent, String parentType, String name, Invoice.InvoiceParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "InvoiceParticipantComponent", "role", element.getRole(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "InvoiceParticipantComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeInvoiceLineItemComponent(Turtle.Complex parent, String parentType, String name, Invoice.InvoiceLineItemComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "lineItem", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "InvoiceLineItemComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasChargeItem()) {
            this.composeType(t, "InvoiceLineItemComponent", "chargeItem", element.getChargeItem(), -1);
        }
        for (int i = 0; i < element.getPriceComponent().size(); ++i) {
            this.composeInvoiceLineItemPriceComponentComponent(t, "InvoiceLineItemComponent", "priceComponent", element.getPriceComponent().get(i), i);
        }
    }

    protected void composeInvoiceLineItemPriceComponentComponent(Turtle.Complex parent, String parentType, String name, Invoice.InvoiceLineItemPriceComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "priceComponent", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "InvoiceLineItemPriceComponentComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "InvoiceLineItemPriceComponentComponent", "code", element.getCode(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "InvoiceLineItemPriceComponentComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "InvoiceLineItemPriceComponentComponent", "amount", element.getAmount(), -1);
        }
    }

    protected void composeLibrary(Turtle.Complex parent, String parentType, String name, Library element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Library", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Library", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Library", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Library", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Library", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Library", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "Library", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Library", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "Library", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Library", "type", element.getType(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "Library", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Library", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Library", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "Library", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Library", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "Library", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "Library", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "Library", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "Library", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "Library", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "Library", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "Library", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "Library", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "Library", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "Library", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "Library", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "Library", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "Library", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "Library", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeParameterDefinition(t, "Library", "parameter", element.getParameter().get(i), i);
        }
        for (i = 0; i < element.getDataRequirement().size(); ++i) {
            this.composeDataRequirement(t, "Library", "dataRequirement", element.getDataRequirement().get(i), i);
        }
        for (i = 0; i < element.getContent().size(); ++i) {
            this.composeAttachment(t, "Library", "content", element.getContent().get(i), i);
        }
    }

    protected void composeLinkage(Turtle.Complex parent, String parentType, String name, Linkage element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Linkage", name, element, index);
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Linkage", "active", element.getActiveElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Linkage", "author", element.getAuthor(), -1);
        }
        for (int i = 0; i < element.getItem().size(); ++i) {
            this.composeLinkageItemComponent(t, "Linkage", "item", element.getItem().get(i), i);
        }
    }

    protected void composeLinkageItemComponent(Turtle.Complex parent, String parentType, String name, Linkage.LinkageItemComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "LinkageItemComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasResource()) {
            this.composeReference(t, "LinkageItemComponent", "resource", element.getResource(), -1);
        }
    }

    protected void composeListResource(Turtle.Complex parent, String parentType, String name, ListResource element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "List", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ListResource", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ListResource", "status", element.getStatusElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "ListResource", "mode", element.getModeElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ListResource", "title", element.getTitleElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ListResource", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ListResource", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "ListResource", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ListResource", "date", element.getDateElement(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "ListResource", "source", element.getSource(), -1);
        }
        if (element.hasOrderedBy()) {
            this.composeCodeableConcept(t, "ListResource", "orderedBy", element.getOrderedBy(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ListResource", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getEntry().size(); ++i) {
            this.composeListResourceEntryComponent(t, "ListResource", "entry", element.getEntry().get(i), i);
        }
        if (element.hasEmptyReason()) {
            this.composeCodeableConcept(t, "ListResource", "emptyReason", element.getEmptyReason(), -1);
        }
    }

    protected void composeListResourceEntryComponent(Turtle.Complex parent, String parentType, String name, ListResource.ListResourceEntryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entry", name, element, index);
        if (element.hasFlag()) {
            this.composeCodeableConcept(t, "ListResourceEntryComponent", "flag", element.getFlag(), -1);
        }
        if (element.hasDeletedElement()) {
            this.composeBoolean(t, "ListResourceEntryComponent", "deleted", element.getDeletedElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ListResourceEntryComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasItem()) {
            this.composeReference(t, "ListResourceEntryComponent", "item", element.getItem(), -1);
        }
    }

    protected void composeLocation(Turtle.Complex parent, String parentType, String name, Location element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Location", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Location", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Location", "status", element.getStatusElement(), -1);
        }
        if (element.hasOperationalStatus()) {
            this.composeCoding(t, "Location", "operationalStatus", element.getOperationalStatus(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Location", "name", element.getNameElement(), -1);
        }
        for (i = 0; i < element.getAlias().size(); ++i) {
            this.composeString(t, "Location", "alias", element.getAlias().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Location", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "Location", "mode", element.getModeElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Location", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Location", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "Location", "address", element.getAddress(), -1);
        }
        if (element.hasPhysicalType()) {
            this.composeCodeableConcept(t, "Location", "physicalType", element.getPhysicalType(), -1);
        }
        if (element.hasPosition()) {
            this.composeLocationPositionComponent(t, "Location", "position", element.getPosition(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Location", "managingOrganization", element.getManagingOrganization(), -1);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Location", "partOf", element.getPartOf(), -1);
        }
        for (i = 0; i < element.getHoursOfOperation().size(); ++i) {
            this.composeLocationHoursOfOperationComponent(t, "Location", "hoursOfOperation", element.getHoursOfOperation().get(i), i);
        }
        if (element.hasAvailabilityExceptionsElement()) {
            this.composeString(t, "Location", "availabilityExceptions", element.getAvailabilityExceptionsElement(), -1);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "Location", "endpoint", element.getEndpoint().get(i), i);
        }
    }

    protected void composeLocationPositionComponent(Turtle.Complex parent, String parentType, String name, Location.LocationPositionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "position", name, element, index);
        if (element.hasLongitudeElement()) {
            this.composeDecimal(t, "LocationPositionComponent", "longitude", element.getLongitudeElement(), -1);
        }
        if (element.hasLatitudeElement()) {
            this.composeDecimal(t, "LocationPositionComponent", "latitude", element.getLatitudeElement(), -1);
        }
        if (element.hasAltitudeElement()) {
            this.composeDecimal(t, "LocationPositionComponent", "altitude", element.getAltitudeElement(), -1);
        }
    }

    protected void composeLocationHoursOfOperationComponent(Turtle.Complex parent, String parentType, String name, Location.LocationHoursOfOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "hoursOfOperation", name, element, index);
        for (int i = 0; i < element.getDaysOfWeek().size(); ++i) {
            this.composeEnum(t, "LocationHoursOfOperationComponent", "daysOfWeek", element.getDaysOfWeek().get(i), i);
        }
        if (element.hasAllDayElement()) {
            this.composeBoolean(t, "LocationHoursOfOperationComponent", "allDay", element.getAllDayElement(), -1);
        }
        if (element.hasOpeningTimeElement()) {
            this.composeTime(t, "LocationHoursOfOperationComponent", "openingTime", element.getOpeningTimeElement(), -1);
        }
        if (element.hasClosingTimeElement()) {
            this.composeTime(t, "LocationHoursOfOperationComponent", "closingTime", element.getClosingTimeElement(), -1);
        }
    }

    protected void composeManufacturedItemDefinition(Turtle.Complex parent, String parentType, String name, ManufacturedItemDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ManufacturedItemDefinition", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ManufacturedItemDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ManufacturedItemDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasManufacturedDoseForm()) {
            this.composeCodeableConcept(t, "ManufacturedItemDefinition", "manufacturedDoseForm", element.getManufacturedDoseForm(), -1);
        }
        if (element.hasUnitOfPresentation()) {
            this.composeCodeableConcept(t, "ManufacturedItemDefinition", "unitOfPresentation", element.getUnitOfPresentation(), -1);
        }
        for (i = 0; i < element.getManufacturer().size(); ++i) {
            this.composeReference(t, "ManufacturedItemDefinition", "manufacturer", element.getManufacturer().get(i), i);
        }
        for (i = 0; i < element.getIngredient().size(); ++i) {
            this.composeCodeableConcept(t, "ManufacturedItemDefinition", "ingredient", element.getIngredient().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeManufacturedItemDefinitionPropertyComponent(t, "ManufacturedItemDefinition", "property", element.getProperty().get(i), i);
        }
    }

    protected void composeManufacturedItemDefinitionPropertyComponent(Turtle.Complex parent, String parentType, String name, ManufacturedItemDefinition.ManufacturedItemDefinitionPropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ManufacturedItemDefinitionPropertyComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ManufacturedItemDefinitionPropertyComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeMeasure(Turtle.Complex parent, String parentType, String name, Measure element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Measure", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Measure", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Measure", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Measure", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Measure", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Measure", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "Measure", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Measure", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "Measure", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "Measure", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Measure", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Measure", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "Measure", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Measure", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "Measure", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "Measure", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "Measure", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "Measure", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "Measure", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "Measure", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "Measure", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "Measure", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "Measure", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "Measure", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "Measure", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "Measure", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "Measure", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "Measure", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeCanonical(t, "Measure", "library", element.getLibrary().get(i), i);
        }
        if (element.hasDisclaimerElement()) {
            this.composeMarkdown(t, "Measure", "disclaimer", element.getDisclaimerElement(), -1);
        }
        if (element.hasScoring()) {
            this.composeCodeableConcept(t, "Measure", "scoring", element.getScoring(), -1);
        }
        if (element.hasCompositeScoring()) {
            this.composeCodeableConcept(t, "Measure", "compositeScoring", element.getCompositeScoring(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Measure", "type", element.getType().get(i), i);
        }
        if (element.hasRiskAdjustmentElement()) {
            this.composeString(t, "Measure", "riskAdjustment", element.getRiskAdjustmentElement(), -1);
        }
        if (element.hasRateAggregationElement()) {
            this.composeString(t, "Measure", "rateAggregation", element.getRateAggregationElement(), -1);
        }
        if (element.hasRationaleElement()) {
            this.composeMarkdown(t, "Measure", "rationale", element.getRationaleElement(), -1);
        }
        if (element.hasClinicalRecommendationStatementElement()) {
            this.composeMarkdown(t, "Measure", "clinicalRecommendationStatement", element.getClinicalRecommendationStatementElement(), -1);
        }
        if (element.hasImprovementNotation()) {
            this.composeCodeableConcept(t, "Measure", "improvementNotation", element.getImprovementNotation(), -1);
        }
        for (i = 0; i < element.getDefinition().size(); ++i) {
            this.composeMarkdown(t, "Measure", "definition", element.getDefinition().get(i), i);
        }
        if (element.hasGuidanceElement()) {
            this.composeMarkdown(t, "Measure", "guidance", element.getGuidanceElement(), -1);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeMeasureGroupComponent(t, "Measure", "group", element.getGroup().get(i), i);
        }
        for (i = 0; i < element.getSupplementalData().size(); ++i) {
            this.composeMeasureSupplementalDataComponent(t, "Measure", "supplementalData", element.getSupplementalData().get(i), i);
        }
    }

    protected void composeMeasureGroupComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureGroupComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureGroupComponent", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "MeasureGroupComponent", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getPopulation().size(); ++i) {
            this.composeMeasureGroupPopulationComponent(t, "MeasureGroupComponent", "population", element.getPopulation().get(i), i);
        }
        for (i = 0; i < element.getStratifier().size(); ++i) {
            this.composeMeasureGroupStratifierComponent(t, "MeasureGroupComponent", "stratifier", element.getStratifier().get(i), i);
        }
    }

    protected void composeMeasureGroupPopulationComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureGroupPopulationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "population", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureGroupPopulationComponent", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "MeasureGroupPopulationComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCriteria()) {
            this.composeExpression(t, "MeasureGroupPopulationComponent", "criteria", element.getCriteria(), -1);
        }
    }

    protected void composeMeasureGroupStratifierComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureGroupStratifierComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "stratifier", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureGroupStratifierComponent", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "MeasureGroupStratifierComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCriteria()) {
            this.composeExpression(t, "MeasureGroupStratifierComponent", "criteria", element.getCriteria(), -1);
        }
        for (int i = 0; i < element.getComponent().size(); ++i) {
            this.composeMeasureGroupStratifierComponentComponent(t, "MeasureGroupStratifierComponent", "component", element.getComponent().get(i), i);
        }
    }

    protected void composeMeasureGroupStratifierComponentComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureGroupStratifierComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureGroupStratifierComponentComponent", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "MeasureGroupStratifierComponentComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCriteria()) {
            this.composeExpression(t, "MeasureGroupStratifierComponentComponent", "criteria", element.getCriteria(), -1);
        }
    }

    protected void composeMeasureSupplementalDataComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureSupplementalDataComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supplementalData", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureSupplementalDataComponent", "code", element.getCode(), -1);
        }
        for (int i = 0; i < element.getUsage().size(); ++i) {
            this.composeCodeableConcept(t, "MeasureSupplementalDataComponent", "usage", element.getUsage().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "MeasureSupplementalDataComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCriteria()) {
            this.composeExpression(t, "MeasureSupplementalDataComponent", "criteria", element.getCriteria(), -1);
        }
    }

    protected void composeMeasureReport(Turtle.Complex parent, String parentType, String name, MeasureReport element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MeasureReport", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MeasureReport", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MeasureReport", "status", element.getStatusElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "MeasureReport", "type", element.getTypeElement(), -1);
        }
        if (element.hasMeasureElement()) {
            this.composeCanonical(t, "MeasureReport", "measure", element.getMeasureElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MeasureReport", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "MeasureReport", "date", element.getDateElement(), -1);
        }
        if (element.hasReporter()) {
            this.composeReference(t, "MeasureReport", "reporter", element.getReporter(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "MeasureReport", "period", element.getPeriod(), -1);
        }
        if (element.hasImprovementNotation()) {
            this.composeCodeableConcept(t, "MeasureReport", "improvementNotation", element.getImprovementNotation(), -1);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeMeasureReportGroupComponent(t, "MeasureReport", "group", element.getGroup().get(i), i);
        }
        for (i = 0; i < element.getEvaluatedResource().size(); ++i) {
            this.composeReference(t, "MeasureReport", "evaluatedResource", element.getEvaluatedResource().get(i), i);
        }
    }

    protected void composeMeasureReportGroupComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureReportGroupComponent", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getPopulation().size(); ++i) {
            this.composeMeasureReportGroupPopulationComponent(t, "MeasureReportGroupComponent", "population", element.getPopulation().get(i), i);
        }
        if (element.hasMeasureScore()) {
            this.composeQuantity(t, "MeasureReportGroupComponent", "measureScore", element.getMeasureScore(), -1);
        }
        for (i = 0; i < element.getStratifier().size(); ++i) {
            this.composeMeasureReportGroupStratifierComponent(t, "MeasureReportGroupComponent", "stratifier", element.getStratifier().get(i), i);
        }
    }

    protected void composeMeasureReportGroupPopulationComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupPopulationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "population", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureReportGroupPopulationComponent", "code", element.getCode(), -1);
        }
        if (element.hasCountElement()) {
            this.composeInteger(t, "MeasureReportGroupPopulationComponent", "count", element.getCountElement(), -1);
        }
        if (element.hasSubjectResults()) {
            this.composeReference(t, "MeasureReportGroupPopulationComponent", "subjectResults", element.getSubjectResults(), -1);
        }
    }

    protected void composeMeasureReportGroupStratifierComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupStratifierComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "stratifier", name, element, index);
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "MeasureReportGroupStratifierComponent", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getStratum().size(); ++i) {
            this.composeMeasureReportStratifierGroupComponent(t, "MeasureReportGroupStratifierComponent", "stratum", element.getStratum().get(i), i);
        }
    }

    protected void composeMeasureReportStratifierGroupComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.StratifierGroupComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "stratum", name, element, index);
        if (element.hasValue()) {
            this.composeCodeableConcept(t, "StratifierGroupComponent", "value", element.getValue(), -1);
        }
        for (i = 0; i < element.getComponent().size(); ++i) {
            this.composeMeasureReportStratifierGroupComponentComponent(t, "StratifierGroupComponent", "component", element.getComponent().get(i), i);
        }
        for (i = 0; i < element.getPopulation().size(); ++i) {
            this.composeMeasureReportStratifierGroupPopulationComponent(t, "StratifierGroupComponent", "population", element.getPopulation().get(i), i);
        }
        if (element.hasMeasureScore()) {
            this.composeQuantity(t, "StratifierGroupComponent", "measureScore", element.getMeasureScore(), -1);
        }
    }

    protected void composeMeasureReportStratifierGroupComponentComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.StratifierGroupComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "StratifierGroupComponentComponent", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeCodeableConcept(t, "StratifierGroupComponentComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeMeasureReportStratifierGroupPopulationComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.StratifierGroupPopulationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "population", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "StratifierGroupPopulationComponent", "code", element.getCode(), -1);
        }
        if (element.hasCountElement()) {
            this.composeInteger(t, "StratifierGroupPopulationComponent", "count", element.getCountElement(), -1);
        }
        if (element.hasSubjectResults()) {
            this.composeReference(t, "StratifierGroupPopulationComponent", "subjectResults", element.getSubjectResults(), -1);
        }
    }

    protected void composeMedia(Turtle.Complex parent, String parentType, String name, Media element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Media", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Media", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Media", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "Media", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Media", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Media", "type", element.getType(), -1);
        }
        if (element.hasModality()) {
            this.composeCodeableConcept(t, "Media", "modality", element.getModality(), -1);
        }
        if (element.hasView()) {
            this.composeCodeableConcept(t, "Media", "view", element.getView(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Media", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Media", "encounter", element.getEncounter(), -1);
        }
        if (element.hasCreated()) {
            this.composeType(t, "Media", "created", element.getCreated(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeInstant(t, "Media", "issued", element.getIssuedElement(), -1);
        }
        if (element.hasOperator()) {
            this.composeReference(t, "Media", "operator", element.getOperator(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Media", "reasonCode", element.getReasonCode().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "Media", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasDeviceNameElement()) {
            this.composeString(t, "Media", "deviceName", element.getDeviceNameElement(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "Media", "device", element.getDevice(), -1);
        }
        if (element.hasHeightElement()) {
            this.composePositiveInt(t, "Media", "height", element.getHeightElement(), -1);
        }
        if (element.hasWidthElement()) {
            this.composePositiveInt(t, "Media", "width", element.getWidthElement(), -1);
        }
        if (element.hasFramesElement()) {
            this.composePositiveInt(t, "Media", "frames", element.getFramesElement(), -1);
        }
        if (element.hasDurationElement()) {
            this.composeDecimal(t, "Media", "duration", element.getDurationElement(), -1);
        }
        if (element.hasContent()) {
            this.composeAttachment(t, "Media", "content", element.getContent(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Media", "note", element.getNote().get(i), i);
        }
    }

    protected void composeMedication(Turtle.Complex parent, String parentType, String name, Medication element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Medication", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Medication", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Medication", "code", element.getCode(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Medication", "status", element.getStatusElement(), -1);
        }
        if (element.hasManufacturer()) {
            this.composeReference(t, "Medication", "manufacturer", element.getManufacturer(), -1);
        }
        if (element.hasForm()) {
            this.composeCodeableConcept(t, "Medication", "form", element.getForm(), -1);
        }
        if (element.hasAmount()) {
            this.composeRatio(t, "Medication", "amount", element.getAmount(), -1);
        }
        for (i = 0; i < element.getIngredient().size(); ++i) {
            this.composeMedicationIngredientComponent(t, "Medication", "ingredient", element.getIngredient().get(i), i);
        }
        if (element.hasBatch()) {
            this.composeMedicationBatchComponent(t, "Medication", "batch", element.getBatch(), -1);
        }
    }

    protected void composeMedicationIngredientComponent(Turtle.Complex parent, String parentType, String name, Medication.MedicationIngredientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "ingredient", name, element, index);
        if (element.hasItem()) {
            this.composeType(t, "MedicationIngredientComponent", "item", element.getItem(), -1);
        }
        if (element.hasIsActiveElement()) {
            this.composeBoolean(t, "MedicationIngredientComponent", "isActive", element.getIsActiveElement(), -1);
        }
        if (element.hasStrength()) {
            this.composeRatio(t, "MedicationIngredientComponent", "strength", element.getStrength(), -1);
        }
    }

    protected void composeMedicationBatchComponent(Turtle.Complex parent, String parentType, String name, Medication.MedicationBatchComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "batch", name, element, index);
        if (element.hasLotNumberElement()) {
            this.composeString(t, "MedicationBatchComponent", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasExpirationDateElement()) {
            this.composeDateTime(t, "MedicationBatchComponent", "expirationDate", element.getExpirationDateElement(), -1);
        }
    }

    protected void composeMedicationAdministration(Turtle.Complex parent, String parentType, String name, MedicationAdministration element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationAdministration", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicationAdministration", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiates().size(); ++i) {
            this.composeUri(t, "MedicationAdministration", "instantiates", element.getInstantiates().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "MedicationAdministration", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationAdministration", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getStatusReason().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationAdministration", "statusReason", element.getStatusReason().get(i), i);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "MedicationAdministration", "category", element.getCategory(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicationAdministration", "medication", element.getMedication(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicationAdministration", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "MedicationAdministration", "context", element.getContext(), -1);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "MedicationAdministration", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
        if (element.hasEffective()) {
            this.composeType(t, "MedicationAdministration", "effective", element.getEffective(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeMedicationAdministrationPerformerComponent(t, "MedicationAdministration", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationAdministration", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "MedicationAdministration", "reasonReference", element.getReasonReference().get(i), i);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "MedicationAdministration", "request", element.getRequest(), -1);
        }
        for (i = 0; i < element.getDevice().size(); ++i) {
            this.composeReference(t, "MedicationAdministration", "device", element.getDevice().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "MedicationAdministration", "note", element.getNote().get(i), i);
        }
        if (element.hasDosage()) {
            this.composeMedicationAdministrationDosageComponent(t, "MedicationAdministration", "dosage", element.getDosage(), -1);
        }
        for (i = 0; i < element.getEventHistory().size(); ++i) {
            this.composeReference(t, "MedicationAdministration", "eventHistory", element.getEventHistory().get(i), i);
        }
    }

    protected void composeMedicationAdministrationPerformerComponent(Turtle.Complex parent, String parentType, String name, MedicationAdministration.MedicationAdministrationPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "MedicationAdministrationPerformerComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "MedicationAdministrationPerformerComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeMedicationAdministrationDosageComponent(Turtle.Complex parent, String parentType, String name, MedicationAdministration.MedicationAdministrationDosageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dosage", name, element, index);
        if (element.hasTextElement()) {
            this.composeString(t, "MedicationAdministrationDosageComponent", "text", element.getTextElement(), -1);
        }
        if (element.hasSite()) {
            this.composeCodeableConcept(t, "MedicationAdministrationDosageComponent", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "MedicationAdministrationDosageComponent", "route", element.getRoute(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "MedicationAdministrationDosageComponent", "method", element.getMethod(), -1);
        }
        if (element.hasDose()) {
            this.composeQuantity(t, "MedicationAdministrationDosageComponent", "dose", element.getDose(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "MedicationAdministrationDosageComponent", "rate", element.getRate(), -1);
        }
    }

    protected void composeMedicationDispense(Turtle.Complex parent, String parentType, String name, MedicationDispense element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationDispense", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicationDispense", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationDispense", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeType(t, "MedicationDispense", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "MedicationDispense", "category", element.getCategory(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicationDispense", "medication", element.getMedication(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicationDispense", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "MedicationDispense", "context", element.getContext(), -1);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeMedicationDispensePerformerComponent(t, "MedicationDispense", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "MedicationDispense", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getAuthorizingPrescription().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "authorizingPrescription", element.getAuthorizingPrescription().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationDispense", "type", element.getType(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationDispense", "quantity", element.getQuantity(), -1);
        }
        if (element.hasDaysSupply()) {
            this.composeQuantity(t, "MedicationDispense", "daysSupply", element.getDaysSupply(), -1);
        }
        if (element.hasWhenPreparedElement()) {
            this.composeDateTime(t, "MedicationDispense", "whenPrepared", element.getWhenPreparedElement(), -1);
        }
        if (element.hasWhenHandedOverElement()) {
            this.composeDateTime(t, "MedicationDispense", "whenHandedOver", element.getWhenHandedOverElement(), -1);
        }
        if (element.hasDestination()) {
            this.composeReference(t, "MedicationDispense", "destination", element.getDestination(), -1);
        }
        for (i = 0; i < element.getReceiver().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "receiver", element.getReceiver().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "MedicationDispense", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getDosageInstruction().size(); ++i) {
            this.composeDosage(t, "MedicationDispense", "dosageInstruction", element.getDosageInstruction().get(i), i);
        }
        if (element.hasSubstitution()) {
            this.composeMedicationDispenseSubstitutionComponent(t, "MedicationDispense", "substitution", element.getSubstitution(), -1);
        }
        for (i = 0; i < element.getDetectedIssue().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "detectedIssue", element.getDetectedIssue().get(i), i);
        }
        for (i = 0; i < element.getEventHistory().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "eventHistory", element.getEventHistory().get(i), i);
        }
    }

    protected void composeMedicationDispensePerformerComponent(Turtle.Complex parent, String parentType, String name, MedicationDispense.MedicationDispensePerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "MedicationDispensePerformerComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "MedicationDispensePerformerComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeMedicationDispenseSubstitutionComponent(Turtle.Complex parent, String parentType, String name, MedicationDispense.MedicationDispenseSubstitutionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "substitution", name, element, index);
        if (element.hasWasSubstitutedElement()) {
            this.composeBoolean(t, "MedicationDispenseSubstitutionComponent", "wasSubstituted", element.getWasSubstitutedElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationDispenseSubstitutionComponent", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationDispenseSubstitutionComponent", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getResponsibleParty().size(); ++i) {
            this.composeReference(t, "MedicationDispenseSubstitutionComponent", "responsibleParty", element.getResponsibleParty().get(i), i);
        }
    }

    protected void composeMedicationKnowledge(Turtle.Complex parent, String parentType, String name, MedicationKnowledge element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationKnowledge", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "code", element.getCode(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationKnowledge", "status", element.getStatusElement(), -1);
        }
        if (element.hasManufacturer()) {
            this.composeReference(t, "MedicationKnowledge", "manufacturer", element.getManufacturer(), -1);
        }
        if (element.hasDoseForm()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "doseForm", element.getDoseForm(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "MedicationKnowledge", "amount", element.getAmount(), -1);
        }
        for (i = 0; i < element.getSynonym().size(); ++i) {
            this.composeString(t, "MedicationKnowledge", "synonym", element.getSynonym().get(i), i);
        }
        for (i = 0; i < element.getRelatedMedicationKnowledge().size(); ++i) {
            this.composeMedicationKnowledgeRelatedMedicationKnowledgeComponent(t, "MedicationKnowledge", "relatedMedicationKnowledge", element.getRelatedMedicationKnowledge().get(i), i);
        }
        for (i = 0; i < element.getAssociatedMedication().size(); ++i) {
            this.composeReference(t, "MedicationKnowledge", "associatedMedication", element.getAssociatedMedication().get(i), i);
        }
        for (i = 0; i < element.getProductType().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "productType", element.getProductType().get(i), i);
        }
        for (i = 0; i < element.getMonograph().size(); ++i) {
            this.composeMedicationKnowledgeMonographComponent(t, "MedicationKnowledge", "monograph", element.getMonograph().get(i), i);
        }
        for (i = 0; i < element.getIngredient().size(); ++i) {
            this.composeMedicationKnowledgeIngredientComponent(t, "MedicationKnowledge", "ingredient", element.getIngredient().get(i), i);
        }
        if (element.hasPreparationInstructionElement()) {
            this.composeMarkdown(t, "MedicationKnowledge", "preparationInstruction", element.getPreparationInstructionElement(), -1);
        }
        for (i = 0; i < element.getIntendedRoute().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "intendedRoute", element.getIntendedRoute().get(i), i);
        }
        for (i = 0; i < element.getCost().size(); ++i) {
            this.composeMedicationKnowledgeCostComponent(t, "MedicationKnowledge", "cost", element.getCost().get(i), i);
        }
        for (i = 0; i < element.getMonitoringProgram().size(); ++i) {
            this.composeMedicationKnowledgeMonitoringProgramComponent(t, "MedicationKnowledge", "monitoringProgram", element.getMonitoringProgram().get(i), i);
        }
        for (i = 0; i < element.getAdministrationGuidelines().size(); ++i) {
            this.composeMedicationKnowledgeAdministrationGuidelinesComponent(t, "MedicationKnowledge", "administrationGuidelines", element.getAdministrationGuidelines().get(i), i);
        }
        for (i = 0; i < element.getMedicineClassification().size(); ++i) {
            this.composeMedicationKnowledgeMedicineClassificationComponent(t, "MedicationKnowledge", "medicineClassification", element.getMedicineClassification().get(i), i);
        }
        if (element.hasPackaging()) {
            this.composeMedicationKnowledgePackagingComponent(t, "MedicationKnowledge", "packaging", element.getPackaging(), -1);
        }
        for (i = 0; i < element.getDrugCharacteristic().size(); ++i) {
            this.composeMedicationKnowledgeDrugCharacteristicComponent(t, "MedicationKnowledge", "drugCharacteristic", element.getDrugCharacteristic().get(i), i);
        }
        for (i = 0; i < element.getContraindication().size(); ++i) {
            this.composeReference(t, "MedicationKnowledge", "contraindication", element.getContraindication().get(i), i);
        }
        for (i = 0; i < element.getRegulatory().size(); ++i) {
            this.composeMedicationKnowledgeRegulatoryComponent(t, "MedicationKnowledge", "regulatory", element.getRegulatory().get(i), i);
        }
        for (i = 0; i < element.getKinetics().size(); ++i) {
            this.composeMedicationKnowledgeKineticsComponent(t, "MedicationKnowledge", "kinetics", element.getKinetics().get(i), i);
        }
    }

    protected void composeMedicationKnowledgeRelatedMedicationKnowledgeComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatedMedicationKnowledge", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeRelatedMedicationKnowledgeComponent", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getReference().size(); ++i) {
            this.composeReference(t, "MedicationKnowledgeRelatedMedicationKnowledgeComponent", "reference", element.getReference().get(i), i);
        }
    }

    protected void composeMedicationKnowledgeMonographComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeMonographComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "monograph", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeMonographComponent", "type", element.getType(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "MedicationKnowledgeMonographComponent", "source", element.getSource(), -1);
        }
    }

    protected void composeMedicationKnowledgeIngredientComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeIngredientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "ingredient", name, element, index);
        if (element.hasItem()) {
            this.composeType(t, "MedicationKnowledgeIngredientComponent", "item", element.getItem(), -1);
        }
        if (element.hasIsActiveElement()) {
            this.composeBoolean(t, "MedicationKnowledgeIngredientComponent", "isActive", element.getIsActiveElement(), -1);
        }
        if (element.hasStrength()) {
            this.composeRatio(t, "MedicationKnowledgeIngredientComponent", "strength", element.getStrength(), -1);
        }
    }

    protected void composeMedicationKnowledgeCostComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeCostComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "cost", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeCostComponent", "type", element.getType(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeString(t, "MedicationKnowledgeCostComponent", "source", element.getSourceElement(), -1);
        }
        if (element.hasCost()) {
            this.composeMoney(t, "MedicationKnowledgeCostComponent", "cost", element.getCost(), -1);
        }
    }

    protected void composeMedicationKnowledgeMonitoringProgramComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "monitoringProgram", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeMonitoringProgramComponent", "type", element.getType(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "MedicationKnowledgeMonitoringProgramComponent", "name", element.getNameElement(), -1);
        }
    }

    protected void composeMedicationKnowledgeAdministrationGuidelinesComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "administrationGuidelines", name, element, index);
        for (i = 0; i < element.getDosage().size(); ++i) {
            this.composeMedicationKnowledgeAdministrationGuidelinesDosageComponent(t, "MedicationKnowledgeAdministrationGuidelinesComponent", "dosage", element.getDosage().get(i), i);
        }
        if (element.hasIndication()) {
            this.composeType(t, "MedicationKnowledgeAdministrationGuidelinesComponent", "indication", element.getIndication(), -1);
        }
        for (i = 0; i < element.getPatientCharacteristics().size(); ++i) {
            this.composeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent(t, "MedicationKnowledgeAdministrationGuidelinesComponent", "patientCharacteristics", element.getPatientCharacteristics().get(i), i);
        }
    }

    protected void composeMedicationKnowledgeAdministrationGuidelinesDosageComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dosage", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeAdministrationGuidelinesDosageComponent", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getDosage().size(); ++i) {
            this.composeDosage(t, "MedicationKnowledgeAdministrationGuidelinesDosageComponent", "dosage", element.getDosage().get(i), i);
        }
    }

    protected void composeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "patientCharacteristics", name, element, index);
        if (element.hasCharacteristic()) {
            this.composeType(t, "MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent", "characteristic", element.getCharacteristic(), -1);
        }
        for (int i = 0; i < element.getValue().size(); ++i) {
            this.composeString(t, "MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent", "value", element.getValue().get(i), i);
        }
    }

    protected void composeMedicationKnowledgeMedicineClassificationComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "medicineClassification", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeMedicineClassificationComponent", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getClassification().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationKnowledgeMedicineClassificationComponent", "classification", element.getClassification().get(i), i);
        }
    }

    protected void composeMedicationKnowledgePackagingComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgePackagingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "packaging", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgePackagingComponent", "type", element.getType(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationKnowledgePackagingComponent", "quantity", element.getQuantity(), -1);
        }
    }

    protected void composeMedicationKnowledgeDrugCharacteristicComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "drugCharacteristic", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeDrugCharacteristicComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "MedicationKnowledgeDrugCharacteristicComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeMedicationKnowledgeRegulatoryComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatoryComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "regulatory", name, element, index);
        if (element.hasRegulatoryAuthority()) {
            this.composeReference(t, "MedicationKnowledgeRegulatoryComponent", "regulatoryAuthority", element.getRegulatoryAuthority(), -1);
        }
        for (i = 0; i < element.getSubstitution().size(); ++i) {
            this.composeMedicationKnowledgeRegulatorySubstitutionComponent(t, "MedicationKnowledgeRegulatoryComponent", "substitution", element.getSubstitution().get(i), i);
        }
        for (i = 0; i < element.getSchedule().size(); ++i) {
            this.composeMedicationKnowledgeRegulatoryScheduleComponent(t, "MedicationKnowledgeRegulatoryComponent", "schedule", element.getSchedule().get(i), i);
        }
        if (element.hasMaxDispense()) {
            this.composeMedicationKnowledgeRegulatoryMaxDispenseComponent(t, "MedicationKnowledgeRegulatoryComponent", "maxDispense", element.getMaxDispense(), -1);
        }
    }

    protected void composeMedicationKnowledgeRegulatorySubstitutionComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "substitution", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeRegulatorySubstitutionComponent", "type", element.getType(), -1);
        }
        if (element.hasAllowedElement()) {
            this.composeBoolean(t, "MedicationKnowledgeRegulatorySubstitutionComponent", "allowed", element.getAllowedElement(), -1);
        }
    }

    protected void composeMedicationKnowledgeRegulatoryScheduleComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "schedule", name, element, index);
        if (element.hasSchedule()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeRegulatoryScheduleComponent", "schedule", element.getSchedule(), -1);
        }
    }

    protected void composeMedicationKnowledgeRegulatoryMaxDispenseComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "maxDispense", name, element, index);
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationKnowledgeRegulatoryMaxDispenseComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasPeriod()) {
            this.composeDuration(t, "MedicationKnowledgeRegulatoryMaxDispenseComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeMedicationKnowledgeKineticsComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeKineticsComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "kinetics", name, element, index);
        for (i = 0; i < element.getAreaUnderCurve().size(); ++i) {
            this.composeQuantity(t, "MedicationKnowledgeKineticsComponent", "areaUnderCurve", element.getAreaUnderCurve().get(i), i);
        }
        for (i = 0; i < element.getLethalDose50().size(); ++i) {
            this.composeQuantity(t, "MedicationKnowledgeKineticsComponent", "lethalDose50", element.getLethalDose50().get(i), i);
        }
        if (element.hasHalfLifePeriod()) {
            this.composeDuration(t, "MedicationKnowledgeKineticsComponent", "halfLifePeriod", element.getHalfLifePeriod(), -1);
        }
    }

    protected void composeMedicationRequest(Turtle.Complex parent, String parentType, String name, MedicationRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicationRequest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "MedicationRequest", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "MedicationRequest", "intent", element.getIntentElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationRequest", "category", element.getCategory().get(i), i);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "MedicationRequest", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "MedicationRequest", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasReported()) {
            this.composeType(t, "MedicationRequest", "reported", element.getReported(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicationRequest", "medication", element.getMedication(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicationRequest", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "MedicationRequest", "encounter", element.getEncounter(), -1);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "MedicationRequest", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "MedicationRequest", "requester", element.getRequester(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "MedicationRequest", "performer", element.getPerformer(), -1);
        }
        if (element.hasPerformerType()) {
            this.composeCodeableConcept(t, "MedicationRequest", "performerType", element.getPerformerType(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "MedicationRequest", "recorder", element.getRecorder(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationRequest", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "MedicationRequest", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "MedicationRequest", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "basedOn", element.getBasedOn().get(i), i);
        }
        if (element.hasGroupIdentifier()) {
            this.composeIdentifier(t, "MedicationRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
        }
        if (element.hasCourseOfTherapyType()) {
            this.composeCodeableConcept(t, "MedicationRequest", "courseOfTherapyType", element.getCourseOfTherapyType(), -1);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "insurance", element.getInsurance().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "MedicationRequest", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getDosageInstruction().size(); ++i) {
            this.composeDosage(t, "MedicationRequest", "dosageInstruction", element.getDosageInstruction().get(i), i);
        }
        if (element.hasDispenseRequest()) {
            this.composeMedicationRequestDispenseRequestComponent(t, "MedicationRequest", "dispenseRequest", element.getDispenseRequest(), -1);
        }
        if (element.hasSubstitution()) {
            this.composeMedicationRequestSubstitutionComponent(t, "MedicationRequest", "substitution", element.getSubstitution(), -1);
        }
        if (element.hasPriorPrescription()) {
            this.composeReference(t, "MedicationRequest", "priorPrescription", element.getPriorPrescription(), -1);
        }
        for (i = 0; i < element.getDetectedIssue().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "detectedIssue", element.getDetectedIssue().get(i), i);
        }
        for (i = 0; i < element.getEventHistory().size(); ++i) {
            this.composeReference(t, "MedicationRequest", "eventHistory", element.getEventHistory().get(i), i);
        }
    }

    protected void composeMedicationRequestDispenseRequestComponent(Turtle.Complex parent, String parentType, String name, MedicationRequest.MedicationRequestDispenseRequestComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dispenseRequest", name, element, index);
        if (element.hasInitialFill()) {
            this.composeMedicationRequestDispenseRequestInitialFillComponent(t, "MedicationRequestDispenseRequestComponent", "initialFill", element.getInitialFill(), -1);
        }
        if (element.hasDispenseInterval()) {
            this.composeDuration(t, "MedicationRequestDispenseRequestComponent", "dispenseInterval", element.getDispenseInterval(), -1);
        }
        if (element.hasValidityPeriod()) {
            this.composePeriod(t, "MedicationRequestDispenseRequestComponent", "validityPeriod", element.getValidityPeriod(), -1);
        }
        if (element.hasNumberOfRepeatsAllowedElement()) {
            this.composeUnsignedInt(t, "MedicationRequestDispenseRequestComponent", "numberOfRepeatsAllowed", element.getNumberOfRepeatsAllowedElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationRequestDispenseRequestComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasExpectedSupplyDuration()) {
            this.composeDuration(t, "MedicationRequestDispenseRequestComponent", "expectedSupplyDuration", element.getExpectedSupplyDuration(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "MedicationRequestDispenseRequestComponent", "performer", element.getPerformer(), -1);
        }
    }

    protected void composeMedicationRequestDispenseRequestInitialFillComponent(Turtle.Complex parent, String parentType, String name, MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "initialFill", name, element, index);
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationRequestDispenseRequestInitialFillComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasDuration()) {
            this.composeDuration(t, "MedicationRequestDispenseRequestInitialFillComponent", "duration", element.getDuration(), -1);
        }
    }

    protected void composeMedicationRequestSubstitutionComponent(Turtle.Complex parent, String parentType, String name, MedicationRequest.MedicationRequestSubstitutionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "substitution", name, element, index);
        if (element.hasAllowed()) {
            this.composeType(t, "MedicationRequestSubstitutionComponent", "allowed", element.getAllowed(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "MedicationRequestSubstitutionComponent", "reason", element.getReason(), -1);
        }
    }

    protected void composeMedicationStatement(Turtle.Complex parent, String parentType, String name, MedicationStatement element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationStatement", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicationStatement", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "MedicationStatement", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "MedicationStatement", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationStatement", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getStatusReason().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationStatement", "statusReason", element.getStatusReason().get(i), i);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "MedicationStatement", "category", element.getCategory(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicationStatement", "medication", element.getMedication(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicationStatement", "subject", element.getSubject(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "MedicationStatement", "context", element.getContext(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "MedicationStatement", "effective", element.getEffective(), -1);
        }
        if (element.hasDateAssertedElement()) {
            this.composeDateTime(t, "MedicationStatement", "dateAsserted", element.getDateAssertedElement(), -1);
        }
        if (element.hasInformationSource()) {
            this.composeReference(t, "MedicationStatement", "informationSource", element.getInformationSource(), -1);
        }
        for (i = 0; i < element.getDerivedFrom().size(); ++i) {
            this.composeReference(t, "MedicationStatement", "derivedFrom", element.getDerivedFrom().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationStatement", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "MedicationStatement", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "MedicationStatement", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getDosage().size(); ++i) {
            this.composeDosage(t, "MedicationStatement", "dosage", element.getDosage().get(i), i);
        }
    }

    protected void composeMedicinalProductDefinition(Turtle.Complex parent, String parentType, String name, MedicinalProductDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicinalProductDefinition", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicinalProductDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "type", element.getType(), -1);
        }
        if (element.hasDomain()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "domain", element.getDomain(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "MedicinalProductDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "status", element.getStatus(), -1);
        }
        if (element.hasStatusDateElement()) {
            this.composeDateTime(t, "MedicinalProductDefinition", "statusDate", element.getStatusDateElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "MedicinalProductDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCombinedPharmaceuticalDoseForm()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "combinedPharmaceuticalDoseForm", element.getCombinedPharmaceuticalDoseForm(), -1);
        }
        for (i = 0; i < element.getRoute().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "route", element.getRoute().get(i), i);
        }
        if (element.hasIndicationElement()) {
            this.composeMarkdown(t, "MedicinalProductDefinition", "indication", element.getIndicationElement(), -1);
        }
        if (element.hasLegalStatusOfSupply()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "legalStatusOfSupply", element.getLegalStatusOfSupply(), -1);
        }
        if (element.hasAdditionalMonitoringIndicator()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "additionalMonitoringIndicator", element.getAdditionalMonitoringIndicator(), -1);
        }
        for (i = 0; i < element.getSpecialMeasures().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "specialMeasures", element.getSpecialMeasures().get(i), i);
        }
        if (element.hasPediatricUseIndicator()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "pediatricUseIndicator", element.getPediatricUseIndicator(), -1);
        }
        for (i = 0; i < element.getClassification().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "classification", element.getClassification().get(i), i);
        }
        for (i = 0; i < element.getMarketingStatus().size(); ++i) {
            this.composeMarketingStatus(t, "MedicinalProductDefinition", "marketingStatus", element.getMarketingStatus().get(i), i);
        }
        for (i = 0; i < element.getPackagedMedicinalProduct().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "packagedMedicinalProduct", element.getPackagedMedicinalProduct().get(i), i);
        }
        for (i = 0; i < element.getIngredient().size(); ++i) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "ingredient", element.getIngredient().get(i), i);
        }
        for (i = 0; i < element.getImpurity().size(); ++i) {
            this.composeCodeableReference(t, "MedicinalProductDefinition", "impurity", element.getImpurity().get(i), i);
        }
        for (i = 0; i < element.getAttachedDocument().size(); ++i) {
            this.composeReference(t, "MedicinalProductDefinition", "attachedDocument", element.getAttachedDocument().get(i), i);
        }
        for (i = 0; i < element.getMasterFile().size(); ++i) {
            this.composeReference(t, "MedicinalProductDefinition", "masterFile", element.getMasterFile().get(i), i);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeMedicinalProductDefinitionContactComponent(t, "MedicinalProductDefinition", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getClinicalTrial().size(); ++i) {
            this.composeReference(t, "MedicinalProductDefinition", "clinicalTrial", element.getClinicalTrial().get(i), i);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCoding(t, "MedicinalProductDefinition", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeMedicinalProductDefinitionNameComponent(t, "MedicinalProductDefinition", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getCrossReference().size(); ++i) {
            this.composeMedicinalProductDefinitionCrossReferenceComponent(t, "MedicinalProductDefinition", "crossReference", element.getCrossReference().get(i), i);
        }
        for (i = 0; i < element.getOperation().size(); ++i) {
            this.composeMedicinalProductDefinitionOperationComponent(t, "MedicinalProductDefinition", "operation", element.getOperation().get(i), i);
        }
        for (i = 0; i < element.getCharacteristic().size(); ++i) {
            this.composeMedicinalProductDefinitionCharacteristicComponent(t, "MedicinalProductDefinition", "characteristic", element.getCharacteristic().get(i), i);
        }
    }

    protected void composeMedicinalProductDefinitionContactComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionContactComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionContactComponent", "type", element.getType(), -1);
        }
        if (element.hasContact()) {
            this.composeReference(t, "MedicinalProductDefinitionContactComponent", "contact", element.getContact(), -1);
        }
    }

    protected void composeMedicinalProductDefinitionNameComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionNameComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "name", name, element, index);
        if (element.hasProductNameElement()) {
            this.composeString(t, "MedicinalProductDefinitionNameComponent", "productName", element.getProductNameElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionNameComponent", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getNamePart().size(); ++i) {
            this.composeMedicinalProductDefinitionNameNamePartComponent(t, "MedicinalProductDefinitionNameComponent", "namePart", element.getNamePart().get(i), i);
        }
        for (i = 0; i < element.getCountryLanguage().size(); ++i) {
            this.composeMedicinalProductDefinitionNameCountryLanguageComponent(t, "MedicinalProductDefinitionNameComponent", "countryLanguage", element.getCountryLanguage().get(i), i);
        }
    }

    protected void composeMedicinalProductDefinitionNameNamePartComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "namePart", name, element, index);
        if (element.hasPartElement()) {
            this.composeString(t, "MedicinalProductDefinitionNameNamePartComponent", "part", element.getPartElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionNameNamePartComponent", "type", element.getType(), -1);
        }
    }

    protected void composeMedicinalProductDefinitionNameCountryLanguageComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "countryLanguage", name, element, index);
        if (element.hasCountry()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionNameCountryLanguageComponent", "country", element.getCountry(), -1);
        }
        if (element.hasJurisdiction()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionNameCountryLanguageComponent", "jurisdiction", element.getJurisdiction(), -1);
        }
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionNameCountryLanguageComponent", "language", element.getLanguage(), -1);
        }
    }

    protected void composeMedicinalProductDefinitionCrossReferenceComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionCrossReferenceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "crossReference", name, element, index);
        if (element.hasProduct()) {
            this.composeCodeableReference(t, "MedicinalProductDefinitionCrossReferenceComponent", "product", element.getProduct(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionCrossReferenceComponent", "type", element.getType(), -1);
        }
    }

    protected void composeMedicinalProductDefinitionOperationComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "operation", name, element, index);
        if (element.hasType()) {
            this.composeCodeableReference(t, "MedicinalProductDefinitionOperationComponent", "type", element.getType(), -1);
        }
        if (element.hasEffectiveDate()) {
            this.composePeriod(t, "MedicinalProductDefinitionOperationComponent", "effectiveDate", element.getEffectiveDate(), -1);
        }
        for (int i = 0; i < element.getOrganization().size(); ++i) {
            this.composeReference(t, "MedicinalProductDefinitionOperationComponent", "organization", element.getOrganization().get(i), i);
        }
        if (element.hasConfidentialityIndicator()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionOperationComponent", "confidentialityIndicator", element.getConfidentialityIndicator(), -1);
        }
    }

    protected void composeMedicinalProductDefinitionCharacteristicComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "characteristic", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionCharacteristicComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "MedicinalProductDefinitionCharacteristicComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeMessageDefinition(Turtle.Complex parent, String parentType, String name, MessageDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MessageDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "MessageDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MessageDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "MessageDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "MessageDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "MessageDefinition", "title", element.getTitleElement(), -1);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeCanonical(t, "MessageDefinition", "replaces", element.getReplaces().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MessageDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "MessageDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "MessageDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "MessageDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "MessageDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "MessageDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "MessageDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "MessageDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "MessageDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "MessageDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasBaseElement()) {
            this.composeCanonical(t, "MessageDefinition", "base", element.getBaseElement(), -1);
        }
        for (i = 0; i < element.getParent().size(); ++i) {
            this.composeCanonical(t, "MessageDefinition", "parent", element.getParent().get(i), i);
        }
        if (element.hasEvent()) {
            this.composeType(t, "MessageDefinition", "event", element.getEvent(), -1);
        }
        if (element.hasCategoryElement()) {
            this.composeEnum(t, "MessageDefinition", "category", element.getCategoryElement(), -1);
        }
        for (i = 0; i < element.getFocus().size(); ++i) {
            this.composeMessageDefinitionFocusComponent(t, "MessageDefinition", "focus", element.getFocus().get(i), i);
        }
        if (element.hasResponseRequiredElement()) {
            this.composeEnum(t, "MessageDefinition", "responseRequired", element.getResponseRequiredElement(), -1);
        }
        for (i = 0; i < element.getAllowedResponse().size(); ++i) {
            this.composeMessageDefinitionAllowedResponseComponent(t, "MessageDefinition", "allowedResponse", element.getAllowedResponse().get(i), i);
        }
        for (i = 0; i < element.getGraph().size(); ++i) {
            this.composeCanonical(t, "MessageDefinition", "graph", element.getGraph().get(i), i);
        }
    }

    protected void composeMessageDefinitionFocusComponent(Turtle.Complex parent, String parentType, String name, MessageDefinition.MessageDefinitionFocusComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "focus", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "MessageDefinitionFocusComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "MessageDefinitionFocusComponent", "profile", element.getProfileElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeUnsignedInt(t, "MessageDefinitionFocusComponent", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "MessageDefinitionFocusComponent", "max", element.getMaxElement(), -1);
        }
    }

    protected void composeMessageDefinitionAllowedResponseComponent(Turtle.Complex parent, String parentType, String name, MessageDefinition.MessageDefinitionAllowedResponseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "allowedResponse", name, element, index);
        if (element.hasMessageElement()) {
            this.composeCanonical(t, "MessageDefinitionAllowedResponseComponent", "message", element.getMessageElement(), -1);
        }
        if (element.hasSituationElement()) {
            this.composeMarkdown(t, "MessageDefinitionAllowedResponseComponent", "situation", element.getSituationElement(), -1);
        }
    }

    protected void composeMessageHeader(Turtle.Complex parent, String parentType, String name, MessageHeader element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MessageHeader", name, element, index);
        if (element.hasEvent()) {
            this.composeType(t, "MessageHeader", "event", element.getEvent(), -1);
        }
        for (i = 0; i < element.getDestination().size(); ++i) {
            this.composeMessageHeaderMessageDestinationComponent(t, "MessageHeader", "destination", element.getDestination().get(i), i);
        }
        if (element.hasSender()) {
            this.composeReference(t, "MessageHeader", "sender", element.getSender(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "MessageHeader", "enterer", element.getEnterer(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "MessageHeader", "author", element.getAuthor(), -1);
        }
        if (element.hasSource()) {
            this.composeMessageHeaderMessageSourceComponent(t, "MessageHeader", "source", element.getSource(), -1);
        }
        if (element.hasResponsible()) {
            this.composeReference(t, "MessageHeader", "responsible", element.getResponsible(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "MessageHeader", "reason", element.getReason(), -1);
        }
        if (element.hasResponse()) {
            this.composeMessageHeaderResponseComponent(t, "MessageHeader", "response", element.getResponse(), -1);
        }
        for (i = 0; i < element.getFocus().size(); ++i) {
            this.composeReference(t, "MessageHeader", "focus", element.getFocus().get(i), i);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "MessageHeader", "definition", element.getDefinitionElement(), -1);
        }
    }

    protected void composeMessageHeaderMessageDestinationComponent(Turtle.Complex parent, String parentType, String name, MessageHeader.MessageDestinationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "destination", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "MessageDestinationComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeReference(t, "MessageDestinationComponent", "target", element.getTarget(), -1);
        }
        if (element.hasEndpointElement()) {
            this.composeUrl(t, "MessageDestinationComponent", "endpoint", element.getEndpointElement(), -1);
        }
        if (element.hasReceiver()) {
            this.composeReference(t, "MessageDestinationComponent", "receiver", element.getReceiver(), -1);
        }
    }

    protected void composeMessageHeaderMessageSourceComponent(Turtle.Complex parent, String parentType, String name, MessageHeader.MessageSourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "source", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "MessageSourceComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasSoftwareElement()) {
            this.composeString(t, "MessageSourceComponent", "software", element.getSoftwareElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "MessageSourceComponent", "version", element.getVersionElement(), -1);
        }
        if (element.hasContact()) {
            this.composeContactPoint(t, "MessageSourceComponent", "contact", element.getContact(), -1);
        }
        if (element.hasEndpointElement()) {
            this.composeUrl(t, "MessageSourceComponent", "endpoint", element.getEndpointElement(), -1);
        }
    }

    protected void composeMessageHeaderResponseComponent(Turtle.Complex parent, String parentType, String name, MessageHeader.MessageHeaderResponseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "response", name, element, index);
        if (element.hasIdentifierElement()) {
            this.composeId(t, "MessageHeaderResponseComponent", "identifier", element.getIdentifierElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "MessageHeaderResponseComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDetails()) {
            this.composeReference(t, "MessageHeaderResponseComponent", "details", element.getDetails(), -1);
        }
    }

    protected void composeMolecularSequence(Turtle.Complex parent, String parentType, String name, MolecularSequence element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MolecularSequence", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MolecularSequence", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "MolecularSequence", "type", element.getTypeElement(), -1);
        }
        if (element.hasCoordinateSystemElement()) {
            this.composeInteger(t, "MolecularSequence", "coordinateSystem", element.getCoordinateSystemElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "MolecularSequence", "patient", element.getPatient(), -1);
        }
        if (element.hasSpecimen()) {
            this.composeReference(t, "MolecularSequence", "specimen", element.getSpecimen(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "MolecularSequence", "device", element.getDevice(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "MolecularSequence", "performer", element.getPerformer(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MolecularSequence", "quantity", element.getQuantity(), -1);
        }
        if (element.hasReferenceSeq()) {
            this.composeMolecularSequenceReferenceSeqComponent(t, "MolecularSequence", "referenceSeq", element.getReferenceSeq(), -1);
        }
        for (i = 0; i < element.getVariant().size(); ++i) {
            this.composeMolecularSequenceVariantComponent(t, "MolecularSequence", "variant", element.getVariant().get(i), i);
        }
        if (element.hasObservedSeqElement()) {
            this.composeString(t, "MolecularSequence", "observedSeq", element.getObservedSeqElement(), -1);
        }
        for (i = 0; i < element.getQuality().size(); ++i) {
            this.composeMolecularSequenceQualityComponent(t, "MolecularSequence", "quality", element.getQuality().get(i), i);
        }
        if (element.hasReadCoverageElement()) {
            this.composeInteger(t, "MolecularSequence", "readCoverage", element.getReadCoverageElement(), -1);
        }
        for (i = 0; i < element.getRepository().size(); ++i) {
            this.composeMolecularSequenceRepositoryComponent(t, "MolecularSequence", "repository", element.getRepository().get(i), i);
        }
        for (i = 0; i < element.getPointer().size(); ++i) {
            this.composeReference(t, "MolecularSequence", "pointer", element.getPointer().get(i), i);
        }
        for (i = 0; i < element.getStructureVariant().size(); ++i) {
            this.composeMolecularSequenceStructureVariantComponent(t, "MolecularSequence", "structureVariant", element.getStructureVariant().get(i), i);
        }
    }

    protected void composeMolecularSequenceReferenceSeqComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceReferenceSeqComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "referenceSeq", name, element, index);
        if (element.hasChromosome()) {
            this.composeCodeableConcept(t, "MolecularSequenceReferenceSeqComponent", "chromosome", element.getChromosome(), -1);
        }
        if (element.hasGenomeBuildElement()) {
            this.composeString(t, "MolecularSequenceReferenceSeqComponent", "genomeBuild", element.getGenomeBuildElement(), -1);
        }
        if (element.hasOrientationElement()) {
            this.composeEnum(t, "MolecularSequenceReferenceSeqComponent", "orientation", element.getOrientationElement(), -1);
        }
        if (element.hasReferenceSeqId()) {
            this.composeCodeableConcept(t, "MolecularSequenceReferenceSeqComponent", "referenceSeqId", element.getReferenceSeqId(), -1);
        }
        if (element.hasReferenceSeqPointer()) {
            this.composeReference(t, "MolecularSequenceReferenceSeqComponent", "referenceSeqPointer", element.getReferenceSeqPointer(), -1);
        }
        if (element.hasReferenceSeqStringElement()) {
            this.composeString(t, "MolecularSequenceReferenceSeqComponent", "referenceSeqString", element.getReferenceSeqStringElement(), -1);
        }
        if (element.hasStrandElement()) {
            this.composeEnum(t, "MolecularSequenceReferenceSeqComponent", "strand", element.getStrandElement(), -1);
        }
        if (element.hasWindowStartElement()) {
            this.composeInteger(t, "MolecularSequenceReferenceSeqComponent", "windowStart", element.getWindowStartElement(), -1);
        }
        if (element.hasWindowEndElement()) {
            this.composeInteger(t, "MolecularSequenceReferenceSeqComponent", "windowEnd", element.getWindowEndElement(), -1);
        }
    }

    protected void composeMolecularSequenceVariantComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceVariantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "variant", name, element, index);
        if (element.hasStartElement()) {
            this.composeInteger(t, "MolecularSequenceVariantComponent", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "MolecularSequenceVariantComponent", "end", element.getEndElement(), -1);
        }
        if (element.hasObservedAlleleElement()) {
            this.composeString(t, "MolecularSequenceVariantComponent", "observedAllele", element.getObservedAlleleElement(), -1);
        }
        if (element.hasReferenceAlleleElement()) {
            this.composeString(t, "MolecularSequenceVariantComponent", "referenceAllele", element.getReferenceAlleleElement(), -1);
        }
        if (element.hasCigarElement()) {
            this.composeString(t, "MolecularSequenceVariantComponent", "cigar", element.getCigarElement(), -1);
        }
        if (element.hasVariantPointer()) {
            this.composeReference(t, "MolecularSequenceVariantComponent", "variantPointer", element.getVariantPointer(), -1);
        }
    }

    protected void composeMolecularSequenceQualityComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceQualityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "quality", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "MolecularSequenceQualityComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasStandardSequence()) {
            this.composeCodeableConcept(t, "MolecularSequenceQualityComponent", "standardSequence", element.getStandardSequence(), -1);
        }
        if (element.hasStartElement()) {
            this.composeInteger(t, "MolecularSequenceQualityComponent", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "MolecularSequenceQualityComponent", "end", element.getEndElement(), -1);
        }
        if (element.hasScore()) {
            this.composeQuantity(t, "MolecularSequenceQualityComponent", "score", element.getScore(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "MolecularSequenceQualityComponent", "method", element.getMethod(), -1);
        }
        if (element.hasTruthTPElement()) {
            this.composeDecimal(t, "MolecularSequenceQualityComponent", "truthTP", element.getTruthTPElement(), -1);
        }
        if (element.hasQueryTPElement()) {
            this.composeDecimal(t, "MolecularSequenceQualityComponent", "queryTP", element.getQueryTPElement(), -1);
        }
        if (element.hasTruthFNElement()) {
            this.composeDecimal(t, "MolecularSequenceQualityComponent", "truthFN", element.getTruthFNElement(), -1);
        }
        if (element.hasQueryFPElement()) {
            this.composeDecimal(t, "MolecularSequenceQualityComponent", "queryFP", element.getQueryFPElement(), -1);
        }
        if (element.hasGtFPElement()) {
            this.composeDecimal(t, "MolecularSequenceQualityComponent", "gtFP", element.getGtFPElement(), -1);
        }
        if (element.hasPrecisionElement()) {
            this.composeDecimal(t, "MolecularSequenceQualityComponent", "precision", element.getPrecisionElement(), -1);
        }
        if (element.hasRecallElement()) {
            this.composeDecimal(t, "MolecularSequenceQualityComponent", "recall", element.getRecallElement(), -1);
        }
        if (element.hasFScoreElement()) {
            this.composeDecimal(t, "MolecularSequenceQualityComponent", "fScore", element.getFScoreElement(), -1);
        }
        if (element.hasRoc()) {
            this.composeMolecularSequenceQualityRocComponent(t, "MolecularSequenceQualityComponent", "roc", element.getRoc(), -1);
        }
    }

    protected void composeMolecularSequenceQualityRocComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceQualityRocComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "roc", name, element, index);
        for (i = 0; i < element.getScore().size(); ++i) {
            this.composeInteger(t, "MolecularSequenceQualityRocComponent", "score", element.getScore().get(i), i);
        }
        for (i = 0; i < element.getNumTP().size(); ++i) {
            this.composeInteger(t, "MolecularSequenceQualityRocComponent", "numTP", element.getNumTP().get(i), i);
        }
        for (i = 0; i < element.getNumFP().size(); ++i) {
            this.composeInteger(t, "MolecularSequenceQualityRocComponent", "numFP", element.getNumFP().get(i), i);
        }
        for (i = 0; i < element.getNumFN().size(); ++i) {
            this.composeInteger(t, "MolecularSequenceQualityRocComponent", "numFN", element.getNumFN().get(i), i);
        }
        for (i = 0; i < element.getPrecision().size(); ++i) {
            this.composeDecimal(t, "MolecularSequenceQualityRocComponent", "precision", element.getPrecision().get(i), i);
        }
        for (i = 0; i < element.getSensitivity().size(); ++i) {
            this.composeDecimal(t, "MolecularSequenceQualityRocComponent", "sensitivity", element.getSensitivity().get(i), i);
        }
        for (i = 0; i < element.getFMeasure().size(); ++i) {
            this.composeDecimal(t, "MolecularSequenceQualityRocComponent", "fMeasure", element.getFMeasure().get(i), i);
        }
    }

    protected void composeMolecularSequenceRepositoryComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceRepositoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "repository", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "MolecularSequenceRepositoryComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "MolecularSequenceRepositoryComponent", "url", element.getUrlElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "MolecularSequenceRepositoryComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasDatasetIdElement()) {
            this.composeString(t, "MolecularSequenceRepositoryComponent", "datasetId", element.getDatasetIdElement(), -1);
        }
        if (element.hasVariantsetIdElement()) {
            this.composeString(t, "MolecularSequenceRepositoryComponent", "variantsetId", element.getVariantsetIdElement(), -1);
        }
        if (element.hasReadsetIdElement()) {
            this.composeString(t, "MolecularSequenceRepositoryComponent", "readsetId", element.getReadsetIdElement(), -1);
        }
    }

    protected void composeMolecularSequenceStructureVariantComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceStructureVariantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "structureVariant", name, element, index);
        if (element.hasVariantType()) {
            this.composeCodeableConcept(t, "MolecularSequenceStructureVariantComponent", "variantType", element.getVariantType(), -1);
        }
        if (element.hasExactElement()) {
            this.composeBoolean(t, "MolecularSequenceStructureVariantComponent", "exact", element.getExactElement(), -1);
        }
        if (element.hasLengthElement()) {
            this.composeInteger(t, "MolecularSequenceStructureVariantComponent", "length", element.getLengthElement(), -1);
        }
        if (element.hasOuter()) {
            this.composeMolecularSequenceStructureVariantOuterComponent(t, "MolecularSequenceStructureVariantComponent", "outer", element.getOuter(), -1);
        }
        if (element.hasInner()) {
            this.composeMolecularSequenceStructureVariantInnerComponent(t, "MolecularSequenceStructureVariantComponent", "inner", element.getInner(), -1);
        }
    }

    protected void composeMolecularSequenceStructureVariantOuterComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceStructureVariantOuterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "outer", name, element, index);
        if (element.hasStartElement()) {
            this.composeInteger(t, "MolecularSequenceStructureVariantOuterComponent", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "MolecularSequenceStructureVariantOuterComponent", "end", element.getEndElement(), -1);
        }
    }

    protected void composeMolecularSequenceStructureVariantInnerComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceStructureVariantInnerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "inner", name, element, index);
        if (element.hasStartElement()) {
            this.composeInteger(t, "MolecularSequenceStructureVariantInnerComponent", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "MolecularSequenceStructureVariantInnerComponent", "end", element.getEndElement(), -1);
        }
    }

    protected void composeNamingSystem(Turtle.Complex parent, String parentType, String name, NamingSystem element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "NamingSystem", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "NamingSystem", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "NamingSystem", "status", element.getStatusElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "NamingSystem", "kind", element.getKindElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "NamingSystem", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "NamingSystem", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "NamingSystem", "contact", element.getContact().get(i), i);
        }
        if (element.hasResponsibleElement()) {
            this.composeString(t, "NamingSystem", "responsible", element.getResponsibleElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "NamingSystem", "type", element.getType(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "NamingSystem", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "NamingSystem", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "NamingSystem", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "NamingSystem", "usage", element.getUsageElement(), -1);
        }
        for (i = 0; i < element.getUniqueId().size(); ++i) {
            this.composeNamingSystemUniqueIdComponent(t, "NamingSystem", "uniqueId", element.getUniqueId().get(i), i);
        }
    }

    protected void composeNamingSystemUniqueIdComponent(Turtle.Complex parent, String parentType, String name, NamingSystem.NamingSystemUniqueIdComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "uniqueId", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "NamingSystemUniqueIdComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "NamingSystemUniqueIdComponent", "value", element.getValueElement(), -1);
        }
        if (element.hasPreferredElement()) {
            this.composeBoolean(t, "NamingSystemUniqueIdComponent", "preferred", element.getPreferredElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "NamingSystemUniqueIdComponent", "comment", element.getCommentElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "NamingSystemUniqueIdComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeNutritionOrder(Turtle.Complex parent, String parentType, String name, NutritionOrder element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "NutritionOrder", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "NutritionOrder", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "NutritionOrder", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "NutritionOrder", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getInstantiates().size(); ++i) {
            this.composeUri(t, "NutritionOrder", "instantiates", element.getInstantiates().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "NutritionOrder", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "NutritionOrder", "intent", element.getIntentElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "NutritionOrder", "patient", element.getPatient(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "NutritionOrder", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateTimeElement()) {
            this.composeDateTime(t, "NutritionOrder", "dateTime", element.getDateTimeElement(), -1);
        }
        if (element.hasOrderer()) {
            this.composeReference(t, "NutritionOrder", "orderer", element.getOrderer(), -1);
        }
        for (i = 0; i < element.getAllergyIntolerance().size(); ++i) {
            this.composeReference(t, "NutritionOrder", "allergyIntolerance", element.getAllergyIntolerance().get(i), i);
        }
        for (i = 0; i < element.getFoodPreferenceModifier().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionOrder", "foodPreferenceModifier", element.getFoodPreferenceModifier().get(i), i);
        }
        for (i = 0; i < element.getExcludeFoodModifier().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionOrder", "excludeFoodModifier", element.getExcludeFoodModifier().get(i), i);
        }
        if (element.hasOralDiet()) {
            this.composeNutritionOrderOralDietComponent(t, "NutritionOrder", "oralDiet", element.getOralDiet(), -1);
        }
        for (i = 0; i < element.getSupplement().size(); ++i) {
            this.composeNutritionOrderSupplementComponent(t, "NutritionOrder", "supplement", element.getSupplement().get(i), i);
        }
        if (element.hasEnteralFormula()) {
            this.composeNutritionOrderEnteralFormulaComponent(t, "NutritionOrder", "enteralFormula", element.getEnteralFormula(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "NutritionOrder", "note", element.getNote().get(i), i);
        }
    }

    protected void composeNutritionOrderOralDietComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "oralDiet", name, element, index);
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionOrderOralDietComponent", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getSchedule().size(); ++i) {
            this.composeTiming(t, "NutritionOrderOralDietComponent", "schedule", element.getSchedule().get(i), i);
        }
        for (i = 0; i < element.getNutrient().size(); ++i) {
            this.composeNutritionOrderOralDietNutrientComponent(t, "NutritionOrderOralDietComponent", "nutrient", element.getNutrient().get(i), i);
        }
        for (i = 0; i < element.getTexture().size(); ++i) {
            this.composeNutritionOrderOralDietTextureComponent(t, "NutritionOrderOralDietComponent", "texture", element.getTexture().get(i), i);
        }
        for (i = 0; i < element.getFluidConsistencyType().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionOrderOralDietComponent", "fluidConsistencyType", element.getFluidConsistencyType().get(i), i);
        }
        if (element.hasInstructionElement()) {
            this.composeString(t, "NutritionOrderOralDietComponent", "instruction", element.getInstructionElement(), -1);
        }
    }

    protected void composeNutritionOrderOralDietNutrientComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietNutrientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "nutrient", name, element, index);
        if (element.hasModifier()) {
            this.composeCodeableConcept(t, "NutritionOrderOralDietNutrientComponent", "modifier", element.getModifier(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "NutritionOrderOralDietNutrientComponent", "amount", element.getAmount(), -1);
        }
    }

    protected void composeNutritionOrderOralDietTextureComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietTextureComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "texture", name, element, index);
        if (element.hasModifier()) {
            this.composeCodeableConcept(t, "NutritionOrderOralDietTextureComponent", "modifier", element.getModifier(), -1);
        }
        if (element.hasFoodType()) {
            this.composeCodeableConcept(t, "NutritionOrderOralDietTextureComponent", "foodType", element.getFoodType(), -1);
        }
    }

    protected void composeNutritionOrderSupplementComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderSupplementComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supplement", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "NutritionOrderSupplementComponent", "type", element.getType(), -1);
        }
        if (element.hasProductNameElement()) {
            this.composeString(t, "NutritionOrderSupplementComponent", "productName", element.getProductNameElement(), -1);
        }
        for (int i = 0; i < element.getSchedule().size(); ++i) {
            this.composeTiming(t, "NutritionOrderSupplementComponent", "schedule", element.getSchedule().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "NutritionOrderSupplementComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasInstructionElement()) {
            this.composeString(t, "NutritionOrderSupplementComponent", "instruction", element.getInstructionElement(), -1);
        }
    }

    protected void composeNutritionOrderEnteralFormulaComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderEnteralFormulaComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "enteralFormula", name, element, index);
        if (element.hasBaseFormulaType()) {
            this.composeCodeableConcept(t, "NutritionOrderEnteralFormulaComponent", "baseFormulaType", element.getBaseFormulaType(), -1);
        }
        if (element.hasBaseFormulaProductNameElement()) {
            this.composeString(t, "NutritionOrderEnteralFormulaComponent", "baseFormulaProductName", element.getBaseFormulaProductNameElement(), -1);
        }
        if (element.hasAdditiveType()) {
            this.composeCodeableConcept(t, "NutritionOrderEnteralFormulaComponent", "additiveType", element.getAdditiveType(), -1);
        }
        if (element.hasAdditiveProductNameElement()) {
            this.composeString(t, "NutritionOrderEnteralFormulaComponent", "additiveProductName", element.getAdditiveProductNameElement(), -1);
        }
        if (element.hasCaloricDensity()) {
            this.composeQuantity(t, "NutritionOrderEnteralFormulaComponent", "caloricDensity", element.getCaloricDensity(), -1);
        }
        if (element.hasRouteofAdministration()) {
            this.composeCodeableConcept(t, "NutritionOrderEnteralFormulaComponent", "routeofAdministration", element.getRouteofAdministration(), -1);
        }
        for (int i = 0; i < element.getAdministration().size(); ++i) {
            this.composeNutritionOrderEnteralFormulaAdministrationComponent(t, "NutritionOrderEnteralFormulaComponent", "administration", element.getAdministration().get(i), i);
        }
        if (element.hasMaxVolumeToDeliver()) {
            this.composeQuantity(t, "NutritionOrderEnteralFormulaComponent", "maxVolumeToDeliver", element.getMaxVolumeToDeliver(), -1);
        }
        if (element.hasAdministrationInstructionElement()) {
            this.composeString(t, "NutritionOrderEnteralFormulaComponent", "administrationInstruction", element.getAdministrationInstructionElement(), -1);
        }
    }

    protected void composeNutritionOrderEnteralFormulaAdministrationComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "administration", name, element, index);
        if (element.hasSchedule()) {
            this.composeTiming(t, "NutritionOrderEnteralFormulaAdministrationComponent", "schedule", element.getSchedule(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "NutritionOrderEnteralFormulaAdministrationComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "NutritionOrderEnteralFormulaAdministrationComponent", "rate", element.getRate(), -1);
        }
    }

    protected void composeNutritionProduct(Turtle.Complex parent, String parentType, String name, NutritionProduct element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "NutritionProduct", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "NutritionProduct", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionProduct", "category", element.getCategory().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "NutritionProduct", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getManufacturer().size(); ++i) {
            this.composeReference(t, "NutritionProduct", "manufacturer", element.getManufacturer().get(i), i);
        }
        for (i = 0; i < element.getNutrient().size(); ++i) {
            this.composeNutritionProductNutrientComponent(t, "NutritionProduct", "nutrient", element.getNutrient().get(i), i);
        }
        for (i = 0; i < element.getIngredient().size(); ++i) {
            this.composeNutritionProductIngredientComponent(t, "NutritionProduct", "ingredient", element.getIngredient().get(i), i);
        }
        for (i = 0; i < element.getKnownAllergen().size(); ++i) {
            this.composeCodeableReference(t, "NutritionProduct", "knownAllergen", element.getKnownAllergen().get(i), i);
        }
        for (i = 0; i < element.getProductCharacteristic().size(); ++i) {
            this.composeNutritionProductProductCharacteristicComponent(t, "NutritionProduct", "productCharacteristic", element.getProductCharacteristic().get(i), i);
        }
        if (element.hasInstance()) {
            this.composeNutritionProductInstanceComponent(t, "NutritionProduct", "instance", element.getInstance(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "NutritionProduct", "note", element.getNote().get(i), i);
        }
    }

    protected void composeNutritionProductNutrientComponent(Turtle.Complex parent, String parentType, String name, NutritionProduct.NutritionProductNutrientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "nutrient", name, element, index);
        if (element.hasItem()) {
            this.composeCodeableReference(t, "NutritionProductNutrientComponent", "item", element.getItem(), -1);
        }
        for (int i = 0; i < element.getAmount().size(); ++i) {
            this.composeRatio(t, "NutritionProductNutrientComponent", "amount", element.getAmount().get(i), i);
        }
    }

    protected void composeNutritionProductIngredientComponent(Turtle.Complex parent, String parentType, String name, NutritionProduct.NutritionProductIngredientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "ingredient", name, element, index);
        if (element.hasItem()) {
            this.composeCodeableReference(t, "NutritionProductIngredientComponent", "item", element.getItem(), -1);
        }
        for (int i = 0; i < element.getAmount().size(); ++i) {
            this.composeRatio(t, "NutritionProductIngredientComponent", "amount", element.getAmount().get(i), i);
        }
    }

    protected void composeNutritionProductProductCharacteristicComponent(Turtle.Complex parent, String parentType, String name, NutritionProduct.NutritionProductProductCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "productCharacteristic", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "NutritionProductProductCharacteristicComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "NutritionProductProductCharacteristicComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeNutritionProductInstanceComponent(Turtle.Complex parent, String parentType, String name, NutritionProduct.NutritionProductInstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasQuantity()) {
            this.composeQuantity(t, "NutritionProductInstanceComponent", "quantity", element.getQuantity(), -1);
        }
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "NutritionProductInstanceComponent", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasLotNumberElement()) {
            this.composeString(t, "NutritionProductInstanceComponent", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasExpiryElement()) {
            this.composeDateTime(t, "NutritionProductInstanceComponent", "expiry", element.getExpiryElement(), -1);
        }
        if (element.hasUseByElement()) {
            this.composeDateTime(t, "NutritionProductInstanceComponent", "useBy", element.getUseByElement(), -1);
        }
    }

    protected void composeObservation(Turtle.Complex parent, String parentType, String name, Observation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Observation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Observation", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Observation", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "Observation", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Observation", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Observation", "category", element.getCategory().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Observation", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Observation", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getFocus().size(); ++i) {
            this.composeReference(t, "Observation", "focus", element.getFocus().get(i), i);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Observation", "encounter", element.getEncounter(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "Observation", "effective", element.getEffective(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeInstant(t, "Observation", "issued", element.getIssuedElement(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "Observation", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasValue()) {
            this.composeType(t, "Observation", "value", element.getValue(), -1);
        }
        if (element.hasDataAbsentReason()) {
            this.composeCodeableConcept(t, "Observation", "dataAbsentReason", element.getDataAbsentReason(), -1);
        }
        for (i = 0; i < element.getInterpretation().size(); ++i) {
            this.composeCodeableConcept(t, "Observation", "interpretation", element.getInterpretation().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Observation", "note", element.getNote().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "Observation", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "Observation", "method", element.getMethod(), -1);
        }
        if (element.hasSpecimen()) {
            this.composeReference(t, "Observation", "specimen", element.getSpecimen(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "Observation", "device", element.getDevice(), -1);
        }
        for (i = 0; i < element.getReferenceRange().size(); ++i) {
            this.composeObservationReferenceRangeComponent(t, "Observation", "referenceRange", element.getReferenceRange().get(i), i);
        }
        for (i = 0; i < element.getHasMember().size(); ++i) {
            this.composeReference(t, "Observation", "hasMember", element.getHasMember().get(i), i);
        }
        for (i = 0; i < element.getDerivedFrom().size(); ++i) {
            this.composeReference(t, "Observation", "derivedFrom", element.getDerivedFrom().get(i), i);
        }
        for (i = 0; i < element.getComponent().size(); ++i) {
            this.composeObservationComponentComponent(t, "Observation", "component", element.getComponent().get(i), i);
        }
    }

    protected void composeObservationReferenceRangeComponent(Turtle.Complex parent, String parentType, String name, Observation.ObservationReferenceRangeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "referenceRange", name, element, index);
        if (element.hasLow()) {
            this.composeQuantity(t, "ObservationReferenceRangeComponent", "low", element.getLow(), -1);
        }
        if (element.hasHigh()) {
            this.composeQuantity(t, "ObservationReferenceRangeComponent", "high", element.getHigh(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ObservationReferenceRangeComponent", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getAppliesTo().size(); ++i) {
            this.composeCodeableConcept(t, "ObservationReferenceRangeComponent", "appliesTo", element.getAppliesTo().get(i), i);
        }
        if (element.hasAge()) {
            this.composeRange(t, "ObservationReferenceRangeComponent", "age", element.getAge(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "ObservationReferenceRangeComponent", "text", element.getTextElement(), -1);
        }
    }

    protected void composeObservationComponentComponent(Turtle.Complex parent, String parentType, String name, Observation.ObservationComponentComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ObservationComponentComponent", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ObservationComponentComponent", "value", element.getValue(), -1);
        }
        if (element.hasDataAbsentReason()) {
            this.composeCodeableConcept(t, "ObservationComponentComponent", "dataAbsentReason", element.getDataAbsentReason(), -1);
        }
        for (i = 0; i < element.getInterpretation().size(); ++i) {
            this.composeCodeableConcept(t, "ObservationComponentComponent", "interpretation", element.getInterpretation().get(i), i);
        }
        for (i = 0; i < element.getReferenceRange().size(); ++i) {
            this.composeObservationReferenceRangeComponent(t, "ObservationComponentComponent", "referenceRange", element.getReferenceRange().get(i), i);
        }
    }

    protected void composeObservationDefinition(Turtle.Complex parent, String parentType, String name, ObservationDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ObservationDefinition", name, element, index);
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "ObservationDefinition", "category", element.getCategory().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ObservationDefinition", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ObservationDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getPermittedDataType().size(); ++i) {
            this.composeEnum(t, "ObservationDefinition", "permittedDataType", element.getPermittedDataType().get(i), i);
        }
        if (element.hasMultipleResultsAllowedElement()) {
            this.composeBoolean(t, "ObservationDefinition", "multipleResultsAllowed", element.getMultipleResultsAllowedElement(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "ObservationDefinition", "method", element.getMethod(), -1);
        }
        if (element.hasPreferredReportNameElement()) {
            this.composeString(t, "ObservationDefinition", "preferredReportName", element.getPreferredReportNameElement(), -1);
        }
        if (element.hasQuantitativeDetails()) {
            this.composeObservationDefinitionQuantitativeDetailsComponent(t, "ObservationDefinition", "quantitativeDetails", element.getQuantitativeDetails(), -1);
        }
        for (i = 0; i < element.getQualifiedInterval().size(); ++i) {
            this.composeObservationDefinitionQualifiedIntervalComponent(t, "ObservationDefinition", "qualifiedInterval", element.getQualifiedInterval().get(i), i);
        }
        if (element.hasValidCodedValueSet()) {
            this.composeReference(t, "ObservationDefinition", "validCodedValueSet", element.getValidCodedValueSet(), -1);
        }
        if (element.hasNormalCodedValueSet()) {
            this.composeReference(t, "ObservationDefinition", "normalCodedValueSet", element.getNormalCodedValueSet(), -1);
        }
        if (element.hasAbnormalCodedValueSet()) {
            this.composeReference(t, "ObservationDefinition", "abnormalCodedValueSet", element.getAbnormalCodedValueSet(), -1);
        }
        if (element.hasCriticalCodedValueSet()) {
            this.composeReference(t, "ObservationDefinition", "criticalCodedValueSet", element.getCriticalCodedValueSet(), -1);
        }
    }

    protected void composeObservationDefinitionQuantitativeDetailsComponent(Turtle.Complex parent, String parentType, String name, ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "quantitativeDetails", name, element, index);
        if (element.hasCustomaryUnit()) {
            this.composeCodeableConcept(t, "ObservationDefinitionQuantitativeDetailsComponent", "customaryUnit", element.getCustomaryUnit(), -1);
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "ObservationDefinitionQuantitativeDetailsComponent", "unit", element.getUnit(), -1);
        }
        if (element.hasConversionFactorElement()) {
            this.composeDecimal(t, "ObservationDefinitionQuantitativeDetailsComponent", "conversionFactor", element.getConversionFactorElement(), -1);
        }
        if (element.hasDecimalPrecisionElement()) {
            this.composeInteger(t, "ObservationDefinitionQuantitativeDetailsComponent", "decimalPrecision", element.getDecimalPrecisionElement(), -1);
        }
    }

    protected void composeObservationDefinitionQualifiedIntervalComponent(Turtle.Complex parent, String parentType, String name, ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "qualifiedInterval", name, element, index);
        if (element.hasCategoryElement()) {
            this.composeEnum(t, "ObservationDefinitionQualifiedIntervalComponent", "category", element.getCategoryElement(), -1);
        }
        if (element.hasRange()) {
            this.composeRange(t, "ObservationDefinitionQualifiedIntervalComponent", "range", element.getRange(), -1);
        }
        if (element.hasContext()) {
            this.composeCodeableConcept(t, "ObservationDefinitionQualifiedIntervalComponent", "context", element.getContext(), -1);
        }
        for (int i = 0; i < element.getAppliesTo().size(); ++i) {
            this.composeCodeableConcept(t, "ObservationDefinitionQualifiedIntervalComponent", "appliesTo", element.getAppliesTo().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "ObservationDefinitionQualifiedIntervalComponent", "gender", element.getGenderElement(), -1);
        }
        if (element.hasAge()) {
            this.composeRange(t, "ObservationDefinitionQualifiedIntervalComponent", "age", element.getAge(), -1);
        }
        if (element.hasGestationalAge()) {
            this.composeRange(t, "ObservationDefinitionQualifiedIntervalComponent", "gestationalAge", element.getGestationalAge(), -1);
        }
        if (element.hasConditionElement()) {
            this.composeString(t, "ObservationDefinitionQualifiedIntervalComponent", "condition", element.getConditionElement(), -1);
        }
    }

    protected void composeOperationDefinition(Turtle.Complex parent, String parentType, String name, OperationDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "OperationDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "OperationDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "OperationDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "OperationDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "OperationDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "OperationDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "OperationDefinition", "kind", element.getKindElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "OperationDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "OperationDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "OperationDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "OperationDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "OperationDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "OperationDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "OperationDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "OperationDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasAffectsStateElement()) {
            this.composeBoolean(t, "OperationDefinition", "affectsState", element.getAffectsStateElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "OperationDefinition", "code", element.getCodeElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeMarkdown(t, "OperationDefinition", "comment", element.getCommentElement(), -1);
        }
        if (element.hasBaseElement()) {
            this.composeCanonical(t, "OperationDefinition", "base", element.getBaseElement(), -1);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeCode(t, "OperationDefinition", "resource", element.getResource().get(i), i);
        }
        if (element.hasSystemElement()) {
            this.composeBoolean(t, "OperationDefinition", "system", element.getSystemElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeBoolean(t, "OperationDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasInstanceElement()) {
            this.composeBoolean(t, "OperationDefinition", "instance", element.getInstanceElement(), -1);
        }
        if (element.hasInputProfileElement()) {
            this.composeCanonical(t, "OperationDefinition", "inputProfile", element.getInputProfileElement(), -1);
        }
        if (element.hasOutputProfileElement()) {
            this.composeCanonical(t, "OperationDefinition", "outputProfile", element.getOutputProfileElement(), -1);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeOperationDefinitionParameterComponent(t, "OperationDefinition", "parameter", element.getParameter().get(i), i);
        }
        for (i = 0; i < element.getOverload().size(); ++i) {
            this.composeOperationDefinitionOverloadComponent(t, "OperationDefinition", "overload", element.getOverload().get(i), i);
        }
    }

    protected void composeOperationDefinitionParameterComponent(Turtle.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasNameElement()) {
            this.composeCode(t, "OperationDefinitionParameterComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "OperationDefinitionParameterComponent", "use", element.getUseElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "OperationDefinitionParameterComponent", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "OperationDefinitionParameterComponent", "max", element.getMaxElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "OperationDefinitionParameterComponent", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "OperationDefinitionParameterComponent", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getTargetProfile().size(); ++i) {
            this.composeCanonical(t, "OperationDefinitionParameterComponent", "targetProfile", element.getTargetProfile().get(i), i);
        }
        if (element.hasSearchTypeElement()) {
            this.composeEnum(t, "OperationDefinitionParameterComponent", "searchType", element.getSearchTypeElement(), -1);
        }
        if (element.hasBinding()) {
            this.composeOperationDefinitionParameterBindingComponent(t, "OperationDefinitionParameterComponent", "binding", element.getBinding(), -1);
        }
        for (i = 0; i < element.getReferencedFrom().size(); ++i) {
            this.composeOperationDefinitionParameterReferencedFromComponent(t, "OperationDefinitionParameterComponent", "referencedFrom", element.getReferencedFrom().get(i), i);
        }
        for (i = 0; i < element.getPart().size(); ++i) {
            this.composeOperationDefinitionParameterComponent(t, "OperationDefinitionParameterComponent", "part", element.getPart().get(i), i);
        }
    }

    protected void composeOperationDefinitionParameterBindingComponent(Turtle.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterBindingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "binding", name, element, index);
        if (element.hasStrengthElement()) {
            this.composeEnum(t, "OperationDefinitionParameterBindingComponent", "strength", element.getStrengthElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "OperationDefinitionParameterBindingComponent", "valueSet", element.getValueSetElement(), -1);
        }
    }

    protected void composeOperationDefinitionParameterReferencedFromComponent(Turtle.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterReferencedFromComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "referencedFrom", name, element, index);
        if (element.hasSourceElement()) {
            this.composeString(t, "OperationDefinitionParameterReferencedFromComponent", "source", element.getSourceElement(), -1);
        }
        if (element.hasSourceIdElement()) {
            this.composeString(t, "OperationDefinitionParameterReferencedFromComponent", "sourceId", element.getSourceIdElement(), -1);
        }
    }

    protected void composeOperationDefinitionOverloadComponent(Turtle.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionOverloadComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "overload", name, element, index);
        for (int i = 0; i < element.getParameterName().size(); ++i) {
            this.composeString(t, "OperationDefinitionOverloadComponent", "parameterName", element.getParameterName().get(i), i);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "OperationDefinitionOverloadComponent", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeOperationOutcome(Turtle.Complex parent, String parentType, String name, OperationOutcome element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "OperationOutcome", name, element, index);
        for (int i = 0; i < element.getIssue().size(); ++i) {
            this.composeOperationOutcomeIssueComponent(t, "OperationOutcome", "issue", element.getIssue().get(i), i);
        }
    }

    protected void composeOperationOutcomeIssueComponent(Turtle.Complex parent, String parentType, String name, OperationOutcome.OperationOutcomeIssueComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "issue", name, element, index);
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "OperationOutcomeIssueComponent", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "OperationOutcomeIssueComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDetails()) {
            this.composeCodeableConcept(t, "OperationOutcomeIssueComponent", "details", element.getDetails(), -1);
        }
        if (element.hasDiagnosticsElement()) {
            this.composeString(t, "OperationOutcomeIssueComponent", "diagnostics", element.getDiagnosticsElement(), -1);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeString(t, "OperationOutcomeIssueComponent", "location", element.getLocation().get(i), i);
        }
        for (i = 0; i < element.getExpression().size(); ++i) {
            this.composeString(t, "OperationOutcomeIssueComponent", "expression", element.getExpression().get(i), i);
        }
    }

    protected void composeOrganization(Turtle.Complex parent, String parentType, String name, Organization element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Organization", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Organization", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Organization", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Organization", "type", element.getType().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Organization", "name", element.getNameElement(), -1);
        }
        for (i = 0; i < element.getAlias().size(); ++i) {
            this.composeString(t, "Organization", "alias", element.getAlias().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Organization", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "Organization", "address", element.getAddress().get(i), i);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Organization", "partOf", element.getPartOf(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeOrganizationContactComponent(t, "Organization", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "Organization", "endpoint", element.getEndpoint().get(i), i);
        }
    }

    protected void composeOrganizationContactComponent(Turtle.Complex parent, String parentType, String name, Organization.OrganizationContactComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasPurpose()) {
            this.composeCodeableConcept(t, "OrganizationContactComponent", "purpose", element.getPurpose(), -1);
        }
        if (element.hasName()) {
            this.composeHumanName(t, "OrganizationContactComponent", "name", element.getName(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "OrganizationContactComponent", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "OrganizationContactComponent", "address", element.getAddress(), -1);
        }
    }

    protected void composeOrganizationAffiliation(Turtle.Complex parent, String parentType, String name, OrganizationAffiliation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "OrganizationAffiliation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "OrganizationAffiliation", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "OrganizationAffiliation", "active", element.getActiveElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "OrganizationAffiliation", "period", element.getPeriod(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "OrganizationAffiliation", "organization", element.getOrganization(), -1);
        }
        if (element.hasParticipatingOrganization()) {
            this.composeReference(t, "OrganizationAffiliation", "participatingOrganization", element.getParticipatingOrganization(), -1);
        }
        for (i = 0; i < element.getNetwork().size(); ++i) {
            this.composeReference(t, "OrganizationAffiliation", "network", element.getNetwork().get(i), i);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "OrganizationAffiliation", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "OrganizationAffiliation", "specialty", element.getSpecialty().get(i), i);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeReference(t, "OrganizationAffiliation", "location", element.getLocation().get(i), i);
        }
        for (i = 0; i < element.getHealthcareService().size(); ++i) {
            this.composeReference(t, "OrganizationAffiliation", "healthcareService", element.getHealthcareService().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "OrganizationAffiliation", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "OrganizationAffiliation", "endpoint", element.getEndpoint().get(i), i);
        }
    }

    protected void composePackagedProductDefinition(Turtle.Complex parent, String parentType, String name, PackagedProductDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "PackagedProductDefinition", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PackagedProductDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "PackagedProductDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PackagedProductDefinition", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getPackageFor().size(); ++i) {
            this.composeReference(t, "PackagedProductDefinition", "packageFor", element.getPackageFor().get(i), i);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "PackagedProductDefinition", "status", element.getStatus(), -1);
        }
        if (element.hasStatusDateElement()) {
            this.composeDateTime(t, "PackagedProductDefinition", "statusDate", element.getStatusDateElement(), -1);
        }
        for (i = 0; i < element.getContainedItemQuantity().size(); ++i) {
            this.composeQuantity(t, "PackagedProductDefinition", "containedItemQuantity", element.getContainedItemQuantity().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "PackagedProductDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getLegalStatusOfSupply().size(); ++i) {
            this.composePackagedProductDefinitionLegalStatusOfSupplyComponent(t, "PackagedProductDefinition", "legalStatusOfSupply", element.getLegalStatusOfSupply().get(i), i);
        }
        for (i = 0; i < element.getMarketingStatus().size(); ++i) {
            this.composeMarketingStatus(t, "PackagedProductDefinition", "marketingStatus", element.getMarketingStatus().get(i), i);
        }
        for (i = 0; i < element.getCharacteristic().size(); ++i) {
            this.composeCodeableConcept(t, "PackagedProductDefinition", "characteristic", element.getCharacteristic().get(i), i);
        }
        if (element.hasCopackagedIndicatorElement()) {
            this.composeBoolean(t, "PackagedProductDefinition", "copackagedIndicator", element.getCopackagedIndicatorElement(), -1);
        }
        for (i = 0; i < element.getManufacturer().size(); ++i) {
            this.composeReference(t, "PackagedProductDefinition", "manufacturer", element.getManufacturer().get(i), i);
        }
        if (element.hasPackage()) {
            this.composePackagedProductDefinitionPackageComponent(t, "PackagedProductDefinition", "package", element.getPackage(), -1);
        }
    }

    protected void composePackagedProductDefinitionLegalStatusOfSupplyComponent(Turtle.Complex parent, String parentType, String name, PackagedProductDefinition.PackagedProductDefinitionLegalStatusOfSupplyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "legalStatusOfSupply", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "PackagedProductDefinitionLegalStatusOfSupplyComponent", "code", element.getCode(), -1);
        }
        if (element.hasJurisdiction()) {
            this.composeCodeableConcept(t, "PackagedProductDefinitionLegalStatusOfSupplyComponent", "jurisdiction", element.getJurisdiction(), -1);
        }
    }

    protected void composePackagedProductDefinitionPackageComponent(Turtle.Complex parent, String parentType, String name, PackagedProductDefinition.PackagedProductDefinitionPackageComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "package", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PackagedProductDefinitionPackageComponent", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PackagedProductDefinitionPackageComponent", "type", element.getType(), -1);
        }
        if (element.hasQuantityElement()) {
            this.composeInteger(t, "PackagedProductDefinitionPackageComponent", "quantity", element.getQuantityElement(), -1);
        }
        for (i = 0; i < element.getMaterial().size(); ++i) {
            this.composeCodeableConcept(t, "PackagedProductDefinitionPackageComponent", "material", element.getMaterial().get(i), i);
        }
        for (i = 0; i < element.getAlternateMaterial().size(); ++i) {
            this.composeCodeableConcept(t, "PackagedProductDefinitionPackageComponent", "alternateMaterial", element.getAlternateMaterial().get(i), i);
        }
        for (i = 0; i < element.getShelfLifeStorage().size(); ++i) {
            this.composeProductShelfLife(t, "PackagedProductDefinitionPackageComponent", "shelfLifeStorage", element.getShelfLifeStorage().get(i), i);
        }
        for (i = 0; i < element.getManufacturer().size(); ++i) {
            this.composeReference(t, "PackagedProductDefinitionPackageComponent", "manufacturer", element.getManufacturer().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composePackagedProductDefinitionPackagePropertyComponent(t, "PackagedProductDefinitionPackageComponent", "property", element.getProperty().get(i), i);
        }
        for (i = 0; i < element.getContainedItem().size(); ++i) {
            this.composePackagedProductDefinitionPackageContainedItemComponent(t, "PackagedProductDefinitionPackageComponent", "containedItem", element.getContainedItem().get(i), i);
        }
        for (i = 0; i < element.getPackage().size(); ++i) {
            this.composePackagedProductDefinitionPackageComponent(t, "PackagedProductDefinitionPackageComponent", "package", element.getPackage().get(i), i);
        }
    }

    protected void composePackagedProductDefinitionPackagePropertyComponent(Turtle.Complex parent, String parentType, String name, PackagedProductDefinition.PackagedProductDefinitionPackagePropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PackagedProductDefinitionPackagePropertyComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "PackagedProductDefinitionPackagePropertyComponent", "value", element.getValue(), -1);
        }
    }

    protected void composePackagedProductDefinitionPackageContainedItemComponent(Turtle.Complex parent, String parentType, String name, PackagedProductDefinition.PackagedProductDefinitionPackageContainedItemComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "containedItem", name, element, index);
        if (element.hasItem()) {
            this.composeCodeableReference(t, "PackagedProductDefinitionPackageContainedItemComponent", "item", element.getItem(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "PackagedProductDefinitionPackageContainedItemComponent", "amount", element.getAmount(), -1);
        }
    }

    protected void composeParameters(Turtle.Complex parent, String parentType, String name, Parameters element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeResource(t, "Parameters", name, element, index);
        for (int i = 0; i < element.getParameter().size(); ++i) {
            this.composeParametersParameterComponent(t, "Parameters", "parameter", element.getParameter().get(i), i);
        }
    }

    protected void composeParametersParameterComponent(Turtle.Complex parent, String parentType, String name, Parameters.ParametersParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ParametersParameterComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ParametersParameterComponent", "value", element.getValue(), -1);
        }
        if (element.hasResource()) {
            this.composeResource(t, "ParametersParameterComponent", "resource", element.getResource(), -1);
        }
        for (int i = 0; i < element.getPart().size(); ++i) {
            this.composeParametersParameterComponent(t, "ParametersParameterComponent", "part", element.getPart().get(i), i);
        }
    }

    protected void composePatient(Turtle.Complex parent, String parentType, String name, Patient element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Patient", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Patient", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Patient", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeHumanName(t, "Patient", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Patient", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "Patient", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "Patient", "birthDate", element.getBirthDateElement(), -1);
        }
        if (element.hasDeceased()) {
            this.composeType(t, "Patient", "deceased", element.getDeceased(), -1);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "Patient", "address", element.getAddress().get(i), i);
        }
        if (element.hasMaritalStatus()) {
            this.composeCodeableConcept(t, "Patient", "maritalStatus", element.getMaritalStatus(), -1);
        }
        if (element.hasMultipleBirth()) {
            this.composeType(t, "Patient", "multipleBirth", element.getMultipleBirth(), -1);
        }
        for (i = 0; i < element.getPhoto().size(); ++i) {
            this.composeAttachment(t, "Patient", "photo", element.getPhoto().get(i), i);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composePatientContactComponent(t, "Patient", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getCommunication().size(); ++i) {
            this.composePatientCommunicationComponent(t, "Patient", "communication", element.getCommunication().get(i), i);
        }
        for (i = 0; i < element.getGeneralPractitioner().size(); ++i) {
            this.composeReference(t, "Patient", "generalPractitioner", element.getGeneralPractitioner().get(i), i);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Patient", "managingOrganization", element.getManagingOrganization(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composePatientLinkComponent(t, "Patient", "link", element.getLink().get(i), i);
        }
    }

    protected void composePatientContactComponent(Turtle.Complex parent, String parentType, String name, Patient.ContactComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        for (i = 0; i < element.getRelationship().size(); ++i) {
            this.composeCodeableConcept(t, "ContactComponent", "relationship", element.getRelationship().get(i), i);
        }
        if (element.hasName()) {
            this.composeHumanName(t, "ContactComponent", "name", element.getName(), -1);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "ContactComponent", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "ContactComponent", "address", element.getAddress(), -1);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "ContactComponent", "gender", element.getGenderElement(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "ContactComponent", "organization", element.getOrganization(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ContactComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composePatientCommunicationComponent(Turtle.Complex parent, String parentType, String name, Patient.PatientCommunicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "communication", name, element, index);
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "PatientCommunicationComponent", "language", element.getLanguage(), -1);
        }
        if (element.hasPreferredElement()) {
            this.composeBoolean(t, "PatientCommunicationComponent", "preferred", element.getPreferredElement(), -1);
        }
    }

    protected void composePatientLinkComponent(Turtle.Complex parent, String parentType, String name, Patient.PatientLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasOther()) {
            this.composeReference(t, "PatientLinkComponent", "other", element.getOther(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "PatientLinkComponent", "type", element.getTypeElement(), -1);
        }
    }

    protected void composePaymentNotice(Turtle.Complex parent, String parentType, String name, PaymentNotice element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "PaymentNotice", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PaymentNotice", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "PaymentNotice", "status", element.getStatusElement(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "PaymentNotice", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeReference(t, "PaymentNotice", "response", element.getResponse(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "PaymentNotice", "created", element.getCreatedElement(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "PaymentNotice", "provider", element.getProvider(), -1);
        }
        if (element.hasPayment()) {
            this.composeReference(t, "PaymentNotice", "payment", element.getPayment(), -1);
        }
        if (element.hasPaymentDateElement()) {
            this.composeDate(t, "PaymentNotice", "paymentDate", element.getPaymentDateElement(), -1);
        }
        if (element.hasPayee()) {
            this.composeReference(t, "PaymentNotice", "payee", element.getPayee(), -1);
        }
        if (element.hasRecipient()) {
            this.composeReference(t, "PaymentNotice", "recipient", element.getRecipient(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "PaymentNotice", "amount", element.getAmount(), -1);
        }
        if (element.hasPaymentStatus()) {
            this.composeCodeableConcept(t, "PaymentNotice", "paymentStatus", element.getPaymentStatus(), -1);
        }
    }

    protected void composePaymentReconciliation(Turtle.Complex parent, String parentType, String name, PaymentReconciliation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "PaymentReconciliation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PaymentReconciliation", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "PaymentReconciliation", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "PaymentReconciliation", "period", element.getPeriod(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "PaymentReconciliation", "created", element.getCreatedElement(), -1);
        }
        if (element.hasPaymentIssuer()) {
            this.composeReference(t, "PaymentReconciliation", "paymentIssuer", element.getPaymentIssuer(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "PaymentReconciliation", "request", element.getRequest(), -1);
        }
        if (element.hasRequestor()) {
            this.composeReference(t, "PaymentReconciliation", "requestor", element.getRequestor(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "PaymentReconciliation", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "PaymentReconciliation", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasPaymentDateElement()) {
            this.composeDate(t, "PaymentReconciliation", "paymentDate", element.getPaymentDateElement(), -1);
        }
        if (element.hasPaymentAmount()) {
            this.composeMoney(t, "PaymentReconciliation", "paymentAmount", element.getPaymentAmount(), -1);
        }
        if (element.hasPaymentIdentifier()) {
            this.composeIdentifier(t, "PaymentReconciliation", "paymentIdentifier", element.getPaymentIdentifier(), -1);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composePaymentReconciliationDetailsComponent(t, "PaymentReconciliation", "detail", element.getDetail().get(i), i);
        }
        if (element.hasFormCode()) {
            this.composeCodeableConcept(t, "PaymentReconciliation", "formCode", element.getFormCode(), -1);
        }
        for (i = 0; i < element.getProcessNote().size(); ++i) {
            this.composePaymentReconciliationNotesComponent(t, "PaymentReconciliation", "processNote", element.getProcessNote().get(i), i);
        }
    }

    protected void composePaymentReconciliationDetailsComponent(Turtle.Complex parent, String parentType, String name, PaymentReconciliation.DetailsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "DetailsComponent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasPredecessor()) {
            this.composeIdentifier(t, "DetailsComponent", "predecessor", element.getPredecessor(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DetailsComponent", "type", element.getType(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "DetailsComponent", "request", element.getRequest(), -1);
        }
        if (element.hasSubmitter()) {
            this.composeReference(t, "DetailsComponent", "submitter", element.getSubmitter(), -1);
        }
        if (element.hasResponse()) {
            this.composeReference(t, "DetailsComponent", "response", element.getResponse(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDate(t, "DetailsComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasResponsible()) {
            this.composeReference(t, "DetailsComponent", "responsible", element.getResponsible(), -1);
        }
        if (element.hasPayee()) {
            this.composeReference(t, "DetailsComponent", "payee", element.getPayee(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "DetailsComponent", "amount", element.getAmount(), -1);
        }
    }

    protected void composePaymentReconciliationNotesComponent(Turtle.Complex parent, String parentType, String name, PaymentReconciliation.NotesComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "processNote", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "NotesComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "NotesComponent", "text", element.getTextElement(), -1);
        }
    }

    protected void composePerson(Turtle.Complex parent, String parentType, String name, Person element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Person", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Person", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeHumanName(t, "Person", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Person", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "Person", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "Person", "birthDate", element.getBirthDateElement(), -1);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "Person", "address", element.getAddress().get(i), i);
        }
        if (element.hasPhoto()) {
            this.composeAttachment(t, "Person", "photo", element.getPhoto(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Person", "managingOrganization", element.getManagingOrganization(), -1);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Person", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composePersonLinkComponent(t, "Person", "link", element.getLink().get(i), i);
        }
    }

    protected void composePersonLinkComponent(Turtle.Complex parent, String parentType, String name, Person.PersonLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasTarget()) {
            this.composeReference(t, "PersonLinkComponent", "target", element.getTarget(), -1);
        }
        if (element.hasAssuranceElement()) {
            this.composeEnum(t, "PersonLinkComponent", "assurance", element.getAssuranceElement(), -1);
        }
    }

    protected void composePlanDefinition(Turtle.Complex parent, String parentType, String name, PlanDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "PlanDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "PlanDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PlanDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "PlanDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "PlanDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "PlanDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "PlanDefinition", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PlanDefinition", "type", element.getType(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "PlanDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "PlanDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "PlanDefinition", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "PlanDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "PlanDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "PlanDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "PlanDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "PlanDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "PlanDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "PlanDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "PlanDefinition", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "PlanDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "PlanDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "PlanDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "PlanDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "PlanDefinition", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "PlanDefinition", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "PlanDefinition", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "PlanDefinition", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "PlanDefinition", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "PlanDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeCanonical(t, "PlanDefinition", "library", element.getLibrary().get(i), i);
        }
        for (i = 0; i < element.getGoal().size(); ++i) {
            this.composePlanDefinitionGoalComponent(t, "PlanDefinition", "goal", element.getGoal().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composePlanDefinitionActionComponent(t, "PlanDefinition", "action", element.getAction().get(i), i);
        }
    }

    protected void composePlanDefinitionGoalComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionGoalComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "goal", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "PlanDefinitionGoalComponent", "category", element.getCategory(), -1);
        }
        if (element.hasDescription()) {
            this.composeCodeableConcept(t, "PlanDefinitionGoalComponent", "description", element.getDescription(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "PlanDefinitionGoalComponent", "priority", element.getPriority(), -1);
        }
        if (element.hasStart()) {
            this.composeCodeableConcept(t, "PlanDefinitionGoalComponent", "start", element.getStart(), -1);
        }
        for (i = 0; i < element.getAddresses().size(); ++i) {
            this.composeCodeableConcept(t, "PlanDefinitionGoalComponent", "addresses", element.getAddresses().get(i), i);
        }
        for (i = 0; i < element.getDocumentation().size(); ++i) {
            this.composeRelatedArtifact(t, "PlanDefinitionGoalComponent", "documentation", element.getDocumentation().get(i), i);
        }
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composePlanDefinitionGoalTargetComponent(t, "PlanDefinitionGoalComponent", "target", element.getTarget().get(i), i);
        }
    }

    protected void composePlanDefinitionGoalTargetComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionGoalTargetComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasMeasure()) {
            this.composeCodeableConcept(t, "PlanDefinitionGoalTargetComponent", "measure", element.getMeasure(), -1);
        }
        if (element.hasDetail()) {
            this.composeType(t, "PlanDefinitionGoalTargetComponent", "detail", element.getDetail(), -1);
        }
        if (element.hasDue()) {
            this.composeDuration(t, "PlanDefinitionGoalTargetComponent", "due", element.getDue(), -1);
        }
    }

    protected void composePlanDefinitionActionComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasPrefixElement()) {
            this.composeString(t, "PlanDefinitionActionComponent", "prefix", element.getPrefixElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "PlanDefinitionActionComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "PlanDefinitionActionComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTextEquivalentElement()) {
            this.composeString(t, "PlanDefinitionActionComponent", "textEquivalent", element.getTextEquivalentElement(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "PlanDefinitionActionComponent", "priority", element.getPriorityElement(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "PlanDefinitionActionComponent", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "PlanDefinitionActionComponent", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getDocumentation().size(); ++i) {
            this.composeRelatedArtifact(t, "PlanDefinitionActionComponent", "documentation", element.getDocumentation().get(i), i);
        }
        for (i = 0; i < element.getGoalId().size(); ++i) {
            this.composeId(t, "PlanDefinitionActionComponent", "goalId", element.getGoalId().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeType(t, "PlanDefinitionActionComponent", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getTrigger().size(); ++i) {
            this.composeTriggerDefinition(t, "PlanDefinitionActionComponent", "trigger", element.getTrigger().get(i), i);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composePlanDefinitionActionConditionComponent(t, "PlanDefinitionActionComponent", "condition", element.getCondition().get(i), i);
        }
        for (i = 0; i < element.getInput().size(); ++i) {
            this.composeDataRequirement(t, "PlanDefinitionActionComponent", "input", element.getInput().get(i), i);
        }
        for (i = 0; i < element.getOutput().size(); ++i) {
            this.composeDataRequirement(t, "PlanDefinitionActionComponent", "output", element.getOutput().get(i), i);
        }
        for (i = 0; i < element.getRelatedAction().size(); ++i) {
            this.composePlanDefinitionActionRelatedActionComponent(t, "PlanDefinitionActionComponent", "relatedAction", element.getRelatedAction().get(i), i);
        }
        if (element.hasTiming()) {
            this.composeType(t, "PlanDefinitionActionComponent", "timing", element.getTiming(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composePlanDefinitionActionParticipantComponent(t, "PlanDefinitionActionComponent", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PlanDefinitionActionComponent", "type", element.getType(), -1);
        }
        if (element.hasGroupingBehaviorElement()) {
            this.composeEnum(t, "PlanDefinitionActionComponent", "groupingBehavior", element.getGroupingBehaviorElement(), -1);
        }
        if (element.hasSelectionBehaviorElement()) {
            this.composeEnum(t, "PlanDefinitionActionComponent", "selectionBehavior", element.getSelectionBehaviorElement(), -1);
        }
        if (element.hasRequiredBehaviorElement()) {
            this.composeEnum(t, "PlanDefinitionActionComponent", "requiredBehavior", element.getRequiredBehaviorElement(), -1);
        }
        if (element.hasPrecheckBehaviorElement()) {
            this.composeEnum(t, "PlanDefinitionActionComponent", "precheckBehavior", element.getPrecheckBehaviorElement(), -1);
        }
        if (element.hasCardinalityBehaviorElement()) {
            this.composeEnum(t, "PlanDefinitionActionComponent", "cardinalityBehavior", element.getCardinalityBehaviorElement(), -1);
        }
        if (element.hasDefinition()) {
            this.composeType(t, "PlanDefinitionActionComponent", "definition", element.getDefinition(), -1);
        }
        if (element.hasTransformElement()) {
            this.composeCanonical(t, "PlanDefinitionActionComponent", "transform", element.getTransformElement(), -1);
        }
        for (i = 0; i < element.getDynamicValue().size(); ++i) {
            this.composePlanDefinitionActionDynamicValueComponent(t, "PlanDefinitionActionComponent", "dynamicValue", element.getDynamicValue().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composePlanDefinitionActionComponent(t, "PlanDefinitionActionComponent", "action", element.getAction().get(i), i);
        }
    }

    protected void composePlanDefinitionActionConditionComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionConditionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "condition", name, element, index);
        if (element.hasKindElement()) {
            this.composeEnum(t, "PlanDefinitionActionConditionComponent", "kind", element.getKindElement(), -1);
        }
        if (element.hasExpression()) {
            this.composeExpression(t, "PlanDefinitionActionConditionComponent", "expression", element.getExpression(), -1);
        }
    }

    protected void composePlanDefinitionActionRelatedActionComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionRelatedActionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatedAction", name, element, index);
        if (element.hasActionIdElement()) {
            this.composeId(t, "PlanDefinitionActionRelatedActionComponent", "actionId", element.getActionIdElement(), -1);
        }
        if (element.hasRelationshipElement()) {
            this.composeEnum(t, "PlanDefinitionActionRelatedActionComponent", "relationship", element.getRelationshipElement(), -1);
        }
        if (element.hasOffset()) {
            this.composeType(t, "PlanDefinitionActionRelatedActionComponent", "offset", element.getOffset(), -1);
        }
    }

    protected void composePlanDefinitionActionParticipantComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "PlanDefinitionActionParticipantComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "PlanDefinitionActionParticipantComponent", "role", element.getRole(), -1);
        }
    }

    protected void composePlanDefinitionActionDynamicValueComponent(Turtle.Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionDynamicValueComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dynamicValue", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "PlanDefinitionActionDynamicValueComponent", "path", element.getPathElement(), -1);
        }
        if (element.hasExpression()) {
            this.composeExpression(t, "PlanDefinitionActionDynamicValueComponent", "expression", element.getExpression(), -1);
        }
    }

    protected void composePractitioner(Turtle.Complex parent, String parentType, String name, Practitioner element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Practitioner", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Practitioner", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Practitioner", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeHumanName(t, "Practitioner", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Practitioner", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "Practitioner", "address", element.getAddress().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "Practitioner", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "Practitioner", "birthDate", element.getBirthDateElement(), -1);
        }
        for (i = 0; i < element.getPhoto().size(); ++i) {
            this.composeAttachment(t, "Practitioner", "photo", element.getPhoto().get(i), i);
        }
        for (i = 0; i < element.getQualification().size(); ++i) {
            this.composePractitionerQualificationComponent(t, "Practitioner", "qualification", element.getQualification().get(i), i);
        }
        for (i = 0; i < element.getCommunication().size(); ++i) {
            this.composeCodeableConcept(t, "Practitioner", "communication", element.getCommunication().get(i), i);
        }
    }

    protected void composePractitionerQualificationComponent(Turtle.Complex parent, String parentType, String name, Practitioner.PractitionerQualificationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "qualification", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PractitionerQualificationComponent", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "PractitionerQualificationComponent", "code", element.getCode(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "PractitionerQualificationComponent", "period", element.getPeriod(), -1);
        }
        if (element.hasIssuer()) {
            this.composeReference(t, "PractitionerQualificationComponent", "issuer", element.getIssuer(), -1);
        }
    }

    protected void composePractitionerRole(Turtle.Complex parent, String parentType, String name, PractitionerRole element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "PractitionerRole", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PractitionerRole", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "PractitionerRole", "active", element.getActiveElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "PractitionerRole", "period", element.getPeriod(), -1);
        }
        if (element.hasPractitioner()) {
            this.composeReference(t, "PractitionerRole", "practitioner", element.getPractitioner(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "PractitionerRole", "organization", element.getOrganization(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "PractitionerRole", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "PractitionerRole", "specialty", element.getSpecialty().get(i), i);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeReference(t, "PractitionerRole", "location", element.getLocation().get(i), i);
        }
        for (i = 0; i < element.getHealthcareService().size(); ++i) {
            this.composeReference(t, "PractitionerRole", "healthcareService", element.getHealthcareService().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "PractitionerRole", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getAvailableTime().size(); ++i) {
            this.composePractitionerRoleAvailableTimeComponent(t, "PractitionerRole", "availableTime", element.getAvailableTime().get(i), i);
        }
        for (i = 0; i < element.getNotAvailable().size(); ++i) {
            this.composePractitionerRoleNotAvailableComponent(t, "PractitionerRole", "notAvailable", element.getNotAvailable().get(i), i);
        }
        if (element.hasAvailabilityExceptionsElement()) {
            this.composeString(t, "PractitionerRole", "availabilityExceptions", element.getAvailabilityExceptionsElement(), -1);
        }
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeReference(t, "PractitionerRole", "endpoint", element.getEndpoint().get(i), i);
        }
    }

    protected void composePractitionerRoleAvailableTimeComponent(Turtle.Complex parent, String parentType, String name, PractitionerRole.PractitionerRoleAvailableTimeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "availableTime", name, element, index);
        for (int i = 0; i < element.getDaysOfWeek().size(); ++i) {
            this.composeEnum(t, "PractitionerRoleAvailableTimeComponent", "daysOfWeek", element.getDaysOfWeek().get(i), i);
        }
        if (element.hasAllDayElement()) {
            this.composeBoolean(t, "PractitionerRoleAvailableTimeComponent", "allDay", element.getAllDayElement(), -1);
        }
        if (element.hasAvailableStartTimeElement()) {
            this.composeTime(t, "PractitionerRoleAvailableTimeComponent", "availableStartTime", element.getAvailableStartTimeElement(), -1);
        }
        if (element.hasAvailableEndTimeElement()) {
            this.composeTime(t, "PractitionerRoleAvailableTimeComponent", "availableEndTime", element.getAvailableEndTimeElement(), -1);
        }
    }

    protected void composePractitionerRoleNotAvailableComponent(Turtle.Complex parent, String parentType, String name, PractitionerRole.PractitionerRoleNotAvailableComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "notAvailable", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "PractitionerRoleNotAvailableComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasDuring()) {
            this.composePeriod(t, "PractitionerRoleNotAvailableComponent", "during", element.getDuring(), -1);
        }
    }

    protected void composeProcedure(Turtle.Complex parent, String parentType, String name, Procedure element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Procedure", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Procedure", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "Procedure", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "Procedure", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "Procedure", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "Procedure", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Procedure", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "Procedure", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "Procedure", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Procedure", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Procedure", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Procedure", "encounter", element.getEncounter(), -1);
        }
        if (element.hasPerformed()) {
            this.composeType(t, "Procedure", "performed", element.getPerformed(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "Procedure", "recorder", element.getRecorder(), -1);
        }
        if (element.hasAsserter()) {
            this.composeReference(t, "Procedure", "asserter", element.getAsserter(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeProcedurePerformerComponent(t, "Procedure", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Procedure", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "Procedure", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getBodySite().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "bodySite", element.getBodySite().get(i), i);
        }
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "Procedure", "outcome", element.getOutcome(), -1);
        }
        for (i = 0; i < element.getReport().size(); ++i) {
            this.composeReference(t, "Procedure", "report", element.getReport().get(i), i);
        }
        for (i = 0; i < element.getComplication().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "complication", element.getComplication().get(i), i);
        }
        for (i = 0; i < element.getComplicationDetail().size(); ++i) {
            this.composeReference(t, "Procedure", "complicationDetail", element.getComplicationDetail().get(i), i);
        }
        for (i = 0; i < element.getFollowUp().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "followUp", element.getFollowUp().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Procedure", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getFocalDevice().size(); ++i) {
            this.composeProcedureFocalDeviceComponent(t, "Procedure", "focalDevice", element.getFocalDevice().get(i), i);
        }
        for (i = 0; i < element.getUsedReference().size(); ++i) {
            this.composeReference(t, "Procedure", "usedReference", element.getUsedReference().get(i), i);
        }
        for (i = 0; i < element.getUsedCode().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "usedCode", element.getUsedCode().get(i), i);
        }
    }

    protected void composeProcedurePerformerComponent(Turtle.Complex parent, String parentType, String name, Procedure.ProcedurePerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "ProcedurePerformerComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "ProcedurePerformerComponent", "actor", element.getActor(), -1);
        }
        if (element.hasOnBehalfOf()) {
            this.composeReference(t, "ProcedurePerformerComponent", "onBehalfOf", element.getOnBehalfOf(), -1);
        }
    }

    protected void composeProcedureFocalDeviceComponent(Turtle.Complex parent, String parentType, String name, Procedure.ProcedureFocalDeviceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "focalDevice", name, element, index);
        if (element.hasAction()) {
            this.composeCodeableConcept(t, "ProcedureFocalDeviceComponent", "action", element.getAction(), -1);
        }
        if (element.hasManipulated()) {
            this.composeReference(t, "ProcedureFocalDeviceComponent", "manipulated", element.getManipulated(), -1);
        }
    }

    protected void composeProvenance(Turtle.Complex parent, String parentType, String name, Provenance element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Provenance", name, element, index);
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeReference(t, "Provenance", "target", element.getTarget().get(i), i);
        }
        if (element.hasOccurred()) {
            this.composeType(t, "Provenance", "occurred", element.getOccurred(), -1);
        }
        if (element.hasRecordedElement()) {
            this.composeInstant(t, "Provenance", "recorded", element.getRecordedElement(), -1);
        }
        for (i = 0; i < element.getPolicy().size(); ++i) {
            this.composeUri(t, "Provenance", "policy", element.getPolicy().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Provenance", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "Provenance", "reason", element.getReason().get(i), i);
        }
        if (element.hasActivity()) {
            this.composeCodeableConcept(t, "Provenance", "activity", element.getActivity(), -1);
        }
        for (i = 0; i < element.getAgent().size(); ++i) {
            this.composeProvenanceAgentComponent(t, "Provenance", "agent", element.getAgent().get(i), i);
        }
        for (i = 0; i < element.getEntity().size(); ++i) {
            this.composeProvenanceEntityComponent(t, "Provenance", "entity", element.getEntity().get(i), i);
        }
        for (i = 0; i < element.getSignature().size(); ++i) {
            this.composeSignature(t, "Provenance", "signature", element.getSignature().get(i), i);
        }
    }

    protected void composeProvenanceAgentComponent(Turtle.Complex parent, String parentType, String name, Provenance.ProvenanceAgentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "agent", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ProvenanceAgentComponent", "type", element.getType(), -1);
        }
        for (int i = 0; i < element.getRole().size(); ++i) {
            this.composeCodeableConcept(t, "ProvenanceAgentComponent", "role", element.getRole().get(i), i);
        }
        if (element.hasWho()) {
            this.composeReference(t, "ProvenanceAgentComponent", "who", element.getWho(), -1);
        }
        if (element.hasOnBehalfOf()) {
            this.composeReference(t, "ProvenanceAgentComponent", "onBehalfOf", element.getOnBehalfOf(), -1);
        }
    }

    protected void composeProvenanceEntityComponent(Turtle.Complex parent, String parentType, String name, Provenance.ProvenanceEntityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entity", name, element, index);
        if (element.hasRoleElement()) {
            this.composeEnum(t, "ProvenanceEntityComponent", "role", element.getRoleElement(), -1);
        }
        if (element.hasWhat()) {
            this.composeReference(t, "ProvenanceEntityComponent", "what", element.getWhat(), -1);
        }
        for (int i = 0; i < element.getAgent().size(); ++i) {
            this.composeProvenanceAgentComponent(t, "ProvenanceEntityComponent", "agent", element.getAgent().get(i), i);
        }
    }

    protected void composeQuestionnaire(Turtle.Complex parent, String parentType, String name, Questionnaire element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Questionnaire", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Questionnaire", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Questionnaire", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Questionnaire", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Questionnaire", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Questionnaire", "title", element.getTitleElement(), -1);
        }
        for (i = 0; i < element.getDerivedFrom().size(); ++i) {
            this.composeCanonical(t, "Questionnaire", "derivedFrom", element.getDerivedFrom().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Questionnaire", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "Questionnaire", "experimental", element.getExperimentalElement(), -1);
        }
        for (i = 0; i < element.getSubjectType().size(); ++i) {
            this.composeCode(t, "Questionnaire", "subjectType", element.getSubjectType().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Questionnaire", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Questionnaire", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "Questionnaire", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Questionnaire", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "Questionnaire", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "Questionnaire", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "Questionnaire", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "Questionnaire", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "Questionnaire", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "Questionnaire", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "Questionnaire", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCoding(t, "Questionnaire", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireItemComponent(t, "Questionnaire", "item", element.getItem().get(i), i);
        }
    }

    protected void composeQuestionnaireItemComponent(Turtle.Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasLinkIdElement()) {
            this.composeString(t, "QuestionnaireItemComponent", "linkId", element.getLinkIdElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeUri(t, "QuestionnaireItemComponent", "definition", element.getDefinitionElement(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCoding(t, "QuestionnaireItemComponent", "code", element.getCode().get(i), i);
        }
        if (element.hasPrefixElement()) {
            this.composeString(t, "QuestionnaireItemComponent", "prefix", element.getPrefixElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "QuestionnaireItemComponent", "text", element.getTextElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "QuestionnaireItemComponent", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getEnableWhen().size(); ++i) {
            this.composeQuestionnaireItemEnableWhenComponent(t, "QuestionnaireItemComponent", "enableWhen", element.getEnableWhen().get(i), i);
        }
        if (element.hasEnableBehaviorElement()) {
            this.composeEnum(t, "QuestionnaireItemComponent", "enableBehavior", element.getEnableBehaviorElement(), -1);
        }
        if (element.hasRequiredElement()) {
            this.composeBoolean(t, "QuestionnaireItemComponent", "required", element.getRequiredElement(), -1);
        }
        if (element.hasRepeatsElement()) {
            this.composeBoolean(t, "QuestionnaireItemComponent", "repeats", element.getRepeatsElement(), -1);
        }
        if (element.hasReadOnlyElement()) {
            this.composeBoolean(t, "QuestionnaireItemComponent", "readOnly", element.getReadOnlyElement(), -1);
        }
        if (element.hasMaxLengthElement()) {
            this.composeInteger(t, "QuestionnaireItemComponent", "maxLength", element.getMaxLengthElement(), -1);
        }
        if (element.hasAnswerValueSetElement()) {
            this.composeCanonical(t, "QuestionnaireItemComponent", "answerValueSet", element.getAnswerValueSetElement(), -1);
        }
        for (i = 0; i < element.getAnswerOption().size(); ++i) {
            this.composeQuestionnaireItemAnswerOptionComponent(t, "QuestionnaireItemComponent", "answerOption", element.getAnswerOption().get(i), i);
        }
        for (i = 0; i < element.getInitial().size(); ++i) {
            this.composeQuestionnaireItemInitialComponent(t, "QuestionnaireItemComponent", "initial", element.getInitial().get(i), i);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireItemComponent(t, "QuestionnaireItemComponent", "item", element.getItem().get(i), i);
        }
    }

    protected void composeQuestionnaireItemEnableWhenComponent(Turtle.Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemEnableWhenComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "enableWhen", name, element, index);
        if (element.hasQuestionElement()) {
            this.composeString(t, "QuestionnaireItemEnableWhenComponent", "question", element.getQuestionElement(), -1);
        }
        if (element.hasOperatorElement()) {
            this.composeEnum(t, "QuestionnaireItemEnableWhenComponent", "operator", element.getOperatorElement(), -1);
        }
        if (element.hasAnswer()) {
            this.composeType(t, "QuestionnaireItemEnableWhenComponent", "answer", element.getAnswer(), -1);
        }
    }

    protected void composeQuestionnaireItemAnswerOptionComponent(Turtle.Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemAnswerOptionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "answerOption", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "QuestionnaireItemAnswerOptionComponent", "value", element.getValue(), -1);
        }
        if (element.hasInitialSelectedElement()) {
            this.composeBoolean(t, "QuestionnaireItemAnswerOptionComponent", "initialSelected", element.getInitialSelectedElement(), -1);
        }
    }

    protected void composeQuestionnaireItemInitialComponent(Turtle.Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemInitialComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "initial", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "QuestionnaireItemInitialComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeQuestionnaireResponse(Turtle.Complex parent, String parentType, String name, QuestionnaireResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "QuestionnaireResponse", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "QuestionnaireResponse", "identifier", element.getIdentifier(), -1);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "QuestionnaireResponse", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "QuestionnaireResponse", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasQuestionnaireElement()) {
            this.composeCanonical(t, "QuestionnaireResponse", "questionnaire", element.getQuestionnaireElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "QuestionnaireResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "QuestionnaireResponse", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "QuestionnaireResponse", "encounter", element.getEncounter(), -1);
        }
        if (element.hasAuthoredElement()) {
            this.composeDateTime(t, "QuestionnaireResponse", "authored", element.getAuthoredElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "QuestionnaireResponse", "author", element.getAuthor(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "QuestionnaireResponse", "source", element.getSource(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireResponseItemComponent(t, "QuestionnaireResponse", "item", element.getItem().get(i), i);
        }
    }

    protected void composeQuestionnaireResponseItemComponent(Turtle.Complex parent, String parentType, String name, QuestionnaireResponse.QuestionnaireResponseItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasLinkIdElement()) {
            this.composeString(t, "QuestionnaireResponseItemComponent", "linkId", element.getLinkIdElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeUri(t, "QuestionnaireResponseItemComponent", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "QuestionnaireResponseItemComponent", "text", element.getTextElement(), -1);
        }
        for (i = 0; i < element.getAnswer().size(); ++i) {
            this.composeQuestionnaireResponseItemAnswerComponent(t, "QuestionnaireResponseItemComponent", "answer", element.getAnswer().get(i), i);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireResponseItemComponent(t, "QuestionnaireResponseItemComponent", "item", element.getItem().get(i), i);
        }
    }

    protected void composeQuestionnaireResponseItemAnswerComponent(Turtle.Complex parent, String parentType, String name, QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "answer", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "QuestionnaireResponseItemAnswerComponent", "value", element.getValue(), -1);
        }
        for (int i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireResponseItemComponent(t, "QuestionnaireResponseItemAnswerComponent", "item", element.getItem().get(i), i);
        }
    }

    protected void composeRegulatedAuthorization(Turtle.Complex parent, String parentType, String name, RegulatedAuthorization element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "RegulatedAuthorization", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "RegulatedAuthorization", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getSubject().size(); ++i) {
            this.composeReference(t, "RegulatedAuthorization", "subject", element.getSubject().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "RegulatedAuthorization", "type", element.getType(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "RegulatedAuthorization", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getRegion().size(); ++i) {
            this.composeCodeableConcept(t, "RegulatedAuthorization", "region", element.getRegion().get(i), i);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "RegulatedAuthorization", "status", element.getStatus(), -1);
        }
        if (element.hasStatusDateElement()) {
            this.composeDateTime(t, "RegulatedAuthorization", "statusDate", element.getStatusDateElement(), -1);
        }
        if (element.hasValidityPeriod()) {
            this.composePeriod(t, "RegulatedAuthorization", "validityPeriod", element.getValidityPeriod(), -1);
        }
        if (element.hasIndication()) {
            this.composeCodeableReference(t, "RegulatedAuthorization", "indication", element.getIndication(), -1);
        }
        if (element.hasIntendedUse()) {
            this.composeCodeableConcept(t, "RegulatedAuthorization", "intendedUse", element.getIntendedUse(), -1);
        }
        for (i = 0; i < element.getBasis().size(); ++i) {
            this.composeCodeableConcept(t, "RegulatedAuthorization", "basis", element.getBasis().get(i), i);
        }
        if (element.hasHolder()) {
            this.composeReference(t, "RegulatedAuthorization", "holder", element.getHolder(), -1);
        }
        if (element.hasRegulator()) {
            this.composeReference(t, "RegulatedAuthorization", "regulator", element.getRegulator(), -1);
        }
        if (element.hasCase()) {
            this.composeRegulatedAuthorizationCaseComponent(t, "RegulatedAuthorization", "case", element.getCase(), -1);
        }
    }

    protected void composeRegulatedAuthorizationCaseComponent(Turtle.Complex parent, String parentType, String name, RegulatedAuthorization.RegulatedAuthorizationCaseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "case", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "RegulatedAuthorizationCaseComponent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "RegulatedAuthorizationCaseComponent", "type", element.getType(), -1);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "RegulatedAuthorizationCaseComponent", "status", element.getStatus(), -1);
        }
        if (element.hasDate()) {
            this.composeType(t, "RegulatedAuthorizationCaseComponent", "date", element.getDate(), -1);
        }
        for (int i = 0; i < element.getApplication().size(); ++i) {
            this.composeRegulatedAuthorizationCaseComponent(t, "RegulatedAuthorizationCaseComponent", "application", element.getApplication().get(i), i);
        }
    }

    protected void composeRelatedPerson(Turtle.Complex parent, String parentType, String name, RelatedPerson element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "RelatedPerson", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "RelatedPerson", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "RelatedPerson", "active", element.getActiveElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "RelatedPerson", "patient", element.getPatient(), -1);
        }
        for (i = 0; i < element.getRelationship().size(); ++i) {
            this.composeCodeableConcept(t, "RelatedPerson", "relationship", element.getRelationship().get(i), i);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeHumanName(t, "RelatedPerson", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "RelatedPerson", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "RelatedPerson", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "RelatedPerson", "birthDate", element.getBirthDateElement(), -1);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "RelatedPerson", "address", element.getAddress().get(i), i);
        }
        for (i = 0; i < element.getPhoto().size(); ++i) {
            this.composeAttachment(t, "RelatedPerson", "photo", element.getPhoto().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "RelatedPerson", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getCommunication().size(); ++i) {
            this.composeRelatedPersonCommunicationComponent(t, "RelatedPerson", "communication", element.getCommunication().get(i), i);
        }
    }

    protected void composeRelatedPersonCommunicationComponent(Turtle.Complex parent, String parentType, String name, RelatedPerson.RelatedPersonCommunicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "communication", name, element, index);
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "RelatedPersonCommunicationComponent", "language", element.getLanguage(), -1);
        }
        if (element.hasPreferredElement()) {
            this.composeBoolean(t, "RelatedPersonCommunicationComponent", "preferred", element.getPreferredElement(), -1);
        }
    }

    protected void composeRequestGroup(Turtle.Complex parent, String parentType, String name, RequestGroup element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "RequestGroup", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "RequestGroup", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "RequestGroup", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "RequestGroup", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "RequestGroup", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeReference(t, "RequestGroup", "replaces", element.getReplaces().get(i), i);
        }
        if (element.hasGroupIdentifier()) {
            this.composeIdentifier(t, "RequestGroup", "groupIdentifier", element.getGroupIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "RequestGroup", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "RequestGroup", "intent", element.getIntentElement(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "RequestGroup", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "RequestGroup", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "RequestGroup", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "RequestGroup", "encounter", element.getEncounter(), -1);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "RequestGroup", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "RequestGroup", "author", element.getAuthor(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "RequestGroup", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "RequestGroup", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "RequestGroup", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeRequestGroupActionComponent(t, "RequestGroup", "action", element.getAction().get(i), i);
        }
    }

    protected void composeRequestGroupActionComponent(Turtle.Complex parent, String parentType, String name, RequestGroup.RequestGroupActionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasPrefixElement()) {
            this.composeString(t, "RequestGroupActionComponent", "prefix", element.getPrefixElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "RequestGroupActionComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "RequestGroupActionComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTextEquivalentElement()) {
            this.composeString(t, "RequestGroupActionComponent", "textEquivalent", element.getTextEquivalentElement(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "RequestGroupActionComponent", "priority", element.getPriorityElement(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "RequestGroupActionComponent", "code", element.getCode().get(i), i);
        }
        for (i = 0; i < element.getDocumentation().size(); ++i) {
            this.composeRelatedArtifact(t, "RequestGroupActionComponent", "documentation", element.getDocumentation().get(i), i);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeRequestGroupActionConditionComponent(t, "RequestGroupActionComponent", "condition", element.getCondition().get(i), i);
        }
        for (i = 0; i < element.getRelatedAction().size(); ++i) {
            this.composeRequestGroupActionRelatedActionComponent(t, "RequestGroupActionComponent", "relatedAction", element.getRelatedAction().get(i), i);
        }
        if (element.hasTiming()) {
            this.composeType(t, "RequestGroupActionComponent", "timing", element.getTiming(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeReference(t, "RequestGroupActionComponent", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "RequestGroupActionComponent", "type", element.getType(), -1);
        }
        if (element.hasGroupingBehaviorElement()) {
            this.composeEnum(t, "RequestGroupActionComponent", "groupingBehavior", element.getGroupingBehaviorElement(), -1);
        }
        if (element.hasSelectionBehaviorElement()) {
            this.composeEnum(t, "RequestGroupActionComponent", "selectionBehavior", element.getSelectionBehaviorElement(), -1);
        }
        if (element.hasRequiredBehaviorElement()) {
            this.composeEnum(t, "RequestGroupActionComponent", "requiredBehavior", element.getRequiredBehaviorElement(), -1);
        }
        if (element.hasPrecheckBehaviorElement()) {
            this.composeEnum(t, "RequestGroupActionComponent", "precheckBehavior", element.getPrecheckBehaviorElement(), -1);
        }
        if (element.hasCardinalityBehaviorElement()) {
            this.composeEnum(t, "RequestGroupActionComponent", "cardinalityBehavior", element.getCardinalityBehaviorElement(), -1);
        }
        if (element.hasResource()) {
            this.composeReference(t, "RequestGroupActionComponent", "resource", element.getResource(), -1);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeRequestGroupActionComponent(t, "RequestGroupActionComponent", "action", element.getAction().get(i), i);
        }
    }

    protected void composeRequestGroupActionConditionComponent(Turtle.Complex parent, String parentType, String name, RequestGroup.RequestGroupActionConditionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "condition", name, element, index);
        if (element.hasKindElement()) {
            this.composeEnum(t, "RequestGroupActionConditionComponent", "kind", element.getKindElement(), -1);
        }
        if (element.hasExpression()) {
            this.composeExpression(t, "RequestGroupActionConditionComponent", "expression", element.getExpression(), -1);
        }
    }

    protected void composeRequestGroupActionRelatedActionComponent(Turtle.Complex parent, String parentType, String name, RequestGroup.RequestGroupActionRelatedActionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatedAction", name, element, index);
        if (element.hasActionIdElement()) {
            this.composeId(t, "RequestGroupActionRelatedActionComponent", "actionId", element.getActionIdElement(), -1);
        }
        if (element.hasRelationshipElement()) {
            this.composeEnum(t, "RequestGroupActionRelatedActionComponent", "relationship", element.getRelationshipElement(), -1);
        }
        if (element.hasOffset()) {
            this.composeType(t, "RequestGroupActionRelatedActionComponent", "offset", element.getOffset(), -1);
        }
    }

    protected void composeResearchDefinition(Turtle.Complex parent, String parentType, String name, ResearchDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ResearchDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ResearchDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ResearchDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ResearchDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ResearchDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ResearchDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasShortTitleElement()) {
            this.composeString(t, "ResearchDefinition", "shortTitle", element.getShortTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "ResearchDefinition", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ResearchDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ResearchDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "ResearchDefinition", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ResearchDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ResearchDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ResearchDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ResearchDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getComment().size(); ++i) {
            this.composeString(t, "ResearchDefinition", "comment", element.getComment().get(i), i);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ResearchDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ResearchDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "ResearchDefinition", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ResearchDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "ResearchDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "ResearchDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "ResearchDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchDefinition", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "ResearchDefinition", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "ResearchDefinition", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "ResearchDefinition", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "ResearchDefinition", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "ResearchDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeCanonical(t, "ResearchDefinition", "library", element.getLibrary().get(i), i);
        }
        if (element.hasPopulation()) {
            this.composeReference(t, "ResearchDefinition", "population", element.getPopulation(), -1);
        }
        if (element.hasExposure()) {
            this.composeReference(t, "ResearchDefinition", "exposure", element.getExposure(), -1);
        }
        if (element.hasExposureAlternative()) {
            this.composeReference(t, "ResearchDefinition", "exposureAlternative", element.getExposureAlternative(), -1);
        }
        if (element.hasOutcome()) {
            this.composeReference(t, "ResearchDefinition", "outcome", element.getOutcome(), -1);
        }
    }

    protected void composeResearchElementDefinition(Turtle.Complex parent, String parentType, String name, ResearchElementDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ResearchElementDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ResearchElementDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ResearchElementDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ResearchElementDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ResearchElementDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ResearchElementDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasShortTitleElement()) {
            this.composeString(t, "ResearchElementDefinition", "shortTitle", element.getShortTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "ResearchElementDefinition", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ResearchElementDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ResearchElementDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "ResearchElementDefinition", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ResearchElementDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ResearchElementDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ResearchElementDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ResearchElementDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getComment().size(); ++i) {
            this.composeString(t, "ResearchElementDefinition", "comment", element.getComment().get(i), i);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "ResearchElementDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchElementDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ResearchElementDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "ResearchElementDefinition", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ResearchElementDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "ResearchElementDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "ResearchElementDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "ResearchElementDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchElementDefinition", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeContactDetail(t, "ResearchElementDefinition", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getEditor().size(); ++i) {
            this.composeContactDetail(t, "ResearchElementDefinition", "editor", element.getEditor().get(i), i);
        }
        for (i = 0; i < element.getReviewer().size(); ++i) {
            this.composeContactDetail(t, "ResearchElementDefinition", "reviewer", element.getReviewer().get(i), i);
        }
        for (i = 0; i < element.getEndorser().size(); ++i) {
            this.composeContactDetail(t, "ResearchElementDefinition", "endorser", element.getEndorser().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "ResearchElementDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeCanonical(t, "ResearchElementDefinition", "library", element.getLibrary().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ResearchElementDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasVariableTypeElement()) {
            this.composeEnum(t, "ResearchElementDefinition", "variableType", element.getVariableTypeElement(), -1);
        }
        for (i = 0; i < element.getCharacteristic().size(); ++i) {
            this.composeResearchElementDefinitionCharacteristicComponent(t, "ResearchElementDefinition", "characteristic", element.getCharacteristic().get(i), i);
        }
    }

    protected void composeResearchElementDefinitionCharacteristicComponent(Turtle.Complex parent, String parentType, String name, ResearchElementDefinition.ResearchElementDefinitionCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "characteristic", name, element, index);
        if (element.hasDefinition()) {
            this.composeType(t, "ResearchElementDefinitionCharacteristicComponent", "definition", element.getDefinition(), -1);
        }
        for (int i = 0; i < element.getUsageContext().size(); ++i) {
            this.composeUsageContext(t, "ResearchElementDefinitionCharacteristicComponent", "usageContext", element.getUsageContext().get(i), i);
        }
        if (element.hasExcludeElement()) {
            this.composeBoolean(t, "ResearchElementDefinitionCharacteristicComponent", "exclude", element.getExcludeElement(), -1);
        }
        if (element.hasUnitOfMeasure()) {
            this.composeCodeableConcept(t, "ResearchElementDefinitionCharacteristicComponent", "unitOfMeasure", element.getUnitOfMeasure(), -1);
        }
        if (element.hasStudyEffectiveDescriptionElement()) {
            this.composeString(t, "ResearchElementDefinitionCharacteristicComponent", "studyEffectiveDescription", element.getStudyEffectiveDescriptionElement(), -1);
        }
        if (element.hasStudyEffective()) {
            this.composeType(t, "ResearchElementDefinitionCharacteristicComponent", "studyEffective", element.getStudyEffective(), -1);
        }
        if (element.hasStudyEffectiveTimeFromStart()) {
            this.composeDuration(t, "ResearchElementDefinitionCharacteristicComponent", "studyEffectiveTimeFromStart", element.getStudyEffectiveTimeFromStart(), -1);
        }
        if (element.hasStudyEffectiveGroupMeasureElement()) {
            this.composeEnum(t, "ResearchElementDefinitionCharacteristicComponent", "studyEffectiveGroupMeasure", element.getStudyEffectiveGroupMeasureElement(), -1);
        }
        if (element.hasParticipantEffectiveDescriptionElement()) {
            this.composeString(t, "ResearchElementDefinitionCharacteristicComponent", "participantEffectiveDescription", element.getParticipantEffectiveDescriptionElement(), -1);
        }
        if (element.hasParticipantEffective()) {
            this.composeType(t, "ResearchElementDefinitionCharacteristicComponent", "participantEffective", element.getParticipantEffective(), -1);
        }
        if (element.hasParticipantEffectiveTimeFromStart()) {
            this.composeDuration(t, "ResearchElementDefinitionCharacteristicComponent", "participantEffectiveTimeFromStart", element.getParticipantEffectiveTimeFromStart(), -1);
        }
        if (element.hasParticipantEffectiveGroupMeasureElement()) {
            this.composeEnum(t, "ResearchElementDefinitionCharacteristicComponent", "participantEffectiveGroupMeasure", element.getParticipantEffectiveGroupMeasureElement(), -1);
        }
    }

    protected void composeResearchStudy(Turtle.Complex parent, String parentType, String name, ResearchStudy element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ResearchStudy", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ResearchStudy", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ResearchStudy", "title", element.getTitleElement(), -1);
        }
        for (i = 0; i < element.getProtocol().size(); ++i) {
            this.composeReference(t, "ResearchStudy", "protocol", element.getProtocol().get(i), i);
        }
        for (i = 0; i < element.getPartOf().size(); ++i) {
            this.composeReference(t, "ResearchStudy", "partOf", element.getPartOf().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ResearchStudy", "status", element.getStatusElement(), -1);
        }
        if (element.hasPrimaryPurposeType()) {
            this.composeCodeableConcept(t, "ResearchStudy", "primaryPurposeType", element.getPrimaryPurposeType(), -1);
        }
        if (element.hasPhase()) {
            this.composeCodeableConcept(t, "ResearchStudy", "phase", element.getPhase(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchStudy", "category", element.getCategory().get(i), i);
        }
        for (i = 0; i < element.getFocus().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchStudy", "focus", element.getFocus().get(i), i);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchStudy", "condition", element.getCondition().get(i), i);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "ResearchStudy", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getRelatedArtifact().size(); ++i) {
            this.composeRelatedArtifact(t, "ResearchStudy", "relatedArtifact", element.getRelatedArtifact().get(i), i);
        }
        for (i = 0; i < element.getKeyword().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchStudy", "keyword", element.getKeyword().get(i), i);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeCodeableConcept(t, "ResearchStudy", "location", element.getLocation().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ResearchStudy", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getEnrollment().size(); ++i) {
            this.composeReference(t, "ResearchStudy", "enrollment", element.getEnrollment().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ResearchStudy", "period", element.getPeriod(), -1);
        }
        if (element.hasSponsor()) {
            this.composeReference(t, "ResearchStudy", "sponsor", element.getSponsor(), -1);
        }
        if (element.hasPrincipalInvestigator()) {
            this.composeReference(t, "ResearchStudy", "principalInvestigator", element.getPrincipalInvestigator(), -1);
        }
        for (i = 0; i < element.getSite().size(); ++i) {
            this.composeReference(t, "ResearchStudy", "site", element.getSite().get(i), i);
        }
        if (element.hasReasonStopped()) {
            this.composeCodeableConcept(t, "ResearchStudy", "reasonStopped", element.getReasonStopped(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ResearchStudy", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getArm().size(); ++i) {
            this.composeResearchStudyArmComponent(t, "ResearchStudy", "arm", element.getArm().get(i), i);
        }
        for (i = 0; i < element.getObjective().size(); ++i) {
            this.composeResearchStudyObjectiveComponent(t, "ResearchStudy", "objective", element.getObjective().get(i), i);
        }
    }

    protected void composeResearchStudyArmComponent(Turtle.Complex parent, String parentType, String name, ResearchStudy.ResearchStudyArmComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "arm", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ResearchStudyArmComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ResearchStudyArmComponent", "type", element.getType(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ResearchStudyArmComponent", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeResearchStudyObjectiveComponent(Turtle.Complex parent, String parentType, String name, ResearchStudy.ResearchStudyObjectiveComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "objective", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ResearchStudyObjectiveComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ResearchStudyObjectiveComponent", "type", element.getType(), -1);
        }
    }

    protected void composeResearchSubject(Turtle.Complex parent, String parentType, String name, ResearchSubject element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ResearchSubject", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ResearchSubject", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ResearchSubject", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ResearchSubject", "period", element.getPeriod(), -1);
        }
        if (element.hasStudy()) {
            this.composeReference(t, "ResearchSubject", "study", element.getStudy(), -1);
        }
        if (element.hasIndividual()) {
            this.composeReference(t, "ResearchSubject", "individual", element.getIndividual(), -1);
        }
        if (element.hasAssignedArmElement()) {
            this.composeString(t, "ResearchSubject", "assignedArm", element.getAssignedArmElement(), -1);
        }
        if (element.hasActualArmElement()) {
            this.composeString(t, "ResearchSubject", "actualArm", element.getActualArmElement(), -1);
        }
        if (element.hasConsent()) {
            this.composeReference(t, "ResearchSubject", "consent", element.getConsent(), -1);
        }
    }

    protected void composeRiskAssessment(Turtle.Complex parent, String parentType, String name, RiskAssessment element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "RiskAssessment", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "RiskAssessment", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasBasedOn()) {
            this.composeReference(t, "RiskAssessment", "basedOn", element.getBasedOn(), -1);
        }
        if (element.hasParent()) {
            this.composeReference(t, "RiskAssessment", "parent", element.getParent(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "RiskAssessment", "status", element.getStatusElement(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "RiskAssessment", "method", element.getMethod(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "RiskAssessment", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "RiskAssessment", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "RiskAssessment", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "RiskAssessment", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasCondition()) {
            this.composeReference(t, "RiskAssessment", "condition", element.getCondition(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "RiskAssessment", "performer", element.getPerformer(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "RiskAssessment", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "RiskAssessment", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getBasis().size(); ++i) {
            this.composeReference(t, "RiskAssessment", "basis", element.getBasis().get(i), i);
        }
        for (i = 0; i < element.getPrediction().size(); ++i) {
            this.composeRiskAssessmentPredictionComponent(t, "RiskAssessment", "prediction", element.getPrediction().get(i), i);
        }
        if (element.hasMitigationElement()) {
            this.composeString(t, "RiskAssessment", "mitigation", element.getMitigationElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "RiskAssessment", "note", element.getNote().get(i), i);
        }
    }

    protected void composeRiskAssessmentPredictionComponent(Turtle.Complex parent, String parentType, String name, RiskAssessment.RiskAssessmentPredictionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "prediction", name, element, index);
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "RiskAssessmentPredictionComponent", "outcome", element.getOutcome(), -1);
        }
        if (element.hasProbability()) {
            this.composeType(t, "RiskAssessmentPredictionComponent", "probability", element.getProbability(), -1);
        }
        if (element.hasQualitativeRisk()) {
            this.composeCodeableConcept(t, "RiskAssessmentPredictionComponent", "qualitativeRisk", element.getQualitativeRisk(), -1);
        }
        if (element.hasRelativeRiskElement()) {
            this.composeDecimal(t, "RiskAssessmentPredictionComponent", "relativeRisk", element.getRelativeRiskElement(), -1);
        }
        if (element.hasWhen()) {
            this.composeType(t, "RiskAssessmentPredictionComponent", "when", element.getWhen(), -1);
        }
        if (element.hasRationaleElement()) {
            this.composeString(t, "RiskAssessmentPredictionComponent", "rationale", element.getRationaleElement(), -1);
        }
    }

    protected void composeSchedule(Turtle.Complex parent, String parentType, String name, Schedule element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Schedule", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Schedule", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Schedule", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getServiceCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Schedule", "serviceCategory", element.getServiceCategory().get(i), i);
        }
        for (i = 0; i < element.getServiceType().size(); ++i) {
            this.composeCodeableConcept(t, "Schedule", "serviceType", element.getServiceType().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "Schedule", "specialty", element.getSpecialty().get(i), i);
        }
        for (i = 0; i < element.getActor().size(); ++i) {
            this.composeReference(t, "Schedule", "actor", element.getActor().get(i), i);
        }
        if (element.hasPlanningHorizon()) {
            this.composePeriod(t, "Schedule", "planningHorizon", element.getPlanningHorizon(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "Schedule", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeSearchParameter(Turtle.Complex parent, String parentType, String name, SearchParameter element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "SearchParameter", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "SearchParameter", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "SearchParameter", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "SearchParameter", "name", element.getNameElement(), -1);
        }
        if (element.hasDerivedFromElement()) {
            this.composeCanonical(t, "SearchParameter", "derivedFrom", element.getDerivedFromElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "SearchParameter", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "SearchParameter", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "SearchParameter", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "SearchParameter", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "SearchParameter", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "SearchParameter", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "SearchParameter", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "SearchParameter", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "SearchParameter", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "SearchParameter", "code", element.getCodeElement(), -1);
        }
        for (i = 0; i < element.getBase().size(); ++i) {
            this.composeCode(t, "SearchParameter", "base", element.getBase().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "SearchParameter", "type", element.getTypeElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "SearchParameter", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasXpathElement()) {
            this.composeString(t, "SearchParameter", "xpath", element.getXpathElement(), -1);
        }
        if (element.hasXpathUsageElement()) {
            this.composeEnum(t, "SearchParameter", "xpathUsage", element.getXpathUsageElement(), -1);
        }
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeCode(t, "SearchParameter", "target", element.getTarget().get(i), i);
        }
        if (element.hasMultipleOrElement()) {
            this.composeBoolean(t, "SearchParameter", "multipleOr", element.getMultipleOrElement(), -1);
        }
        if (element.hasMultipleAndElement()) {
            this.composeBoolean(t, "SearchParameter", "multipleAnd", element.getMultipleAndElement(), -1);
        }
        for (i = 0; i < element.getComparator().size(); ++i) {
            this.composeEnum(t, "SearchParameter", "comparator", element.getComparator().get(i), i);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeEnum(t, "SearchParameter", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getChain().size(); ++i) {
            this.composeString(t, "SearchParameter", "chain", element.getChain().get(i), i);
        }
        for (i = 0; i < element.getComponent().size(); ++i) {
            this.composeSearchParameterComponentComponent(t, "SearchParameter", "component", element.getComponent().get(i), i);
        }
    }

    protected void composeSearchParameterComponentComponent(Turtle.Complex parent, String parentType, String name, SearchParameter.SearchParameterComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "SearchParameterComponentComponent", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "SearchParameterComponentComponent", "expression", element.getExpressionElement(), -1);
        }
    }

    protected void composeServiceRequest(Turtle.Complex parent, String parentType, String name, ServiceRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ServiceRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ServiceRequest", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesCanonical().size(); ++i) {
            this.composeCanonical(t, "ServiceRequest", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
        }
        for (i = 0; i < element.getInstantiatesUri().size(); ++i) {
            this.composeUri(t, "ServiceRequest", "instantiatesUri", element.getInstantiatesUri().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "basedOn", element.getBasedOn().get(i), i);
        }
        for (i = 0; i < element.getReplaces().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "replaces", element.getReplaces().get(i), i);
        }
        if (element.hasRequisition()) {
            this.composeIdentifier(t, "ServiceRequest", "requisition", element.getRequisition(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ServiceRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "ServiceRequest", "intent", element.getIntentElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "ServiceRequest", "category", element.getCategory().get(i), i);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "ServiceRequest", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "ServiceRequest", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ServiceRequest", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getOrderDetail().size(); ++i) {
            this.composeCodeableConcept(t, "ServiceRequest", "orderDetail", element.getOrderDetail().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeType(t, "ServiceRequest", "quantity", element.getQuantity(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ServiceRequest", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "ServiceRequest", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "ServiceRequest", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasAsNeeded()) {
            this.composeType(t, "ServiceRequest", "asNeeded", element.getAsNeeded(), -1);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "ServiceRequest", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "ServiceRequest", "requester", element.getRequester(), -1);
        }
        if (element.hasPerformerType()) {
            this.composeCodeableConcept(t, "ServiceRequest", "performerType", element.getPerformerType(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "performer", element.getPerformer().get(i), i);
        }
        for (i = 0; i < element.getLocationCode().size(); ++i) {
            this.composeCodeableConcept(t, "ServiceRequest", "locationCode", element.getLocationCode().get(i), i);
        }
        for (i = 0; i < element.getLocationReference().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "locationReference", element.getLocationReference().get(i), i);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "ServiceRequest", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getInsurance().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "insurance", element.getInsurance().get(i), i);
        }
        for (i = 0; i < element.getSupportingInfo().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "supportingInfo", element.getSupportingInfo().get(i), i);
        }
        for (i = 0; i < element.getSpecimen().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "specimen", element.getSpecimen().get(i), i);
        }
        for (i = 0; i < element.getBodySite().size(); ++i) {
            this.composeCodeableConcept(t, "ServiceRequest", "bodySite", element.getBodySite().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "ServiceRequest", "note", element.getNote().get(i), i);
        }
        if (element.hasPatientInstructionElement()) {
            this.composeString(t, "ServiceRequest", "patientInstruction", element.getPatientInstructionElement(), -1);
        }
        for (i = 0; i < element.getRelevantHistory().size(); ++i) {
            this.composeReference(t, "ServiceRequest", "relevantHistory", element.getRelevantHistory().get(i), i);
        }
    }

    protected void composeSlot(Turtle.Complex parent, String parentType, String name, Slot element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Slot", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Slot", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getServiceCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Slot", "serviceCategory", element.getServiceCategory().get(i), i);
        }
        for (i = 0; i < element.getServiceType().size(); ++i) {
            this.composeCodeableConcept(t, "Slot", "serviceType", element.getServiceType().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "Slot", "specialty", element.getSpecialty().get(i), i);
        }
        if (element.hasAppointmentType()) {
            this.composeCodeableConcept(t, "Slot", "appointmentType", element.getAppointmentType(), -1);
        }
        if (element.hasSchedule()) {
            this.composeReference(t, "Slot", "schedule", element.getSchedule(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Slot", "status", element.getStatusElement(), -1);
        }
        if (element.hasStartElement()) {
            this.composeInstant(t, "Slot", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "Slot", "end", element.getEndElement(), -1);
        }
        if (element.hasOverbookedElement()) {
            this.composeBoolean(t, "Slot", "overbooked", element.getOverbookedElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "Slot", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeSpecimen(Turtle.Complex parent, String parentType, String name, Specimen element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Specimen", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Specimen", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasAccessionIdentifier()) {
            this.composeIdentifier(t, "Specimen", "accessionIdentifier", element.getAccessionIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Specimen", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Specimen", "type", element.getType(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Specimen", "subject", element.getSubject(), -1);
        }
        if (element.hasReceivedTimeElement()) {
            this.composeDateTime(t, "Specimen", "receivedTime", element.getReceivedTimeElement(), -1);
        }
        for (i = 0; i < element.getParent().size(); ++i) {
            this.composeReference(t, "Specimen", "parent", element.getParent().get(i), i);
        }
        for (i = 0; i < element.getRequest().size(); ++i) {
            this.composeReference(t, "Specimen", "request", element.getRequest().get(i), i);
        }
        if (element.hasCollection()) {
            this.composeSpecimenCollectionComponent(t, "Specimen", "collection", element.getCollection(), -1);
        }
        for (i = 0; i < element.getProcessing().size(); ++i) {
            this.composeSpecimenProcessingComponent(t, "Specimen", "processing", element.getProcessing().get(i), i);
        }
        for (i = 0; i < element.getContainer().size(); ++i) {
            this.composeSpecimenContainerComponent(t, "Specimen", "container", element.getContainer().get(i), i);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeCodeableConcept(t, "Specimen", "condition", element.getCondition().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Specimen", "note", element.getNote().get(i), i);
        }
    }

    protected void composeSpecimenCollectionComponent(Turtle.Complex parent, String parentType, String name, Specimen.SpecimenCollectionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "collection", name, element, index);
        if (element.hasCollector()) {
            this.composeReference(t, "SpecimenCollectionComponent", "collector", element.getCollector(), -1);
        }
        if (element.hasCollected()) {
            this.composeType(t, "SpecimenCollectionComponent", "collected", element.getCollected(), -1);
        }
        if (element.hasDuration()) {
            this.composeDuration(t, "SpecimenCollectionComponent", "duration", element.getDuration(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "SpecimenCollectionComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "SpecimenCollectionComponent", "method", element.getMethod(), -1);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "SpecimenCollectionComponent", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasFastingStatus()) {
            this.composeType(t, "SpecimenCollectionComponent", "fastingStatus", element.getFastingStatus(), -1);
        }
    }

    protected void composeSpecimenProcessingComponent(Turtle.Complex parent, String parentType, String name, Specimen.SpecimenProcessingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "processing", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "SpecimenProcessingComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeCodeableConcept(t, "SpecimenProcessingComponent", "procedure", element.getProcedure(), -1);
        }
        for (int i = 0; i < element.getAdditive().size(); ++i) {
            this.composeReference(t, "SpecimenProcessingComponent", "additive", element.getAdditive().get(i), i);
        }
        if (element.hasTime()) {
            this.composeType(t, "SpecimenProcessingComponent", "time", element.getTime(), -1);
        }
    }

    protected void composeSpecimenContainerComponent(Turtle.Complex parent, String parentType, String name, Specimen.SpecimenContainerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "container", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "SpecimenContainerComponent", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "SpecimenContainerComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SpecimenContainerComponent", "type", element.getType(), -1);
        }
        if (element.hasCapacity()) {
            this.composeQuantity(t, "SpecimenContainerComponent", "capacity", element.getCapacity(), -1);
        }
        if (element.hasSpecimenQuantity()) {
            this.composeQuantity(t, "SpecimenContainerComponent", "specimenQuantity", element.getSpecimenQuantity(), -1);
        }
        if (element.hasAdditive()) {
            this.composeType(t, "SpecimenContainerComponent", "additive", element.getAdditive(), -1);
        }
    }

    protected void composeSpecimenDefinition(Turtle.Complex parent, String parentType, String name, SpecimenDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "SpecimenDefinition", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "SpecimenDefinition", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasTypeCollected()) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "typeCollected", element.getTypeCollected(), -1);
        }
        for (i = 0; i < element.getPatientPreparation().size(); ++i) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "patientPreparation", element.getPatientPreparation().get(i), i);
        }
        if (element.hasTimeAspectElement()) {
            this.composeString(t, "SpecimenDefinition", "timeAspect", element.getTimeAspectElement(), -1);
        }
        for (i = 0; i < element.getCollection().size(); ++i) {
            this.composeCodeableConcept(t, "SpecimenDefinition", "collection", element.getCollection().get(i), i);
        }
        for (i = 0; i < element.getTypeTested().size(); ++i) {
            this.composeSpecimenDefinitionTypeTestedComponent(t, "SpecimenDefinition", "typeTested", element.getTypeTested().get(i), i);
        }
    }

    protected void composeSpecimenDefinitionTypeTestedComponent(Turtle.Complex parent, String parentType, String name, SpecimenDefinition.SpecimenDefinitionTypeTestedComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "typeTested", name, element, index);
        if (element.hasIsDerivedElement()) {
            this.composeBoolean(t, "SpecimenDefinitionTypeTestedComponent", "isDerived", element.getIsDerivedElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SpecimenDefinitionTypeTestedComponent", "type", element.getType(), -1);
        }
        if (element.hasPreferenceElement()) {
            this.composeEnum(t, "SpecimenDefinitionTypeTestedComponent", "preference", element.getPreferenceElement(), -1);
        }
        if (element.hasContainer()) {
            this.composeSpecimenDefinitionTypeTestedContainerComponent(t, "SpecimenDefinitionTypeTestedComponent", "container", element.getContainer(), -1);
        }
        if (element.hasRequirementElement()) {
            this.composeString(t, "SpecimenDefinitionTypeTestedComponent", "requirement", element.getRequirementElement(), -1);
        }
        if (element.hasRetentionTime()) {
            this.composeDuration(t, "SpecimenDefinitionTypeTestedComponent", "retentionTime", element.getRetentionTime(), -1);
        }
        for (i = 0; i < element.getRejectionCriterion().size(); ++i) {
            this.composeCodeableConcept(t, "SpecimenDefinitionTypeTestedComponent", "rejectionCriterion", element.getRejectionCriterion().get(i), i);
        }
        for (i = 0; i < element.getHandling().size(); ++i) {
            this.composeSpecimenDefinitionTypeTestedHandlingComponent(t, "SpecimenDefinitionTypeTestedComponent", "handling", element.getHandling().get(i), i);
        }
    }

    protected void composeSpecimenDefinitionTypeTestedContainerComponent(Turtle.Complex parent, String parentType, String name, SpecimenDefinition.SpecimenDefinitionTypeTestedContainerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "container", name, element, index);
        if (element.hasMaterial()) {
            this.composeCodeableConcept(t, "SpecimenDefinitionTypeTestedContainerComponent", "material", element.getMaterial(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SpecimenDefinitionTypeTestedContainerComponent", "type", element.getType(), -1);
        }
        if (element.hasCap()) {
            this.composeCodeableConcept(t, "SpecimenDefinitionTypeTestedContainerComponent", "cap", element.getCap(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "SpecimenDefinitionTypeTestedContainerComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCapacity()) {
            this.composeQuantity(t, "SpecimenDefinitionTypeTestedContainerComponent", "capacity", element.getCapacity(), -1);
        }
        if (element.hasMinimumVolume()) {
            this.composeType(t, "SpecimenDefinitionTypeTestedContainerComponent", "minimumVolume", element.getMinimumVolume(), -1);
        }
        for (int i = 0; i < element.getAdditive().size(); ++i) {
            this.composeSpecimenDefinitionTypeTestedContainerAdditiveComponent(t, "SpecimenDefinitionTypeTestedContainerComponent", "additive", element.getAdditive().get(i), i);
        }
        if (element.hasPreparationElement()) {
            this.composeString(t, "SpecimenDefinitionTypeTestedContainerComponent", "preparation", element.getPreparationElement(), -1);
        }
    }

    protected void composeSpecimenDefinitionTypeTestedContainerAdditiveComponent(Turtle.Complex parent, String parentType, String name, SpecimenDefinition.SpecimenDefinitionTypeTestedContainerAdditiveComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "additive", name, element, index);
        if (element.hasAdditive()) {
            this.composeType(t, "SpecimenDefinitionTypeTestedContainerAdditiveComponent", "additive", element.getAdditive(), -1);
        }
    }

    protected void composeSpecimenDefinitionTypeTestedHandlingComponent(Turtle.Complex parent, String parentType, String name, SpecimenDefinition.SpecimenDefinitionTypeTestedHandlingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "handling", name, element, index);
        if (element.hasTemperatureQualifier()) {
            this.composeCodeableConcept(t, "SpecimenDefinitionTypeTestedHandlingComponent", "temperatureQualifier", element.getTemperatureQualifier(), -1);
        }
        if (element.hasTemperatureRange()) {
            this.composeRange(t, "SpecimenDefinitionTypeTestedHandlingComponent", "temperatureRange", element.getTemperatureRange(), -1);
        }
        if (element.hasMaxDuration()) {
            this.composeDuration(t, "SpecimenDefinitionTypeTestedHandlingComponent", "maxDuration", element.getMaxDuration(), -1);
        }
        if (element.hasInstructionElement()) {
            this.composeString(t, "SpecimenDefinitionTypeTestedHandlingComponent", "instruction", element.getInstructionElement(), -1);
        }
    }

    protected void composeStructureDefinition(Turtle.Complex parent, String parentType, String name, StructureDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "StructureDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "StructureDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "StructureDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "StructureDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "StructureDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "StructureDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "StructureDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "StructureDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "StructureDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "StructureDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "StructureDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "StructureDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "StructureDefinition", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "StructureDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "StructureDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "StructureDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        for (i = 0; i < element.getKeyword().size(); ++i) {
            this.composeCoding(t, "StructureDefinition", "keyword", element.getKeyword().get(i), i);
        }
        if (element.hasFhirVersionElement()) {
            this.composeEnum(t, "StructureDefinition", "fhirVersion", element.getFhirVersionElement(), -1);
        }
        for (i = 0; i < element.getMapping().size(); ++i) {
            this.composeStructureDefinitionMappingComponent(t, "StructureDefinition", "mapping", element.getMapping().get(i), i);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "StructureDefinition", "kind", element.getKindElement(), -1);
        }
        if (element.hasAbstractElement()) {
            this.composeBoolean(t, "StructureDefinition", "abstract", element.getAbstractElement(), -1);
        }
        for (i = 0; i < element.getContext().size(); ++i) {
            this.composeStructureDefinitionContextComponent(t, "StructureDefinition", "context", element.getContext().get(i), i);
        }
        for (i = 0; i < element.getContextInvariant().size(); ++i) {
            this.composeString(t, "StructureDefinition", "contextInvariant", element.getContextInvariant().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeUri(t, "StructureDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasBaseDefinitionElement()) {
            this.composeCanonical(t, "StructureDefinition", "baseDefinition", element.getBaseDefinitionElement(), -1);
        }
        if (element.hasDerivationElement()) {
            this.composeEnum(t, "StructureDefinition", "derivation", element.getDerivationElement(), -1);
        }
        if (element.hasSnapshot()) {
            this.composeStructureDefinitionSnapshotComponent(t, "StructureDefinition", "snapshot", element.getSnapshot(), -1);
        }
        if (element.hasDifferential()) {
            this.composeStructureDefinitionDifferentialComponent(t, "StructureDefinition", "differential", element.getDifferential(), -1);
        }
    }

    protected void composeStructureDefinitionMappingComponent(Turtle.Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionMappingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "mapping", name, element, index);
        if (element.hasIdentityElement()) {
            this.composeId(t, "StructureDefinitionMappingComponent", "identity", element.getIdentityElement(), -1);
        }
        if (element.hasUriElement()) {
            this.composeUri(t, "StructureDefinitionMappingComponent", "uri", element.getUriElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "StructureDefinitionMappingComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "StructureDefinitionMappingComponent", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeStructureDefinitionContextComponent(Turtle.Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionContextComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "context", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "StructureDefinitionContextComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "StructureDefinitionContextComponent", "expression", element.getExpressionElement(), -1);
        }
    }

    protected void composeStructureDefinitionSnapshotComponent(Turtle.Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionSnapshotComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "snapshot", name, element, index);
        for (int i = 0; i < element.getElement().size(); ++i) {
            this.composeElementDefinition(t, "StructureDefinitionSnapshotComponent", "element", element.getElement().get(i), i);
        }
    }

    protected void composeStructureDefinitionDifferentialComponent(Turtle.Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionDifferentialComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "differential", name, element, index);
        for (int i = 0; i < element.getElement().size(); ++i) {
            this.composeElementDefinition(t, "StructureDefinitionDifferentialComponent", "element", element.getElement().get(i), i);
        }
    }

    protected void composeStructureMap(Turtle.Complex parent, String parentType, String name, StructureMap element, int index) {
        int i;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "StructureMap", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "StructureMap", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "StructureMap", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "StructureMap", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "StructureMap", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "StructureMap", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "StructureMap", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "StructureMap", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "StructureMap", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactDetail(t, "StructureMap", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "StructureMap", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeUsageContext(t, "StructureMap", "useContext", element.getUseContext().get(i), i);
        }
        for (i = 0; i < element.getJurisdiction().size(); ++i) {
            this.composeCodeableConcept(t, "StructureMap", "jurisdiction", element.getJurisdiction().get(i), i);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "StructureMap", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "StructureMap", "copyright", element.getCopyrightElement(), -1);
        }
        for (i = 0; i < element.getStructure().size(); ++i) {
            this.composeStructureMapStructureComponent(t, "StructureMap", "structure", element.getStructure().get(i), i);
        }
        for (i = 0; i < element.getImport().size(); ++i) {
            this.composeCanonical(t, "StructureMap", "import", element.getImport().get(i), i);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeStructureMapGroupComponent(t, "StructureMap", "group", element.getGroup().get(i), i);
        }
    }

   