/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.context;

import com.google.gson.JsonSyntaxException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r4b.context.TerminologyCache;
import org.hl7.fhir.r4b.formats.IParser;
import org.hl7.fhir.r4b.formats.ParserType;
import org.hl7.fhir.r4b.model.Bundle;
import org.hl7.fhir.r4b.model.CanonicalResource;
import org.hl7.fhir.r4b.model.CodeSystem;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Coding;
import org.hl7.fhir.r4b.model.ConceptMap;
import org.hl7.fhir.r4b.model.ElementDefinition;
import org.hl7.fhir.r4b.model.Parameters;
import org.hl7.fhir.r4b.model.Resource;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.r4b.model.StructureMap;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r4b.terminologies.ValueSetExpander;
import org.hl7.fhir.r4b.utils.validation.IResourceValidator;
import org.hl7.fhir.r4b.utils.validation.ValidationContextCarrier;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.TranslationServices;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public interface IWorkerContext {
    public String getVersion();

    public String getSpecUrl();

    public UcumService getUcumService();

    public IParser getParser(ParserType var1);

    public IParser getParser(String var1);

    public IParser newJsonParser();

    public IParser newXmlParser();

    public IResourceValidator newValidator() throws FHIRException;

    public <T extends Resource> T fetchResource(Class<T> var1, String var2);

    public <T extends Resource> T fetchResourceWithException(Class<T> var1, String var2) throws FHIRException;

    public <T extends Resource> T fetchResource(Class<T> var1, String var2, String var3);

    public <T extends Resource> T fetchResource(Class<T> var1, String var2, CanonicalResource var3);

    public Resource fetchResourceById(String var1, String var2);

    public <T extends Resource> boolean hasResource(Class<T> var1, String var2);

    public void cacheResource(Resource var1) throws FHIRException;

    public void cacheResourceFromPackage(Resource var1, PackageVersion var2) throws FHIRException;

    public void cachePackage(PackageDetails var1, List<PackageVersion> var2);

    public List<String> getResourceNames();

    public Set<String> getResourceNamesAsSet();

    public List<String> getTypeNames();

    public List<StructureDefinition> allStructures();

    public List<StructureDefinition> getStructures();

    public List<CanonicalResource> allConformanceResources();

    public void generateSnapshot(StructureDefinition var1) throws DefinitionException, FHIRException;

    public void generateSnapshot(StructureDefinition var1, boolean var2);

    public Parameters getExpansionParameters();

    public void setExpansionProfile(Parameters var1);

    public CodeSystem fetchCodeSystem(String var1);

    public CodeSystem fetchCodeSystem(String var1, String var2);

    public boolean supportsSystem(String var1) throws TerminologyServiceException;

    public List<ConceptMap> findMapsForSource(String var1) throws FHIRException;

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet var1, boolean var2, boolean var3);

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet var1, boolean var2, boolean var3, boolean var4);

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ElementDefinition.ElementDefinitionBindingComponent var1, boolean var2, boolean var3) throws FHIRException;

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent var1, boolean var2) throws TerminologyServiceException;

    public Locale getLocale();

    public void setLocale(Locale var1);

    public String formatMessage(String var1, Object ... var2);

    public String formatMessagePlural(Integer var1, String var2, Object ... var3);

    public void setValidationMessageLanguage(Locale var1);

    public ValidationResult validateCode(ValidationOptions var1, String var2, ValueSet var3);

    public ValidationResult validateCode(ValidationOptions var1, String var2, String var3, String var4, String var5);

    public ValidationResult validateCode(ValidationOptions var1, String var2, String var3, String var4, String var5, ValueSet var6);

    public ValidationResult validateCode(ValidationOptions var1, CodeableConcept var2, ValueSet var3);

    public ValidationResult validateCode(ValidationOptions var1, Coding var2, ValueSet var3);

    public ValidationResult validateCode(ValidationOptions var1, Coding var2, ValueSet var3, ValidationContextCarrier var4);

    public void validateCodeBatch(ValidationOptions var1, List<? extends CodingValidationRequest> var2, ValueSet var3);

    public String getAbbreviation(String var1);

    public String oid2Uri(String var1);

    public boolean hasCache();

    public void setLogger(ILoggingService var1);

    public ILoggingService getLogger();

    public boolean isNoTerminologyServer();

    public Set<String> getCodeSystemsUsed();

    public TranslationServices translator();

    public List<StructureMap> listTransforms();

    public StructureMap getTransform(String var1);

    public String getOverrideVersionNs();

    public void setOverrideVersionNs(String var1);

    public StructureDefinition fetchTypeDefinition(String var1);

    public StructureDefinition fetchRawProfile(String var1);

    public void setUcumService(UcumService var1);

    public String getLinkForUrl(String var1, String var2);

    public Map<String, byte[]> getBinaries();

    public int loadFromPackage(NpmPackage var1, IContextResourceLoader var2) throws FileNotFoundException, IOException, FHIRException;

    @Deprecated
    public int loadFromPackage(NpmPackage var1, IContextResourceLoader var2, String[] var3) throws FileNotFoundException, IOException, FHIRException;

    public int loadFromPackageAndDependencies(NpmPackage var1, IContextResourceLoader var2, BasePackageCacheManager var3) throws FileNotFoundException, IOException, FHIRException;

    public boolean hasPackage(String var1, String var2);

    public boolean hasPackage(PackageVersion var1);

    public PackageDetails getPackage(PackageVersion var1);

    public int getClientRetryCount();

    public IWorkerContext setClientRetryCount(int var1);

    public TimeTracker clock();

    public PackageVersion getPackageForUrl(String var1);

    public static interface ILoggingService {
        public void logMessage(String var1);

        public void logDebugMessage(LogCategory var1, String var2);

        public static enum LogCategory {
            INIT,
            PROGRESS,
            TX,
            CONTEXT,
            GENERATE,
            HTML;

        }
    }

    public static class ValidationResult {
        private CodeSystem.ConceptDefinitionComponent definition;
        private String system;
        private ValidationMessage.IssueSeverity severity;
        private String message;
        private ValueSetExpander.TerminologyServiceErrorClass errorClass;
        private String txLink;

        public String toString() {
            return "ValidationResult [definition=" + this.definition + ", system=" + this.system + ", severity=" + this.severity + ", message=" + this.message + ", errorClass=" + this.errorClass + ", txLink=" + this.txLink + "]";
        }

        public ValidationResult(ValidationMessage.IssueSeverity severity, String message) {
            this.severity = severity;
            this.message = message;
        }

        public ValidationResult(String system, CodeSystem.ConceptDefinitionComponent definition) {
            this.system = system;
            this.definition = definition;
        }

        public ValidationResult(ValidationMessage.IssueSeverity severity, String message, String system, CodeSystem.ConceptDefinitionComponent definition) {
            this.severity = severity;
            this.message = message;
            this.system = system;
            this.definition = definition;
        }

        public ValidationResult(ValidationMessage.IssueSeverity severity, String message, ValueSetExpander.TerminologyServiceErrorClass errorClass) {
            this.severity = severity;
            this.message = message;
            this.errorClass = errorClass;
        }

        public boolean isOk() {
            return this.severity == null || this.severity == ValidationMessage.IssueSeverity.INFORMATION || this.severity == ValidationMessage.IssueSeverity.WARNING;
        }

        public String getSystem() {
            return this.system;
        }

        public String getDisplay() {
            return this.definition == null ? null : this.definition.getDisplay();
        }

        public String getCode() {
            return this.definition == null ? null : this.definition.getCode();
        }

        public String getDefinition() {
            return this.definition == null ? null : this.definition.getDefinition();
        }

        public CodeSystem.ConceptDefinitionComponent asConceptDefinition() {
            return this.definition;
        }

        public ValidationMessage.IssueSeverity getSeverity() {
            return this.severity;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean IsNoService() {
            return this.errorClass == ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE;
        }

        public ValueSetExpander.TerminologyServiceErrorClass getErrorClass() {
            return this.errorClass;
        }

        public ValidationResult setSeverity(ValidationMessage.IssueSeverity severity) {
            this.severity = severity;
            return this;
        }

        public ValidationResult setMessage(String message) {
            this.message = message;
            return this;
        }

        public ValidationResult setErrorClass(ValueSetExpander.TerminologyServiceErrorClass errorClass) {
            this.errorClass = errorClass;
            return this;
        }

        public String getTxLink() {
            return this.txLink;
        }

        public ValidationResult setTxLink(String txLink) {
            this.txLink = txLink;
            return this;
        }

        public boolean hasMessage() {
            return this.message != null;
        }

        public Coding asCoding() {
            if (this.isOk() && this.definition != null && this.definition.getCode() != null) {
                return new Coding(this.system, this.definition.getCode(), this.definition.getDisplay());
            }
            return null;
        }
    }

    public static interface IContextResourceLoader {
        public String[] getTypes();

        public Bundle loadBundle(InputStream var1, boolean var2) throws FHIRException, IOException;

        public Resource loadResource(InputStream var1, boolean var2) throws FHIRException, IOException;

        public String getResourcePath(Resource var1);

        public IContextResourceLoader getNewLoader(NpmPackage var1) throws JsonSyntaxException, IOException;
    }

    public static interface ICanonicalResourceLocator {
        public void findResource(Object var1, String var2);
    }

    public static class PackageDetails
    extends PackageVersion {
        private String name;
        private String canonical;
        private String web;

        public PackageDetails(String id, String version, String name, String canonical, String web) {
            super(id, version);
            this.name = name;
            this.canonical = canonical;
            this.web = web;
        }

        public String getName() {
            return this.name;
        }

        public String getCanonical() {
            return this.canonical;
        }

        public String getWeb() {
            return this.web;
        }
    }

    public static class PackageVersion {
        private String id;
        private String version;

        public PackageVersion(String source) {
            if (source == null) {
                throw new Error("Source cannot be null");
            }
            if (!source.contains("#")) {
                throw new FHIRException("Source ");
            }
            this.id = source.substring(0, source.indexOf("#"));
            this.version = source.substring(source.indexOf("#") + 1);
        }

        public PackageVersion(String id, String version) {
            this.id = id;
            this.version = version;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isExamplesPackage() {
            boolean b = this.id.startsWith("hl7.fhir.") && this.id.endsWith(".examples");
            return b;
        }

        public String toString() {
            return this.id + "#" + this.version;
        }
    }

    public static class CodingValidationRequest {
        private Coding coding;
        private ValidationResult result;
        private TerminologyCache.CacheToken cacheToken;

        public CodingValidationRequest(Coding coding) {
            this.coding = coding;
        }

        public ValidationResult getResult() {
            return this.result;
        }

        public void setResult(ValidationResult result) {
            this.result = result;
        }

        public Coding getCoding() {
            return this.coding;
        }

        public boolean hasResult() {
            return this.result != null;
        }

        public TerminologyCache.CacheToken getCacheToken() {
            return this.cacheToken;
        }

        public void setCacheToken(TerminologyCache.CacheToken cacheToken) {
            this.cacheToken = cacheToken;
        }
    }
}

