/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.i18n.Msg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService;
import org.hl7.fhir.common.hapi.validation.support.RemoteTerminologyServiceValidationSupport;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class ValidationSupportChain
implements IValidationSupport {
    private List<IValidationSupport> myChain = new ArrayList<IValidationSupport>();

    public ValidationSupportChain() {
    }

    public ValidationSupportChain(IValidationSupport ... theValidationSupportModules) {
        this();
        for (IValidationSupport next : theValidationSupportModules) {
            if (next == null) continue;
            this.addValidationSupport(next);
        }
    }

    public TranslateConceptResults translateConcept(IValidationSupport.TranslateCodeRequest theRequest) {
        TranslateConceptResults retVal = null;
        for (IValidationSupport next : this.myChain) {
            TranslateConceptResults translations = next.translateConcept(theRequest);
            if (translations == null) continue;
            if (retVal == null) {
                retVal = new TranslateConceptResults();
            }
            if (retVal.getMessage() == null) {
                retVal.setMessage(translations.getMessage());
            }
            if (translations.getResult() && !retVal.getResult()) {
                retVal.setResult(translations.getResult());
                retVal.setMessage(translations.getMessage());
            }
            retVal.getResults().addAll(translations.getResults());
        }
        return retVal;
    }

    public void invalidateCaches() {
        for (IValidationSupport next : this.myChain) {
            next.invalidateCaches();
        }
    }

    public boolean isValueSetSupported(ValidationSupportContext theValidationSupportContext, String theValueSetUrl) {
        for (IValidationSupport next : this.myChain) {
            boolean retVal = next.isValueSetSupported(theValidationSupportContext, theValueSetUrl);
            if (!retVal) continue;
            return true;
        }
        return false;
    }

    public IBaseResource generateSnapshot(ValidationSupportContext theValidationSupportContext, IBaseResource theInput, String theUrl, String theWebUrl, String theProfileName) {
        for (IValidationSupport next : this.myChain) {
            IBaseResource retVal = next.generateSnapshot(theValidationSupportContext, theInput, theUrl, theWebUrl, theProfileName);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public FhirContext getFhirContext() {
        if (this.myChain.size() == 0) {
            return null;
        }
        return this.myChain.get(0).getFhirContext();
    }

    public void addValidationSupport(IValidationSupport theValidationSupport) {
        int index = this.myChain.size();
        this.addValidationSupport(index, theValidationSupport);
    }

    public void addValidationSupport(int theIndex, IValidationSupport theValidationSupport) {
        Validate.notNull((Object)theValidationSupport, (String)"theValidationSupport must not be null", (Object[])new Object[0]);
        if (theValidationSupport.getFhirContext() == null) {
            String message = "Can not add validation support: getFhirContext() returns null";
            throw new ConfigurationException(Msg.code((int)708) + message);
        }
        FhirContext existingFhirContext = this.getFhirContext();
        if (existingFhirContext != null) {
            FhirVersionEnum newVersion = theValidationSupport.getFhirContext().getVersion().getVersion();
            FhirVersionEnum existingVersion = existingFhirContext.getVersion().getVersion();
            if (!existingVersion.equals((Object)newVersion)) {
                String message = "Trying to add validation support of version " + newVersion + " to chain with " + this.myChain.size() + " entries of version " + existingVersion;
                throw new ConfigurationException(Msg.code((int)709) + message);
            }
        }
        this.myChain.add(theIndex, theValidationSupport);
    }

    public void removeValidationSupport(IValidationSupport theValidationSupport) {
        this.myChain.remove(theValidationSupport);
    }

    public IValidationSupport.ValueSetExpansionOutcome expandValueSet(ValidationSupportContext theValidationSupportContext, ValueSetExpansionOptions theExpansionOptions, @Nonnull IBaseResource theValueSetToExpand) {
        for (IValidationSupport next : this.myChain) {
            IValidationSupport.ValueSetExpansionOutcome expanded = next.expandValueSet(theValidationSupportContext, theExpansionOptions, theValueSetToExpand);
            if (expanded == null) continue;
            return expanded;
        }
        return null;
    }

    public boolean isRemoteTerminologyServiceConfigured() {
        if (this.myChain != null) {
            Optional<IValidationSupport> remoteTerminologyService = this.myChain.stream().filter(RemoteTerminologyServiceValidationSupport.class::isInstance).findFirst();
            if (remoteTerminologyService.isPresent()) {
                return true;
            }
        }
        return false;
    }

    public List<IBaseResource> fetchAllConformanceResources() {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        for (IValidationSupport next : this.myChain) {
            List candidates = next.fetchAllConformanceResources();
            if (candidates == null) continue;
            retVal.addAll(candidates);
        }
        return retVal;
    }

    public List<IBaseResource> fetchAllStructureDefinitions() {
        return this.doFetchStructureDefinitions(t -> t.fetchAllStructureDefinitions());
    }

    public List<IBaseResource> fetchAllNonBaseStructureDefinitions() {
        return this.doFetchStructureDefinitions(t -> t.fetchAllNonBaseStructureDefinitions());
    }

    private List<IBaseResource> doFetchStructureDefinitions(Function<IValidationSupport, List<IBaseResource>> theFunction) {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        HashSet<String> urls = new HashSet<String>();
        for (IValidationSupport nextSupport : this.myChain) {
            List<IBaseResource> allStructureDefinitions = theFunction.apply(nextSupport);
            if (allStructureDefinitions == null) continue;
            for (IBaseResource next : allStructureDefinitions) {
                IPrimitiveType urlType = (IPrimitiveType)this.getFhirContext().newTerser().getSingleValueOrNull((IBase)next, "url", IPrimitiveType.class);
                if (urlType != null && !StringUtils.isBlank((CharSequence)urlType.getValueAsString()) && !urls.add(urlType.getValueAsString())) continue;
                retVal.add(next);
            }
        }
        return retVal;
    }

    public IBaseResource fetchCodeSystem(String theSystem) {
        for (IValidationSupport next : this.myChain) {
            IBaseResource retVal = next.fetchCodeSystem(theSystem);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public IBaseResource fetchValueSet(String theUrl) {
        for (IValidationSupport next : this.myChain) {
            IBaseResource retVal = next.fetchValueSet(theUrl);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public <T extends IBaseResource> T fetchResource(Class<T> theClass, String theUri) {
        for (IValidationSupport next : this.myChain) {
            IBaseResource retVal = next.fetchResource(theClass, theUri);
            if (retVal == null) continue;
            return (T)retVal;
        }
        return null;
    }

    public byte[] fetchBinary(String key) {
        for (IValidationSupport next : this.myChain) {
            byte[] retVal = next.fetchBinary(key);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public IBaseResource fetchStructureDefinition(String theUrl) {
        for (IValidationSupport next : this.myChain) {
            IBaseResource retVal = next.fetchStructureDefinition(theUrl);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        for (IValidationSupport next : this.myChain) {
            if (!next.isCodeSystemSupported(theValidationSupportContext, theSystem)) continue;
            return true;
        }
        return false;
    }

    public IValidationSupport.CodeValidationResult validateCode(@Nonnull ValidationSupportContext theValidationSupportContext, @Nonnull ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        for (IValidationSupport next : this.myChain) {
            IValidationSupport.CodeValidationResult retVal;
            if ((!StringUtils.isBlank((CharSequence)theValueSetUrl) || !next.isCodeSystemSupported(theValidationSupportContext, theCodeSystem)) && (!StringUtils.isNotBlank((CharSequence)theValueSetUrl) || !next.isValueSetSupported(theValidationSupportContext, theValueSetUrl)) || (retVal = next.validateCode(theValidationSupportContext, theOptions, theCodeSystem, theCode, theDisplay, theValueSetUrl)) == null) continue;
            return retVal;
        }
        return null;
    }

    public IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        for (IValidationSupport next : this.myChain) {
            IValidationSupport.CodeValidationResult retVal;
            String url = CommonCodeSystemsTerminologyService.getValueSetUrl(theValueSet);
            if (!StringUtils.isBlank((CharSequence)url) && !next.isValueSetSupported(theValidationSupportContext, url) || (retVal = next.validateCodeInValueSet(theValidationSupportContext, theOptions, theCodeSystem, theCode, theDisplay, theValueSet)) == null) continue;
            return retVal;
        }
        return null;
    }

    public IValidationSupport.LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, String theSystem, String theCode, String theDisplayLanguage) {
        for (IValidationSupport next : this.myChain) {
            if (!next.isCodeSystemSupported(theValidationSupportContext, theSystem)) continue;
            return next.lookupCode(theValidationSupportContext, theSystem, theCode, theDisplayLanguage);
        }
        return null;
    }
}

