/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.TranslateConceptResult;
import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public final class RemoteTerminologyUtil {
    private RemoteTerminologyUtil() {
    }

    public static IBaseParameters buildTranslateInputParameters(FhirContext fhirContext, IValidationSupport.TranslateCodeRequest theRequest) {
        IBaseParameters params = ParametersUtil.newInstance((FhirContext)fhirContext);
        if (!StringUtils.isEmpty((CharSequence)theRequest.getConceptMapUrl())) {
            ParametersUtil.addParameterToParametersUri((FhirContext)fhirContext, (IBaseParameters)params, (String)"url", (String)theRequest.getConceptMapUrl());
        }
        if (!StringUtils.isEmpty((CharSequence)theRequest.getConceptMapVersion())) {
            ParametersUtil.addParameterToParametersString((FhirContext)fhirContext, (IBaseParameters)params, (String)"conceptMapVersion", (String)theRequest.getConceptMapVersion());
        }
        if (theRequest.getCodings() != null) {
            RemoteTerminologyUtil.addCodingsToTranslateParameters(fhirContext, theRequest.getCodings(), params);
        }
        if (!StringUtils.isEmpty((CharSequence)theRequest.getSourceValueSetUrl())) {
            ParametersUtil.addParameterToParametersUri((FhirContext)fhirContext, (IBaseParameters)params, (String)"source", (String)theRequest.getSourceValueSetUrl());
        }
        if (!StringUtils.isEmpty((CharSequence)theRequest.getTargetValueSetUrl())) {
            ParametersUtil.addParameterToParametersUri((FhirContext)fhirContext, (IBaseParameters)params, (String)"target", (String)theRequest.getTargetValueSetUrl());
        }
        if (!StringUtils.isEmpty((CharSequence)theRequest.getTargetSystemUrl())) {
            ParametersUtil.addParameterToParametersUri((FhirContext)fhirContext, (IBaseParameters)params, (String)"targetsystem", (String)theRequest.getTargetSystemUrl());
        }
        if (theRequest.isReverse()) {
            ParametersUtil.addParameterToParametersBoolean((FhirContext)fhirContext, (IBaseParameters)params, (String)"reverse", (boolean)theRequest.isReverse());
        }
        return params;
    }

    public static void addCodingsToTranslateParameters(FhirContext fhirContext, List<IBaseCoding> theCodings, IBaseParameters theParams) {
        BaseRuntimeElementCompositeDefinition codeableConceptDef = (BaseRuntimeElementCompositeDefinition)Objects.requireNonNull(fhirContext.getElementDefinition("CodeableConcept"));
        BaseRuntimeChildDefinition codings = codeableConceptDef.getChildByName("coding");
        BaseRuntimeElementCompositeDefinition codingDef = (BaseRuntimeElementCompositeDefinition)Objects.requireNonNull(fhirContext.getElementDefinition("Coding"));
        BaseRuntimeChildDefinition codingSystemChild = codingDef.getChildByName("system");
        BaseRuntimeChildDefinition codingCodeChild = codingDef.getChildByName("code");
        RuntimePrimitiveDatatypeDefinition systemDef = (RuntimePrimitiveDatatypeDefinition)fhirContext.getElementDefinition("uri");
        RuntimePrimitiveDatatypeDefinition codeDef = (RuntimePrimitiveDatatypeDefinition)fhirContext.getElementDefinition("code");
        IBase codeableConcept = codeableConceptDef.newInstance();
        for (IBaseCoding aCoding : theCodings) {
            IBaseCoding newCoding = (IBaseCoding)codingDef.newInstance();
            IPrimitiveType newSystem = (IPrimitiveType)systemDef.newInstance((Object)aCoding.getSystem());
            codingSystemChild.getMutator().addValue((IBase)newCoding, (IBase)newSystem);
            IPrimitiveType newCode = (IPrimitiveType)codeDef.newInstance((Object)aCoding.getCode());
            codingCodeChild.getMutator().addValue((IBase)newCoding, (IBase)newCode);
            codings.getMutator().addValue(codeableConcept, (IBase)newCoding);
        }
        ParametersUtil.addParameterToParameters((FhirContext)fhirContext, (IBaseParameters)theParams, (String)"codeableConcept", (Object)codeableConcept);
    }

    public static TranslateConceptResults translateOutcomeToResults(FhirContext fhirContext, IBaseParameters outcome) {
        Optional result = ParametersUtil.getNamedParameterValueAsString((FhirContext)fhirContext, (IBaseParameters)outcome, (String)"result");
        Optional message = ParametersUtil.getNamedParameterValueAsString((FhirContext)fhirContext, (IBaseParameters)outcome, (String)"message");
        List matches = ParametersUtil.getNamedParameters((FhirContext)fhirContext, (IBaseResource)outcome, (String)"match");
        TranslateConceptResults retVal = new TranslateConceptResults();
        if (result.isPresent()) {
            retVal.setResult(Boolean.parseBoolean((String)result.get()));
        }
        if (message.isPresent()) {
            retVal.setMessage((String)message.get());
        }
        if (!matches.isEmpty()) {
            retVal.setResults(RemoteTerminologyUtil.matchesToTranslateConceptResults(fhirContext, matches));
        }
        return retVal;
    }

    private static List<TranslateConceptResult> matchesToTranslateConceptResults(FhirContext fhirContext, List<IBase> theMatches) {
        ArrayList<TranslateConceptResult> resultList = new ArrayList<TranslateConceptResult>();
        for (IBase m : theMatches) {
            TranslateConceptResult match = new TranslateConceptResult();
            String equivalence = ParametersUtil.getParameterPartValueAsString((FhirContext)fhirContext, (IBase)m, (String)"equivalence");
            Optional concept = ParametersUtil.getParameterPartValue((FhirContext)fhirContext, (IBase)m, (String)"concept");
            String source = ParametersUtil.getParameterPartValueAsString((FhirContext)fhirContext, (IBase)m, (String)"source");
            if (StringUtils.isNotBlank((CharSequence)equivalence)) {
                match.setEquivalence(equivalence);
            }
            if (!concept.isPresent()) continue;
            IBaseCoding matchedCoding = (IBaseCoding)concept.get();
            match.setSystem(matchedCoding.getSystem());
            match.setCode(matchedCoding.getCode());
            match.setDisplay(matchedCoding.getDisplay());
            if (StringUtils.isNotBlank((CharSequence)source)) {
                match.setConceptMapUrl(source);
            }
            resultList.add(match);
        }
        return resultList;
    }
}

