/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.compress.utils.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.support.BaseStaticResourceValidationSupport;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class PrePopulatedValidationSupport
extends BaseStaticResourceValidationSupport
implements IValidationSupport {
    private final Map<String, IBaseResource> myCodeSystems;
    private final Map<String, IBaseResource> myStructureDefinitions;
    private final Map<String, IBaseResource> myValueSets;
    private final Map<String, byte[]> myBinaries;

    public PrePopulatedValidationSupport(FhirContext theContext) {
        this(theContext, new HashMap<String, IBaseResource>(), new HashMap<String, IBaseResource>(), new HashMap<String, IBaseResource>(), new HashMap<String, byte[]>());
    }

    public PrePopulatedValidationSupport(FhirContext theFhirContext, Map<String, IBaseResource> theStructureDefinitions, Map<String, IBaseResource> theValueSets, Map<String, IBaseResource> theCodeSystems) {
        this(theFhirContext, theStructureDefinitions, theValueSets, theCodeSystems, new HashMap<String, byte[]>());
    }

    public PrePopulatedValidationSupport(FhirContext theFhirContext, Map<String, IBaseResource> theStructureDefinitions, Map<String, IBaseResource> theValueSets, Map<String, IBaseResource> theCodeSystems, Map<String, byte[]> theBinaries) {
        super(theFhirContext);
        Validate.notNull((Object)theFhirContext, (String)"theFhirContext must not be null", (Object[])new Object[0]);
        Validate.notNull(theStructureDefinitions, (String)"theStructureDefinitions must not be null", (Object[])new Object[0]);
        Validate.notNull(theValueSets, (String)"theValueSets must not be null", (Object[])new Object[0]);
        Validate.notNull(theCodeSystems, (String)"theCodeSystems must not be null", (Object[])new Object[0]);
        Validate.notNull(theBinaries, (String)"theBinaries must not be null", (Object[])new Object[0]);
        this.myStructureDefinitions = theStructureDefinitions;
        this.myValueSets = theValueSets;
        this.myCodeSystems = theCodeSystems;
        this.myBinaries = theBinaries;
    }

    public void addBinary(byte[] theBinary, String theBinaryKey) {
        Validate.notNull((Object)theBinary, (String)"theBinaryKey must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theBinary, (String)("the" + theBinaryKey + " must not be null"), (Object[])new Object[0]);
        this.myBinaries.put(theBinaryKey, theBinary);
    }

    public void addCodeSystem(IBaseResource theCodeSystem) {
        Set<String> urls = this.processResourceAndReturnUrls(theCodeSystem, "CodeSystem");
        this.addToMap(theCodeSystem, this.myCodeSystems, urls);
    }

    private Set<String> processResourceAndReturnUrls(IBaseResource theResource, String theResourceName) {
        Validate.notNull((Object)theResource, (String)("the" + theResourceName + " must not be null"), (Object[])new Object[0]);
        RuntimeResourceDefinition resourceDef = this.getFhirContext().getResourceDefinition(theResource);
        String actualResourceName = resourceDef.getName();
        Validate.isTrue((boolean)actualResourceName.equals(theResourceName), (String)("the" + theResourceName + " must be a " + theResourceName + " - Got: " + actualResourceName), (Object[])new Object[0]);
        Optional urlValue = resourceDef.getChildByName("url").getAccessor().getFirstValueOrNull((IBase)theResource);
        String url = urlValue.map(t -> ((IPrimitiveType)t).getValueAsString()).orElse(null);
        Validate.notNull((Object)url, (String)("the" + theResourceName + ".getUrl() must not return null"), (Object[])new Object[0]);
        Validate.notBlank((CharSequence)url, (String)("the" + theResourceName + ".getUrl() must return a value"), (Object[])new Object[0]);
        int pipeIdx = url.indexOf(124);
        String urlWithoutVersion = pipeIdx != -1 ? url.substring(0, pipeIdx) : url;
        HashSet retVal = Sets.newHashSet((Object[])new String[]{url, urlWithoutVersion});
        Optional versionValue = resourceDef.getChildByName("version").getAccessor().getFirstValueOrNull((IBase)theResource);
        String version = versionValue.map(t -> ((IPrimitiveType)t).getValueAsString()).orElse(null);
        if (StringUtils.isNotBlank((CharSequence)version)) {
            retVal.add(urlWithoutVersion + "|" + version);
        }
        return retVal;
    }

    public void addStructureDefinition(IBaseResource theStructureDefinition) {
        Set<String> url = this.processResourceAndReturnUrls(theStructureDefinition, "StructureDefinition");
        this.addToMap(theStructureDefinition, this.myStructureDefinitions, url);
    }

    private <T extends IBaseResource> void addToMap(T theResource, Map<String, T> theMap, Collection<String> theUrls) {
        for (String urls : theUrls) {
            if (!StringUtils.isNotBlank((CharSequence)urls)) continue;
            theMap.put(urls, theResource);
            int lastSlashIdx = urls.lastIndexOf(47);
            if (lastSlashIdx == -1) continue;
            theMap.put(urls.substring(lastSlashIdx + 1), theResource);
            int previousSlashIdx = urls.lastIndexOf(47, lastSlashIdx - 1);
            if (previousSlashIdx == -1) continue;
            theMap.put(urls.substring(previousSlashIdx + 1), theResource);
        }
    }

    public void addValueSet(IBaseResource theValueSet) {
        Set<String> urls = this.processResourceAndReturnUrls(theValueSet, "ValueSet");
        this.addToMap(theValueSet, this.myValueSets, urls);
    }

    public void addResource(@Nonnull IBaseResource theResource) {
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        switch (this.getFhirContext().getResourceType(theResource)) {
            case "StructureDefinition": {
                this.addStructureDefinition(theResource);
                break;
            }
            case "CodeSystem": {
                this.addCodeSystem(theResource);
                break;
            }
            case "ValueSet": {
                this.addValueSet(theResource);
            }
        }
    }

    public List<IBaseResource> fetchAllConformanceResources() {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        retVal.addAll(this.myCodeSystems.values());
        retVal.addAll(this.myStructureDefinitions.values());
        retVal.addAll(this.myValueSets.values());
        return retVal;
    }

    public <T extends IBaseResource> List<T> fetchAllStructureDefinitions() {
        return PrePopulatedValidationSupport.toList(this.myStructureDefinitions);
    }

    public IBaseResource fetchCodeSystem(String theSystem) {
        return this.myCodeSystems.get(theSystem);
    }

    public IBaseResource fetchValueSet(String theUri) {
        return this.myValueSets.get(theUri);
    }

    public IBaseResource fetchStructureDefinition(String theUrl) {
        return this.myStructureDefinitions.get(theUrl);
    }

    public byte[] fetchBinary(String theBinaryKey) {
        return this.myBinaries.get(theBinaryKey);
    }

    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        return this.myCodeSystems.containsKey(theSystem);
    }

    public boolean isValueSetSupported(ValidationSupportContext theValidationSupportContext, String theValueSetUrl) {
        return this.myValueSets.containsKey(theValueSetUrl);
    }
}

