/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.TranslateConceptResult;
import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.support.BaseValidationSupport;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.ValueSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteTerminologyServiceValidationSupport
extends BaseValidationSupport
implements IValidationSupport {
    private static final Logger ourLog = LoggerFactory.getLogger(RemoteTerminologyServiceValidationSupport.class);
    private String myBaseUrl;
    private List<Object> myClientInterceptors = new ArrayList<Object>();

    public RemoteTerminologyServiceValidationSupport(FhirContext theFhirContext) {
        super(theFhirContext);
    }

    public RemoteTerminologyServiceValidationSupport(FhirContext theFhirContext, String theBaseUrl) {
        super(theFhirContext);
        this.myBaseUrl = theBaseUrl;
    }

    public IValidationSupport.CodeValidationResult validateCode(@Nonnull ValidationSupportContext theValidationSupportContext, @Nonnull ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        return this.invokeRemoteValidateCode(theCodeSystem, theCode, theDisplay, theValueSetUrl, null);
    }

    public IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        IBaseResource valueSet = theValueSet;
        String codeSystem = theCodeSystem;
        if (StringUtils.isNotBlank((CharSequence)theCode) && StringUtils.isBlank((CharSequence)codeSystem)) {
            codeSystem = this.extractCodeSystemForCode((ValueSet)theValueSet, theCode);
        }
        if (StringUtils.isBlank((CharSequence)codeSystem)) {
            return null;
        }
        String valueSetUrl = DefaultProfileValidationSupport.getConformanceResourceUrl((FhirContext)this.myCtx, (IBaseResource)valueSet);
        if (StringUtils.isNotBlank((CharSequence)valueSetUrl)) {
            valueSet = null;
        } else {
            valueSetUrl = null;
        }
        return this.invokeRemoteValidateCode(codeSystem, theCode, theDisplay, valueSetUrl, valueSet);
    }

    private String extractCodeSystemForCode(ValueSet theValueSet, String theCode) {
        if (theValueSet.getCompose() == null || theValueSet.getCompose().getInclude() == null || theValueSet.getCompose().getInclude().isEmpty()) {
            return null;
        }
        if (theValueSet.getCompose().getInclude().size() == 1) {
            ValueSet.ConceptSetComponent include = (ValueSet.ConceptSetComponent)theValueSet.getCompose().getInclude().iterator().next();
            return this.getVersionedCodeSystem(include);
        }
        for (ValueSet.ConceptSetComponent include : theValueSet.getCompose().getInclude()) {
            if (!include.hasSystem()) continue;
            for (ValueSet.ConceptReferenceComponent concept : include.getConcept()) {
                if (!concept.hasCodeElement() || !concept.getCode().equals(theCode)) continue;
                return this.getVersionedCodeSystem(include);
            }
        }
        ourLog.trace("CodeSystem couldn't be extracted for code: {} for ValueSet: {}", (Object)theCode, (Object)theValueSet.getId());
        return null;
    }

    private String getVersionedCodeSystem(ValueSet.ConceptSetComponent theComponent) {
        Object codeSystem = theComponent.getSystem();
        if (!((String)codeSystem).contains("|") && theComponent.hasVersion()) {
            codeSystem = (String)codeSystem + "|" + theComponent.getVersion();
        }
        return codeSystem;
    }

    public IBaseResource fetchCodeSystem(String theSystem) {
        IGenericClient client = this.provideClient();
        Class bundleType = this.myCtx.getResourceDefinition("Bundle").getImplementingClass(IBaseBundle.class);
        IBaseBundle results = (IBaseBundle)client.search().forResource("CodeSystem").where(CodeSystem.URL.matches().value(theSystem)).returnBundle(bundleType).execute();
        List resultsList = BundleUtil.toListOfResources((FhirContext)this.myCtx, (IBaseBundle)results);
        if (resultsList.size() > 0) {
            return (IBaseResource)resultsList.get(0);
        }
        return null;
    }

    public IValidationSupport.LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, String theSystem, String theCode, String theDisplayLanguage) {
        Validate.notBlank((CharSequence)theCode, (String)"theCode must be provided", (Object[])new Object[0]);
        IGenericClient client = this.provideClient();
        FhirContext fhirContext = client.getFhirContext();
        FhirVersionEnum fhirVersion = fhirContext.getVersion().getVersion();
        switch (fhirVersion) {
            case DSTU3: 
            case R4: {
                IBaseParameters params = ParametersUtil.newInstance((FhirContext)fhirContext);
                ParametersUtil.addParameterToParametersString((FhirContext)fhirContext, (IBaseParameters)params, (String)"code", (String)theCode);
                if (!StringUtils.isEmpty((CharSequence)theSystem)) {
                    ParametersUtil.addParameterToParametersString((FhirContext)fhirContext, (IBaseParameters)params, (String)"system", (String)theSystem);
                }
                if (!StringUtils.isEmpty((CharSequence)theDisplayLanguage)) {
                    ParametersUtil.addParameterToParametersString((FhirContext)fhirContext, (IBaseParameters)params, (String)"language", (String)theDisplayLanguage);
                }
                Class codeSystemClass = this.myCtx.getResourceDefinition("CodeSystem").getImplementingClass();
                IBaseParameters outcome = (IBaseParameters)((IOperationUnnamed)client.operation().onType(codeSystemClass)).named("$lookup").withParameters(params).useHttpGet().execute();
                if (outcome == null || outcome.isEmpty()) break;
                switch (fhirVersion) {
                    case DSTU3: {
                        return this.generateLookupCodeResultDSTU3(theCode, theSystem, (Parameters)outcome);
                    }
                    case R4: {
                        return this.generateLookupCodeResultR4(theCode, theSystem, (org.hl7.fhir.r4.model.Parameters)outcome);
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(Msg.code((int)710) + "Unsupported FHIR version '" + fhirVersion.getFhirVersionString() + "'. Only DSTU3 and R4 are supported.");
            }
        }
        return null;
    }

    private IValidationSupport.LookupCodeResult generateLookupCodeResultDSTU3(String theCode, String theSystem, Parameters outcomeDSTU3) {
        IValidationSupport.LookupCodeResult result = new IValidationSupport.LookupCodeResult();
        result.setSearchedForCode(theCode);
        result.setSearchedForSystem(theSystem);
        result.setFound(true);
        block26: for (Parameters.ParametersParameterComponent parameterComponent : outcomeDSTU3.getParameter()) {
            switch (parameterComponent.getName()) {
                case "property": {
                    Property part = parameterComponent.getChildByName("part");
                    if (part == null || !part.hasValues() || part.getValues().size() < 2) break;
                    String key = ((Parameters.ParametersParameterComponent)part.getValues().get(0)).getValue().toString();
                    String value = ((Parameters.ParametersParameterComponent)part.getValues().get(1)).getValue().toString();
                    if (StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)value)) continue block26;
                    result.getProperties().add(new IValidationSupport.StringConceptProperty(key, value));
                    break;
                }
                case "designation": {
                    IValidationSupport.ConceptDesignation conceptDesignation = new IValidationSupport.ConceptDesignation();
                    for (Parameters.ParametersParameterComponent designationComponent : parameterComponent.getPart()) {
                        switch (designationComponent.getName()) {
                            case "language": {
                                conceptDesignation.setLanguage(designationComponent.getValue().toString());
                                break;
                            }
                            case "use": {
                                org.hl7.fhir.dstu3.model.Coding coding = (org.hl7.fhir.dstu3.model.Coding)designationComponent.getValue();
                                if (coding == null) break;
                                conceptDesignation.setUseSystem(coding.getSystem());
                                conceptDesignation.setUseCode(coding.getCode());
                                conceptDesignation.setUseDisplay(coding.getDisplay());
                                break;
                            }
                            case "value": {
                                conceptDesignation.setValue(designationComponent.getValue() == null ? null : designationComponent.getValue().toString());
                            }
                        }
                    }
                    result.getDesignations().add(conceptDesignation);
                    break;
                }
                case "name": {
                    result.setCodeSystemDisplayName(parameterComponent.getValue() == null ? null : parameterComponent.getValue().toString());
                    break;
                }
                case "version": {
                    result.setCodeSystemVersion(parameterComponent.getValue() == null ? null : parameterComponent.getValue().toString());
                    break;
                }
                case "display": {
                    result.setCodeDisplay(parameterComponent.getValue() == null ? null : parameterComponent.getValue().toString());
                    break;
                }
                case "abstract": {
                    result.setCodeIsAbstract(parameterComponent.getValue() == null ? false : Boolean.parseBoolean(parameterComponent.getValue().toString()));
                }
            }
        }
        return result;
    }

    private IValidationSupport.LookupCodeResult generateLookupCodeResultR4(String theCode, String theSystem, org.hl7.fhir.r4.model.Parameters outcomeR4) {
        IValidationSupport.LookupCodeResult result = new IValidationSupport.LookupCodeResult();
        result.setSearchedForCode(theCode);
        result.setSearchedForSystem(theSystem);
        result.setFound(true);
        block26: for (Parameters.ParametersParameterComponent parameterComponent : outcomeR4.getParameter()) {
            switch (parameterComponent.getName()) {
                case "property": {
                    org.hl7.fhir.r4.model.Property part = parameterComponent.getChildByName("part");
                    if (part == null || !part.hasValues() || part.getValues().size() < 2) break;
                    String key = ((Parameters.ParametersParameterComponent)part.getValues().get(0)).getValue().toString();
                    String value = ((Parameters.ParametersParameterComponent)part.getValues().get(1)).getValue().toString();
                    if (StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)value)) continue block26;
                    result.getProperties().add(new IValidationSupport.StringConceptProperty(key, value));
                    break;
                }
                case "designation": {
                    IValidationSupport.ConceptDesignation conceptDesignation = new IValidationSupport.ConceptDesignation();
                    for (Parameters.ParametersParameterComponent designationComponent : parameterComponent.getPart()) {
                        switch (designationComponent.getName()) {
                            case "language": {
                                conceptDesignation.setLanguage(designationComponent.getValue().toString());
                                break;
                            }
                            case "use": {
                                Coding coding = (Coding)designationComponent.getValue();
                                if (coding == null) break;
                                conceptDesignation.setUseSystem(coding.getSystem());
                                conceptDesignation.setUseCode(coding.getCode());
                                conceptDesignation.setUseDisplay(coding.getDisplay());
                                break;
                            }
                            case "value": {
                                conceptDesignation.setValue(designationComponent.getValue() == null ? null : designationComponent.getValue().toString());
                            }
                        }
                    }
                    result.getDesignations().add(conceptDesignation);
                    break;
                }
                case "name": {
                    result.setCodeSystemDisplayName(parameterComponent.getValue() == null ? null : parameterComponent.getValue().toString());
                    break;
                }
                case "version": {
                    result.setCodeSystemVersion(parameterComponent.getValue() == null ? null : parameterComponent.getValue().toString());
                    break;
                }
                case "display": {
                    result.setCodeDisplay(parameterComponent.getValue() == null ? null : parameterComponent.getValue().toString());
                    break;
                }
                case "abstract": {
                    result.setCodeIsAbstract(parameterComponent.getValue() == null ? false : Boolean.parseBoolean(parameterComponent.getValue().toString()));
                }
            }
        }
        return result;
    }

    public IBaseResource fetchValueSet(String theValueSetUrl) {
        IGenericClient client = this.provideClient();
        Class bundleType = this.myCtx.getResourceDefinition("Bundle").getImplementingClass(IBaseBundle.class);
        IBaseBundle results = (IBaseBundle)client.search().forResource("ValueSet").where(CodeSystem.URL.matches().value(theValueSetUrl)).returnBundle(bundleType).execute();
        List resultsList = BundleUtil.toListOfResources((FhirContext)this.myCtx, (IBaseBundle)results);
        if (resultsList.size() > 0) {
            return (IBaseResource)resultsList.get(0);
        }
        return null;
    }

    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        return this.fetchCodeSystem(theSystem) != null;
    }

    public boolean isValueSetSupported(ValidationSupportContext theValidationSupportContext, String theValueSetUrl) {
        return this.fetchValueSet(theValueSetUrl) != null;
    }

    public TranslateConceptResults translateConcept(IValidationSupport.TranslateCodeRequest theRequest) {
        IGenericClient client = this.provideClient();
        FhirContext fhirContext = client.getFhirContext();
        IBaseParameters params = this.buildTranslateInputParameters(fhirContext, theRequest);
        IBaseParameters outcome = (IBaseParameters)((IOperationUnnamed)client.operation().onType("ConceptMap")).named("$translate").withParameters(params).execute();
        return this.translateOutcomeToResults(fhirContext, outcome);
    }

    private IGenericClient provideClient() {
        IGenericClient retVal = this.myCtx.newRestfulGenericClient(this.myBaseUrl);
        for (Object next : this.myClientInterceptors) {
            retVal.registerInterceptor(next);
        }
        return retVal;
    }

    protected IValidationSupport.CodeValidationResult invokeRemoteValidateCode(String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl, IBaseResource theValueSet) {
        if (StringUtils.isBlank((CharSequence)theCode)) {
            return null;
        }
        IGenericClient client = this.provideClient();
        IBaseParameters input = this.buildValidateCodeInputParameters(theCodeSystem, theCode, theDisplay, theValueSetUrl, theValueSet);
        String resourceType = "ValueSet";
        if (theValueSet == null && theValueSetUrl == null) {
            resourceType = "CodeSystem";
        }
        IBaseParameters output = (IBaseParameters)((IOperationUnnamed)client.operation().onType(resourceType)).named("validate-code").withParameters(input).execute();
        List resultValues = ParametersUtil.getNamedParameterValuesAsString((FhirContext)this.getFhirContext(), (IBaseParameters)output, (String)"result");
        if (resultValues.size() < 1 || StringUtils.isBlank((CharSequence)((CharSequence)resultValues.get(0)))) {
            return null;
        }
        Validate.isTrue((resultValues.size() == 1 ? 1 : 0) != 0, (String)"Response contained %d 'result' values", (long)resultValues.size());
        boolean success = "true".equalsIgnoreCase((String)resultValues.get(0));
        IValidationSupport.CodeValidationResult retVal = new IValidationSupport.CodeValidationResult();
        if (success) {
            retVal.setCode(theCode);
            List displayValues = ParametersUtil.getNamedParameterValuesAsString((FhirContext)this.getFhirContext(), (IBaseParameters)output, (String)"display");
            if (displayValues.size() > 0) {
                retVal.setDisplay((String)displayValues.get(0));
            }
        } else {
            retVal.setSeverity(IValidationSupport.IssueSeverity.ERROR);
            List messageValues = ParametersUtil.getNamedParameterValuesAsString((FhirContext)this.getFhirContext(), (IBaseParameters)output, (String)"message");
            if (messageValues.size() > 0) {
                retVal.setMessage((String)messageValues.get(0));
            }
        }
        return retVal;
    }

    protected IBaseParameters buildValidateCodeInputParameters(String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl, IBaseResource theValueSet) {
        IBaseParameters params = ParametersUtil.newInstance((FhirContext)this.getFhirContext());
        if (theValueSet == null && theValueSetUrl == null) {
            ParametersUtil.addParameterToParametersUri((FhirContext)this.getFhirContext(), (IBaseParameters)params, (String)"url", (String)theCodeSystem);
            ParametersUtil.addParameterToParametersString((FhirContext)this.getFhirContext(), (IBaseParameters)params, (String)"code", (String)theCode);
            if (StringUtils.isNotBlank((CharSequence)theDisplay)) {
                ParametersUtil.addParameterToParametersString((FhirContext)this.getFhirContext(), (IBaseParameters)params, (String)"display", (String)theDisplay);
            }
            return params;
        }
        if (StringUtils.isNotBlank((CharSequence)theValueSetUrl)) {
            ParametersUtil.addParameterToParametersUri((FhirContext)this.getFhirContext(), (IBaseParameters)params, (String)"url", (String)theValueSetUrl);
        }
        ParametersUtil.addParameterToParametersString((FhirContext)this.getFhirContext(), (IBaseParameters)params, (String)"code", (String)theCode);
        if (StringUtils.isNotBlank((CharSequence)theCodeSystem)) {
            ParametersUtil.addParameterToParametersUri((FhirContext)this.getFhirContext(), (IBaseParameters)params, (String)"system", (String)theCodeSystem);
        }
        if (StringUtils.isNotBlank((CharSequence)theDisplay)) {
            ParametersUtil.addParameterToParametersString((FhirContext)this.getFhirContext(), (IBaseParameters)params, (String)"display", (String)theDisplay);
        }
        if (theValueSet != null) {
            ParametersUtil.addParameterToParameters((FhirContext)this.getFhirContext(), (IBaseParameters)params, (String)"valueSet", (Object)theValueSet);
        }
        return params;
    }

    public void setBaseUrl(String theBaseUrl) {
        Validate.notBlank((CharSequence)theBaseUrl, (String)"theBaseUrl must be provided", (Object[])new Object[0]);
        this.myBaseUrl = theBaseUrl;
    }

    public void addClientInterceptor(@Nonnull Object theClientInterceptor) {
        Validate.notNull((Object)theClientInterceptor, (String)"theClientInterceptor must not be null", (Object[])new Object[0]);
        this.myClientInterceptors.add(theClientInterceptor);
    }

    private IBaseParameters buildTranslateInputParameters(FhirContext fhirContext, IValidationSupport.TranslateCodeRequest theRequest) {
        IBaseParameters params = ParametersUtil.newInstance((FhirContext)fhirContext);
        if (!StringUtils.isEmpty((CharSequence)theRequest.getConceptMapUrl())) {
            ParametersUtil.addParameterToParametersUri((FhirContext)fhirContext, (IBaseParameters)params, (String)"url", (String)theRequest.getConceptMapUrl());
        }
        if (!StringUtils.isEmpty((CharSequence)theRequest.getConceptMapVersion())) {
            ParametersUtil.addParameterToParametersString((FhirContext)fhirContext, (IBaseParameters)params, (String)"conceptMapVersion", (String)theRequest.getConceptMapVersion());
        }
        if (theRequest.getCodings() != null) {
            this.addCodingsToTranslateParameters(fhirContext, theRequest.getCodings(), params);
        }
        if (!StringUtils.isEmpty((CharSequence)theRequest.getSourceValueSetUrl())) {
            ParametersUtil.addParameterToParametersUri((FhirContext)fhirContext, (IBaseParameters)params, (String)"source", (String)theRequest.getSourceValueSetUrl());
        }
        if (!StringUtils.isEmpty((CharSequence)theRequest.getTargetValueSetUrl())) {
            ParametersUtil.addParameterToParametersUri((FhirContext)fhirContext, (IBaseParameters)params, (String)"target", (String)theRequest.getTargetValueSetUrl());
        }
        if (!StringUtils.isEmpty((CharSequence)theRequest.getTargetSystemUrl())) {
            ParametersUtil.addParameterToParametersUri((FhirContext)fhirContext, (IBaseParameters)params, (String)"targetsystem", (String)theRequest.getTargetSystemUrl());
        }
        if (theRequest.isReverse()) {
            ParametersUtil.addParameterToParametersBoolean((FhirContext)fhirContext, (IBaseParameters)params, (String)"reverse", (boolean)theRequest.isReverse());
        }
        return params;
    }

    private void addCodingsToTranslateParameters(FhirContext fhirContext, List<IBaseCoding> theCodings, IBaseParameters theParams) {
        BaseRuntimeElementCompositeDefinition codeableConceptDef = (BaseRuntimeElementCompositeDefinition)Objects.requireNonNull(fhirContext.getElementDefinition("CodeableConcept"));
        BaseRuntimeChildDefinition codings = codeableConceptDef.getChildByName("coding");
        BaseRuntimeElementCompositeDefinition codingDef = (BaseRuntimeElementCompositeDefinition)Objects.requireNonNull(fhirContext.getElementDefinition("Coding"));
        BaseRuntimeChildDefinition codingSystemChild = codingDef.getChildByName("system");
        BaseRuntimeChildDefinition codingCodeChild = codingDef.getChildByName("code");
        RuntimePrimitiveDatatypeDefinition systemDef = (RuntimePrimitiveDatatypeDefinition)fhirContext.getElementDefinition("uri");
        RuntimePrimitiveDatatypeDefinition codeDef = (RuntimePrimitiveDatatypeDefinition)fhirContext.getElementDefinition("code");
        IBase codeableConcept = codeableConceptDef.newInstance();
        for (IBaseCoding aCoding : theCodings) {
            IBaseCoding newCoding = (IBaseCoding)codingDef.newInstance();
            IPrimitiveType newSystem = (IPrimitiveType)systemDef.newInstance((Object)aCoding.getSystem());
            codingSystemChild.getMutator().addValue((IBase)newCoding, (IBase)newSystem);
            IPrimitiveType newCode = (IPrimitiveType)codeDef.newInstance((Object)aCoding.getCode());
            codingCodeChild.getMutator().addValue((IBase)newCoding, (IBase)newCode);
            codings.getMutator().addValue(codeableConcept, (IBase)newCoding);
        }
        ParametersUtil.addParameterToParameters((FhirContext)fhirContext, (IBaseParameters)theParams, (String)"codeableConcept", (Object)codeableConcept);
    }

    private TranslateConceptResults translateOutcomeToResults(FhirContext fhirContext, IBaseParameters outcome) {
        Optional result = ParametersUtil.getNamedParameterValueAsString((FhirContext)fhirContext, (IBaseParameters)outcome, (String)"result");
        Optional message = ParametersUtil.getNamedParameterValueAsString((FhirContext)fhirContext, (IBaseParameters)outcome, (String)"message");
        List matches = ParametersUtil.getNamedParameters((FhirContext)fhirContext, (IBaseResource)outcome, (String)"match");
        TranslateConceptResults retVal = new TranslateConceptResults();
        if (result.isPresent()) {
            retVal.setResult(Boolean.parseBoolean((String)result.get()));
        }
        if (message.isPresent()) {
            retVal.setMessage((String)message.get());
        }
        if (!matches.isEmpty()) {
            retVal.setResults(this.matchesToTranslateConceptResults(fhirContext, matches));
        }
        return retVal;
    }

    private List<TranslateConceptResult> matchesToTranslateConceptResults(FhirContext fhirContext, List<IBase> theMatches) {
        ArrayList<TranslateConceptResult> resultList = new ArrayList<TranslateConceptResult>();
        for (IBase m : theMatches) {
            TranslateConceptResult match = new TranslateConceptResult();
            String equivalence = ParametersUtil.getParameterPartValueAsString((FhirContext)fhirContext, (IBase)m, (String)"equivalence");
            Optional concept = ParametersUtil.getParameterPartValue((FhirContext)fhirContext, (IBase)m, (String)"concept");
            String source = ParametersUtil.getParameterPartValueAsString((FhirContext)fhirContext, (IBase)m, (String)"source");
            if (StringUtils.isNotBlank((CharSequence)equivalence)) {
                match.setEquivalence(equivalence);
            }
            if (!concept.isPresent()) continue;
            IBaseCoding matchedCoding = (IBaseCoding)concept.get();
            match.setSystem(matchedCoding.getSystem());
            match.setCode(matchedCoding.getCode());
            match.setDisplay(matchedCoding.getDisplay());
            if (StringUtils.isNotBlank((CharSequence)source)) {
                match.setConceptMapUrl(source);
            }
            resultList.add(match);
        }
        return resultList;
    }
}

