/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.jpa.search.reindex.BlockPolicy;
import java.util.concurrent.RejectedExecutionHandler;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public final class ThreadPoolUtil {
    private ThreadPoolUtil() {
    }

    @Nonnull
    public static ThreadPoolTaskExecutor newThreadPool(int theCorePoolSize, int theMaxPoolSize, String theThreadNamePrefix) {
        Validate.isTrue((boolean)theThreadNamePrefix.endsWith("-"), (String)"Thread pool prefix name must end with a hyphen", (Object[])new Object[0]);
        ThreadPoolTaskExecutor asyncTaskExecutor = new ThreadPoolTaskExecutor();
        asyncTaskExecutor.setCorePoolSize(theCorePoolSize);
        asyncTaskExecutor.setMaxPoolSize(theMaxPoolSize);
        asyncTaskExecutor.setQueueCapacity(0);
        asyncTaskExecutor.setAllowCoreThreadTimeOut(true);
        asyncTaskExecutor.setThreadNamePrefix(theThreadNamePrefix);
        asyncTaskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new BlockPolicy());
        asyncTaskExecutor.initialize();
        return asyncTaskExecutor;
    }
}

