/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.jpa.api.model.BulkExportParameters;
import ca.uhn.fhir.rest.api.server.bulk.BulkDataExportOptions;
import java.util.ArrayList;

public class BulkExportUtils {
    private BulkExportUtils() {
    }

    public static BulkExportParameters createBulkExportJobParametersFromExportOptions(BulkDataExportOptions theOptions) {
        BulkExportParameters parameters = new BulkExportParameters("BULK_EXPORT");
        parameters.setStartDate(theOptions.getSince());
        parameters.setOutputFormat(theOptions.getOutputFormat());
        parameters.setExportStyle(theOptions.getExportStyle());
        if (theOptions.getFilters() != null) {
            parameters.setFilters(new ArrayList<String>(theOptions.getFilters()));
        }
        if (theOptions.getGroupId() != null) {
            parameters.setGroupId(theOptions.getGroupId().getValue());
        }
        if (theOptions.getResourceTypes() != null) {
            parameters.setResourceTypes(new ArrayList<String>(theOptions.getResourceTypes()));
        }
        parameters.setExpandMdm(theOptions.isExpandMdm());
        return parameters;
    }
}

